# UpdateProjectResponseBody

The project was successfully updated

## Example Usage

```typescript
import { UpdateProjectResponseBody } from "@vercel/sdk/models/operations/updateproject.js";

let value: UpdateProjectResponseBody = {
  accountId: "<id>",
  crons: {
    enabledAt: 2201.04,
    disabledAt: 6228.94,
    updatedAt: 1114.96,
    deploymentId: "<id>",
    definitions: [
      {
        host: "vercel.com",
        path: "/api/crons/sync-something?hello=world",
        schedule: "0 0 * * *",
      },
    ],
  },
  directoryListing: false,
  id: "<id>",
  latestDeployments: [
    {
      id: "<id>",
      createdAt: 4589.70,
      createdIn: "<value>",
      creator: {
        email: "Emil87@gmail.com",
        uid: "<id>",
        username: "Charles_Lakin",
      },
      deploymentHostname: "<value>",
      name: "<value>",
      plan: "pro",
      previewCommentsEnabled: false,
      private: false,
      readyState: "ERROR",
      type: "LAMBDAS",
      url: "https://utilized-shark.net",
      userId: "<id>",
    },
  ],
  name: "<value>",
  nodeVersion: "14.x",
  targets: {
    "key": {
      id: "<id>",
      createdAt: 9222.99,
      createdIn: "<value>",
      creator: {
        email: "Scot_Emard1@yahoo.com",
        uid: "<id>",
        username: "Daphnee51",
      },
      deploymentHostname: "<value>",
      name: "<value>",
      plan: "pro",
      previewCommentsEnabled: false,
      private: false,
      readyState: "READY",
      type: "LAMBDAS",
      url: "https://adolescent-interchange.net",
      userId: "<id>",
    },
  },
};
```

## Fields

| Field                                                                                                                | Type                                                                                                                 | Required                                                                                                             | Description                                                                                                          |
| -------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| `accountId`                                                                                                          | *string*                                                                                                             | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `analytics`                                                                                                          | [operations.UpdateProjectAnalytics](../../models/operations/updateprojectanalytics.md)                               | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `speedInsights`                                                                                                      | [operations.UpdateProjectSpeedInsights](../../models/operations/updateprojectspeedinsights.md)                       | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `autoExposeSystemEnvs`                                                                                               | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `autoAssignCustomDomains`                                                                                            | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `autoAssignCustomDomainsUpdatedBy`                                                                                   | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `buildCommand`                                                                                                       | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `commandForIgnoringBuildStep`                                                                                        | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `connectConfigurationId`                                                                                             | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `connectBuildsEnabled`                                                                                               | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `createdAt`                                                                                                          | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `customerSupportCodeVisibility`                                                                                      | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `crons`                                                                                                              | [operations.UpdateProjectCrons](../../models/operations/updateprojectcrons.md)                                       | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `dataCache`                                                                                                          | [operations.UpdateProjectDataCache](../../models/operations/updateprojectdatacache.md)                               | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `deploymentExpiration`                                                                                               | [operations.UpdateProjectDeploymentExpiration](../../models/operations/updateprojectdeploymentexpiration.md)         | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `devCommand`                                                                                                         | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `directoryListing`                                                                                                   | *boolean*                                                                                                            | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `installCommand`                                                                                                     | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `env`                                                                                                                | [operations.UpdateProjectEnv](../../models/operations/updateprojectenv.md)[]                                         | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `customEnvironments`                                                                                                 | [operations.UpdateProjectCustomEnvironments](../../models/operations/updateprojectcustomenvironments.md)[]           | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `framework`                                                                                                          | [operations.UpdateProjectProjectsFramework](../../models/operations/updateprojectprojectsframework.md)               | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `gitForkProtection`                                                                                                  | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `gitLFS`                                                                                                             | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `id`                                                                                                                 | *string*                                                                                                             | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `ipBuckets`                                                                                                          | [operations.UpdateProjectIpBuckets](../../models/operations/updateprojectipbuckets.md)[]                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `latestDeployments`                                                                                                  | [operations.UpdateProjectLatestDeployments](../../models/operations/updateprojectlatestdeployments.md)[]             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `link`                                                                                                               | *operations.UpdateProjectLink*                                                                                       | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `microfrontends`                                                                                                     | [operations.UpdateProjectMicrofrontends](../../models/operations/updateprojectmicrofrontends.md)                     | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `name`                                                                                                               | *string*                                                                                                             | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `nodeVersion`                                                                                                        | [operations.UpdateProjectProjectsNodeVersion](../../models/operations/updateprojectprojectsnodeversion.md)           | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `optionsAllowlist`                                                                                                   | [operations.UpdateProjectOptionsAllowlist](../../models/operations/updateprojectoptionsallowlist.md)                 | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `outputDirectory`                                                                                                    | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `passiveConnectConfigurationId`                                                                                      | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `passwordProtection`                                                                                                 | [operations.UpdateProjectPasswordProtection](../../models/operations/updateprojectpasswordprotection.md)             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `productionDeploymentsFastLane`                                                                                      | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `publicSource`                                                                                                       | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `resourceConfig`                                                                                                     | [operations.UpdateProjectResourceConfig](../../models/operations/updateprojectresourceconfig.md)                     | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `rootDirectory`                                                                                                      | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `serverlessFunctionRegion`                                                                                           | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `serverlessFunctionZeroConfigFailover`                                                                               | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `skewProtectionBoundaryAt`                                                                                           | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `skewProtectionMaxAge`                                                                                               | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `skipGitConnectDuringLink`                                                                                           | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `sourceFilesOutsideRootDirectory`                                                                                    | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `enableAffectedProjectsDeployments`                                                                                  | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `ssoProtection`                                                                                                      | [operations.UpdateProjectSsoProtection](../../models/operations/updateprojectssoprotection.md)                       | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `targets`                                                                                                            | Record<string, [operations.UpdateProjectTargets](../../models/operations/updateprojecttargets.md)>                   | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `transferCompletedAt`                                                                                                | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `transferStartedAt`                                                                                                  | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `transferToAccountId`                                                                                                | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `transferredFromAccountId`                                                                                           | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `updatedAt`                                                                                                          | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `live`                                                                                                               | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `enablePreviewFeedback`                                                                                              | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `enableProductionFeedback`                                                                                           | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `permissions`                                                                                                        | [operations.UpdateProjectPermissions](../../models/operations/updateprojectpermissions.md)                           | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `lastRollbackTarget`                                                                                                 | [operations.UpdateProjectLastRollbackTarget](../../models/operations/updateprojectlastrollbacktarget.md)             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `lastAliasRequest`                                                                                                   | [operations.UpdateProjectLastAliasRequest](../../models/operations/updateprojectlastaliasrequest.md)                 | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `hasFloatingAliases`                                                                                                 | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `protectionBypass`                                                                                                   | Record<string, [operations.UpdateProjectProtectionBypass](../../models/operations/updateprojectprotectionbypass.md)> | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `hasActiveBranches`                                                                                                  | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `trustedIps`                                                                                                         | *operations.UpdateProjectTrustedIps*                                                                                 | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `gitComments`                                                                                                        | [operations.UpdateProjectGitComments](../../models/operations/updateprojectgitcomments.md)                           | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `paused`                                                                                                             | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `concurrencyBucketName`                                                                                              | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `webAnalytics`                                                                                                       | [operations.UpdateProjectWebAnalytics](../../models/operations/updateprojectwebanalytics.md)                         | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `security`                                                                                                           | [operations.UpdateProjectSecurity](../../models/operations/updateprojectsecurity.md)                                 | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `oidcTokenConfig`                                                                                                    | [operations.UpdateProjectProjectsOidcTokenConfig](../../models/operations/updateprojectprojectsoidctokenconfig.md)   | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `tier`                                                                                                               | [operations.UpdateProjectTier](../../models/operations/updateprojecttier.md)                                         | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |