# UpdateProjectRequestBody

## Example Usage

```typescript
import { UpdateProjectRequestBody } from "@vercel/sdk/models/operations/updateproject.js";

let value: UpdateProjectRequestBody = {
  name: "a-project-name",
};
```

## Fields

| Field                                                                                                                                                                                                               | Type                                                                                                                                                                                                                | Required                                                                                                                                                                                                            | Description                                                                                                                                                                                                         | Example                                                                                                                                                                                                             |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `autoExposeSystemEnvs`                                                                                                                                                                                              | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | N/A                                                                                                                                                                                                                 |                                                                                                                                                                                                                     |
| `autoAssignCustomDomains`                                                                                                                                                                                           | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | N/A                                                                                                                                                                                                                 |                                                                                                                                                                                                                     |
| `autoAssignCustomDomainsUpdatedBy`                                                                                                                                                                                  | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | N/A                                                                                                                                                                                                                 |                                                                                                                                                                                                                     |
| `buildCommand`                                                                                                                                                                                                      | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The build command for this project. When `null` is used this value will be automatically detected                                                                                                                   |                                                                                                                                                                                                                     |
| `commandForIgnoringBuildStep`                                                                                                                                                                                       | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | N/A                                                                                                                                                                                                                 |                                                                                                                                                                                                                     |
| `customerSupportCodeVisibility`                                                                                                                                                                                     | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Specifies whether customer support can see git source for a deployment                                                                                                                                              |                                                                                                                                                                                                                     |
| `devCommand`                                                                                                                                                                                                        | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The dev command for this project. When `null` is used this value will be automatically detected                                                                                                                     |                                                                                                                                                                                                                     |
| `directoryListing`                                                                                                                                                                                                  | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | N/A                                                                                                                                                                                                                 |                                                                                                                                                                                                                     |
| `framework`                                                                                                                                                                                                         | [operations.UpdateProjectFramework](../../models/operations/updateprojectframework.md)                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                  | The framework that is being used for this project. When `null` is used no framework is selected                                                                                                                     |                                                                                                                                                                                                                     |
| `gitForkProtection`                                                                                                                                                                                                 | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Specifies whether PRs from Git forks should require a team member's authorization before it can be deployed                                                                                                         |                                                                                                                                                                                                                     |
| `gitLFS`                                                                                                                                                                                                            | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Specifies whether Git LFS is enabled for this project.                                                                                                                                                              |                                                                                                                                                                                                                     |
| `installCommand`                                                                                                                                                                                                    | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The install command for this project. When `null` is used this value will be automatically detected                                                                                                                 |                                                                                                                                                                                                                     |
| `name`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The desired name for the project                                                                                                                                                                                    | a-project-name                                                                                                                                                                                                      |
| `nodeVersion`                                                                                                                                                                                                       | [operations.UpdateProjectNodeVersion](../../models/operations/updateprojectnodeversion.md)                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                  | N/A                                                                                                                                                                                                                 |                                                                                                                                                                                                                     |
| `outputDirectory`                                                                                                                                                                                                   | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The output directory of the project. When `null` is used this value will be automatically detected                                                                                                                  |                                                                                                                                                                                                                     |
| `previewDeploymentsDisabled`                                                                                                                                                                                        | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Specifies whether preview deployments are disabled for this project.                                                                                                                                                |                                                                                                                                                                                                                     |
| `publicSource`                                                                                                                                                                                                      | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Specifies whether the source code and logs of the deployments for this project should be public or not                                                                                                              |                                                                                                                                                                                                                     |
| `rootDirectory`                                                                                                                                                                                                     | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The name of a directory or relative path to the source code of your project. When `null` is used it will default to the project root                                                                                |                                                                                                                                                                                                                     |
| `serverlessFunctionRegion`                                                                                                                                                                                          | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The region to deploy Serverless Functions in this project                                                                                                                                                           |                                                                                                                                                                                                                     |
| `serverlessFunctionZeroConfigFailover`                                                                                                                                                                              | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Specifies whether Zero Config Failover is enabled for this project.                                                                                                                                                 |                                                                                                                                                                                                                     |
| `skewProtectionBoundaryAt`                                                                                                                                                                                          | *number*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | Deployments created before this absolute datetime have Skew Protection disabled. Value is in milliseconds since epoch to match \"createdAt\" fields.                                                                |                                                                                                                                                                                                                     |
| `skewProtectionMaxAge`                                                                                                                                                                                              | *number*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | Deployments created before this rolling window have Skew Protection disabled. Value is in seconds to match \"revalidate\" fields.                                                                                   |                                                                                                                                                                                                                     |
| ~~`skipGitConnectDuringLink`~~                                                                                                                                                                                      | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | : warning: ** DEPRECATED **: This will be removed in a future release, please migrate away from it as soon as possible.<br/><br/>Opts-out of the message prompting a CLI user to connect a Git repository in `vercel link`. |                                                                                                                                                                                                                     |
| `sourceFilesOutsideRootDirectory`                                                                                                                                                                                   | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Indicates if there are source files outside of the root directory                                                                                                                                                   |                                                                                                                                                                                                                     |
| `enablePreviewFeedback`                                                                                                                                                                                             | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Opt-in to preview toolbar on the project level                                                                                                                                                                      |                                                                                                                                                                                                                     |
| `enableProductionFeedback`                                                                                                                                                                                          | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Opt-in to production toolbar on the project level                                                                                                                                                                   |                                                                                                                                                                                                                     |
| `enableAffectedProjectsDeployments`                                                                                                                                                                                 | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Opt-in to skip deployments when there are no changes to the root directory and its dependencies                                                                                                                     |                                                                                                                                                                                                                     |
| `oidcTokenConfig`                                                                                                                                                                                                   | [operations.UpdateProjectOidcTokenConfig](../../models/operations/updateprojectoidctokenconfig.md)                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                  | OpenID Connect JSON Web Token generation configuration.                                                                                                                                                             |                                                                                                                                                                                                                     |
| `passwordProtection`                                                                                                                                                                                                | [operations.PasswordProtection](../../models/operations/passwordprotection.md)                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                  | Allows to protect project deployments with a password                                                                                                                                                               |                                                                                                                                                                                                                     |
| `ssoProtection`                                                                                                                                                                                                     | [operations.SsoProtection](../../models/operations/ssoprotection.md)                                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                                  | Ensures visitors to your Preview Deployments are logged into Vercel and have a minimum of Viewer access on your team                                                                                                |                                                                                                                                                                                                                     |
| `trustedIps`                                                                                                                                                                                                        | [operations.TrustedIps](../../models/operations/trustedips.md)                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                  | Restricts access to deployments based on the incoming request IP address                                                                                                                                            |                                                                                                                                                                                                                     |
| `optionsAllowlist`                                                                                                                                                                                                  | [operations.OptionsAllowlist](../../models/operations/optionsallowlist.md)                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                  | Specify a list of paths that should not be protected by Deployment Protection to enable Cors preflight requests                                                                                                     |                                                                                                                                                                                                                     |