# UpdateProjectDataCacheResponseBody

## Example Usage

```typescript
import { UpdateProjectDataCacheResponseBody } from "@vercel/sdk/models/operations/updateprojectdatacache.js";

let value: UpdateProjectDataCacheResponseBody = {
  accountId: "<id>",
  crons: {
    enabledAt: 7992.03,
    disabledAt: 6304.48,
    updatedAt: 8742.88,
    deploymentId: "<id>",
    definitions: [
      {
        host: "vercel.com",
        path: "/api/crons/sync-something?hello=world",
        schedule: "0 0 * * *",
      },
    ],
  },
  directoryListing: false,
  id: "<id>",
  latestDeployments: [
    {
      id: "<id>",
      createdAt: 2930.20,
      createdIn: "<value>",
      creator: {
        email: "Liam.Heidenreich@hotmail.com",
        uid: "<id>",
        username: "Jess.Hills82",
      },
      deploymentHostname: "<value>",
      name: "<value>",
      plan: "enterprise",
      previewCommentsEnabled: false,
      private: false,
      readyState: "ERROR",
      type: "LAMBDAS",
      url: "https://tough-vol.org/",
      userId: "<id>",
    },
  ],
  name: "<value>",
  nodeVersion: "8.10.x",
  targets: {
    "key": {
      id: "<id>",
      createdAt: 7740.47,
      createdIn: "<value>",
      creator: {
        email: "Armando5@gmail.com",
        uid: "<id>",
        username: "Aditya8",
      },
      deploymentHostname: "<value>",
      name: "<value>",
      plan: "pro",
      previewCommentsEnabled: false,
      private: false,
      readyState: "INITIALIZING",
      type: "LAMBDAS",
      url: "https://torn-railway.biz",
      userId: "<id>",
    },
  },
};
```

## Fields

| Field                                                                                                                      | Type                                                                                                                       | Required                                                                                                                   | Description                                                                                                                |
| -------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------- |
| `accountId`                                                                                                                | *string*                                                                                                                   | :heavy_check_mark:                                                                                                         | N/A                                                                                                                        |
| `analytics`                                                                                                                | [operations.Analytics](../../models/operations/analytics.md)                                                               | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `speedInsights`                                                                                                            | [operations.SpeedInsights](../../models/operations/speedinsights.md)                                                       | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `autoExposeSystemEnvs`                                                                                                     | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `autoAssignCustomDomains`                                                                                                  | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `autoAssignCustomDomainsUpdatedBy`                                                                                         | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `buildCommand`                                                                                                             | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `commandForIgnoringBuildStep`                                                                                              | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `connectConfigurationId`                                                                                                   | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `connectBuildsEnabled`                                                                                                     | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `createdAt`                                                                                                                | *number*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `customerSupportCodeVisibility`                                                                                            | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `crons`                                                                                                                    | [operations.Crons](../../models/operations/crons.md)                                                                       | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `dataCache`                                                                                                                | [operations.DataCache](../../models/operations/datacache.md)                                                               | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `deploymentExpiration`                                                                                                     | [operations.DeploymentExpiration](../../models/operations/deploymentexpiration.md)                                         | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `devCommand`                                                                                                               | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `directoryListing`                                                                                                         | *boolean*                                                                                                                  | :heavy_check_mark:                                                                                                         | N/A                                                                                                                        |
| `installCommand`                                                                                                           | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `env`                                                                                                                      | [operations.Env](../../models/operations/env.md)[]                                                                         | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `customEnvironments`                                                                                                       | [operations.CustomEnvironments](../../models/operations/customenvironments.md)[]                                           | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `framework`                                                                                                                | [operations.UpdateProjectDataCacheFramework](../../models/operations/updateprojectdatacacheframework.md)                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `gitForkProtection`                                                                                                        | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `gitLFS`                                                                                                                   | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `id`                                                                                                                       | *string*                                                                                                                   | :heavy_check_mark:                                                                                                         | N/A                                                                                                                        |
| `ipBuckets`                                                                                                                | [operations.IpBuckets](../../models/operations/ipbuckets.md)[]                                                             | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `latestDeployments`                                                                                                        | [operations.LatestDeployments](../../models/operations/latestdeployments.md)[]                                             | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `link`                                                                                                                     | *operations.Link*                                                                                                          | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `microfrontends`                                                                                                           | [operations.Microfrontends](../../models/operations/microfrontends.md)                                                     | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `name`                                                                                                                     | *string*                                                                                                                   | :heavy_check_mark:                                                                                                         | N/A                                                                                                                        |
| `nodeVersion`                                                                                                              | [operations.UpdateProjectDataCacheNodeVersion](../../models/operations/updateprojectdatacachenodeversion.md)               | :heavy_check_mark:                                                                                                         | N/A                                                                                                                        |
| `optionsAllowlist`                                                                                                         | [operations.UpdateProjectDataCacheOptionsAllowlist](../../models/operations/updateprojectdatacacheoptionsallowlist.md)     | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `outputDirectory`                                                                                                          | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `passiveConnectConfigurationId`                                                                                            | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `passwordProtection`                                                                                                       | [operations.UpdateProjectDataCachePasswordProtection](../../models/operations/updateprojectdatacachepasswordprotection.md) | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `productionDeploymentsFastLane`                                                                                            | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `publicSource`                                                                                                             | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `resourceConfig`                                                                                                           | [operations.ResourceConfig](../../models/operations/resourceconfig.md)                                                     | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `rootDirectory`                                                                                                            | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `serverlessFunctionRegion`                                                                                                 | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `serverlessFunctionZeroConfigFailover`                                                                                     | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `skewProtectionBoundaryAt`                                                                                                 | *number*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `skewProtectionMaxAge`                                                                                                     | *number*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `skipGitConnectDuringLink`                                                                                                 | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `sourceFilesOutsideRootDirectory`                                                                                          | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `enableAffectedProjectsDeployments`                                                                                        | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `ssoProtection`                                                                                                            | [operations.UpdateProjectDataCacheSsoProtection](../../models/operations/updateprojectdatacachessoprotection.md)           | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `targets`                                                                                                                  | Record<string, [operations.Targets](../../models/operations/targets.md)>                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `transferCompletedAt`                                                                                                      | *number*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `transferStartedAt`                                                                                                        | *number*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `transferToAccountId`                                                                                                      | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `transferredFromAccountId`                                                                                                 | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `updatedAt`                                                                                                                | *number*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `live`                                                                                                                     | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `enablePreviewFeedback`                                                                                                    | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `enableProductionFeedback`                                                                                                 | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `permissions`                                                                                                              | [operations.Permissions](../../models/operations/permissions.md)                                                           | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `lastRollbackTarget`                                                                                                       | [operations.LastRollbackTarget](../../models/operations/lastrollbacktarget.md)                                             | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `lastAliasRequest`                                                                                                         | [operations.LastAliasRequest](../../models/operations/lastaliasrequest.md)                                                 | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `hasFloatingAliases`                                                                                                       | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `protectionBypass`                                                                                                         | Record<string, [operations.ProtectionBypass](../../models/operations/protectionbypass.md)>                                 | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `hasActiveBranches`                                                                                                        | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `trustedIps`                                                                                                               | *operations.UpdateProjectDataCacheTrustedIps*                                                                              | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `gitComments`                                                                                                              | [operations.GitComments](../../models/operations/gitcomments.md)                                                           | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `paused`                                                                                                                   | *boolean*                                                                                                                  | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `concurrencyBucketName`                                                                                                    | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `webAnalytics`                                                                                                             | [operations.WebAnalytics](../../models/operations/webanalytics.md)                                                         | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `security`                                                                                                                 | [operations.Security](../../models/operations/security.md)                                                                 | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `oidcTokenConfig`                                                                                                          | [operations.UpdateProjectDataCacheOidcTokenConfig](../../models/operations/updateprojectdatacacheoidctokenconfig.md)       | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |
| `tier`                                                                                                                     | [operations.Tier](../../models/operations/tier.md)                                                                         | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |