# TrustedIps

Restricts access to deployments based on the incoming request IP address

## Example Usage

```typescript
import { TrustedIps } from "@vercel/sdk/models/operations/updateproject.js";

let value: TrustedIps = {
  deploymentType: "all",
  addresses: [
    {
      value: "<value>",
    },
  ],
  protectionMode: "exclusive",
};
```

## Fields

| Field                                                                                                                                                                                                                                                                   | Type                                                                                                                                                                                                                                                                    | Required                                                                                                                                                                                                                                                                | Description                                                                                                                                                                                                                                                             |
| ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `deploymentType`                                                                                                                                                                                                                                                        | [operations.UpdateProjectProjectsDeploymentType](../../models/operations/updateprojectprojectsdeploymenttype.md)                                                                                                                                                        | :heavy_check_mark:                                                                                                                                                                                                                                                      | Specify if the Trusted IPs will apply to every Deployment Target or just Preview                                                                                                                                                                                        |
| `addresses`                                                                                                                                                                                                                                                             | [operations.Addresses](../../models/operations/addresses.md)[]                                                                                                                                                                                                          | :heavy_check_mark:                                                                                                                                                                                                                                                      | N/A                                                                                                                                                                                                                                                                     |
| `protectionMode`                                                                                                                                                                                                                                                        | [operations.ProtectionMode](../../models/operations/protectionmode.md)                                                                                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                                                                                      | exclusive: ip match is enough to bypass deployment protection (regardless of other settings). additional: ip must match + any other protection should be also provided (password, vercel auth, shareable link, automation bypass header, automation bypass query param) |