# RequestBody

## Example Usage

```typescript
import { RequestBody } from "@vercel/sdk/models/operations/recordevents.js";

let value: RequestBody = {
  sessionId: "<id>",
  source: "LOCAL",
  event: "MISS",
  hash: "12HKQaOmR5t5Uy6vdcQsNIiZgHGB",
  duration: 400,
};
```

## Fields

| Field                                                                                                                                                                    | Type                                                                                                                                                                     | Required                                                                                                                                                                 | Description                                                                                                                                                              | Example                                                                                                                                                                  |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `sessionId`                                                                                                                                                              | *string*                                                                                                                                                                 | :heavy_check_mark:                                                                                                                                                       | A UUID (universally unique identifer) for the session that generated this event.                                                                                         |                                                                                                                                                                          |
| `source`                                                                                                                                                                 | [operations.Source](../../models/operations/source.md)                                                                                                                   | :heavy_check_mark:                                                                                                                                                       | One of `LOCAL` or `REMOTE`. `LOCAL` specifies that the cache event was from the user's filesystem cache. `REMOTE` specifies that the cache event is from a remote cache. |                                                                                                                                                                          |
| `event`                                                                                                                                                                  | [operations.Event](../../models/operations/event.md)                                                                                                                     | :heavy_check_mark:                                                                                                                                                       | One of `HIT` or `MISS`. `HIT` specifies that a cached artifact for `hash` was found in the cache. `MISS` specifies that a cached artifact with `hash` was not found.     |                                                                                                                                                                          |
| `hash`                                                                                                                                                                   | *string*                                                                                                                                                                 | :heavy_check_mark:                                                                                                                                                       | The artifact hash                                                                                                                                                        | 12HKQaOmR5t5Uy6vdcQsNIiZgHGB                                                                                                                                             |
| `duration`                                                                                                                                                               | *number*                                                                                                                                                                 | :heavy_minus_sign:                                                                                                                                                       | The time taken to generate the artifact. This should be sent as a body parameter on `HIT` events.                                                                        | 400                                                                                                                                                                      |