# ProjectSettings

Project settings that will be applied to the deployment. It is required for the first deployment of a project and will be saved for any following deployments

## Example Usage

```typescript
import { ProjectSettings } from "@vercel/sdk/models/operations/createdeployment.js";

let value: ProjectSettings = {};
```

## Fields

| Field                                                                                                                                                                                                               | Type                                                                                                                                                                                                                | Required                                                                                                                                                                                                            | Description                                                                                                                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `buildCommand`                                                                                                                                                                                                      | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The build command for this project. When `null` is used this value will be automatically detected                                                                                                                   |
| `commandForIgnoringBuildStep`                                                                                                                                                                                       | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | N/A                                                                                                                                                                                                                 |
| `devCommand`                                                                                                                                                                                                        | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The dev command for this project. When `null` is used this value will be automatically detected                                                                                                                     |
| `framework`                                                                                                                                                                                                         | [operations.Framework](../../models/operations/framework.md)                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                                  | The framework that is being used for this project. When `null` is used no framework is selected                                                                                                                     |
| `installCommand`                                                                                                                                                                                                    | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The install command for this project. When `null` is used this value will be automatically detected                                                                                                                 |
| `nodeVersion`                                                                                                                                                                                                       | [operations.NodeVersion](../../models/operations/nodeversion.md)                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                  | Override the Node.js version that should be used for this deployment                                                                                                                                                |
| `outputDirectory`                                                                                                                                                                                                   | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The output directory of the project. When `null` is used this value will be automatically detected                                                                                                                  |
| `rootDirectory`                                                                                                                                                                                                     | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The name of a directory or relative path to the source code of your project. When `null` is used it will default to the project root                                                                                |
| `serverlessFunctionRegion`                                                                                                                                                                                          | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The region to deploy Serverless Functions in this project                                                                                                                                                           |
| ~~`skipGitConnectDuringLink`~~                                                                                                                                                                                      | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | : warning: ** DEPRECATED **: This will be removed in a future release, please migrate away from it as soon as possible.<br/><br/>Opts-out of the message prompting a CLI user to connect a Git repository in `vercel link`. |
| `sourceFilesOutsideRootDirectory`                                                                                                                                                                                   | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Indicates if there are source files outside of the root directory, typically used for monorepos                                                                                                                     |