# ListUserEventsRequest

## Example Usage

```typescript
import { ListUserEventsRequest } from "@vercel/sdk/models/operations/listuserevents.js";

let value: ListUserEventsRequest = {
  limit: 20,
  since: "2019-12-08T10:00:38.976Z",
  until: "2019-12-09T23:00:38.976Z",
  types: "login,team-member-join,domain-buy",
  userId: "aeIInYVk59zbFF2SxfyxxmuO",
  withPayload: "true",
};
```

## Fields

| Field                                                                                                                                   | Type                                                                                                                                    | Required                                                                                                                                | Description                                                                                                                             | Example                                                                                                                                 |
| --------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------- |
| `limit`                                                                                                                                 | *number*                                                                                                                                | :heavy_minus_sign:                                                                                                                      | Maximum number of items which may be returned.                                                                                          | 20                                                                                                                                      |
| `since`                                                                                                                                 | *string*                                                                                                                                | :heavy_minus_sign:                                                                                                                      | Timestamp to only include items created since then.                                                                                     | 2019-12-08T10:00:38.976Z                                                                                                                |
| `until`                                                                                                                                 | *string*                                                                                                                                | :heavy_minus_sign:                                                                                                                      | Timestamp to only include items created until then.                                                                                     | 2019-12-09T23:00:38.976Z                                                                                                                |
| `types`                                                                                                                                 | *string*                                                                                                                                | :heavy_minus_sign:                                                                                                                      | Comma-delimited list of event \"types\" to filter the results by.                                                                       | login,team-member-join,domain-buy                                                                                                       |
| `userId`                                                                                                                                | *string*                                                                                                                                | :heavy_minus_sign:                                                                                                                      | When retrieving events for a Team, the `userId` parameter may be specified to filter events generated by a specific member of the Team. | aeIInYVk59zbFF2SxfyxxmuO                                                                                                                |
| `withPayload`                                                                                                                           | *string*                                                                                                                                | :heavy_minus_sign:                                                                                                                      | When set to `true`, the response will include the `payload` field for each event.                                                       | true                                                                                                                                    |
| `teamId`                                                                                                                                | *string*                                                                                                                                | :heavy_minus_sign:                                                                                                                      | The Team identifier to perform the request on behalf of.                                                                                |                                                                                                                                         |
| `slug`                                                                                                                                  | *string*                                                                                                                                | :heavy_minus_sign:                                                                                                                      | The Team slug to perform the request on behalf of.                                                                                      |                                                                                                                                         |