# LatestDeployments

## Example Usage

```typescript
import { LatestDeployments } from "@vercel/sdk/models/operations/updateprojectdatacache.js";

let value: LatestDeployments = {
  id: "<id>",
  createdAt: 9194.83,
  createdIn: "<value>",
  creator: {
    email: "Zoila.Stroman61@hotmail.com",
    uid: "<id>",
    username: "Rosendo6",
  },
  deploymentHostname: "<value>",
  name: "<value>",
  plan: "enterprise",
  previewCommentsEnabled: false,
  private: false,
  readyState: "READY",
  type: "LAMBDAS",
  url: "https://witty-stock.com",
  userId: "<id>",
};
```

## Fields

| Field                                                                                                                                  | Type                                                                                                                                   | Required                                                                                                                               | Description                                                                                                                            | Example                                                                                                                                |
| -------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------- |
| `id`                                                                                                                                   | *string*                                                                                                                               | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `alias`                                                                                                                                | *string*[]                                                                                                                             | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `aliasAssigned`                                                                                                                        | *operations.AliasAssigned*                                                                                                             | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `aliasError`                                                                                                                           | [operations.UpdateProjectDataCacheProjectsAliasError](../../models/operations/updateprojectdatacacheprojectsaliaserror.md)             | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `aliasFinal`                                                                                                                           | *string*                                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `automaticAliases`                                                                                                                     | *string*[]                                                                                                                             | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `branchMatcher`                                                                                                                        | [operations.BranchMatcher](../../models/operations/branchmatcher.md)                                                                   | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `buildingAt`                                                                                                                           | *number*                                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `builds`                                                                                                                               | [operations.UpdateProjectDataCacheProjectsBuilds](../../models/operations/updateprojectdatacacheprojectsbuilds.md)[]                   | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `checksConclusion`                                                                                                                     | [operations.UpdateProjectDataCacheProjectsChecksConclusion](../../models/operations/updateprojectdatacacheprojectschecksconclusion.md) | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `checksState`                                                                                                                          | [operations.UpdateProjectDataCacheProjectsChecksState](../../models/operations/updateprojectdatacacheprojectschecksstate.md)           | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `connectBuildsEnabled`                                                                                                                 | *boolean*                                                                                                                              | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `connectConfigurationId`                                                                                                               | *string*                                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `createdAt`                                                                                                                            | *number*                                                                                                                               | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `createdIn`                                                                                                                            | *string*                                                                                                                               | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `creator`                                                                                                                              | [operations.UpdateProjectDataCacheProjectsCreator](../../models/operations/updateprojectdatacacheprojectscreator.md)                   | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `deletedAt`                                                                                                                            | *number*                                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `deploymentHostname`                                                                                                                   | *string*                                                                                                                               | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `forced`                                                                                                                               | *boolean*                                                                                                                              | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `name`                                                                                                                                 | *string*                                                                                                                               | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `meta`                                                                                                                                 | Record<string, *string*>                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `monorepoManager`                                                                                                                      | *string*                                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `oidcTokenClaims`                                                                                                                      | [operations.UpdateProjectDataCacheProjectsOidcTokenClaims](../../models/operations/updateprojectdatacacheprojectsoidctokenclaims.md)   | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `plan`                                                                                                                                 | [operations.UpdateProjectDataCacheProjectsPlan](../../models/operations/updateprojectdatacacheprojectsplan.md)                         | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `previewCommentsEnabled`                                                                                                               | *boolean*                                                                                                                              | :heavy_minus_sign:                                                                                                                     | Whether or not preview comments are enabled for the deployment                                                                         | false                                                                                                                                  |
| `private`                                                                                                                              | *boolean*                                                                                                                              | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `readyAt`                                                                                                                              | *number*                                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `readyState`                                                                                                                           | [operations.UpdateProjectDataCacheProjectsReadyState](../../models/operations/updateprojectdatacacheprojectsreadystate.md)             | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `readySubstate`                                                                                                                        | [operations.UpdateProjectDataCacheProjectsReadySubstate](../../models/operations/updateprojectdatacacheprojectsreadysubstate.md)       | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `requestedAt`                                                                                                                          | *number*                                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `target`                                                                                                                               | *string*                                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `teamId`                                                                                                                               | *string*                                                                                                                               | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `type`                                                                                                                                 | [operations.UpdateProjectDataCacheType](../../models/operations/updateprojectdatacachetype.md)                                         | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `url`                                                                                                                                  | *string*                                                                                                                               | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `userId`                                                                                                                               | *string*                                                                                                                               | :heavy_check_mark:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |
| `withCache`                                                                                                                            | *boolean*                                                                                                                              | :heavy_minus_sign:                                                                                                                     | N/A                                                                                                                                    |                                                                                                                                        |