# GetProjectsLatestDeployments

## Example Usage

```typescript
import { GetProjectsLatestDeployments } from "@vercel/sdk/models/operations/getprojects.js";

let value: GetProjectsLatestDeployments = {
  id: "<id>",
  createdAt: 5361.77,
  createdIn: "<value>",
  creator: {
    email: "Drew18@hotmail.com",
    uid: "<id>",
    username: "Karine.Tillman",
  },
  deploymentHostname: "<value>",
  name: "<value>",
  plan: "hobby",
  previewCommentsEnabled: false,
  private: false,
  readyState: "READY",
  type: "LAMBDAS",
  url: "https://good-natured-retention.name",
  userId: "<id>",
};
```

## Fields

| Field                                                                                            | Type                                                                                             | Required                                                                                         | Description                                                                                      | Example                                                                                          |
| ------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------ |
| `id`                                                                                             | *string*                                                                                         | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `alias`                                                                                          | *string*[]                                                                                       | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `aliasAssigned`                                                                                  | *operations.GetProjectsAliasAssigned*                                                            | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `aliasError`                                                                                     | [operations.GetProjectsAliasError](../../models/operations/getprojectsaliaserror.md)             | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `aliasFinal`                                                                                     | *string*                                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `automaticAliases`                                                                               | *string*[]                                                                                       | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `branchMatcher`                                                                                  | [operations.GetProjectsBranchMatcher](../../models/operations/getprojectsbranchmatcher.md)       | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `buildingAt`                                                                                     | *number*                                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `builds`                                                                                         | [operations.GetProjectsBuilds](../../models/operations/getprojectsbuilds.md)[]                   | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `checksConclusion`                                                                               | [operations.GetProjectsChecksConclusion](../../models/operations/getprojectschecksconclusion.md) | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `checksState`                                                                                    | [operations.GetProjectsChecksState](../../models/operations/getprojectschecksstate.md)           | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `connectBuildsEnabled`                                                                           | *boolean*                                                                                        | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `connectConfigurationId`                                                                         | *string*                                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `createdAt`                                                                                      | *number*                                                                                         | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `createdIn`                                                                                      | *string*                                                                                         | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `creator`                                                                                        | [operations.GetProjectsCreator](../../models/operations/getprojectscreator.md)                   | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `deletedAt`                                                                                      | *number*                                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `deploymentHostname`                                                                             | *string*                                                                                         | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `forced`                                                                                         | *boolean*                                                                                        | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `name`                                                                                           | *string*                                                                                         | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `meta`                                                                                           | Record<string, *string*>                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `monorepoManager`                                                                                | *string*                                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `oidcTokenClaims`                                                                                | [operations.GetProjectsOidcTokenClaims](../../models/operations/getprojectsoidctokenclaims.md)   | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `plan`                                                                                           | [operations.GetProjectsPlan](../../models/operations/getprojectsplan.md)                         | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `previewCommentsEnabled`                                                                         | *boolean*                                                                                        | :heavy_minus_sign:                                                                               | Whether or not preview comments are enabled for the deployment                                   | false                                                                                            |
| `private`                                                                                        | *boolean*                                                                                        | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `readyAt`                                                                                        | *number*                                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `readyState`                                                                                     | [operations.GetProjectsReadyState](../../models/operations/getprojectsreadystate.md)             | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `readySubstate`                                                                                  | [operations.GetProjectsReadySubstate](../../models/operations/getprojectsreadysubstate.md)       | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `requestedAt`                                                                                    | *number*                                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `target`                                                                                         | *string*                                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `teamId`                                                                                         | *string*                                                                                         | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |
| `type`                                                                                           | [operations.GetProjectsProjectsType](../../models/operations/getprojectsprojectstype.md)         | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `url`                                                                                            | *string*                                                                                         | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `userId`                                                                                         | *string*                                                                                         | :heavy_check_mark:                                                                               | N/A                                                                                              |                                                                                                  |
| `withCache`                                                                                      | *boolean*                                                                                        | :heavy_minus_sign:                                                                               | N/A                                                                                              |                                                                                                  |