# GetDeploymentsRequest

## Example Usage

```typescript
import { GetDeploymentsRequest } from "@vercel/sdk/models/operations/getdeployments.js";

let value: GetDeploymentsRequest = {
  app: "docs",
  from: 1612948664566,
  limit: 10,
  projectId: "QmXGTs7mvAMMC7WW5ebrM33qKG32QK3h4vmQMjmY",
  target: "production",
  to: 1612948664566,
  users: "kr1PsOIzqEL5Xg6M4VZcZosf,K4amb7K9dAt5R2vBJWF32bmY",
  since: 1540095775941,
  until: 1540095775951,
  state: "BUILDING,READY",
};
```

## Fields

| Field                                                                                                        | Type                                                                                                         | Required                                                                                                     | Description                                                                                                  | Example                                                                                                      |
| ------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------ |
| `app`                                                                                                        | *string*                                                                                                     | :heavy_minus_sign:                                                                                           | Name of the deployment.                                                                                      | docs                                                                                                         |
| `from`                                                                                                       | *number*                                                                                                     | :heavy_minus_sign:                                                                                           | Gets the deployment created after this Date timestamp. (default: current time)                               | 1612948664566                                                                                                |
| `limit`                                                                                                      | *number*                                                                                                     | :heavy_minus_sign:                                                                                           | Maximum number of deployments to list from a request.                                                        | 10                                                                                                           |
| `projectId`                                                                                                  | *string*                                                                                                     | :heavy_minus_sign:                                                                                           | Filter deployments from the given ID or name.                                                                | QmXGTs7mvAMMC7WW5ebrM33qKG32QK3h4vmQMjmY                                                                     |
| `target`                                                                                                     | *string*                                                                                                     | :heavy_minus_sign:                                                                                           | Filter deployments based on the environment.                                                                 | production                                                                                                   |
| `to`                                                                                                         | *number*                                                                                                     | :heavy_minus_sign:                                                                                           | Gets the deployment created before this Date timestamp. (default: current time)                              | 1612948664566                                                                                                |
| `users`                                                                                                      | *string*                                                                                                     | :heavy_minus_sign:                                                                                           | Filter out deployments based on users who have created the deployment.                                       | kr1PsOIzqEL5Xg6M4VZcZosf,K4amb7K9dAt5R2vBJWF32bmY                                                            |
| `since`                                                                                                      | *number*                                                                                                     | :heavy_minus_sign:                                                                                           | Get Deployments created after this JavaScript timestamp.                                                     | 1540095775941                                                                                                |
| `until`                                                                                                      | *number*                                                                                                     | :heavy_minus_sign:                                                                                           | Get Deployments created before this JavaScript timestamp.                                                    | 1540095775951                                                                                                |
| `state`                                                                                                      | *string*                                                                                                     | :heavy_minus_sign:                                                                                           | Filter deployments based on their state (`BUILDING`, `ERROR`, `INITIALIZING`, `QUEUED`, `READY`, `CANCELED`) | BUILDING,READY                                                                                               |
| `rollbackCandidate`                                                                                          | *boolean*                                                                                                    | :heavy_minus_sign:                                                                                           | Filter deployments based on their rollback candidacy                                                         |                                                                                                              |
| `teamId`                                                                                                     | *string*                                                                                                     | :heavy_minus_sign:                                                                                           | The Team identifier to perform the request on behalf of.                                                     |                                                                                                              |
| `slug`                                                                                                       | *string*                                                                                                     | :heavy_minus_sign:                                                                                           | The Team slug to perform the request on behalf of.                                                           |                                                                                                              |