# GetDeploymentResponseBody1

The deployment including both public and private information

## Example Usage

```typescript
import { GetDeploymentResponseBody1 } from "@vercel/sdk/models/operations/getdeployment.js";

let value: GetDeploymentResponseBody1 = {
  build: {
    env: [
      "<value>",
    ],
  },
  env: [
    "<value>",
  ],
  inspectorUrl: "https://sore-merit.org/",
  isInConcurrentBuildsQueue: false,
  isInSystemBuildsQueue: false,
  projectSettings: {},
  aliasAssigned: false,
  bootedAt: 9822.48,
  buildingAt: 9926.67,
  buildSkipped: false,
  creator: {
    uid: "<id>",
  },
  public: false,
  status: "QUEUED",
  id: "<id>",
  type: "LAMBDAS",
  createdAt: 9382.56,
  name: "<value>",
  readyState: "BUILDING",
  meta: {
    "key": "<value>",
  },
  regions: [
    "<value>",
  ],
  url: "https://small-creator.name/",
  version: 1858.17,
  projectId: "<id>",
  plan: "pro",
  createdIn: "<value>",
  ownerId: "<id>",
  routes: [
    {
      src: "<value>",
    },
  ],
};
```

## Fields

| Field                                                                                                                                                                                                                       | Type                                                                                                                                                                                                                        | Required                                                                                                                                                                                                                    | Description                                                                                                                                                                                                                 |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `aliasAssignedAt`                                                                                                                                                                                                           | *operations.ResponseBodyAliasAssignedAt*                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `alwaysRefuseToBuild`                                                                                                                                                                                                       | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `build`                                                                                                                                                                                                                     | [operations.ResponseBodyBuild](../../models/operations/responsebodybuild.md)                                                                                                                                                | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildArtifactUrls`                                                                                                                                                                                                         | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `builds`                                                                                                                                                                                                                    | [operations.ResponseBodyBuilds](../../models/operations/responsebodybuilds.md)[]                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `env`                                                                                                                                                                                                                       | *string*[]                                                                                                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `inspectorUrl`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `isInConcurrentBuildsQueue`                                                                                                                                                                                                 | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `isInSystemBuildsQueue`                                                                                                                                                                                                     | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `projectSettings`                                                                                                                                                                                                           | [operations.ResponseBodyProjectSettings](../../models/operations/responsebodyprojectsettings.md)                                                                                                                            | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `readyStateReason`                                                                                                                                                                                                          | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `integrations`                                                                                                                                                                                                              | [operations.ResponseBodyIntegrations](../../models/operations/responsebodyintegrations.md)                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `alias`                                                                                                                                                                                                                     | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasAssigned`                                                                                                                                                                                                             | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `bootedAt`                                                                                                                                                                                                                  | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildingAt`                                                                                                                                                                                                                | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildSkipped`                                                                                                                                                                                                              | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `creator`                                                                                                                                                                                                                   | [operations.ResponseBodyCreator](../../models/operations/responsebodycreator.md)                                                                                                                                            | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `initReadyAt`                                                                                                                                                                                                               | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `isFirstBranchDeployment`                                                                                                                                                                                                   | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `lambdas`                                                                                                                                                                                                                   | [operations.GetDeploymentResponseBodyLambdas](../../models/operations/getdeploymentresponsebodylambdas.md)[]                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `public`                                                                                                                                                                                                                    | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `ready`                                                                                                                                                                                                                     | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `status`                                                                                                                                                                                                                    | [operations.ResponseBodyStatus](../../models/operations/responsebodystatus.md)                                                                                                                                              | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `team`                                                                                                                                                                                                                      | [operations.GetDeploymentResponseBodyTeam](../../models/operations/getdeploymentresponsebodyteam.md)                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `userAliases`                                                                                                                                                                                                               | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `previewCommentsEnabled`                                                                                                                                                                                                    | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `ttyBuildLogs`                                                                                                                                                                                                              | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `customEnvironment`                                                                                                                                                                                                         | *operations.GetDeploymentResponseBodyCustomEnvironment*                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasWarning`                                                                                                                                                                                                              | [operations.GetDeploymentResponseBodyAliasWarning](../../models/operations/getdeploymentresponsebodyaliaswarning.md)                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `id`                                                                                                                                                                                                                        | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `type`                                                                                                                                                                                                                      | [operations.ResponseBodyType](../../models/operations/responsebodytype.md)                                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `createdAt`                                                                                                                                                                                                                 | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `name`                                                                                                                                                                                                                      | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `readyState`                                                                                                                                                                                                                | [operations.ResponseBodyReadyState](../../models/operations/responsebodyreadystate.md)                                                                                                                                      | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasError`                                                                                                                                                                                                                | [operations.ResponseBodyAliasError](../../models/operations/responsebodyaliaserror.md)                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasFinal`                                                                                                                                                                                                                | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `autoAssignCustomDomains`                                                                                                                                                                                                   | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | applies to custom domains only, defaults to `true`                                                                                                                                                                          |
| `automaticAliases`                                                                                                                                                                                                          | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildErrorAt`                                                                                                                                                                                                              | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `checksState`                                                                                                                                                                                                               | [operations.ResponseBodyChecksState](../../models/operations/responsebodychecksstate.md)                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `checksConclusion`                                                                                                                                                                                                          | [operations.ResponseBodyChecksConclusion](../../models/operations/responsebodychecksconclusion.md)                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `deletedAt`                                                                                                                                                                                                                 | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `defaultRoute`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | Computed field that is only available for deployments with a micro-frontend configuration.                                                                                                                                  |
| `canceledAt`                                                                                                                                                                                                                | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorCode`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorLink`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorMessage`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorStep`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `passiveRegions`                                                                                                                                                                                                            | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | Since November 2023 this field defines a set of regions that we will deploy the lambda to passively Lambdas will be deployed to these regions but only invoked if all of the primary `regions` are marked as out of service |
| `gitSource`                                                                                                                                                                                                                 | *operations.GetDeploymentResponseBodyGitSource*                                                                                                                                                                             | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `meta`                                                                                                                                                                                                                      | Record<string, *string*>                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `project`                                                                                                                                                                                                                   | [operations.ResponseBodyProject](../../models/operations/responsebodyproject.md)                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `readySubstate`                                                                                                                                                                                                             | [operations.ResponseBodyReadySubstate](../../models/operations/responsebodyreadysubstate.md)                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                                          | Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic             |
| `regions`                                                                                                                                                                                                                   | *string*[]                                                                                                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `softDeletedByRetention`                                                                                                                                                                                                    | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `source`                                                                                                                                                                                                                    | [operations.ResponseBodySource](../../models/operations/responsebodysource.md)                                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `target`                                                                                                                                                                                                                    | [operations.ResponseBodyTarget](../../models/operations/responsebodytarget.md)                                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `undeletedAt`                                                                                                                                                                                                               | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `url`                                                                                                                                                                                                                       | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `version`                                                                                                                                                                                                                   | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `oidcTokenClaims`                                                                                                                                                                                                           | [operations.ResponseBodyOidcTokenClaims](../../models/operations/responsebodyoidctokenclaims.md)                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `projectId`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `plan`                                                                                                                                                                                                                      | [operations.ResponseBodyPlan](../../models/operations/responsebodyplan.md)                                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `connectBuildsEnabled`                                                                                                                                                                                                      | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `connectConfigurationId`                                                                                                                                                                                                    | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `createdIn`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `crons`                                                                                                                                                                                                                     | [operations.ResponseBodyCrons](../../models/operations/responsebodycrons.md)[]                                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `functions`                                                                                                                                                                                                                 | Record<string, [operations.ResponseBodyFunctions](../../models/operations/responsebodyfunctions.md)>                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `monorepoManager`                                                                                                                                                                                                           | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `ownerId`                                                                                                                                                                                                                   | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `passiveConnectConfigurationId`                                                                                                                                                                                             | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | Since November 2023 this field defines a Secure Compute network that will only be used to deploy passive lambdas to (as in passiveRegions)                                                                                  |
| `routes`                                                                                                                                                                                                                    | *operations.ResponseBodyRoutes*[]                                                                                                                                                                                           | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `gitRepo`                                                                                                                                                                                                                   | *operations.ResponseBodyGitRepo*                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `flags`                                                                                                                                                                                                                     | *operations.ResponseBodyFlags*                                                                                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |