# GetConfigurationsResponseBody2

## Example Usage

```typescript
import { GetConfigurationsResponseBody2 } from "@vercel/sdk/models/operations/getconfigurations.js";

let value: GetConfigurationsResponseBody2 = {
  integration: {
    name: "<value>",
    icon: "<value>",
    category: "<value>",
    isLegacy: false,
  },
  completedAt: 1558531915505,
  createdAt: 1558531915505,
  id: "icfg_3bwCLgxL8qt5kjRLcv2Dit7F",
  integrationId: "oac_xzpVzcUOgcB1nrVlirtKhbWV",
  ownerId: "kr1PsOIzqEL5Xg6M4VZcZosf",
  projects: [
    "prj_xQxbutw1HpL6HLYPAzt5h75m8NjO",
  ],
  source: "marketplace",
  slug: "slack",
  teamId: "team_nLlpyC6RE1qxydlFKbrxDlud",
  type: "integration-configuration",
  updatedAt: 1558531915505,
  userId: "kr1PsOIzqEL5Xg6M4VZcZosf",
  scopes: [
    "read:project",
    "read-write:log-drain",
  ],
  disabledAt: 1558531915505,
  deletedAt: 1558531915505,
  deleteRequestedAt: 1558531915505,
};
```

## Fields

| Field                                                                                                                                                                                                                                                                                                        | Type                                                                                                                                                                                                                                                                                                         | Required                                                                                                                                                                                                                                                                                                     | Description                                                                                                                                                                                                                                                                                                  | Example                                                                                                                                                                                                                                                                                                      |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `integration`                                                                                                                                                                                                                                                                                                | [operations.Integration](../../models/operations/integration.md)                                                                                                                                                                                                                                             | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | N/A                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                              |
| `completedAt`                                                                                                                                                                                                                                                                                                | *number*                                                                                                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | A timestamp that tells you when the configuration was installed successfully                                                                                                                                                                                                                                 | 1558531915505                                                                                                                                                                                                                                                                                                |
| `createdAt`                                                                                                                                                                                                                                                                                                  | *number*                                                                                                                                                                                                                                                                                                     | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | A timestamp that tells you when the configuration was created                                                                                                                                                                                                                                                | 1558531915505                                                                                                                                                                                                                                                                                                |
| `id`                                                                                                                                                                                                                                                                                                         | *string*                                                                                                                                                                                                                                                                                                     | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | The unique identifier of the configuration                                                                                                                                                                                                                                                                   | icfg_3bwCLgxL8qt5kjRLcv2Dit7F                                                                                                                                                                                                                                                                                |
| `integrationId`                                                                                                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                                                                                                     | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | The unique identifier of the app the configuration was created for                                                                                                                                                                                                                                           | oac_xzpVzcUOgcB1nrVlirtKhbWV                                                                                                                                                                                                                                                                                 |
| `ownerId`                                                                                                                                                                                                                                                                                                    | *string*                                                                                                                                                                                                                                                                                                     | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | The user or team ID that owns the configuration                                                                                                                                                                                                                                                              | kr1PsOIzqEL5Xg6M4VZcZosf                                                                                                                                                                                                                                                                                     |
| `projects`                                                                                                                                                                                                                                                                                                   | *string*[]                                                                                                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | When a configuration is limited to access certain projects, this will contain each of the project ID it is allowed to access. If it is not defined, the configuration has full access.                                                                                                                       | [<br/>"prj_xQxbutw1HpL6HLYPAzt5h75m8NjO"<br/>]                                                                                                                                                                                                                                                               |
| `source`                                                                                                                                                                                                                                                                                                     | [operations.GetConfigurationsResponseBodyIntegrationsSource](../../models/operations/getconfigurationsresponsebodyintegrationssource.md)                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.                                                                                                                                                           | marketplace                                                                                                                                                                                                                                                                                                  |
| `slug`                                                                                                                                                                                                                                                                                                       | *string*                                                                                                                                                                                                                                                                                                     | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | The slug of the integration the configuration is created for.                                                                                                                                                                                                                                                | slack                                                                                                                                                                                                                                                                                                        |
| `teamId`                                                                                                                                                                                                                                                                                                     | *string*                                                                                                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | When the configuration was created for a team, this will show the ID of the team.                                                                                                                                                                                                                            | team_nLlpyC6RE1qxydlFKbrxDlud                                                                                                                                                                                                                                                                                |
| `type`                                                                                                                                                                                                                                                                                                       | [operations.GetConfigurationsResponseBodyIntegrationsType](../../models/operations/getconfigurationsresponsebodyintegrationstype.md)                                                                                                                                                                         | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | N/A                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                              |
| `updatedAt`                                                                                                                                                                                                                                                                                                  | *number*                                                                                                                                                                                                                                                                                                     | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | A timestamp that tells you when the configuration was updated.                                                                                                                                                                                                                                               | 1558531915505                                                                                                                                                                                                                                                                                                |
| `userId`                                                                                                                                                                                                                                                                                                     | *string*                                                                                                                                                                                                                                                                                                     | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | The ID of the user that created the configuration.                                                                                                                                                                                                                                                           | kr1PsOIzqEL5Xg6M4VZcZosf                                                                                                                                                                                                                                                                                     |
| `scopes`                                                                                                                                                                                                                                                                                                     | *string*[]                                                                                                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                                                                                                           | The resources that are allowed to be accessed by the configuration.                                                                                                                                                                                                                                          | [<br/>"read:project",<br/>"read-write:log-drain"<br/>]                                                                                                                                                                                                                                                       |
| `disabledAt`                                                                                                                                                                                                                                                                                                 | *number*                                                                                                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | A timestamp that tells you when the configuration was disabled. Note: Configurations can be disabled when the associated user loses access to a team. They do not function during this time until the configuration is 'transferred', meaning the associated user is changed to one with access to the team. | 1558531915505                                                                                                                                                                                                                                                                                                |
| `deletedAt`                                                                                                                                                                                                                                                                                                  | *number*                                                                                                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | A timestamp that tells you when the configuration was deleted.                                                                                                                                                                                                                                               | 1558531915505                                                                                                                                                                                                                                                                                                |
| `deleteRequestedAt`                                                                                                                                                                                                                                                                                          | *number*                                                                                                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | A timestamp that tells you when the configuration deletion has been started for cases when the deletion needs to be settled/approved by partners, such as when marketplace invoices have been paid.                                                                                                          | 1558531915505                                                                                                                                                                                                                                                                                                |
| `disabledReason`                                                                                                                                                                                                                                                                                             | [operations.ResponseBodyDisabledReason](../../models/operations/responsebodydisabledreason.md)                                                                                                                                                                                                               | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | N/A                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                              |
| `installationType`                                                                                                                                                                                                                                                                                           | [operations.GetConfigurationsResponseBodyInstallationType](../../models/operations/getconfigurationsresponsebodyinstallationtype.md)                                                                                                                                                                         | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'                                     |                                                                                                                                                                                                                                                                                                              |
| `billingPlan`                                                                                                                                                                                                                                                                                                | [operations.ResponseBodyBillingPlan](../../models/operations/responsebodybillingplan.md)                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | N/A                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                              |
| `billingTotal`                                                                                                                                                                                                                                                                                               | *string*                                                                                                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | N/A                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                              |
| `periodStart`                                                                                                                                                                                                                                                                                                | *string*                                                                                                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | N/A                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                              |
| `periodEnd`                                                                                                                                                                                                                                                                                                  | *string*                                                                                                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                           | N/A                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                              |