# Deployments

## Example Usage

```typescript
import { Deployments } from "@vercel/sdk/models/operations/getdeployments.js";

let value: Deployments = {
  uid: "dpl_2euZBFqxYdDMDG1jTrHFnNZ2eUVa",
  name: "docs",
  url: "docs-9jaeg38me.vercel.app",
  created: 1609492210000,
  deleted: 1609492210000,
  undeleted: 1609492210000,
  softDeletedByRetention: true,
  source: "cli",
  state: "READY",
  readyState: "READY",
  type: "LAMBDAS",
  creator: {
    uid: "eLrCnEgbKhsHyfbiNR7E8496",
    email: "example@example.com",
    username: "johndoe",
    githubLogin: "johndoe",
    gitlabLogin: "johndoe",
  },
  target: "production",
  createdAt: 1609492210000,
  buildingAt: 1609492210000,
  ready: 1609492210000,
  inspectorUrl: "https://vercel.com/acme/nextjs/J1hXN00qjUeoYfpEEf7dnDtpSiVq",
};
```

## Fields

| Field                                                                                                                                                                                                           | Type                                                                                                                                                                                                            | Required                                                                                                                                                                                                        | Description                                                                                                                                                                                                     | Example                                                                                                                                                                                                         |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `uid`                                                                                                                                                                                                           | *string*                                                                                                                                                                                                        | :heavy_check_mark:                                                                                                                                                                                              | The unique identifier of the deployment.                                                                                                                                                                        | dpl_2euZBFqxYdDMDG1jTrHFnNZ2eUVa                                                                                                                                                                                |
| `name`                                                                                                                                                                                                          | *string*                                                                                                                                                                                                        | :heavy_check_mark:                                                                                                                                                                                              | The name of the deployment.                                                                                                                                                                                     | docs                                                                                                                                                                                                            |
| `url`                                                                                                                                                                                                           | *string*                                                                                                                                                                                                        | :heavy_check_mark:                                                                                                                                                                                              | The URL of the deployment.                                                                                                                                                                                      | docs-9jaeg38me.vercel.app                                                                                                                                                                                       |
| `created`                                                                                                                                                                                                       | *number*                                                                                                                                                                                                        | :heavy_check_mark:                                                                                                                                                                                              | Timestamp of when the deployment got created.                                                                                                                                                                   | 1609492210000                                                                                                                                                                                                   |
| `deleted`                                                                                                                                                                                                       | *number*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | Timestamp of when the deployment got deleted.                                                                                                                                                                   | 1609492210000                                                                                                                                                                                                   |
| `undeleted`                                                                                                                                                                                                     | *number*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | Timestamp of when the deployment was undeleted.                                                                                                                                                                 | 1609492210000                                                                                                                                                                                                   |
| `softDeletedByRetention`                                                                                                                                                                                        | *boolean*                                                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                                                              | Optional flag to indicate if the deployment was soft deleted by retention policy.                                                                                                                               | true                                                                                                                                                                                                            |
| `source`                                                                                                                                                                                                        | [operations.GetDeploymentsSource](../../models/operations/getdeploymentssource.md)                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                              | The source of the deployment.                                                                                                                                                                                   | cli                                                                                                                                                                                                             |
| `state`                                                                                                                                                                                                         | [operations.GetDeploymentsState](../../models/operations/getdeploymentsstate.md)                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                              | In which state is the deployment.                                                                                                                                                                               | READY                                                                                                                                                                                                           |
| `readyState`                                                                                                                                                                                                    | [operations.GetDeploymentsReadyState](../../models/operations/getdeploymentsreadystate.md)                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                              | In which state is the deployment.                                                                                                                                                                               | READY                                                                                                                                                                                                           |
| `type`                                                                                                                                                                                                          | [operations.GetDeploymentsType](../../models/operations/getdeploymentstype.md)                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                              | The type of the deployment.                                                                                                                                                                                     | LAMBDAS                                                                                                                                                                                                         |
| `creator`                                                                                                                                                                                                       | [operations.GetDeploymentsCreator](../../models/operations/getdeploymentscreator.md)                                                                                                                            | :heavy_check_mark:                                                                                                                                                                                              | Metadata information of the user who created the deployment.                                                                                                                                                    |                                                                                                                                                                                                                 |
| `meta`                                                                                                                                                                                                          | Record<string, *string*>                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | Metadata information from the Git provider.                                                                                                                                                                     |                                                                                                                                                                                                                 |
| `target`                                                                                                                                                                                                        | [operations.GetDeploymentsTarget](../../models/operations/getdeploymentstarget.md)                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                              | On which environment has the deployment been deployed to.                                                                                                                                                       | production                                                                                                                                                                                                      |
| `aliasError`                                                                                                                                                                                                    | [operations.GetDeploymentsAliasError](../../models/operations/getdeploymentsaliaserror.md)                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                              | An error object in case aliasing of the deployment failed.                                                                                                                                                      |                                                                                                                                                                                                                 |
| `aliasAssigned`                                                                                                                                                                                                 | *operations.GetDeploymentsAliasAssigned*                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | N/A                                                                                                                                                                                                             |                                                                                                                                                                                                                 |
| `createdAt`                                                                                                                                                                                                     | *number*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | Timestamp of when the deployment got created.                                                                                                                                                                   | 1609492210000                                                                                                                                                                                                   |
| `buildingAt`                                                                                                                                                                                                    | *number*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | Timestamp of when the deployment started building at.                                                                                                                                                           | 1609492210000                                                                                                                                                                                                   |
| `ready`                                                                                                                                                                                                         | *number*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | Timestamp of when the deployment got ready.                                                                                                                                                                     | 1609492210000                                                                                                                                                                                                   |
| `readySubstate`                                                                                                                                                                                                 | [operations.GetDeploymentsReadySubstate](../../models/operations/getdeploymentsreadysubstate.md)                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                              | Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic |                                                                                                                                                                                                                 |
| `checksState`                                                                                                                                                                                                   | [operations.GetDeploymentsChecksState](../../models/operations/getdeploymentschecksstate.md)                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                              | State of all registered checks                                                                                                                                                                                  |                                                                                                                                                                                                                 |
| `checksConclusion`                                                                                                                                                                                              | [operations.GetDeploymentsChecksConclusion](../../models/operations/getdeploymentschecksconclusion.md)                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                              | Conclusion for checks                                                                                                                                                                                           |                                                                                                                                                                                                                 |
| `inspectorUrl`                                                                                                                                                                                                  | *string*                                                                                                                                                                                                        | :heavy_check_mark:                                                                                                                                                                                              | Vercel URL to inspect the deployment.                                                                                                                                                                           | https://vercel.com/acme/nextjs/J1hXN00qjUeoYfpEEf7dnDtpSiVq                                                                                                                                                     |
| `isRollbackCandidate`                                                                                                                                                                                           | *boolean*                                                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                                                              | Deployment can be used for instant rollback                                                                                                                                                                     |                                                                                                                                                                                                                 |
| `projectSettings`                                                                                                                                                                                               | [operations.GetDeploymentsProjectSettings](../../models/operations/getdeploymentsprojectsettings.md)                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                              | The project settings which was used for this deployment                                                                                                                                                         |                                                                                                                                                                                                                 |
| `connectBuildsEnabled`                                                                                                                                                                                          | *boolean*                                                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                                                              | The flag saying if Secure Compute network is used for builds                                                                                                                                                    |                                                                                                                                                                                                                 |
| `connectConfigurationId`                                                                                                                                                                                        | *string*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | The ID of Secure Compute network used for this deployment                                                                                                                                                       |                                                                                                                                                                                                                 |
| `passiveConnectConfigurationId`                                                                                                                                                                                 | *string*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | The ID of Secure Compute network used for this deployment's passive functions                                                                                                                                   |                                                                                                                                                                                                                 |
| `expiration`                                                                                                                                                                                                    | *number*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | The expiration configured by the project retention policy                                                                                                                                                       |                                                                                                                                                                                                                 |
| `proposedExpiration`                                                                                                                                                                                            | *number*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | The expiration proposed to replace the existing expiration                                                                                                                                                      |                                                                                                                                                                                                                 |
| `customEnvironment`                                                                                                                                                                                             | [operations.GetDeploymentsCustomEnvironment](../../models/operations/getdeploymentscustomenvironment.md)                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                              | The custom environment used for this deployment, if any                                                                                                                                                         |                                                                                                                                                                                                                 |