# CreateProjectTargets

## Example Usage

```typescript
import { CreateProjectTargets } from "@vercel/sdk/models/operations/createproject.js";

let value: CreateProjectTargets = {
  id: "<id>",
  createdAt: 191.23,
  createdIn: "<value>",
  creator: {
    email: "Rory.Fadel8@yahoo.com",
    uid: "<id>",
    username: "Bailey.Bergstrom85",
  },
  deploymentHostname: "<value>",
  name: "<value>",
  plan: "enterprise",
  previewCommentsEnabled: false,
  private: false,
  readyState: "READY",
  type: "LAMBDAS",
  url: "https://crowded-councilman.info/",
  userId: "<id>",
};
```

## Fields

| Field                                                                                                                                            | Type                                                                                                                                             | Required                                                                                                                                         | Description                                                                                                                                      | Example                                                                                                                                          |
| ------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------ |
| `id`                                                                                                                                             | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `alias`                                                                                                                                          | *string*[]                                                                                                                                       | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `aliasAssigned`                                                                                                                                  | *operations.CreateProjectProjectsAliasAssigned*                                                                                                  | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `aliasError`                                                                                                                                     | [operations.CreateProjectProjectsAliasError](../../models/operations/createprojectprojectsaliaserror.md)                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `aliasFinal`                                                                                                                                     | *string*                                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `automaticAliases`                                                                                                                               | *string*[]                                                                                                                                       | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `branchMatcher`                                                                                                                                  | [operations.CreateProjectProjectsBranchMatcher](../../models/operations/createprojectprojectsbranchmatcher.md)                                   | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `buildingAt`                                                                                                                                     | *number*                                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `builds`                                                                                                                                         | [operations.CreateProjectProjectsBuilds](../../models/operations/createprojectprojectsbuilds.md)[]                                               | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `checksConclusion`                                                                                                                               | [operations.CreateProjectProjectsChecksConclusion](../../models/operations/createprojectprojectschecksconclusion.md)                             | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `checksState`                                                                                                                                    | [operations.CreateProjectProjectsChecksState](../../models/operations/createprojectprojectschecksstate.md)                                       | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `connectBuildsEnabled`                                                                                                                           | *boolean*                                                                                                                                        | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `connectConfigurationId`                                                                                                                         | *string*                                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `createdAt`                                                                                                                                      | *number*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `createdIn`                                                                                                                                      | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `creator`                                                                                                                                        | [operations.CreateProjectProjectsCreator](../../models/operations/createprojectprojectscreator.md)                                               | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `deletedAt`                                                                                                                                      | *number*                                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `deploymentHostname`                                                                                                                             | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `forced`                                                                                                                                         | *boolean*                                                                                                                                        | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `name`                                                                                                                                           | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `meta`                                                                                                                                           | Record<string, *string*>                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `monorepoManager`                                                                                                                                | *string*                                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `oidcTokenClaims`                                                                                                                                | [operations.CreateProjectProjectsOidcTokenClaims](../../models/operations/createprojectprojectsoidctokenclaims.md)                               | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `plan`                                                                                                                                           | [operations.CreateProjectProjectsPlan](../../models/operations/createprojectprojectsplan.md)                                                     | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `previewCommentsEnabled`                                                                                                                         | *boolean*                                                                                                                                        | :heavy_minus_sign:                                                                                                                               | Whether or not preview comments are enabled for the deployment                                                                                   | false                                                                                                                                            |
| `private`                                                                                                                                        | *boolean*                                                                                                                                        | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `readyAt`                                                                                                                                        | *number*                                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `readyState`                                                                                                                                     | [operations.CreateProjectProjectsReadyState](../../models/operations/createprojectprojectsreadystate.md)                                         | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `readySubstate`                                                                                                                                  | [operations.CreateProjectProjectsReadySubstate](../../models/operations/createprojectprojectsreadysubstate.md)                                   | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `requestedAt`                                                                                                                                    | *number*                                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `target`                                                                                                                                         | *string*                                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `teamId`                                                                                                                                         | *string*                                                                                                                                         | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `type`                                                                                                                                           | [operations.CreateProjectProjectsResponse200ApplicationJSONType](../../models/operations/createprojectprojectsresponse200applicationjsontype.md) | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `url`                                                                                                                                            | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `userId`                                                                                                                                         | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `withCache`                                                                                                                                      | *boolean*                                                                                                                                        | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |