# CreateProjectResponseBody

The project was successfuly created

## Example Usage

```typescript
import { CreateProjectResponseBody } from "@vercel/sdk/models/operations/createproject.js";

let value: CreateProjectResponseBody = {
  accountId: "<id>",
  crons: {
    enabledAt: 813.70,
    disabledAt: 8818.97,
    updatedAt: 7196.20,
    deploymentId: "<id>",
    definitions: [
      {
        host: "vercel.com",
        path: "/api/crons/sync-something?hello=world",
        schedule: "0 0 * * *",
      },
    ],
  },
  directoryListing: false,
  id: "<id>",
  latestDeployments: [
    {
      id: "<id>",
      createdAt: 9663.90,
      createdIn: "<value>",
      creator: {
        email: "Elisa26@yahoo.com",
        uid: "<id>",
        username: "Gabrielle.Franey",
      },
      deploymentHostname: "<value>",
      name: "<value>",
      plan: "enterprise",
      previewCommentsEnabled: false,
      private: false,
      readyState: "INITIALIZING",
      type: "LAMBDAS",
      url: "https://weary-worth.info",
      userId: "<id>",
    },
  ],
  name: "<value>",
  nodeVersion: "8.10.x",
  targets: {
    "key": {
      id: "<id>",
      createdAt: 7918.80,
      createdIn: "<value>",
      creator: {
        email: "Deja_Cummerata@hotmail.com",
        uid: "<id>",
        username: "Jermain42",
      },
      deploymentHostname: "<value>",
      name: "<value>",
      plan: "hobby",
      previewCommentsEnabled: false,
      private: false,
      readyState: "BUILDING",
      type: "LAMBDAS",
      url: "https://frugal-beret.info/",
      userId: "<id>",
    },
  },
};
```

## Fields

| Field                                                                                                                | Type                                                                                                                 | Required                                                                                                             | Description                                                                                                          |
| -------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| `accountId`                                                                                                          | *string*                                                                                                             | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `analytics`                                                                                                          | [operations.CreateProjectAnalytics](../../models/operations/createprojectanalytics.md)                               | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `speedInsights`                                                                                                      | [operations.CreateProjectSpeedInsights](../../models/operations/createprojectspeedinsights.md)                       | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `autoExposeSystemEnvs`                                                                                               | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `autoAssignCustomDomains`                                                                                            | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `autoAssignCustomDomainsUpdatedBy`                                                                                   | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `buildCommand`                                                                                                       | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `commandForIgnoringBuildStep`                                                                                        | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `connectConfigurationId`                                                                                             | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `connectBuildsEnabled`                                                                                               | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `createdAt`                                                                                                          | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `customerSupportCodeVisibility`                                                                                      | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `crons`                                                                                                              | [operations.CreateProjectCrons](../../models/operations/createprojectcrons.md)                                       | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `dataCache`                                                                                                          | [operations.CreateProjectDataCache](../../models/operations/createprojectdatacache.md)                               | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `deploymentExpiration`                                                                                               | [operations.CreateProjectDeploymentExpiration](../../models/operations/createprojectdeploymentexpiration.md)         | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `devCommand`                                                                                                         | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `directoryListing`                                                                                                   | *boolean*                                                                                                            | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `installCommand`                                                                                                     | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `env`                                                                                                                | [operations.CreateProjectEnv](../../models/operations/createprojectenv.md)[]                                         | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `customEnvironments`                                                                                                 | [operations.CreateProjectCustomEnvironments](../../models/operations/createprojectcustomenvironments.md)[]           | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `framework`                                                                                                          | [operations.CreateProjectProjectsFramework](../../models/operations/createprojectprojectsframework.md)               | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `gitForkProtection`                                                                                                  | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `gitLFS`                                                                                                             | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `id`                                                                                                                 | *string*                                                                                                             | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `ipBuckets`                                                                                                          | [operations.CreateProjectIpBuckets](../../models/operations/createprojectipbuckets.md)[]                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `latestDeployments`                                                                                                  | [operations.CreateProjectLatestDeployments](../../models/operations/createprojectlatestdeployments.md)[]             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `link`                                                                                                               | *operations.CreateProjectLink*                                                                                       | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `microfrontends`                                                                                                     | [operations.CreateProjectMicrofrontends](../../models/operations/createprojectmicrofrontends.md)                     | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `name`                                                                                                               | *string*                                                                                                             | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `nodeVersion`                                                                                                        | [operations.CreateProjectNodeVersion](../../models/operations/createprojectnodeversion.md)                           | :heavy_check_mark:                                                                                                   | N/A                                                                                                                  |
| `optionsAllowlist`                                                                                                   | [operations.CreateProjectOptionsAllowlist](../../models/operations/createprojectoptionsallowlist.md)                 | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `outputDirectory`                                                                                                    | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `passiveConnectConfigurationId`                                                                                      | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `passwordProtection`                                                                                                 | [operations.CreateProjectPasswordProtection](../../models/operations/createprojectpasswordprotection.md)             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `productionDeploymentsFastLane`                                                                                      | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `publicSource`                                                                                                       | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `resourceConfig`                                                                                                     | [operations.CreateProjectResourceConfig](../../models/operations/createprojectresourceconfig.md)                     | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `rootDirectory`                                                                                                      | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `serverlessFunctionRegion`                                                                                           | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `serverlessFunctionZeroConfigFailover`                                                                               | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `skewProtectionBoundaryAt`                                                                                           | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `skewProtectionMaxAge`                                                                                               | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `skipGitConnectDuringLink`                                                                                           | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `sourceFilesOutsideRootDirectory`                                                                                    | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `enableAffectedProjectsDeployments`                                                                                  | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `ssoProtection`                                                                                                      | [operations.CreateProjectSsoProtection](../../models/operations/createprojectssoprotection.md)                       | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `targets`                                                                                                            | Record<string, [operations.CreateProjectTargets](../../models/operations/createprojecttargets.md)>                   | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `transferCompletedAt`                                                                                                | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `transferStartedAt`                                                                                                  | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `transferToAccountId`                                                                                                | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `transferredFromAccountId`                                                                                           | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `updatedAt`                                                                                                          | *number*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `live`                                                                                                               | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `enablePreviewFeedback`                                                                                              | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `enableProductionFeedback`                                                                                           | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `permissions`                                                                                                        | [operations.CreateProjectPermissions](../../models/operations/createprojectpermissions.md)                           | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `lastRollbackTarget`                                                                                                 | [operations.CreateProjectLastRollbackTarget](../../models/operations/createprojectlastrollbacktarget.md)             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `lastAliasRequest`                                                                                                   | [operations.CreateProjectLastAliasRequest](../../models/operations/createprojectlastaliasrequest.md)                 | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `hasFloatingAliases`                                                                                                 | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `protectionBypass`                                                                                                   | Record<string, [operations.CreateProjectProtectionBypass](../../models/operations/createprojectprotectionbypass.md)> | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `hasActiveBranches`                                                                                                  | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `trustedIps`                                                                                                         | *operations.CreateProjectTrustedIps*                                                                                 | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `gitComments`                                                                                                        | [operations.CreateProjectGitComments](../../models/operations/createprojectgitcomments.md)                           | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `paused`                                                                                                             | *boolean*                                                                                                            | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `concurrencyBucketName`                                                                                              | *string*                                                                                                             | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `webAnalytics`                                                                                                       | [operations.CreateProjectWebAnalytics](../../models/operations/createprojectwebanalytics.md)                         | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `security`                                                                                                           | [operations.CreateProjectSecurity](../../models/operations/createprojectsecurity.md)                                 | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `oidcTokenConfig`                                                                                                    | [operations.CreateProjectOidcTokenConfig](../../models/operations/createprojectoidctokenconfig.md)                   | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |
| `tier`                                                                                                               | [operations.CreateProjectTier](../../models/operations/createprojecttier.md)                                         | :heavy_minus_sign:                                                                                                   | N/A                                                                                                                  |