# CreateProjectRequestBody

## Example Usage

```typescript
import { CreateProjectRequestBody } from "@vercel/sdk/models/operations/createproject.js";

let value: CreateProjectRequestBody = {
  name: "a-project-name",
};
```

## Fields

| Field                                                                                                                                                                                                               | Type                                                                                                                                                                                                                | Required                                                                                                                                                                                                            | Description                                                                                                                                                                                                         | Example                                                                                                                                                                                                             |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `buildCommand`                                                                                                                                                                                                      | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The build command for this project. When `null` is used this value will be automatically detected                                                                                                                   |                                                                                                                                                                                                                     |
| `commandForIgnoringBuildStep`                                                                                                                                                                                       | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | N/A                                                                                                                                                                                                                 |                                                                                                                                                                                                                     |
| `devCommand`                                                                                                                                                                                                        | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The dev command for this project. When `null` is used this value will be automatically detected                                                                                                                     |                                                                                                                                                                                                                     |
| `environmentVariables`                                                                                                                                                                                              | [operations.EnvironmentVariables](../../models/operations/environmentvariables.md)[]                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                                  | Collection of ENV Variables the Project will use                                                                                                                                                                    |                                                                                                                                                                                                                     |
| `framework`                                                                                                                                                                                                         | [operations.CreateProjectFramework](../../models/operations/createprojectframework.md)                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                  | The framework that is being used for this project. When `null` is used no framework is selected                                                                                                                     |                                                                                                                                                                                                                     |
| `gitRepository`                                                                                                                                                                                                     | [operations.GitRepository](../../models/operations/gitrepository.md)                                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                                  | The Git Repository that will be connected to the project. When this is defined, any pushes to the specified connected Git Repository will be automatically deployed                                                 |                                                                                                                                                                                                                     |
| `installCommand`                                                                                                                                                                                                    | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The install command for this project. When `null` is used this value will be automatically detected                                                                                                                 |                                                                                                                                                                                                                     |
| `name`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                            | :heavy_check_mark:                                                                                                                                                                                                  | The desired name for the project                                                                                                                                                                                    | a-project-name                                                                                                                                                                                                      |
| ~~`skipGitConnectDuringLink`~~                                                                                                                                                                                      | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | : warning: ** DEPRECATED **: This will be removed in a future release, please migrate away from it as soon as possible.<br/><br/>Opts-out of the message prompting a CLI user to connect a Git repository in `vercel link`. |                                                                                                                                                                                                                     |
| `outputDirectory`                                                                                                                                                                                                   | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The output directory of the project. When `null` is used this value will be automatically detected                                                                                                                  |                                                                                                                                                                                                                     |
| `publicSource`                                                                                                                                                                                                      | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Specifies whether the source code and logs of the deployments for this project should be public or not                                                                                                              |                                                                                                                                                                                                                     |
| `rootDirectory`                                                                                                                                                                                                     | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The name of a directory or relative path to the source code of your project. When `null` is used it will default to the project root                                                                                |                                                                                                                                                                                                                     |
| `serverlessFunctionRegion`                                                                                                                                                                                          | *string*                                                                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | The region to deploy Serverless Functions in this project                                                                                                                                                           |                                                                                                                                                                                                                     |
| `serverlessFunctionZeroConfigFailover`                                                                                                                                                                              | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Specifies whether Zero Config Failover is enabled for this project.                                                                                                                                                 |                                                                                                                                                                                                                     |
| `oidcTokenConfig`                                                                                                                                                                                                   | [operations.OidcTokenConfig](../../models/operations/oidctokenconfig.md)                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                  | OpenID Connect JSON Web Token generation configuration.                                                                                                                                                             |                                                                                                                                                                                                                     |
| `enableAffectedProjectsDeployments`                                                                                                                                                                                 | *boolean*                                                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                                                  | Opt-in to skip deployments when there are no changes to the root directory and its dependencies                                                                                                                     |                                                                                                                                                                                                                     |