# CreateProjectLatestDeployments

## Example Usage

```typescript
import { CreateProjectLatestDeployments } from "@vercel/sdk/models/operations/createproject.js";

let value: CreateProjectLatestDeployments = {
  id: "<id>",
  createdAt: 968.04,
  createdIn: "<value>",
  creator: {
    email: "Lane35@yahoo.com",
    uid: "<id>",
    username: "Louvenia76",
  },
  deploymentHostname: "<value>",
  name: "<value>",
  plan: "enterprise",
  previewCommentsEnabled: false,
  private: false,
  readyState: "BUILDING",
  type: "LAMBDAS",
  url: "https://excellent-hospitalization.name/",
  userId: "<id>",
};
```

## Fields

| Field                                                                                                              | Type                                                                                                               | Required                                                                                                           | Description                                                                                                        | Example                                                                                                            |
| ------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------ |
| `id`                                                                                                               | *string*                                                                                                           | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `alias`                                                                                                            | *string*[]                                                                                                         | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `aliasAssigned`                                                                                                    | *operations.CreateProjectAliasAssigned*                                                                            | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `aliasError`                                                                                                       | [operations.CreateProjectAliasError](../../models/operations/createprojectaliaserror.md)                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `aliasFinal`                                                                                                       | *string*                                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `automaticAliases`                                                                                                 | *string*[]                                                                                                         | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `branchMatcher`                                                                                                    | [operations.CreateProjectBranchMatcher](../../models/operations/createprojectbranchmatcher.md)                     | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `buildingAt`                                                                                                       | *number*                                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `builds`                                                                                                           | [operations.CreateProjectBuilds](../../models/operations/createprojectbuilds.md)[]                                 | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `checksConclusion`                                                                                                 | [operations.CreateProjectChecksConclusion](../../models/operations/createprojectchecksconclusion.md)               | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `checksState`                                                                                                      | [operations.CreateProjectChecksState](../../models/operations/createprojectchecksstate.md)                         | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `connectBuildsEnabled`                                                                                             | *boolean*                                                                                                          | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `connectConfigurationId`                                                                                           | *string*                                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `createdAt`                                                                                                        | *number*                                                                                                           | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `createdIn`                                                                                                        | *string*                                                                                                           | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `creator`                                                                                                          | [operations.CreateProjectCreator](../../models/operations/createprojectcreator.md)                                 | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `deletedAt`                                                                                                        | *number*                                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `deploymentHostname`                                                                                               | *string*                                                                                                           | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `forced`                                                                                                           | *boolean*                                                                                                          | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `name`                                                                                                             | *string*                                                                                                           | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `meta`                                                                                                             | Record<string, *string*>                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `monorepoManager`                                                                                                  | *string*                                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `oidcTokenClaims`                                                                                                  | [operations.CreateProjectOidcTokenClaims](../../models/operations/createprojectoidctokenclaims.md)                 | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `plan`                                                                                                             | [operations.CreateProjectPlan](../../models/operations/createprojectplan.md)                                       | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `previewCommentsEnabled`                                                                                           | *boolean*                                                                                                          | :heavy_minus_sign:                                                                                                 | Whether or not preview comments are enabled for the deployment                                                     | false                                                                                                              |
| `private`                                                                                                          | *boolean*                                                                                                          | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `readyAt`                                                                                                          | *number*                                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `readyState`                                                                                                       | [operations.CreateProjectReadyState](../../models/operations/createprojectreadystate.md)                           | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `readySubstate`                                                                                                    | [operations.CreateProjectReadySubstate](../../models/operations/createprojectreadysubstate.md)                     | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `requestedAt`                                                                                                      | *number*                                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `target`                                                                                                           | *string*                                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `teamId`                                                                                                           | *string*                                                                                                           | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `type`                                                                                                             | [operations.CreateProjectProjectsResponse200Type](../../models/operations/createprojectprojectsresponse200type.md) | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `url`                                                                                                              | *string*                                                                                                           | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `userId`                                                                                                           | *string*                                                                                                           | :heavy_check_mark:                                                                                                 | N/A                                                                                                                |                                                                                                                    |
| `withCache`                                                                                                        | *boolean*                                                                                                          | :heavy_minus_sign:                                                                                                 | N/A                                                                                                                |                                                                                                                    |