# CreateLogDrainRequestBody

## Example Usage

```typescript
import { CreateLogDrainRequestBody } from "@vercel/sdk/models/operations/createlogdrain.js";

let value: CreateLogDrainRequestBody = {
  name: "My first log drain",
  secret: "a1Xsfd325fXcs",
  deliveryFormat: "json",
  url: "https://example.com/log-drain",
};
```

## Fields

| Field                                                                                                                                                                         | Type                                                                                                                                                                          | Required                                                                                                                                                                      | Description                                                                                                                                                                   | Example                                                                                                                                                                       |
| ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `name`                                                                                                                                                                        | *string*                                                                                                                                                                      | :heavy_check_mark:                                                                                                                                                            | The name of the log drain                                                                                                                                                     | My first log drain                                                                                                                                                            |
| `projectIds`                                                                                                                                                                  | *string*[]                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                            | N/A                                                                                                                                                                           |                                                                                                                                                                               |
| `secret`                                                                                                                                                                      | *string*                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                            | A secret to sign log drain notification headers so a consumer can verify their authenticity                                                                                   | a1Xsfd325fXcs                                                                                                                                                                 |
| `deliveryFormat`                                                                                                                                                              | [operations.DeliveryFormat](../../models/operations/deliveryformat.md)                                                                                                        | :heavy_minus_sign:                                                                                                                                                            | The delivery log format                                                                                                                                                       | json                                                                                                                                                                          |
| `url`                                                                                                                                                                         | *string*                                                                                                                                                                      | :heavy_check_mark:                                                                                                                                                            | The url where you will receive logs. The protocol must be `https://` or `http://` when type is `json` and `ndjson`, and `syslog+tls:` or `syslog:` when the type is `syslog`. | https://example.com/log-drain                                                                                                                                                 |
| `sources`                                                                                                                                                                     | [operations.Sources](../../models/operations/sources.md)[]                                                                                                                    | :heavy_minus_sign:                                                                                                                                                            | N/A                                                                                                                                                                           |                                                                                                                                                                               |
| `headers`                                                                                                                                                                     | Record<string, *string*>                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                            | Headers to be sent together with the request                                                                                                                                  |                                                                                                                                                                               |
| `environments`                                                                                                                                                                | [operations.Environments](../../models/operations/environments.md)[]                                                                                                          | :heavy_minus_sign:                                                                                                                                                            | N/A                                                                                                                                                                           |                                                                                                                                                                               |