# CreateDeploymentResponseBody

The successfully created deployment

## Example Usage

```typescript
import { CreateDeploymentResponseBody } from "@vercel/sdk/models/operations/createdeployment.js";

let value: CreateDeploymentResponseBody = {
  build: {
    env: [
      "<value>",
    ],
  },
  env: [
    "<value>",
  ],
  inspectorUrl: "https://blue-bidet.info",
  isInConcurrentBuildsQueue: false,
  isInSystemBuildsQueue: false,
  projectSettings: {},
  aliasAssigned: false,
  bootedAt: 7665.91,
  buildingAt: 6886.83,
  buildSkipped: false,
  creator: {
    uid: "<id>",
  },
  public: false,
  status: "INITIALIZING",
  type: "LAMBDAS",
  createdAt: 7672.10,
  name: "<value>",
  id: "<id>",
  version: 2871.53,
  meta: {
    "key": "<value>",
  },
  readyState: "BUILDING",
  regions: [
    "<value>",
  ],
  url: "https://showy-vanadyl.biz",
  projectId: "<id>",
  ownerId: "<id>",
  routes: [
    {
      src: "<value>",
      continue: false,
      middleware: 6599.71,
    },
  ],
  plan: "enterprise",
  createdIn: "<value>",
};
```

## Fields

| Field                                                                                                                                                                                                                       | Type                                                                                                                                                                                                                        | Required                                                                                                                                                                                                                    | Description                                                                                                                                                                                                                 |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `aliasAssignedAt`                                                                                                                                                                                                           | *operations.AliasAssignedAt*                                                                                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `alwaysRefuseToBuild`                                                                                                                                                                                                       | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `build`                                                                                                                                                                                                                     | [operations.Build](../../models/operations/build.md)                                                                                                                                                                        | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildArtifactUrls`                                                                                                                                                                                                         | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `builds`                                                                                                                                                                                                                    | [operations.Builds](../../models/operations/builds.md)[]                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `env`                                                                                                                                                                                                                       | *string*[]                                                                                                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `inspectorUrl`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `isInConcurrentBuildsQueue`                                                                                                                                                                                                 | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `isInSystemBuildsQueue`                                                                                                                                                                                                     | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `projectSettings`                                                                                                                                                                                                           | [operations.CreateDeploymentProjectSettings](../../models/operations/createdeploymentprojectsettings.md)                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `readyStateReason`                                                                                                                                                                                                          | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `integrations`                                                                                                                                                                                                              | [operations.Integrations](../../models/operations/integrations.md)                                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `alias`                                                                                                                                                                                                                     | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasAssigned`                                                                                                                                                                                                             | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `bootedAt`                                                                                                                                                                                                                  | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildingAt`                                                                                                                                                                                                                | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildSkipped`                                                                                                                                                                                                              | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `creator`                                                                                                                                                                                                                   | [operations.Creator](../../models/operations/creator.md)                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `initReadyAt`                                                                                                                                                                                                               | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `isFirstBranchDeployment`                                                                                                                                                                                                   | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `lambdas`                                                                                                                                                                                                                   | [operations.Lambdas](../../models/operations/lambdas.md)[]                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `public`                                                                                                                                                                                                                    | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `ready`                                                                                                                                                                                                                     | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `status`                                                                                                                                                                                                                    | [operations.CreateDeploymentStatus](../../models/operations/createdeploymentstatus.md)                                                                                                                                      | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `team`                                                                                                                                                                                                                      | [operations.Team](../../models/operations/team.md)                                                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `userAliases`                                                                                                                                                                                                               | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `previewCommentsEnabled`                                                                                                                                                                                                    | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `ttyBuildLogs`                                                                                                                                                                                                              | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `customEnvironment`                                                                                                                                                                                                         | *operations.CustomEnvironment*                                                                                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `type`                                                                                                                                                                                                                      | [operations.CreateDeploymentType](../../models/operations/createdeploymenttype.md)                                                                                                                                          | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `createdAt`                                                                                                                                                                                                                 | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `name`                                                                                                                                                                                                                      | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `deletedAt`                                                                                                                                                                                                                 | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `id`                                                                                                                                                                                                                        | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `version`                                                                                                                                                                                                                   | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `autoAssignCustomDomains`                                                                                                                                                                                                   | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | applies to custom domains only, defaults to `true`                                                                                                                                                                          |
| `gitSource`                                                                                                                                                                                                                 | *operations.CreateDeploymentGitSource*                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `meta`                                                                                                                                                                                                                      | Record<string, *string*>                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `project`                                                                                                                                                                                                                   | [operations.Project](../../models/operations/project.md)                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `readyState`                                                                                                                                                                                                                | [operations.ReadyState](../../models/operations/readystate.md)                                                                                                                                                              | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `source`                                                                                                                                                                                                                    | [operations.CreateDeploymentSource](../../models/operations/createdeploymentsource.md)                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `target`                                                                                                                                                                                                                    | [operations.CreateDeploymentTarget](../../models/operations/createdeploymenttarget.md)                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `passiveRegions`                                                                                                                                                                                                            | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | Since November 2023 this field defines a set of regions that we will deploy the lambda to passively Lambdas will be deployed to these regions but only invoked if all of the primary `regions` are marked as out of service |
| `regions`                                                                                                                                                                                                                   | *string*[]                                                                                                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorMessage`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasWarning`                                                                                                                                                                                                              | [operations.AliasWarning](../../models/operations/aliaswarning.md)                                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasError`                                                                                                                                                                                                                | [operations.AliasError](../../models/operations/aliaserror.md)                                                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasFinal`                                                                                                                                                                                                                | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `automaticAliases`                                                                                                                                                                                                          | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildErrorAt`                                                                                                                                                                                                              | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `checksState`                                                                                                                                                                                                               | [operations.ChecksState](../../models/operations/checksstate.md)                                                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `checksConclusion`                                                                                                                                                                                                          | [operations.ChecksConclusion](../../models/operations/checksconclusion.md)                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `defaultRoute`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | Computed field that is only available for deployments with a micro-frontend configuration.                                                                                                                                  |
| `canceledAt`                                                                                                                                                                                                                | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorCode`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorLink`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorStep`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `readySubstate`                                                                                                                                                                                                             | [operations.ReadySubstate](../../models/operations/readysubstate.md)                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                                          | Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic             |
| `softDeletedByRetention`                                                                                                                                                                                                    | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `undeletedAt`                                                                                                                                                                                                               | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `url`                                                                                                                                                                                                                       | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `oidcTokenClaims`                                                                                                                                                                                                           | [operations.OidcTokenClaims](../../models/operations/oidctokenclaims.md)                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `projectId`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `ownerId`                                                                                                                                                                                                                   | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `monorepoManager`                                                                                                                                                                                                           | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `functions`                                                                                                                                                                                                                 | Record<string, [operations.Functions](../../models/operations/functions.md)>                                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `routes`                                                                                                                                                                                                                    | *operations.Routes*[]                                                                                                                                                                                                       | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `crons`                                                                                                                                                                                                                     | [operations.CreateDeploymentCrons](../../models/operations/createdeploymentcrons.md)[]                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `plan`                                                                                                                                                                                                                      | [operations.Plan](../../models/operations/plan.md)                                                                                                                                                                          | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `connectBuildsEnabled`                                                                                                                                                                                                      | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `connectConfigurationId`                                                                                                                                                                                                    | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `createdIn`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `passiveConnectConfigurationId`                                                                                                                                                                                             | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | Since November 2023 this field defines a Secure Compute network that will only be used to deploy passive lambdas to (as in passiveRegions)                                                                                  |
| `gitRepo`                                                                                                                                                                                                                   | *operations.GitRepo*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `flags`                                                                                                                                                                                                                     | *operations.Flags*                                                                                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |