# CreateDeploymentRequestBody

## Example Usage

```typescript
import { CreateDeploymentRequestBody } from "@vercel/sdk/models/operations/createdeployment.js";

let value: CreateDeploymentRequestBody = {
  files: [
    {
      file: "folder/file.js",
    },
  ],
  gitMetadata: {
    remoteUrl: "https://github.com/vercel/next.js",
    commitAuthorName: "kyliau",
    commitMessage:
      "add method to measure Interaction to Next Paint (INP) (#36490)",
    commitRef: "main",
    commitSha: "dc36199b2234c6586ebe05ec94078a895c707e29",
    dirty: true,
  },
  meta: {
    "foo": "bar",
  },
  name: "my-instant-deployment",
  project: "my-deployment-project",
};
```

## Fields

| Field                                                                                                                                                                                                                                                  | Type                                                                                                                                                                                                                                                   | Required                                                                                                                                                                                                                                               | Description                                                                                                                                                                                                                                            | Example                                                                                                                                                                                                                                                |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `deploymentId`                                                                                                                                                                                                                                         | *string*                                                                                                                                                                                                                                               | :heavy_minus_sign:                                                                                                                                                                                                                                     | An deployment id for an existing deployment to redeploy                                                                                                                                                                                                |                                                                                                                                                                                                                                                        |
| `files`                                                                                                                                                                                                                                                | *operations.Files*[]                                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                                                     | A list of objects with the files to be deployed                                                                                                                                                                                                        |                                                                                                                                                                                                                                                        |
| `gitMetadata`                                                                                                                                                                                                                                          | [operations.GitMetadata](../../models/operations/gitmetadata.md)                                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                                                                                                     | Populates initial git metadata for different git providers.                                                                                                                                                                                            |                                                                                                                                                                                                                                                        |
| `gitSource`                                                                                                                                                                                                                                            | *operations.GitSource*                                                                                                                                                                                                                                 | :heavy_minus_sign:                                                                                                                                                                                                                                     | Defines the Git Repository source to be deployed. This property can not be used in combination with `files`.                                                                                                                                           |                                                                                                                                                                                                                                                        |
| `meta`                                                                                                                                                                                                                                                 | Record<string, *string*>                                                                                                                                                                                                                               | :heavy_minus_sign:                                                                                                                                                                                                                                     | An object containing the deployment's metadata. Multiple key-value pairs can be attached to a deployment                                                                                                                                               | {<br/>"foo": "bar"<br/>}                                                                                                                                                                                                                               |
| `monorepoManager`                                                                                                                                                                                                                                      | *string*                                                                                                                                                                                                                                               | :heavy_minus_sign:                                                                                                                                                                                                                                     | The monorepo manager that is being used for this deployment. When `null` is used no monorepo manager is selected                                                                                                                                       |                                                                                                                                                                                                                                                        |
| `name`                                                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                     | A string with the project name used in the deployment URL                                                                                                                                                                                              | my-instant-deployment                                                                                                                                                                                                                                  |
| `project`                                                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                                               | :heavy_minus_sign:                                                                                                                                                                                                                                     | The target project identifier in which the deployment will be created. When defined, this parameter overrides name                                                                                                                                     | my-deployment-project                                                                                                                                                                                                                                  |
| `projectSettings`                                                                                                                                                                                                                                      | [operations.ProjectSettings](../../models/operations/projectsettings.md)                                                                                                                                                                               | :heavy_minus_sign:                                                                                                                                                                                                                                     | Project settings that will be applied to the deployment. It is required for the first deployment of a project and will be saved for any following deployments                                                                                          |                                                                                                                                                                                                                                                        |
| `target`                                                                                                                                                                                                                                               | [operations.Target](../../models/operations/target.md)                                                                                                                                                                                                 | :heavy_minus_sign:                                                                                                                                                                                                                                     | Either not defined, `staging`, or `production`. If `staging`, a staging alias in the format `<project>-<team>.vercel.app` will be assigned. If `production`, any aliases defined in `alias` will be assigned. If omitted, the target will be `preview` |                                                                                                                                                                                                                                                        |
| `withLatestCommit`                                                                                                                                                                                                                                     | *boolean*                                                                                                                                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                                                     | When `true` and `deploymentId` is passed in, the sha from the previous deployment's `gitSource` is removed forcing the latest commit to be used.                                                                                                       |                                                                                                                                                                                                                                                        |