# CreateConfigurableLogDrainResponseBody

## Example Usage

```typescript
import { CreateConfigurableLogDrainResponseBody } from "@vercel/sdk/models/operations/createconfigurablelogdrain.js";

let value: CreateConfigurableLogDrainResponseBody = {
  id: "<id>",
  deliveryFormat: "ndjson",
  url: "https://pessimistic-euphonium.name/",
  name: "<value>",
  ownerId: "<id>",
  createdAt: 1696.78,
  deletedAt: 1594.69,
  updatedAt: 4170.30,
  environments: [
    "production",
  ],
};
```

## Fields

| Field                                                                                                                                        | Type                                                                                                                                         | Required                                                                                                                                     | Description                                                                                                                                  |
| -------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------- |
| `secret`                                                                                                                                     | *string*                                                                                                                                     | :heavy_minus_sign:                                                                                                                           | The secret to validate the log-drain payload                                                                                                 |
| `id`                                                                                                                                         | *string*                                                                                                                                     | :heavy_check_mark:                                                                                                                           | N/A                                                                                                                                          |
| `deliveryFormat`                                                                                                                             | [operations.CreateConfigurableLogDrainLogDrainsDeliveryFormat](../../models/operations/createconfigurablelogdrainlogdrainsdeliveryformat.md) | :heavy_check_mark:                                                                                                                           | N/A                                                                                                                                          |
| `url`                                                                                                                                        | *string*                                                                                                                                     | :heavy_check_mark:                                                                                                                           | N/A                                                                                                                                          |
| `name`                                                                                                                                       | *string*                                                                                                                                     | :heavy_check_mark:                                                                                                                           | N/A                                                                                                                                          |
| `clientId`                                                                                                                                   | *string*                                                                                                                                     | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `configurationId`                                                                                                                            | *string*                                                                                                                                     | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `teamId`                                                                                                                                     | *string*                                                                                                                                     | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `ownerId`                                                                                                                                    | *string*                                                                                                                                     | :heavy_check_mark:                                                                                                                           | N/A                                                                                                                                          |
| `projectIds`                                                                                                                                 | *string*[]                                                                                                                                   | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `createdAt`                                                                                                                                  | *number*                                                                                                                                     | :heavy_check_mark:                                                                                                                           | N/A                                                                                                                                          |
| `deletedAt`                                                                                                                                  | *number*                                                                                                                                     | :heavy_check_mark:                                                                                                                           | N/A                                                                                                                                          |
| `updatedAt`                                                                                                                                  | *number*                                                                                                                                     | :heavy_check_mark:                                                                                                                           | N/A                                                                                                                                          |
| `sources`                                                                                                                                    | [operations.CreateConfigurableLogDrainLogDrainsSources](../../models/operations/createconfigurablelogdrainlogdrainssources.md)[]             | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `headers`                                                                                                                                    | Record<string, *string*>                                                                                                                     | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `environments`                                                                                                                               | [operations.CreateConfigurableLogDrainLogDrainsEnvironments](../../models/operations/createconfigurablelogdrainlogdrainsenvironments.md)[]   | :heavy_check_mark:                                                                                                                           | N/A                                                                                                                                          |
| `status`                                                                                                                                     | [operations.CreateConfigurableLogDrainStatus](../../models/operations/createconfigurablelogdrainstatus.md)                                   | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `disabledAt`                                                                                                                                 | *number*                                                                                                                                     | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `disabledReason`                                                                                                                             | [operations.CreateConfigurableLogDrainDisabledReason](../../models/operations/createconfigurablelogdraindisabledreason.md)                   | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `disabledBy`                                                                                                                                 | *string*                                                                                                                                     | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `firstErrorTimestamp`                                                                                                                        | *number*                                                                                                                                     | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `samplingRate`                                                                                                                               | *number*                                                                                                                                     | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `hideIpAddresses`                                                                                                                            | *boolean*                                                                                                                                    | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |
| `createdFrom`                                                                                                                                | [operations.CreateConfigurableLogDrainCreatedFrom](../../models/operations/createconfigurablelogdraincreatedfrom.md)                         | :heavy_minus_sign:                                                                                                                           | N/A                                                                                                                                          |