# CreateConfigurableLogDrainRequestBody

## Example Usage

```typescript
import { CreateConfigurableLogDrainRequestBody } from "@vercel/sdk/models/operations/createconfigurablelogdrain.js";

let value: CreateConfigurableLogDrainRequestBody = {
  deliveryFormat: "json",
  url: "https://pointed-tenement.biz/",
  sources: [
    "firewall",
  ],
};
```

## Fields

| Field                                                                                                                      | Type                                                                                                                       | Required                                                                                                                   | Description                                                                                                                | Example                                                                                                                    |
| -------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------- |
| `deliveryFormat`                                                                                                           | [operations.CreateConfigurableLogDrainDeliveryFormat](../../models/operations/createconfigurablelogdraindeliveryformat.md) | :heavy_check_mark:                                                                                                         | The delivery log format                                                                                                    | json                                                                                                                       |
| `url`                                                                                                                      | *string*                                                                                                                   | :heavy_check_mark:                                                                                                         | The log drain url                                                                                                          |                                                                                                                            |
| `headers`                                                                                                                  | Record<string, *string*>                                                                                                   | :heavy_minus_sign:                                                                                                         | Headers to be sent together with the request                                                                               |                                                                                                                            |
| `projectIds`                                                                                                               | *string*[]                                                                                                                 | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |                                                                                                                            |
| `sources`                                                                                                                  | [operations.CreateConfigurableLogDrainSources](../../models/operations/createconfigurablelogdrainsources.md)[]             | :heavy_check_mark:                                                                                                         | N/A                                                                                                                        |                                                                                                                            |
| `environments`                                                                                                             | [operations.CreateConfigurableLogDrainEnvironments](../../models/operations/createconfigurablelogdrainenvironments.md)[]   | :heavy_minus_sign:                                                                                                         | N/A                                                                                                                        |                                                                                                                            |
| `secret`                                                                                                                   | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | Custom secret of log drain                                                                                                 |                                                                                                                            |
| `samplingRate`                                                                                                             | *number*                                                                                                                   | :heavy_minus_sign:                                                                                                         | The sampling rate for this log drain. It should be a percentage rate between 0 and 100. With max 2 decimal points          |                                                                                                                            |
| `name`                                                                                                                     | *string*                                                                                                                   | :heavy_minus_sign:                                                                                                         | The custom name of this log drain.                                                                                         |                                                                                                                            |