# CancelDeploymentResponseBody

The private deployment representation of a Deployment.

## Example Usage

```typescript
import { CancelDeploymentResponseBody } from "@vercel/sdk/models/operations/canceldeployment.js";

let value: CancelDeploymentResponseBody = {
  build: {
    env: [
      "<value>",
    ],
  },
  env: [
    "<value>",
  ],
  inspectorUrl: "https://lost-swine.org",
  isInConcurrentBuildsQueue: false,
  isInSystemBuildsQueue: false,
  projectSettings: {},
  aliasAssigned: false,
  bootedAt: 2715.51,
  buildingAt: 6075.45,
  buildSkipped: false,
  creator: {
    uid: "<id>",
  },
  public: false,
  status: "QUEUED",
  id: "<id>",
  createdAt: 5379.46,
  name: "<value>",
  meta: {
    "key": "<value>",
  },
  readyState: "CANCELED",
  regions: [
    "<value>",
  ],
  type: "LAMBDAS",
  url: "https://worthless-tentacle.info/",
  version: 8174.53,
  createdIn: "<value>",
  ownerId: "<id>",
  plan: "hobby",
  projectId: "<id>",
  routes: [
    {
      src: "<value>",
      continue: false,
      middleware: 3198.34,
    },
  ],
};
```

## Fields

| Field                                                                                                                                                                                                                       | Type                                                                                                                                                                                                                        | Required                                                                                                                                                                                                                    | Description                                                                                                                                                                                                                 |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `aliasAssignedAt`                                                                                                                                                                                                           | *operations.CancelDeploymentAliasAssignedAt*                                                                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `alwaysRefuseToBuild`                                                                                                                                                                                                       | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `build`                                                                                                                                                                                                                     | [operations.CancelDeploymentBuild](../../models/operations/canceldeploymentbuild.md)                                                                                                                                        | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildArtifactUrls`                                                                                                                                                                                                         | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `builds`                                                                                                                                                                                                                    | [operations.CancelDeploymentBuilds](../../models/operations/canceldeploymentbuilds.md)[]                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `env`                                                                                                                                                                                                                       | *string*[]                                                                                                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `inspectorUrl`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `isInConcurrentBuildsQueue`                                                                                                                                                                                                 | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `isInSystemBuildsQueue`                                                                                                                                                                                                     | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `projectSettings`                                                                                                                                                                                                           | [operations.CancelDeploymentProjectSettings](../../models/operations/canceldeploymentprojectsettings.md)                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `readyStateReason`                                                                                                                                                                                                          | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `integrations`                                                                                                                                                                                                              | [operations.CancelDeploymentIntegrations](../../models/operations/canceldeploymentintegrations.md)                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `alias`                                                                                                                                                                                                                     | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasAssigned`                                                                                                                                                                                                             | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `bootedAt`                                                                                                                                                                                                                  | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildingAt`                                                                                                                                                                                                                | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildSkipped`                                                                                                                                                                                                              | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `creator`                                                                                                                                                                                                                   | [operations.CancelDeploymentCreator](../../models/operations/canceldeploymentcreator.md)                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `initReadyAt`                                                                                                                                                                                                               | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `isFirstBranchDeployment`                                                                                                                                                                                                   | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `lambdas`                                                                                                                                                                                                                   | [operations.CancelDeploymentLambdas](../../models/operations/canceldeploymentlambdas.md)[]                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `public`                                                                                                                                                                                                                    | *boolean*                                                                                                                                                                                                                   | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `ready`                                                                                                                                                                                                                     | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `status`                                                                                                                                                                                                                    | [operations.CancelDeploymentStatus](../../models/operations/canceldeploymentstatus.md)                                                                                                                                      | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `team`                                                                                                                                                                                                                      | [operations.CancelDeploymentTeam](../../models/operations/canceldeploymentteam.md)                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `userAliases`                                                                                                                                                                                                               | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `previewCommentsEnabled`                                                                                                                                                                                                    | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `ttyBuildLogs`                                                                                                                                                                                                              | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `customEnvironment`                                                                                                                                                                                                         | *operations.CancelDeploymentCustomEnvironment*                                                                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `id`                                                                                                                                                                                                                        | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasError`                                                                                                                                                                                                                | [operations.CancelDeploymentAliasError](../../models/operations/canceldeploymentaliaserror.md)                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasFinal`                                                                                                                                                                                                                | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `aliasWarning`                                                                                                                                                                                                              | [operations.CancelDeploymentAliasWarning](../../models/operations/canceldeploymentaliaswarning.md)                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `autoAssignCustomDomains`                                                                                                                                                                                                   | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | applies to custom domains only, defaults to `true`                                                                                                                                                                          |
| `automaticAliases`                                                                                                                                                                                                          | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `buildErrorAt`                                                                                                                                                                                                              | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `checksState`                                                                                                                                                                                                               | [operations.CancelDeploymentChecksState](../../models/operations/canceldeploymentchecksstate.md)                                                                                                                            | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `checksConclusion`                                                                                                                                                                                                          | [operations.CancelDeploymentChecksConclusion](../../models/operations/canceldeploymentchecksconclusion.md)                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `createdAt`                                                                                                                                                                                                                 | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `deletedAt`                                                                                                                                                                                                                 | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `defaultRoute`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | Computed field that is only available for deployments with a micro-frontend configuration.                                                                                                                                  |
| `canceledAt`                                                                                                                                                                                                                | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorCode`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorLink`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorMessage`                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `errorStep`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `passiveRegions`                                                                                                                                                                                                            | *string*[]                                                                                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                                          | Since November 2023 this field defines a set of regions that we will deploy the lambda to passively Lambdas will be deployed to these regions but only invoked if all of the primary `regions` are marked as out of service |
| `gitSource`                                                                                                                                                                                                                 | *operations.CancelDeploymentGitSource*                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `name`                                                                                                                                                                                                                      | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `meta`                                                                                                                                                                                                                      | Record<string, *string*>                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `project`                                                                                                                                                                                                                   | [operations.CancelDeploymentProject](../../models/operations/canceldeploymentproject.md)                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `readyState`                                                                                                                                                                                                                | [operations.CancelDeploymentReadyState](../../models/operations/canceldeploymentreadystate.md)                                                                                                                              | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `readySubstate`                                                                                                                                                                                                             | [operations.CancelDeploymentReadySubstate](../../models/operations/canceldeploymentreadysubstate.md)                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                                          | Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic             |
| `regions`                                                                                                                                                                                                                   | *string*[]                                                                                                                                                                                                                  | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `softDeletedByRetention`                                                                                                                                                                                                    | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `source`                                                                                                                                                                                                                    | [operations.CancelDeploymentSource](../../models/operations/canceldeploymentsource.md)                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `target`                                                                                                                                                                                                                    | [operations.CancelDeploymentTarget](../../models/operations/canceldeploymenttarget.md)                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `type`                                                                                                                                                                                                                      | [operations.CancelDeploymentType](../../models/operations/canceldeploymenttype.md)                                                                                                                                          | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `undeletedAt`                                                                                                                                                                                                               | *number*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `url`                                                                                                                                                                                                                       | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `version`                                                                                                                                                                                                                   | *number*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `oidcTokenClaims`                                                                                                                                                                                                           | [operations.CancelDeploymentOidcTokenClaims](../../models/operations/canceldeploymentoidctokenclaims.md)                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `connectBuildsEnabled`                                                                                                                                                                                                      | *boolean*                                                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `connectConfigurationId`                                                                                                                                                                                                    | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `createdIn`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `crons`                                                                                                                                                                                                                     | [operations.CancelDeploymentCrons](../../models/operations/canceldeploymentcrons.md)[]                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `functions`                                                                                                                                                                                                                 | Record<string, [operations.CancelDeploymentFunctions](../../models/operations/canceldeploymentfunctions.md)>                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `monorepoManager`                                                                                                                                                                                                           | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `ownerId`                                                                                                                                                                                                                   | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `passiveConnectConfigurationId`                                                                                                                                                                                             | *string*                                                                                                                                                                                                                    | :heavy_minus_sign:                                                                                                                                                                                                          | Since November 2023 this field defines a Secure Compute network that will only be used to deploy passive lambdas to (as in passiveRegions)                                                                                  |
| `plan`                                                                                                                                                                                                                      | [operations.CancelDeploymentPlan](../../models/operations/canceldeploymentplan.md)                                                                                                                                          | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `projectId`                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                    | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `routes`                                                                                                                                                                                                                    | *operations.CancelDeploymentRoutes*[]                                                                                                                                                                                       | :heavy_check_mark:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `gitRepo`                                                                                                                                                                                                                   | *operations.CancelDeploymentGitRepo*                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |
| `flags`                                                                                                                                                                                                                     | *operations.CancelDeploymentFlags*                                                                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                         |