# TeamLimited

A limited form of data representing a Team, due to the authentication token missing privileges to read the full Team data.

## Example Usage

```typescript
import { TeamLimited } from "@vercel/sdk/models/components/teamlimited.js";

let value: TeamLimited = {
  limited: false,
  saml: {
    connection: {
      type: "OktaSAML",
      status: "linked",
      state: "active",
      connectedAt: 1611796915677,
      lastReceivedWebhookEvent: 1611796915677,
    },
    directory: {
      type: "OktaSAML",
      state: "active",
      connectedAt: 1611796915677,
      lastReceivedWebhookEvent: 1611796915677,
    },
    enforced: false,
  },
  id: "team_nllPyCtREAqxxdyFKbbMDlxd",
  slug: "my-team",
  name: "My Team",
  avatar: "6eb07268bcfadd309905ffb1579354084c24655c",
  membership: {
    confirmed: false,
    confirmedAt: 3274.11,
    role: "VIEWER",
    createdAt: 3353.03,
    created: 1049.91,
  },
  created: "<value>",
  createdAt: 1630748523395,
};
```

## Fields

| Field                                                                                                                                                                                                                                                                                                  | Type                                                                                                                                                                                                                                                                                                   | Required                                                                                                                                                                                                                                                                                               | Description                                                                                                                                                                                                                                                                                            | Example                                                                                                                                                                                                                                                                                                |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `limited`                                                                                                                                                                                                                                                                                              | *boolean*                                                                                                                                                                                                                                                                                              | :heavy_check_mark:                                                                                                                                                                                                                                                                                     | Property indicating that this Team data contains only limited information, due to the authentication token missing privileges to read the full Team data. Re-login with the Team's configured SAML Single Sign-On provider in order to upgrade the authentication token with the necessary privileges. |                                                                                                                                                                                                                                                                                                        |
| `saml`                                                                                                                                                                                                                                                                                                 | [components.Saml](../../models/components/saml.md)                                                                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                                                                                                                     | When "Single Sign-On (SAML)" is configured, this object contains information that allows the client-side to identify whether or not this Team has SAML enforced.                                                                                                                                       |                                                                                                                                                                                                                                                                                                        |
| `id`                                                                                                                                                                                                                                                                                                   | *string*                                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                                     | The Team's unique identifier.                                                                                                                                                                                                                                                                          | team_nllPyCtREAqxxdyFKbbMDlxd                                                                                                                                                                                                                                                                          |
| `slug`                                                                                                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                                     | The Team's slug, which is unique across the Vercel platform.                                                                                                                                                                                                                                           | my-team                                                                                                                                                                                                                                                                                                |
| `name`                                                                                                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                                     | Name associated with the Team account, or `null` if none has been provided.                                                                                                                                                                                                                            | My Team                                                                                                                                                                                                                                                                                                |
| `avatar`                                                                                                                                                                                                                                                                                               | *string*                                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                                     | The ID of the file used as avatar for this Team.                                                                                                                                                                                                                                                       | 6eb07268bcfadd309905ffb1579354084c24655c                                                                                                                                                                                                                                                               |
| `membership`                                                                                                                                                                                                                                                                                           | [components.Membership](../../models/components/membership.md)                                                                                                                                                                                                                                         | :heavy_check_mark:                                                                                                                                                                                                                                                                                     | The membership of the authenticated User in relation to the Team.                                                                                                                                                                                                                                      |                                                                                                                                                                                                                                                                                                        |
| `created`                                                                                                                                                                                                                                                                                              | *string*                                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                                     | Will remain undocumented. Remove in v3 API.                                                                                                                                                                                                                                                            |                                                                                                                                                                                                                                                                                                        |
| `createdAt`                                                                                                                                                                                                                                                                                            | *number*                                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                                     | UNIX timestamp (in milliseconds) when the Team was created.                                                                                                                                                                                                                                            | 1630748523395                                                                                                                                                                                                                                                                                          |