# AuthUserLimited

A limited form of data for the currently authenticated User, due to the authentication token missing privileges to read the full User data.

## Example Usage

```typescript
import { AuthUserLimited } from "@vercel/sdk/models/components/authuserlimited.js";

let value: AuthUserLimited = {
  limited: false,
  id: "AEIIDYVk59zbFF2Sxfyxxmua",
  email: "me@example.com",
  name: "John Doe",
  username: "jdoe",
  avatar: "22cb30c85ff45ac4c72de8981500006b28114aa1",
  defaultTeamId: "<id>",
  version: "northstar",
};
```

## Fields

| Field                                                                                                                                                                                                                                                                                  | Type                                                                                                                                                                                                                                                                                   | Required                                                                                                                                                                                                                                                                               | Description                                                                                                                                                                                                                                                                            | Example                                                                                                                                                                                                                                                                                |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `limited`                                                                                                                                                                                                                                                                              | *boolean*                                                                                                                                                                                                                                                                              | :heavy_check_mark:                                                                                                                                                                                                                                                                     | Property indicating that this User data contains only limited information, due to the authentication token missing privileges to read the full User data. Re-login with email, GitHub, GitLab or Bitbucket in order to upgrade the authentication token with the necessary privileges. |                                                                                                                                                                                                                                                                                        |
| `id`                                                                                                                                                                                                                                                                                   | *string*                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                     | The User's unique identifier.                                                                                                                                                                                                                                                          | AEIIDYVk59zbFF2Sxfyxxmua                                                                                                                                                                                                                                                               |
| `email`                                                                                                                                                                                                                                                                                | *string*                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                     | Email address associated with the User account.                                                                                                                                                                                                                                        | me@example.com                                                                                                                                                                                                                                                                         |
| `name`                                                                                                                                                                                                                                                                                 | *string*                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                     | Name associated with the User account, or `null` if none has been provided.                                                                                                                                                                                                            | John Doe                                                                                                                                                                                                                                                                               |
| `username`                                                                                                                                                                                                                                                                             | *string*                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                     | Unique username associated with the User account.                                                                                                                                                                                                                                      | jdoe                                                                                                                                                                                                                                                                                   |
| `avatar`                                                                                                                                                                                                                                                                               | *string*                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                     | SHA1 hash of the avatar for the User account. Can be used in conjuction with the ... endpoint to retrieve the avatar image.                                                                                                                                                            | 22cb30c85ff45ac4c72de8981500006b28114aa1                                                                                                                                                                                                                                               |
| `defaultTeamId`                                                                                                                                                                                                                                                                        | *string*                                                                                                                                                                                                                                                                               | :heavy_check_mark:                                                                                                                                                                                                                                                                     | The user's default team. Only applies if the user's `version` is `'northstar'`.                                                                                                                                                                                                        |                                                                                                                                                                                                                                                                                        |
| `version`                                                                                                                                                                                                                                                                              | [components.AuthUserLimitedVersion](../../models/components/authuserlimitedversion.md)                                                                                                                                                                                                 | :heavy_check_mark:                                                                                                                                                                                                                                                                     | The user's version. Will either be unset or `northstar`.                                                                                                                                                                                                                               |                                                                                                                                                                                                                                                                                        |