# AuthUser

Data for the currently authenticated User.

## Example Usage

```typescript
import { AuthUser } from "@vercel/sdk/models/components/authuser.js";

let value: AuthUser = {
  createdAt: 1630748523395,
  softBlock: {
    blockedAt: 1863.04,
    reason: "BLOCKED_FOR_PLATFORM_ABUSE",
  },
  billing: {},
  resourceConfig: {},
  stagingPrefix: "<value>",
  hasTrialAvailable: false,
  id: "AEIIDYVk59zbFF2Sxfyxxmua",
  email: "me@example.com",
  name: "John Doe",
  username: "jdoe",
  avatar: "22cb30c85ff45ac4c72de8981500006b28114aa1",
  defaultTeamId: "<id>",
  version: "northstar",
};
```

## Fields

| Field                                                                                                                                            | Type                                                                                                                                             | Required                                                                                                                                         | Description                                                                                                                                      | Example                                                                                                                                          |
| ------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------ |
| `createdAt`                                                                                                                                      | *number*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | UNIX timestamp (in milliseconds) when the User account was created.                                                                              | 1630748523395                                                                                                                                    |
| `softBlock`                                                                                                                                      | [components.SoftBlock](../../models/components/softblock.md)                                                                                     | :heavy_check_mark:                                                                                                                               | When the User account has been "soft blocked", this property will contain the date when the restriction was enacted, and the identifier for why. |                                                                                                                                                  |
| `billing`                                                                                                                                        | [components.Billing](../../models/components/billing.md)                                                                                         | :heavy_check_mark:                                                                                                                               | An object containing billing infomation associated with the User account.                                                                        |                                                                                                                                                  |
| `resourceConfig`                                                                                                                                 | [components.ResourceConfig](../../models/components/resourceconfig.md)                                                                           | :heavy_check_mark:                                                                                                                               | An object containing infomation related to the amount of platform resources may be allocated to the User account.                                |                                                                                                                                                  |
| `stagingPrefix`                                                                                                                                  | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | Prefix that will be used in the URL of "Preview" deployments created by the User account.                                                        |                                                                                                                                                  |
| `activeDashboardViews`                                                                                                                           | [components.ActiveDashboardViews](../../models/components/activedashboardviews.md)[]                                                             | :heavy_minus_sign:                                                                                                                               | set of dashboard view preferences (cards or list) per scopeId                                                                                    |                                                                                                                                                  |
| `importFlowGitNamespace`                                                                                                                         | *components.ImportFlowGitNamespace*                                                                                                              | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `importFlowGitNamespaceId`                                                                                                                       | *components.ImportFlowGitNamespaceId*                                                                                                            | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `importFlowGitProvider`                                                                                                                          | [components.ImportFlowGitProvider](../../models/components/importflowgitprovider.md)                                                             | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `preferredScopesAndGitNamespaces`                                                                                                                | [components.PreferredScopesAndGitNamespaces](../../models/components/preferredscopesandgitnamespaces.md)[]                                       | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `dismissedToasts`                                                                                                                                | [components.DismissedToasts](../../models/components/dismissedtoasts.md)[]                                                                       | :heavy_minus_sign:                                                                                                                               | A record of when, under a certain scopeId, a toast was dismissed                                                                                 |                                                                                                                                                  |
| `favoriteProjectsAndSpaces`                                                                                                                      | *components.FavoriteProjectsAndSpaces*[]                                                                                                         | :heavy_minus_sign:                                                                                                                               | A list of projects and spaces across teams that a user has marked as a favorite.                                                                 |                                                                                                                                                  |
| `hasTrialAvailable`                                                                                                                              | *boolean*                                                                                                                                        | :heavy_check_mark:                                                                                                                               | Whether the user has a trial available for a paid plan subscription.                                                                             |                                                                                                                                                  |
| `remoteCaching`                                                                                                                                  | [components.RemoteCaching](../../models/components/remotecaching.md)                                                                             | :heavy_minus_sign:                                                                                                                               | remote caching settings                                                                                                                          |                                                                                                                                                  |
| `dataCache`                                                                                                                                      | [components.DataCache](../../models/components/datacache.md)                                                                                     | :heavy_minus_sign:                                                                                                                               | data cache settings                                                                                                                              |                                                                                                                                                  |
| `featureBlocks`                                                                                                                                  | [components.FeatureBlocks](../../models/components/featureblocks.md)                                                                             | :heavy_minus_sign:                                                                                                                               | Feature blocks for the user                                                                                                                      |                                                                                                                                                  |
| `northstarMigration`                                                                                                                             | [components.NorthstarMigration](../../models/components/northstarmigration.md)                                                                   | :heavy_minus_sign:                                                                                                                               | N/A                                                                                                                                              |                                                                                                                                                  |
| `id`                                                                                                                                             | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | The User's unique identifier.                                                                                                                    | AEIIDYVk59zbFF2Sxfyxxmua                                                                                                                         |
| `email`                                                                                                                                          | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | Email address associated with the User account.                                                                                                  | me@example.com                                                                                                                                   |
| `name`                                                                                                                                           | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | Name associated with the User account, or `null` if none has been provided.                                                                      | John Doe                                                                                                                                         |
| `username`                                                                                                                                       | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | Unique username associated with the User account.                                                                                                | jdoe                                                                                                                                             |
| `avatar`                                                                                                                                         | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | SHA1 hash of the avatar for the User account. Can be used in conjuction with the ... endpoint to retrieve the avatar image.                      | 22cb30c85ff45ac4c72de8981500006b28114aa1                                                                                                         |
| `defaultTeamId`                                                                                                                                  | *string*                                                                                                                                         | :heavy_check_mark:                                                                                                                               | The user's default team. Only applies if the user's `version` is `'northstar'`.                                                                  |                                                                                                                                                  |
| `version`                                                                                                                                        | [components.Version](../../models/components/version.md)                                                                                         | :heavy_check_mark:                                                                                                                               | The user's version. Will either be unset or `northstar`.                                                                                         |                                                                                                                                                  |