// Demo store placeholders
const PLACEHOLDERS = {
  HEROS: [
    // primaryHero
    {
      heading: {value: 'All Mountain All Season'},
      byline: {
        value: 'The All New Hydrogen Snowboard Exclusively From Shopify',
      },
      cta: {value: 'Shop Now →'},
      handle: 'freestyle',
      spread: {
        reference: {
          mediaContentType: 'IMAGE',
          alt: 'Tracks in the snow leading to a person on a mountain top with a red jacket contrasting to an epic blue horizon with a mountain range in the distance.',
          previewImage: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Hydrogen_Hero_Feature_1.jpg?v=1654902468',
          },
          id: 'gid://shopify/MediaImage/29259478466616',
          image: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Hydrogen_Hero_Feature_1.jpg?v=1654902468',
            width: 2500,
            height: 3155,
          },
        },
      },
      spreadSecondary: {
        reference: {
          mediaContentType: 'IMAGE',
          alt: 'A snowboarder standing on a mountain top in choppy snow, shows off the back of his snowboard which reads Hydrogen in a cursive script.',
          previewImage: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Hydrogen_Hero_Feature_2.jpg?v=1654902468',
          },
          id: 'gid://shopify/MediaImage/29259478499384',
          image: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Hydrogen_Hero_Feature_2.jpg?v=1654902468',
            width: 2500,
            height: 3155,
          },
        },
      },
      height: 'full',
      top: true,
      loading: 'eager',
    },
    // secondaryHero
    {
      heading: {value: 'The Winter 2022 Collection'},
      byline: {value: 'Just Dropped'},
      cta: {value: 'Shop Now →'},
      handle: 'winter-2022',
      spread: {
        reference: {
          mediaContentType: 'IMAGE',
          alt: 'Three young women in snowboarding attire embracing and laughing while snow falls around them',
          previewImage: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Collection_Feature_Wide.jpg?v=1654902160',
          },
          id: 'gid://shopify/MediaImage/29259478302776',
          image: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Collection_Feature_Wide.jpg?v=1654902160',
            width: 5000,
            height: 2500,
          },
        },
      },
      spreadSecondary: null,
    },
    // tertiaryHero
    {
      heading: {value: 'From the Slopes to the Chalet'},
      byline: null,
      cta: {value: 'Shop Now →'},
      handle: 'backcountry',
      spread: {
        reference: {
          mediaContentType: 'IMAGE',
          alt: 'A skier hikes up a mountain through the snow with skis over their shoulder.',
          previewImage: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Chalet_Collection_Feature_1.jpg?v=1654902306',
          },
          id: 'gid://shopify/MediaImage/29259478368312',
          image: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Chalet_Collection_Feature_1.jpg?v=1654902306',
            width: 2500,
            height: 2500,
          },
        },
      },
      spreadSecondary: {
        reference: {
          mediaContentType: 'IMAGE',
          alt: 'A snow covered lodge is illuminated by lights at night with a dark starry sky and mountain backdrop.',
          previewImage: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Chalet_Collection_Feature_2.jpg?v=1654902306',
          },
          id: 'gid://shopify/MediaImage/29259478401080',
          image: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/files/Chalet_Collection_Feature_2.jpg?v=1654902306',
            width: 2500,
            height: 2500,
          },
        },
      },
    },
  ],
  PRODUCT_INFO: [
    {
      title: 'Description',
      content:
        'We threw snow tires on our core classics... Good for all year round! Named after my favorite football match of the year. Just like any of our joints, dress them up or down...',
    },
    {
      title: 'Size and Fit',
      content:
        'We threw snow tires on our core classics... Good for all year round! Named after my favorite football match of the year. Just like any of our joints, dress them up or down...',
    },
    {
      title: 'Delivery and Returns',
      content: `The towels had been hanging from the rod for years. They were stained and worn, and quite frankly, just plain ugly. Debra didn't want to touch them but she really didn't have a choice. It was important for her to see what was living within them. Patrick didn't want to go. The fact that she was insisting they must go made him want to go even less. He had no desire to make small talk with strangers he would never again see just to be polite. But she insisted that Patrick go, and she would soon find out that this would be the biggest mistake she could make in their relationship.`,
    },
  ],
  PRODUCT: {
    label: 'Limited Edition',
    id: 'gid://shopify/Product/6730850828344',
    title: 'The Hydrogen',
    publishedAt: '2021-06-17T18:33:17Z',
    handle: 'snowboard',
    description:
      "Description Our flagship board, ideal for technical terrain and those who dare to go where the chairlift can't take you. The Hydrogen excels in the backcountry making riding out of bounds as easy as resort groomers. New for 2021, the Hydrogen Snowboard has Oxygen Pack inserts giving you more float on the deepest days. Care Guide Clean well after use Wax regularly Specs Weight: 5 lb Length: 4 ft Width: 1 ft Manufactured on: 8/2/2021, 3:30:00 PM Manufactured by: Shopify",
    priceRange: {
      minVariantPrice: {
        amount: '775.0',
        currencyCode: 'CAD',
      },
      maxVariantPrice: {
        amount: '775.0',
        currencyCode: 'CAD',
      },
    },
    options: [
      {
        name: 'Color',
        values: ['Morning', 'Evening', 'Night'],
      },
      {
        name: 'Size',
        values: ['154', '158', '160'],
      },
    ],
    variants: {
      nodes: [
        {
          id: 'gid://shopify/ProductVariant/41007289630776',
          image: {
            url: 'https://cdn.shopify.com/s/files/1/0551/4566/0472/products/hydrogen-morning.jpg?v=1636146509',
            altText: 'The Hydrogen snowboard, color Morning',
            width: 1200,
            height: 1504,
          },
          priceV2: {
            amount: '775.0',
            currencyCode: 'CAD',
          },
          compareAtPriceV2: {
            amount: '840.0',
            currencyCode: 'CAD',
          },
        },
      ],
    },
  },
};

// Return placeholders for collection Heros when metafields are not set
export function getHeroPlaceholder(heros: any[]) {
  if (!heros?.length) return [];

  // when we pass a collection without metafields,
  // we merge it with placeholder data
  return heros.map((hero, index) => {
    // assume passed hero has metafields data already
    if (hero?.heading?.value) {
      return hero;
    }

    // hero placeholder
    const placeholder = PLACEHOLDERS.HEROS[index];

    // prioritize metafield data if available, else the hero hero values
    // otherwise the placeholder values
    const byLine =
      hero?.byLine || hero?.descriptionHtml
        ? {value: hero.descriptionHtml}
        : placeholder.byline;

    const heading =
      hero?.heading || hero?.title ? {value: hero.title} : placeholder.heading;

    // merge hero placeholder with hero data
    return {
      heading,
      byLine,
      cta: hero?.cta || placeholder.cta,
      handle: hero?.handle || placeholder.handle,
      id: hero?.id || index,
      spread: hero?.spread || placeholder.spread,
      spreadSecondary: hero?.spreadSecondary || placeholder.spreadSecondary,
      height: placeholder?.height || undefined,
      top: placeholder?.top || undefined,
    };
  });
}

// get product info placeholder data
export function getProductInfoPlaceholder() {
  function getMultipleRandom(arr: any[], infos: number) {
    const shuffled = [...arr].sort(() => 0.5 - Math.random());
    return shuffled.slice(0, infos);
  }
  return getMultipleRandom(PLACEHOLDERS.PRODUCT_INFO, 3);
}

export function getProductPlaceholder() {
  return PLACEHOLDERS.PRODUCT;
}
