/* eslint-disable */

try {
  Object.freeze({}).detectStrictMode = true;
} catch (error) {
  throw new Error(`The whole PnP file got strict-mode-ified, which is known to break (Emscripten libraries aren't strict mode). This usually happens when the file goes through Babel.`);
}

var __non_webpack_module__ = module;

function $$SETUP_STATE(hydrateRuntimeState, basePath) {
  return hydrateRuntimeState({
    "__info": [
      "This file is automatically generated. Do not touch it, or risk",
      "your modifications being lost. We also recommend you not to read",
      "it either without using the @yarnpkg/pnp package, as the data layout",
      "is entirely unspecified and WILL change from a version to another."
    ],
    "dependencyTreeRoots": [
    ],
    "enableTopLevelFallback": false,
    "ignorePatternData": null,
    "fallbackExclusionList": [
    ],
    "fallbackPool": [
    ],
    "locationBlacklistData": [
    ],
    "packageRegistryData": [
      [null, [
        [null, {
          "packageLocation": "./",
          "packageDependencies": [
            ["exeggcute", "1.0.0"],
            ["once", "1.4.0"]
          ],
        }]
      ]],
      ["exeggcute", [
        ["1.0.0", {
          "packageLocation": "./node_modules/.pnpm/exeggcute@1.0.0/node_modules/exeggcute",
          "packageDependencies": [
            ["exeggcute", "1.0.0"]
          ],
        }]
      ]],
      ["once", [
        ["1.4.0", {
          "packageLocation": "./node_modules/.pnpm/once@1.4.0/node_modules/once",
          "packageDependencies": [
            ["once", "1.4.0"],
            ["wrappy", "1.0.2"]
          ],
        }]
      ]],
      ["wrappy", [
        ["1.0.2", {
          "packageLocation": "./node_modules/.pnpm/wrappy@1.0.2/node_modules/wrappy",
          "packageDependencies": [
            ["wrappy", "1.0.2"]
          ],
        }]
      ]]
    ]
  }, {basePath: basePath || __dirname});
  }

(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["pnpHook"] = factory();
	else
		root["pnpHook"] = factory();
})(global, function() {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 936:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => /* binding */ _entryPoint
});

// EXTERNAL MODULE: external "fs"
var external_fs_ = __webpack_require__(747);
var external_fs_default = /*#__PURE__*/__webpack_require__.n(external_fs_);

// CONCATENATED MODULE: external "os"
const external_os_namespaceObject = require("os");;
var external_os_default = /*#__PURE__*/__webpack_require__.n(external_os_namespaceObject);

// EXTERNAL MODULE: external "path"
var external_path_ = __webpack_require__(622);
var external_path_default = /*#__PURE__*/__webpack_require__.n(external_path_);

// CONCATENATED MODULE: ../yarnpkg-fslib/sources/path.ts

var PathType;

(function (PathType) {
  PathType[PathType["File"] = 0] = "File";
  PathType[PathType["Portable"] = 1] = "Portable";
  PathType[PathType["Native"] = 2] = "Native";
})(PathType || (PathType = {}));

const PortablePath = {
  root: `/`,
  dot: `.`
};
const Filename = {
  nodeModules: `node_modules`,
  manifest: `package.json`,
  lockfile: `yarn.lock`,
  pnpJs: `.pnp.js`,
  rc: `.yarnrc.yml`
};
const npath = Object.create((external_path_default()));
const ppath = Object.create((external_path_default()).posix);

npath.cwd = () => process.cwd();

ppath.cwd = () => toPortablePath(process.cwd());

ppath.resolve = (...segments) => {
  if (segments.length > 0 && ppath.isAbsolute(segments[0])) {
    return external_path_default().posix.resolve(...segments);
  } else {
    return external_path_default().posix.resolve(ppath.cwd(), ...segments);
  }
};

const contains = function (pathUtils, from, to) {
  from = pathUtils.normalize(from);
  to = pathUtils.normalize(to);
  if (from === to) return `.`;
  if (!from.endsWith(pathUtils.sep)) from = from + pathUtils.sep;

  if (to.startsWith(from)) {
    return to.slice(from.length);
  } else {
    return null;
  }
};

npath.fromPortablePath = fromPortablePath;
npath.toPortablePath = toPortablePath;

npath.contains = (from, to) => contains(npath, from, to);

ppath.contains = (from, to) => contains(ppath, from, to);

const WINDOWS_PATH_REGEXP = /^([a-zA-Z]:.*)$/;
const UNC_WINDOWS_PATH_REGEXP = /^\\\\(\.\\)?(.*)$/;
const PORTABLE_PATH_REGEXP = /^\/([a-zA-Z]:.*)$/;
const UNC_PORTABLE_PATH_REGEXP = /^\/unc\/(\.dot\/)?(.*)$/; // Path should look like "/N:/berry/scripts/plugin-pack.js"
// And transform to "N:\berry\scripts\plugin-pack.js"

function fromPortablePath(p) {
  if (process.platform !== `win32`) return p;
  if (p.match(PORTABLE_PATH_REGEXP)) p = p.replace(PORTABLE_PATH_REGEXP, `$1`);else if (p.match(UNC_PORTABLE_PATH_REGEXP)) p = p.replace(UNC_PORTABLE_PATH_REGEXP, (match, p1, p2) => `\\\\${p1 ? `.\\` : ``}${p2}`);else return p;
  return p.replace(/\//g, `\\`);
} // Path should look like "N:/berry/scripts/plugin-pack.js"
// And transform to "/N:/berry/scripts/plugin-pack.js"


function toPortablePath(p) {
  if (process.platform !== `win32`) return p;
  if (p.match(WINDOWS_PATH_REGEXP)) p = p.replace(WINDOWS_PATH_REGEXP, `/$1`);else if (p.match(UNC_WINDOWS_PATH_REGEXP)) p = p.replace(UNC_WINDOWS_PATH_REGEXP, (match, p1, p2) => `/unc/${p1 ? `.dot/` : ``}${p2}`);
  return p.replace(/\\/g, `/`);
}

function convertPath(targetPathUtils, sourcePath) {
  return targetPathUtils === npath ? fromPortablePath(sourcePath) : toPortablePath(sourcePath);
}
function toFilename(filename) {
  if (npath.parse(filename).dir !== `` || ppath.parse(filename).dir !== ``) throw new Error(`Invalid filename: "${filename}"`);
  return filename;
}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/algorithms/copyPromise.ts

 // 1980-01-01, like Fedora

const defaultTime = new Date(315532800 * 1000);
async function copyPromise(destinationFs, destination, sourceFs, source, opts) {
  const normalizedDestination = destinationFs.pathUtils.normalize(destination);
  const normalizedSource = sourceFs.pathUtils.normalize(source);
  const prelayout = [];
  const postlayout = [];
  await destinationFs.mkdirPromise(destinationFs.pathUtils.dirname(destination), {
    recursive: true
  });
  const updateTime = typeof destinationFs.lutimesPromise === `function` ? destinationFs.lutimesPromise.bind(destinationFs) : destinationFs.utimesPromise.bind(destinationFs);
  await copyImpl(prelayout, postlayout, updateTime, destinationFs, normalizedDestination, sourceFs, normalizedSource, opts);

  for (const operation of prelayout) await operation();

  await Promise.all(postlayout.map(operation => {
    return operation();
  }));
}

async function copyImpl(prelayout, postlayout, updateTime, destinationFs, destination, sourceFs, source, opts) {
  var _a, _b;

  const destinationStat = await maybeLStat(destinationFs, destination);
  const sourceStat = await sourceFs.lstatPromise(source);
  const referenceTime = opts.stableTime ? {
    mtime: defaultTime,
    atime: defaultTime
  } : sourceStat;
  let updated;

  switch (true) {
    case sourceStat.isDirectory():
      {
        updated = await copyFolder(prelayout, postlayout, updateTime, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts);
      }
      break;

    case sourceStat.isFile():
      {
        updated = await copyFile(prelayout, postlayout, updateTime, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts);
      }
      break;

    case sourceStat.isSymbolicLink():
      {
        updated = await copySymlink(prelayout, postlayout, updateTime, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts);
      }
      break;

    default:
      {
        throw new Error(`Unsupported file type (${sourceStat.mode})`);
      }
      break;
  }

  if (updated || ((_a = destinationStat === null || destinationStat === void 0 ? void 0 : destinationStat.mtime) === null || _a === void 0 ? void 0 : _a.getTime()) !== referenceTime.mtime.getTime() || ((_b = destinationStat === null || destinationStat === void 0 ? void 0 : destinationStat.atime) === null || _b === void 0 ? void 0 : _b.getTime()) !== referenceTime.atime.getTime()) {
    postlayout.push(() => updateTime(destination, referenceTime.atime, referenceTime.mtime));
    updated = true;
  }

  if (destinationStat === null || (destinationStat.mode & 0o777) !== (sourceStat.mode & 0o777)) {
    postlayout.push(() => destinationFs.chmodPromise(destination, sourceStat.mode & 0o777));
    updated = true;
  }

  return updated;
}

async function maybeLStat(baseFs, p) {
  try {
    return await baseFs.lstatPromise(p);
  } catch (e) {
    return null;
  }
}

async function copyFolder(prelayout, postlayout, updateTime, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts) {
  if (destinationStat !== null && !destinationStat.isDirectory()) {
    if (opts.overwrite) {
      prelayout.push(async () => destinationFs.removePromise(destination));
      destinationStat = null;
    } else {
      return false;
    }
  }

  let updated = false;

  if (destinationStat === null) {
    prelayout.push(async () => destinationFs.mkdirPromise(destination, {
      mode: sourceStat.mode
    }));
    updated = true;
  }

  const entries = await sourceFs.readdirPromise(source);

  if (opts.stableSort) {
    for (const entry of entries.sort()) {
      if (await copyImpl(prelayout, postlayout, updateTime, destinationFs, destinationFs.pathUtils.join(destination, entry), sourceFs, sourceFs.pathUtils.join(source, entry), opts)) {
        updated = true;
      }
    }
  } else {
    const entriesUpdateStatus = await Promise.all(entries.map(async entry => {
      await copyImpl(prelayout, postlayout, updateTime, destinationFs, destinationFs.pathUtils.join(destination, entry), sourceFs, sourceFs.pathUtils.join(source, entry), opts);
    }));

    if (entriesUpdateStatus.some(status => status)) {
      updated = true;
    }
  }

  return updated;
}

async function copyFile(prelayout, postlayout, updateTime, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts) {
  if (destinationStat !== null) {
    if (opts.overwrite) {
      prelayout.push(async () => destinationFs.removePromise(destination));
      destinationStat = null;
    } else {
      return false;
    }
  }

  const op = destinationFs === sourceFs ? async () => destinationFs.copyFilePromise(source, destination, (external_fs_default()).constants.COPYFILE_FICLONE) : async () => destinationFs.writeFilePromise(destination, await sourceFs.readFilePromise(source));
  prelayout.push(async () => op());
  return true;
}

async function copySymlink(prelayout, postlayout, updateTime, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts) {
  if (destinationStat !== null) {
    if (opts.overwrite) {
      prelayout.push(async () => destinationFs.removePromise(destination));
      destinationStat = null;
    } else {
      return false;
    }
  }

  prelayout.push(async () => {
    await destinationFs.symlinkPromise(convertPath(destinationFs.pathUtils, await sourceFs.readlinkPromise(source)), destination);
  });
  return true;
}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/FakeFS.ts



class FakeFS {
  constructor(pathUtils) {
    this.pathUtils = pathUtils;
  }

  async *genTraversePromise(init, {
    stableSort = false
  } = {}) {
    const stack = [init];

    while (stack.length > 0) {
      const p = stack.shift();
      const entry = await this.lstatPromise(p);

      if (entry.isDirectory()) {
        const entries = await this.readdirPromise(p);

        if (stableSort) {
          for (const entry of entries.sort()) {
            stack.push(this.pathUtils.join(p, entry));
          }
        } else {
          throw new Error(`Not supported`);
        }
      } else {
        yield p;
      }
    }
  }

  async removePromise(p, {
    recursive = true,
    maxRetries = 5
  } = {}) {
    let stat;

    try {
      stat = await this.lstatPromise(p);
    } catch (error) {
      if (error.code === `ENOENT`) {
        return;
      } else {
        throw error;
      }
    }

    if (stat.isDirectory()) {
      if (recursive) for (const entry of await this.readdirPromise(p)) await this.removePromise(this.pathUtils.resolve(p, entry)); // 5 gives 1s worth of retries at worst

      let t = 0;

      do {
        try {
          await this.rmdirPromise(p);
          break;
        } catch (error) {
          if (error.code === `EBUSY` || error.code === `ENOTEMPTY`) {
            if (maxRetries === 0) {
              break;
            } else {
              await new Promise(resolve => setTimeout(resolve, t * 100));
              continue;
            }
          } else {
            throw error;
          }
        }
      } while (t++ < maxRetries);
    } else {
      await this.unlinkPromise(p);
    }
  }

  removeSync(p, {
    recursive = true
  } = {}) {
    let stat;

    try {
      stat = this.lstatSync(p);
    } catch (error) {
      if (error.code === `ENOENT`) {
        return;
      } else {
        throw error;
      }
    }

    if (stat.isDirectory()) {
      if (recursive) for (const entry of this.readdirSync(p)) this.removeSync(this.pathUtils.resolve(p, entry));
      this.rmdirSync(p);
    } else {
      this.unlinkSync(p);
    }
  }

  async mkdirpPromise(p, {
    chmod,
    utimes
  } = {}) {
    p = this.resolve(p);
    if (p === this.pathUtils.dirname(p)) return;
    const parts = p.split(this.pathUtils.sep);

    for (let u = 2; u <= parts.length; ++u) {
      const subPath = parts.slice(0, u).join(this.pathUtils.sep);

      if (!this.existsSync(subPath)) {
        try {
          await this.mkdirPromise(subPath);
        } catch (error) {
          if (error.code === `EEXIST`) {
            continue;
          } else {
            throw error;
          }
        }

        if (chmod != null) await this.chmodPromise(subPath, chmod);

        if (utimes != null) {
          await this.utimesPromise(subPath, utimes[0], utimes[1]);
        } else {
          const parentStat = await this.statPromise(this.pathUtils.dirname(subPath));
          await this.utimesPromise(subPath, parentStat.atime, parentStat.mtime);
        }
      }
    }
  }

  mkdirpSync(p, {
    chmod,
    utimes
  } = {}) {
    p = this.resolve(p);
    if (p === this.pathUtils.dirname(p)) return;
    const parts = p.split(this.pathUtils.sep);

    for (let u = 2; u <= parts.length; ++u) {
      const subPath = parts.slice(0, u).join(this.pathUtils.sep);

      if (!this.existsSync(subPath)) {
        try {
          this.mkdirSync(subPath);
        } catch (error) {
          if (error.code === `EEXIST`) {
            continue;
          } else {
            throw error;
          }
        }

        if (chmod != null) this.chmodSync(subPath, chmod);

        if (utimes != null) {
          this.utimesSync(subPath, utimes[0], utimes[1]);
        } else {
          const parentStat = this.statSync(this.pathUtils.dirname(subPath));
          this.utimesSync(subPath, parentStat.atime, parentStat.mtime);
        }
      }
    }
  }

  async copyPromise(destination, source, {
    baseFs = this,
    overwrite = true,
    stableSort = false,
    stableTime = false
  } = {}) {
    return await copyPromise(this, destination, baseFs, source, {
      overwrite,
      stableSort,
      stableTime
    });
  }

  copySync(destination, source, {
    baseFs = this,
    overwrite = true
  } = {}) {
    const stat = baseFs.lstatSync(source);
    const exists = this.existsSync(destination);

    if (stat.isDirectory()) {
      this.mkdirpSync(destination);
      const directoryListing = baseFs.readdirSync(source);

      for (const entry of directoryListing) {
        this.copySync(this.pathUtils.join(destination, entry), baseFs.pathUtils.join(source, entry), {
          baseFs,
          overwrite
        });
      }
    } else if (stat.isFile()) {
      if (!exists || overwrite) {
        if (exists) this.removeSync(destination);
        const content = baseFs.readFileSync(source);
        this.writeFileSync(destination, content);
      }
    } else if (stat.isSymbolicLink()) {
      if (!exists || overwrite) {
        if (exists) this.removeSync(destination);
        const target = baseFs.readlinkSync(source);
        this.symlinkSync(convertPath(this.pathUtils, target), destination);
      }
    } else {
      throw new Error(`Unsupported file type (file: ${source}, mode: 0o${stat.mode.toString(8).padStart(6, `0`)})`);
    }

    const mode = stat.mode & 0o777;
    this.chmodSync(destination, mode);
  }

  async changeFilePromise(p, content, opts = {}) {
    if (Buffer.isBuffer(content)) {
      return this.changeFileBufferPromise(p, content);
    } else {
      return this.changeFileTextPromise(p, content, opts);
    }
  }

  async changeFileBufferPromise(p, content) {
    let current = Buffer.alloc(0);

    try {
      current = await this.readFilePromise(p);
    } catch (error) {// ignore errors, no big deal
    }

    if (Buffer.compare(current, content) === 0) return;
    await this.writeFilePromise(p, content);
  }

  async changeFileTextPromise(p, content, {
    automaticNewlines
  } = {}) {
    let current = ``;

    try {
      current = await this.readFilePromise(p, `utf8`);
    } catch (error) {// ignore errors, no big deal
    }

    const normalizedContent = automaticNewlines ? normalizeLineEndings(current, content) : content;
    if (current === normalizedContent) return;
    await this.writeFilePromise(p, normalizedContent);
  }

  changeFileSync(p, content, opts = {}) {
    if (Buffer.isBuffer(content)) {
      return this.changeFileBufferSync(p, content);
    } else {
      return this.changeFileTextSync(p, content, opts);
    }
  }

  changeFileBufferSync(p, content) {
    let current = Buffer.alloc(0);

    try {
      current = this.readFileSync(p);
    } catch (error) {// ignore errors, no big deal
    }

    if (Buffer.compare(current, content) === 0) return;
    this.writeFileSync(p, content);
  }

  changeFileTextSync(p, content, {
    automaticNewlines = false
  } = {}) {
    let current = ``;

    try {
      current = this.readFileSync(p, `utf8`);
    } catch (error) {// ignore errors, no big deal
    }

    const normalizedContent = automaticNewlines ? normalizeLineEndings(current, content) : content;
    if (current === normalizedContent) return;
    this.writeFileSync(p, normalizedContent);
  }

  async movePromise(fromP, toP) {
    try {
      await this.renamePromise(fromP, toP);
    } catch (error) {
      if (error.code === `EXDEV`) {
        await this.copyPromise(toP, fromP);
        await this.removePromise(fromP);
      } else {
        throw error;
      }
    }
  }

  moveSync(fromP, toP) {
    try {
      this.renameSync(fromP, toP);
    } catch (error) {
      if (error.code === `EXDEV`) {
        this.copySync(toP, fromP);
        this.removeSync(fromP);
      } else {
        throw error;
      }
    }
  }

  async lockPromise(affectedPath, callback) {
    const lockPath = `${affectedPath}.flock`;
    const interval = 1000 / 60;
    const startTime = Date.now();
    let fd = null; // Even when we detect that a lock file exists, we still look inside to see
    // whether the pid that created it is still alive. It's not foolproof
    // (there are false positive), but there are no false negative and that's
    // all that matters in 99% of the cases.

    const isAlive = async () => {
      let pid;

      try {
        [pid] = await this.readJsonPromise(lockPath);
      } catch (error) {
        // If we can't read the file repeatedly, we assume the process was
        // aborted before even writing finishing writing the payload.
        return Date.now() - startTime < 500;
      }

      try {
        // "As a special case, a signal of 0 can be used to test for the
        // existence of a process" - so we check whether it's alive.
        process.kill(pid, 0);
        return true;
      } catch (error) {
        return false;
      }
    };

    while (fd === null) {
      try {
        fd = await this.openPromise(lockPath, `wx`);
      } catch (error) {
        if (error.code === `EEXIST`) {
          if (!(await isAlive())) {
            try {
              await this.unlinkPromise(lockPath);
              continue;
            } catch (error) {// No big deal if we can't remove it. Just fallback to wait for
              // it to be eventually released by its owner.
            }
          }

          if (Date.now() - startTime < 60 * 1000) {
            await new Promise(resolve => setTimeout(resolve, interval));
          } else {
            throw new Error(`Couldn't acquire a lock in a reasonable time (via ${lockPath})`);
          }
        } else {
          throw error;
        }
      }
    }

    await this.writePromise(fd, JSON.stringify([process.pid]));

    try {
      return await callback();
    } finally {
      try {
        // closePromise needs to come before unlinkPromise otherwise another process can attempt
        // to get the file handle after the unlink but before close resuling in
        // EPERM: operation not permitted, open
        await this.closePromise(fd);
        await this.unlinkPromise(lockPath);
      } catch (error) {// noop
      }
    }
  }

  async readJsonPromise(p) {
    const content = await this.readFilePromise(p, `utf8`);

    try {
      return JSON.parse(content);
    } catch (error) {
      error.message += ` (in ${p})`;
      throw error;
    }
  }

  readJsonSync(p) {
    const content = this.readFileSync(p, `utf8`);

    try {
      return JSON.parse(content);
    } catch (error) {
      error.message += ` (in ${p})`;
      throw error;
    }
  }

  async writeJsonPromise(p, data) {
    return await this.writeFilePromise(p, `${JSON.stringify(data, null, 2)}\n`);
  }

  writeJsonSync(p, data) {
    return this.writeFileSync(p, `${JSON.stringify(data, null, 2)}\n`);
  }

  async preserveTimePromise(p, cb) {
    const stat = await this.lstatPromise(p);
    const result = await cb();
    if (typeof result !== `undefined`) p = result;

    if (this.lutimesPromise) {
      await this.lutimesPromise(p, stat.atime, stat.mtime);
    } else if (!stat.isSymbolicLink()) {
      await this.utimesPromise(p, stat.atime, stat.mtime);
    }
  }

  async preserveTimeSync(p, cb) {
    const stat = this.lstatSync(p);
    const result = cb();
    if (typeof result !== `undefined`) p = result;

    if (this.lutimesSync) {
      this.lutimesSync(p, stat.atime, stat.mtime);
    } else if (!stat.isSymbolicLink()) {
      this.utimesSync(p, stat.atime, stat.mtime);
    }
  }

}
FakeFS.DEFAULT_TIME = 315532800;
class BasePortableFakeFS extends FakeFS {
  constructor() {
    super(ppath);
  }

}

function getEndOfLine(content) {
  const matches = content.match(/\r?\n/g);
  if (matches === null) return external_os_namespaceObject.EOL;
  const crlf = matches.filter(nl => nl === `\r\n`).length;
  const lf = matches.length - crlf;
  return crlf > lf ? `\r\n` : `\n`;
}

function normalizeLineEndings(originalContent, newContent) {
  return newContent.replace(/\r?\n/g, getEndOfLine(originalContent));
}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/errors.ts
function makeError(code, message) {
  return Object.assign(new Error(`${code}: ${message}`), {
    code
  });
}

function EBUSY(message) {
  return makeError(`EBUSY`, message);
}
function ENOSYS(message, reason) {
  return makeError(`ENOSYS`, `${message}, ${reason}`);
}
function EINVAL(reason) {
  return makeError(`EINVAL`, `invalid argument, ${reason}`);
}
function EBADF(reason) {
  return makeError(`EBADF`, `bad file descriptor, ${reason}`);
}
function ENOENT(reason) {
  return makeError(`ENOENT`, `no such file or directory, ${reason}`);
}
function ENOTDIR(reason) {
  return makeError(`ENOTDIR`, `not a directory, ${reason}`);
}
function EISDIR(reason) {
  return makeError(`EISDIR`, `illegal operation on a directory, ${reason}`);
}
function EEXIST(reason) {
  return makeError(`EEXIST`, `file already exists, ${reason}`);
}
function EROFS(reason) {
  return makeError(`EROFS`, `read-only filesystem, ${reason}`);
}
function ENOTEMPTY(reason) {
  return makeError(`ENOTEMPTY`, `directory not empty, ${reason}`);
}
function EOPNOTSUPP(reason) {
  return makeError(`EOPNOTSUPP`, `operation not supported, ${reason}`);
} // ------------------------------------------------------------------------

function ERR_DIR_CLOSED() {
  return makeError(`ERR_DIR_CLOSED`, `Directory handle was closed`);
} // ------------------------------------------------------------------------

class LibzipError extends Error {
  constructor(message, code) {
    super(message);
    this.name = `Libzip Error`;
    this.code = code;
  }

}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/NodeFS.ts




class NodeFS extends BasePortableFakeFS {
  constructor(realFs = (external_fs_default())) {
    super();
    this.realFs = realFs; // @ts-expect-error

    if (typeof this.realFs.lutimes !== `undefined`) {
      this.lutimesPromise = this.lutimesPromiseImpl;
      this.lutimesSync = this.lutimesSyncImpl;
    }
  }

  getExtractHint() {
    return false;
  }

  getRealPath() {
    return PortablePath.root;
  }

  resolve(p) {
    return ppath.resolve(p);
  }

  async openPromise(p, flags, mode) {
    return await new Promise((resolve, reject) => {
      this.realFs.open(npath.fromPortablePath(p), flags, mode, this.makeCallback(resolve, reject));
    });
  }

  openSync(p, flags, mode) {
    return this.realFs.openSync(npath.fromPortablePath(p), flags, mode);
  }

  async opendirPromise(p, opts) {
    return await new Promise((resolve, reject) => {
      if (typeof opts !== `undefined`) {
        this.realFs.opendir(npath.fromPortablePath(p), opts, this.makeCallback(resolve, reject));
      } else {
        this.realFs.opendir(npath.fromPortablePath(p), this.makeCallback(resolve, reject));
      }
    }).then(dir => {
      return Object.defineProperty(dir, `path`, {
        value: p,
        configurable: true,
        writable: true
      });
    });
  }

  opendirSync(p, opts) {
    const dir = typeof opts !== `undefined` ? this.realFs.opendirSync(npath.fromPortablePath(p), opts) : this.realFs.opendirSync(npath.fromPortablePath(p));
    return Object.defineProperty(dir, `path`, {
      value: p,
      configurable: true,
      writable: true
    });
  }

  async readPromise(fd, buffer, offset = 0, length = 0, position = -1) {
    return await new Promise((resolve, reject) => {
      this.realFs.read(fd, buffer, offset, length, position, (error, bytesRead) => {
        if (error) {
          reject(error);
        } else {
          resolve(bytesRead);
        }
      });
    });
  }

  readSync(fd, buffer, offset, length, position) {
    return this.realFs.readSync(fd, buffer, offset, length, position);
  }

  async writePromise(fd, buffer, offset, length, position) {
    return await new Promise((resolve, reject) => {
      if (typeof buffer === `string`) {
        return this.realFs.write(fd, buffer, offset, this.makeCallback(resolve, reject));
      } else {
        return this.realFs.write(fd, buffer, offset, length, position, this.makeCallback(resolve, reject));
      }
    });
  }

  writeSync(fd, buffer, offset, length, position) {
    if (typeof buffer === `string`) {
      return this.realFs.writeSync(fd, buffer, offset);
    } else {
      return this.realFs.writeSync(fd, buffer, offset, length, position);
    }
  }

  async closePromise(fd) {
    await new Promise((resolve, reject) => {
      this.realFs.close(fd, this.makeCallback(resolve, reject));
    });
  }

  closeSync(fd) {
    this.realFs.closeSync(fd);
  }

  createReadStream(p, opts) {
    const realPath = p !== null ? npath.fromPortablePath(p) : p;
    return this.realFs.createReadStream(realPath, opts);
  }

  createWriteStream(p, opts) {
    const realPath = p !== null ? npath.fromPortablePath(p) : p;
    return this.realFs.createWriteStream(realPath, opts);
  }

  async realpathPromise(p) {
    return await new Promise((resolve, reject) => {
      this.realFs.realpath(npath.fromPortablePath(p), {}, this.makeCallback(resolve, reject));
    }).then(path => {
      return npath.toPortablePath(path);
    });
  }

  realpathSync(p) {
    return npath.toPortablePath(this.realFs.realpathSync(npath.fromPortablePath(p), {}));
  }

  async existsPromise(p) {
    return await new Promise(resolve => {
      this.realFs.exists(npath.fromPortablePath(p), resolve);
    });
  }

  accessSync(p, mode) {
    return this.realFs.accessSync(npath.fromPortablePath(p), mode);
  }

  async accessPromise(p, mode) {
    return await new Promise((resolve, reject) => {
      this.realFs.access(npath.fromPortablePath(p), mode, this.makeCallback(resolve, reject));
    });
  }

  existsSync(p) {
    return this.realFs.existsSync(npath.fromPortablePath(p));
  }

  async statPromise(p) {
    return await new Promise((resolve, reject) => {
      this.realFs.stat(npath.fromPortablePath(p), this.makeCallback(resolve, reject));
    });
  }

  statSync(p) {
    return this.realFs.statSync(npath.fromPortablePath(p));
  }

  async lstatPromise(p) {
    return await new Promise((resolve, reject) => {
      this.realFs.lstat(npath.fromPortablePath(p), this.makeCallback(resolve, reject));
    });
  }

  lstatSync(p) {
    return this.realFs.lstatSync(npath.fromPortablePath(p));
  }

  async chmodPromise(p, mask) {
    return await new Promise((resolve, reject) => {
      this.realFs.chmod(npath.fromPortablePath(p), mask, this.makeCallback(resolve, reject));
    });
  }

  chmodSync(p, mask) {
    return this.realFs.chmodSync(npath.fromPortablePath(p), mask);
  }

  async chownPromise(p, uid, gid) {
    return await new Promise((resolve, reject) => {
      this.realFs.chown(npath.fromPortablePath(p), uid, gid, this.makeCallback(resolve, reject));
    });
  }

  chownSync(p, uid, gid) {
    return this.realFs.chownSync(npath.fromPortablePath(p), uid, gid);
  }

  async renamePromise(oldP, newP) {
    return await new Promise((resolve, reject) => {
      this.realFs.rename(npath.fromPortablePath(oldP), npath.fromPortablePath(newP), this.makeCallback(resolve, reject));
    });
  }

  renameSync(oldP, newP) {
    return this.realFs.renameSync(npath.fromPortablePath(oldP), npath.fromPortablePath(newP));
  }

  async copyFilePromise(sourceP, destP, flags = 0) {
    return await new Promise((resolve, reject) => {
      this.realFs.copyFile(npath.fromPortablePath(sourceP), npath.fromPortablePath(destP), flags, this.makeCallback(resolve, reject));
    });
  }

  copyFileSync(sourceP, destP, flags = 0) {
    return this.realFs.copyFileSync(npath.fromPortablePath(sourceP), npath.fromPortablePath(destP), flags);
  }

  async appendFilePromise(p, content, opts) {
    return await new Promise((resolve, reject) => {
      const fsNativePath = typeof p === `string` ? npath.fromPortablePath(p) : p;

      if (opts) {
        this.realFs.appendFile(fsNativePath, content, opts, this.makeCallback(resolve, reject));
      } else {
        this.realFs.appendFile(fsNativePath, content, this.makeCallback(resolve, reject));
      }
    });
  }

  appendFileSync(p, content, opts) {
    const fsNativePath = typeof p === `string` ? npath.fromPortablePath(p) : p;

    if (opts) {
      this.realFs.appendFileSync(fsNativePath, content, opts);
    } else {
      this.realFs.appendFileSync(fsNativePath, content);
    }
  }

  async writeFilePromise(p, content, opts) {
    return await new Promise((resolve, reject) => {
      const fsNativePath = typeof p === `string` ? npath.fromPortablePath(p) : p;

      if (opts) {
        this.realFs.writeFile(fsNativePath, content, opts, this.makeCallback(resolve, reject));
      } else {
        this.realFs.writeFile(fsNativePath, content, this.makeCallback(resolve, reject));
      }
    });
  }

  writeFileSync(p, content, opts) {
    const fsNativePath = typeof p === `string` ? npath.fromPortablePath(p) : p;

    if (opts) {
      this.realFs.writeFileSync(fsNativePath, content, opts);
    } else {
      this.realFs.writeFileSync(fsNativePath, content);
    }
  }

  async unlinkPromise(p) {
    return await new Promise((resolve, reject) => {
      this.realFs.unlink(npath.fromPortablePath(p), this.makeCallback(resolve, reject));
    });
  }

  unlinkSync(p) {
    return this.realFs.unlinkSync(npath.fromPortablePath(p));
  }

  async utimesPromise(p, atime, mtime) {
    return await new Promise((resolve, reject) => {
      this.realFs.utimes(npath.fromPortablePath(p), atime, mtime, this.makeCallback(resolve, reject));
    });
  }

  utimesSync(p, atime, mtime) {
    this.realFs.utimesSync(npath.fromPortablePath(p), atime, mtime);
  }

  async lutimesPromiseImpl(p, atime, mtime) {
    // @ts-expect-error: Not yet in DefinitelyTyped
    const lutimes = this.realFs.lutimes;
    if (typeof lutimes === `undefined`) throw ENOSYS(`unavailable Node binding`, `lutimes '${p}'`);
    return await new Promise((resolve, reject) => {
      lutimes.call(this.realFs, npath.fromPortablePath(p), atime, mtime, this.makeCallback(resolve, reject));
    });
  }

  lutimesSyncImpl(p, atime, mtime) {
    // @ts-expect-error: Not yet in DefinitelyTyped
    const lutimesSync = this.realFs.lutimesSync;
    if (typeof lutimesSync === `undefined`) throw ENOSYS(`unavailable Node binding`, `lutimes '${p}'`);
    lutimesSync.call(this.realFs, npath.fromPortablePath(p), atime, mtime);
  }

  async mkdirPromise(p, opts) {
    return await new Promise((resolve, reject) => {
      this.realFs.mkdir(npath.fromPortablePath(p), opts, this.makeCallback(resolve, reject));
    });
  }

  mkdirSync(p, opts) {
    return this.realFs.mkdirSync(npath.fromPortablePath(p), opts);
  }

  async rmdirPromise(p, opts) {
    return await new Promise((resolve, reject) => {
      // TODO: always pass opts when min node version is 12.10+
      if (opts) {
        this.realFs.rmdir(npath.fromPortablePath(p), opts, this.makeCallback(resolve, reject));
      } else {
        this.realFs.rmdir(npath.fromPortablePath(p), this.makeCallback(resolve, reject));
      }
    });
  }

  rmdirSync(p, opts) {
    return this.realFs.rmdirSync(npath.fromPortablePath(p), opts);
  }

  async linkPromise(existingP, newP) {
    return await new Promise((resolve, reject) => {
      this.realFs.link(npath.fromPortablePath(existingP), npath.fromPortablePath(newP), this.makeCallback(resolve, reject));
    });
  }

  linkSync(existingP, newP) {
    return this.realFs.linkSync(npath.fromPortablePath(existingP), npath.fromPortablePath(newP));
  }

  async symlinkPromise(target, p, type) {
    const symlinkType = type || (target.endsWith(`/`) ? `dir` : `file`);
    return await new Promise((resolve, reject) => {
      this.realFs.symlink(npath.fromPortablePath(target.replace(/\/+$/, ``)), npath.fromPortablePath(p), symlinkType, this.makeCallback(resolve, reject));
    });
  }

  symlinkSync(target, p, type) {
    const symlinkType = type || (target.endsWith(`/`) ? `dir` : `file`);
    return this.realFs.symlinkSync(npath.fromPortablePath(target.replace(/\/+$/, ``)), npath.fromPortablePath(p), symlinkType);
  }

  async readFilePromise(p, encoding) {
    return await new Promise((resolve, reject) => {
      const fsNativePath = typeof p === `string` ? npath.fromPortablePath(p) : p;
      this.realFs.readFile(fsNativePath, encoding, this.makeCallback(resolve, reject));
    });
  }

  readFileSync(p, encoding) {
    const fsNativePath = typeof p === `string` ? npath.fromPortablePath(p) : p;
    return this.realFs.readFileSync(fsNativePath, encoding);
  }

  async readdirPromise(p, {
    withFileTypes
  } = {}) {
    return await new Promise((resolve, reject) => {
      if (withFileTypes) {
        this.realFs.readdir(npath.fromPortablePath(p), {
          withFileTypes: true
        }, this.makeCallback(resolve, reject));
      } else {
        this.realFs.readdir(npath.fromPortablePath(p), this.makeCallback(value => resolve(value), reject));
      }
    });
  }

  readdirSync(p, {
    withFileTypes
  } = {}) {
    if (withFileTypes) {
      return this.realFs.readdirSync(npath.fromPortablePath(p), {
        withFileTypes: true
      });
    } else {
      return this.realFs.readdirSync(npath.fromPortablePath(p));
    }
  }

  async readlinkPromise(p) {
    return await new Promise((resolve, reject) => {
      this.realFs.readlink(npath.fromPortablePath(p), this.makeCallback(resolve, reject));
    }).then(path => {
      return npath.toPortablePath(path);
    });
  }

  readlinkSync(p) {
    return npath.toPortablePath(this.realFs.readlinkSync(npath.fromPortablePath(p)));
  }

  async truncatePromise(p, len) {
    return await new Promise((resolve, reject) => {
      this.realFs.truncate(npath.fromPortablePath(p), len, this.makeCallback(resolve, reject));
    });
  }

  truncateSync(p, len) {
    return this.realFs.truncateSync(npath.fromPortablePath(p), len);
  }

  watch(p, a, b) {
    return this.realFs.watch(npath.fromPortablePath(p), // @ts-expect-error
    a, b);
  }

  watchFile(p, a, b) {
    return this.realFs.watchFile(npath.fromPortablePath(p), // @ts-expect-error
    a, b);
  }

  unwatchFile(p, cb) {
    return this.realFs.unwatchFile(npath.fromPortablePath(p), cb);
  }

  makeCallback(resolve, reject) {
    return (err, result) => {
      if (err) {
        reject(err);
      } else {
        resolve(result);
      }
    };
  }

}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/ProxiedFS.ts

class ProxiedFS extends FakeFS {
  getExtractHint(hints) {
    return this.baseFs.getExtractHint(hints);
  }

  resolve(path) {
    return this.mapFromBase(this.baseFs.resolve(this.mapToBase(path)));
  }

  getRealPath() {
    return this.mapFromBase(this.baseFs.getRealPath());
  }

  async openPromise(p, flags, mode) {
    return this.baseFs.openPromise(this.mapToBase(p), flags, mode);
  }

  openSync(p, flags, mode) {
    return this.baseFs.openSync(this.mapToBase(p), flags, mode);
  }

  async opendirPromise(p, opts) {
    return Object.assign(await this.baseFs.opendirPromise(this.mapToBase(p), opts), {
      path: p
    });
  }

  opendirSync(p, opts) {
    return Object.assign(this.baseFs.opendirSync(this.mapToBase(p), opts), {
      path: p
    });
  }

  async readPromise(fd, buffer, offset, length, position) {
    return await this.baseFs.readPromise(fd, buffer, offset, length, position);
  }

  readSync(fd, buffer, offset, length, position) {
    return this.baseFs.readSync(fd, buffer, offset, length, position);
  }

  async writePromise(fd, buffer, offset, length, position) {
    if (typeof buffer === `string`) {
      return await this.baseFs.writePromise(fd, buffer, offset);
    } else {
      return await this.baseFs.writePromise(fd, buffer, offset, length, position);
    }
  }

  writeSync(fd, buffer, offset, length, position) {
    if (typeof buffer === `string`) {
      return this.baseFs.writeSync(fd, buffer, offset);
    } else {
      return this.baseFs.writeSync(fd, buffer, offset, length, position);
    }
  }

  async closePromise(fd) {
    return this.baseFs.closePromise(fd);
  }

  closeSync(fd) {
    this.baseFs.closeSync(fd);
  }

  createReadStream(p, opts) {
    return this.baseFs.createReadStream(p !== null ? this.mapToBase(p) : p, opts);
  }

  createWriteStream(p, opts) {
    return this.baseFs.createWriteStream(p !== null ? this.mapToBase(p) : p, opts);
  }

  async realpathPromise(p) {
    return this.mapFromBase(await this.baseFs.realpathPromise(this.mapToBase(p)));
  }

  realpathSync(p) {
    return this.mapFromBase(this.baseFs.realpathSync(this.mapToBase(p)));
  }

  async existsPromise(p) {
    return this.baseFs.existsPromise(this.mapToBase(p));
  }

  existsSync(p) {
    return this.baseFs.existsSync(this.mapToBase(p));
  }

  accessSync(p, mode) {
    return this.baseFs.accessSync(this.mapToBase(p), mode);
  }

  async accessPromise(p, mode) {
    return this.baseFs.accessPromise(this.mapToBase(p), mode);
  }

  async statPromise(p) {
    return this.baseFs.statPromise(this.mapToBase(p));
  }

  statSync(p) {
    return this.baseFs.statSync(this.mapToBase(p));
  }

  async lstatPromise(p) {
    return this.baseFs.lstatPromise(this.mapToBase(p));
  }

  lstatSync(p) {
    return this.baseFs.lstatSync(this.mapToBase(p));
  }

  async chmodPromise(p, mask) {
    return this.baseFs.chmodPromise(this.mapToBase(p), mask);
  }

  chmodSync(p, mask) {
    return this.baseFs.chmodSync(this.mapToBase(p), mask);
  }

  async chownPromise(p, uid, gid) {
    return this.baseFs.chownPromise(this.mapToBase(p), uid, gid);
  }

  chownSync(p, uid, gid) {
    return this.baseFs.chownSync(this.mapToBase(p), uid, gid);
  }

  async renamePromise(oldP, newP) {
    return this.baseFs.renamePromise(this.mapToBase(oldP), this.mapToBase(newP));
  }

  renameSync(oldP, newP) {
    return this.baseFs.renameSync(this.mapToBase(oldP), this.mapToBase(newP));
  }

  async copyFilePromise(sourceP, destP, flags = 0) {
    return this.baseFs.copyFilePromise(this.mapToBase(sourceP), this.mapToBase(destP), flags);
  }

  copyFileSync(sourceP, destP, flags = 0) {
    return this.baseFs.copyFileSync(this.mapToBase(sourceP), this.mapToBase(destP), flags);
  }

  async appendFilePromise(p, content, opts) {
    return this.baseFs.appendFilePromise(this.fsMapToBase(p), content, opts);
  }

  appendFileSync(p, content, opts) {
    return this.baseFs.appendFileSync(this.fsMapToBase(p), content, opts);
  }

  async writeFilePromise(p, content, opts) {
    return this.baseFs.writeFilePromise(this.fsMapToBase(p), content, opts);
  }

  writeFileSync(p, content, opts) {
    return this.baseFs.writeFileSync(this.fsMapToBase(p), content, opts);
  }

  async unlinkPromise(p) {
    return this.baseFs.unlinkPromise(this.mapToBase(p));
  }

  unlinkSync(p) {
    return this.baseFs.unlinkSync(this.mapToBase(p));
  }

  async utimesPromise(p, atime, mtime) {
    return this.baseFs.utimesPromise(this.mapToBase(p), atime, mtime);
  }

  utimesSync(p, atime, mtime) {
    return this.baseFs.utimesSync(this.mapToBase(p), atime, mtime);
  }

  async mkdirPromise(p, opts) {
    return this.baseFs.mkdirPromise(this.mapToBase(p), opts);
  }

  mkdirSync(p, opts) {
    return this.baseFs.mkdirSync(this.mapToBase(p), opts);
  }

  async rmdirPromise(p, opts) {
    return this.baseFs.rmdirPromise(this.mapToBase(p), opts);
  }

  rmdirSync(p, opts) {
    return this.baseFs.rmdirSync(this.mapToBase(p), opts);
  }

  async linkPromise(existingP, newP) {
    return this.baseFs.linkPromise(this.mapToBase(existingP), this.mapToBase(newP));
  }

  linkSync(existingP, newP) {
    return this.baseFs.linkSync(this.mapToBase(existingP), this.mapToBase(newP));
  }

  async symlinkPromise(target, p, type) {
    return this.baseFs.symlinkPromise(this.mapToBase(target), this.mapToBase(p), type);
  }

  symlinkSync(target, p, type) {
    return this.baseFs.symlinkSync(this.mapToBase(target), this.mapToBase(p), type);
  }

  async readFilePromise(p, encoding) {
    // This weird condition is required to tell TypeScript that the signatures are proper (otherwise it thinks that only the generic one is covered)
    if (encoding === `utf8`) {
      return this.baseFs.readFilePromise(this.fsMapToBase(p), encoding);
    } else {
      return this.baseFs.readFilePromise(this.fsMapToBase(p), encoding);
    }
  }

  readFileSync(p, encoding) {
    // This weird condition is required to tell TypeScript that the signatures are proper (otherwise it thinks that only the generic one is covered)
    if (encoding === `utf8`) {
      return this.baseFs.readFileSync(this.fsMapToBase(p), encoding);
    } else {
      return this.baseFs.readFileSync(this.fsMapToBase(p), encoding);
    }
  }

  async readdirPromise(p, {
    withFileTypes
  } = {}) {
    return this.baseFs.readdirPromise(this.mapToBase(p), {
      withFileTypes: withFileTypes
    });
  }

  readdirSync(p, {
    withFileTypes
  } = {}) {
    return this.baseFs.readdirSync(this.mapToBase(p), {
      withFileTypes: withFileTypes
    });
  }

  async readlinkPromise(p) {
    return this.mapFromBase(await this.baseFs.readlinkPromise(this.mapToBase(p)));
  }

  readlinkSync(p) {
    return this.mapFromBase(this.baseFs.readlinkSync(this.mapToBase(p)));
  }

  async truncatePromise(p, len) {
    return this.baseFs.truncatePromise(this.mapToBase(p), len);
  }

  truncateSync(p, len) {
    return this.baseFs.truncateSync(this.mapToBase(p), len);
  }

  watch(p, a, b) {
    return this.baseFs.watch(this.mapToBase(p), // @ts-expect-error
    a, b);
  }

  watchFile(p, a, b) {
    return this.baseFs.watchFile(this.mapToBase(p), // @ts-expect-error
    a, b);
  }

  unwatchFile(p, cb) {
    return this.baseFs.unwatchFile(this.mapToBase(p), cb);
  }

  fsMapToBase(p) {
    if (typeof p === `number`) {
      return p;
    } else {
      return this.mapToBase(p);
    }
  }

}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/VirtualFS.ts



const NUMBER_REGEXP = /^[0-9]+$/; // $0: full path
// $1: virtual folder
// $2: virtual segment
// $3: hash
// $4: depth
// $5: subpath

const VIRTUAL_REGEXP = /^(\/(?:[^/]+\/)*?\$\$virtual)((?:\/((?:[^/]+-)?[a-f0-9]+)(?:\/([^/]+))?)?((?:\/.*)?))$/;
const VALID_COMPONENT = /^([^/]+-)?[a-f0-9]+$/;
class VirtualFS extends ProxiedFS {
  constructor({
    baseFs = new NodeFS()
  } = {}) {
    super(ppath);
    this.baseFs = baseFs;
  }

  static makeVirtualPath(base, component, to) {
    if (ppath.basename(base) !== `$$virtual`) throw new Error(`Assertion failed: Virtual folders must be named "$$virtual"`);
    if (!ppath.basename(component).match(VALID_COMPONENT)) throw new Error(`Assertion failed: Virtual components must be ended by an hexadecimal hash`); // Obtains the relative distance between the virtual path and its actual target

    const target = ppath.relative(ppath.dirname(base), to);
    const segments = target.split(`/`); // Counts how many levels we need to go back to start applying the rest of the path

    let depth = 0;

    while (depth < segments.length && segments[depth] === `..`) depth += 1;

    const finalSegments = segments.slice(depth);
    const fullVirtualPath = ppath.join(base, component, String(depth), ...finalSegments);
    return fullVirtualPath;
  }

  static resolveVirtual(p) {
    const match = p.match(VIRTUAL_REGEXP);
    if (!match || !match[3] && match[5]) return p;
    const target = ppath.dirname(match[1]);
    if (!match[3] || !match[4]) return target;
    const isnum = NUMBER_REGEXP.test(match[4]);
    if (!isnum) return p;
    const depth = Number(match[4]);
    const backstep = `../`.repeat(depth);
    const subpath = match[5] || `.`;
    return VirtualFS.resolveVirtual(ppath.join(target, backstep, subpath));
  }

  getExtractHint(hints) {
    return this.baseFs.getExtractHint(hints);
  }

  getRealPath() {
    return this.baseFs.getRealPath();
  }

  realpathSync(p) {
    const match = p.match(VIRTUAL_REGEXP);
    if (!match) return this.baseFs.realpathSync(p);
    if (!match[5]) return p;
    const realpath = this.baseFs.realpathSync(this.mapToBase(p));
    return VirtualFS.makeVirtualPath(match[1], match[3], realpath);
  }

  async realpathPromise(p) {
    const match = p.match(VIRTUAL_REGEXP);
    if (!match) return await this.baseFs.realpathPromise(p);
    if (!match[5]) return p;
    const realpath = await this.baseFs.realpathPromise(this.mapToBase(p));
    return VirtualFS.makeVirtualPath(match[1], match[3], realpath);
  }

  mapToBase(p) {
    return VirtualFS.resolveVirtual(p);
  }

  mapFromBase(p) {
    return p;
  }

}
// CONCATENATED MODULE: external "stream"
const external_stream_namespaceObject = require("stream");;
// CONCATENATED MODULE: external "util"
const external_util_namespaceObject = require("util");;
// CONCATENATED MODULE: external "zlib"
const external_zlib_namespaceObject = require("zlib");;
var external_zlib_default = /*#__PURE__*/__webpack_require__.n(external_zlib_namespaceObject);

// CONCATENATED MODULE: ../yarnpkg-fslib/sources/algorithms/opendir.ts

class CustomDir {
  constructor(path, nextDirent, opts = {}) {
    this.path = path;
    this.nextDirent = nextDirent;
    this.opts = opts;
    this.closed = false;
  }

  throwIfClosed() {
    if (this.closed) {
      throw ERR_DIR_CLOSED();
    }
  }

  async *[Symbol.asyncIterator]() {
    try {
      let dirent; // eslint-disable-next-line no-cond-assign

      while ((dirent = await this.read()) !== null) {
        yield dirent;
      }
    } finally {
      await this.close();
    }
  }

  read(cb) {
    const dirent = this.readSync();
    if (typeof cb !== `undefined`) return cb(null, dirent);
    return Promise.resolve(dirent);
  }

  readSync() {
    this.throwIfClosed();
    return this.nextDirent();
  }

  close(cb) {
    this.closeSync();
    if (typeof cb !== `undefined`) return cb(null);
    return Promise.resolve();
  }

  closeSync() {
    var _a, _b;

    this.throwIfClosed();
    (_b = (_a = this.opts).onClose) === null || _b === void 0 ? void 0 : _b.call(_a);
    this.closed = true;
  }

}
function opendir(fakeFs, path, entries, opts) {
  const nextDirent = () => {
    const filename = entries.shift();
    if (typeof filename === `undefined`) return null;
    return Object.assign(fakeFs.statSync(fakeFs.pathUtils.join(path, filename)), {
      name: filename
    });
  };

  return new CustomDir(path, nextDirent, opts);
}
// CONCATENATED MODULE: external "events"
const external_events_namespaceObject = require("events");;
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/constants.ts
const constants_S_IFMT = 0o170000;
const constants_S_IFDIR = 0o040000;
const constants_S_IFREG = 0o100000;
const constants_S_IFLNK = 0o120000;
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/statUtils.ts

class DirEntry {
  constructor() {
    this.name = ``;
    this.mode = 0;
  }

  isBlockDevice() {
    return false;
  }

  isCharacterDevice() {
    return false;
  }

  isDirectory() {
    return (this.mode & S_IFMT) === S_IFDIR;
  }

  isFIFO() {
    return false;
  }

  isFile() {
    return (this.mode & S_IFMT) === S_IFREG;
  }

  isSocket() {
    return false;
  }

  isSymbolicLink() {
    return (this.mode & S_IFMT) === S_IFLNK;
  }

}
class StatEntry {
  constructor() {
    this.dev = 0;
    this.ino = 0;
    this.mode = 0;
    this.nlink = 1;
    this.rdev = 0;
    this.blocks = 1;
  }

  isBlockDevice() {
    return false;
  }

  isCharacterDevice() {
    return false;
  }

  isDirectory() {
    return (this.mode & constants_S_IFMT) === constants_S_IFDIR;
  }

  isFIFO() {
    return false;
  }

  isFile() {
    return (this.mode & constants_S_IFMT) === constants_S_IFREG;
  }

  isSocket() {
    return false;
  }

  isSymbolicLink() {
    return (this.mode & constants_S_IFMT) === constants_S_IFLNK;
  }

}
function makeDefaultStats() {
  return Object.assign(new StatEntry(), {
    uid: 0,
    gid: 0,
    size: 0,
    blksize: 0,
    atimeMs: 0,
    mtimeMs: 0,
    ctimeMs: 0,
    birthtimeMs: 0,
    atime: new Date(0),
    mtime: new Date(0),
    ctime: new Date(0),
    birthtime: new Date(0),
    mode: constants_S_IFREG | 0o644
  });
}
function makeEmptyStats() {
  return Object.assign(makeDefaultStats(), {
    nlink: 0,
    blocks: 0,
    mode: 0
  });
}
function areStatsEqual(a, b) {
  if (a.atimeMs !== b.atimeMs) return false;
  if (a.birthtimeMs !== b.birthtimeMs) return false;
  if (a.blksize !== b.blksize) return false;
  if (a.blocks !== b.blocks) return false;
  if (a.ctimeMs !== b.ctimeMs) return false;
  if (a.dev !== b.dev) return false;
  if (a.gid !== b.gid) return false;
  if (a.ino !== b.ino) return false;
  if (a.isBlockDevice() !== b.isBlockDevice()) return false;
  if (a.isCharacterDevice() !== b.isCharacterDevice()) return false;
  if (a.isDirectory() !== b.isDirectory()) return false;
  if (a.isFIFO() !== b.isFIFO()) return false;
  if (a.isFile() !== b.isFile()) return false;
  if (a.isSocket() !== b.isSocket()) return false;
  if (a.isSymbolicLink() !== b.isSymbolicLink()) return false;
  if (a.mode !== b.mode) return false;
  if (a.mtimeMs !== b.mtimeMs) return false;
  if (a.nlink !== b.nlink) return false;
  if (a.rdev !== b.rdev) return false;
  if (a.size !== b.size) return false;
  if (a.uid !== b.uid) return false;
  return true;
}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/algorithms/watchFile/CustomStatWatcher.ts


var Event;

(function (Event) {
  Event["Change"] = "change";
  Event["Stop"] = "stop";
})(Event || (Event = {}));

var Status;

(function (Status) {
  Status["Ready"] = "ready";
  Status["Running"] = "running";
  Status["Stopped"] = "stopped";
})(Status || (Status = {}));

function assertStatus(current, expected) {
  if (current !== expected) {
    throw new Error(`Invalid StatWatcher status: expected '${expected}', got '${current}'`);
  }
}
class CustomStatWatcher extends external_events_namespaceObject.EventEmitter {
  constructor(fakeFs, path, {
    bigint = false
  } = {}) {
    super();
    this.status = Status.Ready;
    this.changeListeners = new Map();
    this.startTimeout = null;
    this.fakeFs = fakeFs;
    this.path = path;
    this.bigint = bigint;
    this.lastStats = this.stat();
  }

  static create(fakeFs, path, opts) {
    const statWatcher = new CustomStatWatcher(fakeFs, path, opts);
    statWatcher.start();
    return statWatcher;
  }

  start() {
    assertStatus(this.status, Status.Ready);
    this.status = Status.Running; // Node allows other listeners to be registered up to 3 milliseconds
    // after the watcher has been started, so that's what we're doing too

    this.startTimeout = setTimeout(() => {
      this.startTimeout = null; // Per the Node FS docs:
      // "When an fs.watchFile operation results in an ENOENT error,
      // it will invoke the listener once, with all the fields zeroed
      // (or, for dates, the Unix Epoch)."

      if (!this.fakeFs.existsSync(this.path)) {
        this.emit(Event.Change, this.lastStats, this.lastStats);
      }
    }, 3);
  }

  stop() {
    assertStatus(this.status, Status.Running);
    this.status = Status.Stopped;

    if (this.startTimeout !== null) {
      clearTimeout(this.startTimeout);
      this.startTimeout = null;
    }

    this.emit(Event.Stop);
  }

  stat() {
    try {
      return this.fakeFs.statSync(this.path);
    } catch (error) {
      if (error.code === `ENOENT`) {
        return makeEmptyStats();
      } else {
        throw error;
      }
    }
  }
  /**
   * Creates an interval whose callback compares the current stats with the previous stats and notifies all listeners in case of changes.
   *
   * @param opts.persistent Decides whether the interval should be immediately unref-ed.
   */


  makeInterval(opts) {
    const interval = setInterval(() => {
      const currentStats = this.stat();
      const previousStats = this.lastStats;
      if (areStatsEqual(currentStats, previousStats)) return;
      this.lastStats = currentStats;
      this.emit(Event.Change, currentStats, previousStats);
    }, opts.interval);
    return opts.persistent ? interval : interval.unref();
  }
  /**
   * Registers a listener and assigns it an interval.
   */


  registerChangeListener(listener, opts) {
    this.addListener(Event.Change, listener);
    this.changeListeners.set(listener, this.makeInterval(opts));
  }
  /**
   * Unregisters the listener and clears the assigned interval.
   */


  unregisterChangeListener(listener) {
    this.removeListener(Event.Change, listener);
    const interval = this.changeListeners.get(listener);
    if (typeof interval !== `undefined`) clearInterval(interval);
    this.changeListeners.delete(listener);
  }
  /**
   * Unregisters all listeners and clears all assigned intervals.
   */


  unregisterAllChangeListeners() {
    for (const listener of this.changeListeners.keys()) {
      this.unregisterChangeListener(listener);
    }
  }

  hasChangeListeners() {
    return this.changeListeners.size > 0;
  }
  /**
   * Refs all stored intervals.
   */


  ref() {
    for (const interval of this.changeListeners.values()) interval.ref();

    return this;
  }
  /**
   * Unrefs all stored intervals.
   */


  unref() {
    for (const interval of this.changeListeners.values()) interval.unref();

    return this;
  }

}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/algorithms/watchFile.ts

const statWatchersByFakeFS = new WeakMap();
function watchFile(fakeFs, path, a, b) {
  let bigint;
  let persistent;
  let interval;
  let listener;

  switch (typeof a) {
    case `function`:
      {
        bigint = false;
        persistent = true;
        interval = 5007;
        listener = a;
      }
      break;

    default:
      {
        ({
          bigint = false,
          persistent = true,
          interval = 5007
        } = a);
        listener = b;
      }
      break;
  }

  let statWatchers = statWatchersByFakeFS.get(fakeFs);
  if (typeof statWatchers === `undefined`) statWatchersByFakeFS.set(fakeFs, statWatchers = new Map());
  let statWatcher = statWatchers.get(path);

  if (typeof statWatcher === `undefined`) {
    statWatcher = CustomStatWatcher.create(fakeFs, path, {
      bigint
    });
    statWatchers.set(path, statWatcher);
  }

  statWatcher.registerChangeListener(listener, {
    persistent,
    interval
  });
  return statWatcher;
}
function unwatchFile(fakeFs, path, cb) {
  const statWatchers = statWatchersByFakeFS.get(fakeFs);
  if (typeof statWatchers === `undefined`) return;
  const statWatcher = statWatchers.get(path);
  if (typeof statWatcher === `undefined`) return;
  if (typeof cb === `undefined`) statWatcher.unregisterAllChangeListeners();else statWatcher.unregisterChangeListener(cb);

  if (!statWatcher.hasChangeListeners()) {
    statWatcher.stop();
    statWatchers.delete(path);
  }
}
function unwatchAllFiles(fakeFs) {
  const statWatchers = statWatchersByFakeFS.get(fakeFs);
  if (typeof statWatchers === `undefined`) return;

  for (const path of statWatchers.keys()) {
    unwatchFile(fakeFs, path);
  }
}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/ZipFS.ts












const DEFAULT_COMPRESSION_LEVEL = `mixed`;

function toUnixTimestamp(time) {
  if (typeof time === `string` && String(+time) === time) return +time;

  if (Number.isFinite(time)) {
    if (time < 0) {
      return Date.now() / 1000;
    } else {
      return time;
    }
  } // convert to 123.456 UNIX timestamp


  if ((0,external_util_namespaceObject.isDate)(time)) return time.getTime() / 1000;
  throw new Error(`Invalid time`);
}

class ZipFS extends BasePortableFakeFS {
  constructor(source, opts) {
    super();
    this.lzSource = null;
    this.listings = new Map();
    this.entries = new Map();
    /**
     * A cache of indices mapped to file sources.
     * Populated by `setFileSource` calls.
     * Required for supporting read after write.
     */

    this.fileSources = new Map();
    this.fds = new Map();
    this.nextFd = 0;
    this.ready = false;
    this.readOnly = false;
    this.libzip = opts.libzip;
    const pathOptions = opts;
    this.level = typeof pathOptions.level !== `undefined` ? pathOptions.level : DEFAULT_COMPRESSION_LEVEL;

    if (source === null) {
      source = Buffer.from([0x50, 0x4B, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]);
    }

    if (typeof source === `string`) {
      const {
        baseFs = new NodeFS()
      } = pathOptions;
      this.baseFs = baseFs;
      this.path = source;
    } else {
      this.path = null;
      this.baseFs = null;
    }

    if (opts.stats) {
      this.stats = opts.stats;
    } else {
      if (typeof source === `string`) {
        try {
          this.stats = this.baseFs.statSync(source);
        } catch (error) {
          if (error.code === `ENOENT` && pathOptions.create) {
            this.stats = makeDefaultStats();
          } else {
            throw error;
          }
        }
      } else {
        this.stats = makeDefaultStats();
      }
    }

    const errPtr = this.libzip.malloc(4);

    try {
      let flags = 0;
      if (typeof source === `string` && pathOptions.create) flags |= this.libzip.ZIP_CREATE | this.libzip.ZIP_TRUNCATE;

      if (opts.readOnly) {
        flags |= this.libzip.ZIP_RDONLY;
        this.readOnly = true;
      }

      if (typeof source === `string`) {
        this.zip = this.libzip.open(npath.fromPortablePath(source), flags, errPtr);
      } else {
        const lzSource = this.allocateUnattachedSource(source);

        try {
          this.zip = this.libzip.openFromSource(lzSource, flags, errPtr);
          this.lzSource = lzSource;
        } catch (error) {
          this.libzip.source.free(lzSource);
          throw error;
        }
      }

      if (this.zip === 0) {
        const error = this.libzip.struct.errorS();
        this.libzip.error.initWithCode(error, this.libzip.getValue(errPtr, `i32`));
        throw this.makeLibzipError(error);
      }
    } finally {
      this.libzip.free(errPtr);
    }

    this.listings.set(PortablePath.root, new Set());
    const entryCount = this.libzip.getNumEntries(this.zip, 0);

    for (let t = 0; t < entryCount; ++t) {
      const raw = this.libzip.getName(this.zip, t, 0);
      if (ppath.isAbsolute(raw)) continue;
      const p = ppath.resolve(PortablePath.root, raw);
      this.registerEntry(p, t); // If the raw path is a directory, register it
      // to prevent empty folder being skipped

      if (raw.endsWith(`/`)) {
        this.registerListing(p);
      }
    }

    this.symlinkCount = this.libzip.ext.countSymlinks(this.zip);
    if (this.symlinkCount === -1) throw this.makeLibzipError(this.libzip.getError(this.zip));
    this.ready = true;
  }

  makeLibzipError(error) {
    const errorCode = this.libzip.struct.errorCodeZip(error);
    const strerror = this.libzip.error.strerror(error);
    const libzipError = new LibzipError(strerror, this.libzip.errors[errorCode]); // This error should never come up because of the file source cache

    if (errorCode === this.libzip.errors.ZIP_ER_CHANGED) throw new Error(`Assertion failed: Unexpected libzip error: ${libzipError.message}`);
    return libzipError;
  }

  getExtractHint(hints) {
    for (const fileName of this.entries.keys()) {
      const ext = this.pathUtils.extname(fileName);

      if (hints.relevantExtensions.has(ext)) {
        return true;
      }
    }

    return false;
  }

  getAllFiles() {
    return Array.from(this.entries.keys());
  }

  getRealPath() {
    if (!this.path) throw new Error(`ZipFS don't have real paths when loaded from a buffer`);
    return this.path;
  }

  getBufferAndClose() {
    this.prepareClose();
    if (!this.lzSource) throw new Error(`ZipFS was not created from a Buffer`);

    try {
      // Prevent close from cleaning up the source
      this.libzip.source.keep(this.lzSource); // Close the zip archive

      if (this.libzip.close(this.zip) === -1) throw this.makeLibzipError(this.libzip.getError(this.zip)); // Open the source for reading

      if (this.libzip.source.open(this.lzSource) === -1) throw this.makeLibzipError(this.libzip.source.error(this.lzSource)); // Move to the end of source

      if (this.libzip.source.seek(this.lzSource, 0, 0, this.libzip.SEEK_END) === -1) throw this.makeLibzipError(this.libzip.source.error(this.lzSource)); // Get the size of source

      const size = this.libzip.source.tell(this.lzSource);
      if (size === -1) throw this.makeLibzipError(this.libzip.source.error(this.lzSource)); // Move to the start of source

      if (this.libzip.source.seek(this.lzSource, 0, 0, this.libzip.SEEK_SET) === -1) throw this.makeLibzipError(this.libzip.source.error(this.lzSource));
      const buffer = this.libzip.malloc(size);
      if (!buffer) throw new Error(`Couldn't allocate enough memory`);

      try {
        const rc = this.libzip.source.read(this.lzSource, buffer, size);
        if (rc === -1) throw this.makeLibzipError(this.libzip.source.error(this.lzSource));else if (rc < size) throw new Error(`Incomplete read`);else if (rc > size) throw new Error(`Overread`);
        const memory = this.libzip.HEAPU8.subarray(buffer, buffer + size);
        return Buffer.from(memory);
      } finally {
        this.libzip.free(buffer);
      }
    } finally {
      this.libzip.source.close(this.lzSource);
      this.libzip.source.free(this.lzSource);
      this.ready = false;
    }
  }

  prepareClose() {
    if (!this.ready) throw EBUSY(`archive closed, close`);
    unwatchAllFiles(this);
  }

  saveAndClose() {
    if (!this.path || !this.baseFs) throw new Error(`ZipFS cannot be saved and must be discarded when loaded from a buffer`);
    this.prepareClose();

    if (this.readOnly) {
      this.discardAndClose();
      return;
    }

    const previousMod = this.baseFs.existsSync(this.path) ? this.baseFs.statSync(this.path).mode & 0o777 : null;
    const rc = this.libzip.close(this.zip);
    if (rc === -1) throw this.makeLibzipError(this.libzip.getError(this.zip)); // this.libzip overrides the chmod when writing the archive, which is a weird
    // behavior I don't totally understand (plus the umask seems bogus in some
    // weird cases - maybe related to emscripten?)
    //
    // See also https://github.com/nih-at/libzip/issues/77

    if (previousMod === null) this.baseFs.chmodSync(this.path, this.stats.mode);else if (previousMod !== (this.baseFs.statSync(this.path).mode & 0o777)) this.baseFs.chmodSync(this.path, previousMod);
    this.ready = false;
  }

  discardAndClose() {
    this.prepareClose();
    this.libzip.discard(this.zip);
    this.ready = false;
  }

  resolve(p) {
    return ppath.resolve(PortablePath.root, p);
  }

  async openPromise(p, flags, mode) {
    return this.openSync(p, flags, mode);
  }

  openSync(p, flags, mode) {
    const fd = this.nextFd++;
    this.fds.set(fd, {
      cursor: 0,
      p
    });
    return fd;
  }

  hasOpenFileHandles() {
    return !!this.fds.size;
  }

  async opendirPromise(p, opts) {
    return this.opendirSync(p, opts);
  }

  opendirSync(p, opts = {}) {
    const resolvedP = this.resolveFilename(`opendir '${p}'`, p);
    if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) throw ENOENT(`opendir '${p}'`);
    const directoryListing = this.listings.get(resolvedP);
    if (!directoryListing) throw ENOTDIR(`opendir '${p}'`);
    const entries = [...directoryListing];
    const fd = this.openSync(resolvedP, `r`);

    const onClose = () => {
      this.closeSync(fd);
    };

    return opendir(this, resolvedP, entries, {
      onClose
    });
  }

  async readPromise(fd, buffer, offset, length, position) {
    return this.readSync(fd, buffer, offset, length, position);
  }

  readSync(fd, buffer, offset = 0, length = 0, position = -1) {
    const entry = this.fds.get(fd);
    if (typeof entry === `undefined`) throw EBADF(`read`);
    let realPosition;
    if (position === -1 || position === null) realPosition = entry.cursor;else realPosition = position;
    const source = this.readFileSync(entry.p);
    source.copy(buffer, offset, realPosition, realPosition + length);
    const bytesRead = Math.max(0, Math.min(source.length - realPosition, length));
    if (position === -1 || position === null) entry.cursor += bytesRead;
    return bytesRead;
  }

  async writePromise(fd, buffer, offset, length, position) {
    if (typeof buffer === `string`) {
      return this.writeSync(fd, buffer, position);
    } else {
      return this.writeSync(fd, buffer, offset, length, position);
    }
  }

  writeSync(fd, buffer, offset, length, position) {
    const entry = this.fds.get(fd);
    if (typeof entry === `undefined`) throw EBADF(`read`);
    throw new Error(`Unimplemented`);
  }

  async closePromise(fd) {
    return this.closeSync(fd);
  }

  closeSync(fd) {
    const entry = this.fds.get(fd);
    if (typeof entry === `undefined`) throw EBADF(`read`);
    this.fds.delete(fd);
  }

  createReadStream(p, {
    encoding
  } = {}) {
    if (p === null) throw new Error(`Unimplemented`);
    const fd = this.openSync(p, `r`);
    const stream = Object.assign(new external_stream_namespaceObject.PassThrough({
      emitClose: true,
      autoDestroy: true,
      destroy: (error, callback) => {
        clearImmediate(immediate);
        this.closeSync(fd);
        callback(error);
      }
    }), {
      close() {
        stream.destroy();
      },

      bytesRead: 0,
      path: p
    });
    const immediate = setImmediate(async () => {
      try {
        const data = await this.readFilePromise(p, encoding);
        stream.bytesRead = data.length;
        stream.end(data);
      } catch (error) {
        stream.destroy(error);
      }
    });
    return stream;
  }

  createWriteStream(p, {
    encoding
  } = {}) {
    if (this.readOnly) throw EROFS(`open '${p}'`);
    if (p === null) throw new Error(`Unimplemented`);
    const chunks = [];
    const fd = this.openSync(p, `w`);
    const stream = Object.assign(new external_stream_namespaceObject.PassThrough({
      autoDestroy: true,
      emitClose: true,
      destroy: (error, callback) => {
        try {
          if (error) {
            callback(error);
          } else {
            this.writeFileSync(p, Buffer.concat(chunks), encoding);
            callback(null);
          }
        } catch (err) {
          callback(err);
        } finally {
          this.closeSync(fd);
        }
      }
    }), {
      bytesWritten: 0,
      path: p,

      close() {
        stream.destroy();
      }

    });
    stream.on(`data`, chunk => {
      const chunkBuffer = Buffer.from(chunk);
      stream.bytesWritten += chunkBuffer.length;
      chunks.push(chunkBuffer);
    });
    return stream;
  }

  async realpathPromise(p) {
    return this.realpathSync(p);
  }

  realpathSync(p) {
    const resolvedP = this.resolveFilename(`lstat '${p}'`, p);
    if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) throw ENOENT(`lstat '${p}'`);
    return resolvedP;
  }

  async existsPromise(p) {
    return this.existsSync(p);
  }

  existsSync(p) {
    if (!this.ready) throw EBUSY(`archive closed, existsSync '${p}'`);

    if (this.symlinkCount === 0) {
      const resolvedP = ppath.resolve(PortablePath.root, p);
      return this.entries.has(resolvedP) || this.listings.has(resolvedP);
    }

    let resolvedP;

    try {
      resolvedP = this.resolveFilename(`stat '${p}'`, p);
    } catch (error) {
      return false;
    }

    return this.entries.has(resolvedP) || this.listings.has(resolvedP);
  }

  async accessPromise(p, mode) {
    return this.accessSync(p, mode);
  }

  accessSync(p, mode = external_fs_.constants.F_OK) {
    const resolvedP = this.resolveFilename(`access '${p}'`, p);
    if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) throw ENOENT(`access '${p}'`);

    if (this.readOnly && mode & external_fs_.constants.W_OK) {
      throw EROFS(`access '${p}'`);
    }
  }

  async statPromise(p) {
    return this.statSync(p);
  }

  statSync(p) {
    const resolvedP = this.resolveFilename(`stat '${p}'`, p);
    if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) throw ENOENT(`stat '${p}'`);
    if (p[p.length - 1] === `/` && !this.listings.has(resolvedP)) throw ENOTDIR(`stat '${p}'`);
    return this.statImpl(`stat '${p}'`, resolvedP);
  }

  async lstatPromise(p) {
    return this.lstatSync(p);
  }

  lstatSync(p) {
    const resolvedP = this.resolveFilename(`lstat '${p}'`, p, false);
    if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) throw ENOENT(`lstat '${p}'`);
    if (p[p.length - 1] === `/` && !this.listings.has(resolvedP)) throw ENOTDIR(`lstat '${p}'`);
    return this.statImpl(`lstat '${p}'`, resolvedP);
  }

  statImpl(reason, p) {
    const entry = this.entries.get(p); // File, or explicit directory

    if (typeof entry !== `undefined`) {
      const stat = this.libzip.struct.statS();
      const rc = this.libzip.statIndex(this.zip, entry, 0, 0, stat);
      if (rc === -1) throw this.makeLibzipError(this.libzip.getError(this.zip));
      const uid = this.stats.uid;
      const gid = this.stats.gid;
      const size = this.libzip.struct.statSize(stat) >>> 0;
      const blksize = 512;
      const blocks = Math.ceil(size / blksize);
      const mtimeMs = (this.libzip.struct.statMtime(stat) >>> 0) * 1000;
      const atimeMs = mtimeMs;
      const birthtimeMs = mtimeMs;
      const ctimeMs = mtimeMs;
      const atime = new Date(atimeMs);
      const birthtime = new Date(birthtimeMs);
      const ctime = new Date(ctimeMs);
      const mtime = new Date(mtimeMs);
      const type = this.listings.has(p) ? constants_S_IFDIR : this.isSymbolicLink(entry) ? constants_S_IFLNK : constants_S_IFREG;
      const defaultMode = type === constants_S_IFDIR ? 0o755 : 0o644;
      const mode = type | this.getUnixMode(entry, defaultMode) & 0o777;
      return Object.assign(new StatEntry(), {
        uid,
        gid,
        size,
        blksize,
        blocks,
        atime,
        birthtime,
        ctime,
        mtime,
        atimeMs,
        birthtimeMs,
        ctimeMs,
        mtimeMs,
        mode
      });
    } // Implicit directory


    if (this.listings.has(p)) {
      const uid = this.stats.uid;
      const gid = this.stats.gid;
      const size = 0;
      const blksize = 512;
      const blocks = 0;
      const atimeMs = this.stats.mtimeMs;
      const birthtimeMs = this.stats.mtimeMs;
      const ctimeMs = this.stats.mtimeMs;
      const mtimeMs = this.stats.mtimeMs;
      const atime = new Date(atimeMs);
      const birthtime = new Date(birthtimeMs);
      const ctime = new Date(ctimeMs);
      const mtime = new Date(mtimeMs);
      const mode = constants_S_IFDIR | 0o755;
      return Object.assign(new StatEntry(), {
        uid,
        gid,
        size,
        blksize,
        blocks,
        atime,
        birthtime,
        ctime,
        mtime,
        atimeMs,
        birthtimeMs,
        ctimeMs,
        mtimeMs,
        mode
      });
    }

    throw new Error(`Unreachable`);
  }

  getUnixMode(index, defaultMode) {
    const rc = this.libzip.file.getExternalAttributes(this.zip, index, 0, 0, this.libzip.uint08S, this.libzip.uint32S);
    if (rc === -1) throw this.makeLibzipError(this.libzip.getError(this.zip));
    const opsys = this.libzip.getValue(this.libzip.uint08S, `i8`) >>> 0;
    if (opsys !== this.libzip.ZIP_OPSYS_UNIX) return defaultMode;
    return this.libzip.getValue(this.libzip.uint32S, `i32`) >>> 16;
  }

  registerListing(p) {
    let listing = this.listings.get(p);
    if (listing) return listing;
    const parentListing = this.registerListing(ppath.dirname(p));
    listing = new Set();
    parentListing.add(ppath.basename(p));
    this.listings.set(p, listing);
    return listing;
  }

  registerEntry(p, index) {
    const parentListing = this.registerListing(ppath.dirname(p));
    parentListing.add(ppath.basename(p));
    this.entries.set(p, index);
  }

  unregisterListing(p) {
    this.listings.delete(p);
    const parentListing = this.listings.get(ppath.dirname(p));
    parentListing === null || parentListing === void 0 ? void 0 : parentListing.delete(ppath.basename(p));
  }

  unregisterEntry(p) {
    this.unregisterListing(p);
    const entry = this.entries.get(p);
    this.entries.delete(p);
    if (typeof entry === `undefined`) return;
    this.fileSources.delete(entry);

    if (this.isSymbolicLink(entry)) {
      this.symlinkCount--;
    }
  }

  deleteEntry(p, index) {
    this.unregisterEntry(p);
    const rc = this.libzip.delete(this.zip, index);

    if (rc === -1) {
      throw this.makeLibzipError(this.libzip.getError(this.zip));
    }
  }

  resolveFilename(reason, p, resolveLastComponent = true) {
    if (!this.ready) throw EBUSY(`archive closed, ${reason}`);
    let resolvedP = ppath.resolve(PortablePath.root, p);
    if (resolvedP === `/`) return PortablePath.root;
    const fileIndex = this.entries.get(resolvedP);

    if (resolveLastComponent && fileIndex !== undefined) {
      if (this.symlinkCount !== 0 && this.isSymbolicLink(fileIndex)) {
        const target = this.getFileSource(fileIndex).toString();
        return this.resolveFilename(reason, ppath.resolve(ppath.dirname(resolvedP), target), true);
      } else {
        return resolvedP;
      }
    }

    while (true) {
      const parentP = this.resolveFilename(reason, ppath.dirname(resolvedP), true);
      const isDir = this.listings.has(parentP);
      const doesExist = this.entries.has(parentP);
      if (!isDir && !doesExist) throw ENOENT(reason);
      if (!isDir) throw ENOTDIR(reason);
      resolvedP = ppath.resolve(parentP, ppath.basename(resolvedP));
      if (!resolveLastComponent || this.symlinkCount === 0) break;
      const index = this.libzip.name.locate(this.zip, resolvedP.slice(1));
      if (index === -1) break;

      if (this.isSymbolicLink(index)) {
        const target = this.getFileSource(index).toString();
        resolvedP = ppath.resolve(ppath.dirname(resolvedP), target);
      } else {
        break;
      }
    }

    return resolvedP;
  }

  allocateBuffer(content) {
    if (!Buffer.isBuffer(content)) content = Buffer.from(content);
    const buffer = this.libzip.malloc(content.byteLength);
    if (!buffer) throw new Error(`Couldn't allocate enough memory`); // Copy the file into the Emscripten heap

    const heap = new Uint8Array(this.libzip.HEAPU8.buffer, buffer, content.byteLength);
    heap.set(content);
    return {
      buffer,
      byteLength: content.byteLength
    };
  }

  allocateUnattachedSource(content) {
    const error = this.libzip.struct.errorS();
    const {
      buffer,
      byteLength
    } = this.allocateBuffer(content);
    const source = this.libzip.source.fromUnattachedBuffer(buffer, byteLength, 0, true, error);

    if (source === 0) {
      this.libzip.free(error);
      throw this.makeLibzipError(error);
    }

    return source;
  }

  allocateSource(content) {
    const {
      buffer,
      byteLength
    } = this.allocateBuffer(content);
    const source = this.libzip.source.fromBuffer(this.zip, buffer, byteLength, 0, true);

    if (source === 0) {
      this.libzip.free(buffer);
      throw this.makeLibzipError(this.libzip.getError(this.zip));
    }

    return source;
  }

  setFileSource(p, content) {
    const buffer = Buffer.isBuffer(content) ? content : Buffer.from(content);
    const target = ppath.relative(PortablePath.root, p);
    const lzSource = this.allocateSource(content);

    try {
      const newIndex = this.libzip.file.add(this.zip, target, lzSource, this.libzip.ZIP_FL_OVERWRITE);
      if (newIndex === -1) throw this.makeLibzipError(this.libzip.getError(this.zip));

      if (this.level !== `mixed`) {
        // Use store for level 0, and deflate for 1..9
        let method;
        if (this.level === 0) method = this.libzip.ZIP_CM_STORE;else method = this.libzip.ZIP_CM_DEFLATE;
        const rc = this.libzip.file.setCompression(this.zip, newIndex, 0, method, this.level);

        if (rc === -1) {
          throw this.makeLibzipError(this.libzip.getError(this.zip));
        }
      }

      this.fileSources.set(newIndex, buffer);
      return newIndex;
    } catch (error) {
      this.libzip.source.free(lzSource);
      throw error;
    }
  }

  isSymbolicLink(index) {
    if (this.symlinkCount === 0) return false;
    const attrs = this.libzip.file.getExternalAttributes(this.zip, index, 0, 0, this.libzip.uint08S, this.libzip.uint32S);
    if (attrs === -1) throw this.makeLibzipError(this.libzip.getError(this.zip));
    const opsys = this.libzip.getValue(this.libzip.uint08S, `i8`) >>> 0;
    if (opsys !== this.libzip.ZIP_OPSYS_UNIX) return false;
    const attributes = this.libzip.getValue(this.libzip.uint32S, `i32`) >>> 16;
    return (attributes & constants_S_IFMT) === constants_S_IFLNK;
  }

  getFileSource(index, opts = {
    asyncDecompress: false
  }) {
    const cachedFileSource = this.fileSources.get(index);
    if (typeof cachedFileSource !== `undefined`) return cachedFileSource;
    const stat = this.libzip.struct.statS();
    const rc = this.libzip.statIndex(this.zip, index, 0, 0, stat);
    if (rc === -1) throw this.makeLibzipError(this.libzip.getError(this.zip));
    const size = this.libzip.struct.statCompSize(stat);
    const compressionMethod = this.libzip.struct.statCompMethod(stat);
    const buffer = this.libzip.malloc(size);

    try {
      const file = this.libzip.fopenIndex(this.zip, index, 0, this.libzip.ZIP_FL_COMPRESSED);
      if (file === 0) throw this.makeLibzipError(this.libzip.getError(this.zip));

      try {
        const rc = this.libzip.fread(file, buffer, size, 0);
        if (rc === -1) throw this.makeLibzipError(this.libzip.file.getError(file));else if (rc < size) throw new Error(`Incomplete read`);else if (rc > size) throw new Error(`Overread`);
        const memory = this.libzip.HEAPU8.subarray(buffer, buffer + size);
        const data = Buffer.from(memory);

        if (compressionMethod === 0) {
          this.fileSources.set(index, data);
          return data;
        } else if (opts.asyncDecompress) {
          return new Promise((resolve, reject) => {
            external_zlib_default().inflateRaw(data, (error, result) => {
              if (error) {
                reject(error);
              } else {
                this.fileSources.set(index, result);
                resolve(result);
              }
            });
          });
        } else {
          const decompressedData = external_zlib_default().inflateRawSync(data);
          this.fileSources.set(index, decompressedData);
          return decompressedData;
        }
      } finally {
        this.libzip.fclose(file);
      }
    } finally {
      this.libzip.free(buffer);
    }
  }

  async chmodPromise(p, mask) {
    return this.chmodSync(p, mask);
  }

  chmodSync(p, mask) {
    if (this.readOnly) throw EROFS(`chmod '${p}'`); // We don't allow to make the extracted entries group-writable

    mask &= 0o755;
    const resolvedP = this.resolveFilename(`chmod '${p}'`, p, false);
    const entry = this.entries.get(resolvedP);
    if (typeof entry === `undefined`) throw new Error(`Assertion failed: The entry should have been registered (${resolvedP})`);
    const oldMod = this.getUnixMode(entry, constants_S_IFREG | 0o000);
    const newMod = oldMod & ~0o777 | mask;
    const rc = this.libzip.file.setExternalAttributes(this.zip, entry, 0, 0, this.libzip.ZIP_OPSYS_UNIX, newMod << 16);

    if (rc === -1) {
      throw this.makeLibzipError(this.libzip.getError(this.zip));
    }
  }

  async chownPromise(p, uid, gid) {
    return this.chownSync(p, uid, gid);
  }

  chownSync(p, uid, gid) {
    throw new Error(`Unimplemented`);
  }

  async renamePromise(oldP, newP) {
    return this.renameSync(oldP, newP);
  }

  renameSync(oldP, newP) {
    throw new Error(`Unimplemented`);
  }

  async copyFilePromise(sourceP, destP, flags) {
    const {
      indexSource,
      indexDest,
      resolvedDestP
    } = this.prepareCopyFile(sourceP, destP, flags);
    const source = await this.getFileSource(indexSource, {
      asyncDecompress: true
    });
    const newIndex = this.setFileSource(resolvedDestP, source);

    if (newIndex !== indexDest) {
      this.registerEntry(resolvedDestP, newIndex);
    }
  }

  copyFileSync(sourceP, destP, flags = 0) {
    const {
      indexSource,
      indexDest,
      resolvedDestP
    } = this.prepareCopyFile(sourceP, destP, flags);
    const source = this.getFileSource(indexSource);
    const newIndex = this.setFileSource(resolvedDestP, source);

    if (newIndex !== indexDest) {
      this.registerEntry(resolvedDestP, newIndex);
    }
  }

  prepareCopyFile(sourceP, destP, flags = 0) {
    if (this.readOnly) throw EROFS(`copyfile '${sourceP} -> '${destP}'`);
    if ((flags & external_fs_.constants.COPYFILE_FICLONE_FORCE) !== 0) throw ENOSYS(`unsupported clone operation`, `copyfile '${sourceP}' -> ${destP}'`);
    const resolvedSourceP = this.resolveFilename(`copyfile '${sourceP} -> ${destP}'`, sourceP);
    const indexSource = this.entries.get(resolvedSourceP);
    if (typeof indexSource === `undefined`) throw EINVAL(`copyfile '${sourceP}' -> '${destP}'`);
    const resolvedDestP = this.resolveFilename(`copyfile '${sourceP}' -> ${destP}'`, destP);
    const indexDest = this.entries.get(resolvedDestP);
    if ((flags & (external_fs_.constants.COPYFILE_EXCL | external_fs_.constants.COPYFILE_FICLONE_FORCE)) !== 0 && typeof indexDest !== `undefined`) throw EEXIST(`copyfile '${sourceP}' -> '${destP}'`);
    return {
      indexSource,
      resolvedDestP,
      indexDest
    };
  }

  async appendFilePromise(p, content, opts) {
    if (this.readOnly) throw EROFS(`open '${p}'`);
    if (typeof opts === `undefined`) opts = {
      flag: `a`
    };else if (typeof opts === `string`) opts = {
      flag: `a`,
      encoding: opts
    };else if (typeof opts.flag === `undefined`) opts = {
      flag: `a`,
      ...opts
    };
    return this.writeFilePromise(p, content, opts);
  }

  appendFileSync(p, content, opts = {}) {
    if (this.readOnly) throw EROFS(`open '${p}'`);
    if (typeof opts === `undefined`) opts = {
      flag: `a`
    };else if (typeof opts === `string`) opts = {
      flag: `a`,
      encoding: opts
    };else if (typeof opts.flag === `undefined`) opts = {
      flag: `a`,
      ...opts
    };
    return this.writeFileSync(p, content, opts);
  }

  async writeFilePromise(p, content, opts) {
    const {
      encoding,
      index,
      resolvedP
    } = this.prepareWriteFile(p, opts);
    if (index !== undefined && typeof opts === `object` && opts.flag && opts.flag.includes(`a`)) content = Buffer.concat([await this.getFileSource(index, {
      asyncDecompress: true
    }), Buffer.from(content)]);
    if (encoding !== null) content = content.toString(encoding);
    const newIndex = this.setFileSource(resolvedP, content);

    if (newIndex !== index) {
      this.registerEntry(resolvedP, newIndex);
    }
  }

  writeFileSync(p, content, opts) {
    const {
      encoding,
      index,
      resolvedP
    } = this.prepareWriteFile(p, opts);
    if (index !== undefined && typeof opts === `object` && opts.flag && opts.flag.includes(`a`)) content = Buffer.concat([this.getFileSource(index), Buffer.from(content)]);
    if (encoding !== null) content = content.toString(encoding);
    const newIndex = this.setFileSource(resolvedP, content);

    if (newIndex !== index) {
      this.registerEntry(resolvedP, newIndex);
    }
  }

  prepareWriteFile(p, opts) {
    if (typeof p !== `string`) throw EBADF(`read`);
    if (this.readOnly) throw EROFS(`open '${p}'`);
    const resolvedP = this.resolveFilename(`open '${p}'`, p);
    if (this.listings.has(resolvedP)) throw EISDIR(`open '${p}'`);
    let encoding = null;
    if (typeof opts === `string`) encoding = opts;else if (typeof opts === `object` && opts.encoding) encoding = opts.encoding;
    const index = this.entries.get(resolvedP);
    return {
      encoding,
      resolvedP,
      index
    };
  }

  async unlinkPromise(p) {
    return this.unlinkSync(p);
  }

  unlinkSync(p) {
    if (this.readOnly) throw EROFS(`unlink '${p}'`);
    const resolvedP = this.resolveFilename(`unlink '${p}'`, p);
    if (this.listings.has(resolvedP)) throw EISDIR(`unlink '${p}'`);
    const index = this.entries.get(resolvedP);
    if (typeof index === `undefined`) throw EINVAL(`unlink '${p}'`);
    this.deleteEntry(resolvedP, index);
  }

  async utimesPromise(p, atime, mtime) {
    return this.utimesSync(p, atime, mtime);
  }

  utimesSync(p, atime, mtime) {
    if (this.readOnly) throw EROFS(`utimes '${p}'`);
    const resolvedP = this.resolveFilename(`utimes '${p}'`, p);
    this.utimesImpl(resolvedP, mtime);
  }

  async lutimesPromise(p, atime, mtime) {
    return this.lutimesSync(p, atime, mtime);
  }

  lutimesSync(p, atime, mtime) {
    if (this.readOnly) throw EROFS(`lutimes '${p}'`);
    const resolvedP = this.resolveFilename(`utimes '${p}'`, p, false);
    this.utimesImpl(resolvedP, mtime);
  }

  utimesImpl(resolvedP, mtime) {
    if (this.listings.has(resolvedP)) if (!this.entries.has(resolvedP)) this.hydrateDirectory(resolvedP);
    const entry = this.entries.get(resolvedP);
    if (entry === undefined) throw new Error(`Unreachable`);
    const rc = this.libzip.file.setMtime(this.zip, entry, 0, toUnixTimestamp(mtime), 0);

    if (rc === -1) {
      throw this.makeLibzipError(this.libzip.getError(this.zip));
    }
  }

  async mkdirPromise(p, opts) {
    return this.mkdirSync(p, opts);
  }

  mkdirSync(p, {
    mode = 0o755,
    recursive = false
  } = {}) {
    if (recursive) {
      this.mkdirpSync(p, {
        chmod: mode
      });
      return;
    }

    if (this.readOnly) throw EROFS(`mkdir '${p}'`);
    const resolvedP = this.resolveFilename(`mkdir '${p}'`, p);
    if (this.entries.has(resolvedP) || this.listings.has(resolvedP)) throw EEXIST(`mkdir '${p}'`);
    this.hydrateDirectory(resolvedP);
    this.chmodSync(resolvedP, mode);
  }

  async rmdirPromise(p, opts) {
    return this.rmdirSync(p, opts);
  }

  rmdirSync(p, {
    recursive = false
  } = {}) {
    if (this.readOnly) throw EROFS(`rmdir '${p}'`);

    if (recursive) {
      this.removeSync(p);
      return;
    }

    const resolvedP = this.resolveFilename(`rmdir '${p}'`, p);
    const directoryListing = this.listings.get(resolvedP);
    if (!directoryListing) throw ENOTDIR(`rmdir '${p}'`);
    if (directoryListing.size > 0) throw ENOTEMPTY(`rmdir '${p}'`);
    const index = this.entries.get(resolvedP);
    if (typeof index === `undefined`) throw EINVAL(`rmdir '${p}'`);
    this.deleteEntry(p, index);
  }

  hydrateDirectory(resolvedP) {
    const index = this.libzip.dir.add(this.zip, ppath.relative(PortablePath.root, resolvedP));
    if (index === -1) throw this.makeLibzipError(this.libzip.getError(this.zip));
    this.registerListing(resolvedP);
    this.registerEntry(resolvedP, index);
    return index;
  }

  async linkPromise(existingP, newP) {
    return this.linkSync(existingP, newP);
  }

  linkSync(existingP, newP) {
    // Zip archives don't support hard links:
    // https://stackoverflow.com/questions/8859616/are-hard-links-possible-within-a-zip-archive
    throw EOPNOTSUPP(`link '${existingP}' -> '${newP}'`);
  }

  async symlinkPromise(target, p) {
    return this.symlinkSync(target, p);
  }

  symlinkSync(target, p) {
    if (this.readOnly) throw EROFS(`symlink '${target}' -> '${p}'`);
    const resolvedP = this.resolveFilename(`symlink '${target}' -> '${p}'`, p);
    if (this.listings.has(resolvedP)) throw EISDIR(`symlink '${target}' -> '${p}'`);
    if (this.entries.has(resolvedP)) throw EEXIST(`symlink '${target}' -> '${p}'`);
    const index = this.setFileSource(resolvedP, target);
    this.registerEntry(resolvedP, index);
    const rc = this.libzip.file.setExternalAttributes(this.zip, index, 0, 0, this.libzip.ZIP_OPSYS_UNIX, (constants_S_IFLNK | 0o777) << 16);
    if (rc === -1) throw this.makeLibzipError(this.libzip.getError(this.zip));
    this.symlinkCount += 1;
  }

  async readFilePromise(p, encoding) {
    // This is messed up regarding the TS signatures
    if (typeof encoding === `object`) // @ts-expect-error
      encoding = encoding ? encoding.encoding : undefined;
    const data = await this.readFileBuffer(p, {
      asyncDecompress: true
    });
    return encoding ? data.toString(encoding) : data;
  }

  readFileSync(p, encoding) {
    // This is messed up regarding the TS signatures
    if (typeof encoding === `object`) // @ts-expect-error
      encoding = encoding ? encoding.encoding : undefined;
    const data = this.readFileBuffer(p);
    return encoding ? data.toString(encoding) : data;
  }

  readFileBuffer(p, opts = {
    asyncDecompress: false
  }) {
    if (typeof p !== `string`) throw EBADF(`read`);
    const resolvedP = this.resolveFilename(`open '${p}'`, p);
    if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) throw ENOENT(`open '${p}'`); // Ensures that the last component is a directory, if the user said so (even if it is we'll throw right after with EISDIR anyway)

    if (p[p.length - 1] === `/` && !this.listings.has(resolvedP)) throw ENOTDIR(`open '${p}'`);
    if (this.listings.has(resolvedP)) throw EISDIR(`read`);
    const entry = this.entries.get(resolvedP);
    if (entry === undefined) throw new Error(`Unreachable`);
    return this.getFileSource(entry, opts);
  }

  async readdirPromise(p, {
    withFileTypes
  } = {}) {
    return this.readdirSync(p, {
      withFileTypes: withFileTypes
    });
  }

  readdirSync(p, {
    withFileTypes
  } = {}) {
    const resolvedP = this.resolveFilename(`scandir '${p}'`, p);
    if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) throw ENOENT(`scandir '${p}'`);
    const directoryListing = this.listings.get(resolvedP);
    if (!directoryListing) throw ENOTDIR(`scandir '${p}'`);
    const entries = [...directoryListing];
    if (!withFileTypes) return entries;
    return entries.map(name => {
      return Object.assign(this.statImpl(`lstat`, ppath.join(p, name)), {
        name
      });
    });
  }

  async readlinkPromise(p) {
    const entry = this.prepareReadlink(p);
    return (await this.getFileSource(entry, {
      asyncDecompress: true
    })).toString();
  }

  readlinkSync(p) {
    const entry = this.prepareReadlink(p);
    return this.getFileSource(entry).toString();
  }

  prepareReadlink(p) {
    const resolvedP = this.resolveFilename(`readlink '${p}'`, p, false);
    if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) throw ENOENT(`readlink '${p}'`); // Ensure that the last component is a directory (if it is we'll throw right after with EISDIR anyway)

    if (p[p.length - 1] === `/` && !this.listings.has(resolvedP)) throw ENOTDIR(`open '${p}'`);
    if (this.listings.has(resolvedP)) throw EINVAL(`readlink '${p}'`);
    const entry = this.entries.get(resolvedP);
    if (entry === undefined) throw new Error(`Unreachable`);
    if (!this.isSymbolicLink(entry)) throw EINVAL(`readlink '${p}'`);
    return entry;
  }

  async truncatePromise(p, len = 0) {
    const resolvedP = this.resolveFilename(`open '${p}'`, p);
    const index = this.entries.get(resolvedP);
    if (typeof index === `undefined`) throw EINVAL(`open '${p}'`);
    const source = await this.getFileSource(index, {
      asyncDecompress: true
    });
    const truncated = Buffer.alloc(len, 0x00);
    source.copy(truncated);
    return await this.writeFilePromise(p, truncated);
  }

  truncateSync(p, len = 0) {
    const resolvedP = this.resolveFilename(`open '${p}'`, p);
    const index = this.entries.get(resolvedP);
    if (typeof index === `undefined`) throw EINVAL(`open '${p}'`);
    const source = this.getFileSource(index);
    const truncated = Buffer.alloc(len, 0x00);
    source.copy(truncated);
    return this.writeFileSync(p, truncated);
  }

  watch(p, a, b) {
    let persistent;

    switch (typeof a) {
      case `function`:
      case `string`:
      case `undefined`:
        {
          persistent = true;
        }
        break;

      default:
        {
          ({
            persistent = true
          } = a);
        }
        break;
    }

    if (!persistent) return {
      on: () => {},
      close: () => {}
    };
    const interval = setInterval(() => {}, 24 * 60 * 60 * 1000);
    return {
      on: () => {},
      close: () => {
        clearInterval(interval);
      }
    };
  }

  watchFile(p, a, b) {
    const resolvedP = this.resolveFilename(`open '${p}'`, p);
    return watchFile(this, resolvedP, a, b);
  }

  unwatchFile(p, cb) {
    const resolvedP = this.resolveFilename(`open '${p}'`, p);
    return unwatchFile(this, resolvedP, cb);
  }

}
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/ZipOpenFS.ts






const ZIP_FD = 0x80000000;
const FILE_PARTS_REGEX = /.*?(?<!\/)\.zip(?=\/|$)/;
class ZipOpenFS extends BasePortableFakeFS {
  constructor({
    libzip,
    baseFs = new NodeFS(),
    filter = null,
    maxOpenFiles = Infinity,
    readOnlyArchives = false,
    useCache = true,
    maxAge = 5000
  }) {
    super();
    this.fdMap = new Map();
    this.nextFd = 3;
    this.isZip = new Set();
    this.notZip = new Set();
    this.realPaths = new Map();
    this.limitOpenFilesTimeout = null;
    this.libzip = libzip;
    this.baseFs = baseFs;
    this.zipInstances = useCache ? new Map() : null;
    this.filter = filter;
    this.maxOpenFiles = maxOpenFiles;
    this.readOnlyArchives = readOnlyArchives;
    this.maxAge = maxAge;
  }

  static async openPromise(fn, opts) {
    const zipOpenFs = new ZipOpenFS(opts);

    try {
      return await fn(zipOpenFs);
    } finally {
      zipOpenFs.saveAndClose();
    }
  }

  getExtractHint(hints) {
    return this.baseFs.getExtractHint(hints);
  }

  getRealPath() {
    return this.baseFs.getRealPath();
  }

  saveAndClose() {
    unwatchAllFiles(this);

    if (this.zipInstances) {
      for (const [path, {
        zipFs
      }] of this.zipInstances.entries()) {
        zipFs.saveAndClose();
        this.zipInstances.delete(path);
      }
    }
  }

  discardAndClose() {
    unwatchAllFiles(this);

    if (this.zipInstances) {
      for (const [path, {
        zipFs
      }] of this.zipInstances.entries()) {
        zipFs.discardAndClose();
        this.zipInstances.delete(path);
      }
    }
  }

  resolve(p) {
    return this.baseFs.resolve(p);
  }

  remapFd(zipFs, fd) {
    const remappedFd = this.nextFd++ | ZIP_FD;
    this.fdMap.set(remappedFd, [zipFs, fd]);
    return remappedFd;
  }

  async openPromise(p, flags, mode) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.openPromise(p, flags, mode);
    }, async (zipFs, {
      subPath
    }) => {
      return this.remapFd(zipFs, await zipFs.openPromise(subPath, flags, mode));
    });
  }

  openSync(p, flags, mode) {
    return this.makeCallSync(p, () => {
      return this.baseFs.openSync(p, flags, mode);
    }, (zipFs, {
      subPath
    }) => {
      return this.remapFd(zipFs, zipFs.openSync(subPath, flags, mode));
    });
  }

  async opendirPromise(p, opts) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.opendirPromise(p, opts);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.opendirPromise(subPath, opts);
    }, {
      requireSubpath: false
    });
  }

  opendirSync(p, opts) {
    return this.makeCallSync(p, () => {
      return this.baseFs.opendirSync(p, opts);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.opendirSync(subPath, opts);
    }, {
      requireSubpath: false
    });
  }

  async readPromise(fd, buffer, offset, length, position) {
    if ((fd & ZIP_FD) === 0) return await this.baseFs.readPromise(fd, buffer, offset, length, position);
    const entry = this.fdMap.get(fd);
    if (typeof entry === `undefined`) throw Object.assign(new Error(`EBADF: bad file descriptor, read`), {
      code: `EBADF`
    });
    const [zipFs, realFd] = entry;
    return await zipFs.readPromise(realFd, buffer, offset, length, position);
  }

  readSync(fd, buffer, offset, length, position) {
    if ((fd & ZIP_FD) === 0) return this.baseFs.readSync(fd, buffer, offset, length, position);
    const entry = this.fdMap.get(fd);
    if (typeof entry === `undefined`) throw Object.assign(new Error(`EBADF: bad file descriptor, read`), {
      code: `EBADF`
    });
    const [zipFs, realFd] = entry;
    return zipFs.readSync(realFd, buffer, offset, length, position);
  }

  async writePromise(fd, buffer, offset, length, position) {
    if ((fd & ZIP_FD) === 0) {
      if (typeof buffer === `string`) {
        return await this.baseFs.writePromise(fd, buffer, offset);
      } else {
        return await this.baseFs.writePromise(fd, buffer, offset, length, position);
      }
    }

    const entry = this.fdMap.get(fd);
    if (typeof entry === `undefined`) throw Object.assign(new Error(`EBADF: bad file descriptor, write`), {
      code: `EBADF`
    });
    const [zipFs, realFd] = entry;

    if (typeof buffer === `string`) {
      return await zipFs.writePromise(realFd, buffer, offset);
    } else {
      return await zipFs.writePromise(realFd, buffer, offset, length, position);
    }
  }

  writeSync(fd, buffer, offset, length, position) {
    if ((fd & ZIP_FD) === 0) {
      if (typeof buffer === `string`) {
        return this.baseFs.writeSync(fd, buffer, offset);
      } else {
        return this.baseFs.writeSync(fd, buffer, offset, length, position);
      }
    }

    const entry = this.fdMap.get(fd);
    if (typeof entry === `undefined`) throw Object.assign(new Error(`EBADF: bad file descriptor, write`), {
      code: `EBADF`
    });
    const [zipFs, realFd] = entry;

    if (typeof buffer === `string`) {
      return zipFs.writeSync(realFd, buffer, offset);
    } else {
      return zipFs.writeSync(realFd, buffer, offset, length, position);
    }
  }

  async closePromise(fd) {
    if ((fd & ZIP_FD) === 0) return await this.baseFs.closePromise(fd);
    const entry = this.fdMap.get(fd);
    if (typeof entry === `undefined`) throw Object.assign(new Error(`EBADF: bad file descriptor, close`), {
      code: `EBADF`
    });
    this.fdMap.delete(fd);
    const [zipFs, realFd] = entry;
    return await zipFs.closePromise(realFd);
  }

  closeSync(fd) {
    if ((fd & ZIP_FD) === 0) return this.baseFs.closeSync(fd);
    const entry = this.fdMap.get(fd);
    if (typeof entry === `undefined`) throw Object.assign(new Error(`EBADF: bad file descriptor, close`), {
      code: `EBADF`
    });
    this.fdMap.delete(fd);
    const [zipFs, realFd] = entry;
    return zipFs.closeSync(realFd);
  }

  createReadStream(p, opts) {
    if (p === null) return this.baseFs.createReadStream(p, opts);
    return this.makeCallSync(p, () => {
      return this.baseFs.createReadStream(p, opts);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.createReadStream(subPath, opts);
    });
  }

  createWriteStream(p, opts) {
    if (p === null) return this.baseFs.createWriteStream(p, opts);
    return this.makeCallSync(p, () => {
      return this.baseFs.createWriteStream(p, opts);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.createWriteStream(subPath, opts);
    });
  }

  async realpathPromise(p) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.realpathPromise(p);
    }, async (zipFs, {
      archivePath,
      subPath
    }) => {
      let realArchivePath = this.realPaths.get(archivePath);

      if (typeof realArchivePath === `undefined`) {
        realArchivePath = await this.baseFs.realpathPromise(archivePath);
        this.realPaths.set(archivePath, realArchivePath);
      }

      return this.pathUtils.join(realArchivePath, this.pathUtils.relative(PortablePath.root, await zipFs.realpathPromise(subPath)));
    });
  }

  realpathSync(p) {
    return this.makeCallSync(p, () => {
      return this.baseFs.realpathSync(p);
    }, (zipFs, {
      archivePath,
      subPath
    }) => {
      let realArchivePath = this.realPaths.get(archivePath);

      if (typeof realArchivePath === `undefined`) {
        realArchivePath = this.baseFs.realpathSync(archivePath);
        this.realPaths.set(archivePath, realArchivePath);
      }

      return this.pathUtils.join(realArchivePath, this.pathUtils.relative(PortablePath.root, zipFs.realpathSync(subPath)));
    });
  }

  async existsPromise(p) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.existsPromise(p);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.existsPromise(subPath);
    });
  }

  existsSync(p) {
    return this.makeCallSync(p, () => {
      return this.baseFs.existsSync(p);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.existsSync(subPath);
    });
  }

  async accessPromise(p, mode) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.accessPromise(p, mode);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.accessPromise(subPath, mode);
    });
  }

  accessSync(p, mode) {
    return this.makeCallSync(p, () => {
      return this.baseFs.accessSync(p, mode);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.accessSync(subPath, mode);
    });
  }

  async statPromise(p) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.statPromise(p);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.statPromise(subPath);
    });
  }

  statSync(p) {
    return this.makeCallSync(p, () => {
      return this.baseFs.statSync(p);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.statSync(subPath);
    });
  }

  async lstatPromise(p) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.lstatPromise(p);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.lstatPromise(subPath);
    });
  }

  lstatSync(p) {
    return this.makeCallSync(p, () => {
      return this.baseFs.lstatSync(p);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.lstatSync(subPath);
    });
  }

  async chmodPromise(p, mask) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.chmodPromise(p, mask);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.chmodPromise(subPath, mask);
    });
  }

  chmodSync(p, mask) {
    return this.makeCallSync(p, () => {
      return this.baseFs.chmodSync(p, mask);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.chmodSync(subPath, mask);
    });
  }

  async chownPromise(p, uid, gid) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.chownPromise(p, uid, gid);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.chownPromise(subPath, uid, gid);
    });
  }

  chownSync(p, uid, gid) {
    return this.makeCallSync(p, () => {
      return this.baseFs.chownSync(p, uid, gid);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.chownSync(subPath, uid, gid);
    });
  }

  async renamePromise(oldP, newP) {
    return await this.makeCallPromise(oldP, async () => {
      return await this.makeCallPromise(newP, async () => {
        return await this.baseFs.renamePromise(oldP, newP);
      }, async () => {
        throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), {
          code: `EEXDEV`
        });
      });
    }, async (zipFsO, {
      subPath: subPathO
    }) => {
      return await this.makeCallPromise(newP, async () => {
        throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), {
          code: `EEXDEV`
        });
      }, async (zipFsN, {
        subPath: subPathN
      }) => {
        if (zipFsO !== zipFsN) {
          throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), {
            code: `EEXDEV`
          });
        } else {
          return await zipFsO.renamePromise(subPathO, subPathN);
        }
      });
    });
  }

  renameSync(oldP, newP) {
    return this.makeCallSync(oldP, () => {
      return this.makeCallSync(newP, () => {
        return this.baseFs.renameSync(oldP, newP);
      }, async () => {
        throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), {
          code: `EEXDEV`
        });
      });
    }, (zipFsO, {
      subPath: subPathO
    }) => {
      return this.makeCallSync(newP, () => {
        throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), {
          code: `EEXDEV`
        });
      }, (zipFsN, {
        subPath: subPathN
      }) => {
        if (zipFsO !== zipFsN) {
          throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), {
            code: `EEXDEV`
          });
        } else {
          return zipFsO.renameSync(subPathO, subPathN);
        }
      });
    });
  }

  async copyFilePromise(sourceP, destP, flags = 0) {
    const fallback = async (sourceFs, sourceP, destFs, destP) => {
      if ((flags & external_fs_.constants.COPYFILE_FICLONE_FORCE) !== 0) throw Object.assign(new Error(`EXDEV: cross-device clone not permitted, copyfile '${sourceP}' -> ${destP}'`), {
        code: `EXDEV`
      });
      if (flags & external_fs_.constants.COPYFILE_EXCL && (await this.existsPromise(sourceP))) throw Object.assign(new Error(`EEXIST: file already exists, copyfile '${sourceP}' -> '${destP}'`), {
        code: `EEXIST`
      });
      let content;

      try {
        content = await sourceFs.readFilePromise(sourceP);
      } catch (error) {
        throw Object.assign(new Error(`EINVAL: invalid argument, copyfile '${sourceP}' -> '${destP}'`), {
          code: `EINVAL`
        });
      }

      await destFs.writeFilePromise(destP, content);
    };

    return await this.makeCallPromise(sourceP, async () => {
      return await this.makeCallPromise(destP, async () => {
        return await this.baseFs.copyFilePromise(sourceP, destP, flags);
      }, async (zipFsD, {
        subPath: subPathD
      }) => {
        return await fallback(this.baseFs, sourceP, zipFsD, subPathD);
      });
    }, async (zipFsS, {
      subPath: subPathS
    }) => {
      return await this.makeCallPromise(destP, async () => {
        return await fallback(zipFsS, subPathS, this.baseFs, destP);
      }, async (zipFsD, {
        subPath: subPathD
      }) => {
        if (zipFsS !== zipFsD) {
          return await fallback(zipFsS, subPathS, zipFsD, subPathD);
        } else {
          return await zipFsS.copyFilePromise(subPathS, subPathD, flags);
        }
      });
    });
  }

  copyFileSync(sourceP, destP, flags = 0) {
    const fallback = (sourceFs, sourceP, destFs, destP) => {
      if ((flags & external_fs_.constants.COPYFILE_FICLONE_FORCE) !== 0) throw Object.assign(new Error(`EXDEV: cross-device clone not permitted, copyfile '${sourceP}' -> ${destP}'`), {
        code: `EXDEV`
      });
      if (flags & external_fs_.constants.COPYFILE_EXCL && this.existsSync(sourceP)) throw Object.assign(new Error(`EEXIST: file already exists, copyfile '${sourceP}' -> '${destP}'`), {
        code: `EEXIST`
      });
      let content;

      try {
        content = sourceFs.readFileSync(sourceP);
      } catch (error) {
        throw Object.assign(new Error(`EINVAL: invalid argument, copyfile '${sourceP}' -> '${destP}'`), {
          code: `EINVAL`
        });
      }

      destFs.writeFileSync(destP, content);
    };

    return this.makeCallSync(sourceP, () => {
      return this.makeCallSync(destP, () => {
        return this.baseFs.copyFileSync(sourceP, destP, flags);
      }, (zipFsD, {
        subPath: subPathD
      }) => {
        return fallback(this.baseFs, sourceP, zipFsD, subPathD);
      });
    }, (zipFsS, {
      subPath: subPathS
    }) => {
      return this.makeCallSync(destP, () => {
        return fallback(zipFsS, subPathS, this.baseFs, destP);
      }, (zipFsD, {
        subPath: subPathD
      }) => {
        if (zipFsS !== zipFsD) {
          return fallback(zipFsS, subPathS, zipFsD, subPathD);
        } else {
          return zipFsS.copyFileSync(subPathS, subPathD, flags);
        }
      });
    });
  }

  async appendFilePromise(p, content, opts) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.appendFilePromise(p, content, opts);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.appendFilePromise(subPath, content, opts);
    });
  }

  appendFileSync(p, content, opts) {
    return this.makeCallSync(p, () => {
      return this.baseFs.appendFileSync(p, content, opts);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.appendFileSync(subPath, content, opts);
    });
  }

  async writeFilePromise(p, content, opts) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.writeFilePromise(p, content, opts);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.writeFilePromise(subPath, content, opts);
    });
  }

  writeFileSync(p, content, opts) {
    return this.makeCallSync(p, () => {
      return this.baseFs.writeFileSync(p, content, opts);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.writeFileSync(subPath, content, opts);
    });
  }

  async unlinkPromise(p) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.unlinkPromise(p);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.unlinkPromise(subPath);
    });
  }

  unlinkSync(p) {
    return this.makeCallSync(p, () => {
      return this.baseFs.unlinkSync(p);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.unlinkSync(subPath);
    });
  }

  async utimesPromise(p, atime, mtime) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.utimesPromise(p, atime, mtime);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.utimesPromise(subPath, atime, mtime);
    });
  }

  utimesSync(p, atime, mtime) {
    return this.makeCallSync(p, () => {
      return this.baseFs.utimesSync(p, atime, mtime);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.utimesSync(subPath, atime, mtime);
    });
  }

  async mkdirPromise(p, opts) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.mkdirPromise(p, opts);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.mkdirPromise(subPath, opts);
    });
  }

  mkdirSync(p, opts) {
    return this.makeCallSync(p, () => {
      return this.baseFs.mkdirSync(p, opts);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.mkdirSync(subPath, opts);
    });
  }

  async rmdirPromise(p, opts) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.rmdirPromise(p, opts);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.rmdirPromise(subPath, opts);
    });
  }

  rmdirSync(p, opts) {
    return this.makeCallSync(p, () => {
      return this.baseFs.rmdirSync(p, opts);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.rmdirSync(subPath, opts);
    });
  }

  async linkPromise(existingP, newP) {
    return await this.makeCallPromise(newP, async () => {
      return await this.baseFs.linkPromise(existingP, newP);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.linkPromise(existingP, subPath);
    });
  }

  linkSync(existingP, newP) {
    return this.makeCallSync(newP, () => {
      return this.baseFs.linkSync(existingP, newP);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.linkSync(existingP, subPath);
    });
  }

  async symlinkPromise(target, p, type) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.symlinkPromise(target, p, type);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.symlinkPromise(target, subPath);
    });
  }

  symlinkSync(target, p, type) {
    return this.makeCallSync(p, () => {
      return this.baseFs.symlinkSync(target, p, type);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.symlinkSync(target, subPath);
    });
  }

  async readFilePromise(p, encoding) {
    return this.makeCallPromise(p, async () => {
      // This weird switch is required to tell TypeScript that the signatures are proper (otherwise it thinks that only the generic one is covered)
      switch (encoding) {
        case `utf8`:
          return await this.baseFs.readFilePromise(p, encoding);

        default:
          return await this.baseFs.readFilePromise(p, encoding);
      }
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.readFilePromise(subPath, encoding);
    });
  }

  readFileSync(p, encoding) {
    return this.makeCallSync(p, () => {
      // This weird switch is required to tell TypeScript that the signatures are proper (otherwise it thinks that only the generic one is covered)
      switch (encoding) {
        case `utf8`:
          return this.baseFs.readFileSync(p, encoding);

        default:
          return this.baseFs.readFileSync(p, encoding);
      }
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.readFileSync(subPath, encoding);
    });
  }

  async readdirPromise(p, {
    withFileTypes
  } = {}) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.readdirPromise(p, {
        withFileTypes: withFileTypes
      });
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.readdirPromise(subPath, {
        withFileTypes: withFileTypes
      });
    }, {
      requireSubpath: false
    });
  }

  readdirSync(p, {
    withFileTypes
  } = {}) {
    return this.makeCallSync(p, () => {
      return this.baseFs.readdirSync(p, {
        withFileTypes: withFileTypes
      });
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.readdirSync(subPath, {
        withFileTypes: withFileTypes
      });
    }, {
      requireSubpath: false
    });
  }

  async readlinkPromise(p) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.readlinkPromise(p);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.readlinkPromise(subPath);
    });
  }

  readlinkSync(p) {
    return this.makeCallSync(p, () => {
      return this.baseFs.readlinkSync(p);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.readlinkSync(subPath);
    });
  }

  async truncatePromise(p, len) {
    return await this.makeCallPromise(p, async () => {
      return await this.baseFs.truncatePromise(p, len);
    }, async (zipFs, {
      subPath
    }) => {
      return await zipFs.truncatePromise(subPath, len);
    });
  }

  truncateSync(p, len) {
    return this.makeCallSync(p, () => {
      return this.baseFs.truncateSync(p, len);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.truncateSync(subPath, len);
    });
  }

  watch(p, a, b) {
    return this.makeCallSync(p, () => {
      return this.baseFs.watch(p, // @ts-expect-error
      a, b);
    }, (zipFs, {
      subPath
    }) => {
      return zipFs.watch(subPath, // @ts-expect-error
      a, b);
    });
  }

  watchFile(p, a, b) {
    return this.makeCallSync(p, () => {
      return this.baseFs.watchFile(p, // @ts-expect-error
      a, b);
    }, () => {
      return watchFile(this, p, a, b);
    });
  }

  unwatchFile(p, cb) {
    return this.makeCallSync(p, () => {
      return this.baseFs.unwatchFile(p, cb);
    }, () => {
      return unwatchFile(this, p, cb);
    });
  }

  async makeCallPromise(p, discard, accept, {
    requireSubpath = true
  } = {}) {
    if (typeof p !== `string`) return await discard();
    const normalizedP = this.resolve(p);
    const zipInfo = this.findZip(normalizedP);
    if (!zipInfo) return await discard();
    if (requireSubpath && zipInfo.subPath === `/`) return await discard();
    return await this.getZipPromise(zipInfo.archivePath, async zipFs => await accept(zipFs, zipInfo));
  }

  makeCallSync(p, discard, accept, {
    requireSubpath = true
  } = {}) {
    if (typeof p !== `string`) return discard();
    const normalizedP = this.resolve(p);
    const zipInfo = this.findZip(normalizedP);
    if (!zipInfo) return discard();
    if (requireSubpath && zipInfo.subPath === `/`) return discard();
    return this.getZipSync(zipInfo.archivePath, zipFs => accept(zipFs, zipInfo));
  }

  findZip(p) {
    if (this.filter && !this.filter.test(p)) return null;
    let filePath = ``;

    while (true) {
      const parts = FILE_PARTS_REGEX.exec(p.slice(filePath.length));
      if (!parts) return null;
      filePath = this.pathUtils.join(filePath, parts[0]);

      if (this.isZip.has(filePath) === false) {
        if (this.notZip.has(filePath)) continue;

        try {
          if (!this.baseFs.lstatSync(filePath).isFile()) {
            this.notZip.add(filePath);
            continue;
          }
        } catch (_a) {
          return null;
        }

        this.isZip.add(filePath);
      }

      return {
        archivePath: filePath,
        subPath: this.pathUtils.join(PortablePath.root, p.slice(filePath.length))
      };
    }
  }

  limitOpenFiles(max) {
    if (this.zipInstances === null) return;
    const now = Date.now();
    let nextExpiresAt = now + this.maxAge;
    let closeCount = max === null ? 0 : this.zipInstances.size - max;

    for (const [path, {
      zipFs,
      expiresAt,
      refCount
    }] of this.zipInstances.entries()) {
      if (refCount !== 0 || zipFs.hasOpenFileHandles()) {
        continue;
      } else if (now >= expiresAt) {
        zipFs.saveAndClose();
        this.zipInstances.delete(path);
        closeCount -= 1;
        continue;
      } else if (max === null || closeCount <= 0) {
        nextExpiresAt = expiresAt;
        break;
      }

      zipFs.saveAndClose();
      this.zipInstances.delete(path);
      closeCount -= 1;
    }

    if (this.limitOpenFilesTimeout === null && (max === null && this.zipInstances.size > 0 || max !== null)) {
      this.limitOpenFilesTimeout = setTimeout(() => {
        this.limitOpenFilesTimeout = null;
        this.limitOpenFiles(null);
      }, nextExpiresAt - now).unref();
    }
  }

  async getZipPromise(p, accept) {
    const getZipOptions = async () => ({
      baseFs: this.baseFs,
      libzip: this.libzip,
      readOnly: this.readOnlyArchives,
      stats: await this.baseFs.statPromise(p)
    });

    if (this.zipInstances) {
      let cachedZipFs = this.zipInstances.get(p);

      if (!cachedZipFs) {
        const zipOptions = await getZipOptions(); // We need to recheck because concurrent getZipPromise calls may
        // have instantiated the zip archive while we were waiting

        cachedZipFs = this.zipInstances.get(p);

        if (!cachedZipFs) {
          cachedZipFs = {
            zipFs: new ZipFS(p, zipOptions),
            expiresAt: 0,
            refCount: 0
          };
        }
      } // Removing then re-adding the field allows us to easily implement
      // a basic LRU garbage collection strategy


      this.zipInstances.delete(p);
      this.limitOpenFiles(this.maxOpenFiles - 1);
      this.zipInstances.set(p, cachedZipFs);
      cachedZipFs.expiresAt = Date.now() + this.maxAge;
      cachedZipFs.refCount += 1;

      try {
        return await accept(cachedZipFs.zipFs);
      } finally {
        cachedZipFs.refCount -= 1;
      }
    } else {
      const zipFs = new ZipFS(p, await getZipOptions());

      try {
        return await accept(zipFs);
      } finally {
        zipFs.saveAndClose();
      }
    }
  }

  getZipSync(p, accept) {
    const getZipOptions = () => ({
      baseFs: this.baseFs,
      libzip: this.libzip,
      readOnly: this.readOnlyArchives,
      stats: this.baseFs.statSync(p)
    });

    if (this.zipInstances) {
      let cachedZipFs = this.zipInstances.get(p);

      if (!cachedZipFs) {
        cachedZipFs = {
          zipFs: new ZipFS(p, getZipOptions()),
          expiresAt: 0,
          refCount: 0
        };
      } // Removing then re-adding the field allows us to easily implement
      // a basic LRU garbage collection strategy


      this.zipInstances.delete(p);
      this.limitOpenFiles(this.maxOpenFiles - 1);
      this.zipInstances.set(p, cachedZipFs);
      cachedZipFs.expiresAt = Date.now() + this.maxAge;
      return accept(cachedZipFs.zipFs);
    } else {
      const zipFs = new ZipFS(p, getZipOptions());

      try {
        return accept(zipFs);
      } finally {
        zipFs.saveAndClose();
      }
    }
  }

}
// CONCATENATED MODULE: ../yarnpkg-libzip/sources/makeInterface.ts
const number64 = [`number`, `number`];
var Errors;

(function (Errors) {
  Errors[Errors["ZIP_ER_OK"] = 0] = "ZIP_ER_OK";
  Errors[Errors["ZIP_ER_MULTIDISK"] = 1] = "ZIP_ER_MULTIDISK";
  Errors[Errors["ZIP_ER_RENAME"] = 2] = "ZIP_ER_RENAME";
  Errors[Errors["ZIP_ER_CLOSE"] = 3] = "ZIP_ER_CLOSE";
  Errors[Errors["ZIP_ER_SEEK"] = 4] = "ZIP_ER_SEEK";
  Errors[Errors["ZIP_ER_READ"] = 5] = "ZIP_ER_READ";
  Errors[Errors["ZIP_ER_WRITE"] = 6] = "ZIP_ER_WRITE";
  Errors[Errors["ZIP_ER_CRC"] = 7] = "ZIP_ER_CRC";
  Errors[Errors["ZIP_ER_ZIPCLOSED"] = 8] = "ZIP_ER_ZIPCLOSED";
  Errors[Errors["ZIP_ER_NOENT"] = 9] = "ZIP_ER_NOENT";
  Errors[Errors["ZIP_ER_EXISTS"] = 10] = "ZIP_ER_EXISTS";
  Errors[Errors["ZIP_ER_OPEN"] = 11] = "ZIP_ER_OPEN";
  Errors[Errors["ZIP_ER_TMPOPEN"] = 12] = "ZIP_ER_TMPOPEN";
  Errors[Errors["ZIP_ER_ZLIB"] = 13] = "ZIP_ER_ZLIB";
  Errors[Errors["ZIP_ER_MEMORY"] = 14] = "ZIP_ER_MEMORY";
  Errors[Errors["ZIP_ER_CHANGED"] = 15] = "ZIP_ER_CHANGED";
  Errors[Errors["ZIP_ER_COMPNOTSUPP"] = 16] = "ZIP_ER_COMPNOTSUPP";
  Errors[Errors["ZIP_ER_EOF"] = 17] = "ZIP_ER_EOF";
  Errors[Errors["ZIP_ER_INVAL"] = 18] = "ZIP_ER_INVAL";
  Errors[Errors["ZIP_ER_NOZIP"] = 19] = "ZIP_ER_NOZIP";
  Errors[Errors["ZIP_ER_INTERNAL"] = 20] = "ZIP_ER_INTERNAL";
  Errors[Errors["ZIP_ER_INCONS"] = 21] = "ZIP_ER_INCONS";
  Errors[Errors["ZIP_ER_REMOVE"] = 22] = "ZIP_ER_REMOVE";
  Errors[Errors["ZIP_ER_DELETED"] = 23] = "ZIP_ER_DELETED";
  Errors[Errors["ZIP_ER_ENCRNOTSUPP"] = 24] = "ZIP_ER_ENCRNOTSUPP";
  Errors[Errors["ZIP_ER_RDONLY"] = 25] = "ZIP_ER_RDONLY";
  Errors[Errors["ZIP_ER_NOPASSWD"] = 26] = "ZIP_ER_NOPASSWD";
  Errors[Errors["ZIP_ER_WRONGPASSWD"] = 27] = "ZIP_ER_WRONGPASSWD";
  Errors[Errors["ZIP_ER_OPNOTSUPP"] = 28] = "ZIP_ER_OPNOTSUPP";
  Errors[Errors["ZIP_ER_INUSE"] = 29] = "ZIP_ER_INUSE";
  Errors[Errors["ZIP_ER_TELL"] = 30] = "ZIP_ER_TELL";
  Errors[Errors["ZIP_ER_COMPRESSED_DATA"] = 31] = "ZIP_ER_COMPRESSED_DATA";
})(Errors || (Errors = {}));

const makeInterface = libzip => ({
  // Those are getters because they can change after memory growth
  get HEAP8() {
    return libzip.HEAP8;
  },

  get HEAPU8() {
    return libzip.HEAPU8;
  },

  errors: Errors,
  SEEK_SET: 0,
  SEEK_CUR: 1,
  SEEK_END: 2,
  ZIP_CHECKCONS: 4,
  ZIP_CREATE: 1,
  ZIP_EXCL: 2,
  ZIP_TRUNCATE: 8,
  ZIP_RDONLY: 16,
  ZIP_FL_OVERWRITE: 8192,
  ZIP_FL_COMPRESSED: 4,
  ZIP_OPSYS_DOS: 0x00,
  ZIP_OPSYS_AMIGA: 0x01,
  ZIP_OPSYS_OPENVMS: 0x02,
  ZIP_OPSYS_UNIX: 0x03,
  ZIP_OPSYS_VM_CMS: 0x04,
  ZIP_OPSYS_ATARI_ST: 0x05,
  ZIP_OPSYS_OS_2: 0x06,
  ZIP_OPSYS_MACINTOSH: 0x07,
  ZIP_OPSYS_Z_SYSTEM: 0x08,
  ZIP_OPSYS_CPM: 0x09,
  ZIP_OPSYS_WINDOWS_NTFS: 0x0a,
  ZIP_OPSYS_MVS: 0x0b,
  ZIP_OPSYS_VSE: 0x0c,
  ZIP_OPSYS_ACORN_RISC: 0x0d,
  ZIP_OPSYS_VFAT: 0x0e,
  ZIP_OPSYS_ALTERNATE_MVS: 0x0f,
  ZIP_OPSYS_BEOS: 0x10,
  ZIP_OPSYS_TANDEM: 0x11,
  ZIP_OPSYS_OS_400: 0x12,
  ZIP_OPSYS_OS_X: 0x13,
  ZIP_CM_DEFAULT: -1,
  ZIP_CM_STORE: 0,
  ZIP_CM_DEFLATE: 8,
  uint08S: libzip._malloc(1),
  uint16S: libzip._malloc(2),
  uint32S: libzip._malloc(4),
  uint64S: libzip._malloc(8),
  malloc: libzip._malloc,
  free: libzip._free,
  getValue: libzip.getValue,
  open: libzip.cwrap(`zip_open`, `number`, [`string`, `number`, `number`]),
  openFromSource: libzip.cwrap(`zip_open_from_source`, `number`, [`number`, `number`, `number`]),
  close: libzip.cwrap(`zip_close`, `number`, [`number`]),
  discard: libzip.cwrap(`zip_discard`, null, [`number`]),
  getError: libzip.cwrap(`zip_get_error`, `number`, [`number`]),
  getName: libzip.cwrap(`zip_get_name`, `string`, [`number`, `number`, `number`]),
  getNumEntries: libzip.cwrap(`zip_get_num_entries`, `number`, [`number`, `number`]),
  delete: libzip.cwrap(`zip_delete`, `number`, [`number`, `number`]),
  stat: libzip.cwrap(`zip_stat`, `number`, [`number`, `string`, `number`, `number`]),
  statIndex: libzip.cwrap(`zip_stat_index`, `number`, [`number`, ...number64, `number`, `number`]),
  fopen: libzip.cwrap(`zip_fopen`, `number`, [`number`, `string`, `number`]),
  fopenIndex: libzip.cwrap(`zip_fopen_index`, `number`, [`number`, ...number64, `number`]),
  fread: libzip.cwrap(`zip_fread`, `number`, [`number`, `number`, `number`, `number`]),
  fclose: libzip.cwrap(`zip_fclose`, `number`, [`number`]),
  dir: {
    add: libzip.cwrap(`zip_dir_add`, `number`, [`number`, `string`])
  },
  file: {
    add: libzip.cwrap(`zip_file_add`, `number`, [`number`, `string`, `number`, `number`]),
    getError: libzip.cwrap(`zip_file_get_error`, `number`, [`number`]),
    getExternalAttributes: libzip.cwrap(`zip_file_get_external_attributes`, `number`, [`number`, ...number64, `number`, `number`, `number`]),
    setExternalAttributes: libzip.cwrap(`zip_file_set_external_attributes`, `number`, [`number`, ...number64, `number`, `number`, `number`]),
    setMtime: libzip.cwrap(`zip_file_set_mtime`, `number`, [`number`, ...number64, `number`, `number`]),
    setCompression: libzip.cwrap(`zip_set_file_compression`, `number`, [`number`, ...number64, `number`, `number`])
  },
  ext: {
    countSymlinks: libzip.cwrap(`zip_ext_count_symlinks`, `number`, [`number`])
  },
  error: {
    initWithCode: libzip.cwrap(`zip_error_init_with_code`, null, [`number`, `number`]),
    strerror: libzip.cwrap(`zip_error_strerror`, `string`, [`number`])
  },
  name: {
    locate: libzip.cwrap(`zip_name_locate`, `number`, [`number`, `string`, `number`])
  },
  source: {
    fromUnattachedBuffer: libzip.cwrap(`zip_source_buffer_create`, `number`, [`number`, `number`, `number`, `number`]),
    fromBuffer: libzip.cwrap(`zip_source_buffer`, `number`, [`number`, `number`, ...number64, `number`]),
    free: libzip.cwrap(`zip_source_free`, null, [`number`]),
    keep: libzip.cwrap(`zip_source_keep`, null, [`number`]),
    open: libzip.cwrap(`zip_source_open`, `number`, [`number`]),
    close: libzip.cwrap(`zip_source_close`, `number`, [`number`]),
    seek: libzip.cwrap(`zip_source_seek`, `number`, [`number`, ...number64, `number`]),
    tell: libzip.cwrap(`zip_source_tell`, `number`, [`number`]),
    read: libzip.cwrap(`zip_source_read`, `number`, [`number`, `number`, `number`]),
    error: libzip.cwrap(`zip_source_error`, `number`, [`number`]),
    setMtime: libzip.cwrap(`zip_source_set_mtime`, `number`, [`number`, `number`])
  },
  struct: {
    stat: libzip.cwrap(`zipstruct_stat`, `number`, []),
    statS: libzip.cwrap(`zipstruct_statS`, `number`, []),
    statName: libzip.cwrap(`zipstruct_stat_name`, `string`, [`number`]),
    statIndex: libzip.cwrap(`zipstruct_stat_index`, `number`, [`number`]),
    statSize: libzip.cwrap(`zipstruct_stat_size`, `number`, [`number`]),
    statCompSize: libzip.cwrap(`zipstruct_stat_comp_size`, `number`, [`number`]),
    statCompMethod: libzip.cwrap(`zipstruct_stat_comp_method`, `number`, [`number`]),
    statMtime: libzip.cwrap(`zipstruct_stat_mtime`, `number`, [`number`]),
    error: libzip.cwrap(`zipstruct_error`, `number`, []),
    errorS: libzip.cwrap(`zipstruct_errorS`, `number`, []),
    errorCodeZip: libzip.cwrap(`zipstruct_error_code_zip`, `number`, [`number`])
  }
});
// CONCATENATED MODULE: ../yarnpkg-libzip/sources/sync.ts

let mod = null;
function getLibzipSync() {
  if (mod === null) mod = makeInterface(__webpack_require__(368));
  return mod;
}
async function getLibzipPromise() {
  return getLibzipSync();
}
// EXTERNAL MODULE: external "module"
var external_module_ = __webpack_require__(282);
var external_module_default = /*#__PURE__*/__webpack_require__.n(external_module_);

// CONCATENATED MODULE: external "string_decoder"
const external_string_decoder_namespaceObject = require("string_decoder");;
var external_string_decoder_default = /*#__PURE__*/__webpack_require__.n(external_string_decoder_namespaceObject);

// CONCATENATED MODULE: ../yarnpkg-fslib/sources/index.ts
























function getTempName(prefix) {
  const tmpdir = npath.toPortablePath(external_os_default().tmpdir());
  const hash = Math.ceil(Math.random() * 0x100000000).toString(16).padStart(8, `0`);
  return ppath.join(tmpdir, `${prefix}${hash}`);
}

function patchFs(patchedFs, fakeFs) {
  const SYNC_IMPLEMENTATIONS = new Set([`accessSync`, `appendFileSync`, `createReadStream`, `chmodSync`, `chownSync`, `closeSync`, `copyFileSync`, `linkSync`, `lstatSync`, `lutimesSync`, `mkdirSync`, `openSync`, `opendirSync`, `readSync`, `readlinkSync`, `readFileSync`, `readdirSync`, `readlinkSync`, `realpathSync`, `renameSync`, `rmdirSync`, `statSync`, `symlinkSync`, `truncateSync`, `unlinkSync`, `unwatchFile`, `utimesSync`, `watch`, `watchFile`, `writeFileSync`, `writeSync`]);
  const ASYNC_IMPLEMENTATIONS = new Set([`accessPromise`, `appendFilePromise`, `chmodPromise`, `chownPromise`, `closePromise`, `copyFilePromise`, `linkPromise`, `lstatPromise`, `lutimesPromise`, `mkdirPromise`, `openPromise`, `opendirPromise`, `readdirPromise`, `realpathPromise`, `readFilePromise`, `readdirPromise`, `readlinkPromise`, `renamePromise`, `rmdirPromise`, `statPromise`, `symlinkPromise`, `truncatePromise`, `unlinkPromise`, `utimesPromise`, `writeFilePromise`, `writeSync`]);
  const FILEHANDLE_IMPLEMENTATIONS = new Set([`appendFilePromise`, `chmodPromise`, `chownPromise`, `closePromise`, `readPromise`, `readFilePromise`, `statPromise`, `truncatePromise`, `utimesPromise`, `writePromise`, `writeFilePromise`]);

  const setupFn = (target, name, replacement) => {
    const orig = target[name];
    target[name] = replacement; // Preserve any util.promisify implementations

    if (typeof (orig === null || orig === void 0 ? void 0 : orig[external_util_namespaceObject.promisify.custom]) !== `undefined`) {
      replacement[external_util_namespaceObject.promisify.custom] = orig[external_util_namespaceObject.promisify.custom];
    }
  };
  /** Callback implementations */


  {
    setupFn(patchedFs, `exists`, (p, ...args) => {
      const hasCallback = typeof args[args.length - 1] === `function`;
      const callback = hasCallback ? args.pop() : () => {};
      process.nextTick(() => {
        fakeFs.existsPromise(p).then(exists => {
          callback(exists);
        }, () => {
          callback(false);
        });
      });
    });
    setupFn(patchedFs, `read`, (p, buffer, ...args) => {
      const hasCallback = typeof args[args.length - 1] === `function`;
      const callback = hasCallback ? args.pop() : () => {};
      process.nextTick(() => {
        fakeFs.readPromise(p, buffer, ...args).then(bytesRead => {
          callback(null, bytesRead, buffer);
        }, error => {
          callback(error);
        });
      });
    });

    for (const fnName of ASYNC_IMPLEMENTATIONS) {
      const origName = fnName.replace(/Promise$/, ``);
      if (typeof patchedFs[origName] === `undefined`) continue;
      const fakeImpl = fakeFs[fnName];
      if (typeof fakeImpl === `undefined`) continue;

      const wrapper = (...args) => {
        const hasCallback = typeof args[args.length - 1] === `function`;
        const callback = hasCallback ? args.pop() : () => {};
        process.nextTick(() => {
          fakeImpl.apply(fakeFs, args).then(result => {
            callback(null, result);
          }, error => {
            callback(error);
          });
        });
      };

      setupFn(patchedFs, origName, wrapper);
    }

    patchedFs.realpath.native = patchedFs.realpath;
  }
  /** Sync implementations */

  {
    setupFn(patchedFs, `existsSync`, p => {
      try {
        return fakeFs.existsSync(p);
      } catch (error) {
        return false;
      }
    });

    for (const fnName of SYNC_IMPLEMENTATIONS) {
      const origName = fnName;
      if (typeof patchedFs[origName] === `undefined`) continue;
      const fakeImpl = fakeFs[fnName];
      if (typeof fakeImpl === `undefined`) continue;
      setupFn(patchedFs, origName, fakeImpl.bind(fakeFs));
    }

    patchedFs.realpathSync.native = patchedFs.realpathSync;
  }
  /** Promise implementations */

  {
    // `fs.promises` is a getter that returns a reference to require(`fs/promises`),
    // so we can just patch `fs.promises` and both will be updated
    const origEmitWarning = process.emitWarning;

    process.emitWarning = () => {};

    let patchedFsPromises;

    try {
      patchedFsPromises = patchedFs.promises;
    } finally {
      process.emitWarning = origEmitWarning;
    }

    if (typeof patchedFsPromises !== `undefined`) {
      // `fs.promises.exists` doesn't exist
      for (const fnName of ASYNC_IMPLEMENTATIONS) {
        const origName = fnName.replace(/Promise$/, ``);
        if (typeof patchedFsPromises[origName] === `undefined`) continue;
        const fakeImpl = fakeFs[fnName];
        if (typeof fakeImpl === `undefined`) continue; // Open is a bit particular with fs.promises: it returns a file handle
        // instance instead of the traditional file descriptor number

        if (fnName === `open`) continue;
        setupFn(patchedFsPromises, origName, fakeImpl.bind(fakeFs));
      }

      class FileHandle {
        constructor(fd) {
          this.fd = fd;
        }

      }

      for (const fnName of FILEHANDLE_IMPLEMENTATIONS) {
        const origName = fnName.replace(/Promise$/, ``);
        const fakeImpl = fakeFs[fnName];
        if (typeof fakeImpl === `undefined`) continue;
        setupFn(FileHandle.prototype, origName, function (...args) {
          return fakeImpl.call(fakeFs, this.fd, ...args);
        });
      }

      setupFn(patchedFsPromises, `open`, async (...args) => {
        // @ts-expect-error
        const fd = await fakeFs.openPromise(...args);
        return new FileHandle(fd);
      }); // `fs.promises.realpath` doesn't have a `native` property
    }
  }
  /** util.promisify implementations */

  {
    // Override the promisified version of `fs.read` to return an object as per
    // https://github.com/nodejs/node/blob/dc79f3f37caf6f25b8efee4623bec31e2c20f595/lib/fs.js#L559-L560
    // and
    // https://github.com/nodejs/node/blob/ba684805b6c0eded76e5cd89ee00328ac7a59365/lib/internal/util.js#L293
    // @ts-expect-error
    patchedFs.read[external_util_namespaceObject.promisify.custom] = async (p, buffer, ...args) => {
      const res = fakeFs.readPromise(p, buffer, ...args);
      return {
        bytesRead: await res,
        buffer
      };
    };
  }
}
function extendFs(realFs, fakeFs) {
  const patchedFs = Object.create(realFs);
  patchFs(patchedFs, fakeFs);
  return patchedFs;
}
const tmpdirs = new Set();
let cleanExitRegistered = false;

function registerCleanExit() {
  if (cleanExitRegistered) return;
  cleanExitRegistered = true;
  process.once(`exit`, () => {
    xfs.rmtempSync();
  });
}

const xfs = Object.assign(new NodeFS(), {
  detachTemp(p) {
    tmpdirs.delete(p);
  },

  mktempSync(cb) {
    registerCleanExit();

    while (true) {
      const p = getTempName(`xfs-`);

      try {
        this.mkdirSync(p);
      } catch (error) {
        if (error.code === `EEXIST`) {
          continue;
        } else {
          throw error;
        }
      }

      const realP = this.realpathSync(p);
      tmpdirs.add(realP);

      if (typeof cb !== `undefined`) {
        try {
          return cb(realP);
        } finally {
          if (tmpdirs.has(realP)) {
            tmpdirs.delete(realP);

            try {
              this.removeSync(realP);
            } catch (_a) {// Too bad if there's an error
            }
          }
        }
      } else {
        return p;
      }
    }
  },

  async mktempPromise(cb) {
    registerCleanExit();

    while (true) {
      const p = getTempName(`xfs-`);

      try {
        await this.mkdirPromise(p);
      } catch (error) {
        if (error.code === `EEXIST`) {
          continue;
        } else {
          throw error;
        }
      }

      const realP = await this.realpathPromise(p);
      tmpdirs.add(realP);

      if (typeof cb !== `undefined`) {
        try {
          return await cb(realP);
        } finally {
          if (tmpdirs.has(realP)) {
            tmpdirs.delete(realP);

            try {
              await this.removePromise(realP);
            } catch (_a) {// Too bad if there's an error
            }
          }
        }
      } else {
        return realP;
      }
    }
  },

  async rmtempPromise() {
    await Promise.all(Array.from(tmpdirs.values()).map(async p => {
      try {
        await xfs.removePromise(p, {
          maxRetries: 0
        });
        tmpdirs.delete(p);
      } catch (_a) {// Too bad if there's an error
      }
    }));
  },

  rmtempSync() {
    for (const p of tmpdirs) {
      try {
        xfs.removeSync(p);
        tmpdirs.delete(p);
      } catch (_a) {// Too bad if there's an error
      }
    }
  }

});
// CONCATENATED MODULE: ../yarnpkg-fslib/sources/PosixFS.ts


class PosixFS extends ProxiedFS {
  constructor(baseFs) {
    super(npath);
    this.baseFs = baseFs;
  }

  mapFromBase(path) {
    return npath.fromPortablePath(path);
  }

  mapToBase(path) {
    return npath.toPortablePath(path);
  }

}
// CONCATENATED MODULE: external "url"
const external_url_namespaceObject = require("url");;
// CONCATENATED MODULE: ./sources/loader/internalTools.ts

var ErrorCode;

(function (ErrorCode) {
  ErrorCode["API_ERROR"] = "API_ERROR";
  ErrorCode["BLACKLISTED"] = "BLACKLISTED";
  ErrorCode["BUILTIN_NODE_RESOLUTION_FAILED"] = "BUILTIN_NODE_RESOLUTION_FAILED";
  ErrorCode["MISSING_DEPENDENCY"] = "MISSING_DEPENDENCY";
  ErrorCode["MISSING_PEER_DEPENDENCY"] = "MISSING_PEER_DEPENDENCY";
  ErrorCode["QUALIFIED_PATH_RESOLUTION_FAILED"] = "QUALIFIED_PATH_RESOLUTION_FAILED";
  ErrorCode["INTERNAL"] = "INTERNAL";
  ErrorCode["UNDECLARED_DEPENDENCY"] = "UNDECLARED_DEPENDENCY";
  ErrorCode["UNSUPPORTED"] = "UNSUPPORTED";
})(ErrorCode || (ErrorCode = {})); // Some errors are exposed as MODULE_NOT_FOUND for compatibility with packages
// that expect this umbrella error when the resolution fails


const MODULE_NOT_FOUND_ERRORS = new Set([ErrorCode.BLACKLISTED, ErrorCode.BUILTIN_NODE_RESOLUTION_FAILED, ErrorCode.MISSING_DEPENDENCY, ErrorCode.MISSING_PEER_DEPENDENCY, ErrorCode.QUALIFIED_PATH_RESOLUTION_FAILED, ErrorCode.UNDECLARED_DEPENDENCY]);
/**
 * Simple helper function that assign an error code to an error, so that it can more easily be caught and used
 * by third-parties.
 */

function internalTools_makeError(pnpCode, message, data = {}) {
  const code = MODULE_NOT_FOUND_ERRORS.has(pnpCode) ? `MODULE_NOT_FOUND` : pnpCode;
  const propertySpec = {
    configurable: true,
    writable: true,
    enumerable: false
  };
  return Object.defineProperties(new Error(message), {
    code: { ...propertySpec,
      value: code
    },
    pnpCode: { ...propertySpec,
      value: pnpCode
    },
    data: { ...propertySpec,
      value: data
    }
  });
}
/**
 * Returns the module that should be used to resolve require calls. It's usually the direct parent, except if we're
 * inside an eval expression.
 */

function getIssuerModule(parent) {
  let issuer = parent;

  while (issuer && (issuer.id === `[eval]` || issuer.id === `<repl>` || !issuer.filename)) issuer = issuer.parent;

  return issuer || null;
}
function getPathForDisplay(p) {
  return npath.normalize(npath.fromPortablePath(p));
}
// CONCATENATED MODULE: ./sources/loader/applyPatch.ts





function applyPatch(pnpapi, opts) {
  // @ts-expect-error
  const builtinModules = new Set(external_module_.Module.builtinModules || Object.keys(process.binding(`natives`)));
  /**
   * The cache that will be used for all accesses occuring outside of a PnP context.
   */

  const defaultCache = {};
  /**
   * Used to disable the resolution hooks (for when we want to fallback to the previous resolution - we then need
   * a way to "reset" the environment temporarily)
   */

  let enableNativeHooks = true; // @ts-expect-error

  process.versions.pnp = String(pnpapi.VERSIONS.std);

  const moduleExports = __webpack_require__(282);

  moduleExports.findPnpApi = lookupSource => {
    const lookupPath = lookupSource instanceof external_url_namespaceObject.URL ? (0,external_url_namespaceObject.fileURLToPath)(lookupSource) : lookupSource;
    const apiPath = opts.manager.findApiPathFor(lookupPath);
    if (apiPath === null) return null;
    const apiEntry = opts.manager.getApiEntry(apiPath, true);
    return apiEntry.instance;
  };

  function getRequireStack(parent) {
    const requireStack = [];

    for (let cursor = parent; cursor; cursor = cursor.parent) requireStack.push(cursor.filename || cursor.id);

    return requireStack;
  } // A small note: we don't replace the cache here (and instead use the native one). This is an effort to not
  // break code similar to "delete require.cache[require.resolve(FOO)]", where FOO is a package located outside
  // of the Yarn dependency tree. In this case, we defer the load to the native loader. If we were to replace the
  // cache by our own, the native loader would populate its own cache, which wouldn't be exposed anymore, so the
  // delete call would be broken.


  const originalModuleLoad = external_module_.Module._load;

  external_module_.Module._load = function (request, parent, isMain) {
    if (!enableNativeHooks) return originalModuleLoad.call(external_module_.Module, request, parent, isMain); // Builtins are managed by the regular Node loader

    if (builtinModules.has(request)) {
      try {
        enableNativeHooks = false;
        return originalModuleLoad.call(external_module_.Module, request, parent, isMain);
      } finally {
        enableNativeHooks = true;
      }
    }

    const parentApiPath = opts.manager.getApiPathFromParent(parent);
    const parentApi = parentApiPath !== null ? opts.manager.getApiEntry(parentApiPath, true).instance : null; // Requests that aren't covered by the PnP runtime goes through the
    // parent `_load` implementation. This is required for VSCode, for example,
    // which override `_load` to provide additional builtins to its extensions.

    if (parentApi === null) return originalModuleLoad(request, parent, isMain); // The 'pnpapi' name is reserved to return the PnP api currently in use
    // by the program

    if (request === `pnpapi`) return parentApi; // Request `Module._resolveFilename` (ie. `resolveRequest`) to tell us
    // which file we should load

    const modulePath = external_module_.Module._resolveFilename(request, parent, isMain); // We check whether the module is owned by the dependency tree of the
    // module that required it. If it isn't, then we need to create a new
    // store and possibly load its sandboxed PnP runtime.


    const isOwnedByRuntime = parentApi !== null ? parentApi.findPackageLocator(modulePath) !== null : false;
    const moduleApiPath = isOwnedByRuntime ? parentApiPath : opts.manager.findApiPathFor(npath.dirname(modulePath));
    const entry = moduleApiPath !== null ? opts.manager.getApiEntry(moduleApiPath) : {
      instance: null,
      cache: defaultCache
    }; // Check if the module has already been created for the given file

    const cacheEntry = entry.cache[modulePath];
    if (cacheEntry) return cacheEntry.exports; // Create a new module and store it into the cache
    // @ts-expect-error

    const module = new external_module_.Module(modulePath, parent); // @ts-expect-error

    module.pnpApiPath = moduleApiPath;
    entry.cache[modulePath] = module; // The main module is exposed as global variable

    if (isMain) {
      process.mainModule = module;
      module.id = `.`;
    } // Try to load the module, and remove it from the cache if it fails


    let hasThrown = true;

    try {
      // @ts-expect-error
      module.load(modulePath);
      hasThrown = false;
    } finally {
      if (hasThrown) {
        delete external_module_.Module._cache[modulePath];
      }
    }

    return module.exports;
  };

  function getIssuerSpecsFromPaths(paths) {
    return paths.map(path => ({
      apiPath: opts.manager.findApiPathFor(path),
      path,
      module: null
    }));
  }

  function getIssuerSpecsFromModule(module) {
    const issuer = getIssuerModule(module);
    const issuerPath = issuer !== null ? npath.dirname(issuer.filename) : process.cwd();
    return [{
      apiPath: opts.manager.getApiPathFromParent(issuer),
      path: issuerPath,
      module
    }];
  }

  function makeFakeParent(path) {
    const fakeParent = new external_module_.Module(``);
    const fakeFilePath = npath.join(path, `[file]`);
    fakeParent.paths = external_module_.Module._nodeModulePaths(fakeFilePath);
    return fakeParent;
  } // Splits a require request into its components, or return null if the request is a file path


  const pathRegExp = /^(?![a-zA-Z]:[\\/]|\\\\|\.{0,2}(?:\/|$))((?:@[^/]+\/)?[^/]+)\/*(.*|)$/;
  const originalModuleResolveFilename = external_module_.Module._resolveFilename;

  external_module_.Module._resolveFilename = function (request, parent, isMain, options) {
    if (builtinModules.has(request)) return request;
    if (!enableNativeHooks) return originalModuleResolveFilename.call(external_module_.Module, request, parent, isMain, options);

    if (options && options.plugnplay === false) {
      const {
        plugnplay,
        ...rest
      } = options; // Workaround a bug present in some version of Node (now fixed)
      // https://github.com/nodejs/node/pull/28078

      const forwardedOptions = Object.keys(rest).length > 0 ? rest : undefined;

      try {
        enableNativeHooks = false;
        return originalModuleResolveFilename.call(external_module_.Module, request, parent, isMain, forwardedOptions);
      } finally {
        enableNativeHooks = true;
      }
    } // We check that all the options present here are supported; better
    // to fail fast than to introduce subtle bugs in the runtime.


    if (options) {
      const optionNames = new Set(Object.keys(options));
      optionNames.delete(`paths`);
      optionNames.delete(`plugnplay`);

      if (optionNames.size > 0) {
        throw internalTools_makeError(ErrorCode.UNSUPPORTED, `Some options passed to require() aren't supported by PnP yet (${Array.from(optionNames).join(`, `)})`);
      }
    }

    const issuerSpecs = options && options.paths ? getIssuerSpecsFromPaths(options.paths) : getIssuerSpecsFromModule(parent);

    if (request.match(pathRegExp) === null) {
      const parentDirectory = (parent === null || parent === void 0 ? void 0 : parent.filename) != null ? npath.dirname(parent.filename) : null;
      const absoluteRequest = npath.isAbsolute(request) ? request : parentDirectory !== null ? npath.resolve(parentDirectory, request) : null;

      if (absoluteRequest !== null) {
        const apiPath = parentDirectory === npath.dirname(absoluteRequest) && (parent === null || parent === void 0 ? void 0 : parent.pnpApiPath) ? parent.pnpApiPath : opts.manager.findApiPathFor(absoluteRequest);

        if (apiPath !== null) {
          issuerSpecs.unshift({
            apiPath,
            path: parentDirectory,
            module: null
          });
        }
      }
    }

    let firstError;

    for (const {
      apiPath,
      path,
      module
    } of issuerSpecs) {
      let resolution;
      const issuerApi = apiPath !== null ? opts.manager.getApiEntry(apiPath, true).instance : null;

      try {
        if (issuerApi !== null) {
          resolution = issuerApi.resolveRequest(request, path !== null ? `${path}/` : null);
        } else {
          if (path === null) throw new Error(`Assertion failed: Expected the path to be set`);
          resolution = originalModuleResolveFilename.call(external_module_.Module, request, module || makeFakeParent(path), isMain);
        }
      } catch (error) {
        firstError = firstError || error;
        continue;
      }

      if (resolution !== null) {
        return resolution;
      }
    }

    const requireStack = getRequireStack(parent);
    Object.defineProperty(firstError, `requireStack`, {
      configurable: true,
      writable: true,
      enumerable: false,
      value: requireStack
    });
    if (requireStack.length > 0) firstError.message += `\nRequire stack:\n- ${requireStack.join(`\n- `)}`;
    throw firstError;
  };

  const originalFindPath = external_module_.Module._findPath;

  external_module_.Module._findPath = function (request, paths, isMain) {
    if (request === `pnpapi`) return false; // Node sometimes call this function with an absolute path and a `null` set
    // of paths. This would cause the resolution to fail. To avoid that, we
    // fallback on the regular resolution. We only do this when `isMain` is
    // true because the Node default resolution doesn't handle well in-zip
    // paths, even absolute, so we try to use it as little as possible.

    if (!enableNativeHooks || isMain && npath.isAbsolute(request)) return originalFindPath.call(external_module_.Module, request, paths, isMain);

    for (const path of paths || []) {
      let resolution;

      try {
        const pnpApiPath = opts.manager.findApiPathFor(path);

        if (pnpApiPath !== null) {
          const api = opts.manager.getApiEntry(pnpApiPath, true).instance;
          resolution = api.resolveRequest(request, path) || false;
        } else {
          resolution = originalFindPath.call(external_module_.Module, request, [path], isMain);
        }
      } catch (error) {
        continue;
      }

      if (resolution) {
        return resolution;
      }
    }

    return false;
  };

  patchFs((external_fs_default()), new PosixFS(opts.fakeFs));
}
// CONCATENATED MODULE: ./sources/loader/hydrateRuntimeState.ts

function hydrateRuntimeState(data, {
  basePath
}) {
  const portablePath = npath.toPortablePath(basePath);
  const absolutePortablePath = ppath.resolve(portablePath);
  const ignorePattern = data.ignorePatternData !== null ? new RegExp(data.ignorePatternData) : null;
  const packageRegistry = new Map(data.packageRegistryData.map(([packageName, packageStoreData]) => {
    return [packageName, new Map(packageStoreData.map(([packageReference, packageInformationData]) => {
      return [packageReference, {
        // We use ppath.join instead of ppath.resolve because:
        // 1) packageInformationData.packageLocation is a relative path when part of the SerializedState
        // 2) ppath.join preserves trailing slashes
        packageLocation: ppath.join(absolutePortablePath, packageInformationData.packageLocation),
        packageDependencies: new Map(packageInformationData.packageDependencies),
        packagePeers: new Set(packageInformationData.packagePeers),
        linkType: packageInformationData.linkType,
        discardFromLookup: packageInformationData.discardFromLookup || false
      }];
    }))];
  }));
  const packageLocatorsByLocations = new Map();
  const packageLocationLengths = new Set();

  for (const [packageName, storeData] of data.packageRegistryData) {
    for (const [packageReference, packageInformationData] of storeData) {
      if (packageName === null !== (packageReference === null)) throw new Error(`Assertion failed: The name and reference should be null, or neither should`);
      if (packageInformationData.discardFromLookup) continue; // @ts-expect-error: TypeScript isn't smart enough to understand the type assertion

      const packageLocator = {
        name: packageName,
        reference: packageReference
      };
      packageLocatorsByLocations.set(packageInformationData.packageLocation, packageLocator);
      packageLocationLengths.add(packageInformationData.packageLocation.length);
    }
  }

  for (const location of data.locationBlacklistData) packageLocatorsByLocations.set(location, null);

  const fallbackExclusionList = new Map(data.fallbackExclusionList.map(([packageName, packageReferences]) => {
    return [packageName, new Set(packageReferences)];
  }));
  const fallbackPool = new Map(data.fallbackPool);
  const dependencyTreeRoots = data.dependencyTreeRoots;
  const enableTopLevelFallback = data.enableTopLevelFallback;
  return {
    basePath: portablePath,
    dependencyTreeRoots,
    enableTopLevelFallback,
    fallbackExclusionList,
    fallbackPool,
    ignorePattern,
    packageLocationLengths: [...packageLocationLengths].sort((a, b) => b - a),
    packageLocatorsByLocations,
    packageRegistry
  };
}
// CONCATENATED MODULE: ./sources/loader/makeApi.ts




function makeApi(runtimeState, opts) {
  const alwaysWarnOnFallback = Number(process.env.PNP_ALWAYS_WARN_ON_FALLBACK) > 0;
  const debugLevel = Number(process.env.PNP_DEBUG_LEVEL); // @ts-expect-error

  const builtinModules = new Set(external_module_.Module.builtinModules || Object.keys(process.binding(`natives`))); // Splits a require request into its components, or return null if the request is a file path

  const pathRegExp = /^(?![a-zA-Z]:[\\/]|\\\\|\.{0,2}(?:\/|$))((?:@[^/]+\/)?[^/]+)\/*(.*|)$/; // Matches if the path starts with a valid path qualifier (./, ../, /)
  // eslint-disable-next-line no-unused-vars

  const isStrictRegExp = /^(\/|\.{1,2}(\/|$))/; // Matches if the path must point to a directory (ie ends with /)

  const isDirRegExp = /\/$/; // We only instantiate one of those so that we can use strict-equal comparisons

  const topLevelLocator = {
    name: null,
    reference: null
  }; // Used for compatibility purposes - cf setupCompatibilityLayer

  const fallbackLocators = []; // To avoid emitting the same warning multiple times

  const emittedWarnings = new Set();
  if (runtimeState.enableTopLevelFallback === true) fallbackLocators.push(topLevelLocator);

  if (opts.compatibilityMode !== false) {
    // ESLint currently doesn't have any portable way for shared configs to
    // specify their own plugins that should be used (cf issue #10125). This
    // will likely get fixed at some point but it'll take time, so in the
    // meantime we'll just add additional fallback entries for common shared
    // configs.
    // Similarly, Gatsby generates files within the `public` folder located
    // within the project, but doesn't pre-resolve the `require` calls to use
    // its own dependencies. Meaning that when PnP see a file from the `public`
    // folder making a require, it thinks that your project forgot to list one
    // of your dependencies.
    for (const name of [`react-scripts`, `gatsby`]) {
      const packageStore = runtimeState.packageRegistry.get(name);

      if (packageStore) {
        for (const reference of packageStore.keys()) {
          if (reference === null) {
            throw new Error(`Assertion failed: This reference shouldn't be null`);
          } else {
            fallbackLocators.push({
              name,
              reference
            });
          }
        }
      }
    }
  }
  /**
   * The setup code will be injected here. The tables listed below are guaranteed to be filled after the call to
   * the $$DYNAMICALLY_GENERATED_CODE function.
   */


  const {
    ignorePattern,
    packageRegistry,
    packageLocatorsByLocations,
    packageLocationLengths
  } = runtimeState;
  /**
   * Allows to print useful logs just be setting a value in the environment
   */

  function makeLogEntry(name, args) {
    return {
      fn: name,
      args,
      error: null,
      result: null
    };
  }

  function maybeLog(name, fn) {
    if (opts.allowDebug === false) return fn;

    if (Number.isFinite(debugLevel)) {
      if (debugLevel >= 2) {
        return (...args) => {
          const logEntry = makeLogEntry(name, args);

          try {
            return logEntry.result = fn(...args);
          } catch (error) {
            throw logEntry.error = error;
          } finally {
            console.trace(logEntry);
          }
        };
      } else if (debugLevel >= 1) {
        return (...args) => {
          try {
            return fn(...args);
          } catch (error) {
            const logEntry = makeLogEntry(name, args);
            logEntry.error = error;
            console.trace(logEntry);
            throw error;
          }
        };
      }
    }

    return fn;
  }
  /**
   * Returns information about a package in a safe way (will throw if they cannot be retrieved)
   */


  function getPackageInformationSafe(packageLocator) {
    const packageInformation = getPackageInformation(packageLocator);

    if (!packageInformation) {
      throw internalTools_makeError(ErrorCode.INTERNAL, `Couldn't find a matching entry in the dependency tree for the specified parent (this is probably an internal error)`);
    }

    return packageInformation;
  }
  /**
   * Returns whether the specified locator is a dependency tree root (in which case it's part of the project) or not
   */


  function isDependencyTreeRoot(packageLocator) {
    if (packageLocator.name === null) return true;

    for (const dependencyTreeRoot of runtimeState.dependencyTreeRoots) if (dependencyTreeRoot.name === packageLocator.name && dependencyTreeRoot.reference === packageLocator.reference) return true;

    return false;
  }
  /**
   * Implements the node resolution for folder access and extension selection
   */


  function applyNodeExtensionResolution(unqualifiedPath, candidates, {
    extensions
  }) {
    let stat;

    try {
      candidates.push(unqualifiedPath);
      stat = opts.fakeFs.statSync(unqualifiedPath);
    } catch (error) {} // If the file exists and is a file, we can stop right there


    if (stat && !stat.isDirectory()) return opts.fakeFs.realpathSync(unqualifiedPath); // If the file is a directory, we must check if it contains a package.json with a "main" entry

    if (stat && stat.isDirectory()) {
      let pkgJson;

      try {
        pkgJson = JSON.parse(opts.fakeFs.readFileSync(ppath.join(unqualifiedPath, `package.json`), `utf8`));
      } catch (error) {}

      let nextUnqualifiedPath;
      if (pkgJson && pkgJson.main) nextUnqualifiedPath = ppath.resolve(unqualifiedPath, pkgJson.main); // If the "main" field changed the path, we start again from this new location

      if (nextUnqualifiedPath && nextUnqualifiedPath !== unqualifiedPath) {
        const resolution = applyNodeExtensionResolution(nextUnqualifiedPath, candidates, {
          extensions
        });

        if (resolution !== null) {
          return resolution;
        }
      }
    } // Otherwise we check if we find a file that match one of the supported extensions


    for (let i = 0, length = extensions.length; i < length; i++) {
      const candidateFile = `${unqualifiedPath}${extensions[i]}`;
      candidates.push(candidateFile);

      if (opts.fakeFs.existsSync(candidateFile)) {
        return candidateFile;
      }
    } // Otherwise, we check if the path is a folder - in such a case, we try to use its index


    if (stat && stat.isDirectory()) {
      for (let i = 0, length = extensions.length; i < length; i++) {
        const candidateFile = ppath.format({
          dir: unqualifiedPath,
          name: `index`,
          ext: extensions[i]
        });
        candidates.push(candidateFile);

        if (opts.fakeFs.existsSync(candidateFile)) {
          return candidateFile;
        }
      }
    } // Otherwise there's nothing else we can do :(


    return null;
  }
  /**
   * This function creates fake modules that can be used with the _resolveFilename function.
   * Ideally it would be nice to be able to avoid this, since it causes useless allocations
   * and cannot be cached efficiently (we recompute the nodeModulePaths every time).
   *
   * Fortunately, this should only affect the fallback, and there hopefully shouldn't have a
   * lot of them.
   */


  function makeFakeModule(path) {
    // @ts-expect-error
    const fakeModule = new external_module_.Module(path, null);
    fakeModule.filename = path;
    fakeModule.paths = external_module_.Module._nodeModulePaths(path);
    return fakeModule;
  }
  /**
   * Normalize path to posix format.
   */


  function normalizePath(p) {
    return npath.toPortablePath(p);
  }
  /**
   * Forward the resolution to the next resolver (usually the native one)
   */


  function callNativeResolution(request, issuer) {
    if (issuer.endsWith(`/`)) issuer = ppath.join(issuer, `internal.js`); // Since we would need to create a fake module anyway (to call _resolveLookupPath that
    // would give us the paths to give to _resolveFilename), we can as well not use
    // the {paths} option at all, since it internally makes _resolveFilename create another
    // fake module anyway.

    return external_module_.Module._resolveFilename(npath.fromPortablePath(request), makeFakeModule(npath.fromPortablePath(issuer)), false, {
      plugnplay: false
    });
  }
  /**
   *
   */


  function isPathIgnored(path) {
    if (ignorePattern === null) return false;
    const subPath = ppath.contains(runtimeState.basePath, path);
    if (subPath === null) return false;

    if (ignorePattern.test(subPath.replace(/\/$/, ``))) {
      return true;
    } else {
      return false;
    }
  }
  /**
   * This key indicates which version of the standard is implemented by this resolver. The `std` key is the
   * Plug'n'Play standard, and any other key are third-party extensions. Third-party extensions are not allowed
   * to override the standard, and can only offer new methods.
   *
   * If a new version of the Plug'n'Play standard is released and some extensions conflict with newly added
   * functions, they'll just have to fix the conflicts and bump their own version number.
   */


  const VERSIONS = {
    std: 3,
    resolveVirtual: 1,
    getAllLocators: 1
  };
  /**
   * We export a special symbol for easy access to the top level locator.
   */

  const topLevel = topLevelLocator;
  /**
   * Gets the package information for a given locator. Returns null if they cannot be retrieved.
   */

  function getPackageInformation({
    name,
    reference
  }) {
    const packageInformationStore = packageRegistry.get(name);
    if (!packageInformationStore) return null;
    const packageInformation = packageInformationStore.get(reference);
    if (!packageInformation) return null;
    return packageInformation;
  }
  /**
   * Find all packages that depend on the specified one.
   *
   * Note: This is a private function; we expect consumers to implement it
   * themselves. We keep it that way because this implementation isn't
   * optimized at all, since we only need it when printing errors.
   */


  function findPackageDependents({
    name,
    reference
  }) {
    const dependents = [];

    for (const [dependentName, packageInformationStore] of packageRegistry) {
      if (dependentName === null) continue;

      for (const [dependentReference, packageInformation] of packageInformationStore) {
        if (dependentReference === null) continue;
        const dependencyReference = packageInformation.packageDependencies.get(name);
        if (dependencyReference !== reference) continue; // Don't forget that all packages depend on themselves

        if (dependentName === name && dependentReference === reference) continue;
        dependents.push({
          name: dependentName,
          reference: dependentReference
        });
      }
    }

    return dependents;
  }
  /**
   * Find all packages that broke the peer dependency on X, starting from Y.
   *
   * Note: This is a private function; we expect consumers to implement it
   * themselves. We keep it that way because this implementation isn't
   * optimized at all, since we only need it when printing errors.
   */


  function findBrokenPeerDependencies(dependency, initialPackage) {
    const brokenPackages = new Map();
    const alreadyVisited = new Set();

    const traversal = currentPackage => {
      const identifier = JSON.stringify(currentPackage.name);
      if (alreadyVisited.has(identifier)) return;
      alreadyVisited.add(identifier);
      const dependents = findPackageDependents(currentPackage);

      for (const dependent of dependents) {
        const dependentInformation = getPackageInformationSafe(dependent);

        if (dependentInformation.packagePeers.has(dependency)) {
          traversal(dependent);
        } else {
          let brokenSet = brokenPackages.get(dependent.name);
          if (typeof brokenSet === `undefined`) brokenPackages.set(dependent.name, brokenSet = new Set());
          brokenSet.add(dependent.reference);
        }
      }
    };

    traversal(initialPackage);
    const brokenList = [];

    for (const name of [...brokenPackages.keys()].sort()) for (const reference of [...brokenPackages.get(name)].sort()) brokenList.push({
      name,
      reference
    });

    return brokenList;
  }
  /**
   * Finds the package locator that owns the specified path. If none is found, returns null instead.
   */


  function findPackageLocator(location) {
    if (isPathIgnored(location)) return null;
    let relativeLocation = normalizePath(ppath.relative(runtimeState.basePath, location));
    if (!relativeLocation.match(isStrictRegExp)) relativeLocation = `./${relativeLocation}`;
    if (location.match(isDirRegExp) && !relativeLocation.endsWith(`/`)) relativeLocation = `${relativeLocation}/`;
    let from = 0; // If someone wants to use a binary search to go from O(n) to O(log n), be my guest

    while (from < packageLocationLengths.length && packageLocationLengths[from] > relativeLocation.length) from += 1;

    for (let t = from; t < packageLocationLengths.length; ++t) {
      const locator = packageLocatorsByLocations.get(relativeLocation.slice(0, packageLocationLengths[t]));
      if (typeof locator === `undefined`) continue; // Ensures that the returned locator isn't a blacklisted one.
      //
      // Blacklisted packages are packages that cannot be used because their dependencies cannot be deduced. This only
      // happens with peer dependencies, which effectively have different sets of dependencies depending on their
      // parents.
      //
      // In order to deambiguate those different sets of dependencies, the Yarn implementation of PnP will generate a
      // symlink for each combination of <package name>/<package version>/<dependent package> it will find, and will
      // blacklist the target of those symlinks. By doing this, we ensure that files loaded through a specific path
      // will always have the same set of dependencies, provided the symlinks are correctly preserved.
      //
      // Unfortunately, some tools do not preserve them, and when it happens PnP isn't able anymore to deduce the set of
      // dependencies based on the path of the file that makes the require calls. But since we've blacklisted those
      // paths, we're able to print a more helpful error message that points out that a third-party package is doing
      // something incompatible!

      if (locator === null) {
        const locationForDisplay = getPathForDisplay(location);
        throw internalTools_makeError(ErrorCode.BLACKLISTED, `A forbidden path has been used in the package resolution process - this is usually caused by one of your tools calling 'fs.realpath' on the return value of 'require.resolve'. Since we need to use symlinks to simultaneously provide valid filesystem paths and disambiguate peer dependencies, they must be passed untransformed to 'require'.\n\nForbidden path: ${locationForDisplay}`, {
          location: locationForDisplay
        });
      }

      return locator;
    }

    return null;
  }
  /**
   * Transforms a request (what's typically passed as argument to the require function) into an unqualified path.
   * This path is called "unqualified" because it only changes the package name to the package location on the disk,
   * which means that the end result still cannot be directly accessed (for example, it doesn't try to resolve the
   * file extension, or to resolve directories to their "index.js" content). Use the "resolveUnqualified" function
   * to convert them to fully-qualified paths, or just use "resolveRequest" that do both operations in one go.
   *
   * Note that it is extremely important that the `issuer` path ends with a forward slash if the issuer is to be
   * treated as a folder (ie. "/tmp/foo/" rather than "/tmp/foo" if "foo" is a directory). Otherwise relative
   * imports won't be computed correctly (they'll get resolved relative to "/tmp/" instead of "/tmp/foo/").
   */


  function resolveToUnqualified(request, issuer, {
    considerBuiltins = true
  } = {}) {
    // The 'pnpapi' request is reserved and will always return the path to the PnP file, from everywhere
    if (request === `pnpapi`) return npath.toPortablePath(opts.pnpapiResolution); // Bailout if the request is a native module

    if (considerBuiltins && builtinModules.has(request)) return null;
    const requestForDisplay = getPathForDisplay(request);
    const issuerForDisplay = issuer && getPathForDisplay(issuer); // We allow disabling the pnp resolution for some subpaths.
    // This is because some projects, often legacy, contain multiple
    // levels of dependencies (ie. a yarn.lock inside a subfolder of
    // a yarn.lock). This is typically solved using workspaces, but
    // not all of them have been converted already.

    if (issuer && isPathIgnored(issuer)) {
      // Absolute paths that seem to belong to a PnP tree are still
      // handled by our runtime even if the issuer isn't. This is
      // because the native Node resolution uses a special version
      // of the `stat` syscall which would otherwise bypass the
      // filesystem layer we require to access the files.
      if (!ppath.isAbsolute(request) || findPackageLocator(request) === null) {
        const result = callNativeResolution(request, issuer);

        if (result === false) {
          throw internalTools_makeError(ErrorCode.BUILTIN_NODE_RESOLUTION_FAILED, `The builtin node resolution algorithm was unable to resolve the requested module (it didn't go through the pnp resolver because the issuer was explicitely ignored by the regexp)\n\nRequire request: "${requestForDisplay}"\nRequired by: ${issuerForDisplay}\n`, {
            request: requestForDisplay,
            issuer: issuerForDisplay
          });
        }

        return npath.toPortablePath(result);
      }
    }

    let unqualifiedPath; // If the request is a relative or absolute path, we just return it normalized

    const dependencyNameMatch = request.match(pathRegExp);

    if (!dependencyNameMatch) {
      if (ppath.isAbsolute(request)) {
        unqualifiedPath = ppath.normalize(request);
      } else {
        if (!issuer) {
          throw internalTools_makeError(ErrorCode.API_ERROR, `The resolveToUnqualified function must be called with a valid issuer when the path isn't a builtin nor absolute`, {
            request: requestForDisplay,
            issuer: issuerForDisplay
          });
        } // We use ppath.join instead of ppath.resolve because:
        // 1) The request is a relative path in this branch
        // 2) ppath.join preserves trailing slashes


        const absoluteIssuer = ppath.resolve(issuer);

        if (issuer.match(isDirRegExp)) {
          unqualifiedPath = ppath.normalize(ppath.join(absoluteIssuer, request));
        } else {
          unqualifiedPath = ppath.normalize(ppath.join(ppath.dirname(absoluteIssuer), request));
        }
      } // No need to use the return value; we just want to check the blacklist status


      findPackageLocator(unqualifiedPath);
    } // Things are more hairy if it's a package require - we then need to figure out which package is needed, and in
    // particular the exact version for the given location on the dependency tree
    else {
        if (!issuer) {
          throw internalTools_makeError(ErrorCode.API_ERROR, `The resolveToUnqualified function must be called with a valid issuer when the path isn't a builtin nor absolute`, {
            request: requestForDisplay,
            issuer: issuerForDisplay
          });
        }

        const [, dependencyName, subPath] = dependencyNameMatch;
        const issuerLocator = findPackageLocator(issuer); // If the issuer file doesn't seem to be owned by a package managed through pnp, then we resort to using the next
        // resolution algorithm in the chain, usually the native Node resolution one

        if (!issuerLocator) {
          const result = callNativeResolution(request, issuer);

          if (result === false) {
            throw internalTools_makeError(ErrorCode.BUILTIN_NODE_RESOLUTION_FAILED, `The builtin node resolution algorithm was unable to resolve the requested module (it didn't go through the pnp resolver because the issuer doesn't seem to be part of the Yarn-managed dependency tree).\n\nRequire path: "${requestForDisplay}"\nRequired by: ${issuerForDisplay}\n`, {
              request: requestForDisplay,
              issuer: issuerForDisplay
            });
          }

          return npath.toPortablePath(result);
        }

        const issuerInformation = getPackageInformationSafe(issuerLocator); // We obtain the dependency reference in regard to the package that request it

        let dependencyReference = issuerInformation.packageDependencies.get(dependencyName);
        let fallbackReference = null; // If we can't find it, we check if we can potentially load it from the packages that have been defined as potential fallbacks.
        // It's a bit of a hack, but it improves compatibility with the existing Node ecosystem. Hopefully we should eventually be able
        // to kill this logic and become stricter once pnp gets enough traction and the affected packages fix themselves.

        if (dependencyReference == null) {
          if (issuerLocator.name !== null) {
            // To allow programs to become gradually stricter, starting from the v2 we enforce that workspaces cannot depend on fallbacks.
            // This works by having a list containing all their locators, and checking when a fallback is required whether it's one of them.
            const exclusionEntry = runtimeState.fallbackExclusionList.get(issuerLocator.name);
            const canUseFallbacks = !exclusionEntry || !exclusionEntry.has(issuerLocator.reference);

            if (canUseFallbacks) {
              for (let t = 0, T = fallbackLocators.length; t < T; ++t) {
                const fallbackInformation = getPackageInformationSafe(fallbackLocators[t]);
                const reference = fallbackInformation.packageDependencies.get(dependencyName);
                if (reference == null) continue;
                if (alwaysWarnOnFallback) fallbackReference = reference;else dependencyReference = reference;
                break;
              }

              if (runtimeState.enableTopLevelFallback) {
                if (dependencyReference == null && fallbackReference === null) {
                  const reference = runtimeState.fallbackPool.get(dependencyName);

                  if (reference != null) {
                    fallbackReference = reference;
                  }
                }
              }
            }
          }
        } // If we can't find the path, and if the package making the request is the top-level, we can offer nicer error messages


        let error = null;

        if (dependencyReference === null) {
          if (isDependencyTreeRoot(issuerLocator)) {
            error = internalTools_makeError(ErrorCode.MISSING_PEER_DEPENDENCY, `Your application tried to access ${dependencyName} (a peer dependency); this isn't allowed as there is no ancestor to satisfy the requirement. Use a devDependency if needed.\n\nRequired package: ${dependencyName} (via "${requestForDisplay}")\nRequired by: ${issuerForDisplay}\n`, {
              request: requestForDisplay,
              issuer: issuerForDisplay,
              dependencyName
            });
          } else {
            const brokenAncestors = findBrokenPeerDependencies(dependencyName, issuerLocator);

            if (brokenAncestors.every(ancestor => isDependencyTreeRoot(ancestor))) {
              error = internalTools_makeError(ErrorCode.MISSING_PEER_DEPENDENCY, `${issuerLocator.name} tried to access ${dependencyName} (a peer dependency) but it isn't provided by your application; this makes the require call ambiguous and unsound.\n\nRequired package: ${dependencyName} (via "${requestForDisplay}")\nRequired by: ${issuerLocator.name}@${issuerLocator.reference} (via ${issuerForDisplay})\n${brokenAncestors.map(ancestorLocator => `Ancestor breaking the chain: ${ancestorLocator.name}@${ancestorLocator.reference}\n`).join(``)}\n`, {
                request: requestForDisplay,
                issuer: issuerForDisplay,
                issuerLocator: Object.assign({}, issuerLocator),
                dependencyName,
                brokenAncestors
              });
            } else {
              error = internalTools_makeError(ErrorCode.MISSING_PEER_DEPENDENCY, `${issuerLocator.name} tried to access ${dependencyName} (a peer dependency) but it isn't provided by its ancestors; this makes the require call ambiguous and unsound.\n\nRequired package: ${dependencyName} (via "${requestForDisplay}")\nRequired by: ${issuerLocator.name}@${issuerLocator.reference} (via ${issuerForDisplay})\n${brokenAncestors.map(ancestorLocator => `Ancestor breaking the chain: ${ancestorLocator.name}@${ancestorLocator.reference}\n`).join(``)}\n`, {
                request: requestForDisplay,
                issuer: issuerForDisplay,
                issuerLocator: Object.assign({}, issuerLocator),
                dependencyName,
                brokenAncestors
              });
            }
          }
        } else if (dependencyReference === undefined) {
          if (!considerBuiltins && builtinModules.has(request)) {
            if (isDependencyTreeRoot(issuerLocator)) {
              error = internalTools_makeError(ErrorCode.UNDECLARED_DEPENDENCY, `Your application tried to access ${dependencyName}. While this module is usually interpreted as a Node builtin, your resolver is running inside a non-Node resolution context where such builtins are ignored. Since ${dependencyName} isn't otherwise declared in your dependencies, this makes the require call ambiguous and unsound.\n\nRequired package: ${dependencyName} (via "${requestForDisplay}")\nRequired by: ${issuerForDisplay}\n`, {
                request: requestForDisplay,
                issuer: issuerForDisplay,
                dependencyName
              });
            } else {
              error = internalTools_makeError(ErrorCode.UNDECLARED_DEPENDENCY, `${issuerLocator.name} tried to access ${dependencyName}. While this module is usually interpreted as a Node builtin, your resolver is running inside a non-Node resolution context where such builtins are ignored. Since ${dependencyName} isn't otherwise declared in ${issuerLocator.name}'s dependencies, this makes the require call ambiguous and unsound.\n\nRequired package: ${dependencyName} (via "${requestForDisplay}")\nRequired by: ${issuerForDisplay}\n`, {
                request: requestForDisplay,
                issuer: issuerForDisplay,
                issuerLocator: Object.assign({}, issuerLocator),
                dependencyName
              });
            }
          } else {
            if (isDependencyTreeRoot(issuerLocator)) {
              error = internalTools_makeError(ErrorCode.UNDECLARED_DEPENDENCY, `Your application tried to access ${dependencyName}, but it isn't declared in your dependencies; this makes the require call ambiguous and unsound.\n\nRequired package: ${dependencyName} (via "${requestForDisplay}")\nRequired by: ${issuerForDisplay}\n`, {
                request: requestForDisplay,
                issuer: issuerForDisplay,
                dependencyName
              });
            } else {
              error = internalTools_makeError(ErrorCode.UNDECLARED_DEPENDENCY, `${issuerLocator.name} tried to access ${dependencyName}, but it isn't declared in its dependencies; this makes the require call ambiguous and unsound.\n\nRequired package: ${dependencyName} (via "${requestForDisplay}")\nRequired by: ${issuerLocator.name}@${issuerLocator.reference} (via ${issuerForDisplay})\n`, {
                request: requestForDisplay,
                issuer: issuerForDisplay,
                issuerLocator: Object.assign({}, issuerLocator),
                dependencyName
              });
            }
          }
        }

        if (dependencyReference == null) {
          if (fallbackReference === null || error === null) throw error || new Error(`Assertion failed: Expected an error to have been set`);
          dependencyReference = fallbackReference;
          const message = error.message.replace(/\n.*/g, ``);
          error.message = message;

          if (!emittedWarnings.has(message)) {
            emittedWarnings.add(message);
            process.emitWarning(error);
          }
        } // We need to check that the package exists on the filesystem, because it might not have been installed


        const dependencyLocator = Array.isArray(dependencyReference) ? {
          name: dependencyReference[0],
          reference: dependencyReference[1]
        } : {
          name: dependencyName,
          reference: dependencyReference
        };
        const dependencyInformation = getPackageInformationSafe(dependencyLocator);

        if (!dependencyInformation.packageLocation) {
          throw internalTools_makeError(ErrorCode.MISSING_DEPENDENCY, `A dependency seems valid but didn't get installed for some reason. This might be caused by a partial install, such as dev vs prod.\n\nRequired package: ${dependencyLocator.name}@${dependencyLocator.reference} (via "${requestForDisplay}")\nRequired by: ${issuerLocator.name}@${issuerLocator.reference} (via ${issuerForDisplay})\n`, {
            request: requestForDisplay,
            issuer: issuerForDisplay,
            dependencyLocator: Object.assign({}, dependencyLocator)
          });
        } // Now that we know which package we should resolve to, we only have to find out the file location
        // packageLocation is always absolute as it's returned by getPackageInformationSafe


        const dependencyLocation = dependencyInformation.packageLocation;

        if (subPath) {
          // We use ppath.join instead of ppath.resolve because:
          // 1) subPath is always a relative path
          // 2) ppath.join preserves trailing slashes
          unqualifiedPath = ppath.join(dependencyLocation, subPath);
        } else {
          unqualifiedPath = dependencyLocation;
        }
      }

    return ppath.normalize(unqualifiedPath);
  }
  /**
   * Transforms an unqualified path into a qualified path by using the Node resolution algorithm (which automatically
   * appends ".js" / ".json", and transforms directory accesses into "index.js").
   */


  function resolveUnqualified(unqualifiedPath, {
    extensions = Object.keys(external_module_.Module._extensions)
  } = {}) {
    const candidates = [];
    const qualifiedPath = applyNodeExtensionResolution(unqualifiedPath, candidates, {
      extensions
    });

    if (qualifiedPath) {
      return ppath.normalize(qualifiedPath);
    } else {
      const unqualifiedPathForDisplay = getPathForDisplay(unqualifiedPath);
      throw internalTools_makeError(ErrorCode.QUALIFIED_PATH_RESOLUTION_FAILED, `Qualified path resolution failed - none of the candidates can be found on the disk.\n\nSource path: ${unqualifiedPathForDisplay}\n${candidates.map(candidate => `Rejected candidate: ${getPathForDisplay(candidate)}\n`).join(``)}`, {
        unqualifiedPath: unqualifiedPathForDisplay
      });
    }
  }
  /**
   * Transforms a request into a fully qualified path.
   *
   * Note that it is extremely important that the `issuer` path ends with a forward slash if the issuer is to be
   * treated as a folder (ie. "/tmp/foo/" rather than "/tmp/foo" if "foo" is a directory). Otherwise relative
   * imports won't be computed correctly (they'll get resolved relative to "/tmp/" instead of "/tmp/foo/").
   */


  function resolveRequest(request, issuer, {
    considerBuiltins,
    extensions
  } = {}) {
    const unqualifiedPath = resolveToUnqualified(request, issuer, {
      considerBuiltins
    });
    if (unqualifiedPath === null) return null;

    try {
      return resolveUnqualified(unqualifiedPath, {
        extensions
      });
    } catch (resolutionError) {
      if (resolutionError.pnpCode === `QUALIFIED_PATH_RESOLUTION_FAILED`) Object.assign(resolutionError.data, {
        request: getPathForDisplay(request),
        issuer: issuer && getPathForDisplay(issuer)
      });
      throw resolutionError;
    }
  }

  function resolveVirtual(request) {
    const normalized = ppath.normalize(request);
    const resolved = VirtualFS.resolveVirtual(normalized);
    return resolved !== normalized ? resolved : null;
  }

  return {
    VERSIONS,
    topLevel,
    getLocator: (name, referencish) => {
      if (Array.isArray(referencish)) {
        return {
          name: referencish[0],
          reference: referencish[1]
        };
      } else {
        return {
          name,
          reference: referencish
        };
      }
    },
    getDependencyTreeRoots: () => {
      return [...runtimeState.dependencyTreeRoots];
    },

    getAllLocators() {
      const locators = [];

      for (const [name, entry] of packageRegistry) for (const reference of entry.keys()) if (name !== null && reference !== null) locators.push({
        name,
        reference
      });

      return locators;
    },

    getPackageInformation: locator => {
      const info = getPackageInformation(locator);
      if (info === null) return null;
      const packageLocation = npath.fromPortablePath(info.packageLocation);
      const nativeInfo = { ...info,
        packageLocation
      };
      return nativeInfo;
    },
    findPackageLocator: path => {
      return findPackageLocator(npath.toPortablePath(path));
    },
    resolveToUnqualified: maybeLog(`resolveToUnqualified`, (request, issuer, opts) => {
      const portableIssuer = issuer !== null ? npath.toPortablePath(issuer) : null;
      const resolution = resolveToUnqualified(npath.toPortablePath(request), portableIssuer, opts);
      if (resolution === null) return null;
      return npath.fromPortablePath(resolution);
    }),
    resolveUnqualified: maybeLog(`resolveUnqualified`, (unqualifiedPath, opts) => {
      return npath.fromPortablePath(resolveUnqualified(npath.toPortablePath(unqualifiedPath), opts));
    }),
    resolveRequest: maybeLog(`resolveRequest`, (request, issuer, opts) => {
      const portableIssuer = issuer !== null ? npath.toPortablePath(issuer) : null;
      const resolution = resolveRequest(npath.toPortablePath(request), portableIssuer, opts);
      if (resolution === null) return null;
      return npath.fromPortablePath(resolution);
    }),
    resolveVirtual: maybeLog(`resolveVirtual`, path => {
      const result = resolveVirtual(npath.toPortablePath(path));

      if (result !== null) {
        return npath.fromPortablePath(result);
      } else {
        return null;
      }
    })
  };
}
// CONCATENATED MODULE: ./sources/loader/makeManager.ts


function makeManager(pnpapi, opts) {
  const initialApiPath = npath.toPortablePath(pnpapi.resolveToUnqualified(`pnpapi`, null));
  const initialApiStats = opts.fakeFs.statSync(npath.toPortablePath(initialApiPath));
  const apiMetadata = new Map([[initialApiPath, {
    cache: external_module_.Module._cache,
    instance: pnpapi,
    stats: initialApiStats,
    lastRefreshCheck: Date.now()
  }]]);

  function loadApiInstance(pnpApiPath) {
    const nativePath = npath.fromPortablePath(pnpApiPath); // @ts-expect-error

    const module = new external_module_.Module(nativePath, null); // @ts-expect-error

    module.load(nativePath);
    return module.exports;
  }

  function refreshApiEntry(pnpApiPath, apiEntry) {
    const timeNow = Date.now();
    if (timeNow - apiEntry.lastRefreshCheck < 500) return;
    apiEntry.lastRefreshCheck = timeNow;
    const stats = opts.fakeFs.statSync(pnpApiPath);

    if (stats.mtime > apiEntry.stats.mtime) {
      console.warn(`[Warning] The runtime detected new informations in a PnP file; reloading the API instance (${npath.fromPortablePath(pnpApiPath)})`);
      apiEntry.stats = stats;
      apiEntry.instance = loadApiInstance(pnpApiPath);
    }
  }

  function getApiEntry(pnpApiPath, refresh = false) {
    let apiEntry = apiMetadata.get(pnpApiPath);

    if (typeof apiEntry !== `undefined`) {
      if (refresh) {
        refreshApiEntry(pnpApiPath, apiEntry);
      }
    } else {
      apiMetadata.set(pnpApiPath, apiEntry = {
        cache: {},
        instance: loadApiInstance(pnpApiPath),
        stats: opts.fakeFs.statSync(pnpApiPath),
        lastRefreshCheck: Date.now()
      });
    }

    return apiEntry;
  }

  const findApiPathCache = new Map();

  function addToCacheAndReturn(start, end, target) {
    if (target !== null) target = VirtualFS.resolveVirtual(target);
    let curr;
    let next = start;

    do {
      curr = next;
      findApiPathCache.set(curr, target);
      next = ppath.dirname(curr);
    } while (curr !== end);

    return target;
  }

  function findApiPathFor(modulePath) {
    const controlledBy = [];

    for (const [apiPath, apiEntry] of apiMetadata) {
      const locator = apiEntry.instance.findPackageLocator(modulePath);

      if (locator) {
        if (apiMetadata.size === 1) {
          return apiPath;
        } else {
          controlledBy.push(apiPath);
        }
      }
    }

    if (controlledBy.length !== 0) {
      if (controlledBy.length === 1) return controlledBy[0];
      throw new Error(`Unable to locate pnpapi, the module '${modulePath}' is controlled by multiple pnpapi instances.\nThis is usually caused by using the global cache (enableGlobalCache: true)\n\nControlled by:\n${controlledBy.map(pnpPath => `  ${npath.fromPortablePath(pnpPath)}`).join(`\n`)}`);
    }

    const start = ppath.resolve(npath.toPortablePath(modulePath));
    let curr;
    let next = start;

    do {
      curr = next;
      const cached = findApiPathCache.get(curr);
      if (cached !== undefined) return addToCacheAndReturn(start, curr, cached);
      const candidate = ppath.join(curr, `.pnp.js`);
      if (xfs.existsSync(candidate) && xfs.statSync(candidate).isFile()) return addToCacheAndReturn(start, curr, candidate);
      const cjsCandidate = ppath.join(curr, `.pnp.cjs`);
      if (xfs.existsSync(cjsCandidate) && xfs.statSync(cjsCandidate).isFile()) return addToCacheAndReturn(start, curr, cjsCandidate);
      next = ppath.dirname(curr);
    } while (curr !== PortablePath.root);

    return addToCacheAndReturn(start, curr, null);
  }

  function getApiPathFromParent(parent) {
    if (parent == null) return initialApiPath;

    if (typeof parent.pnpApiPath === `undefined`) {
      if (parent.filename !== null) {
        return parent.pnpApiPath = findApiPathFor(parent.filename);
      } else {
        return initialApiPath;
      }
    }

    if (parent.pnpApiPath !== null) return parent.pnpApiPath;
    return null;
  }

  return {
    getApiPathFromParent,
    findApiPathFor,
    getApiEntry
  };
}
// CONCATENATED MODULE: ./sources/loader/_entryPoint.ts








 // We must copy the fs into a local, because otherwise
// 1. we would make the NodeFS instance use the function that we patched (infinite loop)
// 2. Object.create(fs) isn't enough, since it won't prevent the proto from being modified

const localFs = { ...(external_fs_default())
};
const nodeFs = new NodeFS(localFs);
const defaultRuntimeState = $$SETUP_STATE(hydrateRuntimeState);
const defaultPnpapiResolution = __filename; // We create a virtual filesystem that will do three things:
// 1. all requests inside a folder named "$$virtual" will be remapped according the virtual folder rules
// 2. all requests going inside a Zip archive will be handled by the Zip fs implementation
// 3. any remaining request will be forwarded to Node as-is

const defaultFsLayer = new VirtualFS({
  baseFs: new ZipOpenFS({
    baseFs: nodeFs,
    libzip: getLibzipSync(),
    maxOpenFiles: 80,
    readOnlyArchives: true
  })
});
let manager;
const defaultApi = Object.assign(makeApi(defaultRuntimeState, {
  fakeFs: defaultFsLayer,
  pnpapiResolution: defaultPnpapiResolution
}), {
  /**
   * Can be used to generate a different API than the default one (for example
   * to map it on `/` rather than the local directory path, or to use a
   * different FS layer than the default one).
   */
  makeApi: ({
    basePath = undefined,
    fakeFs = defaultFsLayer,
    pnpapiResolution = defaultPnpapiResolution,
    ...rest
  }) => {
    const apiRuntimeState = typeof basePath !== `undefined` ? $$SETUP_STATE(hydrateRuntimeState, basePath) : defaultRuntimeState;
    return makeApi(apiRuntimeState, {
      fakeFs,
      pnpapiResolution,
      ...rest
    });
  },

  /**
   * Will inject the specified API into the environment, monkey-patching FS. Is
   * automatically called when the hook is loaded through `--require`.
   */
  setup: api => {
    applyPatch(api || defaultApi, {
      fakeFs: defaultFsLayer,
      manager
    });
  }
});
manager = makeManager(defaultApi, {
  fakeFs: defaultFsLayer
}); // eslint-disable-next-line arca/no-default-export

/* harmony default export */ const _entryPoint = (defaultApi);

if (__non_webpack_module__.parent && __non_webpack_module__.parent.id === `internal/preload`) {
  defaultApi.setup();

  if (__non_webpack_module__.filename) {
    // We delete it from the cache in order to support the case where the CLI resolver is invoked from "yarn run"
    // It's annoying because it might cause some issues when the file is multiple times in NODE_OPTIONS, but it shouldn't happen anyway.
    delete (external_module_default())._cache[__non_webpack_module__.filename];
  }
}

if (process.mainModule === __non_webpack_module__) {
  const reportError = (code, message, data) => {
    process.stdout.write(`${JSON.stringify([{
      code,
      message,
      data
    }, null])}\n`);
  };

  const reportSuccess = resolution => {
    process.stdout.write(`${JSON.stringify([null, resolution])}\n`);
  };

  const processResolution = (request, issuer) => {
    try {
      reportSuccess(defaultApi.resolveRequest(request, issuer));
    } catch (error) {
      reportError(error.code, error.message, error.data);
    }
  };

  const processRequest = data => {
    try {
      const [request, issuer] = JSON.parse(data);
      processResolution(request, issuer);
    } catch (error) {
      reportError(`INVALID_JSON`, error.message, error.data);
    }
  };

  if (process.argv.length > 2) {
    if (process.argv.length !== 4) {
      process.stderr.write(`Usage: ${process.argv[0]} ${process.argv[1]} <request> <issuer>\n`);
      process.exitCode = 64;
      /* EX_USAGE */
    } else {
      processResolution(process.argv[2], process.argv[3]);
    }
  } else {
    let buffer = ``;
    const decoder = new (external_string_decoder_default()).StringDecoder();
    process.stdin.on(`data`, chunk => {
      buffer += decoder.write(chunk);

      do {
        const index = buffer.indexOf(`\n`);
        if (index === -1) break;
        const line = buffer.slice(0, index);
        buffer = buffer.slice(index + 1);
        processRequest(line);
      } while (true);
    });
  }
}

/***/ }),

/***/ 368:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var frozenFs = Object.assign({}, __webpack_require__(747));
var Module = typeof Module !== "undefined" ? Module : {};
var moduleOverrides = {};
var key;
for (key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}
var arguments_ = [];
var thisProgram = "./this.program";
var quit_ = function(status, toThrow) {
  throw toThrow;
};
var ENVIRONMENT_IS_WORKER = false;
var ENVIRONMENT_IS_NODE = true;
var scriptDirectory = "";
function locateFile(path) {
  if (Module["locateFile"]) {
    return Module["locateFile"](path, scriptDirectory);
  }
  return scriptDirectory + path;
}
var read_, readBinary;
var nodeFS;
var nodePath;
if (ENVIRONMENT_IS_NODE) {
  if (ENVIRONMENT_IS_WORKER) {
    scriptDirectory = __webpack_require__(622).dirname(scriptDirectory) + "/";
  } else {
    scriptDirectory = __dirname + "/";
  }
  read_ = function shell_read(filename, binary) {
    var ret = tryParseAsDataURI(filename);
    if (ret) {
      return binary ? ret : ret.toString();
    }
    if (!nodeFS) nodeFS = frozenFs;
    if (!nodePath) nodePath = __webpack_require__(622);
    filename = nodePath["normalize"](filename);
    return nodeFS["readFileSync"](filename, binary ? null : "utf8");
  };
  readBinary = function readBinary(filename) {
    var ret = read_(filename, true);
    if (!ret.buffer) {
      ret = new Uint8Array(ret);
    }
    assert(ret.buffer);
    return ret;
  };
  if (process["argv"].length > 1) {
    thisProgram = process["argv"][1].replace(/\\/g, "/");
  }
  arguments_ = process["argv"].slice(2);
  if (true) {
    module["exports"] = Module;
  }
  quit_ = function(status) {
    process["exit"](status);
  };
  Module["inspect"] = function() {
    return "[Emscripten Module object]";
  };
} else {
}
var out = Module["print"] || console.log.bind(console);
var err = Module["printErr"] || console.warn.bind(console);
for (key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
moduleOverrides = null;
if (Module["arguments"]) arguments_ = Module["arguments"];
if (Module["thisProgram"]) thisProgram = Module["thisProgram"];
if (Module["quit"]) quit_ = Module["quit"];
var STACK_ALIGN = 16;
function alignMemory(size, factor) {
  if (!factor) factor = STACK_ALIGN;
  return Math.ceil(size / factor) * factor;
}
var tempRet0 = 0;
var setTempRet0 = function(value) {
  tempRet0 = value;
};
var wasmBinary;
if (Module["wasmBinary"]) wasmBinary = Module["wasmBinary"];
var noExitRuntime;
if (Module["noExitRuntime"]) noExitRuntime = Module["noExitRuntime"];
if (typeof WebAssembly !== "object") {
  abort("no native wasm support detected");
}
function getValue(ptr, type, noSafe) {
  type = type || "i8";
  if (type.charAt(type.length - 1) === "*") type = "i32";
  switch (type) {
    case "i1":
      return HEAP8[ptr >> 0];
    case "i8":
      return HEAP8[ptr >> 0];
    case "i16":
      return HEAP16[ptr >> 1];
    case "i32":
      return HEAP32[ptr >> 2];
    case "i64":
      return HEAP32[ptr >> 2];
    case "float":
      return HEAPF32[ptr >> 2];
    case "double":
      return HEAPF64[ptr >> 3];
    default:
      abort("invalid type for getValue: " + type);
  }
  return null;
}
var wasmMemory;
var wasmTable = new WebAssembly.Table({
  initial: 31,
  maximum: 31,
  element: "anyfunc"
});
var ABORT = false;
var EXITSTATUS = 0;
function assert(condition, text) {
  if (!condition) {
    abort("Assertion failed: " + text);
  }
}
function getCFunc(ident) {
  var func = Module["_" + ident];
  assert(
    func,
    "Cannot call unknown function " + ident + ", make sure it is exported"
  );
  return func;
}
function ccall(ident, returnType, argTypes, args, opts) {
  var toC = {
    string: function(str) {
      var ret = 0;
      if (str !== null && str !== undefined && str !== 0) {
        var len = (str.length << 2) + 1;
        ret = stackAlloc(len);
        stringToUTF8(str, ret, len);
      }
      return ret;
    },
    array: function(arr) {
      var ret = stackAlloc(arr.length);
      writeArrayToMemory(arr, ret);
      return ret;
    }
  };
  function convertReturnValue(ret) {
    if (returnType === "string") return UTF8ToString(ret);
    if (returnType === "boolean") return Boolean(ret);
    return ret;
  }
  var func = getCFunc(ident);
  var cArgs = [];
  var stack = 0;
  if (args) {
    for (var i = 0; i < args.length; i++) {
      var converter = toC[argTypes[i]];
      if (converter) {
        if (stack === 0) stack = stackSave();
        cArgs[i] = converter(args[i]);
      } else {
        cArgs[i] = args[i];
      }
    }
  }
  var ret = func.apply(null, cArgs);
  ret = convertReturnValue(ret);
  if (stack !== 0) stackRestore(stack);
  return ret;
}
function cwrap(ident, returnType, argTypes, opts) {
  argTypes = argTypes || [];
  var numericArgs = argTypes.every(function(type) {
    return type === "number";
  });
  var numericRet = returnType !== "string";
  if (numericRet && numericArgs && !opts) {
    return getCFunc(ident);
  }
  return function() {
    return ccall(ident, returnType, argTypes, arguments, opts);
  };
}
var UTF8Decoder =
  typeof TextDecoder !== "undefined" ? new TextDecoder("utf8") : undefined;
function UTF8ArrayToString(heap, idx, maxBytesToRead) {
  var endIdx = idx + maxBytesToRead;
  var endPtr = idx;
  while (heap[endPtr] && !(endPtr >= endIdx)) ++endPtr;
  if (endPtr - idx > 16 && heap.subarray && UTF8Decoder) {
    return UTF8Decoder.decode(heap.subarray(idx, endPtr));
  } else {
    var str = "";
    while (idx < endPtr) {
      var u0 = heap[idx++];
      if (!(u0 & 128)) {
        str += String.fromCharCode(u0);
        continue;
      }
      var u1 = heap[idx++] & 63;
      if ((u0 & 224) == 192) {
        str += String.fromCharCode(((u0 & 31) << 6) | u1);
        continue;
      }
      var u2 = heap[idx++] & 63;
      if ((u0 & 240) == 224) {
        u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
      } else {
        u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | (heap[idx++] & 63);
      }
      if (u0 < 65536) {
        str += String.fromCharCode(u0);
      } else {
        var ch = u0 - 65536;
        str += String.fromCharCode(55296 | (ch >> 10), 56320 | (ch & 1023));
      }
    }
  }
  return str;
}
function UTF8ToString(ptr, maxBytesToRead) {
  return ptr ? UTF8ArrayToString(HEAPU8, ptr, maxBytesToRead) : "";
}
function stringToUTF8Array(str, heap, outIdx, maxBytesToWrite) {
  if (!(maxBytesToWrite > 0)) return 0;
  var startIdx = outIdx;
  var endIdx = outIdx + maxBytesToWrite - 1;
  for (var i = 0; i < str.length; ++i) {
    var u = str.charCodeAt(i);
    if (u >= 55296 && u <= 57343) {
      var u1 = str.charCodeAt(++i);
      u = (65536 + ((u & 1023) << 10)) | (u1 & 1023);
    }
    if (u <= 127) {
      if (outIdx >= endIdx) break;
      heap[outIdx++] = u;
    } else if (u <= 2047) {
      if (outIdx + 1 >= endIdx) break;
      heap[outIdx++] = 192 | (u >> 6);
      heap[outIdx++] = 128 | (u & 63);
    } else if (u <= 65535) {
      if (outIdx + 2 >= endIdx) break;
      heap[outIdx++] = 224 | (u >> 12);
      heap[outIdx++] = 128 | ((u >> 6) & 63);
      heap[outIdx++] = 128 | (u & 63);
    } else {
      if (outIdx + 3 >= endIdx) break;
      heap[outIdx++] = 240 | (u >> 18);
      heap[outIdx++] = 128 | ((u >> 12) & 63);
      heap[outIdx++] = 128 | ((u >> 6) & 63);
      heap[outIdx++] = 128 | (u & 63);
    }
  }
  heap[outIdx] = 0;
  return outIdx - startIdx;
}
function stringToUTF8(str, outPtr, maxBytesToWrite) {
  return stringToUTF8Array(str, HEAPU8, outPtr, maxBytesToWrite);
}
function lengthBytesUTF8(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    var u = str.charCodeAt(i);
    if (u >= 55296 && u <= 57343)
      u = (65536 + ((u & 1023) << 10)) | (str.charCodeAt(++i) & 1023);
    if (u <= 127) ++len;
    else if (u <= 2047) len += 2;
    else if (u <= 65535) len += 3;
    else len += 4;
  }
  return len;
}
function allocateUTF8(str) {
  var size = lengthBytesUTF8(str) + 1;
  var ret = _malloc(size);
  if (ret) stringToUTF8Array(str, HEAP8, ret, size);
  return ret;
}
function writeArrayToMemory(array, buffer) {
  HEAP8.set(array, buffer);
}
var WASM_PAGE_SIZE = 65536;
function alignUp(x, multiple) {
  if (x % multiple > 0) {
    x += multiple - (x % multiple);
  }
  return x;
}
var buffer, HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
function updateGlobalBufferAndViews(buf) {
  buffer = buf;
  Module["HEAP8"] = HEAP8 = new Int8Array(buf);
  Module["HEAP16"] = HEAP16 = new Int16Array(buf);
  Module["HEAP32"] = HEAP32 = new Int32Array(buf);
  Module["HEAPU8"] = HEAPU8 = new Uint8Array(buf);
  Module["HEAPU16"] = HEAPU16 = new Uint16Array(buf);
  Module["HEAPU32"] = HEAPU32 = new Uint32Array(buf);
  Module["HEAPF32"] = HEAPF32 = new Float32Array(buf);
  Module["HEAPF64"] = HEAPF64 = new Float64Array(buf);
}
var INITIAL_INITIAL_MEMORY = Module["INITIAL_MEMORY"] || 16777216;
if (Module["wasmMemory"]) {
  wasmMemory = Module["wasmMemory"];
} else {
  wasmMemory = new WebAssembly.Memory({
    initial: INITIAL_INITIAL_MEMORY / WASM_PAGE_SIZE,
    maximum: 2147483648 / WASM_PAGE_SIZE
  });
}
if (wasmMemory) {
  buffer = wasmMemory.buffer;
}
INITIAL_INITIAL_MEMORY = buffer.byteLength;
updateGlobalBufferAndViews(buffer);
var __ATPRERUN__ = [];
var __ATINIT__ = [];
var __ATMAIN__ = [];
var __ATPOSTRUN__ = [];
var runtimeInitialized = false;
function preRun() {
  if (Module["preRun"]) {
    if (typeof Module["preRun"] == "function")
      Module["preRun"] = [Module["preRun"]];
    while (Module["preRun"].length) {
      addOnPreRun(Module["preRun"].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}
function initRuntime() {
  runtimeInitialized = true;
  if (!Module["noFSInit"] && !FS.init.initialized) FS.init();
  TTY.init();
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  FS.ignorePermissions = false;
  callRuntimeCallbacks(__ATMAIN__);
}
function postRun() {
  if (Module["postRun"]) {
    if (typeof Module["postRun"] == "function")
      Module["postRun"] = [Module["postRun"]];
    while (Module["postRun"].length) {
      addOnPostRun(Module["postRun"].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}
function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
var Math_abs = Math.abs;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_min = Math.min;
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null;
function getUniqueRunDependency(id) {
  return id;
}
function addRunDependency(id) {
  runDependencies++;
  if (Module["monitorRunDependencies"]) {
    Module["monitorRunDependencies"](runDependencies);
  }
}
function removeRunDependency(id) {
  runDependencies--;
  if (Module["monitorRunDependencies"]) {
    Module["monitorRunDependencies"](runDependencies);
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback();
    }
  }
}
Module["preloadedImages"] = {};
Module["preloadedAudios"] = {};
function abort(what) {
  if (Module["onAbort"]) {
    Module["onAbort"](what);
  }
  what += "";
  err(what);
  ABORT = true;
  EXITSTATUS = 1;
  what = "abort(" + what + "). Build with -s ASSERTIONS=1 for more info.";
  var e = new WebAssembly.RuntimeError(what);
  throw e;
}
function hasPrefix(str, prefix) {
  return String.prototype.startsWith
    ? str.startsWith(prefix)
    : str.indexOf(prefix) === 0;
}
var dataURIPrefix = "data:application/octet-stream;base64,";
function isDataURI(filename) {
  return hasPrefix(filename, dataURIPrefix);
}
var wasmBinaryFile =
  "data:application/octet-stream;base64,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";
if (!isDataURI(wasmBinaryFile)) {
  wasmBinaryFile = locateFile(wasmBinaryFile);
}
function getBinary() {
  try {
    if (wasmBinary) {
      return new Uint8Array(wasmBinary);
    }
    var binary = tryParseAsDataURI(wasmBinaryFile);
    if (binary) {
      return binary;
    }
    if (readBinary) {
      return readBinary(wasmBinaryFile);
    } else {
      throw "sync fetching of the wasm failed: you can preload it to Module['wasmBinary'] manually, or emcc.py will do that for you when generating HTML (but not JS)";
    }
  } catch (err) {
    abort(err);
  }
}
function createWasm() {
  var info = { a: asmLibraryArg };
  function receiveInstance(instance, module) {
    var exports = instance.exports;
    Module["asm"] = exports;
    removeRunDependency("wasm-instantiate");
  }
  addRunDependency("wasm-instantiate");
  function instantiateSync() {
    var instance;
    var module;
    var binary;
    try {
      binary = getBinary();
      module = new WebAssembly.Module(binary);
      instance = new WebAssembly.Instance(module, info);
    } catch (e) {
      var str = e.toString();
      err("failed to compile wasm module: " + str);
      if (
        str.indexOf("imported Memory") >= 0 ||
        str.indexOf("memory import") >= 0
      ) {
        err(
          "Memory size incompatibility issues may be due to changing INITIAL_MEMORY at runtime to something too large. Use ALLOW_MEMORY_GROWTH to allow any size memory (and also make sure not to set INITIAL_MEMORY at runtime to something smaller than it was at compile time)."
        );
      }
      throw e;
    }
    receiveInstance(instance, module);
  }
  if (Module["instantiateWasm"]) {
    try {
      var exports = Module["instantiateWasm"](info, receiveInstance);
      return exports;
    } catch (e) {
      err("Module.instantiateWasm callback failed with error: " + e);
      return false;
    }
  }
  instantiateSync();
  return Module["asm"];
}
var tempDouble;
var tempI64;
__ATINIT__.push({
  func: function() {
    ___wasm_call_ctors();
  }
});
function callRuntimeCallbacks(callbacks) {
  while (callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == "function") {
      callback(Module);
      continue;
    }
    var func = callback.func;
    if (typeof func === "number") {
      if (callback.arg === undefined) {
        wasmTable.get(func)();
      } else {
        wasmTable.get(func)(callback.arg);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
function demangle(func) {
  return func;
}
function demangleAll(text) {
  var regex = /\b_Z[\w\d_]+/g;
  return text.replace(regex, function(x) {
    var y = demangle(x);
    return x === y ? x : y + " [" + x + "]";
  });
}
function jsStackTrace() {
  var error = new Error();
  if (!error.stack) {
    try {
      throw new Error();
    } catch (e) {
      error = e;
    }
    if (!error.stack) {
      return "(no stack trace available)";
    }
  }
  return error.stack.toString();
}
function stackTrace() {
  var js = jsStackTrace();
  if (Module["extraStackTrace"]) js += "\n" + Module["extraStackTrace"]();
  return demangleAll(js);
}
function _gmtime_r(time, tmPtr) {
  var date = new Date(HEAP32[time >> 2] * 1e3);
  HEAP32[tmPtr >> 2] = date.getUTCSeconds();
  HEAP32[(tmPtr + 4) >> 2] = date.getUTCMinutes();
  HEAP32[(tmPtr + 8) >> 2] = date.getUTCHours();
  HEAP32[(tmPtr + 12) >> 2] = date.getUTCDate();
  HEAP32[(tmPtr + 16) >> 2] = date.getUTCMonth();
  HEAP32[(tmPtr + 20) >> 2] = date.getUTCFullYear() - 1900;
  HEAP32[(tmPtr + 24) >> 2] = date.getUTCDay();
  HEAP32[(tmPtr + 36) >> 2] = 0;
  HEAP32[(tmPtr + 32) >> 2] = 0;
  var start = Date.UTC(date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);
  var yday = ((date.getTime() - start) / (1e3 * 60 * 60 * 24)) | 0;
  HEAP32[(tmPtr + 28) >> 2] = yday;
  if (!_gmtime_r.GMTString) _gmtime_r.GMTString = allocateUTF8("GMT");
  HEAP32[(tmPtr + 40) >> 2] = _gmtime_r.GMTString;
  return tmPtr;
}
function ___gmtime_r(a0, a1) {
  return _gmtime_r(a0, a1);
}
var PATH = {
  splitPath: function(filename) {
    var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
    return splitPathRe.exec(filename).slice(1);
  },
  normalizeArray: function(parts, allowAboveRoot) {
    var up = 0;
    for (var i = parts.length - 1; i >= 0; i--) {
      var last = parts[i];
      if (last === ".") {
        parts.splice(i, 1);
      } else if (last === "..") {
        parts.splice(i, 1);
        up++;
      } else if (up) {
        parts.splice(i, 1);
        up--;
      }
    }
    if (allowAboveRoot) {
      for (; up; up--) {
        parts.unshift("..");
      }
    }
    return parts;
  },
  normalize: function(path) {
    var isAbsolute = path.charAt(0) === "/",
      trailingSlash = path.slice(-1) === "/";
    path = PATH.normalizeArray(
      path.split("/").filter(function(p) {
        return !!p;
      }),
      !isAbsolute
    ).join("/");
    if (!path && !isAbsolute) {
      path = ".";
    }
    if (path && trailingSlash) {
      path += "/";
    }
    return (isAbsolute ? "/" : "") + path;
  },
  dirname: function(path) {
    var result = PATH.splitPath(path),
      root = result[0],
      dir = result[1];
    if (!root && !dir) {
      return ".";
    }
    if (dir) {
      dir = dir.slice(0, -1);
    }
    return root + dir;
  },
  basename: function(path) {
    if (path === "/") return "/";
    path = PATH.normalize(path);
    path = path.replace(/\/$/, "");
    var lastSlash = path.lastIndexOf("/");
    if (lastSlash === -1) return path;
    return path.slice(lastSlash + 1);
  },
  extname: function(path) {
    return PATH.splitPath(path)[3];
  },
  join: function() {
    var paths = Array.prototype.slice.call(arguments, 0);
    return PATH.normalize(paths.join("/"));
  },
  join2: function(l, r) {
    return PATH.normalize(l + "/" + r);
  }
};
function setErrNo(value) {
  HEAP32[___errno_location() >> 2] = value;
  return value;
}
var PATH_FS = {
  resolve: function() {
    var resolvedPath = "",
      resolvedAbsolute = false;
    for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
      var path = i >= 0 ? arguments[i] : FS.cwd();
      if (typeof path !== "string") {
        throw new TypeError("Arguments to path.resolve must be strings");
      } else if (!path) {
        return "";
      }
      resolvedPath = path + "/" + resolvedPath;
      resolvedAbsolute = path.charAt(0) === "/";
    }
    resolvedPath = PATH.normalizeArray(
      resolvedPath.split("/").filter(function(p) {
        return !!p;
      }),
      !resolvedAbsolute
    ).join("/");
    return (resolvedAbsolute ? "/" : "") + resolvedPath || ".";
  },
  relative: function(from, to) {
    from = PATH_FS.resolve(from).slice(1);
    to = PATH_FS.resolve(to).slice(1);
    function trim(arr) {
      var start = 0;
      for (; start < arr.length; start++) {
        if (arr[start] !== "") break;
      }
      var end = arr.length - 1;
      for (; end >= 0; end--) {
        if (arr[end] !== "") break;
      }
      if (start > end) return [];
      return arr.slice(start, end - start + 1);
    }
    var fromParts = trim(from.split("/"));
    var toParts = trim(to.split("/"));
    var length = Math.min(fromParts.length, toParts.length);
    var samePartsLength = length;
    for (var i = 0; i < length; i++) {
      if (fromParts[i] !== toParts[i]) {
        samePartsLength = i;
        break;
      }
    }
    var outputParts = [];
    for (var i = samePartsLength; i < fromParts.length; i++) {
      outputParts.push("..");
    }
    outputParts = outputParts.concat(toParts.slice(samePartsLength));
    return outputParts.join("/");
  }
};
var TTY = {
  ttys: [],
  init: function() {},
  shutdown: function() {},
  register: function(dev, ops) {
    TTY.ttys[dev] = { input: [], output: [], ops: ops };
    FS.registerDevice(dev, TTY.stream_ops);
  },
  stream_ops: {
    open: function(stream) {
      var tty = TTY.ttys[stream.node.rdev];
      if (!tty) {
        throw new FS.ErrnoError(43);
      }
      stream.tty = tty;
      stream.seekable = false;
    },
    close: function(stream) {
      stream.tty.ops.flush(stream.tty);
    },
    flush: function(stream) {
      stream.tty.ops.flush(stream.tty);
    },
    read: function(stream, buffer, offset, length, pos) {
      if (!stream.tty || !stream.tty.ops.get_char) {
        throw new FS.ErrnoError(60);
      }
      var bytesRead = 0;
      for (var i = 0; i < length; i++) {
        var result;
        try {
          result = stream.tty.ops.get_char(stream.tty);
        } catch (e) {
          throw new FS.ErrnoError(29);
        }
        if (result === undefined && bytesRead === 0) {
          throw new FS.ErrnoError(6);
        }
        if (result === null || result === undefined) break;
        bytesRead++;
        buffer[offset + i] = result;
      }
      if (bytesRead) {
        stream.node.timestamp = Date.now();
      }
      return bytesRead;
    },
    write: function(stream, buffer, offset, length, pos) {
      if (!stream.tty || !stream.tty.ops.put_char) {
        throw new FS.ErrnoError(60);
      }
      try {
        for (var i = 0; i < length; i++) {
          stream.tty.ops.put_char(stream.tty, buffer[offset + i]);
        }
      } catch (e) {
        throw new FS.ErrnoError(29);
      }
      if (length) {
        stream.node.timestamp = Date.now();
      }
      return i;
    }
  },
  default_tty_ops: {
    get_char: function(tty) {
      if (!tty.input.length) {
        var result = null;
        if (ENVIRONMENT_IS_NODE) {
          var BUFSIZE = 256;
          var buf = Buffer.alloc ? Buffer.alloc(BUFSIZE) : new Buffer(BUFSIZE);
          var bytesRead = 0;
          try {
            bytesRead = nodeFS.readSync(
              process.stdin.fd,
              buf,
              0,
              BUFSIZE,
              null
            );
          } catch (e) {
            if (e.toString().indexOf("EOF") != -1) bytesRead = 0;
            else throw e;
          }
          if (bytesRead > 0) {
            result = buf.slice(0, bytesRead).toString("utf-8");
          } else {
            result = null;
          }
        } else if (
          typeof window != "undefined" &&
          typeof window.prompt == "function"
        ) {
          result = window.prompt("Input: ");
          if (result !== null) {
            result += "\n";
          }
        } else if (typeof readline == "function") {
          result = readline();
          if (result !== null) {
            result += "\n";
          }
        }
        if (!result) {
          return null;
        }
        tty.input = intArrayFromString(result, true);
      }
      return tty.input.shift();
    },
    put_char: function(tty, val) {
      if (val === null || val === 10) {
        out(UTF8ArrayToString(tty.output, 0));
        tty.output = [];
      } else {
        if (val != 0) tty.output.push(val);
      }
    },
    flush: function(tty) {
      if (tty.output && tty.output.length > 0) {
        out(UTF8ArrayToString(tty.output, 0));
        tty.output = [];
      }
    }
  },
  default_tty1_ops: {
    put_char: function(tty, val) {
      if (val === null || val === 10) {
        err(UTF8ArrayToString(tty.output, 0));
        tty.output = [];
      } else {
        if (val != 0) tty.output.push(val);
      }
    },
    flush: function(tty) {
      if (tty.output && tty.output.length > 0) {
        err(UTF8ArrayToString(tty.output, 0));
        tty.output = [];
      }
    }
  }
};
var MEMFS = {
  ops_table: null,
  mount: function(mount) {
    return MEMFS.createNode(null, "/", 16384 | 511, 0);
  },
  createNode: function(parent, name, mode, dev) {
    if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
      throw new FS.ErrnoError(63);
    }
    if (!MEMFS.ops_table) {
      MEMFS.ops_table = {
        dir: {
          node: {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr,
            lookup: MEMFS.node_ops.lookup,
            mknod: MEMFS.node_ops.mknod,
            rename: MEMFS.node_ops.rename,
            unlink: MEMFS.node_ops.unlink,
            rmdir: MEMFS.node_ops.rmdir,
            readdir: MEMFS.node_ops.readdir,
            symlink: MEMFS.node_ops.symlink
          },
          stream: { llseek: MEMFS.stream_ops.llseek }
        },
        file: {
          node: {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr
          },
          stream: {
            llseek: MEMFS.stream_ops.llseek,
            read: MEMFS.stream_ops.read,
            write: MEMFS.stream_ops.write,
            allocate: MEMFS.stream_ops.allocate,
            mmap: MEMFS.stream_ops.mmap,
            msync: MEMFS.stream_ops.msync
          }
        },
        link: {
          node: {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr,
            readlink: MEMFS.node_ops.readlink
          },
          stream: {}
        },
        chrdev: {
          node: {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr
          },
          stream: FS.chrdev_stream_ops
        }
      };
    }
    var node = FS.createNode(parent, name, mode, dev);
    if (FS.isDir(node.mode)) {
      node.node_ops = MEMFS.ops_table.dir.node;
      node.stream_ops = MEMFS.ops_table.dir.stream;
      node.contents = {};
    } else if (FS.isFile(node.mode)) {
      node.node_ops = MEMFS.ops_table.file.node;
      node.stream_ops = MEMFS.ops_table.file.stream;
      node.usedBytes = 0;
      node.contents = null;
    } else if (FS.isLink(node.mode)) {
      node.node_ops = MEMFS.ops_table.link.node;
      node.stream_ops = MEMFS.ops_table.link.stream;
    } else if (FS.isChrdev(node.mode)) {
      node.node_ops = MEMFS.ops_table.chrdev.node;
      node.stream_ops = MEMFS.ops_table.chrdev.stream;
    }
    node.timestamp = Date.now();
    if (parent) {
      parent.contents[name] = node;
    }
    return node;
  },
  getFileDataAsRegularArray: function(node) {
    if (node.contents && node.contents.subarray) {
      var arr = [];
      for (var i = 0; i < node.usedBytes; ++i) arr.push(node.contents[i]);
      return arr;
    }
    return node.contents;
  },
  getFileDataAsTypedArray: function(node) {
    if (!node.contents) return new Uint8Array(0);
    if (node.contents.subarray)
      return node.contents.subarray(0, node.usedBytes);
    return new Uint8Array(node.contents);
  },
  expandFileStorage: function(node, newCapacity) {
    var prevCapacity = node.contents ? node.contents.length : 0;
    if (prevCapacity >= newCapacity) return;
    var CAPACITY_DOUBLING_MAX = 1024 * 1024;
    newCapacity = Math.max(
      newCapacity,
      (prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2 : 1.125)) >>> 0
    );
    if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256);
    var oldContents = node.contents;
    node.contents = new Uint8Array(newCapacity);
    if (node.usedBytes > 0)
      node.contents.set(oldContents.subarray(0, node.usedBytes), 0);
    return;
  },
  resizeFileStorage: function(node, newSize) {
    if (node.usedBytes == newSize) return;
    if (newSize == 0) {
      node.contents = null;
      node.usedBytes = 0;
      return;
    }
    if (!node.contents || node.contents.subarray) {
      var oldContents = node.contents;
      node.contents = new Uint8Array(newSize);
      if (oldContents) {
        node.contents.set(
          oldContents.subarray(0, Math.min(newSize, node.usedBytes))
        );
      }
      node.usedBytes = newSize;
      return;
    }
    if (!node.contents) node.contents = [];
    if (node.contents.length > newSize) node.contents.length = newSize;
    else while (node.contents.length < newSize) node.contents.push(0);
    node.usedBytes = newSize;
  },
  node_ops: {
    getattr: function(node) {
      var attr = {};
      attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
      attr.ino = node.id;
      attr.mode = node.mode;
      attr.nlink = 1;
      attr.uid = 0;
      attr.gid = 0;
      attr.rdev = node.rdev;
      if (FS.isDir(node.mode)) {
        attr.size = 4096;
      } else if (FS.isFile(node.mode)) {
        attr.size = node.usedBytes;
      } else if (FS.isLink(node.mode)) {
        attr.size = node.link.length;
      } else {
        attr.size = 0;
      }
      attr.atime = new Date(node.timestamp);
      attr.mtime = new Date(node.timestamp);
      attr.ctime = new Date(node.timestamp);
      attr.blksize = 4096;
      attr.blocks = Math.ceil(attr.size / attr.blksize);
      return attr;
    },
    setattr: function(node, attr) {
      if (attr.mode !== undefined) {
        node.mode = attr.mode;
      }
      if (attr.timestamp !== undefined) {
        node.timestamp = attr.timestamp;
      }
      if (attr.size !== undefined) {
        MEMFS.resizeFileStorage(node, attr.size);
      }
    },
    lookup: function(parent, name) {
      throw FS.genericErrors[44];
    },
    mknod: function(parent, name, mode, dev) {
      return MEMFS.createNode(parent, name, mode, dev);
    },
    rename: function(old_node, new_dir, new_name) {
      if (FS.isDir(old_node.mode)) {
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {}
        if (new_node) {
          for (var i in new_node.contents) {
            throw new FS.ErrnoError(55);
          }
        }
      }
      delete old_node.parent.contents[old_node.name];
      old_node.name = new_name;
      new_dir.contents[new_name] = old_node;
      old_node.parent = new_dir;
    },
    unlink: function(parent, name) {
      delete parent.contents[name];
    },
    rmdir: function(parent, name) {
      var node = FS.lookupNode(parent, name);
      for (var i in node.contents) {
        throw new FS.ErrnoError(55);
      }
      delete parent.contents[name];
    },
    readdir: function(node) {
      var entries = [".", ".."];
      for (var key in node.contents) {
        if (!node.contents.hasOwnProperty(key)) {
          continue;
        }
        entries.push(key);
      }
      return entries;
    },
    symlink: function(parent, newname, oldpath) {
      var node = MEMFS.createNode(parent, newname, 511 | 40960, 0);
      node.link = oldpath;
      return node;
    },
    readlink: function(node) {
      if (!FS.isLink(node.mode)) {
        throw new FS.ErrnoError(28);
      }
      return node.link;
    }
  },
  stream_ops: {
    read: function(stream, buffer, offset, length, position) {
      var contents = stream.node.contents;
      if (position >= stream.node.usedBytes) return 0;
      var size = Math.min(stream.node.usedBytes - position, length);
      if (size > 8 && contents.subarray) {
        buffer.set(contents.subarray(position, position + size), offset);
      } else {
        for (var i = 0; i < size; i++)
          buffer[offset + i] = contents[position + i];
      }
      return size;
    },
    write: function(stream, buffer, offset, length, position, canOwn) {
      if (buffer.buffer === HEAP8.buffer) {
        canOwn = false;
      }
      if (!length) return 0;
      var node = stream.node;
      node.timestamp = Date.now();
      if (buffer.subarray && (!node.contents || node.contents.subarray)) {
        if (canOwn) {
          node.contents = buffer.subarray(offset, offset + length);
          node.usedBytes = length;
          return length;
        } else if (node.usedBytes === 0 && position === 0) {
          node.contents = buffer.slice(offset, offset + length);
          node.usedBytes = length;
          return length;
        } else if (position + length <= node.usedBytes) {
          node.contents.set(buffer.subarray(offset, offset + length), position);
          return length;
        }
      }
      MEMFS.expandFileStorage(node, position + length);
      if (node.contents.subarray && buffer.subarray) {
        node.contents.set(buffer.subarray(offset, offset + length), position);
      } else {
        for (var i = 0; i < length; i++) {
          node.contents[position + i] = buffer[offset + i];
        }
      }
      node.usedBytes = Math.max(node.usedBytes, position + length);
      return length;
    },
    llseek: function(stream, offset, whence) {
      var position = offset;
      if (whence === 1) {
        position += stream.position;
      } else if (whence === 2) {
        if (FS.isFile(stream.node.mode)) {
          position += stream.node.usedBytes;
        }
      }
      if (position < 0) {
        throw new FS.ErrnoError(28);
      }
      return position;
    },
    allocate: function(stream, offset, length) {
      MEMFS.expandFileStorage(stream.node, offset + length);
      stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
    },
    mmap: function(stream, address, length, position, prot, flags) {
      assert(address === 0);
      if (!FS.isFile(stream.node.mode)) {
        throw new FS.ErrnoError(43);
      }
      var ptr;
      var allocated;
      var contents = stream.node.contents;
      if (!(flags & 2) && contents.buffer === buffer) {
        allocated = false;
        ptr = contents.byteOffset;
      } else {
        if (position > 0 || position + length < contents.length) {
          if (contents.subarray) {
            contents = contents.subarray(position, position + length);
          } else {
            contents = Array.prototype.slice.call(
              contents,
              position,
              position + length
            );
          }
        }
        allocated = true;
        ptr = FS.mmapAlloc(length);
        if (!ptr) {
          throw new FS.ErrnoError(48);
        }
        HEAP8.set(contents, ptr);
      }
      return { ptr: ptr, allocated: allocated };
    },
    msync: function(stream, buffer, offset, length, mmapFlags) {
      if (!FS.isFile(stream.node.mode)) {
        throw new FS.ErrnoError(43);
      }
      if (mmapFlags & 2) {
        return 0;
      }
      var bytesWritten = MEMFS.stream_ops.write(
        stream,
        buffer,
        0,
        length,
        offset,
        false
      );
      return 0;
    }
  }
};
var ERRNO_CODES = {
  EPERM: 63,
  ENOENT: 44,
  ESRCH: 71,
  EINTR: 27,
  EIO: 29,
  ENXIO: 60,
  E2BIG: 1,
  ENOEXEC: 45,
  EBADF: 8,
  ECHILD: 12,
  EAGAIN: 6,
  EWOULDBLOCK: 6,
  ENOMEM: 48,
  EACCES: 2,
  EFAULT: 21,
  ENOTBLK: 105,
  EBUSY: 10,
  EEXIST: 20,
  EXDEV: 75,
  ENODEV: 43,
  ENOTDIR: 54,
  EISDIR: 31,
  EINVAL: 28,
  ENFILE: 41,
  EMFILE: 33,
  ENOTTY: 59,
  ETXTBSY: 74,
  EFBIG: 22,
  ENOSPC: 51,
  ESPIPE: 70,
  EROFS: 69,
  EMLINK: 34,
  EPIPE: 64,
  EDOM: 18,
  ERANGE: 68,
  ENOMSG: 49,
  EIDRM: 24,
  ECHRNG: 106,
  EL2NSYNC: 156,
  EL3HLT: 107,
  EL3RST: 108,
  ELNRNG: 109,
  EUNATCH: 110,
  ENOCSI: 111,
  EL2HLT: 112,
  EDEADLK: 16,
  ENOLCK: 46,
  EBADE: 113,
  EBADR: 114,
  EXFULL: 115,
  ENOANO: 104,
  EBADRQC: 103,
  EBADSLT: 102,
  EDEADLOCK: 16,
  EBFONT: 101,
  ENOSTR: 100,
  ENODATA: 116,
  ETIME: 117,
  ENOSR: 118,
  ENONET: 119,
  ENOPKG: 120,
  EREMOTE: 121,
  ENOLINK: 47,
  EADV: 122,
  ESRMNT: 123,
  ECOMM: 124,
  EPROTO: 65,
  EMULTIHOP: 36,
  EDOTDOT: 125,
  EBADMSG: 9,
  ENOTUNIQ: 126,
  EBADFD: 127,
  EREMCHG: 128,
  ELIBACC: 129,
  ELIBBAD: 130,
  ELIBSCN: 131,
  ELIBMAX: 132,
  ELIBEXEC: 133,
  ENOSYS: 52,
  ENOTEMPTY: 55,
  ENAMETOOLONG: 37,
  ELOOP: 32,
  EOPNOTSUPP: 138,
  EPFNOSUPPORT: 139,
  ECONNRESET: 15,
  ENOBUFS: 42,
  EAFNOSUPPORT: 5,
  EPROTOTYPE: 67,
  ENOTSOCK: 57,
  ENOPROTOOPT: 50,
  ESHUTDOWN: 140,
  ECONNREFUSED: 14,
  EADDRINUSE: 3,
  ECONNABORTED: 13,
  ENETUNREACH: 40,
  ENETDOWN: 38,
  ETIMEDOUT: 73,
  EHOSTDOWN: 142,
  EHOSTUNREACH: 23,
  EINPROGRESS: 26,
  EALREADY: 7,
  EDESTADDRREQ: 17,
  EMSGSIZE: 35,
  EPROTONOSUPPORT: 66,
  ESOCKTNOSUPPORT: 137,
  EADDRNOTAVAIL: 4,
  ENETRESET: 39,
  EISCONN: 30,
  ENOTCONN: 53,
  ETOOMANYREFS: 141,
  EUSERS: 136,
  EDQUOT: 19,
  ESTALE: 72,
  ENOTSUP: 138,
  ENOMEDIUM: 148,
  EILSEQ: 25,
  EOVERFLOW: 61,
  ECANCELED: 11,
  ENOTRECOVERABLE: 56,
  EOWNERDEAD: 62,
  ESTRPIPE: 135
};
var NODEFS = {
  isWindows: false,
  staticInit: function() {
    NODEFS.isWindows = !!process.platform.match(/^win/);
    var flags = { fs: fs.constants };
    if (flags["fs"]) {
      flags = flags["fs"];
    }
    NODEFS.flagsForNodeMap = {
      1024: flags["O_APPEND"],
      64: flags["O_CREAT"],
      128: flags["O_EXCL"],
      0: flags["O_RDONLY"],
      2: flags["O_RDWR"],
      4096: flags["O_SYNC"],
      512: flags["O_TRUNC"],
      1: flags["O_WRONLY"]
    };
  },
  bufferFrom: function(arrayBuffer) {
    return Buffer["alloc"] ? Buffer.from(arrayBuffer) : new Buffer(arrayBuffer);
  },
  convertNodeCode: function(e) {
    var code = e.code;
    return ERRNO_CODES[code];
  },
  mount: function(mount) {
    return NODEFS.createNode(null, "/", NODEFS.getMode(mount.opts.root), 0);
  },
  createNode: function(parent, name, mode, dev) {
    if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
      throw new FS.ErrnoError(28);
    }
    var node = FS.createNode(parent, name, mode);
    node.node_ops = NODEFS.node_ops;
    node.stream_ops = NODEFS.stream_ops;
    return node;
  },
  getMode: function(path) {
    var stat;
    try {
      stat = fs.lstatSync(path);
      if (NODEFS.isWindows) {
        stat.mode = stat.mode | ((stat.mode & 292) >> 2);
      }
    } catch (e) {
      if (!e.code) throw e;
      throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
    }
    return stat.mode;
  },
  realPath: function(node) {
    var parts = [];
    while (node.parent !== node) {
      parts.push(node.name);
      node = node.parent;
    }
    parts.push(node.mount.opts.root);
    parts.reverse();
    return PATH.join.apply(null, parts);
  },
  flagsForNode: function(flags) {
    flags &= ~2097152;
    flags &= ~2048;
    flags &= ~32768;
    flags &= ~524288;
    var newFlags = 0;
    for (var k in NODEFS.flagsForNodeMap) {
      if (flags & k) {
        newFlags |= NODEFS.flagsForNodeMap[k];
        flags ^= k;
      }
    }
    if (!flags) {
      return newFlags;
    } else {
      throw new FS.ErrnoError(28);
    }
  },
  node_ops: {
    getattr: function(node) {
      var path = NODEFS.realPath(node);
      var stat;
      try {
        stat = fs.lstatSync(path);
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
      if (NODEFS.isWindows && !stat.blksize) {
        stat.blksize = 4096;
      }
      if (NODEFS.isWindows && !stat.blocks) {
        stat.blocks = ((stat.size + stat.blksize - 1) / stat.blksize) | 0;
      }
      return {
        dev: stat.dev,
        ino: stat.ino,
        mode: stat.mode,
        nlink: stat.nlink,
        uid: stat.uid,
        gid: stat.gid,
        rdev: stat.rdev,
        size: stat.size,
        atime: stat.atime,
        mtime: stat.mtime,
        ctime: stat.ctime,
        blksize: stat.blksize,
        blocks: stat.blocks
      };
    },
    setattr: function(node, attr) {
      var path = NODEFS.realPath(node);
      try {
        if (attr.mode !== undefined) {
          fs.chmodSync(path, attr.mode);
          node.mode = attr.mode;
        }
        if (attr.timestamp !== undefined) {
          var date = new Date(attr.timestamp);
          fs.utimesSync(path, date, date);
        }
        if (attr.size !== undefined) {
          fs.truncateSync(path, attr.size);
        }
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    },
    lookup: function(parent, name) {
      var path = PATH.join2(NODEFS.realPath(parent), name);
      var mode = NODEFS.getMode(path);
      return NODEFS.createNode(parent, name, mode);
    },
    mknod: function(parent, name, mode, dev) {
      var node = NODEFS.createNode(parent, name, mode, dev);
      var path = NODEFS.realPath(node);
      try {
        if (FS.isDir(node.mode)) {
          fs.mkdirSync(path, node.mode);
        } else {
          fs.writeFileSync(path, "", { mode: node.mode });
        }
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
      return node;
    },
    rename: function(oldNode, newDir, newName) {
      var oldPath = NODEFS.realPath(oldNode);
      var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
      try {
        fs.renameSync(oldPath, newPath);
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
      oldNode.name = newName;
    },
    unlink: function(parent, name) {
      var path = PATH.join2(NODEFS.realPath(parent), name);
      try {
        fs.unlinkSync(path);
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    },
    rmdir: function(parent, name) {
      var path = PATH.join2(NODEFS.realPath(parent), name);
      try {
        fs.rmdirSync(path);
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    },
    readdir: function(node) {
      var path = NODEFS.realPath(node);
      try {
        return fs.readdirSync(path);
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    },
    symlink: function(parent, newName, oldPath) {
      var newPath = PATH.join2(NODEFS.realPath(parent), newName);
      try {
        fs.symlinkSync(oldPath, newPath);
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    },
    readlink: function(node) {
      var path = NODEFS.realPath(node);
      try {
        path = fs.readlinkSync(path);
        path = NODEJS_PATH.relative(
          NODEJS_PATH.resolve(node.mount.opts.root),
          path
        );
        return path;
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    }
  },
  stream_ops: {
    open: function(stream) {
      var path = NODEFS.realPath(stream.node);
      try {
        if (FS.isFile(stream.node.mode)) {
          stream.nfd = fs.openSync(path, NODEFS.flagsForNode(stream.flags));
        }
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    },
    close: function(stream) {
      try {
        if (FS.isFile(stream.node.mode) && stream.nfd) {
          fs.closeSync(stream.nfd);
        }
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    },
    read: function(stream, buffer, offset, length, position) {
      if (length === 0) return 0;
      try {
        return fs.readSync(
          stream.nfd,
          NODEFS.bufferFrom(buffer.buffer),
          offset,
          length,
          position
        );
      } catch (e) {
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    },
    write: function(stream, buffer, offset, length, position) {
      try {
        return fs.writeSync(
          stream.nfd,
          NODEFS.bufferFrom(buffer.buffer),
          offset,
          length,
          position
        );
      } catch (e) {
        throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
      }
    },
    llseek: function(stream, offset, whence) {
      var position = offset;
      if (whence === 1) {
        position += stream.position;
      } else if (whence === 2) {
        if (FS.isFile(stream.node.mode)) {
          try {
            var stat = fs.fstatSync(stream.nfd);
            position += stat.size;
          } catch (e) {
            throw new FS.ErrnoError(NODEFS.convertNodeCode(e));
          }
        }
      }
      if (position < 0) {
        throw new FS.ErrnoError(28);
      }
      return position;
    },
    mmap: function(stream, address, length, position, prot, flags) {
      assert(address === 0);
      if (!FS.isFile(stream.node.mode)) {
        throw new FS.ErrnoError(43);
      }
      var ptr = FS.mmapAlloc(length);
      NODEFS.stream_ops.read(stream, HEAP8, ptr, length, position);
      return { ptr: ptr, allocated: true };
    },
    msync: function(stream, buffer, offset, length, mmapFlags) {
      if (!FS.isFile(stream.node.mode)) {
        throw new FS.ErrnoError(43);
      }
      if (mmapFlags & 2) {
        return 0;
      }
      var bytesWritten = NODEFS.stream_ops.write(
        stream,
        buffer,
        0,
        length,
        offset,
        false
      );
      return 0;
    }
  }
};
var NODERAWFS = {
  lookupPath: function(path) {
    return { path: path, node: { mode: NODEFS.getMode(path) } };
  },
  createStandardStreams: function() {
    FS.streams[0] = {
      fd: 0,
      nfd: 0,
      position: 0,
      path: "",
      flags: 0,
      tty: true,
      seekable: false
    };
    for (var i = 1; i < 3; i++) {
      FS.streams[i] = {
        fd: i,
        nfd: i,
        position: 0,
        path: "",
        flags: 577,
        tty: true,
        seekable: false
      };
    }
  },
  cwd: function() {
    return process.cwd();
  },
  chdir: function() {
    process.chdir.apply(void 0, arguments);
  },
  mknod: function(path, mode) {
    if (FS.isDir(path)) {
      fs.mkdirSync(path, mode);
    } else {
      fs.writeFileSync(path, "", { mode: mode });
    }
  },
  mkdir: function() {
    fs.mkdirSync.apply(void 0, arguments);
  },
  symlink: function() {
    fs.symlinkSync.apply(void 0, arguments);
  },
  rename: function() {
    fs.renameSync.apply(void 0, arguments);
  },
  rmdir: function() {
    fs.rmdirSync.apply(void 0, arguments);
  },
  readdir: function() {
    fs.readdirSync.apply(void 0, arguments);
  },
  unlink: function() {
    fs.unlinkSync.apply(void 0, arguments);
  },
  readlink: function() {
    return fs.readlinkSync.apply(void 0, arguments);
  },
  stat: function() {
    return fs.statSync.apply(void 0, arguments);
  },
  lstat: function() {
    return fs.lstatSync.apply(void 0, arguments);
  },
  chmod: function() {
    fs.chmodSync.apply(void 0, arguments);
  },
  fchmod: function() {
    fs.fchmodSync.apply(void 0, arguments);
  },
  chown: function() {
    fs.chownSync.apply(void 0, arguments);
  },
  fchown: function() {
    fs.fchownSync.apply(void 0, arguments);
  },
  truncate: function() {
    fs.truncateSync.apply(void 0, arguments);
  },
  ftruncate: function() {
    fs.ftruncateSync.apply(void 0, arguments);
  },
  utime: function() {
    fs.utimesSync.apply(void 0, arguments);
  },
  open: function(path, flags, mode, suggestFD) {
    if (typeof flags === "string") {
      flags = VFS.modeStringToFlags(flags);
    }
    var nfd = fs.openSync(path, NODEFS.flagsForNode(flags), mode);
    var fd = suggestFD != null ? suggestFD : FS.nextfd(nfd);
    var stream = {
      fd: fd,
      nfd: nfd,
      position: 0,
      path: path,
      flags: flags,
      seekable: true
    };
    FS.streams[fd] = stream;
    return stream;
  },
  close: function(stream) {
    if (!stream.stream_ops) {
      fs.closeSync(stream.nfd);
    }
    FS.closeStream(stream.fd);
  },
  llseek: function(stream, offset, whence) {
    if (stream.stream_ops) {
      return VFS.llseek(stream, offset, whence);
    }
    var position = offset;
    if (whence === 1) {
      position += stream.position;
    } else if (whence === 2) {
      position += fs.fstatSync(stream.nfd).size;
    } else if (whence !== 0) {
      throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
    }
    if (position < 0) {
      throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
    }
    stream.position = position;
    return position;
  },
  read: function(stream, buffer, offset, length, position) {
    if (stream.stream_ops) {
      return VFS.read(stream, buffer, offset, length, position);
    }
    var seeking = typeof position !== "undefined";
    if (!seeking && stream.seekable) position = stream.position;
    var bytesRead = fs.readSync(
      stream.nfd,
      NODEFS.bufferFrom(buffer.buffer),
      offset,
      length,
      position
    );
    if (!seeking) stream.position += bytesRead;
    return bytesRead;
  },
  write: function(stream, buffer, offset, length, position) {
    if (stream.stream_ops) {
      return VFS.write(stream, buffer, offset, length, position);
    }
    if (stream.flags & +"1024") {
      FS.llseek(stream, 0, +"2");
    }
    var seeking = typeof position !== "undefined";
    if (!seeking && stream.seekable) position = stream.position;
    var bytesWritten = fs.writeSync(
      stream.nfd,
      NODEFS.bufferFrom(buffer.buffer),
      offset,
      length,
      position
    );
    if (!seeking) stream.position += bytesWritten;
    return bytesWritten;
  },
  allocate: function() {
    throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
  },
  mmap: function() {
    throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
  },
  msync: function() {
    return 0;
  },
  munmap: function() {
    return 0;
  },
  ioctl: function() {
    throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
  }
};
var FS = {
  root: null,
  mounts: [],
  devices: {},
  streams: [],
  nextInode: 1,
  nameTable: null,
  currentPath: "/",
  initialized: false,
  ignorePermissions: true,
  trackingDelegate: {},
  tracking: { openFlags: { READ: 1, WRITE: 2 } },
  ErrnoError: null,
  genericErrors: {},
  filesystems: null,
  syncFSRequests: 0,
  handleFSError: function(e) {
    if (!(e instanceof FS.ErrnoError)) throw e + " : " + stackTrace();
    return setErrNo(e.errno);
  },
  lookupPath: function(path, opts) {
    path = PATH_FS.resolve(FS.cwd(), path);
    opts = opts || {};
    if (!path) return { path: "", node: null };
    var defaults = { follow_mount: true, recurse_count: 0 };
    for (var key in defaults) {
      if (opts[key] === undefined) {
        opts[key] = defaults[key];
      }
    }
    if (opts.recurse_count > 8) {
      throw new FS.ErrnoError(32);
    }
    var parts = PATH.normalizeArray(
      path.split("/").filter(function(p) {
        return !!p;
      }),
      false
    );
    var current = FS.root;
    var current_path = "/";
    for (var i = 0; i < parts.length; i++) {
      var islast = i === parts.length - 1;
      if (islast && opts.parent) {
        break;
      }
      current = FS.lookupNode(current, parts[i]);
      current_path = PATH.join2(current_path, parts[i]);
      if (FS.isMountpoint(current)) {
        if (!islast || (islast && opts.follow_mount)) {
          current = current.mounted.root;
        }
      }
      if (!islast || opts.follow) {
        var count = 0;
        while (FS.isLink(current.mode)) {
          var link = FS.readlink(current_path);
          current_path = PATH_FS.resolve(PATH.dirname(current_path), link);
          var lookup = FS.lookupPath(current_path, {
            recurse_count: opts.recurse_count
          });
          current = lookup.node;
          if (count++ > 40) {
            throw new FS.ErrnoError(32);
          }
        }
      }
    }
    return { path: current_path, node: current };
  },
  getPath: function(node) {
    var path;
    while (true) {
      if (FS.isRoot(node)) {
        var mount = node.mount.mountpoint;
        if (!path) return mount;
        return mount[mount.length - 1] !== "/"
          ? mount + "/" + path
          : mount + path;
      }
      path = path ? node.name + "/" + path : node.name;
      node = node.parent;
    }
  },
  hashName: function(parentid, name) {
    var hash = 0;
    for (var i = 0; i < name.length; i++) {
      hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
    }
    return ((parentid + hash) >>> 0) % FS.nameTable.length;
  },
  hashAddNode: function(node) {
    var hash = FS.hashName(node.parent.id, node.name);
    node.name_next = FS.nameTable[hash];
    FS.nameTable[hash] = node;
  },
  hashRemoveNode: function(node) {
    var hash = FS.hashName(node.parent.id, node.name);
    if (FS.nameTable[hash] === node) {
      FS.nameTable[hash] = node.name_next;
    } else {
      var current = FS.nameTable[hash];
      while (current) {
        if (current.name_next === node) {
          current.name_next = node.name_next;
          break;
        }
        current = current.name_next;
      }
    }
  },
  lookupNode: function(parent, name) {
    var errCode = FS.mayLookup(parent);
    if (errCode) {
      throw new FS.ErrnoError(errCode, parent);
    }
    var hash = FS.hashName(parent.id, name);
    for (var node = FS.nameTable[hash]; node; node = node.name_next) {
      var nodeName = node.name;
      if (node.parent.id === parent.id && nodeName === name) {
        return node;
      }
    }
    return FS.lookup(parent, name);
  },
  createNode: function(parent, name, mode, rdev) {
    var node = new FS.FSNode(parent, name, mode, rdev);
    FS.hashAddNode(node);
    return node;
  },
  destroyNode: function(node) {
    FS.hashRemoveNode(node);
  },
  isRoot: function(node) {
    return node === node.parent;
  },
  isMountpoint: function(node) {
    return !!node.mounted;
  },
  isFile: function(mode) {
    return (mode & 61440) === 32768;
  },
  isDir: function(mode) {
    return (mode & 61440) === 16384;
  },
  isLink: function(mode) {
    return (mode & 61440) === 40960;
  },
  isChrdev: function(mode) {
    return (mode & 61440) === 8192;
  },
  isBlkdev: function(mode) {
    return (mode & 61440) === 24576;
  },
  isFIFO: function(mode) {
    return (mode & 61440) === 4096;
  },
  isSocket: function(mode) {
    return (mode & 49152) === 49152;
  },
  flagModes: {
    r: 0,
    rs: 1052672,
    "r+": 2,
    w: 577,
    wx: 705,
    xw: 705,
    "w+": 578,
    "wx+": 706,
    "xw+": 706,
    a: 1089,
    ax: 1217,
    xa: 1217,
    "a+": 1090,
    "ax+": 1218,
    "xa+": 1218
  },
  modeStringToFlags: function(str) {
    var flags = FS.flagModes[str];
    if (typeof flags === "undefined") {
      throw new Error("Unknown file open mode: " + str);
    }
    return flags;
  },
  flagsToPermissionString: function(flag) {
    var perms = ["r", "w", "rw"][flag & 3];
    if (flag & 512) {
      perms += "w";
    }
    return perms;
  },
  nodePermissions: function(node, perms) {
    if (FS.ignorePermissions) {
      return 0;
    }
    if (perms.indexOf("r") !== -1 && !(node.mode & 292)) {
      return 2;
    } else if (perms.indexOf("w") !== -1 && !(node.mode & 146)) {
      return 2;
    } else if (perms.indexOf("x") !== -1 && !(node.mode & 73)) {
      return 2;
    }
    return 0;
  },
  mayLookup: function(dir) {
    var errCode = FS.nodePermissions(dir, "x");
    if (errCode) return errCode;
    if (!dir.node_ops.lookup) return 2;
    return 0;
  },
  mayCreate: function(dir, name) {
    try {
      var node = FS.lookupNode(dir, name);
      return 20;
    } catch (e) {}
    return FS.nodePermissions(dir, "wx");
  },
  mayDelete: function(dir, name, isdir) {
    var node;
    try {
      node = FS.lookupNode(dir, name);
    } catch (e) {
      return e.errno;
    }
    var errCode = FS.nodePermissions(dir, "wx");
    if (errCode) {
      return errCode;
    }
    if (isdir) {
      if (!FS.isDir(node.mode)) {
        return 54;
      }
      if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
        return 10;
      }
    } else {
      if (FS.isDir(node.mode)) {
        return 31;
      }
    }
    return 0;
  },
  mayOpen: function(node, flags) {
    if (!node) {
      return 44;
    }
    if (FS.isLink(node.mode)) {
      return 32;
    } else if (FS.isDir(node.mode)) {
      if (FS.flagsToPermissionString(flags) !== "r" || flags & 512) {
        return 31;
      }
    }
    return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
  },
  MAX_OPEN_FDS: 4096,
  nextfd: function(fd_start, fd_end) {
    fd_start = fd_start || 0;
    fd_end = fd_end || FS.MAX_OPEN_FDS;
    for (var fd = fd_start; fd <= fd_end; fd++) {
      if (!FS.streams[fd]) {
        return fd;
      }
    }
    throw new FS.ErrnoError(33);
  },
  getStream: function(fd) {
    return FS.streams[fd];
  },
  createStream: function(stream, fd_start, fd_end) {
    if (!FS.FSStream) {
      FS.FSStream = function() {};
      FS.FSStream.prototype = {
        object: {
          get: function() {
            return this.node;
          },
          set: function(val) {
            this.node = val;
          }
        },
        isRead: {
          get: function() {
            return (this.flags & 2097155) !== 1;
          }
        },
        isWrite: {
          get: function() {
            return (this.flags & 2097155) !== 0;
          }
        },
        isAppend: {
          get: function() {
            return this.flags & 1024;
          }
        }
      };
    }
    var newStream = new FS.FSStream();
    for (var p in stream) {
      newStream[p] = stream[p];
    }
    stream = newStream;
    var fd = FS.nextfd(fd_start, fd_end);
    stream.fd = fd;
    FS.streams[fd] = stream;
    return stream;
  },
  closeStream: function(fd) {
    FS.streams[fd] = null;
  },
  chrdev_stream_ops: {
    open: function(stream) {
      var device = FS.getDevice(stream.node.rdev);
      stream.stream_ops = device.stream_ops;
      if (stream.stream_ops.open) {
        stream.stream_ops.open(stream);
      }
    },
    llseek: function() {
      throw new FS.ErrnoError(70);
    }
  },
  major: function(dev) {
    return dev >> 8;
  },
  minor: function(dev) {
    return dev & 255;
  },
  makedev: function(ma, mi) {
    return (ma << 8) | mi;
  },
  registerDevice: function(dev, ops) {
    FS.devices[dev] = { stream_ops: ops };
  },
  getDevice: function(dev) {
    return FS.devices[dev];
  },
  getMounts: function(mount) {
    var mounts = [];
    var check = [mount];
    while (check.length) {
      var m = check.pop();
      mounts.push(m);
      check.push.apply(check, m.mounts);
    }
    return mounts;
  },
  syncfs: function(populate, callback) {
    if (typeof populate === "function") {
      callback = populate;
      populate = false;
    }
    FS.syncFSRequests++;
    if (FS.syncFSRequests > 1) {
      err(
        "warning: " +
          FS.syncFSRequests +
          " FS.syncfs operations in flight at once, probably just doing extra work"
      );
    }
    var mounts = FS.getMounts(FS.root.mount);
    var completed = 0;
    function doCallback(errCode) {
      FS.syncFSRequests--;
      return callback(errCode);
    }
    function done(errCode) {
      if (errCode) {
        if (!done.errored) {
          done.errored = true;
          return doCallback(errCode);
        }
        return;
      }
      if (++completed >= mounts.length) {
        doCallback(null);
      }
    }
    mounts.forEach(function(mount) {
      if (!mount.type.syncfs) {
        return done(null);
      }
      mount.type.syncfs(mount, populate, done);
    });
  },
  mount: function(type, opts, mountpoint) {
    var root = mountpoint === "/";
    var pseudo = !mountpoint;
    var node;
    if (root && FS.root) {
      throw new FS.ErrnoError(10);
    } else if (!root && !pseudo) {
      var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
      mountpoint = lookup.path;
      node = lookup.node;
      if (FS.isMountpoint(node)) {
        throw new FS.ErrnoError(10);
      }
      if (!FS.isDir(node.mode)) {
        throw new FS.ErrnoError(54);
      }
    }
    var mount = { type: type, opts: opts, mountpoint: mountpoint, mounts: [] };
    var mountRoot = type.mount(mount);
    mountRoot.mount = mount;
    mount.root = mountRoot;
    if (root) {
      FS.root = mountRoot;
    } else if (node) {
      node.mounted = mount;
      if (node.mount) {
        node.mount.mounts.push(mount);
      }
    }
    return mountRoot;
  },
  unmount: function(mountpoint) {
    var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
    if (!FS.isMountpoint(lookup.node)) {
      throw new FS.ErrnoError(28);
    }
    var node = lookup.node;
    var mount = node.mounted;
    var mounts = FS.getMounts(mount);
    Object.keys(FS.nameTable).forEach(function(hash) {
      var current = FS.nameTable[hash];
      while (current) {
        var next = current.name_next;
        if (mounts.indexOf(current.mount) !== -1) {
          FS.destroyNode(current);
        }
        current = next;
      }
    });
    node.mounted = null;
    var idx = node.mount.mounts.indexOf(mount);
    node.mount.mounts.splice(idx, 1);
  },
  lookup: function(parent, name) {
    return parent.node_ops.lookup(parent, name);
  },
  mknod: function(path, mode, dev) {
    var lookup = FS.lookupPath(path, { parent: true });
    var parent = lookup.node;
    var name = PATH.basename(path);
    if (!name || name === "." || name === "..") {
      throw new FS.ErrnoError(28);
    }
    var errCode = FS.mayCreate(parent, name);
    if (errCode) {
      throw new FS.ErrnoError(errCode);
    }
    if (!parent.node_ops.mknod) {
      throw new FS.ErrnoError(63);
    }
    return parent.node_ops.mknod(parent, name, mode, dev);
  },
  create: function(path, mode) {
    mode = mode !== undefined ? mode : 438;
    mode &= 4095;
    mode |= 32768;
    return FS.mknod(path, mode, 0);
  },
  mkdir: function(path, mode) {
    mode = mode !== undefined ? mode : 511;
    mode &= 511 | 512;
    mode |= 16384;
    return FS.mknod(path, mode, 0);
  },
  mkdirTree: function(path, mode) {
    var dirs = path.split("/");
    var d = "";
    for (var i = 0; i < dirs.length; ++i) {
      if (!dirs[i]) continue;
      d += "/" + dirs[i];
      try {
        FS.mkdir(d, mode);
      } catch (e) {
        if (e.errno != 20) throw e;
      }
    }
  },
  mkdev: function(path, mode, dev) {
    if (typeof dev === "undefined") {
      dev = mode;
      mode = 438;
    }
    mode |= 8192;
    return FS.mknod(path, mode, dev);
  },
  symlink: function(oldpath, newpath) {
    if (!PATH_FS.resolve(oldpath)) {
      throw new FS.ErrnoError(44);
    }
    var lookup = FS.lookupPath(newpath, { parent: true });
    var parent = lookup.node;
    if (!parent) {
      throw new FS.ErrnoError(44);
    }
    var newname = PATH.basename(newpath);
    var errCode = FS.mayCreate(parent, newname);
    if (errCode) {
      throw new FS.ErrnoError(errCode);
    }
    if (!parent.node_ops.symlink) {
      throw new FS.ErrnoError(63);
    }
    return parent.node_ops.symlink(parent, newname, oldpath);
  },
  rename: function(old_path, new_path) {
    var old_dirname = PATH.dirname(old_path);
    var new_dirname = PATH.dirname(new_path);
    var old_name = PATH.basename(old_path);
    var new_name = PATH.basename(new_path);
    var lookup, old_dir, new_dir;
    lookup = FS.lookupPath(old_path, { parent: true });
    old_dir = lookup.node;
    lookup = FS.lookupPath(new_path, { parent: true });
    new_dir = lookup.node;
    if (!old_dir || !new_dir) throw new FS.ErrnoError(44);
    if (old_dir.mount !== new_dir.mount) {
      throw new FS.ErrnoError(75);
    }
    var old_node = FS.lookupNode(old_dir, old_name);
    var relative = PATH_FS.relative(old_path, new_dirname);
    if (relative.charAt(0) !== ".") {
      throw new FS.ErrnoError(28);
    }
    relative = PATH_FS.relative(new_path, old_dirname);
    if (relative.charAt(0) !== ".") {
      throw new FS.ErrnoError(55);
    }
    var new_node;
    try {
      new_node = FS.lookupNode(new_dir, new_name);
    } catch (e) {}
    if (old_node === new_node) {
      return;
    }
    var isdir = FS.isDir(old_node.mode);
    var errCode = FS.mayDelete(old_dir, old_name, isdir);
    if (errCode) {
      throw new FS.ErrnoError(errCode);
    }
    errCode = new_node
      ? FS.mayDelete(new_dir, new_name, isdir)
      : FS.mayCreate(new_dir, new_name);
    if (errCode) {
      throw new FS.ErrnoError(errCode);
    }
    if (!old_dir.node_ops.rename) {
      throw new FS.ErrnoError(63);
    }
    if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
      throw new FS.ErrnoError(10);
    }
    if (new_dir !== old_dir) {
      errCode = FS.nodePermissions(old_dir, "w");
      if (errCode) {
        throw new FS.ErrnoError(errCode);
      }
    }
    try {
      if (FS.trackingDelegate["willMovePath"]) {
        FS.trackingDelegate["willMovePath"](old_path, new_path);
      }
    } catch (e) {
      err(
        "FS.trackingDelegate['willMovePath']('" +
          old_path +
          "', '" +
          new_path +
          "') threw an exception: " +
          e.message
      );
    }
    FS.hashRemoveNode(old_node);
    try {
      old_dir.node_ops.rename(old_node, new_dir, new_name);
    } catch (e) {
      throw e;
    } finally {
      FS.hashAddNode(old_node);
    }
    try {
      if (FS.trackingDelegate["onMovePath"])
        FS.trackingDelegate["onMovePath"](old_path, new_path);
    } catch (e) {
      err(
        "FS.trackingDelegate['onMovePath']('" +
          old_path +
          "', '" +
          new_path +
          "') threw an exception: " +
          e.message
      );
    }
  },
  rmdir: function(path) {
    var lookup = FS.lookupPath(path, { parent: true });
    var parent = lookup.node;
    var name = PATH.basename(path);
    var node = FS.lookupNode(parent, name);
    var errCode = FS.mayDelete(parent, name, true);
    if (errCode) {
      throw new FS.ErrnoError(errCode);
    }
    if (!parent.node_ops.rmdir) {
      throw new FS.ErrnoError(63);
    }
    if (FS.isMountpoint(node)) {
      throw new FS.ErrnoError(10);
    }
    try {
      if (FS.trackingDelegate["willDeletePath"]) {
        FS.trackingDelegate["willDeletePath"](path);
      }
    } catch (e) {
      err(
        "FS.trackingDelegate['willDeletePath']('" +
          path +
          "') threw an exception: " +
          e.message
      );
    }
    parent.node_ops.rmdir(parent, name);
    FS.destroyNode(node);
    try {
      if (FS.trackingDelegate["onDeletePath"])
        FS.trackingDelegate["onDeletePath"](path);
    } catch (e) {
      err(
        "FS.trackingDelegate['onDeletePath']('" +
          path +
          "') threw an exception: " +
          e.message
      );
    }
  },
  readdir: function(path) {
    var lookup = FS.lookupPath(path, { follow: true });
    var node = lookup.node;
    if (!node.node_ops.readdir) {
      throw new FS.ErrnoError(54);
    }
    return node.node_ops.readdir(node);
  },
  unlink: function(path) {
    var lookup = FS.lookupPath(path, { parent: true });
    var parent = lookup.node;
    var name = PATH.basename(path);
    var node = FS.lookupNode(parent, name);
    var errCode = FS.mayDelete(parent, name, false);
    if (errCode) {
      throw new FS.ErrnoError(errCode);
    }
    if (!parent.node_ops.unlink) {
      throw new FS.ErrnoError(63);
    }
    if (FS.isMountpoint(node)) {
      throw new FS.ErrnoError(10);
    }
    try {
      if (FS.trackingDelegate["willDeletePath"]) {
        FS.trackingDelegate["willDeletePath"](path);
      }
    } catch (e) {
      err(
        "FS.trackingDelegate['willDeletePath']('" +
          path +
          "') threw an exception: " +
          e.message
      );
    }
    parent.node_ops.unlink(parent, name);
    FS.destroyNode(node);
    try {
      if (FS.trackingDelegate["onDeletePath"])
        FS.trackingDelegate["onDeletePath"](path);
    } catch (e) {
      err(
        "FS.trackingDelegate['onDeletePath']('" +
          path +
          "') threw an exception: " +
          e.message
      );
    }
  },
  readlink: function(path) {
    var lookup = FS.lookupPath(path);
    var link = lookup.node;
    if (!link) {
      throw new FS.ErrnoError(44);
    }
    if (!link.node_ops.readlink) {
      throw new FS.ErrnoError(28);
    }
    return PATH_FS.resolve(
      FS.getPath(link.parent),
      link.node_ops.readlink(link)
    );
  },
  stat: function(path, dontFollow) {
    var lookup = FS.lookupPath(path, { follow: !dontFollow });
    var node = lookup.node;
    if (!node) {
      throw new FS.ErrnoError(44);
    }
    if (!node.node_ops.getattr) {
      throw new FS.ErrnoError(63);
    }
    return node.node_ops.getattr(node);
  },
  lstat: function(path) {
    return FS.stat(path, true);
  },
  chmod: function(path, mode, dontFollow) {
    var node;
    if (typeof path === "string") {
      var lookup = FS.lookupPath(path, { follow: !dontFollow });
      node = lookup.node;
    } else {
      node = path;
    }
    if (!node.node_ops.setattr) {
      throw new FS.ErrnoError(63);
    }
    node.node_ops.setattr(node, {
      mode: (mode & 4095) | (node.mode & ~4095),
      timestamp: Date.now()
    });
  },
  lchmod: function(path, mode) {
    FS.chmod(path, mode, true);
  },
  fchmod: function(fd, mode) {
    var stream = FS.getStream(fd);
    if (!stream) {
      throw new FS.ErrnoError(8);
    }
    FS.chmod(stream.node, mode);
  },
  chown: function(path, uid, gid, dontFollow) {
    var node;
    if (typeof path === "string") {
      var lookup = FS.lookupPath(path, { follow: !dontFollow });
      node = lookup.node;
    } else {
      node = path;
    }
    if (!node.node_ops.setattr) {
      throw new FS.ErrnoError(63);
    }
    node.node_ops.setattr(node, { timestamp: Date.now() });
  },
  lchown: function(path, uid, gid) {
    FS.chown(path, uid, gid, true);
  },
  fchown: function(fd, uid, gid) {
    var stream = FS.getStream(fd);
    if (!stream) {
      throw new FS.ErrnoError(8);
    }
    FS.chown(stream.node, uid, gid);
  },
  truncate: function(path, len) {
    if (len < 0) {
      throw new FS.ErrnoError(28);
    }
    var node;
    if (typeof path === "string") {
      var lookup = FS.lookupPath(path, { follow: true });
      node = lookup.node;
    } else {
      node = path;
    }
    if (!node.node_ops.setattr) {
      throw new FS.ErrnoError(63);
    }
    if (FS.isDir(node.mode)) {
      throw new FS.ErrnoError(31);
    }
    if (!FS.isFile(node.mode)) {
      throw new FS.ErrnoError(28);
    }
    var errCode = FS.nodePermissions(node, "w");
    if (errCode) {
      throw new FS.ErrnoError(errCode);
    }
    node.node_ops.setattr(node, { size: len, timestamp: Date.now() });
  },
  ftruncate: function(fd, len) {
    var stream = FS.getStream(fd);
    if (!stream) {
      throw new FS.ErrnoError(8);
    }
    if ((stream.flags & 2097155) === 0) {
      throw new FS.ErrnoError(28);
    }
    FS.truncate(stream.node, len);
  },
  utime: function(path, atime, mtime) {
    var lookup = FS.lookupPath(path, { follow: true });
    var node = lookup.node;
    node.node_ops.setattr(node, { timestamp: Math.max(atime, mtime) });
  },
  open: function(path, flags, mode, fd_start, fd_end) {
    if (path === "") {
      throw new FS.ErrnoError(44);
    }
    flags = typeof flags === "string" ? FS.modeStringToFlags(flags) : flags;
    mode = typeof mode === "undefined" ? 438 : mode;
    if (flags & 64) {
      mode = (mode & 4095) | 32768;
    } else {
      mode = 0;
    }
    var node;
    if (typeof path === "object") {
      node = path;
    } else {
      path = PATH.normalize(path);
      try {
        var lookup = FS.lookupPath(path, { follow: !(flags & 131072) });
        node = lookup.node;
      } catch (e) {}
    }
    var created = false;
    if (flags & 64) {
      if (node) {
        if (flags & 128) {
          throw new FS.ErrnoError(20);
        }
      } else {
        node = FS.mknod(path, mode, 0);
        created = true;
      }
    }
    if (!node) {
      throw new FS.ErrnoError(44);
    }
    if (FS.isChrdev(node.mode)) {
      flags &= ~512;
    }
    if (flags & 65536 && !FS.isDir(node.mode)) {
      throw new FS.ErrnoError(54);
    }
    if (!created) {
      var errCode = FS.mayOpen(node, flags);
      if (errCode) {
        throw new FS.ErrnoError(errCode);
      }
    }
    if (flags & 512) {
      FS.truncate(node, 0);
    }
    flags &= ~(128 | 512 | 131072);
    var stream = FS.createStream(
      {
        node: node,
        path: FS.getPath(node),
        flags: flags,
        seekable: true,
        position: 0,
        stream_ops: node.stream_ops,
        ungotten: [],
        error: false
      },
      fd_start,
      fd_end
    );
    if (stream.stream_ops.open) {
      stream.stream_ops.open(stream);
    }
    if (Module["logReadFiles"] && !(flags & 1)) {
      if (!FS.readFiles) FS.readFiles = {};
      if (!(path in FS.readFiles)) {
        FS.readFiles[path] = 1;
        err("FS.trackingDelegate error on read file: " + path);
      }
    }
    try {
      if (FS.trackingDelegate["onOpenFile"]) {
        var trackingFlags = 0;
        if ((flags & 2097155) !== 1) {
          trackingFlags |= FS.tracking.openFlags.READ;
        }
        if ((flags & 2097155) !== 0) {
          trackingFlags |= FS.tracking.openFlags.WRITE;
        }
        FS.trackingDelegate["onOpenFile"](path, trackingFlags);
      }
    } catch (e) {
      err(
        "FS.trackingDelegate['onOpenFile']('" +
          path +
          "', flags) threw an exception: " +
          e.message
      );
    }
    return stream;
  },
  close: function(stream) {
    if (FS.isClosed(stream)) {
      throw new FS.ErrnoError(8);
    }
    if (stream.getdents) stream.getdents = null;
    try {
      if (stream.stream_ops.close) {
        stream.stream_ops.close(stream);
      }
    } catch (e) {
      throw e;
    } finally {
      FS.closeStream(stream.fd);
    }
    stream.fd = null;
  },
  isClosed: function(stream) {
    return stream.fd === null;
  },
  llseek: function(stream, offset, whence) {
    if (FS.isClosed(stream)) {
      throw new FS.ErrnoError(8);
    }
    if (!stream.seekable || !stream.stream_ops.llseek) {
      throw new FS.ErrnoError(70);
    }
    if (whence != 0 && whence != 1 && whence != 2) {
      throw new FS.ErrnoError(28);
    }
    stream.position = stream.stream_ops.llseek(stream, offset, whence);
    stream.ungotten = [];
    return stream.position;
  },
  read: function(stream, buffer, offset, length, position) {
    if (length < 0 || position < 0) {
      throw new FS.ErrnoError(28);
    }
    if (FS.isClosed(stream)) {
      throw new FS.ErrnoError(8);
    }
    if ((stream.flags & 2097155) === 1) {
      throw new FS.ErrnoError(8);
    }
    if (FS.isDir(stream.node.mode)) {
      throw new FS.ErrnoError(31);
    }
    if (!stream.stream_ops.read) {
      throw new FS.ErrnoError(28);
    }
    var seeking = typeof position !== "undefined";
    if (!seeking) {
      position = stream.position;
    } else if (!stream.seekable) {
      throw new FS.ErrnoError(70);
    }
    var bytesRead = stream.stream_ops.read(
      stream,
      buffer,
      offset,
      length,
      position
    );
    if (!seeking) stream.position += bytesRead;
    return bytesRead;
  },
  write: function(stream, buffer, offset, length, position, canOwn) {
    if (length < 0 || position < 0) {
      throw new FS.ErrnoError(28);
    }
    if (FS.isClosed(stream)) {
      throw new FS.ErrnoError(8);
    }
    if ((stream.flags & 2097155) === 0) {
      throw new FS.ErrnoError(8);
    }
    if (FS.isDir(stream.node.mode)) {
      throw new FS.ErrnoError(31);
    }
    if (!stream.stream_ops.write) {
      throw new FS.ErrnoError(28);
    }
    if (stream.seekable && stream.flags & 1024) {
      FS.llseek(stream, 0, 2);
    }
    var seeking = typeof position !== "undefined";
    if (!seeking) {
      position = stream.position;
    } else if (!stream.seekable) {
      throw new FS.ErrnoError(70);
    }
    var bytesWritten = stream.stream_ops.write(
      stream,
      buffer,
      offset,
      length,
      position,
      canOwn
    );
    if (!seeking) stream.position += bytesWritten;
    try {
      if (stream.path && FS.trackingDelegate["onWriteToFile"])
        FS.trackingDelegate["onWriteToFile"](stream.path);
    } catch (e) {
      err(
        "FS.trackingDelegate['onWriteToFile']('" +
          stream.path +
          "') threw an exception: " +
          e.message
      );
    }
    return bytesWritten;
  },
  allocate: function(stream, offset, length) {
    if (FS.isClosed(stream)) {
      throw new FS.ErrnoError(8);
    }
    if (offset < 0 || length <= 0) {
      throw new FS.ErrnoError(28);
    }
    if ((stream.flags & 2097155) === 0) {
      throw new FS.ErrnoError(8);
    }
    if (!FS.isFile(stream.node.mode) && !FS.isDir(stream.node.mode)) {
      throw new FS.ErrnoError(43);
    }
    if (!stream.stream_ops.allocate) {
      throw new FS.ErrnoError(138);
    }
    stream.stream_ops.allocate(stream, offset, length);
  },
  mmap: function(stream, address, length, position, prot, flags) {
    if (
      (prot & 2) !== 0 &&
      (flags & 2) === 0 &&
      (stream.flags & 2097155) !== 2
    ) {
      throw new FS.ErrnoError(2);
    }
    if ((stream.flags & 2097155) === 1) {
      throw new FS.ErrnoError(2);
    }
    if (!stream.stream_ops.mmap) {
      throw new FS.ErrnoError(43);
    }
    return stream.stream_ops.mmap(
      stream,
      address,
      length,
      position,
      prot,
      flags
    );
  },
  msync: function(stream, buffer, offset, length, mmapFlags) {
    if (!stream || !stream.stream_ops.msync) {
      return 0;
    }
    return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
  },
  munmap: function(stream) {
    return 0;
  },
  ioctl: function(stream, cmd, arg) {
    if (!stream.stream_ops.ioctl) {
      throw new FS.ErrnoError(59);
    }
    return stream.stream_ops.ioctl(stream, cmd, arg);
  },
  readFile: function(path, opts) {
    opts = opts || {};
    opts.flags = opts.flags || "r";
    opts.encoding = opts.encoding || "binary";
    if (opts.encoding !== "utf8" && opts.encoding !== "binary") {
      throw new Error('Invalid encoding type "' + opts.encoding + '"');
    }
    var ret;
    var stream = FS.open(path, opts.flags);
    var stat = FS.stat(path);
    var length = stat.size;
    var buf = new Uint8Array(length);
    FS.read(stream, buf, 0, length, 0);
    if (opts.encoding === "utf8") {
      ret = UTF8ArrayToString(buf, 0);
    } else if (opts.encoding === "binary") {
      ret = buf;
    }
    FS.close(stream);
    return ret;
  },
  writeFile: function(path, data, opts) {
    opts = opts || {};
    opts.flags = opts.flags || "w";
    var stream = FS.open(path, opts.flags, opts.mode);
    if (typeof data === "string") {
      var buf = new Uint8Array(lengthBytesUTF8(data) + 1);
      var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
      FS.write(stream, buf, 0, actualNumBytes, undefined, opts.canOwn);
    } else if (ArrayBuffer.isView(data)) {
      FS.write(stream, data, 0, data.byteLength, undefined, opts.canOwn);
    } else {
      throw new Error("Unsupported data type");
    }
    FS.close(stream);
  },
  cwd: function() {
    return FS.currentPath;
  },
  chdir: function(path) {
    var lookup = FS.lookupPath(path, { follow: true });
    if (lookup.node === null) {
      throw new FS.ErrnoError(44);
    }
    if (!FS.isDir(lookup.node.mode)) {
      throw new FS.ErrnoError(54);
    }
    var errCode = FS.nodePermissions(lookup.node, "x");
    if (errCode) {
      throw new FS.ErrnoError(errCode);
    }
    FS.currentPath = lookup.path;
  },
  createDefaultDirectories: function() {
    FS.mkdir("/tmp");
    FS.mkdir("/home");
    FS.mkdir("/home/web_user");
  },
  createDefaultDevices: function() {
    FS.mkdir("/dev");
    FS.registerDevice(FS.makedev(1, 3), {
      read: function() {
        return 0;
      },
      write: function(stream, buffer, offset, length, pos) {
        return length;
      }
    });
    FS.mkdev("/dev/null", FS.makedev(1, 3));
    TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
    TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
    FS.mkdev("/dev/tty", FS.makedev(5, 0));
    FS.mkdev("/dev/tty1", FS.makedev(6, 0));
    var random_device;
    if (
      typeof crypto === "object" &&
      typeof crypto["getRandomValues"] === "function"
    ) {
      var randomBuffer = new Uint8Array(1);
      random_device = function() {
        crypto.getRandomValues(randomBuffer);
        return randomBuffer[0];
      };
    } else if (ENVIRONMENT_IS_NODE) {
      try {
        var crypto_module = __webpack_require__(417);
        random_device = function() {
          return crypto_module["randomBytes"](1)[0];
        };
      } catch (e) {}
    } else {
    }
    if (!random_device) {
      random_device = function() {
        abort("random_device");
      };
    }
    FS.createDevice("/dev", "random", random_device);
    FS.createDevice("/dev", "urandom", random_device);
    FS.mkdir("/dev/shm");
    FS.mkdir("/dev/shm/tmp");
  },
  createSpecialDirectories: function() {
    FS.mkdir("/proc");
    FS.mkdir("/proc/self");
    FS.mkdir("/proc/self/fd");
    FS.mount(
      {
        mount: function() {
          var node = FS.createNode("/proc/self", "fd", 16384 | 511, 73);
          node.node_ops = {
            lookup: function(parent, name) {
              var fd = +name;
              var stream = FS.getStream(fd);
              if (!stream) throw new FS.ErrnoError(8);
              var ret = {
                parent: null,
                mount: { mountpoint: "fake" },
                node_ops: {
                  readlink: function() {
                    return stream.path;
                  }
                }
              };
              ret.parent = ret;
              return ret;
            }
          };
          return node;
        }
      },
      {},
      "/proc/self/fd"
    );
  },
  createStandardStreams: function() {
    if (Module["stdin"]) {
      FS.createDevice("/dev", "stdin", Module["stdin"]);
    } else {
      FS.symlink("/dev/tty", "/dev/stdin");
    }
    if (Module["stdout"]) {
      FS.createDevice("/dev", "stdout", null, Module["stdout"]);
    } else {
      FS.symlink("/dev/tty", "/dev/stdout");
    }
    if (Module["stderr"]) {
      FS.createDevice("/dev", "stderr", null, Module["stderr"]);
    } else {
      FS.symlink("/dev/tty1", "/dev/stderr");
    }
    var stdin = FS.open("/dev/stdin", "r");
    var stdout = FS.open("/dev/stdout", "w");
    var stderr = FS.open("/dev/stderr", "w");
  },
  ensureErrnoError: function() {
    if (FS.ErrnoError) return;
    FS.ErrnoError = function ErrnoError(errno, node) {
      this.node = node;
      this.setErrno = function(errno) {
        this.errno = errno;
      };
      this.setErrno(errno);
      this.message = "FS error";
    };
    FS.ErrnoError.prototype = new Error();
    FS.ErrnoError.prototype.constructor = FS.ErrnoError;
    [44].forEach(function(code) {
      FS.genericErrors[code] = new FS.ErrnoError(code);
      FS.genericErrors[code].stack = "<generic error, no stack>";
    });
  },
  staticInit: function() {
    FS.ensureErrnoError();
    FS.nameTable = new Array(4096);
    FS.mount(MEMFS, {}, "/");
    FS.createDefaultDirectories();
    FS.createDefaultDevices();
    FS.createSpecialDirectories();
    FS.filesystems = { MEMFS: MEMFS, NODEFS: NODEFS };
  },
  init: function(input, output, error) {
    FS.init.initialized = true;
    FS.ensureErrnoError();
    Module["stdin"] = input || Module["stdin"];
    Module["stdout"] = output || Module["stdout"];
    Module["stderr"] = error || Module["stderr"];
    FS.createStandardStreams();
  },
  quit: function() {
    FS.init.initialized = false;
    var fflush = Module["_fflush"];
    if (fflush) fflush(0);
    for (var i = 0; i < FS.streams.length; i++) {
      var stream = FS.streams[i];
      if (!stream) {
        continue;
      }
      FS.close(stream);
    }
  },
  getMode: function(canRead, canWrite) {
    var mode = 0;
    if (canRead) mode |= 292 | 73;
    if (canWrite) mode |= 146;
    return mode;
  },
  joinPath: function(parts, forceRelative) {
    var path = PATH.join.apply(null, parts);
    if (forceRelative && path[0] == "/") path = path.slice(1);
    return path;
  },
  absolutePath: function(relative, base) {
    return PATH_FS.resolve(base, relative);
  },
  standardizePath: function(path) {
    return PATH.normalize(path);
  },
  findObject: function(path, dontResolveLastLink) {
    var ret = FS.analyzePath(path, dontResolveLastLink);
    if (ret.exists) {
      return ret.object;
    } else {
      setErrNo(ret.error);
      return null;
    }
  },
  analyzePath: function(path, dontResolveLastLink) {
    try {
      var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
      path = lookup.path;
    } catch (e) {}
    var ret = {
      isRoot: false,
      exists: false,
      error: 0,
      name: null,
      path: null,
      object: null,
      parentExists: false,
      parentPath: null,
      parentObject: null
    };
    try {
      var lookup = FS.lookupPath(path, { parent: true });
      ret.parentExists = true;
      ret.parentPath = lookup.path;
      ret.parentObject = lookup.node;
      ret.name = PATH.basename(path);
      lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
      ret.exists = true;
      ret.path = lookup.path;
      ret.object = lookup.node;
      ret.name = lookup.node.name;
      ret.isRoot = lookup.path === "/";
    } catch (e) {
      ret.error = e.errno;
    }
    return ret;
  },
  createFolder: function(parent, name, canRead, canWrite) {
    var path = PATH.join2(
      typeof parent === "string" ? parent : FS.getPath(parent),
      name
    );
    var mode = FS.getMode(canRead, canWrite);
    return FS.mkdir(path, mode);
  },
  createPath: function(parent, path, canRead, canWrite) {
    parent = typeof parent === "string" ? parent : FS.getPath(parent);
    var parts = path.split("/").reverse();
    while (parts.length) {
      var part = parts.pop();
      if (!part) continue;
      var current = PATH.join2(parent, part);
      try {
        FS.mkdir(current);
      } catch (e) {}
      parent = current;
    }
    return current;
  },
  createFile: function(parent, name, properties, canRead, canWrite) {
    var path = PATH.join2(
      typeof parent === "string" ? parent : FS.getPath(parent),
      name
    );
    var mode = FS.getMode(canRead, canWrite);
    return FS.create(path, mode);
  },
  createDataFile: function(parent, name, data, canRead, canWrite, canOwn) {
    var path = name
      ? PATH.join2(
          typeof parent === "string" ? parent : FS.getPath(parent),
          name
        )
      : parent;
    var mode = FS.getMode(canRead, canWrite);
    var node = FS.create(path, mode);
    if (data) {
      if (typeof data === "string") {
        var arr = new Array(data.length);
        for (var i = 0, len = data.length; i < len; ++i)
          arr[i] = data.charCodeAt(i);
        data = arr;
      }
      FS.chmod(node, mode | 146);
      var stream = FS.open(node, "w");
      FS.write(stream, data, 0, data.length, 0, canOwn);
      FS.close(stream);
      FS.chmod(node, mode);
    }
    return node;
  },
  createDevice: function(parent, name, input, output) {
    var path = PATH.join2(
      typeof parent === "string" ? parent : FS.getPath(parent),
      name
    );
    var mode = FS.getMode(!!input, !!output);
    if (!FS.createDevice.major) FS.createDevice.major = 64;
    var dev = FS.makedev(FS.createDevice.major++, 0);
    FS.registerDevice(dev, {
      open: function(stream) {
        stream.seekable = false;
      },
      close: function(stream) {
        if (output && output.buffer && output.buffer.length) {
          output(10);
        }
      },
      read: function(stream, buffer, offset, length, pos) {
        var bytesRead = 0;
        for (var i = 0; i < length; i++) {
          var result;
          try {
            result = input();
          } catch (e) {
            throw new FS.ErrnoError(29);
          }
          if (result === undefined && bytesRead === 0) {
            throw new FS.ErrnoError(6);
          }
          if (result === null || result === undefined) break;
          bytesRead++;
          buffer[offset + i] = result;
        }
        if (bytesRead) {
          stream.node.timestamp = Date.now();
        }
        return bytesRead;
      },
      write: function(stream, buffer, offset, length, pos) {
        for (var i = 0; i < length; i++) {
          try {
            output(buffer[offset + i]);
          } catch (e) {
            throw new FS.ErrnoError(29);
          }
        }
        if (length) {
          stream.node.timestamp = Date.now();
        }
        return i;
      }
    });
    return FS.mkdev(path, mode, dev);
  },
  createLink: function(parent, name, target, canRead, canWrite) {
    var path = PATH.join2(
      typeof parent === "string" ? parent : FS.getPath(parent),
      name
    );
    return FS.symlink(target, path);
  },
  forceLoadFile: function(obj) {
    if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
    var success = true;
    if (typeof XMLHttpRequest !== "undefined") {
      throw new Error(
        "Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread."
      );
    } else if (read_) {
      try {
        obj.contents = intArrayFromString(read_(obj.url), true);
        obj.usedBytes = obj.contents.length;
      } catch (e) {
        success = false;
      }
    } else {
      throw new Error("Cannot load without read() or XMLHttpRequest.");
    }
    if (!success) setErrNo(29);
    return success;
  },
  createLazyFile: function(parent, name, url, canRead, canWrite) {
    function LazyUint8Array() {
      this.lengthKnown = false;
      this.chunks = [];
    }
    LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
      if (idx > this.length - 1 || idx < 0) {
        return undefined;
      }
      var chunkOffset = idx % this.chunkSize;
      var chunkNum = (idx / this.chunkSize) | 0;
      return this.getter(chunkNum)[chunkOffset];
    };
    LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(
      getter
    ) {
      this.getter = getter;
    };
    LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
      var xhr = new XMLHttpRequest();
      xhr.open("HEAD", url, false);
      xhr.send(null);
      if (!((xhr.status >= 200 && xhr.status < 300) || xhr.status === 304))
        throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
      var datalength = Number(xhr.getResponseHeader("Content-length"));
      var header;
      var hasByteServing =
        (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
      var usesGzip =
        (header = xhr.getResponseHeader("Content-Encoding")) &&
        header === "gzip";
      var chunkSize = 1024 * 1024;
      if (!hasByteServing) chunkSize = datalength;
      var doXHR = function(from, to) {
        if (from > to)
          throw new Error(
            "invalid range (" + from + ", " + to + ") or no bytes requested!"
          );
        if (to > datalength - 1)
          throw new Error(
            "only " + datalength + " bytes available! programmer error!"
          );
        var xhr = new XMLHttpRequest();
        xhr.open("GET", url, false);
        if (datalength !== chunkSize)
          xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
        if (typeof Uint8Array != "undefined") xhr.responseType = "arraybuffer";
        if (xhr.overrideMimeType) {
          xhr.overrideMimeType("text/plain; charset=x-user-defined");
        }
        xhr.send(null);
        if (!((xhr.status >= 200 && xhr.status < 300) || xhr.status === 304))
          throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
        if (xhr.response !== undefined) {
          return new Uint8Array(xhr.response || []);
        } else {
          return intArrayFromString(xhr.responseText || "", true);
        }
      };
      var lazyArray = this;
      lazyArray.setDataGetter(function(chunkNum) {
        var start = chunkNum * chunkSize;
        var end = (chunkNum + 1) * chunkSize - 1;
        end = Math.min(end, datalength - 1);
        if (typeof lazyArray.chunks[chunkNum] === "undefined") {
          lazyArray.chunks[chunkNum] = doXHR(start, end);
        }
        if (typeof lazyArray.chunks[chunkNum] === "undefined")
          throw new Error("doXHR failed!");
        return lazyArray.chunks[chunkNum];
      });
      if (usesGzip || !datalength) {
        chunkSize = datalength = 1;
        datalength = this.getter(0).length;
        chunkSize = datalength;
        out(
          "LazyFiles on gzip forces download of the whole file when length is accessed"
        );
      }
      this._length = datalength;
      this._chunkSize = chunkSize;
      this.lengthKnown = true;
    };
    if (typeof XMLHttpRequest !== "undefined") {
      if (!ENVIRONMENT_IS_WORKER)
        throw "Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";
      var lazyArray = new LazyUint8Array();
      Object.defineProperties(lazyArray, {
        length: {
          get: function() {
            if (!this.lengthKnown) {
              this.cacheLength();
            }
            return this._length;
          }
        },
        chunkSize: {
          get: function() {
            if (!this.lengthKnown) {
              this.cacheLength();
            }
            return this._chunkSize;
          }
        }
      });
      var properties = { isDevice: false, contents: lazyArray };
    } else {
      var properties = { isDevice: false, url: url };
    }
    var node = FS.createFile(parent, name, properties, canRead, canWrite);
    if (properties.contents) {
      node.contents = properties.contents;
    } else if (properties.url) {
      node.contents = null;
      node.url = properties.url;
    }
    Object.defineProperties(node, {
      usedBytes: {
        get: function() {
          return this.contents.length;
        }
      }
    });
    var stream_ops = {};
    var keys = Object.keys(node.stream_ops);
    keys.forEach(function(key) {
      var fn = node.stream_ops[key];
      stream_ops[key] = function forceLoadLazyFile() {
        if (!FS.forceLoadFile(node)) {
          throw new FS.ErrnoError(29);
        }
        return fn.apply(null, arguments);
      };
    });
    stream_ops.read = function stream_ops_read(
      stream,
      buffer,
      offset,
      length,
      position
    ) {
      if (!FS.forceLoadFile(node)) {
        throw new FS.ErrnoError(29);
      }
      var contents = stream.node.contents;
      if (position >= contents.length) return 0;
      var size = Math.min(contents.length - position, length);
      if (contents.slice) {
        for (var i = 0; i < size; i++) {
          buffer[offset + i] = contents[position + i];
        }
      } else {
        for (var i = 0; i < size; i++) {
          buffer[offset + i] = contents.get(position + i);
        }
      }
      return size;
    };
    node.stream_ops = stream_ops;
    return node;
  },
  createPreloadedFile: function(
    parent,
    name,
    url,
    canRead,
    canWrite,
    onload,
    onerror,
    dontCreateFile,
    canOwn,
    preFinish
  ) {
    Browser.init();
    var fullname = name ? PATH_FS.resolve(PATH.join2(parent, name)) : parent;
    var dep = getUniqueRunDependency("cp " + fullname);
    function processData(byteArray) {
      function finish(byteArray) {
        if (preFinish) preFinish();
        if (!dontCreateFile) {
          FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
        }
        if (onload) onload();
        removeRunDependency(dep);
      }
      var handled = false;
      Module["preloadPlugins"].forEach(function(plugin) {
        if (handled) return;
        if (plugin["canHandle"](fullname)) {
          plugin["handle"](byteArray, fullname, finish, function() {
            if (onerror) onerror();
            removeRunDependency(dep);
          });
          handled = true;
        }
      });
      if (!handled) finish(byteArray);
    }
    addRunDependency(dep);
    if (typeof url == "string") {
      Browser.asyncLoad(
        url,
        function(byteArray) {
          processData(byteArray);
        },
        onerror
      );
    } else {
      processData(url);
    }
  },
  indexedDB: function() {
    return (
      window.indexedDB ||
      window.mozIndexedDB ||
      window.webkitIndexedDB ||
      window.msIndexedDB
    );
  },
  DB_NAME: function() {
    return "EM_FS_" + window.location.pathname;
  },
  DB_VERSION: 20,
  DB_STORE_NAME: "FILE_DATA",
  saveFilesToDB: function(paths, onload, onerror) {
    onload = onload || function() {};
    onerror = onerror || function() {};
    var indexedDB = FS.indexedDB();
    try {
      var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
    } catch (e) {
      return onerror(e);
    }
    openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
      out("creating db");
      var db = openRequest.result;
      db.createObjectStore(FS.DB_STORE_NAME);
    };
    openRequest.onsuccess = function openRequest_onsuccess() {
      var db = openRequest.result;
      var transaction = db.transaction([FS.DB_STORE_NAME], "readwrite");
      var files = transaction.objectStore(FS.DB_STORE_NAME);
      var ok = 0,
        fail = 0,
        total = paths.length;
      function finish() {
        if (fail == 0) onload();
        else onerror();
      }
      paths.forEach(function(path) {
        var putRequest = files.put(FS.analyzePath(path).object.contents, path);
        putRequest.onsuccess = function putRequest_onsuccess() {
          ok++;
          if (ok + fail == total) finish();
        };
        putRequest.onerror = function putRequest_onerror() {
          fail++;
          if (ok + fail == total) finish();
        };
      });
      transaction.onerror = onerror;
    };
    openRequest.onerror = onerror;
  },
  loadFilesFromDB: function(paths, onload, onerror) {
    onload = onload || function() {};
    onerror = onerror || function() {};
    var indexedDB = FS.indexedDB();
    try {
      var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
    } catch (e) {
      return onerror(e);
    }
    openRequest.onupgradeneeded = onerror;
    openRequest.onsuccess = function openRequest_onsuccess() {
      var db = openRequest.result;
      try {
        var transaction = db.transaction([FS.DB_STORE_NAME], "readonly");
      } catch (e) {
        onerror(e);
        return;
      }
      var files = transaction.objectStore(FS.DB_STORE_NAME);
      var ok = 0,
        fail = 0,
        total = paths.length;
      function finish() {
        if (fail == 0) onload();
        else onerror();
      }
      paths.forEach(function(path) {
        var getRequest = files.get(path);
        getRequest.onsuccess = function getRequest_onsuccess() {
          if (FS.analyzePath(path).exists) {
            FS.unlink(path);
          }
          FS.createDataFile(
            PATH.dirname(path),
            PATH.basename(path),
            getRequest.result,
            true,
            true,
            true
          );
          ok++;
          if (ok + fail == total) finish();
        };
        getRequest.onerror = function getRequest_onerror() {
          fail++;
          if (ok + fail == total) finish();
        };
      });
      transaction.onerror = onerror;
    };
    openRequest.onerror = onerror;
  },
  mmapAlloc: function(size) {
    var alignedSize = alignMemory(size, 16384);
    var ptr = _malloc(alignedSize);
    while (size < alignedSize) HEAP8[ptr + size++] = 0;
    return ptr;
  }
};
var SYSCALLS = {
  mappings: {},
  DEFAULT_POLLMASK: 5,
  umask: 511,
  calculateAt: function(dirfd, path) {
    if (path[0] !== "/") {
      var dir;
      if (dirfd === -100) {
        dir = FS.cwd();
      } else {
        var dirstream = FS.getStream(dirfd);
        if (!dirstream) throw new FS.ErrnoError(8);
        dir = dirstream.path;
      }
      path = PATH.join2(dir, path);
    }
    return path;
  },
  doStat: function(func, path, buf) {
    try {
      var stat = func(path);
    } catch (e) {
      if (
        e &&
        e.node &&
        PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))
      ) {
        return -54;
      }
      throw e;
    }
    HEAP32[buf >> 2] = stat.dev;
    HEAP32[(buf + 4) >> 2] = 0;
    HEAP32[(buf + 8) >> 2] = stat.ino;
    HEAP32[(buf + 12) >> 2] = stat.mode;
    HEAP32[(buf + 16) >> 2] = stat.nlink;
    HEAP32[(buf + 20) >> 2] = stat.uid;
    HEAP32[(buf + 24) >> 2] = stat.gid;
    HEAP32[(buf + 28) >> 2] = stat.rdev;
    HEAP32[(buf + 32) >> 2] = 0;
    (tempI64 = [
      stat.size >>> 0,
      ((tempDouble = stat.size),
      +Math_abs(tempDouble) >= 1
        ? tempDouble > 0
          ? (Math_min(+Math_floor(tempDouble / 4294967296), 4294967295) | 0) >>>
            0
          : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>>
            0
        : 0)
    ]),
      (HEAP32[(buf + 40) >> 2] = tempI64[0]),
      (HEAP32[(buf + 44) >> 2] = tempI64[1]);
    HEAP32[(buf + 48) >> 2] = 4096;
    HEAP32[(buf + 52) >> 2] = stat.blocks;
    HEAP32[(buf + 56) >> 2] = (stat.atime.getTime() / 1e3) | 0;
    HEAP32[(buf + 60) >> 2] = 0;
    HEAP32[(buf + 64) >> 2] = (stat.mtime.getTime() / 1e3) | 0;
    HEAP32[(buf + 68) >> 2] = 0;
    HEAP32[(buf + 72) >> 2] = (stat.ctime.getTime() / 1e3) | 0;
    HEAP32[(buf + 76) >> 2] = 0;
    (tempI64 = [
      stat.ino >>> 0,
      ((tempDouble = stat.ino),
      +Math_abs(tempDouble) >= 1
        ? tempDouble > 0
          ? (Math_min(+Math_floor(tempDouble / 4294967296), 4294967295) | 0) >>>
            0
          : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>>
            0
        : 0)
    ]),
      (HEAP32[(buf + 80) >> 2] = tempI64[0]),
      (HEAP32[(buf + 84) >> 2] = tempI64[1]);
    return 0;
  },
  doMsync: function(addr, stream, len, flags, offset) {
    var buffer = HEAPU8.slice(addr, addr + len);
    FS.msync(stream, buffer, offset, len, flags);
  },
  doMkdir: function(path, mode) {
    path = PATH.normalize(path);
    if (path[path.length - 1] === "/") path = path.slice(0, -1);
    FS.mkdir(path, mode, 0);
    return 0;
  },
  doMknod: function(path, mode, dev) {
    switch (mode & 61440) {
      case 32768:
      case 8192:
      case 24576:
      case 4096:
      case 49152:
        break;
      default:
        return -28;
    }
    FS.mknod(path, mode, dev);
    return 0;
  },
  doReadlink: function(path, buf, bufsize) {
    if (bufsize <= 0) return -28;
    var ret = FS.readlink(path);
    var len = Math.min(bufsize, lengthBytesUTF8(ret));
    var endChar = HEAP8[buf + len];
    stringToUTF8(ret, buf, bufsize + 1);
    HEAP8[buf + len] = endChar;
    return len;
  },
  doAccess: function(path, amode) {
    if (amode & ~7) {
      return -28;
    }
    var node;
    var lookup = FS.lookupPath(path, { follow: true });
    node = lookup.node;
    if (!node) {
      return -44;
    }
    var perms = "";
    if (amode & 4) perms += "r";
    if (amode & 2) perms += "w";
    if (amode & 1) perms += "x";
    if (perms && FS.nodePermissions(node, perms)) {
      return -2;
    }
    return 0;
  },
  doDup: function(path, flags, suggestFD) {
    var suggest = FS.getStream(suggestFD);
    if (suggest) FS.close(suggest);
    return FS.open(path, flags, 0, suggestFD, suggestFD).fd;
  },
  doReadv: function(stream, iov, iovcnt, offset) {
    var ret = 0;
    for (var i = 0; i < iovcnt; i++) {
      var ptr = HEAP32[(iov + i * 8) >> 2];
      var len = HEAP32[(iov + (i * 8 + 4)) >> 2];
      var curr = FS.read(stream, HEAP8, ptr, len, offset);
      if (curr < 0) return -1;
      ret += curr;
      if (curr < len) break;
    }
    return ret;
  },
  doWritev: function(stream, iov, iovcnt, offset) {
    var ret = 0;
    for (var i = 0; i < iovcnt; i++) {
      var ptr = HEAP32[(iov + i * 8) >> 2];
      var len = HEAP32[(iov + (i * 8 + 4)) >> 2];
      var curr = FS.write(stream, HEAP8, ptr, len, offset);
      if (curr < 0) return -1;
      ret += curr;
    }
    return ret;
  },
  varargs: undefined,
  get: function() {
    SYSCALLS.varargs += 4;
    var ret = HEAP32[(SYSCALLS.varargs - 4) >> 2];
    return ret;
  },
  getStr: function(ptr) {
    var ret = UTF8ToString(ptr);
    return ret;
  },
  getStreamFromFD: function(fd) {
    var stream = FS.getStream(fd);
    if (!stream) throw new FS.ErrnoError(8);
    return stream;
  },
  get64: function(low, high) {
    return low;
  }
};
function ___sys_chmod(path, mode) {
  try {
    path = SYSCALLS.getStr(path);
    FS.chmod(path, mode);
    return 0;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function ___sys_fcntl64(fd, cmd, varargs) {
  SYSCALLS.varargs = varargs;
  try {
    var stream = SYSCALLS.getStreamFromFD(fd);
    switch (cmd) {
      case 0: {
        var arg = SYSCALLS.get();
        if (arg < 0) {
          return -28;
        }
        var newStream;
        newStream = FS.open(stream.path, stream.flags, 0, arg);
        return newStream.fd;
      }
      case 1:
      case 2:
        return 0;
      case 3:
        return stream.flags;
      case 4: {
        var arg = SYSCALLS.get();
        stream.flags |= arg;
        return 0;
      }
      case 12: {
        var arg = SYSCALLS.get();
        var offset = 0;
        HEAP16[(arg + offset) >> 1] = 2;
        return 0;
      }
      case 13:
      case 14:
        return 0;
      case 16:
      case 8:
        return -28;
      case 9:
        setErrNo(28);
        return -1;
      default: {
        return -28;
      }
    }
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function ___sys_fstat64(fd, buf) {
  try {
    var stream = SYSCALLS.getStreamFromFD(fd);
    return SYSCALLS.doStat(FS.stat, stream.path, buf);
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function ___sys_ioctl(fd, op, varargs) {
  SYSCALLS.varargs = varargs;
  try {
    var stream = SYSCALLS.getStreamFromFD(fd);
    switch (op) {
      case 21509:
      case 21505: {
        if (!stream.tty) return -59;
        return 0;
      }
      case 21510:
      case 21511:
      case 21512:
      case 21506:
      case 21507:
      case 21508: {
        if (!stream.tty) return -59;
        return 0;
      }
      case 21519: {
        if (!stream.tty) return -59;
        var argp = SYSCALLS.get();
        HEAP32[argp >> 2] = 0;
        return 0;
      }
      case 21520: {
        if (!stream.tty) return -59;
        return -28;
      }
      case 21531: {
        var argp = SYSCALLS.get();
        return FS.ioctl(stream, op, argp);
      }
      case 21523: {
        if (!stream.tty) return -59;
        return 0;
      }
      case 21524: {
        if (!stream.tty) return -59;
        return 0;
      }
      default:
        abort("bad ioctl syscall " + op);
    }
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function ___sys_open(path, flags, varargs) {
  SYSCALLS.varargs = varargs;
  try {
    var pathname = SYSCALLS.getStr(path);
    var mode = SYSCALLS.get();
    var stream = FS.open(pathname, flags, mode);
    return stream.fd;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function ___sys_read(fd, buf, count) {
  try {
    var stream = SYSCALLS.getStreamFromFD(fd);
    return FS.read(stream, HEAP8, buf, count);
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function ___sys_rename(old_path, new_path) {
  try {
    old_path = SYSCALLS.getStr(old_path);
    new_path = SYSCALLS.getStr(new_path);
    FS.rename(old_path, new_path);
    return 0;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function ___sys_rmdir(path) {
  try {
    path = SYSCALLS.getStr(path);
    FS.rmdir(path);
    return 0;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function ___sys_stat64(path, buf) {
  try {
    path = SYSCALLS.getStr(path);
    return SYSCALLS.doStat(FS.stat, path, buf);
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function ___sys_unlink(path) {
  try {
    path = SYSCALLS.getStr(path);
    FS.unlink(path);
    return 0;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
}
function _emscripten_memcpy_big(dest, src, num) {
  HEAPU8.copyWithin(dest, src, src + num);
}
function _emscripten_get_heap_size() {
  return HEAPU8.length;
}
function emscripten_realloc_buffer(size) {
  try {
    wasmMemory.grow((size - buffer.byteLength + 65535) >>> 16);
    updateGlobalBufferAndViews(wasmMemory.buffer);
    return 1;
  } catch (e) {}
}
function _emscripten_resize_heap(requestedSize) {
  requestedSize = requestedSize >>> 0;
  var oldSize = _emscripten_get_heap_size();
  var maxHeapSize = 2147483648;
  if (requestedSize > maxHeapSize) {
    return false;
  }
  var minHeapSize = 16777216;
  for (var cutDown = 1; cutDown <= 4; cutDown *= 2) {
    var overGrownHeapSize = oldSize * (1 + 0.2 / cutDown);
    overGrownHeapSize = Math.min(overGrownHeapSize, requestedSize + 100663296);
    var newSize = Math.min(
      maxHeapSize,
      alignUp(Math.max(minHeapSize, requestedSize, overGrownHeapSize), 65536)
    );
    var replacement = emscripten_realloc_buffer(newSize);
    if (replacement) {
      return true;
    }
  }
  return false;
}
function _fd_close(fd) {
  try {
    var stream = SYSCALLS.getStreamFromFD(fd);
    FS.close(stream);
    return 0;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
}
function _fd_fdstat_get(fd, pbuf) {
  try {
    var stream = SYSCALLS.getStreamFromFD(fd);
    var type = stream.tty
      ? 2
      : FS.isDir(stream.mode)
      ? 3
      : FS.isLink(stream.mode)
      ? 7
      : 4;
    HEAP8[pbuf >> 0] = type;
    return 0;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
}
function _fd_read(fd, iov, iovcnt, pnum) {
  try {
    var stream = SYSCALLS.getStreamFromFD(fd);
    var num = SYSCALLS.doReadv(stream, iov, iovcnt);
    HEAP32[pnum >> 2] = num;
    return 0;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
}
function _fd_seek(fd, offset_low, offset_high, whence, newOffset) {
  try {
    var stream = SYSCALLS.getStreamFromFD(fd);
    var HIGH_OFFSET = 4294967296;
    var offset = offset_high * HIGH_OFFSET + (offset_low >>> 0);
    var DOUBLE_LIMIT = 9007199254740992;
    if (offset <= -DOUBLE_LIMIT || offset >= DOUBLE_LIMIT) {
      return -61;
    }
    FS.llseek(stream, offset, whence);
    (tempI64 = [
      stream.position >>> 0,
      ((tempDouble = stream.position),
      +Math_abs(tempDouble) >= 1
        ? tempDouble > 0
          ? (Math_min(+Math_floor(tempDouble / 4294967296), 4294967295) | 0) >>>
            0
          : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>>
            0
        : 0)
    ]),
      (HEAP32[newOffset >> 2] = tempI64[0]),
      (HEAP32[(newOffset + 4) >> 2] = tempI64[1]);
    if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null;
    return 0;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
}
function _fd_write(fd, iov, iovcnt, pnum) {
  try {
    var stream = SYSCALLS.getStreamFromFD(fd);
    var num = SYSCALLS.doWritev(stream, iov, iovcnt);
    HEAP32[pnum >> 2] = num;
    return 0;
  } catch (e) {
    if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
}
function _setTempRet0($i) {
  setTempRet0($i | 0);
}
function _time(ptr) {
  var ret = (Date.now() / 1e3) | 0;
  if (ptr) {
    HEAP32[ptr >> 2] = ret;
  }
  return ret;
}
function _tzset() {
  if (_tzset.called) return;
  _tzset.called = true;
  HEAP32[__get_timezone() >> 2] = new Date().getTimezoneOffset() * 60;
  var currentYear = new Date().getFullYear();
  var winter = new Date(currentYear, 0, 1);
  var summer = new Date(currentYear, 6, 1);
  HEAP32[__get_daylight() >> 2] = Number(
    winter.getTimezoneOffset() != summer.getTimezoneOffset()
  );
  function extractZone(date) {
    var match = date.toTimeString().match(/\(([A-Za-z ]+)\)$/);
    return match ? match[1] : "GMT";
  }
  var winterName = extractZone(winter);
  var summerName = extractZone(summer);
  var winterNamePtr = allocateUTF8(winterName);
  var summerNamePtr = allocateUTF8(summerName);
  if (summer.getTimezoneOffset() < winter.getTimezoneOffset()) {
    HEAP32[__get_tzname() >> 2] = winterNamePtr;
    HEAP32[(__get_tzname() + 4) >> 2] = summerNamePtr;
  } else {
    HEAP32[__get_tzname() >> 2] = summerNamePtr;
    HEAP32[(__get_tzname() + 4) >> 2] = winterNamePtr;
  }
}
function _timegm(tmPtr) {
  _tzset();
  var time = Date.UTC(
    HEAP32[(tmPtr + 20) >> 2] + 1900,
    HEAP32[(tmPtr + 16) >> 2],
    HEAP32[(tmPtr + 12) >> 2],
    HEAP32[(tmPtr + 8) >> 2],
    HEAP32[(tmPtr + 4) >> 2],
    HEAP32[tmPtr >> 2],
    0
  );
  var date = new Date(time);
  HEAP32[(tmPtr + 24) >> 2] = date.getUTCDay();
  var start = Date.UTC(date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);
  var yday = ((date.getTime() - start) / (1e3 * 60 * 60 * 24)) | 0;
  HEAP32[(tmPtr + 28) >> 2] = yday;
  return (date.getTime() / 1e3) | 0;
}
var FSNode = function(parent, name, mode, rdev) {
  if (!parent) {
    parent = this;
  }
  this.parent = parent;
  this.mount = parent.mount;
  this.mounted = null;
  this.id = FS.nextInode++;
  this.name = name;
  this.mode = mode;
  this.node_ops = {};
  this.stream_ops = {};
  this.rdev = rdev;
};
var readMode = 292 | 73;
var writeMode = 146;
Object.defineProperties(FSNode.prototype, {
  read: {
    get: function() {
      return (this.mode & readMode) === readMode;
    },
    set: function(val) {
      val ? (this.mode |= readMode) : (this.mode &= ~readMode);
    }
  },
  write: {
    get: function() {
      return (this.mode & writeMode) === writeMode;
    },
    set: function(val) {
      val ? (this.mode |= writeMode) : (this.mode &= ~writeMode);
    }
  },
  isFolder: {
    get: function() {
      return FS.isDir(this.mode);
    }
  },
  isDevice: {
    get: function() {
      return FS.isChrdev(this.mode);
    }
  }
});
FS.FSNode = FSNode;
FS.staticInit();
if (ENVIRONMENT_IS_NODE) {
  var fs = frozenFs;
  var NODEJS_PATH = __webpack_require__(622);
  NODEFS.staticInit();
}
if (ENVIRONMENT_IS_NODE) {
  var _wrapNodeError = function(func) {
    return function() {
      try {
        return func.apply(this, arguments);
      } catch (e) {
        if (!e.code) throw e;
        throw new FS.ErrnoError(ERRNO_CODES[e.code]);
      }
    };
  };
  var VFS = Object.assign({}, FS);
  for (var _key in NODERAWFS) FS[_key] = _wrapNodeError(NODERAWFS[_key]);
} else {
  throw new Error(
    "NODERAWFS is currently only supported on Node.js environment."
  );
}
function intArrayFromString(stringy, dontAddNull, length) {
  var len = length > 0 ? length : lengthBytesUTF8(stringy) + 1;
  var u8array = new Array(len);
  var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
  if (dontAddNull) u8array.length = numBytesWritten;
  return u8array;
}
var decodeBase64 =
  typeof atob === "function"
    ? atob
    : function(input) {
        var keyStr =
          "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;
        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
        do {
          enc1 = keyStr.indexOf(input.charAt(i++));
          enc2 = keyStr.indexOf(input.charAt(i++));
          enc3 = keyStr.indexOf(input.charAt(i++));
          enc4 = keyStr.indexOf(input.charAt(i++));
          chr1 = (enc1 << 2) | (enc2 >> 4);
          chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
          chr3 = ((enc3 & 3) << 6) | enc4;
          output = output + String.fromCharCode(chr1);
          if (enc3 !== 64) {
            output = output + String.fromCharCode(chr2);
          }
          if (enc4 !== 64) {
            output = output + String.fromCharCode(chr3);
          }
        } while (i < input.length);
        return output;
      };
function intArrayFromBase64(s) {
  if (typeof ENVIRONMENT_IS_NODE === "boolean" && ENVIRONMENT_IS_NODE) {
    var buf;
    try {
      buf = Buffer.from(s, "base64");
    } catch (_) {
      buf = new Buffer(s, "base64");
    }
    return new Uint8Array(buf["buffer"], buf["byteOffset"], buf["byteLength"]);
  }
  try {
    var decoded = decodeBase64(s);
    var bytes = new Uint8Array(decoded.length);
    for (var i = 0; i < decoded.length; ++i) {
      bytes[i] = decoded.charCodeAt(i);
    }
    return bytes;
  } catch (_) {
    throw new Error("Converting base64 string to bytes failed.");
  }
}
function tryParseAsDataURI(filename) {
  if (!isDataURI(filename)) {
    return;
  }
  return intArrayFromBase64(filename.slice(dataURIPrefix.length));
}
var asmLibraryArg = {
  m: ___gmtime_r,
  b: wasmTable,
  r: ___sys_chmod,
  g: ___sys_fcntl64,
  l: ___sys_fstat64,
  q: ___sys_ioctl,
  t: ___sys_open,
  s: ___sys_read,
  j: ___sys_rename,
  u: ___sys_rmdir,
  e: ___sys_stat64,
  i: ___sys_unlink,
  v: _emscripten_memcpy_big,
  w: _emscripten_resize_heap,
  h: _fd_close,
  k: _fd_fdstat_get,
  p: _fd_read,
  n: _fd_seek,
  f: _fd_write,
  a: wasmMemory,
  c: _setTempRet0,
  d: _time,
  o: _timegm
};
var asm = createWasm();
var ___wasm_call_ctors = (Module["___wasm_call_ctors"] = asm["x"]);
var _zipstruct_stat = (Module["_zipstruct_stat"] = asm["y"]);
var _zipstruct_statS = (Module["_zipstruct_statS"] = asm["z"]);
var _zipstruct_stat_name = (Module["_zipstruct_stat_name"] = asm["A"]);
var _zipstruct_stat_index = (Module["_zipstruct_stat_index"] = asm["B"]);
var _zipstruct_stat_size = (Module["_zipstruct_stat_size"] = asm["C"]);
var _zipstruct_stat_mtime = (Module["_zipstruct_stat_mtime"] = asm["D"]);
var _zipstruct_error = (Module["_zipstruct_error"] = asm["E"]);
var _zipstruct_errorS = (Module["_zipstruct_errorS"] = asm["F"]);
var _zipstruct_error_code_zip = (Module["_zipstruct_error_code_zip"] =
  asm["G"]);
var _zipstruct_stat_comp_size = (Module["_zipstruct_stat_comp_size"] =
  asm["H"]);
var _zipstruct_stat_comp_method = (Module["_zipstruct_stat_comp_method"] =
  asm["I"]);
var _zip_close = (Module["_zip_close"] = asm["J"]);
var _zip_delete = (Module["_zip_delete"] = asm["K"]);
var _zip_dir_add = (Module["_zip_dir_add"] = asm["L"]);
var _zip_discard = (Module["_zip_discard"] = asm["M"]);
var _zip_error_init_with_code = (Module["_zip_error_init_with_code"] =
  asm["N"]);
var _zip_get_error = (Module["_zip_get_error"] = asm["O"]);
var _zip_file_get_error = (Module["_zip_file_get_error"] = asm["P"]);
var _zip_error_strerror = (Module["_zip_error_strerror"] = asm["Q"]);
var _zip_fclose = (Module["_zip_fclose"] = asm["R"]);
var _zip_file_add = (Module["_zip_file_add"] = asm["S"]);
var _zip_file_get_external_attributes = (Module[
  "_zip_file_get_external_attributes"
] = asm["T"]);
var _zip_file_set_external_attributes = (Module[
  "_zip_file_set_external_attributes"
] = asm["U"]);
var _zip_file_set_mtime = (Module["_zip_file_set_mtime"] = asm["V"]);
var _zip_fopen = (Module["_zip_fopen"] = asm["W"]);
var _zip_fopen_index = (Module["_zip_fopen_index"] = asm["X"]);
var _zip_fread = (Module["_zip_fread"] = asm["Y"]);
var _zip_get_name = (Module["_zip_get_name"] = asm["Z"]);
var _zip_get_num_entries = (Module["_zip_get_num_entries"] = asm["_"]);
var _zip_name_locate = (Module["_zip_name_locate"] = asm["$"]);
var _zip_open = (Module["_zip_open"] = asm["aa"]);
var _zip_open_from_source = (Module["_zip_open_from_source"] = asm["ba"]);
var _zip_set_file_compression = (Module["_zip_set_file_compression"] =
  asm["ca"]);
var _zip_source_buffer = (Module["_zip_source_buffer"] = asm["da"]);
var _zip_source_buffer_create = (Module["_zip_source_buffer_create"] =
  asm["ea"]);
var _zip_source_close = (Module["_zip_source_close"] = asm["fa"]);
var _zip_source_error = (Module["_zip_source_error"] = asm["ga"]);
var _zip_source_free = (Module["_zip_source_free"] = asm["ha"]);
var _zip_source_keep = (Module["_zip_source_keep"] = asm["ia"]);
var _zip_source_open = (Module["_zip_source_open"] = asm["ja"]);
var _zip_source_read = (Module["_zip_source_read"] = asm["ka"]);
var _zip_source_seek = (Module["_zip_source_seek"] = asm["la"]);
var _zip_source_set_mtime = (Module["_zip_source_set_mtime"] = asm["ma"]);
var _zip_source_tell = (Module["_zip_source_tell"] = asm["na"]);
var _zip_stat = (Module["_zip_stat"] = asm["oa"]);
var _zip_stat_index = (Module["_zip_stat_index"] = asm["pa"]);
var _zip_ext_count_symlinks = (Module["_zip_ext_count_symlinks"] = asm["qa"]);
var ___errno_location = (Module["___errno_location"] = asm["ra"]);
var __get_tzname = (Module["__get_tzname"] = asm["sa"]);
var __get_daylight = (Module["__get_daylight"] = asm["ta"]);
var __get_timezone = (Module["__get_timezone"] = asm["ua"]);
var stackSave = (Module["stackSave"] = asm["va"]);
var stackRestore = (Module["stackRestore"] = asm["wa"]);
var stackAlloc = (Module["stackAlloc"] = asm["xa"]);
var _malloc = (Module["_malloc"] = asm["ya"]);
var _free = (Module["_free"] = asm["za"]);
Module["cwrap"] = cwrap;
Module["getValue"] = getValue;
var calledRun;
dependenciesFulfilled = function runCaller() {
  if (!calledRun) run();
  if (!calledRun) dependenciesFulfilled = runCaller;
};
function run(args) {
  args = args || arguments_;
  if (runDependencies > 0) {
    return;
  }
  preRun();
  if (runDependencies > 0) return;
  function doRun() {
    if (calledRun) return;
    calledRun = true;
    Module["calledRun"] = true;
    if (ABORT) return;
    initRuntime();
    preMain();
    if (Module["onRuntimeInitialized"]) Module["onRuntimeInitialized"]();
    postRun();
  }
  if (Module["setStatus"]) {
    Module["setStatus"]("Running...");
    setTimeout(function() {
      setTimeout(function() {
        Module["setStatus"]("");
      }, 1);
      doRun();
    }, 1);
  } else {
    doRun();
  }
}
Module["run"] = run;
if (Module["preInit"]) {
  if (typeof Module["preInit"] == "function")
    Module["preInit"] = [Module["preInit"]];
  while (Module["preInit"].length > 0) {
    Module["preInit"].pop()();
  }
}
noExitRuntime = true;
run();


/***/ }),

/***/ 417:
/***/ ((module) => {

"use strict";
module.exports = require("crypto");;

/***/ }),

/***/ 747:
/***/ ((module) => {

"use strict";
module.exports = require("fs");;

/***/ }),

/***/ 282:
/***/ ((module) => {

"use strict";
module.exports = require("module");;

/***/ }),

/***/ 622:
/***/ ((module) => {

"use strict";
module.exports = require("path");;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		if(__webpack_module_cache__[moduleId]) {
/******/ 			return __webpack_module_cache__[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => module['default'] :
/******/ 				() => module;
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => Object.prototype.hasOwnProperty.call(obj, prop)
/******/ 	})();
/******/
/************************************************************************/
/******/ 	// module exports must be returned from runtime so entry inlining is disabled
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(936);
/******/ })()
.default;
});
