# Vercel Examples

To get started using any of these examples as your own project, [install Vercel](https://vercel.com/docs/cli) and use either of the following commands in your terminal:

```sh
vercel init                    # Pick an example in the CLI
vercel init <example>          # Create a new project from a specific <example>
vercel init <example> <name>   # Create a new project from a specific <example> with a different folder <name>
```

Deploying your project can be done with **a single command**:

```sh
vercel                         # Deploy your project with the CLI
```

With the `vercel` command, your project will be built and served by Vercel, providing you with a URL that can be shared immediately.

## How to Contribute

Contributing examples should be an enjoyable experience, as such we have created a set of [contributing guidelines](https://github.com/vercel/vercel/blob/main/.github/CONTRIBUTING.md) to help you do so.

The guidelines cover important information such as the requirements for new examples and where to get help if you have any questions.

We have tried to make contributing to examples as easy as possible, especially for those new to Open Source. If anything is unclear or you have any questions then please reach out to us on [https://vercel.community/](https://vercel.community/) where we will do our best to help you.

## Reporting Issues

We actively encourage our community to raise issues and provide feedback on areas of examples that could be improved.

An issue can be raised by clicking the 'Issues' tab at the top of the repository, followed by the Green 'New issue' button.

When submitting an issue, please thoroughly and concisely describe the problem you are experiencing so that we may easily understand and resolve the issue in a timely manner.

## Get In Touch

If you have any questions that are not covered by raising an issue then please get in touch with us on [https://vercel.community/](https://vercel.community/). There you will find both members of the community and staff who are happy to help answer questions on anything Vercel related.

[Join the Vercel Community](https://vercel.community/)
