# <p align="center">Кронос (Kronos)</p>

<p align="center">
  <img src="https://img.shields.io/badge/Kotlin-orange">
  <img src="https://img.shields.io/badge/Room%20Database-blue">
  <img src="https://img.shields.io/badge/Notifications-Yes-blue">
  <img src="https://img.shields.io/badge/Privacy-Yes-blue">
  <img src="https://img.shields.io/badge/Safety-Yes-blue">
</p>

Это простое приложение Todo (tasks manager), разработанное на Kotlin, которое использует библиотеку Room Database для управления задачами. Он также включает в себя функцию уведомления, чтобы напоминать пользователям о задачах в определенные даты и время.

# README.md
- en [English](https://github.com/ve3xone/todo-app/blob/main/README.en.md)
- ru [Русский](https://github.com/ve3xone/todo-app/blob/main/README.md)

## Особенности

- Оффлайн, приватность.
    - Поэтому никаких синхронизаций и нету а будет только максимум экспорт/импорт.
- Создать, читать задачи.
- Задачи храняться локально, используя базу данных (Room Database).
- Уведомления, напоминающие вам о предстоящих задачах.

## Системные требования

Для работы приложения:
- Начиная с Android 8 до Android 14 (Протестировано)

Для сборки приложения:
- Android Studio Iguana (2023.2.1)
    - Можно и ниже и выше, но я для разработки использовал версию 2023.2.1
- Gradle 5.1.1
- Gradle JDK: corretto-1.8.0_402
- Android SDK: Android 14 (API Level 34, Revision 3)

## Задачи на будущее и выполненые задачи

Главное:

- [x] Базовый функционал с задачами. (Создание задач c именем, описанием и также получение уведомлений)
    - [x] Получение списка дел
    - [x] Добавление задач и удаление
    - [x] Редактирование элементов списка
        - [x] Кликабельные ссылки внутри задачи (нужно для ссылок если они есть)
            - Отображается если кликнуть на саму задачу
    - [x] Возможность задать дату и время для каждой задачи (Напоминания на одну задачу)
- [x] Безопасность данных
    - [x] Пароль устанавливает пользователь при первом входе в приложение
    - [x] Пароль зашифрован шифровальными алгоритмами
    - [x] Пароль запрашивается при каждом выходе и заходе в/из прилож.
    - [x] При изменении настроек тоже нужно вводить пароль.
    - [x] После экспорта/импорте ics нужно вводить пароль.
    - [x] После экспорте бд нужно тоже вводить пароль.
    - [x] После импорта базы данных нужно вводить пароль импортируемой базы данных.
- [x] Настройки (Окно в котором будут два раздела темы (выбор темы) и другое)
- [x] Импорт/Экспорт базы данных. (раздел настроек другое)
- [x] Экспорт в [.ics формат](https://en.wikipedia.org/wiki/ICalendar), чтоб можно задачи добавить в календарь. (раздел настроек другое)
- [x] Импорт из [.ics формат](https://en.wikipedia.org/wiki/ICalendar). (раздел настроек другое)
- [x] Поиск по задачам. (по имени и описанию)
- [x] Сортировка задач по умолчанию (по дате и времени задачи)
- [x] Вкладки все и активные задачи
    - Во вкладке "все" отображаются все задачи.
    - Во вкладке "активные" отображаются задачи которые помечаны как невыполненные
        - Отображаются на которых не стоит галочка
        - [x] Возможность отмечать задачи как выполненные или невыполненные.
            - [x] Отмечать задачи как выполненые через уведомление задачи
    - [x] Свайпы между вкладками
- [x] Перевод на английский
- [x] Сделать как по [дизайну](https://raw.githubusercontent.com/ve3xone/kronos-todo-app/main/%D0%B7%D0%B0%D0%BA%D0%BE%D0%BD-%D0%B4%D0%B8%D0%B7%D0%B0%D0%B9%D0%BD/%D0%9F%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D1%83%D1%85%D0%B0.png) ([jam](https://github.com/ve3xone/kronos-todo-app/raw/main/%D0%B7%D0%B0%D0%BA%D0%BE%D0%BD-%D0%B4%D0%B8%D0%B7%D0%B0%D0%B9%D0%BD/%D0%9F%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D1%83%D1%85%D0%B0.jam)).
    - Крч иконки да в целом дизайн достать не получается из-за фигмы jam так что жду иконок и все
        - По итогу было принято не брать дизайн дизайнера так как он сделал в фигме jam...
            - Максимум только иконки возьму...

Задачи на 3 семестр (самые важные и легкие находятся первее):

- [x] Куча разлчиных фиксов чтоб приложение корректно работало на Android 13 и выше

- [x] Статистика.
    - Данный функционал должен предоставлять в наглядной форме статистику пользования приложения - количество завершенных и незавершенных задач, количество созданных и удаленных задач, результативность (соотношение выполненных/невыполненных задач) и т.д.

- Проблемные в плане UI:
    - [ ] Папки для задач.
        - Группировка задач по пользовательским категориям - папкам.
        - Пользователь должен иметь возможность создать "папку", в которую он может добавлять задачи, при открытии "папки" должны отображаться только задачи, добавленные в неё.

    - [ ] Множественные напоминания.
        - Необходимо добавить возможность установления нескольких уведомлений для одной задачи, самое позднее установленное уведомление должно браться за дедлайн задачи.

    - [ ] Подзадачи.
      - При создании или редактировании задачи необходимо добавить функцию добавления подзадачи с возможностью отметить её как "выполненно" или "не выполненно".

На будущее, cкорее всего не успею реализовать:
- [ ] Ещё идея насчет календаря но там тоже проблемки в UI слищком сложно и долго.
    
- Самое проблемное также в плане UI (скорее всего доделать-сделать не успею):
    - [ ] Постепенное обновление интерфейса приложения - внедрение изначального дизайна. В ходе тестирования приложения мы выяснили, что представителям целевой аудитории больше нравился изначальный дизайн продукта, потому мы планируем восстановить его в новой версии.

- Не подходит из-за приватности:
    - [ ] Виджет. У пользователя должна быть возможность быстрого создания задачи через виджет на рабочем столе без необходимости входа в приложение.
