![Wumpus Mono Logo](images/WumpusMono_Logo_Inv.png)

<a href="https://vaughantype.com/wumpus-mono-pro" target="_blank">**Wumpus Mono**</a> is a modern and functional monospaced typeface with a focus on legibility.

Current version: 1.027.

## ¶ Introduction

Wumpus Mono was designed to be easily legible at very small point sizes, and is influenced by fonts such as IBM's [Plex](https://github.com/IBM/plex) and the wonderful Susan Kare's [Chicago](https://en.wikipedia.org/wiki/Chicago_(typeface)).

Regular 400 Roman
![Wumpus Mono Regular Specimen](images/WumpusMono_Overview_Specimen.png)

### [OpenType Stylistic Sets](https://learn.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx)

### `g.ss01` Single-storey (opentail) g

![Wumpus Mono Alternative g](images/WumpusMono_Alternative-g.png)

### `a.ss02` Single-storey a

![Wumpus Mono Alternative a](images/WumpusMono_Alternative-a.png)


### `l.ss03` Single-footed l

![Wumpus Mono Alternative l](images/WumpusMono_Homoglyphs.png)

 _(The above shows the 400 Italic, and multiple weights below, which are not available in the evaluation version in this repository.  Please see [the typeface's site](https://vaughantype.com/wumpus-mono-pro) for more information.)_

<hr>

## ¶ Programming with Wumpus Mono

Many of the decisions that were made in the process of designing this font were made in consideration of how it might look when writing Perl programs, since that is often what takes up the majority of my screen's real-estate.

![Wumpus Mono Sample](images/WumpusMono_Sample.png)

Negative space is used to give extra personality to the `i`, `J`, and `j`:

![Wumpus Mono Negative Space](images/WumpusMono_Negative_Space.png)

## ¶ What's in a name?

Wumpus Mono is named after my friend [wumpus](https://github.com/wumpus) (the radio astronomer, not Discord's mascot.)  The name comes from [Hunt the Wumpus](https://en.wikipedia.org/wiki/Hunt_the_Wumpus) - a classic text-based adventure game you can play in your terminal.  It is a source of much inspiration.  If you haven't played it yet, you can do so on [Telehack](https://telehack.com).

![Wumpus Mono Asterisk](images/Asteroid.gif)

When asked how many lobes the asterisk should have:
```
wumpus: The number of sidelobes should be similar to astronomy
wumpus: JWST has 6
```

...indeed, the [James Webb Space Telescope](https://webb.nasa.gov/)'s primary mirror panels are hexagons.

Asterisk anatomy has been discussed in brilliant detail by Jonathan Hoefler in his blog post [“House of Flying Reference Marks”](https://www.typography.com/blog/house-of-flying-reference-marks).

## ¶ Ligatures

Wumpus Mono includes the following programming ligatures:

![Wumpus Mono Ligatures](images/WumpusMono_Ligatures.png)

... and the following common ligatures:

![Wumpus Mono Common Ligatures](images/WumpusMono_Common_Ligatures.png)

## ¶ License

The fonts in this repository are free for personal evaluation purposes.

Wumpus Mono Pro licenses are available for purchase from [vaughantype.com](https://vaughantype.com) and are licensed under the [Standard Vaughan Type End User Font License Version 1.0](https://vaughantype.com/standard-eula/).

Please [contact the author](mailto:fonts@vaughantype.com) for custom licensing if necessary.

<small>Copyright &copy; 2023 T. E. Vaughan // Vaughan Type. All rights reserved.</small>
