## NexaORM: Contributing Guidelines

We appreciate your interest in contributing to NexaORM! This page outlines the guidelines for contributing code, documentation, and other improvements to the project.

**How to Contribute:**

- **Issues:** Report bugs or request features by creating issues on the NexaORM GitHub repository: [https://github.com/v1p3r75/NexaORM/issues](https://github.com/v1p3r75/NexaORM/issues). 
- **Pull Requests:** Fork the NexaORM repository, make your changes, and submit a pull request for review. Ensure your pull request adheres to the coding style and includes clear documentation for any new features.

**Coding Standards:**

- Follow PSR-2 coding standards for consistent and readable code.
- Use meaningful variable and function names.
- Add comments to explain complex logic or non-obvious code sections.

**Documentation:**

- Improve existing documentation by fixing errors or adding clarity.
- Contribute new documentation for features or functionalities you introduce.
- Use clear and concise language with proper grammar.

**Contributor License Agreement:**

By submitting a contribution, you agree to the NexaORM Contributor License Agreement (CLA). The CLA can be found at [link to NexaORM CLA, if available. If not, remove this line]. 

**Getting Started:**

1. **Fork the NexaORM Repository:** Create a fork of the NexaORM repository on GitHub.
2. **Clone your Fork:** Clone your forked repository to your local machine.
3. **Create a Branch:** Create a new branch for your specific contribution.
4. **Make Changes:** Make your changes to the code or documentation.
5. **Commit Changes:** Commit your changes with clear commit messages.
6. **Push Changes:** Push your changes to your forked repository on GitHub.
7. **Create a Pull Request:** Create a pull request from your branch to the main NexaORM repository.

**Additional Tips:**

- **Unit Tests:** Consider adding unit tests for any new code you introduce.
- **Code Reviews:** Participate in code reviews for other pull requests to ensure overall code quality.
- **Stay Updated:** Follow the NexaORM project for updates and announcements.

**We welcome your contributions!**

By following these guidelines, you can help us make NexaORM a better and more valuable project for everyone. If you have any questions or need assistance, feel free to reach out to the project maintainers on the NexaORM GitHub repository.
