// RTOSDemo_text.c
// Generated by decompiling RTOSDemo.axf
// using Reko decompiler version 0.11.6.0.

#include "RTOSDemo.h"

// 00008000: void NmiSR()
void NmiSR()
{
	while (true)
		;
}

// 00008004: void FaultISR()
void FaultISR()
{
	while (true)
		;
}

// 00008008: void ResetISR(Register word32 cpsr)
void ResetISR(word32 cpsr)
{
	word32 * r3_n = g_ptr802C;
	word32 * r0_n = g_ptr8030;
	if (r3_n < r0_n)
	{
		word32 * r2_n = (word32 *) ((char *) r3_n + (((char *) r0_n + ~r3_n & ~0x03) + 0x04));
		do
		{
			*r3_n = 0x00;
			++r3_n;
		} while (r3_n != r2_n);
	}
	Main(cpsr);
}

word32 * g_ptr802C = &g_dw20000160; // 0000802C
word32 * g_ptr8030 = &g_dw20000880; // 00008030
// 00008034: void raise()
void raise()
{
	while (true)
		;
}

// 00008038: void vPrintTask(Register word32 cpsr)
void vPrintTask(word32 cpsr)
{
	ui32 r4_n = 0x00;
	union Eq_n * r5_n = g_ptr8064;
	while (true)
	{
		ptr32 fp;
		MPU_xQueueGenericReceive(r5_n->u1, fp - 20, ~0x00, 0x00, cpsr);
		OSRAMClear();
		++r4_n;
		byte * dwLoc14;
		OSRAMStringDraw(dwLoc14, r4_n & 0x3F, r4_n & 0x01);
	}
}

union Eq_n * g_ptr8064 = &g_t20000880; // 00008064
// 00008068: void vCheckTask(Register word32 cpsr)
void vCheckTask(word32 cpsr)
{
	MPU_xTaskGetTickCount(cpsr);
	union Eq_n * r5_n = g_ptr809C;
	while (true)
	{
		ptr32 fp;
		MPU_vTaskDelayUntil(fp - 24, 5000, cpsr);
		MPU_xQueueGenericSend(r5_n->u1, fp - 20, ~0x00, 0x00, cpsr);
	}
}

union Eq_n * g_ptr809C = &g_t20000880; // 0000809C
// 000080A0: void Main(Register word32 cpsr)
// Called from:
//      ResetISR
void Main(word32 cpsr)
{
	*g_ptr80F0 = MPU_xQueueGenericCreate(0x03, 0x04, cpsr);
	OSRAMInit(0x00);
	MPU_xTaskCreate(g_dw80F8, g_dw80F4, 0x3B, 0x00, cpsr, 0x03, null);
	MPU_xTaskCreate(g_dw8100, g_dw80FC, 0x3B, 0x00, cpsr, 0x02, null);
	vTaskStartScheduler(cpsr);
	OSRAMStringDraw(g_ptr8104, 0x00, 0x00);
	while (true)
		;
}

word32 * g_ptr80F0 = &g_dw20000880; // 000080F0
word32 g_dw80F4 = 0xA258; // 000080F4
ui32 g_dw80F8 = 0x8069; // 000080F8
word32 g_dw80FC = 0xA260; // 000080FC
ui32 g_dw8100 = 0x8039; // 00008100
byte * g_ptr8104 = &g_bA268; // 00008104
// 00008108: void vUART_ISR(Register word32 r4, Register word32 r5, Register word32 r6, Register word32 cpsr)
void vUART_ISR(word32 r4, word32 r5, word32 r6, word32 cpsr)
{
	Eq_n tLoc15;
	tLoc15.dw0005 = r4;
	tLoc15.dw0009 = r5;
	tLoc15.dw000D = r6;
	ptr32 %continuation;
	tLoc15.ptr0011 = %continuation;
	struct Eq_n * r5_n = g_ptr8174;
	tLoc15.dw0001 = 0x00;
	Eq_n r0_n = UARTIntStatus(r5_n, 0x01);
	UARTIntClear(r5_n, r0_n);
	if (r0_n << 27 < 0x00 && *g_ptr8178 << 25 < 0x00)
	{
		tLoc15.t0000.u0 = r5_n->t0000.u0;
		xQueueGenericSendFromISR(&tLoc15, r0_n, 0x00, cpsr);
	}
	if (r0_n << 26 < 0x00)
	{
		byte * r2_n = g_ptr817C;
		Eq_n r3_n = (word32) *r2_n;
		if (r3_n <= 122)
		{
			ui32 r1_n = *g_ptr8178;
			struct Eq_n * r1_n = r1_n << 26;
			if (r1_n << 26 >= 0x00)
				r1_n = g_ptr8174;
			r1_n->t0000.u1 = (up32) r3_n;
			*r2_n = (byte) r3_n + 0x01;
		}
	}
	if (tLoc15.dw0001 != 0x00)
		*g_ptr8180 = 0x10000000;
}

struct Eq_n * g_ptr8174 = &g_t4000C000; // 00008174
ui32 * g_ptr8178 = &g_dw4000C018; // 00008178
byte * g_ptr817C = &g_b2000022C; // 0000817C
word32 * g_ptr8180 = &g_dwE000ED04; // 00008180
// 00008184: void vSetErrorLED(Register word32 cpsr)
// Called from:
//      prvSetAndCheckRegisters
void vSetErrorLED(word32 cpsr)
{
	vParTestSetLED(0x07, 0x01, cpsr);
}

// 0000818C: Register word32 prvSetAndCheckRegisters(Register word32 cpsr, Register out word32 r5Out, Register out word32 r6Out, Register out word32 r7Out, Register out word32 r8Out)
// Called from:
//      vApplicationIdleHook
word32 prvSetAndCheckRegisters(word32 cpsr, word32 & r5Out, word32 & r6Out, word32 & r7Out, word32 & r8Out)
{
	if (true && (true && (true && (true && (true && (true && (true && (true && (true && (true && (true && (true && true))))))))))))
		return;
	vSetErrorLED(cpsr);
	return;
}

// 00008210: void vApplicationIdleHook(Register word32 r4, Register word32 r5, Register word32 r6, Register word32 r7, Register word32 r8, Register word32 cpsr)
// Called from:
//      prvIdleTask
void vApplicationIdleHook(word32 r4, word32 r5, word32 r6, word32 r7, word32 r8, word32 cpsr)
{
	while (true)
	{
		cpsr = vCoRoutineSchedule(r4, r5, r6, r7, r8, cpsr);
		r4 = prvSetAndCheckRegisters(cpsr, out r5, out r6, out r7, out r8);
	}
}

// 00008220: void PDCInit()
// Called from:
//      vParTestInitialise
void PDCInit()
{
	SysCtlPeripheralEnable(g_dw828C);
	SysCtlPeripheralEnable(g_dw8290);
	GPIODirModeSet((struct Eq_n *) 0x40004000, 0x34, 0x02);
	GPIODirModeSet((struct Eq_n *) 0x40004000, 0x08, 0x01);
	GPIOPadConfigSet((struct Eq_n *) 0x40004000, 0x04, 0x02, 0x0A);
	struct Eq_n * r5_n = g_ptr8294;
	SSIConfig(r5_n, 0x00, 0x00, g_dw8298, 0x08);
	SSIEnable(r5_n);
	GPIOPinWrite((word32 (*)[]) 0x40004000, 0x08, 0x00);
	GPIOPinWrite((word32 (*)[]) 0x40004000, 0x08, 0x08);
}

uint32 g_dw828C = 0x10000010; // 0000828C
uint32 g_dw8290 = 0x20000001; // 00008290
struct Eq_n * g_ptr8294 = &g_t40008000; // 00008294
uint32 g_dw8298 = 1000000; // 00008298
// 0000829C: void PDCWrite(Register ui32 r0, Register ui32 r1)
// Called from:
//      vParTestInitialise
//      vParTestSetLED
//      vParTestToggleLED
void PDCWrite(ui32 r0, ui32 r1)
{
	struct Eq_n * r4_n = g_ptr82CC;
	SSIDataPut(r4_n, r0 & 0x0F);
	SSIDataPut(r4_n, r1);
	Eq_n tLoc14;
	SSIDataGet(r4_n, &tLoc14);
	SSIDataGet(r4_n, &tLoc14);
}

struct Eq_n * g_ptr82CC = &g_t40008000; // 000082CC
// 000082D0: void vListInitialise(Register (ptr32 Eq_n) r0)
// Called from:
//      xQueueGenericReset
//      prvAddNewTaskToReadyList
//      xEventGroupCreate
//      xCoRoutineCreate
void vListInitialise(struct Eq_n * r0)
{
	r0->dw0008 = ~0x00;
	r0->dw0000 = 0x00;
	r0->ptr0004 = &r0->dw0008;
	r0->ptr000C = &r0->dw0008;
	r0->ptr0010 = &r0->dw0008;
}

// 000082E8: void vListInitialiseItem(Register (ptr32 Eq_n) r0)
// Called from:
//      prvInitialiseNewTask
//      xCoRoutineCreate
void vListInitialiseItem(struct Eq_n * r0)
{
	r0->dw0010 = 0x00;
}

// 000082F0: void vListInsertEnd(Register (ptr32 Eq_n) r0, Register (ptr32 Eq_n) r1)
// Called from:
//      prvAddNewTaskToReadyList
//      xTaskGenericNotify
//      xTaskGenericNotifyFromISR
//      vTaskNotifyGiveFromISR
//      xTaskIncrementTick
//      xTaskResumeAll
//      vTaskPlaceOnUnorderedEventList
//      xTaskRemoveFromEventList
//      xTaskRemoveFromUnorderedEventList
//      vTaskPriorityInherit
//      xTaskPriorityDisinherit
//      xCoRoutineCreate
//      vCoRoutineSchedule
//      xCoRoutineRemoveFromEventList
void vListInsertEnd(struct Eq_n * r0, struct Eq_n * r1)
{
	struct Eq_n * r3_n = r0->ptr0004;
	word32 r2_n = r0->dw0000;
	r1->ptr0008 = r3_n->ptr0008;
	struct Eq_n * r4_n = r3_n->ptr0008;
	r1->ptr0004 = r3_n;
	r4_n->ptr0004 = r1;
	r3_n->ptr0008 = r1;
	r1->ptr0010 = r0;
	r0->dw0000 = r2_n + 0x01;
}

// 0000830C: FlagGroup bool vListInsert(Register (ptr32 Eq_n) r0, Register (ptr32 Eq_n) r1)
// Called from:
//      prvAddCurrentTaskToDelayedList.isra.0
//      vTaskPlaceOnEventList
//      vCoRoutineAddToDelayedList
bool vListInsert(struct Eq_n * r0, struct Eq_n * r1)
{
	up32 r5_n = r1->dw0000;
	bool Z;
	struct Eq_n * r2_n;
	struct Eq_n * r3_n;
	if (!Z)
	{
		r2_n = (struct Eq_n *) (&r0->dw0000 + 2);
		while (true)
		{
			r3_n = r2_n->ptr0004;
			if (r5_n < r3_n->dw0000)
				break;
			r2_n = r3_n;
		}
	}
	else
	{
		r2_n = r0->ptr0010;
		r3_n = r2_n->ptr0004;
	}
	word32 r4_n = r0->dw0000;
	r1->ptr0004 = r3_n;
	r3_n->ptr0008 = r1;
	r1->ptr0008 = r2_n;
	r2_n->ptr0004 = r1;
	r1->ptr0010 = r0;
	r0->dw0000 = r4_n + 0x01;
	return (cond(r4_n + 0x01) & 0x04) != 0x00;
}

// 00008340: Register (ptr32 Eq_n) uxListRemove(Register (ptr32 Eq_n) r0)
// Called from:
//      prvAddCurrentTaskToDelayedList.isra.0
//      xTaskGenericNotify
//      xTaskGenericNotifyFromISR
//      vTaskNotifyGiveFromISR
//      xTaskIncrementTick
//      xTaskResumeAll
//      xTaskRemoveFromEventList
//      xTaskRemoveFromUnorderedEventList
//      vTaskPriorityInherit
//      xTaskPriorityDisinherit
//      vCoRoutineAddToDelayedList
//      vCoRoutineSchedule
//      xCoRoutineRemoveFromEventList
struct Eq_n * uxListRemove(struct Eq_n * r0)
{
	struct Eq_n * r2_n = r0->ptr0010;
	struct Eq_n * r3_n = r0->ptr0004;
	r3_n->ptr0008 = r0->ptr0008;
	struct Eq_n * r4_n = r2_n->ptr0004;
	struct Eq_n * r1_n = r0->ptr0008;
	r1_n->ptr0004 = r3_n;
	if (r0 == r4_n)
		r2_n->ptr0004 = r1_n;
	word32 r3_n = r2_n->dw0000;
	r0->ptr0010 = null;
	r2_n->dw0000 = r3_n - 0x01;
	return r3_n - 0x01;
}

// 00008364: FlagGroup bool xQueueCRSend(Register Eq_n r0, Register Eq_n r1, Register Eq_n r2, Register word32 cpsr, Register out Eq_n r0Out)
// Called from:
//      prvFixedDelayCoRoutine
bool xQueueCRSend(Eq_n r0, Eq_n r1, Eq_n r2, word32 cpsr, union Eq_n & r0Out)
{
	__msr(cpsr, 191);
	__instruction_sync_barrier("sy");
	__data_sync_barrier("sy");
	vPortEnterCritical(cpsr);
	if (*((word32) r0 + 56) == *((word32) r0 + 60))
	{
		Eq_n Z_n = vPortExitCritical(cpsr);
		if (r2 != 0x00)
		{
			Eq_n Z_n = vCoRoutineAddToDelayedList(r2, (word32) r0 + 16);
			__msr(cpsr, 0x00);
			r0Out.u0 = ~0x03;
			return Z_n != 0x00;
		}
		else
		{
			__msr(cpsr, r2);
			r0Out = r2;
			return Z_n != 0x00;
		}
	}
	vPortExitCritical(cpsr);
	__msr(cpsr, 0x00);
	__msr(cpsr, 191);
	__instruction_sync_barrier("sy");
	__data_sync_barrier("sy");
	Eq_n r2_n = *((word32) r0 + 56);
	Eq_n r3_n = *((word32) r0 + 60);
	Eq_n r0_n;
	r0_n.u0 = 0x00;
	Eq_n Z_n = cond(r2_n - r3_n) & 0x04;
	if (r2_n < r3_n)
	{
		word32 r0_n;
		word32 r7_n;
		Z_n = prvCopyDataToQueue(r0, r1, 0x00, out r0_n, out r7_n);
		if (*((word32) r0 + 36) != 0x00)
		{
			word32 r0_n;
			xCoRoutineRemoveFromEventList((word32) r0 + 36, out r0_n);
			Z_n = cond(r0_n - 0x00) & 0x04;
			if (r0_n != 0x00)
			{
				r0_n.u0 = ~0x04;
				goto l000083AA;
			}
		}
		__msr(cpsr, 0x00);
		r0Out.u0 = 0x01;
		return Z_n != 0x00;
	}
	else
	{
l000083AA:
		__msr(cpsr, 0x00);
		r0Out = r0_n;
		return Z_n != 0x00;
	}
}

// 00008400: FlagGroup Eq_n xQueueCRReceive(Register (ptr32 Eq_n) r0, Register Eq_n r1, Register Eq_n r2, Register word32 cpsr, Register out Eq_n r0Out, Register out ptr32 r6Out)
// Called from:
//      prvFlashCoRoutine
Eq_n xQueueCRReceive(struct Eq_n * r0, Eq_n r1, Eq_n r2, word32 cpsr, union Eq_n & r0Out, ptr32 & r6Out)
{
	word32 r7_n;
	word32 r5_n;
	struct Eq_n * r4_n;
	__msr(cpsr, 191);
	__instruction_sync_barrier("sy");
	__data_sync_barrier("sy");
	Eq_n r5_n;
	r5_n.u0 = r0->t0038.u0;
	ptr32 r6;
	if (r5_n == 0x00)
	{
		Eq_n NZCV_n;
		NZCV_n.u1 = cond(r2 - 0x00);
		if (r2 != 0x00)
		{
			Eq_n Z_n = vCoRoutineAddToDelayedList(r2, (char *) &r0->t000C + 24);
			__msr(cpsr, r5_n);
			r0Out.u0 = ~0x03;
			r6Out = r6;
			return Z_n != 0x00;
		}
		else
		{
			__msr(cpsr, r2);
			r0Out = r2;
			r6Out = r6;
			return (NZCV_n & 0x04) != 0x00;
		}
	}
	__msr(cpsr, 0x00);
	__msr(cpsr, 191);
	__instruction_sync_barrier("sy");
	__data_sync_barrier("sy");
	Eq_n r2_n;
	r2_n.u0 = r0->t0038.u0;
	Eq_n r0_n;
	if (r2_n != 0x00)
	{
		Eq_n r2_n;
		r2_n.u1 = r0->t0040.u1;
		Eq_n r3_n;
		r3_n.u1 = r0->t0004.u1;
		Eq_n r1_n;
		r1_n.u1 = r0->t000C.u1 + r2_n;
		Eq_n r3_n;
		r3_n.u0 = r0->t0038.u0;
		r0->t000C.u1 = (struct Eq_n *) r1_n;
		Eq_n r1_n = r1_n;
		if (r1_n >= r3_n)
			r1_n.u1 = r0->t0000.u1;
		r0->t0038.u0 = (word32) r3_n - 1;
		if (r1_n >= r3_n)
			r0->t000C.u1 = (struct Eq_n *) r1_n;
		Eq_n Z = memcpy(r1, r1_n, r2_n, out r4_n, out r5_n, out r6, out r7_n);
		if (r4_n->dw0010 != 0x00)
		{
			word32 r0_n;
			xCoRoutineRemoveFromEventList(&r4_n->dw0010, out r0_n);
			Z = cond(r0_n - 0x00) & 0x04;
			if (r0_n != 0x00)
			{
				r0_n.u0 = ~0x04;
l00008440:
				__msr(cpsr, 0x00);
				r0Out = r0_n;
				r6Out = r6;
				return Z != 0x00;
			}
		}
		__msr(cpsr, 0x00);
		r0Out.u0 = 0x01;
		r6Out = r6;
		return Z != 0x00;
	}
	else
	{
		r0_n = r2_n;
		goto l00008440;
	}
}

// 000084A0: void xQueueCRSendFromISR(Register Eq_n r0, Register Eq_n r1, Register word32 r2)
void xQueueCRSendFromISR(Eq_n r0, Eq_n r1, word32 r2)
{
	if (*((word32) r0 + 56) < *((word32) r0 + 60))
	{
		word32 r0_n;
		word32 r7_n;
		prvCopyDataToQueue(r0, r1, 0x00, out r0_n, out r7_n);
		if (r2 == 0x00 && *((word32) r0 + 36) != 0x00)
		{
			word32 r0_n;
			xCoRoutineRemoveFromEventList((word32) r0 + 36, out r0_n);
		}
	}
}

// 000084D4: void xQueueCRReceiveFromISR(Register (ptr32 Eq_n) r0, Register Eq_n r1)
void xQueueCRReceiveFromISR(struct Eq_n * r0, Eq_n r1)
{
	if (r0->dw0038 == 0x00)
		return;
	Eq_n lr_n;
	lr_n.u1 = r0->t0040.u1;
	Eq_n r4_n;
	r4_n.u1 = r0->t0004.u1;
	Eq_n r3_n;
	r3_n.u1 = r0->t000C.u1 + lr_n;
	word32 r7_n = r0->dw0038;
	r0->t000C.u1 = (struct Eq_n *) r3_n;
	Eq_n r3_n = r3_n;
	if (r3_n >= r4_n)
		r3_n.u1 = r0->t0000.u1;
	if (r3_n >= r4_n)
		r0->t000C.u1 = (struct Eq_n *) r3_n;
	r0->dw0038 = r7_n + ~0x00;
	struct Eq_n * r4_n;
	word32 * r5_n;
	word32 r6_n;
	word32 r7_n;
	memcpy(r1, r3_n, lr_n, out r4_n, out r5_n, out r6_n, out r7_n);
	if (*r5_n != 0x00 || r4_n->dw0010 == 0x00)
		return;
	word32 r0_n;
	xCoRoutineRemoveFromEventList(&r4_n->dw0010, out r0_n);
	if (r0_n == 0x00)
		return;
	*r5_n = 0x01;
}

// 0000852C: void prvIdleTask(Register word32 r4, Register word32 r5, Register word32 r6, Register word32 r7, Register word32 r8, Register word32 cpsr)
void prvIdleTask(word32 r4, word32 r5, word32 r6, word32 r7, word32 r8, word32 cpsr)
{
	vApplicationIdleHook(r4, r5, r6, r7, r8, cpsr);
}

// 00008534: void xTaskNotifyStateClear(Register (ptr32 Eq_n) r0, Register word32 cpsr)
// Called from:
//      MPU_xTaskNotifyStateClear
void xTaskNotifyStateClear(struct Eq_n * r0, word32 cpsr)
{
	struct Eq_n * r4_n;
	if (r0 != null)
		r4_n = r0;
	else
		r4_n = g_ptr8560->ptr0004;
	vPortEnterCritical(cpsr);
	word32 r3_n = (word32) r4_n->b0064;
	if (r3_n == 0x02)
		r3_n = 0x00;
	r4_n->b0064 = (byte) r3_n;
	vPortExitCritical(cpsr);
}

struct Eq_n * g_ptr8560 = &g_t200000C4; // 00008560
// 00008564: Register word32 xPortRaisePrivilege(Register word32 cpsr)
// Called from:
//      vPortEnterCritical
//      vPortExitCritical
//      MPU_xTaskCreateRestricted
//      MPU_xTaskCreate
//      MPU_vTaskAllocateMPURegions
//      MPU_vTaskDelayUntil
//      MPU_vTaskDelay
//      MPU_vTaskSuspendAll
//      MPU_xTaskResumeAll
//      MPU_xTaskGetTickCount
//      MPU_uxTaskGetNumberOfTasks
//      MPU_pcTaskGetName
//      MPU_vTaskSetTimeOutState
//      MPU_xTaskCheckForTimeOut
//      MPU_xTaskGenericNotify
//      MPU_xTaskNotifyWait
//      MPU_ulTaskNotifyTake
//      MPU_xTaskNotifyStateClear
//      MPU_xQueueGenericCreate
//      MPU_xQueueGenericReset
//      MPU_xQueueGenericSend
//      MPU_uxQueueMessagesWaiting
//      MPU_uxQueueSpacesAvailable
//      MPU_xQueueGenericReceive
//      MPU_xQueuePeekFromISR
//      MPU_xQueueGetMutexHolder
//      MPU_xQueueCreateMutex
//      MPU_xQueueTakeMutexRecursive
//      MPU_xQueueGiveMutexRecursive
//      MPU_vQueueDelete
//      MPU_pvPortMalloc
//      MPU_vPortFree
//      MPU_vPortInitialiseBlocks
//      MPU_xPortGetFreeHeapSize
//      MPU_xEventGroupCreate
//      MPU_xEventGroupWaitBits
//      MPU_xEventGroupClearBits
//      MPU_xEventGroupSetBits
//      MPU_xEventGroupSync
//      MPU_vEventGroupDelete
word32 xPortRaisePrivilege(word32 cpsr)
{
	(__mrs(cpsr) & 0x01) == 0x00;
	__syscall<word32>(0x02);
	return 0x01;
}

// 00008578: void vPortEnterCritical(Register word32 cpsr)
// Called from:
//      prvUnlockQueue
//      xQueueGenericSend
//      xQueueGenericReceive
//      uxQueueMessagesWaiting
//      uxQueueSpacesAvailable
//      xQueueGetMutexHolder
//      xQueueGenericReset
//      prvAddNewTaskToReadyList
//      xTaskGenericNotify
//      xTaskNotifyWait
//      ulTaskNotifyTake
//      xTaskResumeAll
//      xTaskCheckForTimeOut
//      xEventGroupWaitBits
//      xEventGroupClearBits
//      xEventGroupSync
//      vEventGroupClearBitsCallback
//      xQueueCRSend
//      xTaskNotifyStateClear
void vPortEnterCritical(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	__msr(cpsr, 191);
	__instruction_sync_barrier("sy");
	__data_sync_barrier("sy");
	word32 * r2_n = g_ptr85AC;
	++*r2_n;
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

word32 * g_ptr85AC = &g_dw200000BC; // 000085AC
// 000085B0: FlagGroup bool vPortExitCritical(Register word32 cpsr)
// Called from:
//      prvUnlockQueue
//      xQueueGenericSend
//      xQueueGenericReceive
//      uxQueueMessagesWaiting
//      uxQueueSpacesAvailable
//      xQueueGetMutexHolder
//      xQueueGenericReset
//      prvAddNewTaskToReadyList
//      xTaskGenericNotify
//      xTaskNotifyWait
//      ulTaskNotifyTake
//      xTaskResumeAll
//      xTaskCheckForTimeOut
//      xEventGroupWaitBits
//      xEventGroupClearBits
//      xEventGroupSync
//      vEventGroupClearBitsCallback
//      xQueueCRSend
//      xTaskNotifyStateClear
bool vPortExitCritical(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	word32 * r2_n = g_ptr85D8;
	word32 r3_n = *r2_n;
	*r2_n = r3_n - 0x01;
	if (r3_n == 0x01)
		__msr(cpsr, r3_n - 0x01);
	Eq_n NZCV_n;
	NZCV_n.u1 = cond(r0_n - 0x01);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
	return (NZCV_n & 0x04) != 0x00;
}

word32 * g_ptr85D8 = &g_dw200000BC; // 000085D8
// 000085DC: void vParTestInitialise()
void vParTestInitialise()
{
	PDCInit();
	ui32 r1_n = (word32) *g_ptr85F0;
	PDCWrite(0x05, r1_n);
}

byte * g_ptr85F0 = &g_b200007F4; // 000085F0
// 000085F4: void vParTestSetLED(Register up32 r0, Register word32 r1, Register word32 cpsr)
// Called from:
//      vSetErrorLED
void vParTestSetLED(up32 r0, word32 r1, word32 cpsr)
{
	MPU_vTaskSuspendAll(cpsr);
	if (r0 <= 0x07)
	{
		byte * r3_n = g_ptr862C;
		uint32 r0_n = (uint32) (0x01 << (byte) r0);
		ui32 r2_n = (word32) *r3_n;
		if (r1 != 0x00)
			*r3_n = (byte) (r0_n | r2_n);
		else
			*r3_n = (byte) (r2_n & ~r0_n);
		PDCWrite(0x05, (word32) *r3_n);
	}
	MPU_xTaskResumeAll(cpsr);
}

byte * g_ptr862C = &g_b200007F4; // 0000862C
// 00008630: void vParTestToggleLED(Register up32 r0, Register word32 cpsr)
// Called from:
//      prvFlashCoRoutine
void vParTestToggleLED(up32 r0, word32 cpsr)
{
	MPU_vTaskSuspendAll(cpsr);
	if (r0 <= 0x07)
	{
		ui32 r0_n = 0x01 << r0;
		byte * r3_n = g_ptr866C;
		uint32 r2_n = (uint32) (byte) r0_n;
		if ((r2_n & (word32) (*r3_n)) == 0x00)
			*r3_n = (byte) r2_n | *r3_n;
		else
			*r3_n &= (byte) ~r0_n;
		PDCWrite(0x05, (word32) *r3_n);
	}
	MPU_xTaskResumeAll(cpsr);
}

byte * g_ptr866C = &g_b200007F4; // 0000866C
// 00008670: void prvFlashCoRoutine(Register (ptr32 Eq_n) r0, Register word32 cpsr)
void prvFlashCoRoutine(struct Eq_n * r0, word32 cpsr)
{
	word32 r3_n = (word32) r0->w0034;
	struct Eq_n ** r5_n;
	Eq_n r6_n;
	ptr32 fp;
	word32 r0_n;
	if (r3_n != 0x01C2)
	{
		if (r3_n == 0x01C3)
		{
			r5_n = g_ptr86E0;
			r6_n = fp - 20;
			goto l00008690;
		}
		if (r3_n != 0x00)
			return;
		r5_n = g_ptr86E0;
		r6_n = fp - 20;
l00008696:
		Eq_n Z_n = xQueueCRReceive(*r5_n, r6_n, ~0x00, cpsr, out r0_n, out r6_n);
		if (Z_n)
		{
			r0->w0034 = 0x01C2;
			return;
		}
		if (!Z_n)
		{
l000086AA:
			if (r0_n != 0x01)
			{
				*g_ptr86E4 = 0x00;
				goto l00008696;
			}
l00008690:
			up32 dwLoc14;
			vParTestToggleLED(dwLoc14, cpsr);
			goto l00008696;
		}
	}
	else
	{
		r5_n = g_ptr86E0;
		if (xQueueCRReceive(*r5_n, fp - 20, 0x00, cpsr, out r0_n, out r6_n))
			goto l000086AA;
	}
	r0->w0034 = 0x01C3;
}

struct Eq_n ** g_ptr86E0 = &g_ptr200007F8; // 000086E0
word32 * g_ptr86E4 = &g_dw200000C0; // 000086E4
// 000086E8: void prvFixedDelayCoRoutine(Register (ptr32 Eq_n) r0, Register ui32 r1, Register word32 cpsr)
void prvFixedDelayCoRoutine(struct Eq_n * r0, ui32 r1, word32 cpsr)
{
	up32 r3_n = (word32) r0->w0034;
	ptr32 fp;
	word32 r0_n;
	Eq_n v24_n;
	if (r3_n != 0x0182)
	{
		if (r3_n > 0x0182)
		{
			if (r3_n == 0x0183)
				goto l00008702;
			if (r3_n != 0x0196)
				return;
		}
		else if (r3_n != 0x00)
			return;
		Eq_n Z_n = xQueueCRSend(g_ptr877C->u1, fp - 0x0C, 0x00, cpsr, out r0_n);
		v24_n = Z_n;
		if (Z_n)
		{
			r0->w0034 = 0x0182;
			return;
		}
	}
	else
		v24_n = xQueueCRSend(g_ptr877C->u1, fp - 0x0C, 0x00, cpsr, out r0_n);
	if (v24_n)
	{
		r0->w0034 = 0x0183;
		return;
	}
	Eq_n r0_n;
	if (r0_n != 0x01)
	{
		*g_ptr8780 = 0x00;
		r0_n.u0 = g_ptr8778[r1].u0;
		if (r0_n == 0x00)
		{
l0000870C:
			r0->w0034 = 0x0196;
			return;
		}
l0000875E:
		vCoRoutineAddToDelayedList(r0_n, null);
		goto l0000870C;
	}
l00008702:
	r0_n.u0 = g_ptr8778[r1].u0;
	if (r0_n == 0x00)
		goto l0000870C;
	goto l0000875E;
}

Eq_n (* g_ptr8778)[] = &g_aA284; // 00008778
union Eq_n * g_ptr877C = &g_t200007F8; // 0000877C
word32 * g_ptr8780 = &g_dw200000C0; // 00008780
// 00008784: void vStartFlashCoRoutines(Register Eq_n r0, Register word32 cpsr)
void vStartFlashCoRoutines(Eq_n r0, word32 cpsr)
{
	if (r0 >= 0x08)
		r0.u0 = 0x08;
	word32 r0_n = MPU_xQueueGenericCreate(0x01, 0x04, cpsr);
	*g_ptr87C4 = r0_n;
	if (r0_n == 0x00)
		return;
	if (r0 != 0x00)
	{
		Eq_n r4_n;
		r4_n.u0 = 0x00;
		Eq_n r6_n;
		r6_n.u1 = g_t87C8.u1;
		do
		{
			xCoRoutineCreate(r6_n, 0x00, r4_n, cpsr);
			r4_n.u1 = (word32) r4_n + 1;
		} while (r4_n != r0);
	}
	Eq_n r0_n;
	r0_n.u1 = g_t87CC.u1;
	xCoRoutineCreate(r0_n, 0x01, 0x00, cpsr);
}

word32 * g_ptr87C4 = &g_dw200007F8; // 000087C4
Eq_n g_t87C8 = // 000087C8
	{
		233
	};
Eq_n g_t87CC = // 000087CC
	{
		113
	};
// 000087D0: void xAreFlashCoRoutinesStillRunning()
void xAreFlashCoRoutinesStillRunning()
{
}

// 000087DC: void MPU_xTaskCreateRestricted(Register (ptr32 Eq_n) r0, Register (ptr32 Eq_n) r1, Register word32 cpsr)
void MPU_xTaskCreateRestricted(struct Eq_n * r0, union Eq_n * r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xTaskCreateRestricted(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008808: void MPU_xTaskCreate(Register ui32 r0, Register word32 r1, Register ui32 r2, Register word32 r3, Register word32 cpsr, Stack int32 dwArg00, Stack (ptr32 Eq_n) dwArg04)
// Called from:
//      ResetISR
void MPU_xTaskCreate(ui32 r0, word32 r1, ui32 r2, word32 r3, word32 cpsr, int32 dwArg00, union Eq_n * dwArg04)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xTaskCreate(r0, r1, r2, r3, cpsr, dwArg00, dwArg04);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 0000884C: void MPU_vTaskAllocateMPURegions(Register word32 r0, Register (ptr32 Eq_n) r1, Register word32 cpsr)
void MPU_vTaskAllocateMPURegions(word32 r0, struct Eq_n * r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	vTaskAllocateMPURegions(r0, r1);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008874: void MPU_vTaskDelayUntil(Register (ptr32 up32) r0, Register word32 r1, Register word32 cpsr)
// Called from:
//      vCheckTask
void MPU_vTaskDelayUntil(up32 * r0, word32 r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	vTaskDelayUntil(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 0000889C: void MPU_vTaskDelay(Register up32 r0, Register word32 cpsr)
void MPU_vTaskDelay(up32 r0, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	vTaskDelay(r0, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 000088C0: void MPU_vTaskSuspendAll(Register word32 cpsr)
// Called from:
//      vParTestSetLED
//      vParTestToggleLED
void MPU_vTaskSuspendAll(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	vTaskSuspendAll();
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 000088E0: void MPU_xTaskResumeAll(Register word32 cpsr)
// Called from:
//      vParTestSetLED
//      vParTestToggleLED
void MPU_xTaskResumeAll(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xTaskResumeAll(cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008904: Register word32 MPU_xTaskGetTickCount(Register word32 cpsr)
// Called from:
//      vCheckTask
//      vCoRoutineSchedule
word32 MPU_xTaskGetTickCount(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	word32 r0_n = xTaskGetTickCount();
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
	return r0_n;
}

// 00008928: void MPU_uxTaskGetNumberOfTasks(Register word32 cpsr)
void MPU_uxTaskGetNumberOfTasks(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	uxTaskGetNumberOfTasks();
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 0000894C: void MPU_pcTaskGetName(Register word32 r0, Register word32 cpsr)
void MPU_pcTaskGetName(word32 r0, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	pcTaskGetName(r0);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008974: void MPU_vTaskSetTimeOutState(Register (ptr32 Eq_n) r0, Register word32 cpsr)
void MPU_vTaskSetTimeOutState(struct Eq_n * r0, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	vTaskSetTimeOutState(r0);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008998: void MPU_xTaskCheckForTimeOut(Register (ptr32 Eq_n) r0, Register (ptr32 up32) r1, Register word32 cpsr)
void MPU_xTaskCheckForTimeOut(struct Eq_n * r0, up32 * r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xTaskCheckForTimeOut(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 000089C4: void MPU_xTaskGenericNotify(Register (ptr32 Eq_n) r0, Register ui32 r1, Register up32 r2, Register (ptr32 ui32) r3, Register word32 cpsr)
void MPU_xTaskGenericNotify(struct Eq_n * r0, ui32 r1, up32 r2, ui32 * r3, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xTaskGenericNotify(r0, r1, r2, r3, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 000089FC: void MPU_xTaskNotifyWait(Register word32 r0, Register word32 r1, Register (ptr32 ui32) r2, Register up32 r3, Register word32 cpsr)
void MPU_xTaskNotifyWait(word32 r0, word32 r1, ui32 * r2, up32 r3, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xTaskNotifyWait(r0, r1, r2, r3, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008A34: void MPU_ulTaskNotifyTake(Register word32 r0, Register up32 r1, Register word32 cpsr)
void MPU_ulTaskNotifyTake(word32 r0, up32 r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	ulTaskNotifyTake(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008A60: void MPU_xTaskNotifyStateClear(Register (ptr32 Eq_n) r0, Register word32 cpsr)
void MPU_xTaskNotifyStateClear(struct Eq_n * r0, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xTaskNotifyStateClear(r0, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008A88: Register Eq_n MPU_xQueueGenericCreate(Register Eq_n r0, Register Eq_n r1, Register word32 cpsr)
// Called from:
//      ResetISR
//      vStartFlashCoRoutines
Eq_n MPU_xQueueGenericCreate(Eq_n r0, Eq_n r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	Eq_n r0_n = xQueueGenericCreate(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
	return r0_n;
}

// 00008AB8: void MPU_xQueueGenericReset(Register Eq_n r0, Register word32 r1, Register word32 cpsr)
void MPU_xQueueGenericReset(Eq_n r0, word32 r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xQueueGenericReset(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008AE4: void MPU_xQueueGenericSend(Register Eq_n r0, Register Eq_n r1, Register word32 r2, Register word32 r3, Register word32 cpsr)
// Called from:
//      vCheckTask
void MPU_xQueueGenericSend(Eq_n r0, Eq_n r1, word32 r2, word32 r3, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xQueueGenericSend(r0, r1, r2, r3, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008B1C: void MPU_uxQueueMessagesWaiting(Register word32 cpsr)
void MPU_uxQueueMessagesWaiting(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	uxQueueMessagesWaiting(cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008B44: void MPU_uxQueueSpacesAvailable(Register word32 cpsr)
void MPU_uxQueueSpacesAvailable(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	uxQueueSpacesAvailable(cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008B6C: void MPU_xQueueGenericReceive(Register Eq_n r0, Register Eq_n r1, Register word32 r2, Register word32 r3, Register word32 cpsr)
// Called from:
//      vPrintTask
void MPU_xQueueGenericReceive(Eq_n r0, Eq_n r1, word32 r2, word32 r3, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xQueueGenericReceive(r0, r1, r2, r3, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008BA4: void MPU_xQueuePeekFromISR(Register Eq_n r0, Register Eq_n r1, Register word32 cpsr)
void MPU_xQueuePeekFromISR(Eq_n r0, Eq_n r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xQueuePeekFromISR(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008BD0: void MPU_xQueueGetMutexHolder(Register (ptr32 word32) r0, Register word32 cpsr)
void MPU_xQueueGetMutexHolder(word32 * r0, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xQueueGetMutexHolder(r0, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008BF8: void MPU_xQueueCreateMutex(Register word32 cpsr)
void MPU_xQueueCreateMutex(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xQueueCreateMutex(cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008C20: void MPU_xQueueTakeMutexRecursive(Register Eq_n r0, Register word32 r1, Register word32 cpsr)
void MPU_xQueueTakeMutexRecursive(Eq_n r0, word32 r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xQueueTakeMutexRecursive(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008C4C: void MPU_xQueueGiveMutexRecursive(Register Eq_n r0, Register word32 cpsr)
void MPU_xQueueGiveMutexRecursive(Eq_n r0, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xQueueGiveMutexRecursive(r0, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008C74: void MPU_vQueueDelete(Register word32 cpsr)
void MPU_vQueueDelete(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	vQueueDelete();
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008C98: void MPU_pvPortMalloc(Register ui32 r0, Register word32 cpsr)
void MPU_pvPortMalloc(ui32 r0, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	pvPortMalloc(r0, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008CC0: void MPU_vPortFree(Register word32 cpsr)
void MPU_vPortFree(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	vPortFree();
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008CE4: void MPU_vPortInitialiseBlocks(Register word32 cpsr)
void MPU_vPortInitialiseBlocks(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	vPortInitialiseBlocks();
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008D04: void MPU_xPortGetFreeHeapSize(Register word32 cpsr)
void MPU_xPortGetFreeHeapSize(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xPortGetFreeHeapSize();
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008D28: void MPU_xEventGroupCreate(Register word32 cpsr)
void MPU_xEventGroupCreate(word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xEventGroupCreate(cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008D4C: void MPU_xEventGroupWaitBits(Register (ptr32 ui32) r0, Register ui32 r1, Register word32 r2, Register word32 r3, Register word32 cpsr, Stack up32 dwArg00)
void MPU_xEventGroupWaitBits(ui32 * r0, ui32 r1, word32 r2, word32 r3, word32 cpsr, up32 dwArg00)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xEventGroupWaitBits(r0, r1, r2, r3, cpsr, dwArg00);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008D8C: void MPU_xEventGroupClearBits(Register (ptr32 ui32) r0, Register word32 r1, Register word32 cpsr)
void MPU_xEventGroupClearBits(ui32 * r0, word32 r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xEventGroupClearBits(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008DB8: void MPU_xEventGroupSetBits(Register (ptr32 Eq_n) r0, Register ui32 r1, Register word32 cpsr)
void MPU_xEventGroupSetBits(struct Eq_n * r0, ui32 r1, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xEventGroupSetBits(r0, r1, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008DE4: void MPU_xEventGroupSync(Register (ptr32 Eq_n) r0, Register ui32 r1, Register ui32 r2, Register up32 r3, Register word32 cpsr)
void MPU_xEventGroupSync(struct Eq_n * r0, ui32 r1, ui32 r2, up32 r3, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	xEventGroupSync(r0, r1, r2, r3, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008E1C: void MPU_vEventGroupDelete(Register (ptr32 Eq_n) r0, Register word32 cpsr)
void MPU_vEventGroupDelete(struct Eq_n * r0, word32 cpsr)
{
	word32 r0_n = xPortRaisePrivilege(cpsr);
	vEventGroupDelete(r0, cpsr);
	if (r0_n != 0x01)
		__msr(cpsr, __mrs(cpsr) | 0x01);
}

// 00008E40: void xCoRoutineCreate(Register Eq_n r0, Register uint32 r1, Register Eq_n r2, Register word32 cpsr)
// Called from:
//      vStartFlashCoRoutines
void xCoRoutineCreate(Eq_n r0, uint32 r1, Eq_n r2, word32 cpsr)
{
	uint32 r5_n = r1;
	Eq_n r0_n = pvPortMalloc(0x38, cpsr);
	if (r0_n == 0x00)
		return;
	struct Eq_n * r7_n = g_ptr8EEC;
	if (r7_n->t0000.u1 == 0x00)
	{
		r7_n->t0000.u1 = (struct Eq_n *) r0_n;
		vListInitialise((char *) &r7_n->t0000 + 4);
		vListInitialise((char *) &r7_n->t0000 + 24);
		vListInitialise((char *) &r7_n->t0000 + 44);
		vListInitialise((char *) &r7_n->t0000 + 64);
		vListInitialise((char *) &r7_n->t0000 + 84);
		r7_n->ptr0068 = (char *) &r7_n->t0000 + 44;
		r7_n->ptr006C = (char *) &r7_n->t0000 + 64;
	}
	if (r1 >= 0x01)
		r5_n = 0x01;
	r0_n.u2->u1.w0034 = 0x00;
	r0_n.u2->u1.dw002C = r5_n;
	*((word32) r0_n + 48) = r2;
	r0_n.u1->t0000.u1 = (struct Eq_n *) r0;
	vListInitialiseItem(&r0_n.u2->u0.dw0004);
	vListInitialiseItem(&r0_n.u2->u1.dw0018);
	uint32 r0_n = r0_n.u2->u1.dw002C;
	word32 r5_n = 0x02 - r5_n;
	if (r0_n > r7_n->dw0070)
		r7_n->dw0070 = r0_n;
	r0_n.u2->u1.dw0018 = r5_n;
	*((word32) r0_n + 16) = r0_n;
	*((word32) r0_n + 36) = r0_n;
	vListInsertEnd((char *) &r7_n->t0000 + 4 + r0_n * 0x14, &r0_n.u2->u0.dw0004);
}

struct Eq_n * g_ptr8EEC = &g_t200007FC; // 00008EEC
// 00008EF0: FlagGroup bool vCoRoutineAddToDelayedList(Register Eq_n r0, Register (ptr32 Eq_n) r1)
// Called from:
//      xQueueCRSend
//      xQueueCRReceive
//      prvFixedDelayCoRoutine
bool vCoRoutineAddToDelayedList(Eq_n r0, struct Eq_n * r1)
{
	struct Eq_n * r4_n = g_ptr8F28;
	up32 r5_n = (word32) r0 + r4_n->dw0074;
	uxListRemove(&r4_n->ptr0000->dw0004);
	up32 r3_n = r4_n->dw0074;
	struct Eq_n * r1_n = r4_n->ptr0000;
	r1_n->dw0004 = r5_n;
	Eq_n Z_n = vListInsert(r4_n->ptr0068, &r1_n->dw0004);
	if (r1 == null)
		return Z_n != 0x00;
	struct Eq_n * r1_n = r4_n->ptr0000;
	return vListInsert(r1, &r1_n->dw0004 + 5) != 0x00;
}

struct Eq_n * g_ptr8F28 = &g_t200007FC; // 00008F28
// 00008F2C: Register word32 vCoRoutineSchedule(Register word32 r4, Register word32 r5, Register word32 r6, Register word32 r7, Register word32 r8, Register word32 cpsr)
// Called from:
//      vApplicationIdleHook
word32 vCoRoutineSchedule(word32 r4, word32 r5, word32 r6, word32 r7, word32 r8, word32 cpsr)
{
	struct Eq_n * r5_n = g_ptr9088;
	while (r5_n->dw0054 != 0x00)
	{
		__msr(cpsr, 191);
		__instruction_sync_barrier("sy");
		__data_sync_barrier("sy");
		struct Eq_n * r4_n = r5_n->ptr0060->ptr000C;
		uxListRemove((char *) r4_n + 24);
		__msr(cpsr, 0x00);
		uxListRemove((char *) r4_n + 4);
		uint32 r3_n = r4_n->dw002C;
		struct Eq_n * r0_n = (struct Eq_n *) ((&r5_n->a0000->u0 + 1)->a0000 + r3_n);
		if (r3_n > r5_n->dw0070)
			r5_n->dw0070 = r3_n;
		vListInsertEnd(r0_n, (char *) r4_n + 4);
	}
	word32 r0_n = MPU_xTaskGetTickCount(cpsr);
	up32 r3_n = r5_n->dw0074;
	word32 r0_n = r0_n - r5_n->dw0078;
	word32 r8_n = g_dw9090;
	r5_n->dw007C = r0_n;
l00008F94:
	while (r0_n != 0x00)
	{
		++r3_n;
		r5_n->dw0074 = r3_n;
		--r0_n;
		r5_n->dw007C = r0_n;
		struct Eq_n * r2_n;
		if (r3_n != 0x00)
			r2_n = r5_n->ptr0068;
		else
		{
			r2_n = r5_n->ptr006C;
			r5_n->ptr006C = r5_n->ptr0068;
			r5_n->ptr0068 = r2_n;
		}
		if (r2_n->dw0000 == 0x00)
			goto l00008F94;
		struct Eq_n * r4_n = r2_n->ptr000C->ptr000C;
		if (r3_n < r4_n->dw0004)
			goto l00008F94;
		do
		{
			__msr(cpsr, 191);
			__instruction_sync_barrier("sy");
			__data_sync_barrier("sy");
			struct Eq_n * r6_n = (struct Eq_n *) &r4_n->dw0004;
			uxListRemove(r6_n);
			struct Eq_n * r0_n = (struct Eq_n *) (&r4_n->dw0004 + 5);
			if (r4_n->dw0028 != 0x00)
				uxListRemove(r0_n);
			__msr(cpsr, 0x00);
			uint32 r3_n = r4_n->dw002C;
			struct Eq_n * r0_n = r8_n + r3_n * 0x14;
			if (r3_n > r5_n->dw0070)
				r5_n->dw0070 = r3_n;
			vListInsertEnd(r0_n, r6_n);
			struct Eq_n * r3_n = r5_n->ptr0068;
			if (r3_n->dw0000 == 0x00)
			{
				r3_n = r5_n->dw0074;
				break;
			}
			r4_n = r3_n->ptr000C->ptr000C;
			r3_n = r5_n->dw0074;
		} while (r4_n->dw0004 <= r3_n);
		r0_n = r5_n->dw007C;
	}
	uint32 r1_n = r5_n->dw0070;
	r5_n->dw0078 = r3_n;
	ui32 r3_n = r1_n << 2;
	uint32 r2_n;
	if (*((word160) &(r5_n->a0000 + r1_n)[0] + 4) == 0x00)
	{
		if (r1_n == 0x00)
			return cpsr;
		r3_n = r1_n - 0x01 << 2;
		r2_n = r1_n - 0x01;
		if (((char *) r5_n->a0000 + (r3_n + (r1_n - 0x01) << 0x02))[4] == 0x00)
		{
			if (r1_n == 0x01)
			{
l00009046:
				r5_n->dw0070 = r2_n;
				return cpsr;
			}
			r3_n = r1_n - 0x02 << 2;
			r2_n = r1_n - 0x02;
			if (((char *) r5_n->a0000 + (r3_n + (r1_n - 0x02) << 0x02))[4] == 0x00)
				goto l00009046;
		}
		r5_n->dw0070 = r2_n;
	}
	else
		r2_n = r1_n;
	ui32 r3_n = r3_n + r2_n;
	struct Eq_n * r1_n = (struct Eq_n *) ((char *) r5_n->a0000 + (r3_n << 2));
	struct Eq_n * r2_n = r1_n->ptr0008->ptr0004;
	struct Eq_n * r3_n = (r3_n << 2) + g_dw908C;
	r1_n->ptr0008 = r2_n;
	struct Eq_n * r2_n = r2_n;
	if (r2_n == r3_n)
		r2_n = r2_n->ptr0004;
	Eq_n r0_n;
	r0_n.u0 = r2_n->t000C.u0;
	if (r2_n == r3_n)
		r1_n->ptr0008 = r2_n;
	r5_n->a0000[0] = r0_n;
	(*r0_n.u0)();
	word32 cpsr_n;
	return cpsr_n;
}

struct Eq_n * g_ptr9088 = &g_t200007FC; // 00009088
word32 g_dw908C = 0x20000808; // 0000908C
word32 g_dw9090 = 0x20000800; // 00009090
// 00009094: FlagGroup bool xCoRoutineRemoveFromEventList(Register (ptr32 Eq_n) r0, Register out word32 r0Out)
// Called from:
//      xQueueCRSend
//      xQueueCRReceive
//      xQueueCRSendFromISR
//      xQueueCRReceiveFromISR
bool xCoRoutineRemoveFromEventList(struct Eq_n * r0, word32 & r0Out)
{
	struct Eq_n * r4_n = r0->ptr000C->ptr000C;
	struct Eq_n ** r5_n = g_ptr90C0;
	uxListRemove((char *) r4_n + 24);
	vListInsertEnd((char *) r5_n + 84, (char *) r4_n + 24);
	up32 r0_n = r4_n->dw002C;
	up32 r3_n = *((char *) *r5_n + 44);
	Eq_n NZCV_n;
	NZCV_n.u1 = cond(r0_n - r3_n);
	r0Out = 0x01;
	return (NZCV_n & 0x04) != 0x00;
}

struct Eq_n ** g_ptr90C0 = &g_ptr200007FC; // 000090C0
// 000090C4: void GPIOGetIntNumber(Register up32 r0)
void GPIOGetIntNumber(up32 r0)
{
	up32 r3_n = g_dw9104;
	if (r0 == r3_n)
		return;
	if (r0 > r3_n)
	{
		up32 r3_n = g_dw9108;
		if (r0 == r3_n)
			return;
		if (r0 != r3_n + 0x0001D000)
			;
	}
	else
	{
		if (r0 == 0x40004000)
			return;
		if (r0 != r3_n - 0x1000)
			;
	}
}

up32 g_dw9104 = 0x40006000; // 00009104
up32 g_dw9108 = 0x40007000; // 00009108
// 0000910C: void GPIODirModeSet(Register (ptr32 Eq_n) r0, Register ui32 r1, Register ui32 r2)
// Called from:
//      PDCInit
void GPIODirModeSet(struct Eq_n * r0, ui32 r1, ui32 r2)
{
	ui32 r3_n = r0->dw0400;
	if ((r2 & 0x01) != 0x00)
		r3_n |= r1;
	r0->dw0400 = r3_n & ~r1;
	ui32 r3_n = r0->dw0420;
	if (r2 << 30 < 0x00)
		r1 |= r3_n;
	r0->dw0420 = r3_n & ~r1;
}

// 00009134: void GPIODirModeGet(Register (ptr32 Eq_n) r0, Register word32 r1)
void GPIODirModeGet(struct Eq_n * r0, word32 r1)
{
	uint32 r1_n = (uint32) (0x01 << (byte) r1);
	ui32 r2_n = r0->dw0420;
	(r0->dw0400 & r1_n) != 0x00;
}

// 0000915C: void GPIOIntTypeSet(Register (ptr32 Eq_n) r0, Register ui32 r1, Register ui32 r2)
void GPIOIntTypeSet(struct Eq_n * r0, ui32 r1, ui32 r2)
{
	ui32 r3_n = r0->dw0408;
	if ((r2 & 0x01) != 0x00)
		r3_n |= r1;
	r0->dw0408 = r3_n & ~r1;
	ui32 r3_n = r0->dw0404;
	if ((r2 & 0x02) != 0x00)
		r3_n |= r1;
	r0->dw0404 = r3_n & ~r1;
	ui32 r3_n = r0->dw040C;
	if (r2 << 29 < 0x00)
		r1 |= r3_n;
	r0->dw040C = r3_n & ~r1;
}

// 00009194: void GPIOIntTypeGet(Register (ptr32 Eq_n) r0, Register word32 r1)
void GPIOIntTypeGet(struct Eq_n * r0, word32 r1)
{
	uint32 r1_n = (uint32) (0x01 << (byte) r1);
	ui32 r3_n = r0->dw0404;
	ui32 r0_n = r0->dw040C;
	(r0->dw0408 & r1_n) == 0x00;
}

// 000091C8: void GPIOPadConfigSet(Register (ptr32 Eq_n) r0, Register ui32 r1, Register ui32 r2, Register ui32 r3)
// Called from:
//      PDCInit
//      GPIOPinTypeComparator
//      GPIOPinTypeI2C
//      GPIOPinTypeQEI
//      GPIOPinTypePWM
void GPIOPadConfigSet(struct Eq_n * r0, ui32 r1, ui32 r2, ui32 r3)
{
	ui32 r4_n = r0->dw0500;
	if ((r2 & 0x01) != 0x00)
		r4_n |= r1;
	r0->dw0500 = r4_n & ~r1;
	ui32 r4_n = r0->dw0504;
	if ((r2 & 0x02) != 0x00)
		r4_n |= r1;
	r0->dw0504 = r4_n & ~r1;
	ui32 r4_n = r0->dw0508;
	if ((r2 & 0x04) != 0x00)
		r4_n |= r1;
	r0->dw0508 = r4_n & ~r1;
	ui32 r2_n = r0->dw0518;
	if ((r2 & 0x08) != 0x00)
		r2_n |= r1;
	r0->dw0518 = r2_n & ~r1;
	ui32 r2_n = r0->dw050C;
	if (r3 << 31 < 0x00)
		r2_n |= r1;
	r0->dw050C = r2_n & ~r1;
	ui32 r2_n = r0->dw0510;
	if (r3 << 30 < 0x00)
		r2_n |= r1;
	r0->dw0510 = r2_n & ~r1;
	ui32 r2_n = r0->dw0514;
	if (r3 << 29 < 0x00)
		r2_n |= r1;
	r0->dw0514 = r2_n & ~r1;
	ui32 r3_n = r0->dw051C;
	if ((r3 & 0x08) != 0x00)
		r1 |= r3_n;
	r0->dw051C = r3_n & ~r1;
}

// 0000925C: void GPIOPadConfigGet(Register (ptr32 Eq_n) r0, Register word32 r1, Register (ptr32 word32) r2, Register (ptr32 word32) r3)
void GPIOPadConfigGet(struct Eq_n * r0, word32 r1, word32 * r2, word32 * r3)
{
	uint32 r1_n = (uint32) (0x01 << (byte) r1);
	ui32 r4_n = r0->dw0504;
	ui32 r5_n = r0->dw0508;
	(r0->dw0500 & r1_n) == 0x00;
	ui32 r4_n = r0->dw0518;
	*r2 = 0x00;
	word32 r5_n = 0x00;
	ui32 r2_n = r0->dw050C;
	ui32 r4_n = r0->dw0510;
	ui32 r6_n = r0->dw0514;
	if ((r1_n & r2_n) != 0x00)
		r5_n = 0x01;
	ui32 r2_n = r0->dw051C;
	if ((r1_n & r2_n) == 0x00)
		r5_n = 0x00;
	*r3 = r5_n;
}

// 000092E0: void GPIOPinIntEnable(Register (ptr32 Eq_n) r0, Register ui32 r1)
void GPIOPinIntEnable(struct Eq_n * r0, ui32 r1)
{
	r0->dw0410 = r1 | r0->dw0410;
}

// 000092EC: void GPIOPinIntDisable(Register (ptr32 Eq_n) r0, Register word32 r1)
void GPIOPinIntDisable(struct Eq_n * r0, word32 r1)
{
	r0->dw0410 &= ~r1;
}

// 000092FC: void GPIOPinIntStatus(Register word32 r1)
void GPIOPinIntStatus(word32 r1)
{
	if (r1 != 0x00)
		;
}

// 0000930C: void GPIOPinIntClear(Register (ptr32 Eq_n) r0, Register word32 r1)
void GPIOPinIntClear(struct Eq_n * r0, word32 r1)
{
	r0->dw041C = r1;
}

// 00009314: void GPIOPortIntRegister(Register up32 r0, Register word32 r1)
void GPIOPortIntRegister(up32 r0, word32 r1)
{
	up32 r3_n = g_dw93A8;
	if (r0 == r3_n)
	{
		IntRegister(0x12, r1);
		IntEnable(0x12);
	}
	else
	{
		if (r0 <= r3_n)
		{
			if (r0 == 0x40004000)
			{
				IntRegister(0x10, r1);
				IntEnable(0x10);
				return;
			}
			if (r0 == r3_n - 0x1000)
			{
				IntRegister(0x11, r1);
				IntEnable(0x11);
				return;
			}
		}
		else
		{
			up32 r3_n = g_dw93AC;
			if (r0 == r3_n)
			{
				IntRegister(0x13, r1);
				IntEnable(0x13);
				return;
			}
			if (r0 == r3_n + 0x0001D000)
			{
				IntRegister(0x14, r1);
				IntEnable(0x14);
				return;
			}
		}
		IntRegister(~0x00, r1);
		IntEnable(~0x00);
	}
}

up32 g_dw93A8 = 0x40006000; // 000093A8
up32 g_dw93AC = 0x40007000; // 000093AC
// 000093B0: void GPIOPortIntUnregister(Register up32 r0)
void GPIOPortIntUnregister(up32 r0)
{
	up32 r3_n = g_dw9444;
	if (r0 == r3_n)
	{
		IntDisable(0x12);
		IntUnregister(0x12);
	}
	else
	{
		if (r0 <= r3_n)
		{
			if (r0 == 0x40004000)
			{
				IntDisable(0x10);
				IntUnregister(0x10);
				return;
			}
			if (r0 == r3_n - 0x1000)
			{
				IntDisable(0x11);
				IntUnregister(0x11);
				return;
			}
		}
		else
		{
			up32 r3_n = g_dw9448;
			if (r0 == r3_n)
			{
				IntDisable(0x13);
				IntUnregister(0x13);
				return;
			}
			if (r0 == r3_n + 0x0001D000)
			{
				IntDisable(0x14);
				IntUnregister(0x14);
				return;
			}
		}
		IntDisable(~0x00);
		IntUnregister(~0x00);
	}
}

up32 g_dw9444 = 0x40006000; // 00009444
up32 g_dw9448 = 0x40007000; // 00009448
// 0000944C: void GPIOPinRead()
void GPIOPinRead()
{
}

// 00009454: void GPIOPinWrite(Register (arr word32) r0, Register ui32 r1, Register word32 r2)
// Called from:
//      PDCInit
void GPIOPinWrite(word32 r0[], ui32 r1, word32 r2)
{
	r0[r1] = r2;
}

// 0000945C: void GPIOPinTypeComparator(Register (ptr32 Eq_n) r0, Register ui32 r1)
void GPIOPinTypeComparator(struct Eq_n * r0, ui32 r1)
{
	ui32 r5_n = ~r1;
	r0->dw0400 &= r5_n;
	r0->dw0420 = r5_n & r0->dw0420;
	GPIOPadConfigSet(r0, r1, 0x01, 0x00);
}

// 00009480: void GPIOPinTypeI2C(Register (ptr32 Eq_n) r0, Register ui32 r1)
// Called from:
//      OSRAMInit
void GPIOPinTypeI2C(struct Eq_n * r0, ui32 r1)
{
	r0->dw0400 &= ~r1;
	r0->dw0420 = r1 | r0->dw0420;
	GPIOPadConfigSet(r0, r1, 0x01, 11);
}

// 000094A4: void GPIOPinTypeQEI(Register (ptr32 Eq_n) r0, Register ui32 r1)
void GPIOPinTypeQEI(struct Eq_n * r0, ui32 r1)
{
	r0->dw0400 &= ~r1;
	r0->dw0420 = r1 | r0->dw0420;
	GPIOPadConfigSet(r0, r1, 0x01, 0x0A);
}

// 000094C8: void GPIOPinTypeUART(Register (ptr32 Eq_n) r0, Register ui32 r1)
// Called from:
//      GPIOPinTypeTimer
//      GPIOPinTypeSSI
//      GPIOPinTypePWM
void GPIOPinTypeUART(struct Eq_n * r0, ui32 r1)
{
	r0->dw0400 &= ~r1;
	r0->dw0420 = r1 | r0->dw0420;
	GPIOPadConfigSet(r0, r1, 0x01, 0x08);
}

// 000094EC: void GPIOPinTypeTimer(Register (ptr32 Eq_n) r0, Register ui32 r1)
void GPIOPinTypeTimer(struct Eq_n * r0, ui32 r1)
{
	GPIOPinTypeUART(r0, r1);
}

// 000094F0: void GPIOPinTypeSSI(Register (ptr32 Eq_n) r0, Register ui32 r1)
void GPIOPinTypeSSI(struct Eq_n * r0, ui32 r1)
{
	GPIOPinTypeUART(r0, r1);
}

// 000094F4: void GPIOPinTypePWM(Register (ptr32 Eq_n) r0, Register ui32 r1)
void GPIOPinTypePWM(struct Eq_n * r0, ui32 r1)
{
	GPIOPinTypeUART(r0, r1);
}

// 000094F8: void IntDefaultHandler()
void IntDefaultHandler()
{
	while (true)
		;
}

// 000094FC: void IntMasterEnable()
void IntMasterEnable()
{
	CPUcpsie();
}

// 00009500: void IntMasterDisable()
void IntMasterDisable()
{
	CPUcpsid();
}

// 00009504: void IntRegister(Register ui32 r0, Register word32 r1)
// Called from:
//      GPIOPortIntRegister
//      SSIIntRegister
//      SysCtlIntRegister
//      UARTIntRegister
//      I2CIntRegister
void IntRegister(ui32 r0, word32 r1)
{
	struct Eq_n * r4_n = g_ptr9534;
	if (*g_ptr9530 != r4_n)
	{
		struct Eq_n * r3_n = r4_n;
		do
		{
			r3_n->a0000[0].u0 = (r3_n - r4_n)->u0;
			++r3_n;
		} while (r3_n != r4_n + 46);
		*g_ptr9530 = (struct Eq_n **) r4_n;
	}
	r4_n[r0] = (struct Eq_n) r1;
}

struct Eq_n ** g_ptr9530 = &g_ptrE000ED08; // 00009530
struct Eq_n * g_ptr9534 = &g_t20000000; // 00009534
// 00009538: void IntUnregister(Register ui32 r0)
// Called from:
//      GPIOPortIntUnregister
//      SSIIntUnregister
//      SysCtlIntUnregister
//      UARTIntUnregister
//      I2CIntUnregister
void IntUnregister(ui32 r0)
{
	g_ptr9544[r0] = g_dw9548;
}

word32 (* g_ptr9544)[] = &g_a20000000; // 00009544
word32 g_dw9548 = 0x94F9; // 00009548
// 0000954C: void IntPriorityGroupingSet(Register ui32 r0)
void IntPriorityGroupingSet(ui32 r0)
{
	*g_ptr9564 = g_ptr9560[r0] | 0x05F80000 | 0x00020000;
}

ui32 (* g_ptr9560)[] = &g_aA2A4; // 00009560
ui32 * g_ptr9564 = &g_dwE000ED0C; // 00009564
// 00009568: void IntPriorityGroupingGet()
void IntPriorityGroupingGet()
{
	ui32 r3_n = 0x0700;
	word32 r0_n = 0x00;
	ui32 r1_n = *g_ptr9588;
	word32 * r2_n = g_ptr958C;
	while (r3_n != (r1_n & 0x0700))
	{
		++r0_n;
		if (r0_n == 0x08)
			return;
		++r2_n;
		r3_n = *r2_n;
	}
}

ui32 * g_ptr9588 = &g_dwE000ED0C; // 00009588
word32 * g_ptr958C = &g_dwA2A8; // 0000958C
// 00009590: void IntPrioritySet(Register ui32 r0, Register ui32 r1)
void IntPrioritySet(ui32 r0, ui32 r1)
{
	ui32 * r4_n = (g_ptr95B8 + (r0 & ~0x03))->ptr0020;
	ui32 r0_n = (r0 & 0x03) << 3;
	*r4_n = r1 << r0_n | *r4_n & ~(0xFF << r0_n);
}

ptr32 g_ptr95B8 = 0xA2A4; // 000095B8
// 000095BC: void IntPriorityGet()
void IntPriorityGet()
{
}

// 000095DC: void IntEnable(Register up32 r0)
// Called from:
//      GPIOPortIntRegister
//      SSIIntRegister
//      SysCtlIntRegister
//      UARTIntRegister
//      I2CIntRegister
void IntEnable(up32 r0)
{
	switch (r0)
	{
	case 0x04:
		ui32 * r2_n = g_ptr9634;
		*r2_n |= 0x00010000;
		return;
	case 0x05:
		ui32 * r2_n = g_ptr9634;
		*r2_n |= 0x00020000;
		return;
	case 0x06:
		ui32 * r2_n = g_ptr9634;
		*r2_n |= 0x00040000;
		return;
	case 0x0F:
		ui32 * r2_n = g_ptr9630;
		*r2_n |= 0x02;
		return;
	default:
		if (r0 > 0x0F)
			*g_ptr962C = 0x01 << r0 - 0x10;
		return;
	}
}

ui32 * g_ptr962C = &g_dwE000E100; // 0000962C
ui32 * g_ptr9630 = &g_dwE000E010; // 00009630
ui32 * g_ptr9634 = &g_dwE000ED24; // 00009634
// 00009638: void IntDisable(Register up32 r0)
// Called from:
//      GPIOPortIntUnregister
//      SSIIntUnregister
//      SysCtlIntUnregister
//      UARTIntUnregister
//      I2CIntUnregister
void IntDisable(up32 r0)
{
	switch (r0)
	{
	case 0x04:
		ui32 * r2_n = g_ptr9690;
		*r2_n &= ~0x00010000;
		return;
	case 0x05:
		ui32 * r2_n = g_ptr9690;
		*r2_n &= ~0x00020000;
		return;
	case 0x06:
		ui32 * r2_n = g_ptr9690;
		*r2_n &= ~0x00040000;
		return;
	case 0x0F:
		ui32 * r2_n = g_ptr968C;
		*r2_n &= ~0x02;
		return;
	default:
		if (r0 > 0x0F)
			*g_ptr9688 = 0x01 << r0 - 0x10;
		return;
	}
}

ui32 * g_ptr9688 = &g_dwE000E180; // 00009688
ui32 * g_ptr968C = &g_dwE000E010; // 0000968C
ui32 * g_ptr9690 = &g_dwE000ED24; // 00009690
// 00009694: void OSRAMDelay(Register word32 r0)
// Called from:
//      OSRAMWriteArray
//      OSRAMWriteByte
//      OSRAMWriteFinal
void OSRAMDelay(word32 r0)
{
	do
		--r0;
	while (r0 != 0x00);
}

// 0000969C: void OSRAMWriteFirst(Register ui32 r0)
// Called from:
//      OSRAMStringDraw
//      OSRAMImageDraw
//      OSRAMInit
//      OSRAMDisplayOn
//      OSRAMDisplayOff
void OSRAMWriteFirst(ui32 r0)
{
	struct Eq_n * r4_n = g_ptr96C0;
	I2CMasterSlaveAddrSet(r4_n, 0x3D, 0x00);
	I2CMasterDataPut(r4_n, r0);
	I2CMasterControl(r4_n, 0x03);
}

struct Eq_n * g_ptr96C0 = &g_t40020000; // 000096C0
// 000096C4: void OSRAMWriteArray(Register (ptr32 Eq_n) r0, Register int32 r1)
// Called from:
//      OSRAMStringDraw
//      OSRAMImageDraw
//      OSRAMInit
//      OSRAMDisplayOn
void OSRAMWriteArray(struct Eq_n * r0, int32 r1)
{
	if (r1 == 0x00)
		return;
	struct Eq_n * r5_n = r0;
	word32 * r7_n = g_ptr96FC;
	struct Eq_n * r4_n = g_ptr9700;
	struct Eq_n * r6_n = r0 + r1;
	do
	{
		while (I2CMasterIntStatus(r4_n, 0x00) == 0x00)
			;
		OSRAMDelay(*r7_n);
		I2CMasterDataPut(r4_n, (word32) r5_n->b0000);
		I2CMasterControl(r4_n, 0x01);
		++r5_n;
	} while (r6_n != r5_n);
}

word32 * g_ptr96FC = &g_dw2000087C; // 000096FC
struct Eq_n * g_ptr9700 = &g_t40020000; // 00009700
// 00009704: void OSRAMWriteByte(Register ui32 r0)
// Called from:
//      OSRAMStringDraw
//      OSRAMImageDraw
//      OSRAMInit
//      OSRAMDisplayOff
void OSRAMWriteByte(ui32 r0)
{
	while (I2CMasterIntStatus(g_ptr9730, 0x00) == 0x00)
		;
	OSRAMDelay(*g_ptr9734);
	I2CMasterDataPut(g_ptr9730, r0);
	struct Eq_n * r0_n = g_ptr9730;
	I2CMasterControl(r0_n, 0x01);
}

struct Eq_n * g_ptr9730 = &g_t40020000; // 00009730
word32 * g_ptr9734 = &g_dw2000087C; // 00009734
// 00009738: void OSRAMWriteFinal(Register ui32 r0)
// Called from:
//      OSRAMStringDraw
//      OSRAMImageDraw
//      OSRAMInit
//      OSRAMDisplayOn
//      OSRAMDisplayOff
void OSRAMWriteFinal(ui32 r0)
{
	struct Eq_n * r4_n = g_ptr9778;
	while (I2CMasterIntStatus(r4_n, 0x00) == 0x00)
		;
	word32 * r5_n = g_ptr977C;
	struct Eq_n * r4_n = g_ptr9778;
	OSRAMDelay(*r5_n);
	I2CMasterDataPut(r4_n, r0);
	I2CMasterControl(r4_n, 0x05);
	while (I2CMasterIntStatus(r4_n, 0x00) == 0x00)
		;
	word32 r0_n = *r5_n;
	OSRAMDelay(r0_n);
}

struct Eq_n * g_ptr9778 = &g_t40020000; // 00009778
word32 * g_ptr977C = &g_dw2000087C; // 0000977C
// 00009780: void OSRAMClear()
// Called from:
//      vPrintTask
//      OSRAMInit
void OSRAMClear()
{
	OSRAMWriteFirst(0x80);
	OSRAMWriteArray(g_ptr97C4, 0x06);
	ui32 r4_n;
	for (r4_n = 0x5F; r4_n != 0x00; --r4_n)
		OSRAMWriteByte(0x00);
	OSRAMWriteFinal(r4_n);
	OSRAMWriteFirst(0x80);
	OSRAMWriteArray(g_ptr97C8, 0x06);
	ui32 r4_n;
	for (r4_n = 0x5F; r4_n != 0x00; --r4_n)
		OSRAMWriteByte(0x00);
	OSRAMWriteFinal(r4_n);
}

struct Eq_n * g_ptr97C4 = &g_tA2F4; // 000097C4
struct Eq_n * g_ptr97C8 = &g_tA2FC; // 000097C8
// 000097CC: void OSRAMStringDraw(Register (ptr32 byte) r0, Register uint32 r1, Register ui32 r2)
// Called from:
//      ResetISR
//      vPrintTask
void OSRAMStringDraw(byte * r0, uint32 r1, ui32 r2)
{
	OSRAMWriteFirst(0x80);
	uint32 r4_n = r1;
	byte * r5_n = r0;
	OSRAMWriteByte(177);
	OSRAMWriteByte(0x80);
	OSRAMWriteByte(r1 + 0x24 & 0x0F);
	OSRAMWriteByte(0x80);
	OSRAMWriteByte((uint32) SLICE(r1 + 0x24, ui4, 4) | 0x10);
	OSRAMWriteByte(0x40);
	ui32 r3_n = (word32) *r0;
	if (r3_n == 0x00)
		return;
	word32 r6_n = g_dw9878;
	if (r1 <= 0x5A)
	{
		do
		{
			OSRAMWriteArray(r6_n + (r3_n - 0x20) * 0x05, 0x05);
			if (r4_n == 0x5A)
			{
l00009846:
				OSRAMWriteFinal(0x00);
				return;
			}
			++r5_n;
			r4_n += 0x06;
			if ((word32) *r5_n == 0x00)
				goto l00009846;
			OSRAMWriteByte(0x00);
			r3_n = (word32) *r5_n;
			if (r3_n == 0x00)
				return;
		} while (r4_n <= 0x5A);
	}
	int32 r4_n = 0x5F - r4_n;
	OSRAMWriteArray(r6_n + (r3_n - 0x20) * 0x05, r4_n);
	Eq_n r3_n = (word32) *r5_n;
	ui32 r0_n = (word32) (r3_n - 0x20 + (r3_n - 0x20 << 0x02) + g_dw987C + r4_n)->b0010;
	OSRAMWriteFinal(r0_n);
}

word32 g_dw9878 = 0xA304; // 00009878
int32 g_dw987C = 41716; // 0000987C
// 00009880: void OSRAMImageDraw(Register (ptr32 Eq_n) r0, Register word32 r1, Register word32 r2, Register word32 r3, Stack word32 dwArg00)
void OSRAMImageDraw(struct Eq_n * r0, word32 r1, word32 r2, word32 r3, word32 dwArg00)
{
	if (dwArg00 != 0x00)
	{
		struct Eq_n * r5_n = r0;
		word32 r4_n = r2;
		uint32 r8_n = (uint32) SLICE(r1 + 0x24, ui4, 4);
		word32 r6_n = dwArg00 + r2;
		ui32 r7_n = r1 + 0x24 & 0x0F;
		do
		{
			OSRAMWriteFirst(0x80);
			OSRAMWriteByte(0xB0);
			OSRAMWriteByte(0x80);
			OSRAMWriteByte(r7_n);
			OSRAMWriteByte(0x80);
			OSRAMWriteByte(r8_n | 0x10);
			OSRAMWriteByte(0x40);
			OSRAMWriteArray(r5_n, r3 + ~0x00);
			r5_n += r3;
			OSRAMWriteFinal((word32) r5_n->bFFFFFFFF);
			++r4_n;
		} while (r6_n != r4_n);
	}
}

// 000098F0: void OSRAMInit(Register word32 r0)
// Called from:
//      ResetISR
void OSRAMInit(word32 r0)
{
	SysCtlPeripheralEnable(0x10001000);
	SysCtlPeripheralEnable(g_dw9960);
	GPIOPinTypeI2C(g_ptr9964, 0x0C);
	I2CMasterInit(g_ptr9968, r0);
	word32 r7_n = g_dw9970;
	*g_ptr996C = 0x01;
	ui32 r6_n = 227;
	int32 r4_n = 0x04;
	ui32 r0_n = 0x80;
	up32 r5_n = 0x00;
	while (true)
	{
		OSRAMWriteFirst(r0_n);
		OSRAMWriteArray(r5_n + 0x02 + (r7_n + 0x01EC), r4_n - 0x02);
		OSRAMWriteFinal(r6_n);
		r5_n += r4_n + 0x01;
		struct Eq_n * r3_n = r7_n + r5_n;
		if (r5_n > 0x70)
			break;
		r4_n = (word32) r3_n->b01EC;
		r0_n = (word32) r3_n->b01ED;
		r6_n = (word32) ((char *) r3_n + r4_n)[492];
	}
	OSRAMClear();
}

uint32 g_dw9960 = 0x20000002; // 00009960
struct Eq_n * g_ptr9964 = &g_t40005000; // 00009964
struct Eq_n * g_ptr9968 = &g_t40020000; // 00009968
word32 * g_ptr996C = &g_dw2000087C; // 0000996C
word32 g_dw9970 = 41716; // 00009970
// 00009974: void OSRAMDisplayOn()
void OSRAMDisplayOn()
{
	word32 r7_n = g_dw99BC;
	ui32 r6_n = 227;
	int32 r4_n = 0x04;
	ui32 r0_n = 0x80;
	up32 r5_n = 0x00;
	while (true)
	{
		OSRAMWriteFirst(r0_n);
		OSRAMWriteArray(r5_n + 0x02 + (r7_n + 0x01EC), r4_n - 0x02);
		OSRAMWriteFinal(r6_n);
		r5_n += r4_n + 0x01;
		struct Eq_n * r3_n = r7_n + r5_n;
		if (r5_n > 0x70)
			break;
		r4_n = (word32) r3_n->b01EC;
		r0_n = (word32) r3_n->b01ED;
		r6_n = (word32) ((char *) r3_n + r4_n)[492];
	}
}

word32 g_dw99BC = 41716; // 000099BC
// 000099C0: void OSRAMDisplayOff()
void OSRAMDisplayOff()
{
	OSRAMWriteFirst(0x80);
	OSRAMWriteByte(0xAE);
	OSRAMWriteByte(0x80);
	OSRAMWriteByte(0xAD);
	OSRAMWriteByte(0x80);
	OSRAMWriteFinal(0x8A);
}

// 000099E8: void SSIConfig(Register (ptr32 Eq_n) r0, Register ui32 r1, Register ui32 r2, Register uint32 r3, Stack ui32 dwArg00)
// Called from:
//      PDCInit
void SSIConfig(struct Eq_n * r0, ui32 r1, ui32 r2, uint32 r3, ui32 dwArg00)
{
	ui32 r7_n = r2;
	uint32 r0_n = SysCtlClockGet();
	switch (r2)
	{
	case 0x02:
		r7_n = 0x0C;
		break;
	case 0x00:
	default:
		r7_n = 0x04;
		break;
	}
	r0->dw0004 = r7_n;
	uint32 r3_n = r0_n /u r3;
	uint32 r4_n = 0x00;
	uint32 r2_n;
	do
	{
		r4_n += 0x02;
		r2_n = r3_n /u r4_n;
	} while (r2_n > 0x0100 || r2_n < 0x01);
	r0->dw0010 = r4_n;
	r0->dw0000 = dwArg00 - 0x01 | (r1 & 0x30 | r1 << 0x06) | r2_n - 0x01 << 0x08;
}

// 00009A34: void SSIEnable(Register (ptr32 Eq_n) r0)
// Called from:
//      PDCInit
void SSIEnable(struct Eq_n * r0)
{
	r0->dw0004 |= 0x02;
}

// 00009A40: void SSIDisable(Register (ptr32 Eq_n) r0)
void SSIDisable(struct Eq_n * r0)
{
	r0->dw0004 &= ~0x02;
}

// 00009A4C: void SSIIntRegister(Register word32 r1)
void SSIIntRegister(word32 r1)
{
	IntRegister(0x17, r1);
	IntEnable(0x17);
}

// 00009A60: void SSIIntUnregister()
void SSIIntUnregister()
{
	IntDisable(0x17);
	IntUnregister(0x17);
}

// 00009A74: void SSIIntEnable(Register (ptr32 Eq_n) r0, Register ui32 r1)
void SSIIntEnable(struct Eq_n * r0, ui32 r1)
{
	r0->dw0014 = r1 | r0->dw0014;
}

// 00009A7C: void SSIIntDisable(Register (ptr32 Eq_n) r0, Register word32 r1)
void SSIIntDisable(struct Eq_n * r0, word32 r1)
{
	r0->dw0014 &= ~r1;
}

// 00009A88: void SSIIntStatus(Register word32 r1)
void SSIIntStatus(word32 r1)
{
	if (r1 != 0x00)
		;
}

// 00009A94: void SSIIntClear(Register (ptr32 Eq_n) r0, Register word32 r1)
void SSIIntClear(struct Eq_n * r0, word32 r1)
{
	r0->dw0020 = r1;
}

// 00009A98: void SSIDataPut(Register (ptr32 Eq_n) r0, Register ui32 r1)
// Called from:
//      PDCWrite
void SSIDataPut(struct Eq_n * r0, ui32 r1)
{
	while (r0->dw000C << 30 >= 0x00)
		;
	r0->dw0008 = r1;
}

// 00009AA8: void SSIDataNonBlockingPut(Register (ptr32 Eq_n) r0, Register word32 r1)
void SSIDataNonBlockingPut(struct Eq_n * r0, word32 r1)
{
	if ((r0->dw000C & 0x02) != 0x00)
		r0->dw0008 = r1;
}

// 00009AB8: void SSIDataGet(Register (ptr32 Eq_n) r0, Register (ptr32 ui32) r1)
// Called from:
//      PDCWrite
void SSIDataGet(struct Eq_n * r0, ui32 * r1)
{
	while (r0->dw000C << 29 >= 0x00)
		;
	*r1 = r0->dw0008;
}

// 00009AC8: void SSIDataNonBlockingGet(Register (ptr32 Eq_n) r0, Register (ptr32 ui32) r1)
void SSIDataNonBlockingGet(struct Eq_n * r0, ui32 * r1)
{
	ui32 r3_n = r0->dw000C;
	ui32 r3_n = r3_n & 0x04;
	if ((r3_n & 0x04) != 0x00)
		r3_n = r0->dw0008;
	*r1 = r3_n;
}

// 00009ADC: void SysCtlSRAMSizeGet()
void SysCtlSRAMSizeGet()
{
}

// 00009AF4: void SysCtlFlashSizeGet()
void SysCtlFlashSizeGet()
{
}

// 00009B0C: void SysCtlPinPresent(Register ui32 r0)
void SysCtlPinPresent(ui32 r0)
{
	(*g_ptr9B1C & r0) == 0x00;
}

ui32 * g_ptr9B1C = &g_dw400FE018; // 00009B1C
// 00009B20: void SysCtlPeripheralPresent(Register uint32 r0)
void SysCtlPeripheralPresent(uint32 r0)
{
	(r0 & 0x0FFFFFFF & *g_ptr9B38[r0 >> 28]) == 0x00;
}

ui32 * (* g_ptr9B38)[] = &g_aA554; // 00009B38
// 00009B3C: void SysCtlPeripheralReset(Register uint32 r0)
void SysCtlPeripheralReset(uint32 r0)
{
	ui32 * r2_n = (ui32 *) (g_ptr9B78 + (r0 >> 28))[4];
	*r2_n = r0 & 0x0FFFFFFF | *r2_n;
	up32 dwLoc0C_n = 0x00;
	if (false)
	{
		do
			++dwLoc0C_n;
		while (dwLoc0C_n <= 0x0F);
	}
	*r2_n &= ~r0;
}

Eq_n (* g_ptr9B78)[] = &g_aA554; // 00009B78
// 00009B7C: void SysCtlPeripheralEnable(Register uint32 r0)
// Called from:
//      PDCInit
//      OSRAMInit
void SysCtlPeripheralEnable(uint32 r0)
{
	ui32 * r3_n = (ui32 *) (g_ptr9B94 + (r0 >> 28))[7];
	*r3_n = r0 & 0x0FFFFFFF | *r3_n;
}

Eq_n (* g_ptr9B94)[] = &g_aA554; // 00009B94
// 00009B98: void SysCtlPeripheralDisable(Register uint32 r0)
void SysCtlPeripheralDisable(uint32 r0)
{
	ui32 * r2_n = (ui32 *) (g_ptr9BB0 + (r0 >> 28))[7];
	*r2_n &= ~(r0 & 0x0FFFFFFF);
}

Eq_n (* g_ptr9BB0)[] = &g_aA554; // 00009BB0
// 00009BB4: void SysCtlPeripheralSleepEnable(Register uint32 r0)
void SysCtlPeripheralSleepEnable(uint32 r0)
{
	ui32 * r3_n = (ui32 *) (g_ptr9BCC + (r0 >> 28))[0x0A];
	*r3_n = r0 & 0x0FFFFFFF | *r3_n;
}

Eq_n (* g_ptr9BCC)[] = &g_aA554; // 00009BCC
// 00009BD0: void SysCtlPeripheralSleepDisable(Register uint32 r0)
void SysCtlPeripheralSleepDisable(uint32 r0)
{
	ui32 * r2_n = (ui32 *) (g_ptr9BE8 + (r0 >> 28))[0x0A];
	*r2_n &= ~(r0 & 0x0FFFFFFF);
}

Eq_n (* g_ptr9BE8)[] = &g_aA554; // 00009BE8
// 00009BEC: void SysCtlPeripheralDeepSleepEnable(Register uint32 r0)
void SysCtlPeripheralDeepSleepEnable(uint32 r0)
{
	ui32 * r3_n = (ui32 *) (g_ptr9C04 + (r0 >> 28))[0x0D];
	*r3_n = r0 & 0x0FFFFFFF | *r3_n;
}

Eq_n (* g_ptr9C04)[] = &g_aA554; // 00009C04
// 00009C08: void SysCtlPeripheralDeepSleepDisable(Register uint32 r0)
void SysCtlPeripheralDeepSleepDisable(uint32 r0)
{
	ui32 * r2_n = (ui32 *) (g_ptr9C20 + (r0 >> 28))[0x0D];
	*r2_n &= ~(r0 & 0x0FFFFFFF);
}

Eq_n (* g_ptr9C20)[] = &g_aA554; // 00009C20
// 00009C24: void SysCtlPeripheralClockGating(Register word32 r0)
void SysCtlPeripheralClockGating(word32 r0)
{
	ui32 * r2_n = g_ptr9C3C;
	ui32 r3_n = *r2_n;
	if (r0 != 0x00)
		*r2_n = r3_n | 0x08000000;
	else
		*r2_n = r3_n & ~0x08000000;
}

ui32 * g_ptr9C3C = &g_dw400FE060; // 00009C3C
// 00009C40: void SysCtlIntRegister(Register word32 r0)
void SysCtlIntRegister(word32 r0)
{
	IntRegister(44, r0);
	IntEnable(44);
}

// 00009C54: void SysCtlIntUnregister()
void SysCtlIntUnregister()
{
	IntDisable(44);
	IntUnregister(44);
}

// 00009C68: void SysCtlIntEnable(Register ui32 r0)
void SysCtlIntEnable(ui32 r0)
{
	ui32 * r2_n = g_ptr9C74;
	*r2_n = r0 | *r2_n;
}

ui32 * g_ptr9C74 = &g_dw400FE054; // 00009C74
// 00009C78: void SysCtlIntDisable(Register word32 r0)
void SysCtlIntDisable(word32 r0)
{
	ui32 * r2_n = g_ptr9C84;
	*r2_n &= ~r0;
}

ui32 * g_ptr9C84 = &g_dw400FE054; // 00009C84
// 00009C88: void SysCtlIntClear(Register word32 r0)
void SysCtlIntClear(word32 r0)
{
	*g_ptr9C90 = r0;
}

word32 * g_ptr9C90 = &g_dw400FE058; // 00009C90
// 00009C94: void SysCtlIntStatus(Register word32 r0)
void SysCtlIntStatus(word32 r0)
{
	if (r0 != 0x00)
		;
}

// 00009CAC: void SysCtlLDOSet(Register word32 r0)
void SysCtlLDOSet(word32 r0)
{
	*g_ptr9CB4 = r0;
}

word32 * g_ptr9CB4 = &g_dw400FE034; // 00009CB4
// 00009CB8: void SysCtlLDOGet()
void SysCtlLDOGet()
{
}

// 00009CC4: void SysCtlLDOConfigSet(Register word32 r0)
void SysCtlLDOConfigSet(word32 r0)
{
	*g_ptr9CCC = r0;
}

word32 * g_ptr9CCC = &g_dw400FE160; // 00009CCC
// 00009CD0: void SysCtlReset()
void SysCtlReset()
{
	*g_ptr9CD8 = g_dw9CDC;
	while (true)
		;
}

word32 * g_ptr9CD8 = &g_dwE000ED0C; // 00009CD8
word32 g_dw9CDC = 0x05FA0004; // 00009CDC
// 00009CE0: void SysCtlSleep()
void SysCtlSleep()
{
	CPUwfi();
}

// 00009CE4: void SysCtlDeepSleep()
void SysCtlDeepSleep()
{
	ui32 * r4_n = g_ptr9D00;
	*r4_n |= 0x04;
	CPUwfi();
	*r4_n &= ~0x04;
}

ui32 * g_ptr9D00 = &g_dwE000ED10; // 00009D00
// 00009D04: void SysCtlResetCauseGet()
void SysCtlResetCauseGet()
{
}

// 00009D10: void SysCtlResetCauseClear(Register word32 r0)
void SysCtlResetCauseClear(word32 r0)
{
	ui32 * r2_n = g_ptr9D1C;
	*r2_n &= ~r0;
}

ui32 * g_ptr9D1C = &g_dw400FE05C; // 00009D1C
// 00009D20: void SysCtlBrownOutConfigSet(Register ui32 r0, Register ui32 r1)
void SysCtlBrownOutConfigSet(ui32 r0, ui32 r1)
{
	*g_ptr9D2C = r0 | r1 << 0x02;
}

ui32 * g_ptr9D2C = &g_dw400FE030; // 00009D2C
// 00009D30: void SysCtlClockSet(Register ui32 r0)
void SysCtlClockSet(ui32 r0)
{
	ui32 * r4_n = g_ptr9DE0;
	ui32 r3_n = *r4_n;
	word32 * r5_n = g_ptr9DE8;
	ui32 r2_n = r0 & 0x33F0 | (g_dw9DE4 & r3_n | 0x0800) & (r0 | ~0x03);
	*r4_n = r3_n & ~0x00400000 | 0x0800;
	*r5_n = 0x40;
	*r4_n = r2_n;
	up32 dwLoc14_n = 0x00;
	if (false)
	{
		do
			++dwLoc14_n;
		while (dwLoc14_n <= 0x0F);
	}
	ui32 r2_n = r2_n & ~0x03 | r0 & 0x03;
	*g_ptr9DE0 = r2_n;
	ui32 r1_n = r0 & 0x07C00000 | r2_n & ~0x07C00000;
	if (r0 << 20 >= 0x00)
	{
		word32 dwLoc14_n = 0x8000;
		if (true)
		{
			ui32 * r2_n = g_ptr9DEC;
			if (*r2_n << 25 >= 0x00)
			{
				do
					--dwLoc14_n;
				while (dwLoc14_n != 0x00 && *r2_n << 25 >= 0x00);
			}
		}
		r1_n &= ~0x0800;
	}
	*g_ptr9DE0 = r1_n;
	up32 dwLoc14_n = 0x00;
	if (false)
	{
		do
			++dwLoc14_n;
		while (dwLoc14_n <= 0x0F);
	}
}

ui32 * g_ptr9DE0 = &g_dw400FE060; // 00009DE0
ui32 g_dw9DE4 = ~0x004033F0; // 00009DE4
word32 * g_ptr9DE8 = &g_dw400FE058; // 00009DE8
ui32 * g_ptr9DEC = &g_dw400FE050; // 00009DEC
// 00009DF0: Register uint32 SysCtlClockGet()
// Called from:
//      SSIConfig
//      UARTConfigSet
//      UARTConfigGet
//      I2CMasterInit
uint32 SysCtlClockGet()
{
	ui32 r3_n = *g_ptr9E54;
	uint32 r0_n;
	switch (r3_n & 0x30)
	{
	case 0x10:
		r0_n = g_dw9E64;
		break;
	case 0x20:
		r0_n = g_dw9E60;
		break;
	default:
		if ((r3_n & 0x30) != 0x00)
		{
			r0_n = 0x00;
			return r0_n;
		}
		r0_n = (uint32) (g_ptr9E58 + (uint32) SLICE(r3_n, ui4, 6))[0x0C];
		break;
	}
	if (r3_n << 20 >= 0x00)
	{
		ui32 r2_n = *g_ptr9E5C;
		r0_n = r0_n * ((uint32) SLICE(r2_n, ui9, 5) + 0x02) /u ((r2_n & 0x1F) + 0x02);
		if (r2_n << 0x0011 < 0x00)
			r0_n >>= 1;
		if (r2_n << 16 < 0x00)
			r0_n >>= 2;
	}
	if (r3_n << 9 >= 0x00)
		return r0_n;
	return r0_n /u ((uint32) SLICE(r3_n, ui4, 23) + 0x01);
}

ui32 * g_ptr9E54 = &g_dw400FE060; // 00009E54
Eq_n (* g_ptr9E58)[] = &g_aA554; // 00009E58
ui32 * g_ptr9E5C = &g_dw400FE064; // 00009E5C
uint32 g_dw9E60 = 3750000; // 00009E60
uint32 g_dw9E64 = 15000000; // 00009E64
// 00009E68: void SysCtlPWMClockSet(Register ui32 r0)
void SysCtlPWMClockSet(ui32 r0)
{
	ui32 * r2_n = g_ptr9E78;
	*r2_n = r0 | *r2_n & ~0x001E0000;
}

ui32 * g_ptr9E78 = &g_dw400FE060; // 00009E78
// 00009E7C: void SysCtlPWMClockGet()
void SysCtlPWMClockGet()
{
}

// 00009E8C: void SysCtlADCSpeedSet(Register ui32 r0)
void SysCtlADCSpeedSet(ui32 r0)
{
	ui32 * r4_n = g_ptr9EB8;
	ui32 * r1_n = g_ptr9EBC;
	ui32 * r2_n = g_ptr9EC0;
	*r4_n = *r4_n & ~0x0F00 | r0;
	*r1_n = *r1_n & ~0x0F00 | r0;
	*r2_n = r0 | *r2_n & ~0x0F00;
}

ui32 * g_ptr9EB8 = &g_dw400FE100; // 00009EB8
ui32 * g_ptr9EBC = &g_dw400FE110; // 00009EBC
ui32 * g_ptr9EC0 = &g_dw400FE120; // 00009EC0
// 00009EC4: void SysCtlADCSpeedGet()
void SysCtlADCSpeedGet()
{
}

// 00009ED4: void SysCtlIOSCVerificationSet(Register word32 r0)
void SysCtlIOSCVerificationSet(word32 r0)
{
	ui32 * r2_n = g_ptr9EEC;
	ui32 r3_n = *r2_n;
	if (r0 != 0x00)
		*r2_n = r3_n | 0x08;
	else
		*r2_n = r3_n & ~0x08;
}

ui32 * g_ptr9EEC = &g_dw400FE060; // 00009EEC
// 00009EF0: void SysCtlMOSCVerificationSet(Register word32 r0)
void SysCtlMOSCVerificationSet(word32 r0)
{
	ui32 * r2_n = g_ptr9F08;
	ui32 r3_n = *r2_n;
	if (r0 != 0x00)
		*r2_n = r3_n | 0x04;
	else
		*r2_n = r3_n & ~0x04;
}

ui32 * g_ptr9F08 = &g_dw400FE060; // 00009F08
// 00009F0C: void SysCtlPLLVerificationSet(Register word32 r0)
void SysCtlPLLVerificationSet(word32 r0)
{
	ui32 * r2_n = g_ptr9F24;
	ui32 r3_n = *r2_n;
	if (r0 != 0x00)
		*r2_n = r3_n | 0x0400;
	else
		*r2_n = r3_n & ~0x0400;
}

ui32 * g_ptr9F24 = &g_dw400FE060; // 00009F24
// 00009F28: void SysCtlClkVerificationClear()
void SysCtlClkVerificationClear()
{
	word32 * r3_n = g_ptr9F34;
	*r3_n = 0x01;
	*r3_n = 0x00;
}

word32 * g_ptr9F34 = &g_dw400FE150; // 00009F34
// 00009F38: void UARTParityModeSet(Register (ptr32 Eq_n) r0, Register ui32 r1)
void UARTParityModeSet(struct Eq_n * r0, ui32 r1)
{
	r0->dw002C = r1 | r0->dw002C & ~0x86;
}

// 00009F44: void UARTParityModeGet()
void UARTParityModeGet()
{
}

// 00009F4C: void UARTConfigSet(Register (ptr32 Eq_n) r0, Register uint32 r1, Register ui32 r2)
void UARTConfigSet(struct Eq_n * r0, uint32 r1, ui32 r2)
{
	ui32 r4_n;
	do
		r4_n = r0->dw0018;
	while ((r4_n & 0x08) != 0x00);
	r0->dw002C &= ~0x10;
	r0->dw0030 &= ~0x0301;
	uint32 r0_n = SysCtlClockGet();
	uint32 r2_n = r0_n /u (r1 << 4);
	r0->dw0024 = r2_n;
	r0->dw0028 = (r0_n - (r1 << 4) * r2_n << 3) /u r1 + 0x01 >> 1;
	r0->dw002C = r2;
	r0->dw0018 = r4_n & 0x08;
	r0->dw002C |= 0x10;
	r0->dw0030 = r0->dw0030 | 0x0300 | 0x01;
}

// 00009FA8: void UARTConfigGet(Register (ptr32 Eq_n) r0, Register (ptr32 uint32) r1, Register (ptr32 ui32) r2)
void UARTConfigGet(struct Eq_n * r0, uint32 * r1, ui32 * r2)
{
	*r1 = (SysCtlClockGet() << 2) /u (r0->dw0028 + (r0->dw0024 << 0x06));
	*r2 = r0->dw002C & 0xEE;
}

// 00009FD4: void UARTEnable(Register (ptr32 Eq_n) r0)
void UARTEnable(struct Eq_n * r0)
{
	r0->dw002C |= 0x10;
	r0->dw0030 = r0->dw0030 | 0x0300 | 0x01;
}

// 00009FEC: void UARTDisable(Register (ptr32 Eq_n) r0)
void UARTDisable(struct Eq_n * r0)
{
	while (r0->dw0018 << 28 < 0x00)
		;
	r0->dw002C &= ~0x10;
	r0->dw0030 &= ~0x0301;
}

// 0000A00C: void UARTCharsAvail()
void UARTCharsAvail()
{
}

// 0000A018: void UARTSpaceAvail()
void UARTSpaceAvail()
{
}

// 0000A024: void UARTCharNonBlockingGet(Register (ptr32 Eq_n) r0)
void UARTCharNonBlockingGet(struct Eq_n * r0)
{
	r0->dw0018 << 27 < 0x00;
}

// 0000A034: void UARTCharGet(Register (ptr32 Eq_n) r0)
void UARTCharGet(struct Eq_n * r0)
{
	while (r0->dw0018 << 27 < 0x00)
		;
}

// 0000A044: void UARTCharNonBlockingPut(Register (ptr32 Eq_n) r0, Register word32 r1)
void UARTCharNonBlockingPut(struct Eq_n * r0, word32 r1)
{
	if (r0->dw0018 << 26 >= 0x00)
		r0->dw0000 = r1;
}

// 0000A054: void UARTCharPut(Register (ptr32 Eq_n) r0, Register word32 r1)
void UARTCharPut(struct Eq_n * r0, word32 r1)
{
	while (r0->dw0018 << 26 < 0x00)
		;
	r0->dw0000 = r1;
}

// 0000A064: void UARTBreakCtl(Register (ptr32 Eq_n) r0, Register word32 r1)
void UARTBreakCtl(struct Eq_n * r0, word32 r1)
{
	ui32 r3_n = r0->dw002C;
	if (r1 != 0x00)
		r0->dw002C = r3_n | 0x01;
	else
		r0->dw002C = r3_n & ~0x01;
}

// 0000A078: void UARTIntRegister(Register word32 r0, Register word32 r1)
void UARTIntRegister(word32 r0, word32 r1)
{
	IntRegister(22, r1);
	IntEnable(22);
}

word32 g_dwA094 = 0x4000C000; // 0000A094
// 0000A098: void UARTIntUnregister(Register word32 r0)
void UARTIntUnregister(word32 r0)
{
	IntDisable(22);
	IntUnregister(22);
}

word32 g_dwA0B4 = 0x4000C000; // 0000A0B4
// 0000A0B8: void UARTIntEnable(Register (ptr32 Eq_n) r0, Register ui32 r1)
void UARTIntEnable(struct Eq_n * r0, ui32 r1)
{
	r0->dw0038 = r1 | r0->dw0038;
}

// 0000A0C0: void UARTIntDisable(Register (ptr32 Eq_n) r0, Register word32 r1)
void UARTIntDisable(struct Eq_n * r0, word32 r1)
{
	r0->dw0038 &= ~r1;
}

// 0000A0CC: Register (ptr32 Eq_n) UARTIntStatus(Register (ptr32 Eq_n) r0, Register word32 r1)
// Called from:
//      vUART_ISR
struct Eq_n * UARTIntStatus(struct Eq_n * r0, word32 r1)
{
	if (r1 != 0x00)
		return r0->ptr0040;
	return r0->ptr003C;
}

// 0000A0D8: void UARTIntClear(Register (ptr32 Eq_n) r0, Register Eq_n r1)
// Called from:
//      vUART_ISR
void UARTIntClear(struct Eq_n * r0, Eq_n r1)
{
	r0->t0044.u1 = (struct Eq_n *) r1;
}

// 0000A0DC: void CPUcpsie()
// Called from:
//      IntMasterEnable
void CPUcpsie()
{
	__cps();
}

// 0000A0E4: void CPUcpsid()
// Called from:
//      IntMasterDisable
void CPUcpsid()
{
	__cps();
}

// 0000A0EC: void CPUwfi()
// Called from:
//      SysCtlSleep
//      SysCtlDeepSleep
void CPUwfi()
{
	__wait_for_interrupt();
}

// 0000A0F4: void I2CMasterInit(Register (ptr32 Eq_n) r0, Register word32 r1)
// Called from:
//      OSRAMInit
void I2CMasterInit(struct Eq_n * r0, word32 r1)
{
	r0->dw0020 |= 0x10;
	uint32 r0_n = SysCtlClockGet();
	uint32 r3_n = g_dwA120;
	uint32 r2_n = g_dwA124;
	if (r1 == 0x01)
		r3_n = r2_n;
	r0->dw000C = (r0_n - 0x01 + r3_n) /u r3_n - 0x01;
}

uint32 g_dwA120 = 2000000; // 0000A120
uint32 g_dwA124 = 8000000; // 0000A124
// 0000A128: void I2CSlaveInit(Register (ptr32 Eq_n) r0, Register word32 r1)
void I2CSlaveInit(struct Eq_n * r0, word32 r1)
{
	r0->dwFFFFF820 |= 0x20;
	r0->dw0004 = 0x01;
	r0->dw0000 = r1;
}

// 0000A140: void I2CMasterEnable(Register (ptr32 Eq_n) r0)
void I2CMasterEnable(struct Eq_n * r0)
{
	r0->dw0020 |= 0x10;
}

// 0000A14C: void I2CSlaveEnable(Register (ptr32 Eq_n) r0)
void I2CSlaveEnable(struct Eq_n * r0)
{
	r0->dwFFFFF820 |= 0x20;
	r0->dw0004 = 0x01;
}

// 0000A160: void I2CMasterDisable(Register (ptr32 Eq_n) r0)
void I2CMasterDisable(struct Eq_n * r0)
{
	r0->dw0020 &= ~0x10;
}

// 0000A16C: void I2CSlaveDisable(Register (ptr32 Eq_n) r0)
void I2CSlaveDisable(struct Eq_n * r0)
{
	r0->dw0004 = 0x00;
	r0->dwFFFFF820 &= ~0x20;
}

// 0000A180: void I2CIntRegister(Register word32 r1)
void I2CIntRegister(word32 r1)
{
	IntRegister(0x18, r1);
	IntEnable(0x18);
}

// 0000A194: void I2CIntUnregister()
void I2CIntUnregister()
{
	IntDisable(0x18);
	IntUnregister(0x18);
}

// 0000A1A8: void I2CMasterIntEnable(Register (ptr32 Eq_n) r0)
void I2CMasterIntEnable(struct Eq_n * r0)
{
	r0->dw0010 = 0x01;
}

// 0000A1B0: void I2CSlaveIntEnable(Register (ptr32 Eq_n) r0)
void I2CSlaveIntEnable(struct Eq_n * r0)
{
	r0->dw000C = 0x01;
}

// 0000A1B8: void I2CMasterIntDisable(Register (ptr32 Eq_n) r0)
void I2CMasterIntDisable(struct Eq_n * r0)
{
	r0->dw0010 = 0x00;
}

// 0000A1C0: void I2CSlaveIntDisable(Register (ptr32 Eq_n) r0)
void I2CSlaveIntDisable(struct Eq_n * r0)
{
	r0->dw000C = 0x00;
}

// 0000A1C8: Register (ptr32 Eq_n) I2CMasterIntStatus(Register (ptr32 Eq_n) r0, Register word32 r1)
// Called from:
//      OSRAMWriteArray
//      OSRAMWriteByte
//      OSRAMWriteFinal
struct Eq_n * I2CMasterIntStatus(struct Eq_n * r0, word32 r1)
{
	if (r1 != 0x00)
	{
		struct Eq_n * r0_n = r0->ptr0018;
		struct Eq_n * r0_n = r0_n;
		if (r0_n != null)
			r0_n = (struct Eq_n *) &g_t0001;
		return r0_n;
	}
	else
	{
		struct Eq_n * r0_n = r0->ptr0014;
		struct Eq_n * r0_n = r0_n;
		if (r0_n != null)
			r0_n = (struct Eq_n *) &g_t0001;
		return r0_n;
	}
}

// 0000A1E0: void I2CSlaveIntStatus(Register (ptr32 Eq_n) r0, Register word32 r1)
void I2CSlaveIntStatus(struct Eq_n * r0, word32 r1)
{
	if (r1 != 0x00)
		r0->dw0014 == 0x00;
	else
		r0->dw0010 == 0x00;
}

// 0000A1F8: void I2CMasterIntClear(Register (ptr32 Eq_n) r0)
void I2CMasterIntClear(struct Eq_n * r0)
{
	r0->dw001C = 0x01;
	r0->dw0018 = 0x01;
}

// 0000A200: void I2CSlaveIntClear(Register (ptr32 Eq_n) r0)
void I2CSlaveIntClear(struct Eq_n * r0)
{
	r0->dw0018 = 0x01;
}

// 0000A208: void I2CMasterSlaveAddrSet(Register (ptr32 Eq_n) r0, Register ui32 r1, Register ui32 r2)
// Called from:
//      OSRAMWriteFirst
void I2CMasterSlaveAddrSet(struct Eq_n * r0, ui32 r1, ui32 r2)
{
	r0->dw0000 = r2 | r1 << 0x01;
}

// 0000A210: void I2CMasterBusy()
void I2CMasterBusy()
{
}

// 0000A218: void I2CMasterBusBusy()
void I2CMasterBusBusy()
{
}

// 0000A220: void I2CMasterControl(Register (ptr32 Eq_n) r0, Register word32 r1)
// Called from:
//      OSRAMWriteFirst
//      OSRAMWriteArray
//      OSRAMWriteByte
//      OSRAMWriteFinal
void I2CMasterControl(struct Eq_n * r0, word32 r1)
{
	r0->dw0004 = r1;
}

// 0000A224: void I2CMasterErr(Register (ptr32 Eq_n) r0)
void I2CMasterErr(struct Eq_n * r0)
{
	ui32 r3_n = r0->dw0004;
	if (r3_n << 31 < 0x00 || (r3_n & 0x02) == 0x00)
		;
}

// 0000A23C: void I2CMasterDataPut(Register (ptr32 Eq_n) r0, Register ui32 r1)
// Called from:
//      OSRAMWriteFirst
//      OSRAMWriteArray
//      OSRAMWriteByte
//      OSRAMWriteFinal
void I2CMasterDataPut(struct Eq_n * r0, ui32 r1)
{
	r0->dw0008 = r1;
}

// 0000A240: void I2CMasterDataGet()
void I2CMasterDataGet()
{
}

// 0000A244: void I2CSlaveStatus()
void I2CSlaveStatus()
{
}

// 0000A248: void I2CSlaveDataPut(Register (ptr32 Eq_n) r0, Register word32 r1)
void I2CSlaveDataPut(struct Eq_n * r0, word32 r1)
{
	r0->dw0008 = r1;
}

// 0000A24C: void I2CSlaveDataGet()
void I2CSlaveDataGet()
{
}

byte g_bA268 = 0x53; // 0000A268
Eq_n g_aA284[] = // 0000A284
	{
	};
ui32 g_aA2A4[] = // 0000A2A4
	{
	};
word32 g_dwA2A8 = 0x0600; // 0000A2A8
Eq_n g_tA2F4 = // 0000A2F4
	{
		0xE0,
		0xB0,
	};
Eq_n g_tA2FC = // 0000A2FC
	{
		0x00,
		177,
	};
ui32 * g_aA554[] = // 0000A554
	{
	};
