{
     File:       ADSP.p
 
     Contains:   AppleTalk Data Stream Protocol (ADSP) Interfaces.
 
     Version:    Technology: System 7.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1986-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT ADSP;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __ADSP__}
{$SETC __ADSP__ := 1}

{$I+}
{$SETC ADSPIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACERRORS__}
{$I MacErrors.p}
{$ENDC}
{$IFC UNDEFINED __APPLETALK__}
{$I AppleTalk.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{driver control csCodes}

CONST
	dspInit						= 255;							{  create a new connection end  }
	dspRemove					= 254;							{  remove a connection end  }
	dspOpen						= 253;							{  open a connection  }
	dspClose					= 252;							{  close a connection  }
	dspCLInit					= 251;							{  create a connection listener  }
	dspCLRemove					= 250;							{  remove a connection listener  }
	dspCLListen					= 249;							{  post a listener request  }
	dspCLDeny					= 248;							{  deny an open connection request  }
	dspStatus					= 247;							{  get status of connection end  }
	dspRead						= 246;							{  read data from the connection  }
	dspWrite					= 245;							{  write data on the connection  }
	dspAttention				= 244;							{  send an attention message  }
	dspOptions					= 243;							{  set connection end options  }
	dspReset					= 242;							{  forward reset the connection  }
	dspNewCID					= 241;							{  generate a cid for a connection end  }

																{  connection opening modes  }
	ocRequest					= 1;							{  request a connection with remote  }
	ocPassive					= 2;							{  wait for a connection request from remote  }
	ocAccept					= 3;							{  accept request as delivered by listener  }
	ocEstablish					= 4;							{  consider connection to be open  }

																{  connection end states  }
	sListening					= 1;							{  for connection listeners  }
	sPassive					= 2;							{  waiting for a connection request from remote  }
	sOpening					= 3;							{  requesting a connection with remote  }
	sOpen						= 4;							{  connection is open  }
	sClosing					= 5;							{  connection is being torn down  }
	sClosed						= 6;							{  connection end state is closed  }

																{  client event flags  }
	eClosed						= $80;							{  received connection closed advice  }
	eTearDown					= $40;							{  connection closed due to broken connection  }
	eAttention					= $20;							{  received attention message  }
	eFwdReset					= $10;							{  received forward reset advice  }

																{  miscellaneous constants  }
	attnBufSize					= 570;							{  size of client attention buffer  }
	minDSPQueueSize				= 100;							{  Minimum size of receive or send Queue  }

	{	 connection control block 	}

TYPE
	TRCCBPtr = ^TRCCB;
	TPCCB								= ^TRCCB;
	TRCCB = PACKED RECORD
		ccbLink:				TPCCB;									{  link to next ccb  }
		refNum:					UInt16;									{  user reference number  }
		state:					UInt16;									{  state of the connection end  }
		userFlags:				UInt8;									{  flags for unsolicited connection events  }
		localSocket:			UInt8;									{  socket number of this connection end  }
		remoteAddress:			AddrBlock;								{  internet address of remote end  }
		attnCode:				UInt16;									{  attention code received  }
		attnSize:				UInt16;									{  size of received attention data  }
		attnPtr:				Ptr;									{  ptr to received attention data  }
		reserved:				PACKED ARRAY [0..219] OF UInt8;			{  for adsp internal use  }
	END;

{$IFC TYPED_FUNCTION_POINTERS}
	ADSPConnectionEventProcPtr = PROCEDURE(sourceCCB: TPCCB);
{$ELSEC}
	ADSPConnectionEventProcPtr = Register68kProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ADSPCompletionProcPtr = PROCEDURE(thePBPtr: DSPPBPtr);
{$ELSEC}
	ADSPCompletionProcPtr = Register68kProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	ADSPConnectionEventUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ADSPConnectionEventUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ADSPCompletionUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ADSPCompletionUPP = UniversalProcPtr;
{$ENDC}	
	DSPParamBlockPtr = ^DSPParamBlock;
	DSPParamBlock = PACKED RECORD
		qLink:					QElemPtr;
		qType:					INTEGER;
		ioTrap:					INTEGER;
		ioCmdAddr:				Ptr;
		ioCompletion:			ADSPCompletionUPP;
		ioResult:				OSErr;
		ioNamePtr:				StringPtr;
		ioVRefNum:				INTEGER;
		ioCRefNum:				INTEGER;								{  adsp driver refNum  }
		csCode:					INTEGER;								{  adsp driver control code  }
		qStatus:				LONGINT;								{  adsp internal use  }
		ccbRefNum:				INTEGER;
		CASE INTEGER OF
		0: (
			ccbPtr:				TPCCB;									{  pointer to connection control block  }
			userRoutine:		ADSPConnectionEventUPP;					{  client routine to call on event  }
			sendQSize:			UInt16;									{  size of send queue (0..64K bytes)  }
			sendQueue:			Ptr;									{  client passed send queue buffer  }
			recvQSize:			UInt16;									{  size of receive queue (0..64K bytes)  }
			recvQueue:			Ptr;									{  client passed receive queue buffer  }
			attnPtr:			Ptr;									{  client passed receive attention buffer  }
			localSocket:		UInt8;									{  local socket number  }
			filler1:			UInt8;									{  filler for proper byte alignment  }
		   );
		1: (
			localCID:			UInt16;									{  local connection id  }
			remoteCID:			UInt16;									{  remote connection id  }
			remoteAddress:		AddrBlock;								{  address of remote end  }
			filterAddress:		AddrBlock;								{  address filter  }
			sendSeq:			UInt32;									{  local send sequence number  }
			sendWindow:			UInt16;									{  send window size  }
			recvSeq:			UInt32;									{  receive sequence number  }
			attnSendSeq:		UInt32;									{  attention send sequence number  }
			attnRecvSeq:		UInt32;									{  attention receive sequence number  }
			ocMode:				UInt8;									{  open connection mode  }
			ocInterval:			UInt8;									{  open connection request retry interval  }
			ocMaximum:			UInt8;									{  open connection request retry maximum  }
			filler2:			UInt8;									{  filler for proper byte alignment  }
		   );
		2: (
			abort:				UInt8;									{  abort connection immediately if non-zero  }
			filler3:			UInt8;									{  filler for proper byte alignment  }
		   );
		3: (
			reqCount:			UInt16;									{  requested number of bytes  }
			actCount:			UInt16;									{  actual number of bytes  }
			dataPtr:			Ptr;									{  pointer to data buffer  }
			eom:				UInt8;									{  indicates logical end of message  }
			flush:				UInt8;									{  send data now  }
		   );
		4: (
			attnCode:			UInt16;									{  client attention code  }
			attnSize:			UInt16;									{  size of attention data  }
			attnData:			Ptr;									{  pointer to attention data  }
			attnInterval:		UInt8;									{  retransmit timer in 10-tick intervals  }
			filler4:			UInt8;									{  filler for proper byte alignment  }
		   );
		5: (
			statusCCB:			TPCCB;									{  pointer to ccb  }
			sendQPending:		UInt16;									{  pending bytes in send queue  }
			sendQFree:			UInt16;									{  available buffer space in send queue  }
			recvQPending:		UInt16;									{  pending bytes in receive queue  }
			recvQFree:			UInt16;									{  available buffer space in receive queue  }
		   );
		6: (
			sendBlocking:		UInt16;									{  quantum for data packets  }
			sendTimer:			UInt8;									{  send timer in 10-tick intervals  }
			rtmtTimer:			UInt8;									{  retransmit timer in 10-tick intervals  }
			badSeqMax:			UInt8;									{  threshold for sending retransmit advice  }
			useCheckSum:		UInt8;									{  use ddp packet checksum  }
		   );
		7: (
			newcid:				UInt16;									{  new connection id returned  }
		   );
	END;

	DSPPBPtr							= ^DSPParamBlock;

CONST
	uppADSPConnectionEventProcInfo = $0000B802;
	uppADSPCompletionProcInfo = $00009802;
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  NewADSPConnectionEventUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION NewADSPConnectionEventUPP(userRoutine: ADSPConnectionEventProcPtr): ADSPConnectionEventUPP; { old name was NewADSPConnectionEventProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewADSPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NewADSPCompletionUPP(userRoutine: ADSPCompletionProcPtr): ADSPCompletionUPP; { old name was NewADSPCompletionProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeADSPConnectionEventUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeADSPConnectionEventUPP(userUPP: ADSPConnectionEventUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeADSPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeADSPCompletionUPP(userUPP: ADSPCompletionUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeADSPConnectionEventUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE InvokeADSPConnectionEventUPP(sourceCCB: TPCCB; userRoutine: ADSPConnectionEventUPP); { old name was CallADSPConnectionEventProc }
{
 *  InvokeADSPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE InvokeADSPCompletionUPP(thePBPtr: DSPPBPtr; userRoutine: ADSPCompletionUPP); { old name was CallADSPCompletionProc }
{$ENDC}  {CALL_NOT_IN_CARBON}


{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := ADSPIncludes}

{$ENDC} {__ADSP__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AEDataModel.p
 
     Contains:   AppleEvent Data Model Interfaces.
 
     Version:    Technology: Mac OS 9
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1996-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AEDataModel;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AEDATAMODEL__}
{$SETC __AEDATAMODEL__ := 1}

{$I+}
{$SETC AEDataModelIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __MIXEDMODE__}
{$I MixedMode.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{ Apple event descriptor types }

CONST
	typeBoolean					= 'bool';
	typeChar					= 'TEXT';

	{	 Preferred numeric Apple event descriptor types 	}
	typeSInt16					= 'shor';
	typeSInt32					= 'long';
	typeUInt32					= 'magn';
	typeSInt64					= 'comp';
	typeIEEE32BitFloatingPoint	= 'sing';
	typeIEEE64BitFloatingPoint	= 'doub';
	type128BitFloatingPoint		= 'ldbl';
	typeDecimalStruct			= 'decm';

	{	 Non-preferred Apple event descriptor types 	}
	typeSMInt					= 'shor';
	typeShortInteger			= 'shor';
	typeInteger					= 'long';
	typeLongInteger				= 'long';
	typeMagnitude				= 'magn';
	typeComp					= 'comp';
	typeSMFloat					= 'sing';
	typeShortFloat				= 'sing';
	typeFloat					= 'doub';
	typeLongFloat				= 'doub';
	typeExtended				= 'exte';

	{	 More Apple event descriptor types 	}
	typeAEList					= 'list';
	typeAERecord				= 'reco';
	typeAppleEvent				= 'aevt';
	typeEventRecord				= 'evrc';
	typeTrue					= 'true';
	typeFalse					= 'fals';
	typeAlias					= 'alis';
	typeEnumerated				= 'enum';
	typeType					= 'type';
	typeAppParameters			= 'appa';
	typeProperty				= 'prop';
	typeFSS						= 'fss ';
	typeFSRef					= 'fsrf';
	typeKeyword					= 'keyw';
	typeSectionH				= 'sect';
	typeWildCard				= '****';
	typeApplSignature			= 'sign';
	typeQDRectangle				= 'qdrt';
	typeFixed					= 'fixd';
	typeProcessSerialNumber		= 'psn ';
	typeApplicationURL			= 'aprl';
	typeNull					= 'null';						{  null or nonexistent data  }

{$IFC CALL_NOT_IN_CARBON }
	{	 Deprecated addressing modes under Carbon 	}
	typeSessionID				= 'ssid';
	typeTargetID				= 'targ';
	typeDispatcherID			= 'dspt';

{$ENDC}  {CALL_NOT_IN_CARBON}

	{	 Keywords for Apple event attributes 	}
	keyTransactionIDAttr		= 'tran';
	keyReturnIDAttr				= 'rtid';
	keyEventClassAttr			= 'evcl';
	keyEventIDAttr				= 'evid';
	keyAddressAttr				= 'addr';
	keyOptionalKeywordAttr		= 'optk';
	keyTimeoutAttr				= 'timo';
	keyInteractLevelAttr		= 'inte';						{  this attribute is read only - will be set in AESend  }
	keyEventSourceAttr			= 'esrc';						{  this attribute is read only - returned as typeShortInteger  }
	keyMissedKeywordAttr		= 'miss';						{  this attribute is read only  }
	keyOriginalAddressAttr		= 'from';						{  new in 1.0.1  }
	keyAcceptTimeoutAttr		= 'actm';						{  new for Mac OS X  }


	{	  Constants used for specifying the factoring of AEDescLists. 	}
	kAEDescListFactorNone		= 0;
	kAEDescListFactorType		= 4;
	kAEDescListFactorTypeAndSize = 8;

	{	 Constants used creating an AppleEvent 	}
																{  Constant for the returnID param of AECreateAppleEvent  }
	kAutoGenerateReturnID		= -1;							{  AECreateAppleEvent will generate a session-unique ID  }
																{  Constant for transaction ID�s  }
	kAnyTransactionID			= 0;							{  no transaction is in use  }

	{	 Apple event manager data types 	}

TYPE
	DescType							= ResType;
	AEKeyword							= FourCharCode;
{$IFC OPAQUE_TOOLBOX_STRUCTS }
	AEDataStorage    = ^LONGINT; { an opaque 32-bit type }
	AEDataStoragePtr = ^AEDataStorage;  { when a VAR xx:AEDataStorage parameter can be nil, it is changed to xx: AEDataStoragePtr }
{$ELSEC}
	AEDataStorage						= Handle;
{$ENDC}  {OPAQUE_TOOLBOX_STRUCTS}

	AEDescPtr = ^AEDesc;
	AEDesc = RECORD
		descriptorType:			DescType;
		dataHandle:				AEDataStorage;
	END;

	AEKeyDescPtr = ^AEKeyDesc;
	AEKeyDesc = RECORD
		descKey:				AEKeyword;
		descContent:			AEDesc;
	END;

	{	 a list of AEDesc's is a special kind of AEDesc 	}
	AEDescList							= AEDesc;
	AEDescListPtr 						= ^AEDescList;
	{	 AERecord is a list of keyworded AEDesc's 	}
	AERecord							= AEDescList;
	AERecordPtr 						= ^AERecord;
	{	 an AEDesc which contains address data 	}
	AEAddressDesc						= AEDesc;
	AEAddressDescPtr 					= ^AEAddressDesc;
	{	 an AERecord that contains an AppleEvent, and related data types 	}
	AppleEvent							= AERecord;
	AppleEventPtr 						= ^AppleEvent;
	AEReturnID							= SInt16;
	AETransactionID						= SInt32;
	AEEventClass						= FourCharCode;
	AEEventID							= FourCharCode;
	AEArrayType							= SInt8;

CONST
	kAEDataArray				= 0;
	kAEPackedArray				= 1;
	kAEDescArray				= 3;
	kAEKeyDescArray				= 4;


	kAEHandleArray				= 2;


TYPE
	AEArrayDataPtr = ^AEArrayData;
	AEArrayData = RECORD
		CASE INTEGER OF
		0: (
			kAEDataArray:		ARRAY [0..0] OF INTEGER;
			);
		1: (
			kAEPackedArray:		SInt8;
			);
		2: (
			kAEHandleArray:		ARRAY [0..0] OF Handle;
			);
		3: (
			kAEDescArray:		ARRAY [0..0] OF AEDesc;
			);
		4: (
			kAEKeyDescArray:	ARRAY [0..0] OF AEKeyDesc;
			);
	END;

	AEArrayDataPointer					= ^AEArrayData;
	AEArrayDataPointerPtr 				= ^AEArrayDataPointer;
	{	************************************************************************* 
	  These constants are used by AEMach and AEInteraction APIs.  They are not
	  strictly part of the data format, but are declared here due to layering.
	*************************************************************************	}
	AESendPriority 				= SInt16;
CONST
	kAENormalPriority			= $00000000;					{  post message at the end of the event queue  }
	kAEHighPriority				= $00000001;					{  post message at the front of the event queue (same as nAttnMsg)  }



TYPE
	AESendMode 					= SInt32;
CONST
	kAENoReply					= $00000001;					{  sender doesn't want a reply to event  }
	kAEQueueReply				= $00000002;					{  sender wants a reply but won't wait  }
	kAEWaitReply				= $00000003;					{  sender wants a reply and will wait  }
	kAEDontReconnect			= $00000080;					{  don't reconnect if there is a sessClosedErr from PPCToolbox  }
	kAEWantReceipt				= $00000200;					{  (nReturnReceipt) sender wants a receipt of message  }
	kAENeverInteract			= $00000010;					{  server should not interact with user  }
	kAECanInteract				= $00000020;					{  server may try to interact with user  }
	kAEAlwaysInteract			= $00000030;					{  server should always interact with user where appropriate  }
	kAECanSwitchLayer			= $00000040;					{  interaction may switch layer  }
	kAEDontRecord				= $00001000;					{  don't record this event - available only in vers 1.0.1 and greater  }
	kAEDontExecute				= $00002000;					{  don't send the event for recording - available only in vers 1.0.1 and greater  }
	kAEProcessNonReplyEvents	= $00008000;					{  allow processing of non-reply events while awaiting synchronous AppleEvent reply  }


	{	 Constants for timeout durations 	}
	kAEDefaultTimeout			= -1;							{  timeout value determined by AEM  }
	kNoTimeOut					= -2;							{  wait until reply comes back, however long it takes  }


	{	*************************************************************************
	  These calls are used to set up and modify the coercion dispatch table.
	*************************************************************************	}

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	AECoerceDescProcPtr = FUNCTION({CONST}VAR fromDesc: AEDesc; toType: DescType; handlerRefcon: LONGINT; VAR toDesc: AEDesc): OSErr;
{$ELSEC}
	AECoerceDescProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	AECoercePtrProcPtr = FUNCTION(typeCode: DescType; dataPtr: UNIV Ptr; dataSize: Size; toType: DescType; handlerRefcon: LONGINT; VAR result: AEDesc): OSErr;
{$ELSEC}
	AECoercePtrProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	AECoerceDescUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AECoerceDescUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	AECoercePtrUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AECoercePtrUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppAECoerceDescProcInfo = $00003FE0;
	uppAECoercePtrProcInfo = $0003FFE0;
	{
	 *  NewAECoerceDescUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewAECoerceDescUPP(userRoutine: AECoerceDescProcPtr): AECoerceDescUPP; { old name was NewAECoerceDescProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewAECoercePtrUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewAECoercePtrUPP(userRoutine: AECoercePtrProcPtr): AECoercePtrUPP; { old name was NewAECoercePtrProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeAECoerceDescUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAECoerceDescUPP(userUPP: AECoerceDescUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeAECoercePtrUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAECoercePtrUPP(userUPP: AECoercePtrUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeAECoerceDescUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeAECoerceDescUPP({CONST}VAR fromDesc: AEDesc; toType: DescType; handlerRefcon: LONGINT; VAR toDesc: AEDesc; userRoutine: AECoerceDescUPP): OSErr; { old name was CallAECoerceDescProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeAECoercePtrUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeAECoercePtrUPP(typeCode: DescType; dataPtr: UNIV Ptr; dataSize: Size; toType: DescType; handlerRefcon: LONGINT; VAR result: AEDesc; userRoutine: AECoercePtrUPP): OSErr; { old name was CallAECoercePtrProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{ a AECoercionHandlerUPP is by default a AECoerceDescUPP.  If you are registering a 
    Ptr based coercion handler you will have to add a cast to AECoerceDescUPP from 
    your AECoercePtrUPP type.  A future release of the interfaces will fix this by
    introducing seperate Desc and Ptr coercion handler installation/remove/query routines. }

TYPE
	AECoercionHandlerUPP				= AECoerceDescUPP;
	{
	 *  AEInstallCoercionHandler()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION AEInstallCoercionHandler(fromType: DescType; toType: DescType; handler: AECoercionHandlerUPP; handlerRefcon: LONGINT; fromTypeIsDesc: BOOLEAN; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0A22, $A816;
	{$ENDC}

{
 *  AERemoveCoercionHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AERemoveCoercionHandler(fromType: DescType; toType: DescType; handler: AECoercionHandlerUPP; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0723, $A816;
	{$ENDC}


{
 *  AEGetCoercionHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetCoercionHandler(fromType: DescType; toType: DescType; VAR handler: AECoercionHandlerUPP; VAR handlerRefcon: LONGINT; VAR fromTypeIsDesc: BOOLEAN; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0B24, $A816;
	{$ENDC}

{*************************************************************************
  The following calls provide for a coercion interface.
*************************************************************************}
{
 *  AECoercePtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AECoercePtr(typeCode: DescType; dataPtr: UNIV Ptr; dataSize: Size; toType: DescType; VAR result: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0A02, $A816;
	{$ENDC}

{
 *  AECoerceDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AECoerceDesc({CONST}VAR theAEDesc: AEDesc; toType: DescType; VAR result: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0603, $A816;
	{$ENDC}


{*************************************************************************
 The following calls apply to any AEDesc. Every 'result' descriptor is
 created for you, so you will be responsible for memory management
 (including disposing) of the descriptors so created.  
*************************************************************************}
{ because AEDescs are opaque under Carbon, this AEInitializeDesc provides a
   'clean' way of initializating them to be empty. }
{
 *  AEInitializeDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE AEInitializeDesc(VAR desc: AEDesc); C;


{
 *  AECreateDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AECreateDesc(typeCode: DescType; dataPtr: UNIV Ptr; dataSize: Size; VAR result: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0825, $A816;
	{$ENDC}

{
 *  AEDisposeDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEDisposeDesc(VAR theAEDesc: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0204, $A816;
	{$ENDC}

{
 *  AEDuplicateDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEDuplicateDesc({CONST}VAR theAEDesc: AEDesc; VAR result: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0405, $A816;
	{$ENDC}


{*************************************************************************
  The following calls apply to AEDescList. Since AEDescList is a subtype of
  AEDesc, the calls in the previous section can also be used for AEDescList.
  All list and array indices are 1-based. If the data was greater than
  maximumSize in the routines below, then actualSize will be greater than
  maximumSize, but only maximumSize bytes will actually be retrieved.
*************************************************************************}
{
 *  AECreateList()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AECreateList(factoringPtr: UNIV Ptr; factoredSize: Size; isRecord: BOOLEAN; VAR resultList: AEDescList): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0706, $A816;
	{$ENDC}

{
 *  AECountItems()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AECountItems({CONST}VAR theAEDescList: AEDescList; VAR theCount: LONGINT): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0407, $A816;
	{$ENDC}

{
 *  AEPutPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEPutPtr(VAR theAEDescList: AEDescList; index: LONGINT; typeCode: DescType; dataPtr: UNIV Ptr; dataSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0A08, $A816;
	{$ENDC}

{
 *  AEPutDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEPutDesc(VAR theAEDescList: AEDescList; index: LONGINT; {CONST}VAR theAEDesc: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0609, $A816;
	{$ENDC}

{
 *  AEGetNthPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetNthPtr({CONST}VAR theAEDescList: AEDescList; index: LONGINT; desiredType: DescType; VAR theAEKeyword: AEKeyword; VAR typeCode: DescType; dataPtr: UNIV Ptr; maximumSize: Size; VAR actualSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $100A, $A816;
	{$ENDC}

{
 *  AEGetNthDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetNthDesc({CONST}VAR theAEDescList: AEDescList; index: LONGINT; desiredType: DescType; VAR theAEKeyword: AEKeyword; VAR result: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0A0B, $A816;
	{$ENDC}

{
 *  AESizeOfNthItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AESizeOfNthItem({CONST}VAR theAEDescList: AEDescList; index: LONGINT; VAR typeCode: DescType; VAR dataSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $082A, $A816;
	{$ENDC}

{
 *  AEGetArray()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetArray({CONST}VAR theAEDescList: AEDescList; arrayType: AEArrayType; arrayPtr: AEArrayDataPointer; maximumSize: Size; VAR itemType: DescType; VAR itemSize: Size; VAR itemCount: LONGINT): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0D0C, $A816;
	{$ENDC}

{
 *  AEPutArray()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEPutArray(VAR theAEDescList: AEDescList; arrayType: AEArrayType; {CONST}VAR arrayPtr: AEArrayData; itemType: DescType; itemSize: Size; itemCount: LONGINT): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0B0D, $A816;
	{$ENDC}

{
 *  AEDeleteItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEDeleteItem(VAR theAEDescList: AEDescList; index: LONGINT): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $040E, $A816;
	{$ENDC}


{*************************************************************************
 The following calls apply to AERecord. Since AERecord is a subtype of
 AEDescList, the calls in the previous sections can also be used for
 AERecord an AERecord can be created by using AECreateList with isRecord
 set to true. 
*************************************************************************}
{************************************************************************
 AERecords can have an abitrary descriptorType.  This allows you to
 check if desc is truly an AERecord
***********************************************************************}
{
 *  AECheckIsRecord()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AECheckIsRecord({CONST}VAR theDesc: AEDesc): BOOLEAN; C;

{
  Note: none of the �key� calls were available in the PowerPC 7.x IntefaceLib.
  In C, a #define is used to map �key� calls to �param� calls.  In pascal
  this mapping is done in externally linked glue code.
}
{$IFC CALL_NOT_IN_CARBON }
{
 *  AEPutKeyPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AEPutKeyPtr(VAR theAERecord: AERecord; theAEKeyword: AEKeyword; typeCode: DescType; dataPtr: UNIV Ptr; dataSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0A0F, $A816;
	{$ENDC}

{
 *  AEPutKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AEPutKeyDesc(VAR theAERecord: AERecord; theAEKeyword: AEKeyword; {CONST}VAR theAEDesc: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0610, $A816;
	{$ENDC}

{
 *  AEGetKeyPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AEGetKeyPtr({CONST}VAR theAERecord: AERecord; theAEKeyword: AEKeyword; desiredType: DescType; VAR typeCode: DescType; dataPtr: UNIV Ptr; maximumSize: Size; VAR actualSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0E11, $A816;
	{$ENDC}

{
 *  AEGetKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AEGetKeyDesc({CONST}VAR theAERecord: AERecord; theAEKeyword: AEKeyword; desiredType: DescType; VAR result: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0812, $A816;
	{$ENDC}

{
 *  AESizeOfKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AESizeOfKeyDesc({CONST}VAR theAERecord: AERecord; theAEKeyword: AEKeyword; VAR typeCode: DescType; VAR dataSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0829, $A816;
	{$ENDC}

{
 *  AEDeleteKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AEDeleteKeyDesc(VAR theAERecord: AERecord; theAEKeyword: AEKeyword): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0413, $A816;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}

{*************************************************************************
  The following calls create and manipulate the AppleEvent data type.
*************************************************************************}
{
 *  AECreateAppleEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AECreateAppleEvent(theAEEventClass: AEEventClass; theAEEventID: AEEventID; {CONST}VAR target: AEAddressDesc; returnID: AEReturnID; transactionID: AETransactionID; VAR result: AppleEvent): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0B14, $A816;
	{$ENDC}


{*************************************************************************
  The following calls are used to pack and unpack parameters from records
  of type AppleEvent. Since AppleEvent is a subtype of AERecord, the calls
  in the previous sections can also be used for variables of type
  AppleEvent. The next six calls are in fact identical to the six calls
  for AERecord.
*************************************************************************}
{
 *  AEPutParamPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEPutParamPtr(VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; typeCode: DescType; dataPtr: UNIV Ptr; dataSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0A0F, $A816;
	{$ENDC}

{
 *  AEPutParamDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEPutParamDesc(VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; {CONST}VAR theAEDesc: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0610, $A816;
	{$ENDC}

{
 *  AEGetParamPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetParamPtr({CONST}VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; desiredType: DescType; VAR typeCode: DescType; dataPtr: UNIV Ptr; maximumSize: Size; VAR actualSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0E11, $A816;
	{$ENDC}

{
 *  AEGetParamDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetParamDesc({CONST}VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; desiredType: DescType; VAR result: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0812, $A816;
	{$ENDC}

{
 *  AESizeOfParam()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AESizeOfParam({CONST}VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; VAR typeCode: DescType; VAR dataSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0829, $A816;
	{$ENDC}

{
 *  AEDeleteParam()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEDeleteParam(VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0413, $A816;
	{$ENDC}



{*************************************************************************
 The following calls also apply to type AppleEvent. Message attributes are
 far more restricted, and can only be accessed through the following 5
 calls. The various list and record routines cannot be used to access the
 attributes of an event. 
*************************************************************************}
{
 *  AEGetAttributePtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetAttributePtr({CONST}VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; desiredType: DescType; VAR typeCode: DescType; dataPtr: UNIV Ptr; maximumSize: Size; VAR actualSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0E15, $A816;
	{$ENDC}

{
 *  AEGetAttributeDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetAttributeDesc({CONST}VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; desiredType: DescType; VAR result: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0826, $A816;
	{$ENDC}

{
 *  AESizeOfAttribute()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AESizeOfAttribute({CONST}VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; VAR typeCode: DescType; VAR dataSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0828, $A816;
	{$ENDC}

{
 *  AEPutAttributePtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEPutAttributePtr(VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; typeCode: DescType; dataPtr: UNIV Ptr; dataSize: Size): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0A16, $A816;
	{$ENDC}

{
 *  AEPutAttributeDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEPutAttributeDesc(VAR theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; {CONST}VAR theAEDesc: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0627, $A816;
	{$ENDC}


{*************************************************************************
 AppleEvent Serialization Support

    AESizeOfFlattenedDesc, AEFlattenDesc, AEUnflattenDesc
    
    These calls will work for all AppleEvent data types and between different
    versions of the OS (including between Mac OS 9 and X)
    
    Basic types, AEDesc, AEList and AERecord are OK, but AppleEvent records
    themselves may not be reliably flattened for storage.
*************************************************************************}
{
   AEFlattenDesc
   Returns the amount of buffer space needed to flatten the
   AEDesc. Call this before AEFlattenDesc to make sure your
   buffer has enough room for the operation.
}

{
 *  AESizeOfFlattenedDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AESizeOfFlattenedDesc({CONST}VAR theAEDesc: AEDesc): Size; C;

{
   AEFlattenDesc
   Fills a buffer with a flattened representation of the
   AEDesc and returns the amount of buffer used in actualSize.
   If bufferSize was too small it returns errAEBufferTooSmall
   (-1741) and does not fill in any of the buffer. The resulting
   buffer is only useful with an AEUnflattenDesc call.
   
   Note: if you pass a NULL buffer pointer it returns noErr but
   fills in the actualSize field anyway.
}

{
 *  AEFlattenDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEFlattenDesc({CONST}VAR theAEDesc: AEDesc; buffer: Ptr; bufferSize: Size; VAR actualSize: Size): OSStatus; C;

{
   AEUnflattenDesc
   Allocates an AEDesc (given a Null Desc) given a flattened
   data buffer. It assumes it was given a good buffer filled
   in by AEFlattenDesc. It returns paramErr if it discovers
   something fishy about the buffer.
}

{
 *  AEUnflattenDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEUnflattenDesc(buffer: Ptr; VAR result: AEDesc): OSStatus; C;

{*************************************************************************
 The following calls are necessary to deal with opaque data in AEDescs, because the
 traditional way of dealing with a basic AEDesc has been to dereference the dataHandle
 directly.  This is not supported under Carbon.
*************************************************************************}
{$IFC ACCESSOR_CALLS_ARE_FUNCTIONS }
{
        AEGetDescData no longer supports automatic coercion. If you'd like to
        coerce the descriptor use AECoerceDesc.
    }
{
 *  AEGetDescData()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CarbonAccessors.o 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetDescData({CONST}VAR theAEDesc: AEDesc; dataPtr: UNIV Ptr; maximumSize: Size): OSErr;

{
 *  AEGetDescDataSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CarbonAccessors.o 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetDescDataSize({CONST}VAR theAEDesc: AEDesc): Size;

{
 *  AEReplaceDescData()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CarbonAccessors.o 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEReplaceDescData(typeCode: DescType; dataPtr: UNIV Ptr; dataSize: Size; VAR theAEDesc: AEDesc): OSErr;

{$ENDC}  {ACCESSOR_CALLS_ARE_FUNCTIONS}


{*************************************************************************
  A AEEventHandler is installed to process an AppleEvent 
*************************************************************************}

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	AEEventHandlerProcPtr = FUNCTION({CONST}VAR theAppleEvent: AppleEvent; VAR reply: AppleEvent; handlerRefcon: LONGINT): OSErr;
{$ELSEC}
	AEEventHandlerProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	AEEventHandlerUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AEEventHandlerUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppAEEventHandlerProcInfo = $00000FE0;
	{
	 *  NewAEEventHandlerUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewAEEventHandlerUPP(userRoutine: AEEventHandlerProcPtr): AEEventHandlerUPP; { old name was NewAEEventHandlerProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeAEEventHandlerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAEEventHandlerUPP(userUPP: AEEventHandlerUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeAEEventHandlerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeAEEventHandlerUPP({CONST}VAR theAppleEvent: AppleEvent; VAR reply: AppleEvent; handlerRefcon: LONGINT; userRoutine: AEEventHandlerUPP): OSErr; { old name was CallAEEventHandlerProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}


{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AEDataModelIncludes}

{$ENDC} {__AEDATAMODEL__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AEHelpers.p
 
     Contains:   AEPrint, AEBuild and AEStream for Carbon
 
     Version:    Technology: Mac OS X, CarbonLib
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{
 * Originally from AEGIzmos by Jens Alfke, circa 1992.
 }
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AEHelpers;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AEHELPERS__}
{$SETC __AEHELPERS__ := 1}

{$I+}
{$SETC AEHelpersIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __APPLEEVENTS__}
{$I AppleEvents.p}
{$ENDC}
{$IFC UNDEFINED __AEDATAMODEL__}
{$I AEDataModel.p}
{$ENDC}

{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{
 * AEBuild is only available for C programmers.
 }
{
 * AEPrintDescToHandle
 *
 * AEPrintDescToHandle provides a way to turn an AEDesc into a textual
 * representation.  This is most useful for debugging calls to
 * AEBuildDesc and friends.  The Handle returned should be disposed by
 * the caller.  The size of the handle is the actual number of
 * characters in the string.
 }
{
 *  AEPrintDescToHandle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEPrintDescToHandle({CONST}VAR desc: AEDesc; VAR result: Handle): OSStatus; C;

{
 * AEStream:
 *
 * The AEStream interface allows you to build AppleEvents by appending
 * to an opaque structure (an AEStreamRef) and then turning this
 * structure into an AppleEvent.  The basic idea is to open the
 * stream, write data, and then close it - closing it produces an
 * AEDesc, which may be partially complete, or may be a complete
 * AppleEvent.
 }

TYPE
	AEStreamRef    = ^LONGINT; { an opaque 32-bit type }
	AEStreamRefPtr = ^AEStreamRef;  { when a VAR xx:AEStreamRef parameter can be nil, it is changed to xx: AEStreamRefPtr }
	{
	   Create and return an AEStreamRef
	   Returns NULL on memory allocation failure
	}
	{
	 *  AEStreamOpen()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION AEStreamOpen: AEStreamRef; C;

{
   Closes and disposes of an AEStreamRef, producing
   results in the desc.  You must dispose of the desc yourself.
   If you just want to dispose of the AEStreamRef, you can pass NULL for desc.
}
{
 *  AEStreamClose()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamClose(ref: AEStreamRef; VAR desc: AEDesc): OSStatus; C;

{
   Prepares an AEStreamRef for appending data to a newly created desc.
   You append data with AEStreamWriteData
}
{
 *  AEStreamOpenDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamOpenDesc(ref: AEStreamRef; newType: DescType): OSStatus; C;

{  Append data to the previously opened desc. }
{
 *  AEStreamWriteData()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamWriteData(ref: AEStreamRef; data: UNIV Ptr; length: Size): OSStatus; C;

{
   Finish a desc.  After this, you can close the stream, or adding new
   descs, if you're assembling a list.
}
{
 *  AEStreamCloseDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamCloseDesc(ref: AEStreamRef): OSStatus; C;

{  Write data as a desc to the stream }
{
 *  AEStreamWriteDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamWriteDesc(ref: AEStreamRef; newType: DescType; data: UNIV Ptr; length: Size): OSStatus; C;

{  Write an entire desc to the stream }
{
 *  AEStreamWriteAEDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamWriteAEDesc(ref: AEStreamRef; {CONST}VAR desc: AEDesc): OSStatus; C;

{
   Begin a list.  You can then append to the list by doing
   AEStreamOpenDesc, or AEStreamWriteDesc.
}
{
 *  AEStreamOpenList()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamOpenList(ref: AEStreamRef): OSStatus; C;

{  Finish a list. }
{
 *  AEStreamCloseList()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamCloseList(ref: AEStreamRef): OSStatus; C;

{
   Begin a record.  A record usually has type 'reco', however, this is
   rather generic, and frequently a different type is used.
}
{
 *  AEStreamOpenRecord()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamOpenRecord(ref: AEStreamRef; newType: DescType): OSStatus; C;

{  Change the type of a record. }
{
 *  AEStreamSetRecordType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamSetRecordType(ref: AEStreamRef; newType: DescType): OSStatus; C;

{  Finish a record }
{
 *  AEStreamCloseRecord()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamCloseRecord(ref: AEStreamRef): OSStatus; C;

{
   Add a keyed descriptor to a record.  This is analogous to AEPutParamDesc.
   it can only be used when writing to a record.
}
{
 *  AEStreamWriteKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamWriteKeyDesc(ref: AEStreamRef; key: AEKeyword; newType: DescType; data: UNIV Ptr; length: Size): OSStatus; C;

{
   OpenDesc for a keyed record entry.  You can youse AEStreamWriteData
   after opening a keyed desc.
}
{
 *  AEStreamOpenKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamOpenKeyDesc(ref: AEStreamRef; key: AEKeyword; newType: DescType): OSStatus; C;

{  Write a key to the stream - you can follow this with an AEWriteDesc. }
{
 *  AEStreamWriteKey()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamWriteKey(ref: AEStreamRef; key: AEKeyword): OSStatus; C;

{
   Create a complete AppleEvent.  This creates and returns a new stream.
   Use this call to populate the meta fields in an AppleEvent record.
   After this, you can add your records, lists and other parameters.
}
{
 *  AEStreamCreateEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamCreateEvent(clazz: AEEventClass; id: AEEventID; targetType: DescType; targetData: UNIV Ptr; targetLength: LONGINT; returnID: INTEGER; transactionID: LONGINT): AEStreamRef; C;

{
   This call lets you augment an existing AppleEvent using the stream
   APIs.  This would be useful, for example, in constructing the reply
   record in an AppleEvent handler.  Note that AEStreamOpenEvent will
   consume the AppleEvent passed in - you can't access it again until the
   stream is closed.  When you're done building the event, AEStreamCloseStream
    will reconstitute it.
}
{
 *  AEStreamOpenEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamOpenEvent(VAR event: AppleEvent): AEStreamRef; C;

{  Mark a keyword as being an optional parameter. }
{
 *  AEStreamOptionalParam()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEStreamOptionalParam(ref: AEStreamRef; key: AEKeyword): OSStatus; C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AEHelpersIncludes}

{$ENDC} {__AEHELPERS__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AEInteraction.p
 
     Contains:   AppleEvent functions that deal with Events and interacting with user
 
     Version:    Technology: Mac OS 9
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 2000-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AEInteraction;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AEINTERACTION__}
{$SETC __AEINTERACTION__ := 1}

{$I+}
{$SETC AEInteractionIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __AEDATAMODEL__}
{$I AEDataModel.p}
{$ENDC}
{$IFC UNDEFINED __NOTIFICATION__}
{$I Notification.p}
{$ENDC}
{$IFC UNDEFINED __EVENTS__}
{$I Events.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{*************************************************************************
  AppleEvent callbacks. 
*************************************************************************}

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	AEIdleProcPtr = FUNCTION(VAR theEvent: EventRecord; VAR sleepTime: LONGINT; VAR mouseRgn: RgnHandle): BOOLEAN;
{$ELSEC}
	AEIdleProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	AEFilterProcPtr = FUNCTION(VAR theEvent: EventRecord; returnID: LONGINT; transactionID: LONGINT; {CONST}VAR sender: AEAddressDesc): BOOLEAN;
{$ELSEC}
	AEFilterProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	AEIdleUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AEIdleUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	AEFilterUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AEFilterUPP = UniversalProcPtr;
{$ENDC}	

	{	*************************************************************************
	  The next couple of calls are basic routines used to create, send,
	  and process AppleEvents. 
	*************************************************************************	}
	{
	 *  AESend()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION AESend({CONST}VAR theAppleEvent: AppleEvent; VAR reply: AppleEvent; sendMode: AESendMode; sendPriority: AESendPriority; timeOutInTicks: LONGINT; idleProc: AEIdleUPP; filterProc: AEFilterUPP): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0D17, $A816;
	{$ENDC}

{
 *  AEProcessAppleEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEProcessAppleEvent({CONST}VAR theEventRecord: EventRecord): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $021B, $A816;
	{$ENDC}


{ 
 Note: during event processing, an event handler may realize that it is likely
 to exceed the client's timeout limit. Passing the reply to this
 routine causes a wait event to be generated that asks the client
 for more time. 
}
{
 *  AEResetTimer()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEResetTimer({CONST}VAR reply: AppleEvent): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0219, $A816;
	{$ENDC}


{*************************************************************************
  The following three calls are used to allow applications to behave
  courteously when a user interaction such as a dialog box is needed. 
*************************************************************************}


TYPE
	AEInteractAllowed 			= SInt8;
CONST
	kAEInteractWithSelf			= 0;
	kAEInteractWithLocal		= 1;
	kAEInteractWithAll			= 2;

	{
	 *  AEGetInteractionAllowed()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION AEGetInteractionAllowed(VAR level: AEInteractAllowed): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $021D, $A816;
	{$ENDC}

{
 *  AESetInteractionAllowed()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AESetInteractionAllowed(level: ByteParameter): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $011E, $A816;
	{$ENDC}

{
 *  AEInteractWithUser()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEInteractWithUser(timeOutInTicks: LONGINT; nmReqPtr: NMRecPtr; idleProc: AEIdleUPP): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $061C, $A816;
	{$ENDC}


{*************************************************************************
 The following four calls are available for applications which need more
 sophisticated control over when and how events are processed. Applications
 which implement multi-session servers or which implement their own
 internal event queueing will probably be the major clients of these
 routines. They can be called from within a handler to prevent the AEM from
 disposing of the AppleEvent when the handler returns. They can be used to
 asynchronously process the event (as MacApp does).
*************************************************************************}
{
 *  AESuspendTheCurrentEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AESuspendTheCurrentEvent({CONST}VAR theAppleEvent: AppleEvent): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $022B, $A816;
	{$ENDC}

{ 
 Note: The following routine tells the AppleEvent manager that processing
 is either about to resume or has been completed on a previously suspended
 event. The procPtr passed in as the dispatcher parameter will be called to
 attempt to redispatch the event. Several constants for the dispatcher
 parameter allow special behavior. They are:
    - kAEUseStandardDispatch means redispatch as if the event was just
      received, using the standard AppleEvent dispatch mechanism.
    - kAENoDispatch means ignore the parameter.
      Use this in the case where the event has been handled and no
      redispatch is needed.
    - non nil means call the routine which the dispatcher points to.
}
{ Constants for Refcon in AEResumeTheCurrentEvent with kAEUseStandardDispatch }

CONST
	kAEDoNotIgnoreHandler		= $00000000;
	kAEIgnoreAppPhacHandler		= $00000001;					{  available only in vers 1.0.1 and greater  }
	kAEIgnoreAppEventHandler	= $00000002;					{  available only in vers 1.0.1 and greater  }
	kAEIgnoreSysPhacHandler		= $00000004;					{  available only in vers 1.0.1 and greater  }
	kAEIgnoreSysEventHandler	= $00000008;					{  available only in vers 1.0.1 and greater  }
	kAEIngoreBuiltInEventHandler = $00000010;					{  available only in vers 1.0.1 and greater  }
	kAEDontDisposeOnResume		= $80000000;					{  available only in vers 1.0.1 and greater  }

	{	 Constants for AEResumeTheCurrentEvent 	}
	kAENoDispatch				= 0;							{  dispatch parameter to AEResumeTheCurrentEvent takes a pointer to a dispatch  }
	kAEUseStandardDispatch		= $FFFFFFFF;					{  table, or one of these two constants  }

	{
	 *  AEResumeTheCurrentEvent()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION AEResumeTheCurrentEvent({CONST}VAR theAppleEvent: AppleEvent; {CONST}VAR reply: AppleEvent; dispatcher: AEEventHandlerUPP; handlerRefcon: LONGINT): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0818, $A816;
	{$ENDC}

{
 *  AEGetTheCurrentEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetTheCurrentEvent(VAR theAppleEvent: AppleEvent): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $021A, $A816;
	{$ENDC}

{
 *  AESetTheCurrentEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AESetTheCurrentEvent({CONST}VAR theAppleEvent: AppleEvent): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $022C, $A816;
	{$ENDC}


{*************************************************************************
  AppleEvent callbacks. 
*************************************************************************}

CONST
	uppAEIdleProcInfo = $00000FD0;
	uppAEFilterProcInfo = $00003FD0;
	{
	 *  NewAEIdleUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewAEIdleUPP(userRoutine: AEIdleProcPtr): AEIdleUPP; { old name was NewAEIdleProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewAEFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewAEFilterUPP(userRoutine: AEFilterProcPtr): AEFilterUPP; { old name was NewAEFilterProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeAEIdleUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAEIdleUPP(userUPP: AEIdleUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeAEFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAEFilterUPP(userUPP: AEFilterUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeAEIdleUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeAEIdleUPP(VAR theEvent: EventRecord; VAR sleepTime: LONGINT; VAR mouseRgn: RgnHandle; userRoutine: AEIdleUPP): BOOLEAN; { old name was CallAEIdleProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeAEFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeAEFilterUPP(VAR theEvent: EventRecord; returnID: LONGINT; transactionID: LONGINT; {CONST}VAR sender: AEAddressDesc; userRoutine: AEFilterUPP): BOOLEAN; { old name was CallAEFilterProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}




{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AEInteractionIncludes}

{$ENDC} {__AEINTERACTION__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AEMach.p
 
     Contains:   AppleEvent over mach_msg interfaces
 
     Version:    Technology: For Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 2000-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AEMach;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AEMACH__}
{$SETC __AEMACH__ := 1}

{$I+}
{$SETC AEMachIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __MIXEDMODE__}
{$I MixedMode.p}
{$ENDC}
{$IFC UNDEFINED __AEDATAMODEL__}
{$I AEDataModel.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{-
 * AE Mach API --
 *
 * AppleEvents on OS X are implemented in terms of mach messages.
 * To facilitate writing server processes that can send and receive
 * AppleEvents, the following APIs are provided.
 *
 * AppleEvents are directed to a well known port uniquely tied to a
 * process.  The AE framework will discover this port based on the
 * keyAddressAttr of the event (as specifed in AECreateAppleEvent by
 * the target parameter.)  If a port cannot be found,
 * procNotFound (-600) will be returned on AESend.
 *
 * Of note is a new attribute for an AppleEvent, typeReplyPortAttr.
 * This specifies the mach_port_t to which an AppleEvent reply
 * should be directed.  By default, replies are sent to the
 * processes registered port where they are culled from the normal  
 * event stream if there is an outstanding AESend + kAEWaitReply.
 * But it may be desirable for a client to specify their own port to
 * receive quued replies.
 * (In the case of AESendMessage with kAEWaitReply specified, an 
 * anonymous port will be used to block until the reply is received.)
 *
 * Not supplied is a convenience routine to block a server and
 * process AppleEvents.  This implementation will be detailed in a
 * tech note.
 *}

CONST
	typeReplyPortAttr			= 'repp';

{$IFC TARGET_RT_MAC_MACHO }
	{	-
	 * Return the mach_port_t that was registered with the bootstrap
	 * server for this process.  This port is considered public, and
	 * will be used by other applications to target your process.  You
	 * are free to use this mach_port_t to add to a port set, if and
	 * only if, you are not also using routines from HIToolbox.  In that
	 * case, HIToolbox retains control of this port and AppleEvents are
	 * dispatched through the main event loop.  
	 *	}
	{
	 *  AEGetRegisteredMachPort()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        not available
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION AEGetRegisteredMachPort: mach_port_t; C;

{-
 * Decode a mach_msg into an AppleEvent and its related reply.  (The
 * reply is set up from fields of the event.)  You can call this
 * routine if you wish to dispatch or handle the event yourself.  To
 * return a reply to the sender, you should call:
 *
 *  AESendMessage(reply, NULL, kAENoReply, kAENormalPriority, kAEDefaultTimeout);
 *
 * The contents of the header are invalid after this call.  
 *}
{
 *  AEDecodeMessage()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEDecodeMessage(VAR header: mach_msg_header_t; VAR event: AppleEvent; reply: AppleEventPtr): OSStatus; C;

{-
 * Decodes and dispatches an event to an event handler.  Handles
 * packaging and returning the reply to the sender.
 *
 * The contents of the header are invalid after this call.
 *}
{
 *  AEProcessMessage()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEProcessMessage(VAR header: mach_msg_header_t): OSStatus; C;

{-
 * Send an AppleEvent to a target process.  If the target is the
 * current process (as specified by using typeProcessSerialNumber of
 * ( 0, kCurrentProcess ) it is dispatched directly to the
 * appropriate event handler in your process and not serialized.
 *}
{
 *  AESendMessage()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AESendMessage({CONST}VAR event: AppleEvent; reply: AppleEventPtr; sendMode: AESendMode; timeOutInTicks: LONGINT): OSStatus; C;

{$ENDC}  {TARGET_RT_MAC_MACHO}

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AEMachIncludes}

{$ENDC} {__AEMACH__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AEObjects.p
 
     Contains:   Object Support Library Interfaces.
 
     Version:    Technology: System 8.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1991-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AEObjects;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AEOBJECTS__}
{$SETC __AEOBJECTS__ := 1}

{$I+}
{$SETC AEObjectsIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __OSUTILS__}
{$I OSUtils.p}
{$ENDC}
{$IFC UNDEFINED __APPLEEVENTS__}
{$I AppleEvents.p}
{$ENDC}
{$IFC UNDEFINED __MACERRORS__}
{$I MacErrors.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


CONST
																{ *** LOGICAL OPERATOR CONSTANTS  *** }
	kAEAND						= 'AND ';						{   0x414e4420   }
	kAEOR						= 'OR  ';						{   0x4f522020   }
	kAENOT						= 'NOT ';						{   0x4e4f5420   }
																{ *** ABSOLUTE ORDINAL CONSTANTS  *** }
	kAEFirst					= 'firs';						{   0x66697273   }
	kAELast						= 'last';						{   0x6c617374   }
	kAEMiddle					= 'midd';						{   0x6d696464   }
	kAEAny						= 'any ';						{   0x616e7920   }
	kAEAll						= 'all ';						{   0x616c6c20   }
																{ *** RELATIVE ORDINAL CONSTANTS  *** }
	kAENext						= 'next';						{   0x6e657874   }
	kAEPrevious					= 'prev';						{   0x70726576   }
																{ *** KEYWORD CONSTANT    *** }
	keyAECompOperator			= 'relo';						{   0x72656c6f   }
	keyAELogicalTerms			= 'term';						{   0x7465726d   }
	keyAELogicalOperator		= 'logc';						{   0x6c6f6763   }
	keyAEObject1				= 'obj1';						{   0x6f626a31   }
	keyAEObject2				= 'obj2';						{   0x6f626a32   }
																{     ... for Keywords for getting fields out of object specifier records.  }
	keyAEDesiredClass			= 'want';						{   0x77616e74   }
	keyAEContainer				= 'from';						{   0x66726f6d   }
	keyAEKeyForm				= 'form';						{   0x666f726d   }
	keyAEKeyData				= 'seld';						{   0x73656c64   }

																{     ... for Keywords for getting fields out of Range specifier records.  }
	keyAERangeStart				= 'star';						{   0x73746172   }
	keyAERangeStop				= 'stop';						{   0x73746f70   }
																{     ... special handler selectors for OSL Callbacks.  }
	keyDisposeTokenProc			= 'xtok';						{   0x78746f6b   }
	keyAECompareProc			= 'cmpr';						{   0x636d7072   }
	keyAECountProc				= 'cont';						{   0x636f6e74   }
	keyAEMarkTokenProc			= 'mkid';						{   0x6d6b6964   }
	keyAEMarkProc				= 'mark';						{   0x6d61726b   }
	keyAEAdjustMarksProc		= 'adjm';						{   0x61646a6d   }
	keyAEGetErrDescProc			= 'indc';						{   0x696e6463   }

	{	***   VALUE and TYPE CONSTANTS    ***	}
																{     ... possible values for the keyAEKeyForm field of an object specifier.  }
	formAbsolutePosition		= 'indx';						{   0x696e6478   }
	formRelativePosition		= 'rele';						{   0x72656c65   }
	formTest					= 'test';						{   0x74657374   }
	formRange					= 'rang';						{   0x72616e67   }
	formPropertyID				= 'prop';						{   0x70726f70   }
	formName					= 'name';						{   0x6e616d65   }
																{     ... relevant types (some of these are often pared with forms above).  }
	typeObjectSpecifier			= 'obj ';						{   0x6f626a20   }
	typeObjectBeingExamined		= 'exmn';						{   0x65786d6e   }
	typeCurrentContainer		= 'ccnt';						{   0x63636e74   }
	typeToken					= 'toke';						{   0x746f6b65   }
	typeRelativeDescriptor		= 'rel ';						{   0x72656c20   }
	typeAbsoluteOrdinal			= 'abso';						{   0x6162736f   }
	typeIndexDescriptor			= 'inde';						{   0x696e6465   }
	typeRangeDescriptor			= 'rang';						{   0x72616e67   }
	typeLogicalDescriptor		= 'logi';						{   0x6c6f6769   }
	typeCompDescriptor			= 'cmpd';						{   0x636d7064   }
	typeOSLTokenList			= 'ostl';						{   0x6F73746C   }

	{	 Possible values for flags parameter to AEResolve.  They're additive 	}
	kAEIDoMinimum				= $0000;
	kAEIDoWhose					= $0001;
	kAEIDoMarking				= $0004;
	kAEPassSubDescs				= $0008;
	kAEResolveNestedLists		= $0010;
	kAEHandleSimpleRanges		= $0020;
	kAEUseRelativeIterators		= $0040;

	{	*** SPECIAL CONSTANTS FOR CUSTOM WHOSE-CLAUSE RESOLUTION 	}
	typeWhoseDescriptor			= 'whos';						{   0x77686f73   }
	formWhose					= 'whos';						{   0x77686f73   }
	typeWhoseRange				= 'wrng';						{   0x77726e67   }
	keyAEWhoseRangeStart		= 'wstr';						{   0x77737472   }
	keyAEWhoseRangeStop			= 'wstp';						{   0x77737470   }
	keyAEIndex					= 'kidx';						{   0x6b696478   }
	keyAETest					= 'ktst';						{   0x6b747374   }

	{	
	    used for rewriting tokens in place of 'ccnt' descriptors
	    This record is only of interest to those who, when they...
	    ...get ranges as key data in their accessor procs, choose
	    ...to resolve them manually rather than call AEResolve again.
		}

TYPE
	ccntTokenRecordPtr = ^ccntTokenRecord;
	ccntTokenRecord = RECORD
		tokenClass:				DescType;
		token:					AEDesc;
	END;

	ccntTokenRecPtr						= ^ccntTokenRecord;
	ccntTokenRecHandle					= ^ccntTokenRecPtr;
{$IFC OLDROUTINENAMES }
	DescPtr								= ^AEDesc;
	DescHandle							= ^DescPtr;
{$ENDC}  {OLDROUTINENAMES}

	{	 typedefs providing type checking for procedure pointers 	}
{$IFC TYPED_FUNCTION_POINTERS}
	OSLAccessorProcPtr = FUNCTION(desiredClass: DescType; {CONST}VAR container: AEDesc; containerClass: DescType; form: DescType; {CONST}VAR selectionData: AEDesc; VAR value: AEDesc; accessorRefcon: LONGINT): OSErr;
{$ELSEC}
	OSLAccessorProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	OSLCompareProcPtr = FUNCTION(oper: DescType; {CONST}VAR obj1: AEDesc; {CONST}VAR obj2: AEDesc; VAR result: BOOLEAN): OSErr;
{$ELSEC}
	OSLCompareProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	OSLCountProcPtr = FUNCTION(desiredType: DescType; containerClass: DescType; {CONST}VAR container: AEDesc; VAR result: LONGINT): OSErr;
{$ELSEC}
	OSLCountProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	OSLDisposeTokenProcPtr = FUNCTION(VAR unneededToken: AEDesc): OSErr;
{$ELSEC}
	OSLDisposeTokenProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	OSLGetMarkTokenProcPtr = FUNCTION({CONST}VAR dContainerToken: AEDesc; containerClass: DescType; VAR result: AEDesc): OSErr;
{$ELSEC}
	OSLGetMarkTokenProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	OSLGetErrDescProcPtr = FUNCTION(VAR appDescPtr: AEDescPtr): OSErr;
{$ELSEC}
	OSLGetErrDescProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	OSLMarkProcPtr = FUNCTION({CONST}VAR dToken: AEDesc; {CONST}VAR markToken: AEDesc; index: LONGINT): OSErr;
{$ELSEC}
	OSLMarkProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	OSLAdjustMarksProcPtr = FUNCTION(newStart: LONGINT; newStop: LONGINT; {CONST}VAR markToken: AEDesc): OSErr;
{$ELSEC}
	OSLAdjustMarksProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	OSLAccessorUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	OSLAccessorUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	OSLCompareUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	OSLCompareUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	OSLCountUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	OSLCountUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	OSLDisposeTokenUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	OSLDisposeTokenUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	OSLGetMarkTokenUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	OSLGetMarkTokenUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	OSLGetErrDescUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	OSLGetErrDescUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	OSLMarkUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	OSLMarkUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	OSLAdjustMarksUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	OSLAdjustMarksUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppOSLAccessorProcInfo = $000FFFE0;
	uppOSLCompareProcInfo = $00003FE0;
	uppOSLCountProcInfo = $00003FE0;
	uppOSLDisposeTokenProcInfo = $000000E0;
	uppOSLGetMarkTokenProcInfo = $00000FE0;
	uppOSLGetErrDescProcInfo = $000000E0;
	uppOSLMarkProcInfo = $00000FE0;
	uppOSLAdjustMarksProcInfo = $00000FE0;
	{
	 *  NewOSLAccessorUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewOSLAccessorUPP(userRoutine: OSLAccessorProcPtr): OSLAccessorUPP; { old name was NewOSLAccessorProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewOSLCompareUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewOSLCompareUPP(userRoutine: OSLCompareProcPtr): OSLCompareUPP; { old name was NewOSLCompareProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewOSLCountUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewOSLCountUPP(userRoutine: OSLCountProcPtr): OSLCountUPP; { old name was NewOSLCountProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewOSLDisposeTokenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewOSLDisposeTokenUPP(userRoutine: OSLDisposeTokenProcPtr): OSLDisposeTokenUPP; { old name was NewOSLDisposeTokenProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewOSLGetMarkTokenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewOSLGetMarkTokenUPP(userRoutine: OSLGetMarkTokenProcPtr): OSLGetMarkTokenUPP; { old name was NewOSLGetMarkTokenProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewOSLGetErrDescUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewOSLGetErrDescUPP(userRoutine: OSLGetErrDescProcPtr): OSLGetErrDescUPP; { old name was NewOSLGetErrDescProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewOSLMarkUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewOSLMarkUPP(userRoutine: OSLMarkProcPtr): OSLMarkUPP; { old name was NewOSLMarkProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewOSLAdjustMarksUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewOSLAdjustMarksUPP(userRoutine: OSLAdjustMarksProcPtr): OSLAdjustMarksUPP; { old name was NewOSLAdjustMarksProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeOSLAccessorUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeOSLAccessorUPP(userUPP: OSLAccessorUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeOSLCompareUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeOSLCompareUPP(userUPP: OSLCompareUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeOSLCountUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeOSLCountUPP(userUPP: OSLCountUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeOSLDisposeTokenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeOSLDisposeTokenUPP(userUPP: OSLDisposeTokenUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeOSLGetMarkTokenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeOSLGetMarkTokenUPP(userUPP: OSLGetMarkTokenUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeOSLGetErrDescUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeOSLGetErrDescUPP(userUPP: OSLGetErrDescUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeOSLMarkUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeOSLMarkUPP(userUPP: OSLMarkUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeOSLAdjustMarksUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeOSLAdjustMarksUPP(userUPP: OSLAdjustMarksUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeOSLAccessorUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeOSLAccessorUPP(desiredClass: DescType; {CONST}VAR container: AEDesc; containerClass: DescType; form: DescType; {CONST}VAR selectionData: AEDesc; VAR value: AEDesc; accessorRefcon: LONGINT; userRoutine: OSLAccessorUPP): OSErr; { old name was CallOSLAccessorProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeOSLCompareUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeOSLCompareUPP(oper: DescType; {CONST}VAR obj1: AEDesc; {CONST}VAR obj2: AEDesc; VAR result: BOOLEAN; userRoutine: OSLCompareUPP): OSErr; { old name was CallOSLCompareProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeOSLCountUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeOSLCountUPP(desiredType: DescType; containerClass: DescType; {CONST}VAR container: AEDesc; VAR result: LONGINT; userRoutine: OSLCountUPP): OSErr; { old name was CallOSLCountProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeOSLDisposeTokenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeOSLDisposeTokenUPP(VAR unneededToken: AEDesc; userRoutine: OSLDisposeTokenUPP): OSErr; { old name was CallOSLDisposeTokenProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeOSLGetMarkTokenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeOSLGetMarkTokenUPP({CONST}VAR dContainerToken: AEDesc; containerClass: DescType; VAR result: AEDesc; userRoutine: OSLGetMarkTokenUPP): OSErr; { old name was CallOSLGetMarkTokenProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeOSLGetErrDescUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeOSLGetErrDescUPP(VAR appDescPtr: AEDescPtr; userRoutine: OSLGetErrDescUPP): OSErr; { old name was CallOSLGetErrDescProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeOSLMarkUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeOSLMarkUPP({CONST}VAR dToken: AEDesc; {CONST}VAR markToken: AEDesc; index: LONGINT; userRoutine: OSLMarkUPP): OSErr; { old name was CallOSLMarkProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeOSLAdjustMarksUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeOSLAdjustMarksUPP(newStart: LONGINT; newStop: LONGINT; {CONST}VAR markToken: AEDesc; userRoutine: OSLAdjustMarksUPP): OSErr; { old name was CallOSLAdjustMarksProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}




{
 *  AEObjectInit()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEObjectInit: OSErr;

{ Not done by inline, but by direct linking into code.  It sets up the pack
  such that further calls can be via inline }
{
 *  AESetObjectCallbacks()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AESetObjectCallbacks(myCompareProc: OSLCompareUPP; myCountProc: OSLCountUPP; myDisposeTokenProc: OSLDisposeTokenUPP; myGetMarkTokenProc: OSLGetMarkTokenUPP; myMarkProc: OSLMarkUPP; myAdjustMarksProc: OSLAdjustMarksUPP; myGetErrDescProcPtr: OSLGetErrDescUPP): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0E35, $A816;
	{$ENDC}

{
 *  AEResolve()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEResolve({CONST}VAR objectSpecifier: AEDesc; callbackFlags: INTEGER; VAR theToken: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0536, $A816;
	{$ENDC}

{
 *  AEInstallObjectAccessor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEInstallObjectAccessor(desiredClass: DescType; containerType: DescType; theAccessor: OSLAccessorUPP; accessorRefcon: LONGINT; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0937, $A816;
	{$ENDC}

{
 *  AERemoveObjectAccessor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AERemoveObjectAccessor(desiredClass: DescType; containerType: DescType; theAccessor: OSLAccessorUPP; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0738, $A816;
	{$ENDC}

{
 *  AEGetObjectAccessor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetObjectAccessor(desiredClass: DescType; containerType: DescType; VAR accessor: OSLAccessorUPP; VAR accessorRefcon: LONGINT; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0939, $A816;
	{$ENDC}

{
 *  AEDisposeToken()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEDisposeToken(VAR theToken: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $023A, $A816;
	{$ENDC}

{
 *  AECallObjectAccessor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AECallObjectAccessor(desiredClass: DescType; {CONST}VAR containerToken: AEDesc; containerClass: DescType; keyForm: DescType; {CONST}VAR keyData: AEDesc; VAR token: AEDesc): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0C3B, $A816;
	{$ENDC}


{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AEObjectsIncludes}

{$ENDC} {__AEOBJECTS__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AEPackObject.p
 
     Contains:   AppleEvents object packing Interfaces.
 
     Version:    Technology: System 7.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1991-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AEPackObject;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AEPACKOBJECT__}
{$SETC __AEPACKOBJECT__ := 1}

{$I+}
{$SETC AEPackObjectIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __APPLEEVENTS__}
{$I AppleEvents.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{ These are the object packing routines.  }
{
 *  CreateOffsetDescriptor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CreateOffsetDescriptor(theOffset: LONGINT; VAR theDescriptor: AEDesc): OSErr;

{
 *  CreateCompDescriptor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CreateCompDescriptor(comparisonOperator: DescType; VAR operand1: AEDesc; VAR operand2: AEDesc; disposeInputs: BOOLEAN; VAR theDescriptor: AEDesc): OSErr;

{
 *  CreateLogicalDescriptor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CreateLogicalDescriptor(VAR theLogicalTerms: AEDescList; theLogicOperator: DescType; disposeInputs: BOOLEAN; VAR theDescriptor: AEDesc): OSErr;


{
 *  CreateObjSpecifier()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CreateObjSpecifier(desiredClass: DescType; VAR theContainer: AEDesc; keyForm: DescType; VAR keyData: AEDesc; disposeInputs: BOOLEAN; VAR objSpecifier: AEDesc): OSErr;

{
 *  CreateRangeDescriptor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ObjectSupportLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CreateRangeDescriptor(VAR rangeStart: AEDesc; VAR rangeStop: AEDesc; disposeInputs: BOOLEAN; VAR theDescriptor: AEDesc): OSErr;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AEPackObjectIncludes}

{$ENDC} {__AEPACKOBJECT__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AERegistry.p
 
     Contains:   AppleEvents Registry Interface.
 
     Version:    Technology: Mac OS 8.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1993-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AERegistry;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AEREGISTRY__}
{$SETC __AEREGISTRY__ := 1}

{$I+}
{$SETC AERegistryIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __MACERRORS__}
{$I MacErrors.p}
{$ENDC}
{$IFC UNDEFINED __APPLEEVENTS__}
{$I AppleEvents.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


CONST
	cAEList						= 'list';						{   0x6c697374   }
	cApplication				= 'capp';						{   0x63617070   }
	cArc						= 'carc';						{   0x63617263   }
	cBoolean					= 'bool';						{   0x626f6f6c   }
	cCell						= 'ccel';						{   0x6363656c   }
	cChar						= 'cha ';						{   0x63686120   }
	cColorTable					= 'clrt';						{   0x636c7274   }
	cColumn						= 'ccol';						{   0x63636f6c   }
	cDocument					= 'docu';						{   0x646f6375   }
	cDrawingArea				= 'cdrw';						{   0x63647277   }
	cEnumeration				= 'enum';						{   0x656e756d   }
	cFile						= 'file';						{   0x66696c65   }
	cFixed						= 'fixd';						{   0x66697864   }
	cFixedPoint					= 'fpnt';						{   0x66706e74   }
	cFixedRectangle				= 'frct';						{   0x66726374   }
	cGraphicLine				= 'glin';						{   0x676c696e   }
	cGraphicObject				= 'cgob';						{   0x63676f62   }
	cGraphicShape				= 'cgsh';						{   0x63677368   }
	cGraphicText				= 'cgtx';						{   0x63677478   }
	cGroupedGraphic				= 'cpic';						{   0x63706963   }

	cInsertionLoc				= 'insl';						{   0x696e736c   }
	cInsertionPoint				= 'cins';						{   0x63696e73   }
	cIntlText					= 'itxt';						{   0x69747874   }
	cIntlWritingCode			= 'intl';						{   0x696e746c   }
	cItem						= 'citm';						{   0x6369746d   }
	cLine						= 'clin';						{   0x636c696e   }
	cLongDateTime				= 'ldt ';						{   0x6c647420   }
	cLongFixed					= 'lfxd';						{   0x6c667864   }
	cLongFixedPoint				= 'lfpt';						{   0x6c667074   }
	cLongFixedRectangle			= 'lfrc';						{   0x6c667263   }
	cLongInteger				= 'long';						{   0x6c6f6e67   }
	cLongPoint					= 'lpnt';						{   0x6c706e74   }
	cLongRectangle				= 'lrct';						{   0x6c726374   }
	cMachineLoc					= 'mLoc';						{   0x6d4c6f63   }
	cMenu						= 'cmnu';						{   0x636d6e75   }
	cMenuItem					= 'cmen';						{   0x636d656e   }
	cObject						= 'cobj';						{   0x636f626a   }
	cObjectSpecifier			= 'obj ';						{   0x6f626a20   }
	cOpenableObject				= 'coob';						{   0x636f6f62   }
	cOval						= 'covl';						{   0x636f766c   }

	cParagraph					= 'cpar';						{   0x63706172   }
	cPICT						= 'PICT';						{   0x50494354   }
	cPixel						= 'cpxl';						{   0x6370786c   }
	cPixelMap					= 'cpix';						{   0x63706978   }
	cPolygon					= 'cpgn';						{   0x6370676e   }
	cProperty					= 'prop';						{   0x70726f70   }
	cQDPoint					= 'QDpt';						{   0x51447074   }
	cQDRectangle				= 'qdrt';						{   0x71647274   }
	cRectangle					= 'crec';						{   0x63726563   }
	cRGBColor					= 'cRGB';						{   0x63524742   }
	cRotation					= 'trot';						{   0x74726f74   }
	cRoundedRectangle			= 'crrc';						{   0x63727263   }
	cRow						= 'crow';						{   0x63726f77   }
	cSelection					= 'csel';						{   0x6373656c   }
	cShortInteger				= 'shor';						{   0x73686f72   }
	cTable						= 'ctbl';						{   0x6374626c   }
	cText						= 'ctxt';						{   0x63747874   }
	cTextFlow					= 'cflo';						{   0x63666c6f   }
	cTextStyles					= 'tsty';						{   0x74737479   }
	cType						= 'type';						{   0x74797065   }

	cVersion					= 'vers';						{   0x76657273   }
	cWindow						= 'cwin';						{   0x6377696e   }
	cWord						= 'cwor';						{   0x63776f72   }
	enumArrows					= 'arro';						{   0x6172726f   }
	enumJustification			= 'just';						{   0x6a757374   }
	enumKeyForm					= 'kfrm';						{   0x6b66726d   }
	enumPosition				= 'posi';						{   0x706f7369   }
	enumProtection				= 'prtn';						{   0x7072746e   }
	enumQuality					= 'qual';						{   0x7175616c   }
	enumSaveOptions				= 'savo';						{   0x7361766f   }
	enumStyle					= 'styl';						{   0x7374796c   }
	enumTransferMode			= 'tran';						{   0x7472616e   }
	formUniqueID				= 'ID  ';						{   0x49442020   }
	kAEAbout					= 'abou';						{   0x61626f75   }
	kAEAfter					= 'afte';						{   0x61667465   }
	kAEAliasSelection			= 'sali';						{   0x73616c69   }
	kAEAllCaps					= 'alcp';						{   0x616c6370   }
	kAEArrowAtEnd				= 'aren';						{   0x6172656e   }
	kAEArrowAtStart				= 'arst';						{   0x61727374   }
	kAEArrowBothEnds			= 'arbo';						{   0x6172626f   }

	kAEAsk						= 'ask ';						{   0x61736b20   }
	kAEBefore					= 'befo';						{   0x6265666f   }
	kAEBeginning				= 'bgng';						{   0x62676e67   }
	kAEBeginsWith				= 'bgwt';						{   0x62677774   }
	kAEBeginTransaction			= 'begi';						{   0x62656769   }
	kAEBold						= 'bold';						{   0x626f6c64   }
	kAECaseSensEquals			= 'cseq';						{   0x63736571   }
	kAECentered					= 'cent';						{   0x63656e74   }
	kAEChangeView				= 'view';						{   0x76696577   }
	kAEClone					= 'clon';						{   0x636c6f6e   }
	kAEClose					= 'clos';						{   0x636c6f73   }
	kAECondensed				= 'cond';						{   0x636f6e64   }
	kAEContains					= 'cont';						{   0x636f6e74   }
	kAECopy						= 'copy';						{   0x636f7079   }
	kAECoreSuite				= 'core';						{   0x636f7265   }
	kAECountElements			= 'cnte';						{   0x636e7465   }
	kAECreateElement			= 'crel';						{   0x6372656c   }
	kAECreatePublisher			= 'cpub';						{   0x63707562   }
	kAECut						= 'cut ';						{   0x63757420   }
	kAEDelete					= 'delo';						{   0x64656c6f   }

	kAEDoObjectsExist			= 'doex';						{   0x646f6578   }
	kAEDoScript					= 'dosc';						{   0x646f7363   }
	kAEDrag						= 'drag';						{   0x64726167   }
	kAEDuplicateSelection		= 'sdup';						{   0x73647570   }
	kAEEditGraphic				= 'edit';						{   0x65646974   }
	kAEEmptyTrash				= 'empt';						{   0x656d7074   }
	kAEEnd						= 'end ';						{   0x656e6420   }
	kAEEndsWith					= 'ends';						{   0x656e6473   }
	kAEEndTransaction			= 'endt';						{   0x656e6474   }
	kAEEquals					= '=   ';						{   0x3d202020   }
	kAEExpanded					= 'pexp';						{   0x70657870   }
	kAEFast						= 'fast';						{   0x66617374   }
	kAEFinderEvents				= 'FNDR';						{   0x464e4452   }
	kAEFormulaProtect			= 'fpro';						{   0x6670726f   }
	kAEFullyJustified			= 'full';						{   0x66756c6c   }
	kAEGetClassInfo				= 'qobj';						{   0x716f626a   }
	kAEGetData					= 'getd';						{   0x67657464   }
	kAEGetDataSize				= 'dsiz';						{   0x6473697a   }
	kAEGetEventInfo				= 'gtei';						{   0x67746569   }
	kAEGetInfoSelection			= 'sinf';						{   0x73696e66   }

	kAEGetPrivilegeSelection	= 'sprv';						{   0x73707276   }
	kAEGetSuiteInfo				= 'gtsi';						{   0x67747369   }
	kAEGreaterThan				= '>   ';						{   0x3e202020   }
	kAEGreaterThanEquals		= '>=  ';						{   0x3e3d2020   }
	kAEGrow						= 'grow';						{   0x67726f77   }
	kAEHidden					= 'hidn';						{   0x6869646e   }
	kAEHiQuality				= 'hiqu';						{   0x68697175   }
	kAEImageGraphic				= 'imgr';						{   0x696d6772   }
	kAEIsUniform				= 'isun';						{   0x6973756e   }
	kAEItalic					= 'ital';						{   0x6974616c   }
	kAELeftJustified			= 'left';						{   0x6c656674   }
	kAELessThan					= '<   ';						{   0x3c202020   }
	kAELessThanEquals			= '<=  ';						{   0x3c3d2020   }
	kAELowercase				= 'lowc';						{   0x6c6f7763   }
	kAEMakeObjectsVisible		= 'mvis';						{   0x6d766973   }
	kAEMiscStandards			= 'misc';						{   0x6d697363   }
	kAEModifiable				= 'modf';						{   0x6d6f6466   }
	kAEMove						= 'move';						{   0x6d6f7665   }
	kAENo						= 'no  ';						{   0x6e6f2020   }
	kAENoArrow					= 'arno';						{   0x61726e6f   }

	kAENonmodifiable			= 'nmod';						{   0x6e6d6f64   }
	kAEOpen						= 'odoc';						{   0x6f646f63   }
	kAEOpenSelection			= 'sope';						{   0x736f7065   }
	kAEOutline					= 'outl';						{   0x6f75746c   }
	kAEPageSetup				= 'pgsu';						{   0x70677375   }
	kAEPaste					= 'past';						{   0x70617374   }
	kAEPlain					= 'plan';						{   0x706c616e   }
	kAEPrint					= 'pdoc';						{   0x70646f63   }
	kAEPrintSelection			= 'spri';						{   0x73707269   }
	kAEPrintWindow				= 'pwin';						{   0x7077696e   }
	kAEPutAwaySelection			= 'sput';						{   0x73707574   }
	kAEQDAddOver				= 'addo';						{   0x6164646f   }
	kAEQDAddPin					= 'addp';						{   0x61646470   }
	kAEQDAdMax					= 'admx';						{   0x61646d78   }
	kAEQDAdMin					= 'admn';						{   0x61646d6e   }
	kAEQDBic					= 'bic ';						{   0x62696320   }
	kAEQDBlend					= 'blnd';						{   0x626c6e64   }
	kAEQDCopy					= 'cpy ';						{   0x63707920   }
	kAEQDNotBic					= 'nbic';						{   0x6e626963   }
	kAEQDNotCopy				= 'ncpy';						{   0x6e637079   }

	kAEQDNotOr					= 'ntor';						{   0x6e746f72   }
	kAEQDNotXor					= 'nxor';						{   0x6e786f72   }
	kAEQDOr						= 'or  ';						{   0x6f722020   }
	kAEQDSubOver				= 'subo';						{   0x7375626f   }
	kAEQDSubPin					= 'subp';						{   0x73756270   }
	kAEQDSupplementalSuite		= 'qdsp';						{   0x71647370   }
	kAEQDXor					= 'xor ';						{   0x786f7220   }
	kAEQuickdrawSuite			= 'qdrw';						{   0x71647277   }
	kAEQuitAll					= 'quia';						{   0x71756961   }
	kAERedo						= 'redo';						{   0x7265646f   }
	kAERegular					= 'regl';						{   0x7265676c   }
	kAEReopenApplication		= 'rapp';						{   0x72617070   }
	kAEReplace					= 'rplc';						{   0x72706c63   }
	kAERequiredSuite			= 'reqd';						{   0x72657164   }
	kAERestart					= 'rest';						{   0x72657374   }
	kAERevealSelection			= 'srev';						{   0x73726576   }
	kAERevert					= 'rvrt';						{   0x72767274   }
	kAERightJustified			= 'rght';						{   0x72676874   }
	kAESave						= 'save';						{   0x73617665   }
	kAESelect					= 'slct';						{   0x736c6374   }
	kAESetData					= 'setd';						{   0x73657464   }

	kAESetPosition				= 'posn';						{   0x706f736e   }
	kAEShadow					= 'shad';						{   0x73686164   }
	kAEShowClipboard			= 'shcl';						{   0x7368636c   }
	kAEShutDown					= 'shut';						{   0x73687574   }
	kAESleep					= 'slep';						{   0x736c6570   }
	kAESmallCaps				= 'smcp';						{   0x736d6370   }
	kAESpecialClassProperties	= 'c@#!';						{   0x63402321   }
	kAEStrikethrough			= 'strk';						{   0x7374726b   }
	kAESubscript				= 'sbsc';						{   0x73627363   }
	kAESuperscript				= 'spsc';						{   0x73707363   }
	kAETableSuite				= 'tbls';						{   0x74626c73   }
	kAETextSuite				= 'TEXT';						{   0x54455854   }
	kAETransactionTerminated	= 'ttrm';						{   0x7474726d   }
	kAEUnderline				= 'undl';						{   0x756e646c   }
	kAEUndo						= 'undo';						{   0x756e646f   }
	kAEWholeWordEquals			= 'wweq';						{   0x77776571   }
	kAEYes						= 'yes ';						{   0x79657320   }
	kAEZoom						= 'zoom';						{   0x7a6f6f6d   }

	{	 EventRecord Classes and EventIDs 	}
	kAEMouseClass				= 'mous';
	kAEDown						= 'down';
	kAEUp						= 'up  ';
	kAEMoved					= 'move';
	kAEStoppedMoving			= 'stop';
	kAEWindowClass				= 'wind';
	kAEUpdate					= 'updt';
	kAEActivate					= 'actv';
	kAEDeactivate				= 'dact';
	kAECommandClass				= 'cmnd';						{  Modern Command Event Class  }
	kAEKeyClass					= 'keyc';
	kAERawKey					= 'rkey';						{  Modern Raw Key Event  }
	kAEVirtualKey				= 'keyc';						{  Modern Virtual Key Event  }
	kAENavigationKey			= 'nave';						{  Modern Navigation Key Event  }
	kAEAutoDown					= 'auto';
	kAEApplicationClass			= 'appl';
	kAESuspend					= 'susp';
	kAEResume					= 'rsme';
	kAEDiskEvent				= 'disk';
	kAENullEvent				= 'null';
	kAEWakeUpEvent				= 'wake';
	kAEScrapEvent				= 'scrp';
	kAEHighLevel				= 'high';

	keyAEAngle					= 'kang';						{   0x6b616e67   }
	keyAEArcAngle				= 'parc';						{   0x70617263   }

	keyAEBaseAddr				= 'badd';						{   0x62616464   }
	keyAEBestType				= 'pbst';						{   0x70627374   }
	keyAEBgndColor				= 'kbcl';						{   0x6b62636c   }
	keyAEBgndPattern			= 'kbpt';						{   0x6b627074   }
	keyAEBounds					= 'pbnd';						{   0x70626e64   }
	keyAECellList				= 'kclt';						{   0x6b636c74   }
	keyAEClassID				= 'clID';						{   0x636c4944   }
	keyAEColor					= 'colr';						{   0x636f6c72   }
	keyAEColorTable				= 'cltb';						{   0x636c7462   }
	keyAECurveHeight			= 'kchd';						{   0x6b636864   }
	keyAECurveWidth				= 'kcwd';						{   0x6b637764   }
	keyAEDashStyle				= 'pdst';						{   0x70647374   }
	keyAEData					= 'data';						{   0x64617461   }
	keyAEDefaultType			= 'deft';						{   0x64656674   }
	keyAEDefinitionRect			= 'pdrt';						{   0x70647274   }
	keyAEDescType				= 'dstp';						{   0x64737470   }
	keyAEDestination			= 'dest';						{   0x64657374   }
	keyAEDoAntiAlias			= 'anta';						{   0x616e7461   }
	keyAEDoDithered				= 'gdit';						{   0x67646974   }
	keyAEDoRotate				= 'kdrt';						{   0x6b647274   }

	keyAEDoScale				= 'ksca';						{   0x6b736361   }
	keyAEDoTranslate			= 'ktra';						{   0x6b747261   }
	keyAEEditionFileLoc			= 'eloc';						{   0x656c6f63   }
	keyAEElements				= 'elms';						{   0x656c6d73   }
	keyAEEndPoint				= 'pend';						{   0x70656e64   }
	keyAEEventClass				= 'evcl';						{   0x6576636c   }
	keyAEEventID				= 'evti';						{   0x65767469   }
	keyAEFile					= 'kfil';						{   0x6b66696c   }
	keyAEFileType				= 'fltp';						{   0x666c7470   }
	keyAEFillColor				= 'flcl';						{   0x666c636c   }
	keyAEFillPattern			= 'flpt';						{   0x666c7074   }
	keyAEFlipHorizontal			= 'kfho';						{   0x6b66686f   }
	keyAEFlipVertical			= 'kfvt';						{   0x6b667674   }
	keyAEFont					= 'font';						{   0x666f6e74   }
	keyAEFormula				= 'pfor';						{   0x70666f72   }
	keyAEGraphicObjects			= 'gobs';						{   0x676f6273   }
	keyAEID						= 'ID  ';						{   0x49442020   }
	keyAEImageQuality			= 'gqua';						{   0x67717561   }
	keyAEInsertHere				= 'insh';						{   0x696e7368   }
	keyAEKeyForms				= 'keyf';						{   0x6b657966   }

	keyAEKeyword				= 'kywd';						{   0x6b797764   }
	keyAELevel					= 'levl';						{   0x6c65766c   }
	keyAELineArrow				= 'arro';						{   0x6172726f   }
	keyAEName					= 'pnam';						{   0x706e616d   }
	keyAENewElementLoc			= 'pnel';						{   0x706e656c   }
	keyAEObject					= 'kobj';						{   0x6b6f626a   }
	keyAEObjectClass			= 'kocl';						{   0x6b6f636c   }
	keyAEOffStyles				= 'ofst';						{   0x6f667374   }
	keyAEOnStyles				= 'onst';						{   0x6f6e7374   }
	keyAEParameters				= 'prms';						{   0x70726d73   }
	keyAEParamFlags				= 'pmfg';						{   0x706d6667   }
	keyAEPenColor				= 'ppcl';						{   0x7070636c   }
	keyAEPenPattern				= 'pppa';						{   0x70707061   }
	keyAEPenWidth				= 'ppwd';						{   0x70707764   }
	keyAEPixelDepth				= 'pdpt';						{   0x70647074   }
	keyAEPixMapMinus			= 'kpmm';						{   0x6b706d6d   }
	keyAEPMTable				= 'kpmt';						{   0x6b706d74   }
	keyAEPointList				= 'ptlt';						{   0x70746c74   }
	keyAEPointSize				= 'ptsz';						{   0x7074737a   }
	keyAEPosition				= 'kpos';						{   0x6b706f73   }

	keyAEPropData				= 'prdt';						{   0x70726474   }
	keyAEProperties				= 'qpro';						{   0x7170726f   }
	keyAEProperty				= 'kprp';						{   0x6b707270   }
	keyAEPropFlags				= 'prfg';						{   0x70726667   }
	keyAEPropID					= 'prop';						{   0x70726f70   }
	keyAEProtection				= 'ppro';						{   0x7070726f   }
	keyAERenderAs				= 'kren';						{   0x6b72656e   }
	keyAERequestedType			= 'rtyp';						{   0x72747970   }
	keyAEResult					= '----';						{   0x2d2d2d2d   }
	keyAEResultInfo				= 'rsin';						{   0x7273696e   }
	keyAERotation				= 'prot';						{   0x70726f74   }
	keyAERotPoint				= 'krtp';						{   0x6b727470   }
	keyAERowList				= 'krls';						{   0x6b726c73   }
	keyAESaveOptions			= 'savo';						{   0x7361766f   }
	keyAEScale					= 'pscl';						{   0x7073636c   }
	keyAEScriptTag				= 'psct';						{   0x70736374   }
	keyAEShowWhere				= 'show';						{   0x73686f77   }
	keyAEStartAngle				= 'pang';						{   0x70616e67   }
	keyAEStartPoint				= 'pstp';						{   0x70737470   }
	keyAEStyles					= 'ksty';						{   0x6b737479   }

	keyAESuiteID				= 'suit';						{   0x73756974   }
	keyAEText					= 'ktxt';						{   0x6b747874   }
	keyAETextColor				= 'ptxc';						{   0x70747863   }
	keyAETextFont				= 'ptxf';						{   0x70747866   }
	keyAETextPointSize			= 'ptps';						{   0x70747073   }
	keyAETextStyles				= 'txst';						{   0x74787374   }
	keyAETextLineHeight			= 'ktlh';						{  type ShortInteger  }
	keyAETextLineAscent			= 'ktas';						{  type ShortInteger  }
	keyAETheText				= 'thtx';						{   0x74687478   }
	keyAETransferMode			= 'pptm';						{   0x7070746d   }
	keyAETranslation			= 'ptrs';						{   0x70747273   }
	keyAETryAsStructGraf		= 'toog';						{   0x746f6f67   }
	keyAEUniformStyles			= 'ustl';						{   0x7573746c   }
	keyAEUpdateOn				= 'pupd';						{   0x70757064   }
	keyAEUserTerm				= 'utrm';						{   0x7574726d   }
	keyAEWindow					= 'wndw';						{   0x776e6477   }
	keyAEWritingCode			= 'wrcd';						{   0x77726364   }

	keyMiscellaneous			= 'fmsc';						{   0x666d7363   }
	keySelection				= 'fsel';						{   0x6673656c   }
	keyWindow					= 'kwnd';						{   0x6b776e64   }
																{  EventRecord keys  }
	keyWhen						= 'when';
	keyWhere					= 'wher';
	keyModifiers				= 'mods';
	keyKey						= 'key ';
	keyKeyCode					= 'code';
	keyKeyboard					= 'keyb';
	keyDriveNumber				= 'drv#';
	keyErrorCode				= 'err#';
	keyHighLevelClass			= 'hcls';
	keyHighLevelID				= 'hid ';

	pArcAngle					= 'parc';						{   0x70617263   }
	pBackgroundColor			= 'pbcl';						{   0x7062636c   }
	pBackgroundPattern			= 'pbpt';						{   0x70627074   }
	pBestType					= 'pbst';						{   0x70627374   }
	pBounds						= 'pbnd';						{   0x70626e64   }
	pClass						= 'pcls';						{   0x70636c73   }
	pClipboard					= 'pcli';						{   0x70636c69   }
	pColor						= 'colr';						{   0x636f6c72   }
	pColorTable					= 'cltb';						{   0x636c7462   }
	pContents					= 'pcnt';						{   0x70636e74   }
	pCornerCurveHeight			= 'pchd';						{   0x70636864   }
	pCornerCurveWidth			= 'pcwd';						{   0x70637764   }
	pDashStyle					= 'pdst';						{   0x70647374   }
	pDefaultType				= 'deft';						{   0x64656674   }
	pDefinitionRect				= 'pdrt';						{   0x70647274   }
	pEnabled					= 'enbl';						{   0x656e626c   }
	pEndPoint					= 'pend';						{   0x70656e64   }
	pFillColor					= 'flcl';						{   0x666c636c   }
	pFillPattern				= 'flpt';						{   0x666c7074   }
	pFont						= 'font';						{   0x666f6e74   }

	pFormula					= 'pfor';						{   0x70666f72   }
	pGraphicObjects				= 'gobs';						{   0x676f6273   }
	pHasCloseBox				= 'hclb';						{   0x68636c62   }
	pHasTitleBar				= 'ptit';						{   0x70746974   }
	pID							= 'ID  ';						{   0x49442020   }
	pIndex						= 'pidx';						{   0x70696478   }
	pInsertionLoc				= 'pins';						{   0x70696e73   }
	pIsFloating					= 'isfl';						{   0x6973666c   }
	pIsFrontProcess				= 'pisf';						{   0x70697366   }
	pIsModal					= 'pmod';						{   0x706d6f64   }
	pIsModified					= 'imod';						{   0x696d6f64   }
	pIsResizable				= 'prsz';						{   0x7072737a   }
	pIsStationeryPad			= 'pspd';						{   0x70737064   }
	pIsZoomable					= 'iszm';						{   0x69737a6d   }
	pIsZoomed					= 'pzum';						{   0x707a756d   }
	pItemNumber					= 'itmn';						{   0x69746d6e   }
	pJustification				= 'pjst';						{   0x706a7374   }
	pLineArrow					= 'arro';						{   0x6172726f   }
	pMenuID						= 'mnid';						{   0x6d6e6964   }
	pName						= 'pnam';						{   0x706e616d   }

	pNewElementLoc				= 'pnel';						{   0x706e656c   }
	pPenColor					= 'ppcl';						{   0x7070636c   }
	pPenPattern					= 'pppa';						{   0x70707061   }
	pPenWidth					= 'ppwd';						{   0x70707764   }
	pPixelDepth					= 'pdpt';						{   0x70647074   }
	pPointList					= 'ptlt';						{   0x70746c74   }
	pPointSize					= 'ptsz';						{   0x7074737a   }
	pProtection					= 'ppro';						{   0x7070726f   }
	pRotation					= 'prot';						{   0x70726f74   }
	pScale						= 'pscl';						{   0x7073636c   }
	pScript						= 'scpt';						{   0x73637074   }
	pScriptTag					= 'psct';						{   0x70736374   }
	pSelected					= 'selc';						{   0x73656c63   }
	pSelection					= 'sele';						{   0x73656c65   }
	pStartAngle					= 'pang';						{   0x70616e67   }
	pStartPoint					= 'pstp';						{   0x70737470   }
	pTextColor					= 'ptxc';						{   0x70747863   }
	pTextFont					= 'ptxf';						{   0x70747866   }
	pTextItemDelimiters			= 'txdl';						{   0x7478646c   }
	pTextPointSize				= 'ptps';						{   0x70747073   }

	pTextStyles					= 'txst';						{   0x74787374   }
	pTransferMode				= 'pptm';						{   0x7070746d   }
	pTranslation				= 'ptrs';						{   0x70747273   }
	pUniformStyles				= 'ustl';						{   0x7573746c   }
	pUpdateOn					= 'pupd';						{   0x70757064   }
	pUserSelection				= 'pusl';						{   0x7075736c   }
	pVersion					= 'vers';						{   0x76657273   }
	pVisible					= 'pvis';						{   0x70766973   }

	typeAEText					= 'tTXT';						{   0x74545854   }
	typeArc						= 'carc';						{   0x63617263   }
	typeBest					= 'best';						{   0x62657374   }
	typeCell					= 'ccel';						{   0x6363656c   }
	typeClassInfo				= 'gcli';						{   0x67636c69   }
	typeColorTable				= 'clrt';						{   0x636c7274   }
	typeColumn					= 'ccol';						{   0x63636f6c   }
	typeDashStyle				= 'tdas';						{   0x74646173   }
	typeData					= 'tdta';						{   0x74647461   }
	typeDrawingArea				= 'cdrw';						{   0x63647277   }
	typeElemInfo				= 'elin';						{   0x656c696e   }
	typeEnumeration				= 'enum';						{   0x656e756d   }
	typeEPS						= 'EPS ';						{   0x45505320   }
	typeEventInfo				= 'evin';						{   0x6576696e   }

	typeFinderWindow			= 'fwin';						{   0x6677696e   }
	typeFixedPoint				= 'fpnt';						{   0x66706e74   }
	typeFixedRectangle			= 'frct';						{   0x66726374   }
	typeGraphicLine				= 'glin';						{   0x676c696e   }
	typeGraphicText				= 'cgtx';						{   0x63677478   }
	typeGroupedGraphic			= 'cpic';						{   0x63706963   }
	typeInsertionLoc			= 'insl';						{   0x696e736c   }
	typeIntlText				= 'itxt';						{   0x69747874   }
	typeIntlWritingCode			= 'intl';						{   0x696e746c   }
	typeLongDateTime			= 'ldt ';						{   0x6c647420   }
	typeLongFixed				= 'lfxd';						{   0x6c667864   }
	typeLongFixedPoint			= 'lfpt';						{   0x6c667074   }
	typeLongFixedRectangle		= 'lfrc';						{   0x6c667263   }
	typeLongPoint				= 'lpnt';						{   0x6c706e74   }
	typeLongRectangle			= 'lrct';						{   0x6c726374   }
	typeMachineLoc				= 'mLoc';						{   0x6d4c6f63   }
	typeOval					= 'covl';						{   0x636f766c   }
	typeParamInfo				= 'pmin';						{   0x706d696e   }
	typePict					= 'PICT';						{   0x50494354   }

	typePixelMap				= 'cpix';						{   0x63706978   }
	typePixMapMinus				= 'tpmm';						{   0x74706d6d   }
	typePolygon					= 'cpgn';						{   0x6370676e   }
	typePropInfo				= 'pinf';						{   0x70696e66   }
	typePtr						= 'ptr ';						{   0x70747220   }
	typeQDPoint					= 'QDpt';						{   0x51447074   }
	typeQDRegion				= 'Qrgn';						{   0x51447074  (data is actual region data, including rectangle and size, _not_ region handle or ptr) }
	typeRectangle				= 'crec';						{   0x63726563   }
	typeRGB16					= 'tr16';						{   0x74723136   }
	typeRGB96					= 'tr96';						{   0x74723936   }
	typeRGBColor				= 'cRGB';						{   0x63524742   }
	typeRotation				= 'trot';						{   0x74726f74   }
	typeRoundedRectangle		= 'crrc';						{   0x63727263   }
	typeRow						= 'crow';						{   0x63726f77   }
	typeScrapStyles				= 'styl';						{   0x7374796c   }
	typeScript					= 'scpt';						{   0x73637074   }
	typeStyledText				= 'STXT';						{   0x53545854   }
	typeSuiteInfo				= 'suin';						{   0x7375696e   }
	typeTable					= 'ctbl';						{   0x6374626c   }
	typeTextStyles				= 'tsty';						{   0x74737479   }

	typeTIFF					= 'TIFF';						{   0x54494646   }
	typeVersion					= 'vers';						{   0x76657273   }

	kAEMenuClass				= 'menu';
	kAEMenuSelect				= 'mhit';
	kAEMouseDown				= 'mdwn';
	kAEMouseDownInBack			= 'mdbk';
	kAEKeyDown					= 'kdwn';
	kAEResized					= 'rsiz';
	kAEPromise					= 'prom';

	keyMenuID					= 'mid ';
	keyMenuItem					= 'mitm';
	keyCloseAllWindows			= 'caw ';
	keyOriginalBounds			= 'obnd';
	keyNewBounds				= 'nbnd';
	keyLocalWhere				= 'lwhr';

	typeHIMenu					= 'mobj';
	typeHIWindow				= 'wobj';

	kBySmallIcon				= 0;
	kByIconView					= 1;
	kByNameView					= 2;
	kByDateView					= 3;
	kBySizeView					= 4;
	kByKindView					= 5;
	kByCommentView				= 6;
	kByLabelView				= 7;
	kByVersionView				= 8;

	kAEInfo						= 11;
	kAEMain						= 0;
	kAESharing					= 13;

	kAEZoomIn					= 7;
	kAEZoomOut					= 8;

	kTextServiceClass			= 'tsvc';
	kUpdateActiveInputArea		= 'updt';						{  update the active input area  }
	kShowHideInputWindow		= 'shiw';						{  show or hide the input window  }
	kPos2Offset					= 'p2st';						{  converting global coordinates to char position  }
	kOffset2Pos					= 'st2p';						{  converting char position to global coordinates  }
	kUnicodeNotFromInputMethod	= 'unim';						{  Unicode text when event not handled by Input Method or no Input Method  }
	kGetSelectedText			= 'gtxt';						{  Get text for current selection  }
	keyAETSMDocumentRefcon		= 'refc';						{  TSM document refcon, typeLongInteger  }
	keyAEServerInstance			= 'srvi';						{  component instance  }
	keyAETheData				= 'kdat';						{  typeText  }
	keyAEFixLength				= 'fixl';						{  fix len ??  }
	keyAEUpdateRange			= 'udng';						{  typeTextRangeArray  }
	keyAECurrentPoint			= 'cpos';						{  current point  }
	keyAEBufferSize				= 'buff';						{  buffer size to get the text  }
	keyAEMoveView				= 'mvvw';						{  move view flag  }
	keyAENextBody				= 'nxbd';						{  next or previous body  }
	keyAETSMScriptTag			= 'sclg';
	keyAETSMTextFont			= 'ktxf';
	keyAETSMTextPointSize		= 'ktps';
	keyAETSMEventRecord			= 'tevt';						{  Low level Event Record, typeLowLevelEventRecord  }
	keyAETSMEventRef			= 'tevr';						{  Carbon EventRef, typeEventRef  }
	keyAETextServiceEncoding	= 'tsen';						{  Text Service encoding, mac or Unicode in UpdateActiveInputArea or GetSelectedText events.  }
	keyAETextServiceMacEncoding	= 'tmen';						{  Target mac encoding for TSM conversion of text from Unicode text service.  }
	typeTextRange				= 'txrn';						{  TextRange  }
	typeComponentInstance		= 'cmpi';						{  server instance  }
	typeOffsetArray				= 'ofay';						{  offset array  }
	typeTextRangeArray			= 'tray';
	typeLowLevelEventRecord		= 'evtr';						{  Low Level Event Record  }
	typeEventRef				= 'evrf';						{  Carbon EventRef  }
	typeText					= 'TEXT';						{  Plain text  }


	{	 Desc type constants 	}
	kTSMOutsideOfBody			= 1;
	kTSMInsideOfBody			= 2;
	kTSMInsideOfActiveInputArea	= 3;

	kNextBody					= 1;
	kPreviousBody				= 2;


TYPE
	TextRangePtr = ^TextRange;
	TextRange = RECORD
		fStart:					LONGINT;
		fEnd:					LONGINT;
		fHiliteStyle:			INTEGER;
	END;

	TextRangeHandle						= ^TextRangePtr;
	TextRangeArrayPtr = ^TextRangeArray;
	TextRangeArray = RECORD
		fNumOfRanges:			INTEGER;								{  specify the size of the fRange array  }
		fRange:					ARRAY [0..0] OF TextRange;				{  when fNumOfRanges > 1, the size of this array has to be calculated  }
	END;

	TextRangeArrayHandle				= ^TextRangeArrayPtr;
	OffsetArrayPtr = ^OffsetArray;
	OffsetArray = RECORD
		fNumOfOffsets:			INTEGER;								{  specify the size of the fOffset array  }
		fOffset:				ARRAY [0..0] OF LONGINT;				{  when fNumOfOffsets > 1, the size of this array has to be calculated  }
	END;

	OffsetArrayHandle					= ^OffsetArrayPtr;
	WritingCodePtr = ^WritingCode;
	WritingCode = RECORD
		theScriptCode:			ScriptCode;
		theLangCode:			LangCode;
	END;

	IntlTextPtr = ^IntlText;
	IntlText = RECORD
		theScriptCode:			ScriptCode;
		theLangCode:			LangCode;
		theText:				SInt8;									{  variable length data  }
	END;


	{	 Hilite styles 	}

CONST
	kCaretPosition				= 1;							{  specify caret position  }
	kRawText					= 2;							{  specify range of raw text  }
	kSelectedRawText			= 3;							{  specify range of selected raw text  }
	kConvertedText				= 4;							{  specify range of converted text  }
	kSelectedConvertedText		= 5;							{  specify range of selected converted text  }
	kBlockFillText				= 6;							{  Block Fill hilite style  }
	kOutlineText				= 7;							{  Outline hilite style  }
	kSelectedText				= 8;							{  Selected hilite style  }

	keyAEHiliteRange			= 'hrng';						{  typeTextRangeArray for System 7, typeHiliteRangeArray for System 8  }
	keyAEPinRange				= 'pnrg';						{  typeTextRange for System 7, typeTextRegionRange for System 8    }
	keyAEClauseOffsets			= 'clau';						{  typeOffsetArray for System 7, typeClauseOffsetArray for System 8  }
	keyAEOffset					= 'ofst';						{  typeLongInteger for System 7, typeByteOffset for System 8   }
	keyAEPoint					= 'gpos';						{  typePoint for System 7, typeQDPoint for System 8  }
	keyAELeftSide				= 'klef';						{  typeBoolean  }
	keyAERegionClass			= 'rgnc';						{  typeShortInteger for System 7, typeRegionClass for System 8  }
	keyAEDragging				= 'bool';						{  typeBoolean  }


{$IFC OLDROUTINENAMES }
	keyAELeadingEdge			= 'klef';

{$ENDC}  {OLDROUTINENAMES}

																{  AppleScript 1.3: New Text types  }
	typeUnicodeText				= 'utxt';
	typeStyledUnicodeText		= 'sutx';
	typeEncodedString			= 'encs';
	typeCString					= 'cstr';
	typePString					= 'pstr';

																{  AppleScript 1.3: Unit types  }
	typeMeters					= 'metr';						{  Base Unit  }
	typeInches					= 'inch';
	typeFeet					= 'feet';
	typeYards					= 'yard';
	typeMiles					= 'mile';
	typeKilometers				= 'kmtr';
	typeCentimeters				= 'cmtr';
	typeSquareMeters			= 'sqrm';						{  Base Unit  }
	typeSquareFeet				= 'sqft';
	typeSquareYards				= 'sqyd';
	typeSquareMiles				= 'sqmi';
	typeSquareKilometers		= 'sqkm';
	typeLiters					= 'litr';						{  Base Unit  }
	typeQuarts					= 'qrts';
	typeGallons					= 'galn';
	typeCubicMeters				= 'cmet';						{  Base Unit  }
	typeCubicFeet				= 'cfet';
	typeCubicInches				= 'cuin';
	typeCubicCentimeter			= 'ccmt';
	typeCubicYards				= 'cyrd';
	typeKilograms				= 'kgrm';						{  Base Unit  }
	typeGrams					= 'gram';
	typeOunces					= 'ozs ';
	typePounds					= 'lbs ';
	typeDegreesC				= 'degc';						{  Base Unit  }
	typeDegreesF				= 'degf';
	typeDegreesK				= 'degk';

																{  AppleScript 1.3: Folder Actions  }
	kFAServerApp				= 'ssrv';						{  Creator code for Folder Actions Server }
	kDoFolderActionEvent		= 'fola';						{  Event the Finder sends to the Folder Actions FBA }
	kFolderActionCode			= 'actn';						{  Parameter that contains the Folder Action }
	kFolderOpenedEvent			= 'fopn';						{  Value of kFolderActionCode parameter; sent to script as event }
	kFolderClosedEvent			= 'fclo';
	kFolderWindowMovedEvent		= 'fsiz';
	kFolderItemsAddedEvent		= 'fget';
	kFolderItemsRemovedEvent	= 'flos';
	kItemList					= 'flst';						{  List parameter for added and removed items }
	kNewSizeParameter			= 'fnsz';						{  Parameter for moved window }
	kFASuiteCode				= 'faco';						{  Suite code for the following events }
	kFAAttachCommand			= 'atfa';						{  Attach event id }
	kFARemoveCommand			= 'rmfa';						{  Remove event id }
	kFAEditCommand				= 'edfa';						{  Edit event id }
	kFAFileParam				= 'faal';						{  Key for file parameter for Attach }
	kFAIndexParam				= 'indx';						{  Key for index (0-based) parameter for Remove and Edit }

	{	 AppleScript 1.3 Internet Suite 	}
																{  Suite code  }
	kAEInternetSuite			= 'gurl';
	kAEISWebStarSuite			= 'WWW�';

																{  Events  }
	kAEISGetURL					= 'gurl';
	KAEISHandleCGI				= 'sdoc';

																{  Classes  }
	cURL						= 'url ';
	cInternetAddress			= 'IPAD';
	cHTML						= 'html';
	cFTPItem					= 'ftp ';

																{  Parameters  }
	kAEISHTTPSearchArgs			= 'kfor';
	kAEISPostArgs				= 'post';
	kAEISMethod					= 'meth';
	kAEISClientAddress			= 'addr';
	kAEISUserName				= 'user';
	kAEISPassword				= 'pass';
	kAEISFromUser				= 'frmu';
	kAEISServerName				= 'svnm';
	kAEISServerPort				= 'svpt';
	kAEISScriptName				= 'scnm';
	kAEISContentType			= 'ctyp';
	kAEISReferrer				= 'refr';
	kAEISUserAgent				= 'Agnt';
	kAEISAction					= 'Kact';
	kAEISActionPath				= 'Kapt';
	kAEISClientIP				= 'Kcip';
	kAEISFullRequest			= 'Kfrq';

																{  Properties  }
	pScheme						= 'pusc';
	pHost						= 'HOST';
	pPath						= 'FTPc';
	pUserName					= 'RAun';
	pUserPassword				= 'RApw';
	pDNSForm					= 'pDNS';
	pURL						= 'pURL';
	pTextEncoding				= 'ptxe';
	pFTPKind					= 'kind';

																{  Scheme enumerations  }
	eScheme						= 'esch';
	eurlHTTP					= 'http';						{  RFC 2068  }
	eurlHTTPS					= 'htps';
	eurlFTP						= 'ftp ';						{  RFC 1738  }
	eurlMail					= 'mail';						{  RFC 2638  }
	eurlFile					= 'file';						{  RFC 1738  }
	eurlGopher					= 'gphr';						{  RFC 1738  }
	eurlTelnet					= 'tlnt';						{  RFC 1738  }
	eurlNews					= 'news';						{  RFC 1738  }
	eurlSNews					= 'snws';
	eurlNNTP					= 'nntp';						{  RFC 1738  }
	eurlMessage					= 'mess';
	eurlMailbox					= 'mbox';
	eurlMulti					= 'mult';
	eurlLaunch					= 'laun';
	eurlAFP						= 'afp ';
	eurlAT						= 'at  ';
	eurlEPPC					= 'eppc';
	eurlRTSP					= 'rtsp';						{  RFC 2326  }
	eurlIMAP					= 'imap';						{  RFC 2192  }
	eurlNFS						= 'unfs';						{  RFC 2224  }
	eurlPOP						= 'upop';						{  RFC 2384  }
	eurlLDAP					= 'uldp';						{  RFC 2255  }
	eurlUnknown					= 'url?';

																{  AppleScript 1.3: Connectivity Suite in aeut  }
	kConnSuite					= 'macc';
	cDevSpec					= 'cdev';
	cAddressSpec				= 'cadr';
	cADBAddress					= 'cadb';
	cAppleTalkAddress			= 'cat ';
	cBusAddress					= 'cbus';
	cEthernetAddress			= 'cen ';
	cFireWireAddress			= 'cfw ';
	cIPAddress					= 'cip ';
	cLocalTalkAddress			= 'clt ';
	cSCSIAddress				= 'cscs';
	cTokenRingAddress			= 'ctok';
	cUSBAddress					= 'cusb';						{   }
																{  Properties  }
	pDeviceType					= 'pdvt';
	pDeviceAddress				= 'pdva';
	pConduit					= 'pcon';
	pProtocol					= 'pprt';						{  cde 4/27/98 was 'ppro' conflicted with DB suite  }
	pATMachine					= 'patm';
	pATZone						= 'patz';
	pATType						= 'patt';
	pDottedDecimal				= 'pipd';
	pDNS						= 'pdns';
	pPort						= 'ppor';
	pNetwork					= 'pnet';
	pNode						= 'pnod';
	pSocket						= 'psoc';
	pSCSIBus					= 'pscb';
	pSCSILUN					= 'pslu';						{  cde 5/22/98 per WWDC developer request  }
																{  Enumerations and enumerators  }
	eDeviceType					= 'edvt';
	eAddressSpec				= 'eads';
	eConduit					= 'econ';
	eProtocol					= 'epro';
	eADB						= 'eadb';
	eAnalogAudio				= 'epau';
	eAppleTalk					= 'epat';
	eAudioLineIn				= 'ecai';
	eAudioLineOut				= 'ecal';						{  cde 4/24/98 changed from 'ecao' to not conflict  }
	eAudioOut					= 'ecao';
	eBus						= 'ebus';
	eCDROM						= 'ecd ';
	eCommSlot					= 'eccm';
	eDigitalAudio				= 'epda';
	eDisplay					= 'edds';
	eDVD						= 'edvd';
	eEthernet					= 'ecen';
	eFireWire					= 'ecfw';
	eFloppy						= 'efd ';
	eHD							= 'ehd ';
	eInfrared					= 'ecir';
	eIP							= 'epip';
	eIrDA						= 'epir';
	eIRTalk						= 'epit';
	eKeyboard					= 'ekbd';
	eLCD						= 'edlc';
	eLocalTalk					= 'eclt';
	eMacIP						= 'epmi';
	eMacVideo					= 'epmv';
	eMicrophone					= 'ecmi';
	eModemPort					= 'ecmp';
	eModemPrinterPort			= 'empp';
	eModem						= 'edmm';
	eMonitorOut					= 'ecmn';
	eMouse						= 'emou';
	eNuBusCard					= 'ednb';
	eNuBus						= 'enub';
	ePCcard						= 'ecpc';
	ePCIbus						= 'ecpi';
	ePCIcard					= 'edpi';
	ePDSslot					= 'ecpd';
	ePDScard					= 'epds';
	ePointingDevice				= 'edpd';
	ePostScript					= 'epps';
	ePPP						= 'eppp';
	ePrinterPort				= 'ecpp';
	ePrinter					= 'edpr';
	eSvideo						= 'epsv';
	eSCSI						= 'ecsc';
	eSerial						= 'epsr';
	eSpeakers					= 'edsp';
	eStorageDevice				= 'edst';
	eSVGA						= 'epsg';
	eTokenRing					= 'etok';
	eTrackball					= 'etrk';
	eTrackpad					= 'edtp';
	eUSB						= 'ecus';
	eVideoIn					= 'ecvi';
	eVideoMonitor				= 'edvm';
	eVideoOut					= 'ecvo';

																{  AppleScript 1.3: Keystroke class  }
	cKeystroke					= 'kprs';
	pKeystrokeKey				= 'kMsg';
	pModifiers					= 'kMod';
	pKeyKind					= 'kknd';
	eModifiers					= 'eMds';
	eOptionDown					= 'Kopt';
	eCommandDown				= 'Kcmd';
	eControlDown				= 'Kctl';
	eShiftDown					= 'Ksft';
	eCapsLockDown				= 'Kclk';
	eKeyKind					= 'ekst';						{   }
																{  Special keys all start with 'ks'  }
	eEscapeKey					= $6B733500;					{  Third byte is virtual key code byte         }
	eDeleteKey					= $6B733300;					{  (see IM Mac Toolbox Essentials, pp. 2-43)  }
	eTabKey						= $6B733000;
	eReturnKey					= $6B732400;
	eClearKey					= $6B734700;
	eEnterKey					= $6B734C00;
	eUpArrowKey					= $6B737E00;
	eDownArrowKey				= $6B737D00;
	eLeftArrowKey				= $6B737B00;
	eRightArrowKey				= $6B737C00;
	eHelpKey					= $6B737200;
	eHomeKey					= $6B737300;
	ePageUpKey					= $6B737400;
	ePageDownKey				= $6B737900;
	eForwardDelKey				= $6B737500;
	eEndKey						= $6B737700;
	eF1Key						= $6B737A00;
	eF2Key						= $6B737800;
	eF3Key						= $6B736300;
	eF4Key						= $6B737600;
	eF5Key						= $6B736000;
	eF6Key						= $6B736100;
	eF7Key						= $6B736200;
	eF8Key						= $6B736400;
	eF9Key						= $6B736500;
	eF10Key						= $6B736D00;
	eF11Key						= $6B736700;
	eF12Key						= $6B736F00;
	eF13Key						= $6B736900;
	eF14Key						= $6B736B00;
	eF15Key						= $6B737100;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AERegistryIncludes}

{$ENDC} {__AEREGISTRY__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AEUserTermTypes.p
 
     Contains:   AppleEvents AEUT resource format Interfaces.
 
     Version:    Technology: System 7.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1991-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AEUserTermTypes;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AEUSERTERMTYPES__}
{$SETC __AEUSERTERMTYPES__ := 1}

{$I+}
{$SETC AEUserTermTypesIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CONDITIONALMACROS__}
{$I ConditionalMacros.p}
{$ENDC}
{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


CONST
	kAEUserTerminology			= 'aeut';						{   0x61657574   }
	kAETerminologyExtension		= 'aete';						{   0x61657465   }
	kAEScriptingSizeResource	= 'scsz';						{   0x7363737a   }
	kAEOSAXSizeResource			= 'osiz';

	kAEUTHasReturningParam		= 31;							{  if event has a keyASReturning param  }
	kAEUTOptional				= 15;							{  if something is optional  }
	kAEUTlistOfItems			= 14;							{  if property or reply is a list.  }
	kAEUTEnumerated				= 13;							{  if property or reply is of an enumerated type.  }
	kAEUTReadWrite				= 12;							{  if property is writable.  }
	kAEUTChangesState			= 12;							{  if an event changes state.  }
	kAEUTTightBindingFunction	= 12;							{  if this is a tight-binding precedence function.  }
																{  AppleScript 1.3: new bits for reply, direct parameter, parameter, and property flags  }
	kAEUTEnumsAreTypes			= 11;							{  if the enumeration is a list of types, not constants  }
	kAEUTEnumListIsExclusive	= 10;							{  if the list of enumerations is a proper set  }
	kAEUTReplyIsReference		= 9;							{  if the reply is a reference, not a value  }
	kAEUTDirectParamIsReference	= 9;							{  if the direct parameter is a reference, not a value  }
	kAEUTParamIsReference		= 9;							{  if the parameter is a reference, not a value  }
	kAEUTPropertyIsReference	= 9;							{  if the property is a reference, not a value  }
	kAEUTNotDirectParamIsTarget	= 8;							{  if the direct parameter is not the target of the event  }
	kAEUTParamIsTarget			= 8;							{  if the parameter is the target of the event  }
	kAEUTApostrophe				= 3;							{  if a term contains an apostrophe.  }
	kAEUTFeminine				= 2;							{  if a term is feminine gender.  }
	kAEUTMasculine				= 1;							{  if a term is masculine gender.  }
	kAEUTPlural					= 0;							{  if a term is plural.  }


TYPE
	TScriptingSizeResourcePtr = ^TScriptingSizeResource;
	TScriptingSizeResource = RECORD
		scriptingSizeFlags:		INTEGER;
		minStackSize:			UInt32;
		preferredStackSize:		UInt32;
		maxStackSize:			UInt32;
		minHeapSize:			UInt32;
		preferredHeapSize:		UInt32;
		maxHeapSize:			UInt32;
	END;


CONST
	kLaunchToGetTerminology		= $8000;						{     If kLaunchToGetTerminology is 0, 'aete' is read directly from res file.  If set to 1, then launch and use 'gdut' to get terminology.  }
	kDontFindAppBySignature		= $4000;						{     If kDontFindAppBySignature is 0, then find app with signature if lost.  If 1, then don't  }
	kAlwaysSendSubject			= $2000;						{     If kAlwaysSendSubject 0, then send subject when appropriate. If 1, then every event has Subject Attribute  }

	{	 old names for above bits. 	}
	kReadExtensionTermsMask		= $8000;

																{  AppleScript 1.3: Bit positions for osiz resource  }
																{  AppleScript 1.3: Bit masks for osiz resources  }
	kOSIZDontOpenResourceFile	= 15;							{  If set, resource file is not opened when osax is loaded  }
	kOSIZdontAcceptRemoteEvents	= 14;							{  If set, handler will not be called with events from remote machines  }
	kOSIZOpenWithReadPermission	= 13;							{  If set, file will be opened with read permission only  }
	kOSIZCodeInSharedLibraries	= 11;							{  If set, loader will look for handler in shared library, not osax resources  }

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AEUserTermTypesIncludes}

{$ENDC} {__AEUSERTERMTYPES__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AIFF.p
 
     Contains:   Definition of AIFF file format components.
 
     Version:    Technology: System 8.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1989-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AIFF;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AIFF__}
{$SETC __AIFF__ := 1}

{$I+}
{$SETC AIFFIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


CONST
	AIFFID						= 'AIFF';
	AIFCID						= 'AIFC';
	FormatVersionID				= 'FVER';
	CommonID					= 'COMM';
	FORMID						= 'FORM';
	SoundDataID					= 'SSND';
	MarkerID					= 'MARK';
	InstrumentID				= 'INST';
	MIDIDataID					= 'MIDI';
	AudioRecordingID			= 'AESD';
	ApplicationSpecificID		= 'APPL';
	CommentID					= 'COMT';
	NameID						= 'NAME';
	AuthorID					= 'AUTH';
	CopyrightID					= '(c) ';
	AnnotationID				= 'ANNO';

	NoLooping					= 0;
	ForwardLooping				= 1;
	ForwardBackwardLooping		= 2;

																{  AIFF-C Versions  }
	AIFCVersion1				= $A2805140;

	{	 Compression Names 	}
	NoneName					= 'not compressed';
	ACE2to1Name					= 'ACE 2-to-1';
	ACE8to3Name					= 'ACE 8-to-3';
	MACE3to1Name				= 'MACE 3-to-1';
	MACE6to1Name				= 'MACE 6-to-1';
																{  Compression Types  }
	NoneType					= 'NONE';
	ACE2Type					= 'ACE2';
	ACE8Type					= 'ACE8';
	MACE3Type					= 'MAC3';
	MACE6Type					= 'MAC6';


TYPE
	ID									= UInt32;
	MarkerIdType						= INTEGER;
	ChunkHeaderPtr = ^ChunkHeader;
	ChunkHeader = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
	END;

	ContainerChunkPtr = ^ContainerChunk;
	ContainerChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		formType:				ID;
	END;

	FormatVersionChunkPtr = ^FormatVersionChunk;
	FormatVersionChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		timestamp:				UInt32;
	END;

	CommonChunkPtr = ^CommonChunk;
	CommonChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		numChannels:			INTEGER;
		numSampleFrames:		UInt32;
		sampleSize:				INTEGER;
		sampleRate:				extended80;
	END;

	ExtCommonChunkPtr = ^ExtCommonChunk;
	ExtCommonChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		numChannels:			INTEGER;
		numSampleFrames:		UInt32;
		sampleSize:				INTEGER;
		sampleRate:				extended80;
		compressionType:		ID;
		compressionName:		SInt8;									{  variable length array, Pascal string  }
	END;

	SoundDataChunkPtr = ^SoundDataChunk;
	SoundDataChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		offset:					UInt32;
		blockSize:				UInt32;
	END;

	MarkerPtr = ^Marker;
	Marker = RECORD
		id:						MarkerIdType;
		position:				UInt32;
		markerName:				Str255;
	END;

	MarkerChunkPtr = ^MarkerChunk;
	MarkerChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		numMarkers:				UInt16;
		Markers:				ARRAY [0..0] OF Marker;					{  variable length array  }
	END;

	AIFFLoopPtr = ^AIFFLoop;
	AIFFLoop = RECORD
		playMode:				INTEGER;
		beginLoop:				MarkerIdType;
		endLoop:				MarkerIdType;
	END;

	InstrumentChunkPtr = ^InstrumentChunk;
	InstrumentChunk = PACKED RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		baseFrequency:			UInt8;
		detune:					UInt8;
		lowFrequency:			UInt8;
		highFrequency:			UInt8;
		lowVelocity:			UInt8;
		highVelocity:			UInt8;
		gain:					INTEGER;
		sustainLoop:			AIFFLoop;
		releaseLoop:			AIFFLoop;
	END;

	MIDIDataChunkPtr = ^MIDIDataChunk;
	MIDIDataChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		MIDIdata:				SInt8;									{  variable length array  }
	END;

	AudioRecordingChunkPtr = ^AudioRecordingChunk;
	AudioRecordingChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		AESChannelStatus:		PACKED ARRAY [0..23] OF UInt8;
	END;

	ApplicationSpecificChunkPtr = ^ApplicationSpecificChunk;
	ApplicationSpecificChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		applicationSignature:	OSType;
		data:					SInt8;									{  variable length array  }
	END;

	CommentPtr = ^Comment;
	Comment = RECORD
		timeStamp:				UInt32;
		marker:					MarkerIdType;
		count:					UInt16;
		text:					SInt8;									{  variable length array, Pascal string  }
	END;

	CommentsChunkPtr = ^CommentsChunk;
	CommentsChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		numComments:			UInt16;
		comments:				ARRAY [0..0] OF Comment;				{  variable length array  }
	END;

	TextChunkPtr = ^TextChunk;
	TextChunk = RECORD
		ckID:					ID;
		ckSize:					LONGINT;
		text:					SInt8;									{  variable length array, Pascal string  }
	END;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AIFFIncludes}

{$ENDC} {__AIFF__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       Aliases.p
 
     Contains:   Alias Manager Interfaces.
 
     Version:    Technology: Mac OS 8.1
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1989-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT Aliases;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __ALIASES__}
{$SETC __ALIASES__ := 1}

{$I+}
{$SETC AliasesIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __FILES__}
{$I Files.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


CONST
	rAliasType					= 'alis';						{  Aliases are stored as resources of this type  }

																{  define alias resolution action rules mask  }
	kARMMountVol				= $00000001;					{  mount the volume automatically  }
	kARMNoUI					= $00000002;					{  no user interface allowed during resolution  }
	kARMMultVols				= $00000008;					{  search on multiple volumes  }
	kARMSearch					= $00000100;					{  search quickly  }
	kARMSearchMore				= $00000200;					{  search further  }
	kARMSearchRelFirst			= $00000400;					{  search target on a relative path first  }

																{  define alias record information types  }
	asiZoneName					= -3;							{  get zone name  }
	asiServerName				= -2;							{  get server name  }
	asiVolumeName				= -1;							{  get volume name  }
	asiAliasName				= 0;							{  get aliased file/folder/volume name  }
	asiParentName				= 1;							{  get parent folder name  }

	{	 ResolveAliasFileWithMountFlags options 	}
	kResolveAliasFileNoUI		= $00000001;					{  no user interaction during resolution  }

	{	 define the alias record that will be the blackbox for the caller 	}

TYPE
	AliasRecordPtr = ^AliasRecord;
	AliasRecord = RECORD
		userType:				OSType;									{  appl stored type like creator type  }
		aliasSize:				UInt16;									{  alias record size in bytes, for appl usage  }
	END;

	AliasPtr							= ^AliasRecord;
	AliasHandle							= ^AliasPtr;
	{	 alias record information type 	}
	AliasInfoType						= INTEGER;
	{
	 *  NewAlias()
	 *  
	 *  Summary:
	 *    create a new alias between fromFile and target, returns alias
	 *    record handle
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewAlias(fromFile: {Const}FSSpecPtr; {CONST}VAR target: FSSpec; VAR alias: AliasHandle): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7002, $A823;
	{$ENDC}

{
 *  NewAliasMinimal()
 *  
 *  Summary:
 *    create a minimal new alias for a target and return alias record
 *    handle
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewAliasMinimal({CONST}VAR target: FSSpec; VAR alias: AliasHandle): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7008, $A823;
	{$ENDC}

{
 *  NewAliasMinimalFromFullPath()
 *  
 *  Summary:
 *    create a minimal new alias from a target fullpath (optional zone
 *    and server name) and return alias record handle
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewAliasMinimalFromFullPath(fullPathLength: INTEGER; fullPath: UNIV Ptr; zoneName: Str32; serverName: Str31; VAR alias: AliasHandle): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7009, $A823;
	{$ENDC}

{
 *  ResolveAlias()
 *  
 *  Summary:
 *    given an alias handle and fromFile, resolve the alias, update the
 *    alias record and return aliased filename and wasChanged flag.
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ResolveAlias(fromFile: {Const}FSSpecPtr; alias: AliasHandle; VAR target: FSSpec; VAR wasChanged: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7003, $A823;
	{$ENDC}

{
 *  GetAliasInfo()
 *  
 *  Summary:
 *    given an alias handle and an index specifying requested alias
 *    information type, return the information from alias record as a
 *    string.
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetAliasInfo(alias: AliasHandle; index: AliasInfoType; VAR theString: Str63): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7007, $A823;
	{$ENDC}


{
 *  IsAliasFile()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION IsAliasFile({CONST}VAR fileFSSpec: FSSpec; VAR aliasFileFlag: BOOLEAN; VAR folderFlag: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $702A, $A823;
	{$ENDC}

{
 *  ResolveAliasWithMountFlags()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ResolveAliasWithMountFlags(fromFile: {Const}FSSpecPtr; alias: AliasHandle; VAR target: FSSpec; VAR wasChanged: BOOLEAN; mountFlags: UInt32): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $702B, $A823;
	{$ENDC}

{
 *  ResolveAliasFile()
 *  
 *  Summary:
 *    Given a file spec, return target file spec if input file spec is
 *    an alias. It resolves the entire alias chain or one step of the
 *    chain.  It returns info about whether the target is a folder or
 *    file; and whether the input file spec was an alias or not.
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ResolveAliasFile(VAR theSpec: FSSpec; resolveAliasChains: BOOLEAN; VAR targetIsFolder: BOOLEAN; VAR wasAliased: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $700C, $A823;
	{$ENDC}


{
 *  ResolveAliasFileWithMountFlags()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ResolveAliasFileWithMountFlags(VAR theSpec: FSSpec; resolveAliasChains: BOOLEAN; VAR targetIsFolder: BOOLEAN; VAR wasAliased: BOOLEAN; mountFlags: UInt32): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7029, $A823;
	{$ENDC}

{
 *  FollowFinderAlias()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FollowFinderAlias(fromFile: {Const}FSSpecPtr; alias: AliasHandle; logon: BOOLEAN; VAR target: FSSpec; VAR wasChanged: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $700F, $A823;
	{$ENDC}

{ 
   Low Level Routines 
}
{
 *  UpdateAlias()
 *  
 *  Summary:
 *    given a fromFile-target pair and an alias handle, update the
 *    alias record pointed to by alias handle to represent target as
 *    the new alias.
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION UpdateAlias(fromFile: {Const}FSSpecPtr; {CONST}VAR target: FSSpec; alias: AliasHandle; VAR wasChanged: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7006, $A823;
	{$ENDC}



TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	AliasFilterProcPtr = FUNCTION(cpbPtr: CInfoPBPtr; VAR quitFlag: BOOLEAN; myDataPtr: Ptr): BOOLEAN;
{$ELSEC}
	AliasFilterProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	AliasFilterUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AliasFilterUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppAliasFilterProcInfo = $00000FD0;
	{
	 *  NewAliasFilterUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewAliasFilterUPP(userRoutine: AliasFilterProcPtr): AliasFilterUPP; { old name was NewAliasFilterProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeAliasFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAliasFilterUPP(userUPP: AliasFilterUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeAliasFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeAliasFilterUPP(cpbPtr: CInfoPBPtr; VAR quitFlag: BOOLEAN; myDataPtr: Ptr; userRoutine: AliasFilterUPP): BOOLEAN; { old name was CallAliasFilterProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  MatchAlias()
 *  
 *  Summary:
 *    Given an alias handle and fromFile, match the alias and return
 *    aliased filename(s) and needsUpdate flag
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION MatchAlias(fromFile: {Const}FSSpecPtr; rulesMask: UInt32; alias: AliasHandle; VAR aliasCount: INTEGER; aliasList: FSSpecArrayPtr; VAR needsUpdate: BOOLEAN; aliasFilter: AliasFilterUPP; yourDataPtr: UNIV Ptr): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7005, $A823;
	{$ENDC}



{
 *  ResolveAliasFileWithMountFlagsNoUI()
 *  
 *  Summary:
 *    variation on ResolveAliasFile that does not prompt user with a
 *    dialog
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ResolveAliasFileWithMountFlagsNoUI(VAR theSpec: FSSpec; resolveAliasChains: BOOLEAN; VAR targetIsFolder: BOOLEAN; VAR wasAliased: BOOLEAN; mountFlags: UInt32): OSErr;

{
 *  MatchAliasNoUI()
 *  
 *  Summary:
 *    variation on MatchAlias that does not prompt user with a dialog
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION MatchAliasNoUI(fromFile: {Const}FSSpecPtr; rulesMask: UInt32; alias: AliasHandle; VAR aliasCount: INTEGER; aliasList: FSSpecArrayPtr; VAR needsUpdate: BOOLEAN; aliasFilter: AliasFilterUPP; yourDataPtr: UNIV Ptr): OSErr;

{
 *  FSNewAlias()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FSNewAlias(fromFile: {Const}FSRefPtr; {CONST}VAR target: FSRef; VAR inAlias: AliasHandle): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7036, $A823;
	{$ENDC}

{
 *  FSNewAliasMinimal()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FSNewAliasMinimal({CONST}VAR target: FSRef; VAR inAlias: AliasHandle): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7037, $A823;
	{$ENDC}

{
 *  FSIsAliasFile()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FSIsAliasFile({CONST}VAR fileRef: FSRef; VAR aliasFileFlag: BOOLEAN; VAR folderFlag: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7038, $A823;
	{$ENDC}


{
 *  FSResolveAliasWithMountFlags()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FSResolveAliasWithMountFlags(fromFile: {Const}FSRefPtr; inAlias: AliasHandle; VAR target: FSRef; VAR wasChanged: BOOLEAN; mountFlags: UInt32): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7039, $A823;
	{$ENDC}


{
 *  FSResolveAlias()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FSResolveAlias(fromFile: {Const}FSRefPtr; alias: AliasHandle; VAR target: FSRef; VAR wasChanged: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $703A, $A823;
	{$ENDC}


{
 *  FSResolveAliasFileWithMountFlags()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FSResolveAliasFileWithMountFlags(VAR theRef: FSRef; resolveAliasChains: BOOLEAN; VAR targetIsFolder: BOOLEAN; VAR wasAliased: BOOLEAN; mountFlags: UInt32): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $703B, $A823;
	{$ENDC}


{
 *  FSResolveAliasFile()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FSResolveAliasFile(VAR theRef: FSRef; resolveAliasChains: BOOLEAN; VAR targetIsFolder: BOOLEAN; VAR wasAliased: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $703C, $A823;
	{$ENDC}


{
 *  FSFollowFinderAlias()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FSFollowFinderAlias(fromFile: FSRefPtr; alias: AliasHandle; logon: BOOLEAN; VAR target: FSRef; VAR wasChanged: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $703D, $A823;
	{$ENDC}

{
 *  FSUpdateAlias()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FSUpdateAlias(fromFile: {Const}FSRefPtr; {CONST}VAR target: FSRef; alias: AliasHandle; VAR wasChanged: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $703E, $A823;
	{$ENDC}



{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AliasesIncludes}

{$ENDC} {__ALIASES__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       Appearance.p
 
     Contains:   Appearance Manager Interfaces.
 
     Version:    Technology: Mac OS 9
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1994-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT Appearance;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __APPEARANCE__}
{$SETC __APPEARANCE__ := 1}

{$I+}
{$SETC AppearanceIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __QUICKDRAW__}
{$I Quickdraw.p}
{$ENDC}
{$IFC UNDEFINED __TEXTEDIT__}
{$I TextEdit.p}
{$ENDC}
{$IFC UNDEFINED __QDOFFSCREEN__}
{$I QDOffscreen.p}
{$ENDC}
{$IFC UNDEFINED __MACWINDOWS__}
{$I MacWindows.p}
{$ENDC}
{$IFC UNDEFINED __CONTROLS__}
{$I Controls.p}
{$ENDC}
{$IFC UNDEFINED __MACERRORS__}
{$I MacErrors.p}
{$ENDC}
{$IFC UNDEFINED __TEXTUTILS__}
{$I TextUtils.p}
{$ENDC}
{$IFC UNDEFINED __CFSTRING__}
{$I CFString.p}
{$ENDC}
{����������������������������������������������������������������������������������}
{ Appearance Manager constants, etc.                                               }
{����������������������������������������������������������������������������������}
{ Appearance Manager Apple Events (1.1 and later)              }

{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


CONST
	kAppearanceEventClass		= 'appr';						{  Event Class  }
	kAEAppearanceChanged		= 'thme';						{  Appearance changed (e.g. platinum to hi-tech)  }
	kAESystemFontChanged		= 'sysf';						{  system font changed  }
	kAESmallSystemFontChanged	= 'ssfn';						{  small system font changed  }
	kAEViewsFontChanged			= 'vfnt';						{  views font changed  }

	{	����������������������������������������������������������������������������������	}
	{	 Appearance Manager file types                                                    	}
	{	����������������������������������������������������������������������������������	}
	kThemeDataFileType			= 'thme';						{  file type for theme files  }
	kThemePlatinumFileType		= 'pltn';						{  file type for platinum appearance  }
	kThemeCustomThemesFileType	= 'scen';						{  file type for user themes  }
	kThemeSoundTrackFileType	= 'tsnd';


	kThemeBrushDialogBackgroundActive = 1;						{  Dialogs  }
	kThemeBrushDialogBackgroundInactive = 2;					{  Dialogs  }
	kThemeBrushAlertBackgroundActive = 3;
	kThemeBrushAlertBackgroundInactive = 4;
	kThemeBrushModelessDialogBackgroundActive = 5;
	kThemeBrushModelessDialogBackgroundInactive = 6;
	kThemeBrushUtilityWindowBackgroundActive = 7;				{  Miscellaneous  }
	kThemeBrushUtilityWindowBackgroundInactive = 8;				{  Miscellaneous  }
	kThemeBrushListViewSortColumnBackground = 9;				{  Finder  }
	kThemeBrushListViewBackground = 10;
	kThemeBrushIconLabelBackground = 11;
	kThemeBrushListViewSeparator = 12;
	kThemeBrushChasingArrows	= 13;
	kThemeBrushDragHilite		= 14;
	kThemeBrushDocumentWindowBackground = 15;
	kThemeBrushFinderWindowBackground = 16;

	{	 Brushes available in Appearance 1.1 or later 	}
	kThemeBrushScrollBarDelimiterActive = 17;
	kThemeBrushScrollBarDelimiterInactive = 18;
	kThemeBrushFocusHighlight	= 19;
	kThemeBrushPopupArrowActive	= 20;
	kThemeBrushPopupArrowPressed = 21;
	kThemeBrushPopupArrowInactive = 22;
	kThemeBrushAppleGuideCoachmark = 23;
	kThemeBrushIconLabelBackgroundSelected = 24;
	kThemeBrushStaticAreaFill	= 25;
	kThemeBrushActiveAreaFill	= 26;
	kThemeBrushButtonFrameActive = 27;
	kThemeBrushButtonFrameInactive = 28;
	kThemeBrushButtonFaceActive	= 29;
	kThemeBrushButtonFaceInactive = 30;
	kThemeBrushButtonFacePressed = 31;
	kThemeBrushButtonActiveDarkShadow = 32;
	kThemeBrushButtonActiveDarkHighlight = 33;
	kThemeBrushButtonActiveLightShadow = 34;
	kThemeBrushButtonActiveLightHighlight = 35;
	kThemeBrushButtonInactiveDarkShadow = 36;
	kThemeBrushButtonInactiveDarkHighlight = 37;
	kThemeBrushButtonInactiveLightShadow = 38;
	kThemeBrushButtonInactiveLightHighlight = 39;
	kThemeBrushButtonPressedDarkShadow = 40;
	kThemeBrushButtonPressedDarkHighlight = 41;
	kThemeBrushButtonPressedLightShadow = 42;
	kThemeBrushButtonPressedLightHighlight = 43;
	kThemeBrushBevelActiveLight	= 44;
	kThemeBrushBevelActiveDark	= 45;
	kThemeBrushBevelInactiveLight = 46;
	kThemeBrushBevelInactiveDark = 47;

	{	 Brushes available in Appearance 1.1.1 or later 	}
	kThemeBrushNotificationWindowBackground = 48;

	{	 Brushes available in Appearance X or later 	}
	kThemeBrushMovableModalBackground = 49;
	kThemeBrushSheetBackground	= 50;
	kThemeBrushDrawerBackground	= 51;

	{	 These values are meta-brushes, specific colors that do not       	}
	{	 change from theme to theme. You can use them instead of using    	}
	{	 direct RGB values.                                               	}
	kThemeBrushBlack			= -1;
	kThemeBrushWhite			= -2;


TYPE
	ThemeBrush							= SInt16;

CONST
	kThemeTextColorDialogActive	= 1;
	kThemeTextColorDialogInactive = 2;
	kThemeTextColorAlertActive	= 3;
	kThemeTextColorAlertInactive = 4;
	kThemeTextColorModelessDialogActive = 5;
	kThemeTextColorModelessDialogInactive = 6;
	kThemeTextColorWindowHeaderActive = 7;
	kThemeTextColorWindowHeaderInactive = 8;
	kThemeTextColorPlacardActive = 9;
	kThemeTextColorPlacardInactive = 10;
	kThemeTextColorPlacardPressed = 11;
	kThemeTextColorPushButtonActive = 12;
	kThemeTextColorPushButtonInactive = 13;
	kThemeTextColorPushButtonPressed = 14;
	kThemeTextColorBevelButtonActive = 15;
	kThemeTextColorBevelButtonInactive = 16;
	kThemeTextColorBevelButtonPressed = 17;
	kThemeTextColorPopupButtonActive = 18;
	kThemeTextColorPopupButtonInactive = 19;
	kThemeTextColorPopupButtonPressed = 20;
	kThemeTextColorIconLabel	= 21;
	kThemeTextColorListView		= 22;

	{	 Text Colors available in Appearance 1.0.1 or later 	}
	kThemeTextColorDocumentWindowTitleActive = 23;
	kThemeTextColorDocumentWindowTitleInactive = 24;
	kThemeTextColorMovableModalWindowTitleActive = 25;
	kThemeTextColorMovableModalWindowTitleInactive = 26;
	kThemeTextColorUtilityWindowTitleActive = 27;
	kThemeTextColorUtilityWindowTitleInactive = 28;
	kThemeTextColorPopupWindowTitleActive = 29;
	kThemeTextColorPopupWindowTitleInactive = 30;
	kThemeTextColorRootMenuActive = 31;
	kThemeTextColorRootMenuSelected = 32;
	kThemeTextColorRootMenuDisabled = 33;
	kThemeTextColorMenuItemActive = 34;
	kThemeTextColorMenuItemSelected = 35;
	kThemeTextColorMenuItemDisabled = 36;
	kThemeTextColorPopupLabelActive = 37;
	kThemeTextColorPopupLabelInactive = 38;


	{	 Text colors available in Appearance 1.1 or later 	}
	kThemeTextColorTabFrontActive = 39;
	kThemeTextColorTabNonFrontActive = 40;
	kThemeTextColorTabNonFrontPressed = 41;
	kThemeTextColorTabFrontInactive = 42;
	kThemeTextColorTabNonFrontInactive = 43;
	kThemeTextColorIconLabelSelected = 44;
	kThemeTextColorBevelButtonStickyActive = 45;
	kThemeTextColorBevelButtonStickyInactive = 46;

	{	 Text colors available in Appearance 1.1.1 or later 	}
	kThemeTextColorNotification	= 47;

	{	 These values are specific colors that do not change from             	}
	{	 theme to theme. You can use them instead of using direct RGB values. 	}
	kThemeTextColorBlack		= -1;
	kThemeTextColorWhite		= -2;


TYPE
	ThemeTextColor						= SInt16;
	{	 States to draw primitives: disabled, active, and pressed (hilited) 	}

CONST
	kThemeStateInactive			= 0;
	kThemeStateActive			= 1;
	kThemeStatePressed			= 2;
	kThemeStateRollover			= 6;
	kThemeStateUnavailable		= 7;
	kThemeStateUnavailableInactive = 8;

	{	 obsolete name 	}
	kThemeStateDisabled			= 0;

	kThemeStatePressedUp		= 2;							{  draw with up pressed     (increment/decrement buttons)  }
	kThemeStatePressedDown		= 3;							{  draw with down pressed (increment/decrement buttons)  }


TYPE
	ThemeDrawState						= UInt32;
	{	����������������������������������������������������������������������������������	}
	{	 Theme cursor selectors available in Appearance 1.1 or later                      	}
	{	����������������������������������������������������������������������������������	}

CONST
	kThemeArrowCursor			= 0;
	kThemeCopyArrowCursor		= 1;
	kThemeAliasArrowCursor		= 2;
	kThemeContextualMenuArrowCursor = 3;
	kThemeIBeamCursor			= 4;
	kThemeCrossCursor			= 5;
	kThemePlusCursor			= 6;
	kThemeWatchCursor			= 7;							{  Can Animate  }
	kThemeClosedHandCursor		= 8;
	kThemeOpenHandCursor		= 9;
	kThemePointingHandCursor	= 10;
	kThemeCountingUpHandCursor	= 11;							{  Can Animate  }
	kThemeCountingDownHandCursor = 12;							{  Can Animate  }
	kThemeCountingUpAndDownHandCursor = 13;						{  Can Animate  }
	kThemeSpinningCursor		= 14;							{  Can Animate  }
	kThemeResizeLeftCursor		= 15;
	kThemeResizeRightCursor		= 16;
	kThemeResizeLeftRightCursor	= 17;


TYPE
	ThemeCursor							= UInt32;
	{	����������������������������������������������������������������������������������	}
	{	 Theme menu bar drawing states                                                    	}
	{	����������������������������������������������������������������������������������	}

CONST
	kThemeMenuBarNormal			= 0;
	kThemeMenuBarSelected		= 1;


TYPE
	ThemeMenuBarState					= UInt16;
	{	 attributes 	}

CONST
	kThemeMenuSquareMenuBar		= $01;

	{	����������������������������������������������������������������������������������	}
	{	 Theme menu drawing states                                                        	}
	{	����������������������������������������������������������������������������������	}
	kThemeMenuActive			= 0;
	kThemeMenuSelected			= 1;
	kThemeMenuDisabled			= 3;


TYPE
	ThemeMenuState						= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 MenuType: add kThemeMenuTypeInactive to menu type for DrawThemeMenuBackground if entire  	}
	{	 menu is inactive                                                                         	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeMenuTypePullDown		= 0;
	kThemeMenuTypePopUp			= 1;
	kThemeMenuTypeHierarchical	= 2;
	kThemeMenuTypeInactive		= $0100;


TYPE
	ThemeMenuType						= UInt16;

CONST
	kThemeMenuItemPlain			= 0;
	kThemeMenuItemHierarchical	= 1;							{  item has hierarchical arrow }
	kThemeMenuItemScrollUpArrow	= 2;							{  for scrollable menus, indicates item is scroller }
	kThemeMenuItemScrollDownArrow = 3;
	kThemeMenuItemAtTop			= $0100;						{  indicates item is being drawn at top of menu }
	kThemeMenuItemAtBottom		= $0200;						{  indicates item is being drawn at bottom of menu }
	kThemeMenuItemHierBackground = $0400;						{  item is within a hierarchical menu }
	kThemeMenuItemPopUpBackground = $0800;						{  item is within a popped up menu }
	kThemeMenuItemHasIcon		= $8000;						{  add into non-arrow type when icon present. }


TYPE
	ThemeMenuItemType					= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Theme Backgrounds                                                                        	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeBackgroundTabPane		= 1;
	kThemeBackgroundPlacard		= 2;
	kThemeBackgroundWindowHeader = 3;
	kThemeBackgroundListViewWindowHeader = 4;
	kThemeBackgroundSecondaryGroupBox = 5;


TYPE
	ThemeBackgroundKind					= UInt32;
	{	������������������������������������������������������������������������������������������	}
	{	 Theme Collection tags for Get/SetTheme                                                   	}
	{	                                                                                          	}
	{	  X ALERT: Please note that Get/SetTheme are severely neutered under Mac OS X at present. 	}
	{	           The first group of tags below are available to get under both 9 and X. The     	}
	{	           second group is 9 only. None of the tags can be used in SetTheme on X, as it   	}
	{	           is completely inert on X, and will return unimpErr.                            	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeNameTag				= 'name';						{  Str255 }
	kThemeVariantNameTag		= 'varn';						{  Str255 }
	kThemeHighlightColorTag		= 'hcol';						{  RGBColor }
	kThemeScrollBarArrowStyleTag = 'sbar';						{  ThemeScrollBarArrowStyle }
	kThemeScrollBarThumbStyleTag = 'sbth';						{  ThemeScrollBarThumbStyle }
	kThemeSoundsEnabledTag		= 'snds';						{  Boolean }
	kThemeDblClickCollapseTag	= 'coll';						{  Boolean }

	kThemeAppearanceFileNameTag	= 'thme';						{  Str255 }
	kThemeSystemFontTag			= 'lgsf';						{  Str255 }
	kThemeSmallSystemFontTag	= 'smsf';						{  Str255 }
	kThemeViewsFontTag			= 'vfnt';						{  Str255 }
	kThemeViewsFontSizeTag		= 'vfsz';						{  SInt16 }
	kThemeDesktopPatternNameTag	= 'patn';						{  Str255 }
	kThemeDesktopPatternTag		= 'patt';						{  <variable-length data> (flattened pattern) }
	kThemeDesktopPictureNameTag	= 'dpnm';						{  Str255 }
	kThemeDesktopPictureAliasTag = 'dpal';						{  <alias handle> }
	kThemeDesktopPictureAlignmentTag = 'dpan';					{  UInt32 }
	kThemeHighlightColorNameTag	= 'hcnm';						{  Str255 }
	kThemeExamplePictureIDTag	= 'epic';						{  SInt16 }
	kThemeSoundTrackNameTag		= 'sndt';						{  Str255 }
	kThemeSoundMaskTag			= 'smsk';						{  UInt32 }
	kThemeUserDefinedTag		= 'user';						{  Boolean (this should _always_ be true if present - used by Control Panel). }
	kThemeSmoothFontEnabledTag	= 'smoo';						{  Boolean }
	kThemeSmoothFontMinSizeTag	= 'smos';						{  UInt16 (must be >= 12 and <= 24) }

	{	������������������������������������������������������������������������������������������	}
	{	 Theme Control Settings                                                                   	}
	{	������������������������������������������������������������������������������������������	}
	kThemeCheckBoxClassicX		= 0;							{  check box with an 'X' }
	kThemeCheckBoxCheckMark		= 1;							{  check box with a real check mark }


TYPE
	ThemeCheckBoxStyle					= UInt16;

CONST
	kThemeScrollBarArrowsSingle	= 0;							{  single arrow on each end }
	kThemeScrollBarArrowsLowerRight = 1;						{  double arrows only on right or bottom }


TYPE
	ThemeScrollBarArrowStyle			= UInt16;

CONST
	kThemeScrollBarThumbNormal	= 0;							{  normal, classic thumb size }
	kThemeScrollBarThumbProportional = 1;						{  proportional thumbs }


TYPE
	ThemeScrollBarThumbStyle			= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Font constants                                                                           	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeSystemFont			= 0;
	kThemeSmallSystemFont		= 1;
	kThemeSmallEmphasizedSystemFont = 2;
	kThemeViewsFont				= 3;							{  The following ID's are only available with MacOS X or CarbonLib 1.3 and later }
	kThemeEmphasizedSystemFont	= 4;
	kThemeApplicationFont		= 5;
	kThemeLabelFont				= 6;
	kThemeMenuTitleFont			= 100;
	kThemeMenuItemFont			= 101;
	kThemeMenuItemMarkFont		= 102;
	kThemeMenuItemCmdKeyFont	= 103;
	kThemeWindowTitleFont		= 104;
	kThemePushButtonFont		= 105;
	kThemeUtilityWindowTitleFont = 106;
	kThemeAlertHeaderFont		= 107;
	kThemeCurrentPortFont		= 200;


TYPE
	ThemeFontID							= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Tab constants                                                                            	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeTabNonFront			= 0;
	kThemeTabNonFrontPressed	= 1;
	kThemeTabNonFrontInactive	= 2;
	kThemeTabFront				= 3;
	kThemeTabFrontInactive		= 4;
	kThemeTabNonFrontUnavailable = 5;
	kThemeTabFrontUnavailable	= 6;


TYPE
	ThemeTabStyle						= UInt16;

CONST
	kThemeTabNorth				= 0;
	kThemeTabSouth				= 1;
	kThemeTabEast				= 2;
	kThemeTabWest				= 3;


TYPE
	ThemeTabDirection					= UInt16;
	{	 NOTE ON TAB HEIGHT                                                                       	}
	{	 Use the kThemeSmallTabHeightMax and kThemeLargeTabHeightMax when calculating the rects   	}
	{	 to draw tabs into. This height includes the tab frame overlap. Tabs that are not in the  	}
	{	 front are only drawn down to where they meet the frame, as if the height was just        	}
	{	 kThemeLargeTabHeight, for example, as opposed to the ...Max constant. Remember that for  	}
	{	 East and West tabs, the height referred to below is actually the width.                  	}

CONST
	kThemeSmallTabHeight		= 16;							{  amount small tabs protrude from frame. }
	kThemeLargeTabHeight		= 21;							{  amount large tabs protrude from frame. }
	kThemeTabPaneOverlap		= 3;							{  amount tabs overlap frame. }
	kThemeSmallTabHeightMax		= 19;							{  small tab height + overlap }
	kThemeLargeTabHeightMax		= 24;							{  large tab height + overlap }

	{	������������������������������������������������������������������������������������������	}
	{	 Track kinds                                                                              	}
	{	������������������������������������������������������������������������������������������	}
	kThemeMediumScrollBar		= 0;
	kThemeSmallScrollBar		= 1;
	kThemeMediumSlider			= 2;
	kThemeMediumProgressBar		= 3;
	kThemeMediumIndeterminateBar = 4;
	kThemeRelevanceBar			= 5;
	kThemeSmallSlider			= 6;
	kThemeLargeProgressBar		= 7;
	kThemeLargeIndeterminateBar	= 8;


TYPE
	ThemeTrackKind						= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Track enable states                                                                      	}
	{	������������������������������������������������������������������������������������������	}

CONST
																{  track states  }
	kThemeTrackActive			= 0;
	kThemeTrackDisabled			= 1;
	kThemeTrackNothingToScroll	= 2;
	kThemeTrackInactive			= 3;


TYPE
	ThemeTrackEnableState				= UInt8;
	{	������������������������������������������������������������������������������������������	}
	{	 Track pressed states                                                                     	}
	{	������������������������������������������������������������������������������������������	}

CONST
																{  press states (ignored unless track is active)  }
	kThemeLeftOutsideArrowPressed = $01;
	kThemeLeftInsideArrowPressed = $02;
	kThemeLeftTrackPressed		= $04;
	kThemeThumbPressed			= $08;
	kThemeRightTrackPressed		= $10;
	kThemeRightInsideArrowPressed = $20;
	kThemeRightOutsideArrowPressed = $40;
	kThemeTopOutsideArrowPressed = $01;
	kThemeTopInsideArrowPressed	= $02;
	kThemeTopTrackPressed		= $04;
	kThemeBottomTrackPressed	= $10;
	kThemeBottomInsideArrowPressed = $20;
	kThemeBottomOutsideArrowPressed = $40;


TYPE
	ThemeTrackPressState				= UInt8;
	{	������������������������������������������������������������������������������������������	}
	{	 Thumb directions                                                                         	}
	{	������������������������������������������������������������������������������������������	}

CONST
																{  thumb direction  }
	kThemeThumbPlain			= 0;
	kThemeThumbUpward			= 1;
	kThemeThumbDownward			= 2;


TYPE
	ThemeThumbDirection					= UInt8;
	{	������������������������������������������������������������������������������������������	}
	{	 Track attributes                                                                         	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeTrackHorizontal		= $01;							{  track is drawn horizontally }
	kThemeTrackRightToLeft		= $02;							{  track progresses from right to left }
	kThemeTrackShowThumb		= $04;							{  track's thumb should be drawn }
	kThemeTrackThumbRgnIsNotGhost = $08;						{  the provided thumbRgn should be drawn opaque, not as a ghost }
	kThemeTrackNoScrollBarArrows = $10;							{  the scroll bar doesn't have arrows }


TYPE
	ThemeTrackAttributes				= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Track info block                                                                         	}
	{	������������������������������������������������������������������������������������������	}
	ScrollBarTrackInfoPtr = ^ScrollBarTrackInfo;
	ScrollBarTrackInfo = RECORD
		viewsize:				SInt32;									{  current view range size  }
		pressState:				SInt8;									{  pressed parts state  }
	END;

	SliderTrackInfoPtr = ^SliderTrackInfo;
	SliderTrackInfo = RECORD
		thumbDir:				SInt8;									{  thumb direction  }
		pressState:				SInt8;									{  pressed parts state  }
	END;

	ProgressTrackInfoPtr = ^ProgressTrackInfo;
	ProgressTrackInfo = RECORD
		phase:					SInt8;									{  phase for indeterminate progress  }
	END;

	ThemeTrackDrawInfoPtr = ^ThemeTrackDrawInfo;
	ThemeTrackDrawInfo = RECORD
		kind:					ThemeTrackKind;							{  what kind of track this info is for  }
		bounds:					Rect;									{  track basis rectangle  }
		min:					SInt32;									{  min track value  }
		max:					SInt32;									{  max track value  }
		value:					SInt32;									{  current thumb value  }
		reserved:				UInt32;
		attributes:				ThemeTrackAttributes;					{  various track attributes  }
		enableState:			SInt8;									{  enable state  }
		filler1:				SInt8;
		CASE INTEGER OF
		0: (
			scrollbar:			ScrollBarTrackInfo;
			);
		1: (
			slider:				SliderTrackInfo;
			);
		2: (
			progress:			ProgressTrackInfo;
			);
	END;

	{	������������������������������������������������������������������������������������������	}
	{	 ThemeWindowAttributes                                                                    	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeWindowHasGrow			= $01;							{  can the size of the window be changed by the user?  }
	kThemeWindowHasHorizontalZoom = $08;						{  window can zoom only horizontally  }
	kThemeWindowHasVerticalZoom	= $10;							{  window can zoom only vertically  }
	kThemeWindowHasFullZoom		= $18;							{  window zooms in all directions  }
	kThemeWindowHasCloseBox		= $20;							{  window has a close box  }
	kThemeWindowHasCollapseBox	= $40;							{  window has a collapse box  }
	kThemeWindowHasTitleText	= $80;							{  window has a title/title icon  }
	kThemeWindowIsCollapsed		= $0100;						{  window is in the collapsed state  }
	kThemeWindowHasDirty		= $0200;


TYPE
	ThemeWindowAttributes				= UInt32;
	{	������������������������������������������������������������������������������������������	}
	{	 Window Types Supported by the Appearance Manager                                         	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeDocumentWindow		= 0;
	kThemeDialogWindow			= 1;
	kThemeMovableDialogWindow	= 2;
	kThemeAlertWindow			= 3;
	kThemeMovableAlertWindow	= 4;
	kThemePlainDialogWindow		= 5;
	kThemeShadowDialogWindow	= 6;
	kThemePopupWindow			= 7;
	kThemeUtilityWindow			= 8;
	kThemeUtilitySideWindow		= 9;
	kThemeSheetWindow			= 10;


TYPE
	ThemeWindowType						= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Window Widgets Supported by the Appearance Manager                                       	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeWidgetCloseBox		= 0;
	kThemeWidgetZoomBox			= 1;
	kThemeWidgetCollapseBox		= 2;
	kThemeWidgetDirtyCloseBox	= 6;


TYPE
	ThemeTitleBarWidget					= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Popup arrow orientations                                                                 	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeArrowLeft				= 0;
	kThemeArrowDown				= 1;
	kThemeArrowRight			= 2;
	kThemeArrowUp				= 3;


TYPE
	ThemeArrowOrientation				= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Popup arrow sizes                                                                        	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeArrow3pt				= 0;
	kThemeArrow5pt				= 1;
	kThemeArrow7pt				= 2;
	kThemeArrow9pt				= 3;


TYPE
	ThemePopupArrowSize					= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Grow box directions                                                                      	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeGrowLeft				= $01;							{  can grow to the left  }
	kThemeGrowRight				= $02;							{  can grow to the right  }
	kThemeGrowUp				= $04;							{  can grow up  }
	kThemeGrowDown				= $08;							{  can grow down  }


TYPE
	ThemeGrowDirection					= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Button kinds                                                                             	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemePushButton			= 0;
	kThemeCheckBox				= 1;
	kThemeRadioButton			= 2;
	kThemeBevelButton			= 3;							{  bevel button (obsolete)  }
	kThemeArrowButton			= 4;							{  popup button without text (no label). See ThemeButtonAdornment for glyphs.  }
	kThemePopupButton			= 5;							{  popup button  }
	kThemeDisclosureButton		= 6;
	kThemeIncDecButton			= 7;							{  increment/decrement buttons  (no label)  }
	kThemeSmallBevelButton		= 8;							{  small-shadow bevel button  }
	kThemeMediumBevelButton		= 3;							{  med-shadow bevel button  }
	kThemeLargeBevelButton		= 9;							{  large-shadow bevel button  }
	kThemeListHeaderButton		= 10;							{  sort button for top of list  }
	kThemeRoundButton			= 11;							{  round button  }
	kThemeLargeRoundButton		= 12;							{  large round button  }
	kThemeSmallCheckBox			= 13;							{  small checkbox  }
	kThemeSmallRadioButton		= 14;							{  small radio button  }
	kThemeRoundedBevelButton	= 15;							{  rounded bevel button  }
	kThemeNormalCheckBox		= 1;
	kThemeNormalRadioButton		= 2;


TYPE
	ThemeButtonKind						= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Common button values                                                                     	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeButtonOff				= 0;
	kThemeButtonOn				= 1;
	kThemeButtonMixed			= 2;
	kThemeDisclosureRight		= 0;
	kThemeDisclosureDown		= 1;
	kThemeDisclosureLeft		= 2;


TYPE
	ThemeButtonValue					= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Button adornment types                                                                   	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeAdornmentNone			= 0;
	kThemeAdornmentDefault		= $01;							{  if set, draw default ornamentation ( for push button and generic well )  }
	kThemeAdornmentFocus		= $04;							{  if set, draw focus  }
	kThemeAdornmentRightToLeft	= $10;							{  if set, draw right to left label  }
	kThemeAdornmentDrawIndicatorOnly = $20;						{  if set, don't draw or erase label ( radio, check, disclosure )  }
	kThemeAdornmentHeaderButtonLeftNeighborSelected = $40;		{  if set, draw the left border of the button as selected ( list header button only )  }
	kThemeAdornmentHeaderButtonRightNeighborSelected = $80;		{  if set, draw the right border of the button ( list header button only )  }
	kThemeAdornmentHeaderButtonSortUp = $0100;					{  if set, draw the sort indicator pointing upward ( list header button only )  }
	kThemeAdornmentHeaderMenuButton = $0200;					{  if set, draw as a header menu button ( list header button only )  }
	kThemeAdornmentHeaderButtonNoShadow = $0400;				{  if set, draw the non-shadow area of the button ( list header button only )  }
	kThemeAdornmentHeaderButtonShadowOnly = $0800;				{  if set, draw the only the shadow area of the button ( list header button only )  }
	kThemeAdornmentNoShadow		= $0400;						{  old name  }
	kThemeAdornmentShadowOnly	= $0800;						{  old name  }
	kThemeAdornmentArrowLeftArrow = $40;						{  If set, draw a left arrow on the arrow button  }
	kThemeAdornmentArrowDownArrow = $80;						{  If set, draw a down arrow on the arrow button  }
	kThemeAdornmentArrowDoubleArrow = $0100;					{  If set, draw a double arrow on the arrow button  }
	kThemeAdornmentArrowUpArrow	= $0200;						{  If set, draw a up arrow on the arrow button  }


TYPE
	ThemeButtonAdornment				= UInt16;
	{	������������������������������������������������������������������������������������������	}
	{	 Button drawing info block                                                                	}
	{	������������������������������������������������������������������������������������������	}
	ThemeButtonDrawInfoPtr = ^ThemeButtonDrawInfo;
	ThemeButtonDrawInfo = RECORD
		state:					ThemeDrawState;
		value:					ThemeButtonValue;
		adornment:				ThemeButtonAdornment;
	END;

	{	������������������������������������������������������������������������������������������	}
	{	 Sound Support                                                                            	}
	{	                                                                                          	}
	{	  X ALERT: Please note that none of the theme sound APIs currently function on X.         	}
	{	������������������������������������������������������������������������������������������	}
	{	������������������������������������������������������������������������������������������	}
	{	 Sound classes                                                                            	}
	{	                                                                                          	}
	{	 You can use the constants below to set what sounds are active using the SetTheme API.    	}
	{	 Use these with the kThemeSoundMask tag.                                                  	}
	{	������������������������������������������������������������������������������������������	}

CONST
	kThemeNoSounds				= 0;
	kThemeWindowSoundsMask		= $01;
	kThemeMenuSoundsMask		= $02;
	kThemeControlSoundsMask		= $04;
	kThemeFinderSoundsMask		= $08;


	{	������������������������������������������������������������������������������������������	}
	{	 Drag Sounds                                                                              	}
	{	                                                                                          	}
	{	 Drag sounds are looped for the duration of the drag.                                     	}
	{	                                                                                          	}
	{	 Call BeginThemeDragSound at the start of the drag.                                       	}
	{	 Call EndThemeDragSound when the drag has finished.                                       	}
	{	                                                                                          	}
	{	 Note that in order to maintain a consistent user experience, only one drag sound may     	}
	{	 occur at a time.  The sound should be attached to a mouse action, start after the        	}
	{	 mouse goes down and stop when the mouse is released.                                     	}
	{	������������������������������������������������������������������������������������������	}
	kThemeDragSoundNone			= 0;
	kThemeDragSoundMoveWindow	= 'wmov';
	kThemeDragSoundGrowWindow	= 'wgro';
	kThemeDragSoundMoveUtilWindow = 'umov';
	kThemeDragSoundGrowUtilWindow = 'ugro';
	kThemeDragSoundMoveDialog	= 'dmov';
	kThemeDragSoundMoveAlert	= 'amov';
	kThemeDragSoundMoveIcon		= 'imov';
	kThemeDragSoundSliderThumb	= 'slth';
	kThemeDragSoundSliderGhost	= 'slgh';
	kThemeDragSoundScrollBarThumb = 'sbth';
	kThemeDragSoundScrollBarGhost = 'sbgh';
	kThemeDragSoundScrollBarArrowDecreasing = 'sbad';
	kThemeDragSoundScrollBarArrowIncreasing = 'sbai';
	kThemeDragSoundDragging		= 'drag';


TYPE
	ThemeDragSoundKind					= OSType;
	{	��������������������������������������������������������������������������	}
	{	 State-change sounds                                                      	}
	{	                                                                          	}
	{	 State-change sounds are played asynchonously as a one-shot.              	}
	{	                                                                          	}
	{	 Call PlayThemeSound to play the sound.  The sound will play              	}
	{	 asynchronously until complete, then stop automatically.                  	}
	{	��������������������������������������������������������������������������	}

CONST
	kThemeSoundNone				= 0;
	kThemeSoundMenuOpen			= 'mnuo';						{  menu sounds  }
	kThemeSoundMenuClose		= 'mnuc';
	kThemeSoundMenuItemHilite	= 'mnui';
	kThemeSoundMenuItemRelease	= 'mnus';
	kThemeSoundWindowClosePress	= 'wclp';						{  window sounds  }
	kThemeSoundWindowCloseEnter	= 'wcle';
	kThemeSoundWindowCloseExit	= 'wclx';
	kThemeSoundWindowCloseRelease = 'wclr';
	kThemeSoundWindowZoomPress	= 'wzmp';
	kThemeSoundWindowZoomEnter	= 'wzme';
	kThemeSoundWindowZoomExit	= 'wzmx';
	kThemeSoundWindowZoomRelease = 'wzmr';
	kThemeSoundWindowCollapsePress = 'wcop';
	kThemeSoundWindowCollapseEnter = 'wcoe';
	kThemeSoundWindowCollapseExit = 'wcox';
	kThemeSoundWindowCollapseRelease = 'wcor';
	kThemeSoundWindowDragBoundary = 'wdbd';
	kThemeSoundUtilWinClosePress = 'uclp';						{  utility window sounds  }
	kThemeSoundUtilWinCloseEnter = 'ucle';
	kThemeSoundUtilWinCloseExit	= 'uclx';
	kThemeSoundUtilWinCloseRelease = 'uclr';
	kThemeSoundUtilWinZoomPress	= 'uzmp';
	kThemeSoundUtilWinZoomEnter	= 'uzme';
	kThemeSoundUtilWinZoomExit	= 'uzmx';
	kThemeSoundUtilWinZoomRelease = 'uzmr';
	kThemeSoundUtilWinCollapsePress = 'ucop';
	kThemeSoundUtilWinCollapseEnter = 'ucoe';
	kThemeSoundUtilWinCollapseExit = 'ucox';
	kThemeSoundUtilWinCollapseRelease = 'ucor';
	kThemeSoundUtilWinDragBoundary = 'udbd';
	kThemeSoundWindowOpen		= 'wopn';						{  window close and zoom action  }
	kThemeSoundWindowClose		= 'wcls';
	kThemeSoundWindowZoomIn		= 'wzmi';
	kThemeSoundWindowZoomOut	= 'wzmo';
	kThemeSoundWindowCollapseUp	= 'wcol';
	kThemeSoundWindowCollapseDown = 'wexp';
	kThemeSoundWindowActivate	= 'wact';
	kThemeSoundUtilWindowOpen	= 'uopn';
	kThemeSoundUtilWindowClose	= 'ucls';
	kThemeSoundUtilWindowZoomIn	= 'uzmi';
	kThemeSoundUtilWindowZoomOut = 'uzmo';
	kThemeSoundUtilWindowCollapseUp = 'ucol';
	kThemeSoundUtilWindowCollapseDown = 'uexp';
	kThemeSoundUtilWindowActivate = 'uact';
	kThemeSoundDialogOpen		= 'dopn';
	kThemeSoundDialogClose		= 'dlgc';
	kThemeSoundAlertOpen		= 'aopn';
	kThemeSoundAlertClose		= 'altc';
	kThemeSoundPopupWindowOpen	= 'pwop';
	kThemeSoundPopupWindowClose	= 'pwcl';
	kThemeSoundButtonPress		= 'btnp';						{  button  }
	kThemeSoundButtonEnter		= 'btne';
	kThemeSoundButtonExit		= 'btnx';
	kThemeSoundButtonRelease	= 'btnr';
	kThemeSoundDefaultButtonPress = 'dbtp';						{  default button  }
	kThemeSoundDefaultButtonEnter = 'dbte';
	kThemeSoundDefaultButtonExit = 'dbtx';
	kThemeSoundDefaultButtonRelease = 'dbtr';
	kThemeSoundCancelButtonPress = 'cbtp';						{  cancel button  }
	kThemeSoundCancelButtonEnter = 'cbte';
	kThemeSoundCancelButtonExit	= 'cbtx';
	kThemeSoundCancelButtonRelease = 'cbtr';
	kThemeSoundCheckboxPress	= 'chkp';						{  checkboxes  }
	kThemeSoundCheckboxEnter	= 'chke';
	kThemeSoundCheckboxExit		= 'chkx';
	kThemeSoundCheckboxRelease	= 'chkr';
	kThemeSoundRadioPress		= 'radp';						{  radio buttons  }
	kThemeSoundRadioEnter		= 'rade';
	kThemeSoundRadioExit		= 'radx';
	kThemeSoundRadioRelease		= 'radr';
	kThemeSoundScrollArrowPress	= 'sbap';						{  scroll bars  }
	kThemeSoundScrollArrowEnter	= 'sbae';
	kThemeSoundScrollArrowExit	= 'sbax';
	kThemeSoundScrollArrowRelease = 'sbar';
	kThemeSoundScrollEndOfTrack	= 'sbte';
	kThemeSoundScrollTrackPress	= 'sbtp';
	kThemeSoundSliderEndOfTrack	= 'slte';						{  sliders  }
	kThemeSoundSliderTrackPress	= 'sltp';
	kThemeSoundBalloonOpen		= 'blno';						{  help balloons  }
	kThemeSoundBalloonClose		= 'blnc';
	kThemeSoundBevelPress		= 'bevp';						{  Bevel buttons  }
	kThemeSoundBevelEnter		= 'beve';
	kThemeSoundBevelExit		= 'bevx';
	kThemeSoundBevelRelease		= 'bevr';
	kThemeSoundLittleArrowUpPress = 'laup';						{  Little Arrows  }
	kThemeSoundLittleArrowDnPress = 'ladp';
	kThemeSoundLittleArrowEnter	= 'lare';
	kThemeSoundLittleArrowExit	= 'larx';
	kThemeSoundLittleArrowUpRelease = 'laur';
	kThemeSoundLittleArrowDnRelease = 'ladr';
	kThemeSoundPopupPress		= 'popp';						{  Popup Buttons  }
	kThemeSoundPopupEnter		= 'pope';
	kThemeSoundPopupExit		= 'popx';
	kThemeSoundPopupRelease		= 'popr';
	kThemeSoundDisclosurePress	= 'dscp';						{  Disclosure Buttons  }
	kThemeSoundDisclosureEnter	= 'dsce';
	kThemeSoundDisclosureExit	= 'dscx';
	kThemeSoundDisclosureRelease = 'dscr';
	kThemeSoundTabPressed		= 'tabp';						{  Tabs  }
	kThemeSoundTabEnter			= 'tabe';
	kThemeSoundTabExit			= 'tabx';
	kThemeSoundTabRelease		= 'tabr';
	kThemeSoundDragTargetHilite	= 'dthi';						{  drag manager  }
	kThemeSoundDragTargetUnhilite = 'dtuh';
	kThemeSoundDragTargetDrop	= 'dtdr';
	kThemeSoundEmptyTrash		= 'ftrs';						{  finder  }
	kThemeSoundSelectItem		= 'fsel';
	kThemeSoundNewItem			= 'fnew';
	kThemeSoundReceiveDrop		= 'fdrp';
	kThemeSoundCopyDone			= 'fcpd';
	kThemeSoundResolveAlias		= 'fral';
	kThemeSoundLaunchApp		= 'flap';
	kThemeSoundDiskInsert		= 'dski';
	kThemeSoundDiskEject		= 'dske';
	kThemeSoundFinderDragOnIcon	= 'fdon';
	kThemeSoundFinderDragOffIcon = 'fdof';


TYPE
	ThemeSoundKind						= OSType;
	{	������������������������������������������������������������������������������������������	}
	{	 Window Metrics                                                                           	}
	{	������������������������������������������������������������������������������������������	}
	{	  Window metrics are used by the Appearance manager to fill in the blanks necessary to    	}
	{	  draw windows. If a value is not appropriate for the type of window, be sure to fill in  	}
	{	  the slot in the structure with zero.    For the popupTabOffset parameter, you can pass a	}
	{	  real value based on the left edge of the window. This value might be interpreted in a   	}
	{	  different manner when depending on the value of the popupTabPosition field. The values  	}
	{	  you can pass into popupTabPosition are:                                                 	}
	{	                                                                                          	}
	{	  kThemePopupTabNormalPosition                                                            	}
	{	      Starts the tab left edge at the position indicated by the popupTabOffset field.     	}
	{	                                                                                          	}
	{	  kThemePopupTabCenterOnWindow                                                            	}
	{	      tells us to ignore the offset field and instead simply center the width of the      	}
	{	      handle on the window.                                                               	}
	{	                                                                                          	}
	{	  kThemePopupTabCenterOnOffset                                                            	}
	{	      tells us to center the width of the handle around the value passed in offset.       	}
	{	                                                                                          	}
	{	  The Appearance Manager will try its best to accomodate the requested placement, but may 	}
	{	  move the handle slightly to make it fit correctly.                                      	}
	{	                                                                                          	}

CONST
	kThemePopupTabNormalPosition = 0;
	kThemePopupTabCenterOnWindow = 1;
	kThemePopupTabCenterOnOffset = 2;


TYPE
	ThemeWindowMetricsPtr = ^ThemeWindowMetrics;
	ThemeWindowMetrics = RECORD
		metricSize:				UInt16;									{  should be always be sizeof( ThemeWindowMetrics ) }
		titleHeight:			SInt16;
		titleWidth:				SInt16;
		popupTabOffset:			SInt16;
		popupTabWidth:			SInt16;
		popupTabPosition:		UInt16;
	END;

	{	������������������������������������������������������������������������������������������	}
	{	 Theme Metrics                                                                            	}
	{	������������������������������������������������������������������������������������������	}
	{	  Theme metrics allow you to find out sizes of things in the current environment, such as 	}
	{	  how wide a scroll bar is, etc.                                                          	}

CONST
	kThemeMetricScrollBarWidth	= 0;
	kThemeMetricSmallScrollBarWidth = 1;
	kThemeMetricCheckBoxHeight	= 2;
	kThemeMetricRadioButtonHeight = 3;
	kThemeMetricEditTextWhitespace = 4;
	kThemeMetricEditTextFrameOutset = 5;
	kThemeMetricListBoxFrameOutset = 6;
	kThemeMetricFocusRectOutset	= 7;
	kThemeMetricImageWellThickness = 8;
	kThemeMetricScrollBarOverlap = 9;
	kThemeMetricLargeTabHeight	= 10;
	kThemeMetricLargeTabCapsWidth = 11;
	kThemeMetricTabFrameOverlap	= 12;
	kThemeMetricTabIndentOrStyle = 13;
	kThemeMetricTabOverlap		= 14;
	kThemeMetricSmallTabHeight	= 15;
	kThemeMetricSmallTabCapsWidth = 16;
	kThemeMetricDisclosureButtonHeight = 17;
	kThemeMetricRoundButtonSize	= 18;
	kThemeMetricPushButtonHeight = 19;
	kThemeMetricListHeaderHeight = 20;
	kThemeMetricSmallCheckBoxHeight = 21;
	kThemeMetricDisclosureButtonWidth = 22;
	kThemeMetricSmallDisclosureButtonHeight = 23;
	kThemeMetricSmallDisclosureButtonWidth = 24;
	kThemeMetricDisclosureTriangleHeight = 25;
	kThemeMetricDisclosureTriangleWidth = 26;
	kThemeMetricLittleArrowsHeight = 27;
	kThemeMetricLittleArrowsWidth = 28;
	kThemeMetricPaneSplitterHeight = 29;
	kThemeMetricPopupButtonHeight = 30;
	kThemeMetricSmallPopupButtonHeight = 31;
	kThemeMetricLargeProgressBarThickness = 32;
	kThemeMetricPullDownHeight	= 33;
	kThemeMetricSmallPullDownHeight = 34;
	kThemeMetricSmallPushButtonHeight = 35;
	kThemeMetricSmallRadioButtonHeight = 36;
	kThemeMetricRelevanceIndicatorHeight = 37;
	kThemeMetricResizeControlHeight = 38;
	kThemeMetricSmallResizeControlHeight = 39;
	kThemeMetricLargeRoundButtonSize = 40;
	kThemeMetricHSliderHeight	= 41;
	kThemeMetricHSliderTickHeight = 42;
	kThemeMetricSmallHSliderHeight = 43;
	kThemeMetricSmallHSliderTickHeight = 44;
	kThemeMetricVSliderWidth	= 45;
	kThemeMetricVSliderTickWidth = 46;
	kThemeMetricSmallVSliderWidth = 47;
	kThemeMetricSmallVSliderTickWidth = 48;
	kThemeMetricTitleBarControlsHeight = 49;
	kThemeMetricCheckBoxWidth	= 50;
	kThemeMetricSmallCheckBoxWidth = 51;
	kThemeMetricRadioButtonWidth = 52;
	kThemeMetricSmallRadioButtonWidth = 53;
	kThemeMetricSmallHSliderMinThumbWidth = 54;
	kThemeMetricSmallVSliderMinThumbHeight = 55;
	kThemeMetricSmallHSliderTickOffset = 56;
	kThemeMetricSmallVSliderTickOffset = 57;
	kThemeMetricNormalProgressBarThickness = 58;
	kThemeMetricProgressBarShadowOutset = 59;
	kThemeMetricSmallProgressBarShadowOutset = 60;
	kThemeMetricPrimaryGroupBoxContentInset = 61;
	kThemeMetricSecondaryGroupBoxContentInset = 62;


TYPE
	ThemeMetric							= UInt32;
	{	������������������������������������������������������������������������������������������	}
	{	 Drawing State                                                                            	}
	{	������������������������������������������������������������������������������������������	}
	ThemeDrawingState    = ^LONGINT; { an opaque 32-bit type }
	ThemeDrawingStatePtr = ^ThemeDrawingState;  { when a VAR xx:ThemeDrawingState parameter can be nil, it is changed to xx: ThemeDrawingStatePtr }
	{	������������������������������������������������������������������������������������������	}
	{	 Callback procs                                                                           	}
	{	������������������������������������������������������������������������������������������	}
{$IFC TYPED_FUNCTION_POINTERS}
	ThemeTabTitleDrawProcPtr = PROCEDURE({CONST}VAR bounds: Rect; style: ThemeTabStyle; direction: ThemeTabDirection; depth: SInt16; isColorDev: BOOLEAN; userData: UInt32);
{$ELSEC}
	ThemeTabTitleDrawProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ThemeEraseProcPtr = PROCEDURE({CONST}VAR bounds: Rect; eraseData: UInt32; depth: SInt16; isColorDev: BOOLEAN);
{$ELSEC}
	ThemeEraseProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ThemeButtonDrawProcPtr = PROCEDURE({CONST}VAR bounds: Rect; kind: ThemeButtonKind; {CONST}VAR info: ThemeButtonDrawInfo; userData: UInt32; depth: SInt16; isColorDev: BOOLEAN);
{$ELSEC}
	ThemeButtonDrawProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	WindowTitleDrawingProcPtr = PROCEDURE({CONST}VAR bounds: Rect; depth: SInt16; colorDevice: BOOLEAN; userData: UInt32);
{$ELSEC}
	WindowTitleDrawingProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ThemeIteratorProcPtr = FUNCTION(inFileName: Str255; resID: SInt16; inThemeSettings: Collection; inUserData: UNIV Ptr): BOOLEAN;
{$ELSEC}
	ThemeIteratorProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	ThemeTabTitleDrawUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ThemeTabTitleDrawUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ThemeEraseUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ThemeEraseUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ThemeButtonDrawUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ThemeButtonDrawUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	WindowTitleDrawingUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	WindowTitleDrawingUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ThemeIteratorUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ThemeIteratorUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppThemeTabTitleDrawProcInfo = $00036AC0;
	uppThemeEraseProcInfo = $00001BC0;
	uppThemeButtonDrawProcInfo = $0001BEC0;
	uppWindowTitleDrawingProcInfo = $000036C0;
	uppThemeIteratorProcInfo = $00003ED0;
	{
	 *  NewThemeTabTitleDrawUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewThemeTabTitleDrawUPP(userRoutine: ThemeTabTitleDrawProcPtr): ThemeTabTitleDrawUPP; { old name was NewThemeTabTitleDrawProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewThemeEraseUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewThemeEraseUPP(userRoutine: ThemeEraseProcPtr): ThemeEraseUPP; { old name was NewThemeEraseProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewThemeButtonDrawUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewThemeButtonDrawUPP(userRoutine: ThemeButtonDrawProcPtr): ThemeButtonDrawUPP; { old name was NewThemeButtonDrawProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewWindowTitleDrawingUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewWindowTitleDrawingUPP(userRoutine: WindowTitleDrawingProcPtr): WindowTitleDrawingUPP; { old name was NewWindowTitleDrawingProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewThemeIteratorUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewThemeIteratorUPP(userRoutine: ThemeIteratorProcPtr): ThemeIteratorUPP; { old name was NewThemeIteratorProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeThemeTabTitleDrawUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeThemeTabTitleDrawUPP(userUPP: ThemeTabTitleDrawUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeThemeEraseUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeThemeEraseUPP(userUPP: ThemeEraseUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeThemeButtonDrawUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeThemeButtonDrawUPP(userUPP: ThemeButtonDrawUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeWindowTitleDrawingUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeWindowTitleDrawingUPP(userUPP: WindowTitleDrawingUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeThemeIteratorUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeThemeIteratorUPP(userUPP: ThemeIteratorUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeThemeTabTitleDrawUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE InvokeThemeTabTitleDrawUPP({CONST}VAR bounds: Rect; style: ThemeTabStyle; direction: ThemeTabDirection; depth: SInt16; isColorDev: BOOLEAN; userData: UInt32; userRoutine: ThemeTabTitleDrawUPP); { old name was CallThemeTabTitleDrawProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeThemeEraseUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE InvokeThemeEraseUPP({CONST}VAR bounds: Rect; eraseData: UInt32; depth: SInt16; isColorDev: BOOLEAN; userRoutine: ThemeEraseUPP); { old name was CallThemeEraseProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeThemeButtonDrawUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE InvokeThemeButtonDrawUPP({CONST}VAR bounds: Rect; kind: ThemeButtonKind; {CONST}VAR info: ThemeButtonDrawInfo; userData: UInt32; depth: SInt16; isColorDev: BOOLEAN; userRoutine: ThemeButtonDrawUPP); { old name was CallThemeButtonDrawProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeWindowTitleDrawingUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE InvokeWindowTitleDrawingUPP({CONST}VAR bounds: Rect; depth: SInt16; colorDevice: BOOLEAN; userData: UInt32; userRoutine: WindowTitleDrawingUPP); { old name was CallWindowTitleDrawingProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeThemeIteratorUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeThemeIteratorUPP(inFileName: Str255; resID: SInt16; inThemeSettings: Collection; inUserData: UNIV Ptr; userRoutine: ThemeIteratorUPP): BOOLEAN; { old name was CallThemeIteratorProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{����������������������������������������������������������������������������������}
{ Menu Drawing callbacks                                                           }
{����������������������������������������������������������������������������������}

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	MenuTitleDrawingProcPtr = PROCEDURE({CONST}VAR inBounds: Rect; inDepth: SInt16; inIsColorDevice: BOOLEAN; inUserData: SInt32);
{$ELSEC}
	MenuTitleDrawingProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	MenuItemDrawingProcPtr = PROCEDURE({CONST}VAR inBounds: Rect; inDepth: SInt16; inIsColorDevice: BOOLEAN; inUserData: SInt32);
{$ELSEC}
	MenuItemDrawingProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	MenuTitleDrawingUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	MenuTitleDrawingUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	MenuItemDrawingUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	MenuItemDrawingUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppMenuTitleDrawingProcInfo = $000036C0;
	uppMenuItemDrawingProcInfo = $000036C0;
	{
	 *  NewMenuTitleDrawingUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewMenuTitleDrawingUPP(userRoutine: MenuTitleDrawingProcPtr): MenuTitleDrawingUPP; { old name was NewMenuTitleDrawingProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewMenuItemDrawingUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewMenuItemDrawingUPP(userRoutine: MenuItemDrawingProcPtr): MenuItemDrawingUPP; { old name was NewMenuItemDrawingProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeMenuTitleDrawingUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeMenuTitleDrawingUPP(userUPP: MenuTitleDrawingUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeMenuItemDrawingUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeMenuItemDrawingUPP(userUPP: MenuItemDrawingUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeMenuTitleDrawingUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE InvokeMenuTitleDrawingUPP({CONST}VAR inBounds: Rect; inDepth: SInt16; inIsColorDevice: BOOLEAN; inUserData: SInt32; userRoutine: MenuTitleDrawingUPP); { old name was CallMenuTitleDrawingProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeMenuItemDrawingUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE InvokeMenuItemDrawingUPP({CONST}VAR inBounds: Rect; inDepth: SInt16; inIsColorDevice: BOOLEAN; inUserData: SInt32; userRoutine: MenuItemDrawingUPP); { old name was CallMenuItemDrawingProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{����������������������������������������������������������������������������������}
{  Appearance Manager APIs                                                         }
{����������������������������������������������������������������������������������}
{ Registering Appearance-Savvy Applications }
{
 *  RegisterAppearanceClient()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION RegisterAppearanceClient: OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0015, $AA74;
	{$ENDC}

{
 *  UnregisterAppearanceClient()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION UnregisterAppearanceClient: OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0016, $AA74;
	{$ENDC}

{
 *  IsAppearanceClient()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION IsAppearanceClient({CONST}VAR process: ProcessSerialNumber): BOOLEAN;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $FFFF, $AA74;
	{$ENDC}

{****************************************************************************
    NOTES ON THEME BRUSHES
    Theme brushes can be either colors or patterns, depending on the theme.
    Because of this, you should be prepared to handle the case where a brush
    is a pattern and save and restore the pnPixPat and bkPixPat fields of
    your GrafPorts when saving the fore and back colors. Also, since patterns
    in bkPixPat override the background color of the window, you should use
    BackPat to set your background pattern to a normal white pattern. This
    will ensure that you can use RGBBackColor to set your back color to white,
    call EraseRect and get the expected results.
****************************************************************************}

{
 *  SetThemePen()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetThemePen(inBrush: ThemeBrush; inDepth: SInt16; inIsColorDevice: BOOLEAN): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0001, $AA74;
	{$ENDC}

{
 *  SetThemeBackground()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetThemeBackground(inBrush: ThemeBrush; inDepth: SInt16; inIsColorDevice: BOOLEAN): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0002, $AA74;
	{$ENDC}

{
 *  SetThemeTextColor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetThemeTextColor(inColor: ThemeTextColor; inDepth: SInt16; inIsColorDevice: BOOLEAN): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0003, $AA74;
	{$ENDC}

{
 *  SetThemeWindowBackground()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetThemeWindowBackground(inWindow: WindowRef; inBrush: ThemeBrush; inUpdate: BOOLEAN): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0004, $AA74;
	{$ENDC}

{ Window Placards, Headers and Frames }
{
 *  DrawThemeWindowHeader()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeWindowHeader({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0005, $AA74;
	{$ENDC}

{
 *  DrawThemeWindowListViewHeader()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeWindowListViewHeader({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0006, $AA74;
	{$ENDC}

{
 *  DrawThemePlacard()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemePlacard({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0007, $AA74;
	{$ENDC}

{
 *  DrawThemeEditTextFrame()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeEditTextFrame({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0009, $AA74;
	{$ENDC}

{
 *  DrawThemeListBoxFrame()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeListBoxFrame({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $000A, $AA74;
	{$ENDC}

{ Keyboard Focus Drawing }
{
 *  DrawThemeFocusRect()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeFocusRect({CONST}VAR inRect: Rect; inHasFocus: BOOLEAN): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $000B, $AA74;
	{$ENDC}

{ Dialog Group Boxes and Separators }
{
 *  DrawThemePrimaryGroup()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemePrimaryGroup({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $000C, $AA74;
	{$ENDC}

{
 *  DrawThemeSecondaryGroup()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeSecondaryGroup({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $000D, $AA74;
	{$ENDC}

{
 *  DrawThemeSeparator()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeSeparator({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $000E, $AA74;
	{$ENDC}

{������������������������������ BEGIN APPEARANCE 1.0.1 ��������������������������������������������}
{ The following Appearance Manager APIs are only available }
{ in Appearance 1.0.1 or later                             }
{
 *  DrawThemeModelessDialogFrame()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeModelessDialogFrame({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0008, $AA74;
	{$ENDC}

{
 *  DrawThemeGenericWell()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeGenericWell({CONST}VAR inRect: Rect; inState: ThemeDrawState; inFillCenter: BOOLEAN): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0022, $AA74;
	{$ENDC}

{
 *  DrawThemeFocusRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeFocusRegion(inRegion: RgnHandle; inHasFocus: BOOLEAN): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0023, $AA74;
	{$ENDC}

{
 *  IsThemeInColor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION IsThemeInColor(inDepth: SInt16; inIsColorDevice: BOOLEAN): BOOLEAN;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0024, $AA74;
	{$ENDC}

{ IMPORTANT: GetThemeAccentColors will only work in the platinum theme. Any other theme will }
{ most likely return an error }
{
 *  GetThemeAccentColors()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeAccentColors(VAR outColors: CTabHandle): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0025, $AA74;
	{$ENDC}

{
 *  DrawThemeMenuBarBackground()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeMenuBarBackground({CONST}VAR inBounds: Rect; inState: ThemeMenuBarState; inAttributes: UInt32): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0018, $AA74;
	{$ENDC}

{
 *  DrawThemeMenuTitle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeMenuTitle({CONST}VAR inMenuBarRect: Rect; {CONST}VAR inTitleRect: Rect; inState: ThemeMenuState; inAttributes: UInt32; inTitleProc: MenuTitleDrawingUPP; inTitleData: UInt32): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0019, $AA74;
	{$ENDC}


{
 *  GetThemeMenuBarHeight()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeMenuBarHeight(VAR outHeight: SInt16): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $001A, $AA74;
	{$ENDC}

{
 *  DrawThemeMenuBackground()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeMenuBackground({CONST}VAR inMenuRect: Rect; inMenuType: ThemeMenuType): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $001B, $AA74;
	{$ENDC}

{
 *  GetThemeMenuBackgroundRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeMenuBackgroundRegion({CONST}VAR inMenuRect: Rect; menuType: ThemeMenuType; region: RgnHandle): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $001C, $AA74;
	{$ENDC}

{
 *  DrawThemeMenuItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeMenuItem({CONST}VAR inMenuRect: Rect; {CONST}VAR inItemRect: Rect; inVirtualMenuTop: SInt16; inVirtualMenuBottom: SInt16; inState: ThemeMenuState; inItemType: ThemeMenuItemType; inDrawProc: MenuItemDrawingUPP; inUserData: UInt32): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $001D, $AA74;
	{$ENDC}

{
 *  DrawThemeMenuSeparator()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeMenuSeparator({CONST}VAR inItemRect: Rect): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $001E, $AA74;
	{$ENDC}

{
 *  GetThemeMenuSeparatorHeight()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeMenuSeparatorHeight(VAR outHeight: SInt16): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $001F, $AA74;
	{$ENDC}

{
 *  GetThemeMenuItemExtra()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeMenuItemExtra(inItemType: ThemeMenuItemType; VAR outHeight: SInt16; VAR outWidth: SInt16): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0020, $AA74;
	{$ENDC}

{
 *  GetThemeMenuTitleExtra()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeMenuTitleExtra(VAR outWidth: SInt16; inIsSquished: BOOLEAN): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0021, $AA74;
	{$ENDC}

{������������������������������� BEGIN APPEARANCE 1.1 ���������������������������������������������}
{���������������������������������� THEME SWITCHING �����������������������������������������������}
{                                                                                                  }
{  X ALERT: Please note that Get/SetTheme are severely neutered under Mac OS X at present.         }
{           See the note above regarding what collection tags are supported under X.               }

{
 *  GetTheme()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetTheme(ioCollection: Collection): OSStatus;

{
 *  SetTheme()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetTheme(ioCollection: Collection): OSStatus;

{
 *  IterateThemes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION IterateThemes(inProc: ThemeIteratorUPP; inUserData: UNIV Ptr): OSStatus;

{���������������������������������������� TABS ����������������������������������������������������}
{
 *  DrawThemeTabPane()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeTabPane({CONST}VAR inRect: Rect; inState: ThemeDrawState): OSStatus;

{
 *  DrawThemeTab()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeTab({CONST}VAR inRect: Rect; inStyle: ThemeTabStyle; inDirection: ThemeTabDirection; labelProc: ThemeTabTitleDrawUPP; userData: UInt32): OSStatus;

{
 *  GetThemeTabRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTabRegion({CONST}VAR inRect: Rect; inStyle: ThemeTabStyle; inDirection: ThemeTabDirection; ioRgn: RgnHandle): OSStatus;

{��������������������������������������� CURSORS ��������������������������������������������������}
{
 *  SetThemeCursor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetThemeCursor(inCursor: ThemeCursor): OSStatus;

{
 *  SetAnimatedThemeCursor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetAnimatedThemeCursor(inCursor: ThemeCursor; inAnimationStep: UInt32): OSStatus;

{�������������������������������� CONTROL STYLE SETTINGS ������������������������������������������}
{
 *  GetThemeScrollBarThumbStyle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeScrollBarThumbStyle(VAR outStyle: ThemeScrollBarThumbStyle): OSStatus;

{
 *  GetThemeScrollBarArrowStyle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeScrollBarArrowStyle(VAR outStyle: ThemeScrollBarArrowStyle): OSStatus;

{
 *  GetThemeCheckBoxStyle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeCheckBoxStyle(VAR outStyle: ThemeCheckBoxStyle): OSStatus;

{���������������������������������������� FONTS/TEXT ����������������������������������������������}
{
 *  UseThemeFont()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION UseThemeFont(inFontID: ThemeFontID; inScript: ScriptCode): OSStatus;

{
 *  GetThemeFont()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeFont(inFontID: ThemeFontID; inScript: ScriptCode; outFontName: StringPtr; VAR outFontSize: SInt16; VAR outStyle: Style): OSStatus;

{
 *  DrawThemeTextBox()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeTextBox(inString: CFStringRef; inFontID: ThemeFontID; inState: ThemeDrawState; inWrapToWidth: BOOLEAN; {CONST}VAR inBoundingBox: Rect; inJust: SInt16; inContext: UNIV Ptr): OSStatus;

{
 *  TruncateThemeText()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION TruncateThemeText(inString: CFMutableStringRef; inFontID: ThemeFontID; inState: ThemeDrawState; inPixelWidthLimit: SInt16; inTruncWhere: TruncCode; VAR outTruncated: BOOLEAN): OSStatus;

{
 *  GetThemeTextDimensions()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTextDimensions(inString: CFStringRef; inFontID: ThemeFontID; inState: ThemeDrawState; inWrapToWidth: BOOLEAN; VAR ioBounds: Point; VAR outBaseline: SInt16): OSStatus;

{
 *  GetThemeTextShadowOutset()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTextShadowOutset(inFontID: ThemeFontID; inState: ThemeDrawState; VAR outOutset: Rect): OSStatus;

{���������������������������������������� TRACKS ��������������������������������������������������}
{
 *  DrawThemeTrack()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeTrack({CONST}VAR drawInfo: ThemeTrackDrawInfo; rgnGhost: RgnHandle; eraseProc: ThemeEraseUPP; eraseData: UInt32): OSStatus;

{
 *  HitTestThemeTrack()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION HitTestThemeTrack({CONST}VAR drawInfo: ThemeTrackDrawInfo; mousePoint: Point; VAR partHit: ControlPartCode): BOOLEAN;

{
 *  GetThemeTrackBounds()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTrackBounds({CONST}VAR drawInfo: ThemeTrackDrawInfo; VAR bounds: Rect): OSStatus;

{
 *  GetThemeTrackThumbRgn()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTrackThumbRgn({CONST}VAR drawInfo: ThemeTrackDrawInfo; thumbRgn: RgnHandle): OSStatus;

{
 *  GetThemeTrackDragRect()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTrackDragRect({CONST}VAR drawInfo: ThemeTrackDrawInfo; VAR dragRect: Rect): OSStatus;

{
 *  DrawThemeTrackTickMarks()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeTrackTickMarks({CONST}VAR drawInfo: ThemeTrackDrawInfo; numTicks: ItemCount; eraseProc: ThemeEraseUPP; eraseData: UInt32): OSStatus;

{
 *  GetThemeTrackThumbPositionFromOffset()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTrackThumbPositionFromOffset({CONST}VAR drawInfo: ThemeTrackDrawInfo; thumbOffset: Point; VAR relativePosition: SInt32): OSStatus;

{
 *  GetThemeTrackThumbPositionFromRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTrackThumbPositionFromRegion({CONST}VAR drawInfo: ThemeTrackDrawInfo; thumbRgn: RgnHandle; VAR relativePosition: SInt32): OSStatus;

{
 *  GetThemeTrackLiveValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTrackLiveValue({CONST}VAR drawInfo: ThemeTrackDrawInfo; relativePosition: SInt32; VAR value: SInt32): OSStatus;

{����������������������������������� SCROLLBAR ARROWS ���������������������������������������������}
{
 *  DrawThemeScrollBarArrows()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeScrollBarArrows({CONST}VAR bounds: Rect; enableState: ByteParameter; pressState: ByteParameter; isHoriz: BOOLEAN; VAR trackBounds: Rect): OSStatus;

{
 *  GetThemeScrollBarTrackRect()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeScrollBarTrackRect({CONST}VAR bounds: Rect; enableState: ByteParameter; pressState: ByteParameter; isHoriz: BOOLEAN; VAR trackBounds: Rect): OSStatus;

{
 *  HitTestThemeScrollBarArrows()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION HitTestThemeScrollBarArrows({CONST}VAR scrollBarBounds: Rect; enableState: ByteParameter; pressState: ByteParameter; isHoriz: BOOLEAN; ptHit: Point; VAR trackBounds: Rect; VAR partcode: ControlPartCode): BOOLEAN;

{���������������������������������������� WINDOWS �������������������������������������������������}
{
 *  GetThemeWindowRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeWindowRegion(flavor: ThemeWindowType; {CONST}VAR contRect: Rect; state: ThemeDrawState; {CONST}VAR metrics: ThemeWindowMetrics; attributes: ThemeWindowAttributes; winRegion: WindowRegionCode; rgn: RgnHandle): OSStatus;

{
 *  DrawThemeWindowFrame()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeWindowFrame(flavor: ThemeWindowType; {CONST}VAR contRect: Rect; state: ThemeDrawState; {CONST}VAR metrics: ThemeWindowMetrics; attributes: ThemeWindowAttributes; titleProc: WindowTitleDrawingUPP; titleData: UInt32): OSStatus;

{
 *  DrawThemeTitleBarWidget()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeTitleBarWidget(flavor: ThemeWindowType; {CONST}VAR contRect: Rect; state: ThemeDrawState; {CONST}VAR metrics: ThemeWindowMetrics; attributes: ThemeWindowAttributes; widget: ThemeTitleBarWidget): OSStatus;

{
 *  GetThemeWindowRegionHit()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeWindowRegionHit(flavor: ThemeWindowType; {CONST}VAR inContRect: Rect; state: ThemeDrawState; {CONST}VAR metrics: ThemeWindowMetrics; inAttributes: ThemeWindowAttributes; inPoint: Point; VAR outRegionHit: WindowRegionCode): BOOLEAN;

{
 *  DrawThemeScrollBarDelimiters()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeScrollBarDelimiters(flavor: ThemeWindowType; {CONST}VAR inContRect: Rect; state: ThemeDrawState; attributes: ThemeWindowAttributes): OSStatus;


{���������������������������������������� BUTTONS �������������������������������������������������}
{
 *  DrawThemeButton()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeButton({CONST}VAR inBounds: Rect; inKind: ThemeButtonKind; {CONST}VAR inNewInfo: ThemeButtonDrawInfo; inPrevInfo: {Const}ThemeButtonDrawInfoPtr; inEraseProc: ThemeEraseUPP; inLabelProc: ThemeButtonDrawUPP; inUserData: UInt32): OSStatus;

{
 *  GetThemeButtonRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeButtonRegion({CONST}VAR inBounds: Rect; inKind: ThemeButtonKind; {CONST}VAR inNewInfo: ThemeButtonDrawInfo; outRegion: RgnHandle): OSStatus;

{
 *  GetThemeButtonContentBounds()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeButtonContentBounds({CONST}VAR inBounds: Rect; inKind: ThemeButtonKind; {CONST}VAR inDrawInfo: ThemeButtonDrawInfo; VAR outBounds: Rect): OSStatus;

{
 *  GetThemeButtonBackgroundBounds()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeButtonBackgroundBounds({CONST}VAR inBounds: Rect; inKind: ThemeButtonKind; {CONST}VAR inDrawInfo: ThemeButtonDrawInfo; VAR outBounds: Rect): OSStatus;


{������������������������������������� INTERFACE SOUNDS �������������������������������������������}
{                                                                                                  }
{  X ALERT: Please note that the sound APIs do not work on Mac OS X at present.                    }
{
 *  PlayThemeSound()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION PlayThemeSound(kind: ThemeSoundKind): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0026, $AA74;
	{$ENDC}

{
 *  BeginThemeDragSound()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION BeginThemeDragSound(kind: ThemeDragSoundKind): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0027, $AA74;
	{$ENDC}

{
 *  EndThemeDragSound()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION EndThemeDragSound: OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0028, $AA74;
	{$ENDC}

{�������������������������������������� PRIMITIVES ������������������������������������������������}
{
 *  DrawThemeTickMark()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeTickMark({CONST}VAR bounds: Rect; state: ThemeDrawState): OSStatus;

{
 *  DrawThemeChasingArrows()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeChasingArrows({CONST}VAR bounds: Rect; index: UInt32; state: ThemeDrawState; eraseProc: ThemeEraseUPP; eraseData: UInt32): OSStatus;

{
 *  DrawThemePopupArrow()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemePopupArrow({CONST}VAR bounds: Rect; orientation: ThemeArrowOrientation; size: ThemePopupArrowSize; state: ThemeDrawState; eraseProc: ThemeEraseUPP; eraseData: UInt32): OSStatus;

{
 *  DrawThemeStandaloneGrowBox()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeStandaloneGrowBox(origin: Point; growDirection: ThemeGrowDirection; isSmall: BOOLEAN; state: ThemeDrawState): OSStatus;

{
 *  DrawThemeStandaloneNoGrowBox()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DrawThemeStandaloneNoGrowBox(origin: Point; growDirection: ThemeGrowDirection; isSmall: BOOLEAN; state: ThemeDrawState): OSStatus;

{
 *  GetThemeStandaloneGrowBoxBounds()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeStandaloneGrowBoxBounds(origin: Point; growDirection: ThemeGrowDirection; isSmall: BOOLEAN; VAR bounds: Rect): OSStatus;

{������������������������������������� DRAWING STATE ����������������������������������������������}
{ The following routines help you save and restore the drawing state in a theme-savvy manner. With }
{ these weapons in your arsenal, there is no grafport you cannot tame. Use ThemeGetDrawingState to }
{ get the current drawing settings for the current port. It will return an opaque object for you   }
{ to pass into ThemeSetDrawingState later on. When you are finished with the state, call the       }
{ ThemeDisposeDrawingState routine. You can alternatively pass true into the inDisposeNow          }
{ parameter of the ThemeSetDrawingState routine.  You can use this routine to copy the drawing     }
{ state from one port to another as well.                                                          }
{                                                                                                  }
{ As of this writing (Mac OS 9.1 and Mac OS X), Get/SetThemeDrawingState will save and restore     }
{ this data in the port:                                                                           }
{                                                                                                  }
{      pen size                                                                                    }
{      pen location                                                                                }
{      pen mode                                                                                    }
{      pen Pattern and PixPat                                                                      }
{      background Pattern and PixPat                                                               }
{      RGB foreground and background colors                                                        }
{      text mode                                                                                   }
{      pattern origin                                                                              }
{                                                                                                  }
{ Get/SetThemeDrawingState may save and restore additional port state in the future, but you can   }
{ rely on them to always save at least this port state.                                            }
{
 *  NormalizeThemeDrawingState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NormalizeThemeDrawingState: OSStatus;

{
 *  GetThemeDrawingState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeDrawingState(VAR outState: ThemeDrawingState): OSStatus;

{
 *  SetThemeDrawingState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetThemeDrawingState(inState: ThemeDrawingState; inDisposeNow: BOOLEAN): OSStatus;

{
 *  DisposeThemeDrawingState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION DisposeThemeDrawingState(inState: ThemeDrawingState): OSStatus;

{������������������������������������� MISCELLANEOUS ����������������������������������������������}
{ ApplyThemeBackground is used to set up the background for embedded controls  }
{ It is normally called by controls that are embedders. The standard controls  }
{ call this API to ensure a correct background for the current theme. You pass }
{ in the same rectangle you would if you were calling the drawing primitive.   }
{
 *  ApplyThemeBackground()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ApplyThemeBackground(inKind: ThemeBackgroundKind; {CONST}VAR bounds: Rect; inState: ThemeDrawState; inDepth: SInt16; inColorDev: BOOLEAN): OSStatus;

{
 *  SetThemeTextColorForWindow()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetThemeTextColorForWindow(window: WindowRef; isActive: BOOLEAN; depth: SInt16; isColorDev: BOOLEAN): OSStatus;

{
 *  IsValidAppearanceFileType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION IsValidAppearanceFileType(fileType: OSType): BOOLEAN;

{
 *  GetThemeBrushAsColor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeBrushAsColor(inBrush: ThemeBrush; inDepth: SInt16; inColorDev: BOOLEAN; VAR outColor: RGBColor): OSStatus;

{
 *  GetThemeTextColor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppearanceLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeTextColor(inColor: ThemeTextColor; inDepth: SInt16; inColorDev: BOOLEAN; VAR outColor: RGBColor): OSStatus;

{��������������������������������������� BEGIN CARBON ���������������������������������������������}
{
 *  GetThemeMetric()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetThemeMetric(inMetric: ThemeMetric; VAR outMetric: SInt32): OSStatus;

{
 *  GetTextAndEncodingFromCFString()
 *  
 *  Summary:
 *    Converts the contents of a CFString to the one- or two-byte
 *    encoding that most accurately represents the original Unicode
 *    characters in the string.
 *  
 *  Discussion:
 *    Because the Macintosh toolbox has had, until Carbon, little
 *    support for Unicode, you may often find that your applications
 *    need to translate a CFString (containing Unicode characters) back
 *    to a one- or two-byte encoding of the string in order to draw,
 *    measure, or otherwise use the text in the string.
 *    GetTextAndEncodingFromCFString is a utility that may be helpful
 *    to do this, in some circumstances. The Carbon toolbox uses this
 *    API itself when translating CFStrings to Pascal strings.
 *    GetTextAndEncodingFromCFString attempts to convert the Unicode
 *    characters in the string to the closest non-Unicode
 *    representation of the string. For example, a string containing
 *    only Unicode characters that are present in the MacRoman one-byte
 *    encoding will be translated to MacRoman, and
 *    kTextEncodingMacRoman will be returned as the encoding of the
 *    text. A string containing Unicode characters that are present in
 *    the MacJapanese two-byte encoding will be translated to
 *    MacJapanese (Shift-JIS), and kTextEncodingMacJapanese will be
 *    returned as the encoding of the text.
 *    GetTextAndEncodingFromCFString is designed to be used for simple
 *    strings which contain only text from a single language. It is not
 *    designed to translate strings with multiple runs of text from
 *    different languages, and will only return the first run of such a
 *    string; for example, if you pass it a string containing a run of
 *    Roman characters followed by a run of Japanese characters, it
 *    will only return the Roman characters in the output buffer. For
 *    more complex text translation, you should call the Unicode
 *    converter directly (see ConvertFromUnicodeToTextRun, which
 *    GetTextAndEncodingFromCFString uses internally).
 *  
 *  Parameters:
 *    
 *    inString:
 *      The string to convert.
 *    
 *    outText:
 *      The output buffer in which to place the converted text.
 *    
 *    inTextMaxLength:
 *      The length in bytes of the input buffer.
 *    
 *    outTextLength:
 *      On exit, contains the length in bytes of the text that was
 *      placed into the output buffer.
 *    
 *    outEncoding:
 *      On exit, contains the encoding of the text that was placed into
 *      the output buffer.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.2.5 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetTextAndEncodingFromCFString(inString: CFStringRef; outText: BytePtr; inTextMaxLength: ByteCount; VAR outTextLength: ByteCount; VAR outEncoding: TextEncoding): OSStatus;


{��������������������������������������������������������������������������������������������������}
{ Obsolete symbolic names                                                                          }
{��������������������������������������������������������������������������������������������������}
{ Obsolete error codes - use the new ones, s'il vous plait / kudasai }

CONST
	appearanceBadBrushIndexErr	= -30560;						{  pattern index invalid  }
	appearanceProcessRegisteredErr = -30561;
	appearanceProcessNotRegisteredErr = -30562;
	appearanceBadTextColorIndexErr = -30563;
	appearanceThemeHasNoAccents	= -30564;
	appearanceBadCursorIndexErr	= -30565;

	kThemeActiveDialogBackgroundBrush = 1;
	kThemeInactiveDialogBackgroundBrush = 2;
	kThemeActiveAlertBackgroundBrush = 3;
	kThemeInactiveAlertBackgroundBrush = 4;
	kThemeActiveModelessDialogBackgroundBrush = 5;
	kThemeInactiveModelessDialogBackgroundBrush = 6;
	kThemeActiveUtilityWindowBackgroundBrush = 7;
	kThemeInactiveUtilityWindowBackgroundBrush = 8;
	kThemeListViewSortColumnBackgroundBrush = 9;
	kThemeListViewBackgroundBrush = 10;
	kThemeIconLabelBackgroundBrush = 11;
	kThemeListViewSeparatorBrush = 12;
	kThemeChasingArrowsBrush	= 13;
	kThemeDragHiliteBrush		= 14;
	kThemeDocumentWindowBackgroundBrush = 15;
	kThemeFinderWindowBackgroundBrush = 16;

	kThemeActiveScrollBarDelimiterBrush = 17;
	kThemeInactiveScrollBarDelimiterBrush = 18;
	kThemeFocusHighlightBrush	= 19;
	kThemeActivePopupArrowBrush	= 20;
	kThemePressedPopupArrowBrush = 21;
	kThemeInactivePopupArrowBrush = 22;
	kThemeAppleGuideCoachmarkBrush = 23;

	kThemeActiveDialogTextColor	= 1;
	kThemeInactiveDialogTextColor = 2;
	kThemeActiveAlertTextColor	= 3;
	kThemeInactiveAlertTextColor = 4;
	kThemeActiveModelessDialogTextColor = 5;
	kThemeInactiveModelessDialogTextColor = 6;
	kThemeActiveWindowHeaderTextColor = 7;
	kThemeInactiveWindowHeaderTextColor = 8;
	kThemeActivePlacardTextColor = 9;
	kThemeInactivePlacardTextColor = 10;
	kThemePressedPlacardTextColor = 11;
	kThemeActivePushButtonTextColor = 12;
	kThemeInactivePushButtonTextColor = 13;
	kThemePressedPushButtonTextColor = 14;
	kThemeActiveBevelButtonTextColor = 15;
	kThemeInactiveBevelButtonTextColor = 16;
	kThemePressedBevelButtonTextColor = 17;
	kThemeActivePopupButtonTextColor = 18;
	kThemeInactivePopupButtonTextColor = 19;
	kThemePressedPopupButtonTextColor = 20;
	kThemeIconLabelTextColor	= 21;
	kThemeListViewTextColor		= 22;

	kThemeActiveDocumentWindowTitleTextColor = 23;
	kThemeInactiveDocumentWindowTitleTextColor = 24;
	kThemeActiveMovableModalWindowTitleTextColor = 25;
	kThemeInactiveMovableModalWindowTitleTextColor = 26;
	kThemeActiveUtilityWindowTitleTextColor = 27;
	kThemeInactiveUtilityWindowTitleTextColor = 28;
	kThemeActivePopupWindowTitleColor = 29;
	kThemeInactivePopupWindowTitleColor = 30;
	kThemeActiveRootMenuTextColor = 31;
	kThemeSelectedRootMenuTextColor = 32;
	kThemeDisabledRootMenuTextColor = 33;
	kThemeActiveMenuItemTextColor = 34;
	kThemeSelectedMenuItemTextColor = 35;
	kThemeDisabledMenuItemTextColor = 36;
	kThemeActivePopupLabelTextColor = 37;
	kThemeInactivePopupLabelTextColor = 38;

	kAEThemeSwitch				= 'thme';						{  Event ID's: Theme Switched  }

	kThemeNoAdornment			= 0;
	kThemeDefaultAdornment		= $01;
	kThemeFocusAdornment		= $04;
	kThemeRightToLeftAdornment	= $10;
	kThemeDrawIndicatorOnly		= $20;

	kThemeBrushPassiveAreaFill	= 25;

	kThemeMetricCheckBoxGlyphHeight = 2;
	kThemeMetricRadioButtonGlyphHeight = 3;
	kThemeMetricDisclosureButtonSize = 17;
	kThemeMetricBestListHeaderHeight = 20;
	kThemeMetricSmallProgressBarThickness = 58;					{  obsolete  }
	kThemeMetricProgressBarThickness = 32;						{  obsolete  }

	kThemeScrollBar				= 0;
	kThemeSlider				= 2;
	kThemeProgressBar			= 3;
	kThemeIndeterminateBar		= 4;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AppearanceIncludes}

{$ENDC} {__APPEARANCE__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AppleDiskPartitions.p
 
     Contains:   The Apple disk partition scheme as defined in Inside Macintosh: Volume V.
 
     Version:    Technology: Mac OS 9
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 2000-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AppleDiskPartitions;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __APPLEDISKPARTITIONS__}
{$SETC __APPLEDISKPARTITIONS__ := 1}

{$I+}
{$SETC AppleDiskPartitionsIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{ Block 0 Definitions }

CONST
	sbSIGWord					= $4552;						{  signature word for Block 0 ('ER')  }
	sbMac						= 1;							{  system type for Mac  }

	{	 Partition Map Signatures 	}
	pMapSIG						= $504D;						{  partition map signature ('PM')  }
	pdSigWord					= $5453;						{  partition map signature ('TS')  }
	oldPMSigWord				= $5453;
	newPMSigWord				= $504D;


	{	 Driver Descriptor Map 	}

TYPE
	Block0Ptr = ^Block0;
	Block0 = PACKED RECORD
		sbSig:					UInt16;									{  unique value for SCSI block 0  }
		sbBlkSize:				UInt16;									{  block size of device  }
		sbBlkCount:				UInt32;									{  number of blocks on device  }
		sbDevType:				UInt16;									{  device type  }
		sbDevId:				UInt16;									{  device id  }
		sbData:					UInt32;									{  not used  }
		sbDrvrCount:			UInt16;									{  driver descriptor count  }
		ddBlock:				UInt32;									{  1st driver's starting block  }
		ddSize:					UInt16;									{  size of 1st driver (512-byte blks)  }
		ddType:					UInt16;									{  system type (1 for Mac+)  }
		ddPad:					ARRAY [0..242] OF UInt16;				{  ARRAY[0..242] OF INTEGER; not used  }
	END;

	{	 Driver descriptor 	}
	DDMapPtr = ^DDMap;
	DDMap = RECORD
		ddBlock:				UInt32;									{  1st driver's starting block  }
		ddSize:					UInt16;									{  size of 1st driver (512-byte blks)  }
		ddType:					UInt16;									{  system type (1 for Mac+)  }
	END;

	{	 Constants for the ddType field of the DDMap structure. 	}

CONST
	kDriverTypeMacSCSI			= $0001;
	kDriverTypeMacATA			= $0701;
	kDriverTypeMacSCSIChained	= $FFFF;
	kDriverTypeMacATAChained	= $F8FF;

	{	 Partition Map Entry 	}

TYPE
	PartitionPtr = ^Partition;
	Partition = PACKED RECORD
		pmSig:					UInt16;									{  unique value for map entry blk  }
		pmSigPad:				UInt16;									{  currently unused  }
		pmMapBlkCnt:			UInt32;									{  # of blks in partition map  }
		pmPyPartStart:			UInt32;									{  physical start blk of partition  }
		pmPartBlkCnt:			UInt32;									{  # of blks in this partition  }
		pmPartName:				PACKED ARRAY [0..31] OF UInt8;			{  ASCII partition name  }
		pmParType:				PACKED ARRAY [0..31] OF UInt8;			{  ASCII partition type  }
		pmLgDataStart:			UInt32;									{  log. # of partition's 1st data blk  }
		pmDataCnt:				UInt32;									{  # of blks in partition's data area  }
		pmPartStatus:			UInt32;									{  bit field for partition status  }
		pmLgBootStart:			UInt32;									{  log. blk of partition's boot code  }
		pmBootSize:				UInt32;									{  number of bytes in boot code  }
		pmBootAddr:				UInt32;									{  memory load address of boot code  }
		pmBootAddr2:			UInt32;									{  currently unused  }
		pmBootEntry:			UInt32;									{  entry point of boot code  }
		pmBootEntry2:			UInt32;									{  currently unused  }
		pmBootCksum:			UInt32;									{  checksum of boot code  }
		pmProcessor:			PACKED ARRAY [0..15] OF UInt8;			{  ASCII for the processor type  }
		pmPad:					ARRAY [0..187] OF UInt16;				{  ARRAY[0..187] OF INTEGER; not used  }
	END;


	{	 Flags for the pmPartStatus field of the Partition data structure. 	}

CONST
	kPartitionAUXIsValid		= $00000001;
	kPartitionAUXIsAllocated	= $00000002;
	kPartitionAUXIsInUse		= $00000004;
	kPartitionAUXIsBootValid	= $00000008;
	kPartitionAUXIsReadable		= $00000010;
	kPartitionAUXIsWriteable	= $00000020;
	kPartitionAUXIsBootCodePositionIndependent = $00000040;
	kPartitionIsWriteable		= $00000020;
	kPartitionIsMountedAtStartup = $40000000;
	kPartitionIsStartup			= $80000000;
	kPartitionIsChainCompatible	= $00000100;
	kPartitionIsRealDeviceDriver = $00000200;
	kPartitionCanChainToNext	= $00000400;




	{	 Well known driver signatures, stored in the first four byte of pmPad. 	}
	kPatchDriverSignature		= 'ptDR';						{  SCSI and ATA[PI] patch driver     }
	kSCSIDriverSignature		= $00010600;					{  SCSI  hard disk driver            }
	kATADriverSignature			= 'wiki';						{  ATA   hard disk driver            }
	kSCSICDDriverSignature		= 'CDvr';						{  SCSI  CD-ROM    driver            }
	kATAPIDriverSignature		= 'ATPI';						{  ATAPI CD-ROM    driver            }
	kDriveSetupHFSSignature		= 'DSU1';						{  Drive Setup HFS partition         }



{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AppleDiskPartitionsIncludes}

{$ENDC} {__APPLEDISKPARTITIONS__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AppleEvents.p
 
     Contains:   AppleEvent Package Interfaces.
 
     Version:    Technology: System 7.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1989-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AppleEvents;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __APPLEEVENTS__}
{$SETC __APPLEEVENTS__ := 1}

{$I+}
{$SETC AppleEventsIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __MIXEDMODE__}
{$I MixedMode.p}
{$ENDC}
{
    Note:   The functions and types for the building and parsing AppleEvent  
            messages has moved to AEDataModel.h
}
{$IFC UNDEFINED __AEDATAMODEL__}
{$I AEDataModel.p}
{$ENDC}

{
    Note:   The functions for interacting with events has moved to AEInteraction.h
}
{$IFC UNDEFINED __AEINTERACTION__}
{$I AEInteraction.p}
{$ENDC}

{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


CONST
																{  Keywords for Apple event parameters  }
	keyDirectObject				= '----';
	keyErrorNumber				= 'errn';
	keyErrorString				= 'errs';
	keyProcessSerialNumber		= 'psn ';						{  Keywords for special handlers  }
	keyPreDispatch				= 'phac';						{  preHandler accessor call  }
	keySelectProc				= 'selh';						{  more selector call  }
																{  Keyword for recording  }
	keyAERecorderCount			= 'recr';						{  available only in vers 1.0.1 and greater  }
																{  Keyword for version information  }
	keyAEVersion				= 'vers';						{  available only in vers 1.0.1 and greater  }

	{	 Event Class 	}
	kCoreEventClass				= 'aevt';

	{	 Event ID�s 	}
	kAEOpenApplication			= 'oapp';
	kAEOpenDocuments			= 'odoc';
	kAEPrintDocuments			= 'pdoc';
	kAEQuitApplication			= 'quit';
	kAEAnswer					= 'ansr';
	kAEApplicationDied			= 'obit';
	kAEShowPreferences			= 'pref';						{  sent by Mac OS X when the user chooses the Preferences item  }

	{	 Constants for recording 	}
	kAEStartRecording			= 'reca';						{  available only in vers 1.0.1 and greater  }
	kAEStopRecording			= 'recc';						{  available only in vers 1.0.1 and greater  }
	kAENotifyStartRecording		= 'rec1';						{  available only in vers 1.0.1 and greater  }
	kAENotifyStopRecording		= 'rec0';						{  available only in vers 1.0.1 and greater  }
	kAENotifyRecording			= 'recr';						{  available only in vers 1.0.1 and greater  }





	{	
	 * AEEventSource is defined as an SInt8 for compatability with pascal.
	 * Important note: keyEventSourceAttr is returned by AttributePtr as a typeShortInteger.
	 * Be sure to pass at least two bytes of storage to AEGetAttributePtr - the result can be
	 * compared directly against the following enums.
	 	}

TYPE
	AEEventSource 				= SInt8;
CONST
	kAEUnknownSource			= 0;
	kAEDirectCall				= 1;
	kAESameProcess				= 2;
	kAELocalProcess				= 3;
	kAERemoteProcess			= 4;

	{	*************************************************************************
	  These calls are used to set up and modify the event dispatch table.
	*************************************************************************	}
	{
	 *  AEInstallEventHandler()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION AEInstallEventHandler(theAEEventClass: AEEventClass; theAEEventID: AEEventID; handler: AEEventHandlerUPP; handlerRefcon: LONGINT; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $091F, $A816;
	{$ENDC}

{
 *  AERemoveEventHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AERemoveEventHandler(theAEEventClass: AEEventClass; theAEEventID: AEEventID; handler: AEEventHandlerUPP; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0720, $A816;
	{$ENDC}

{
 *  AEGetEventHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetEventHandler(theAEEventClass: AEEventClass; theAEEventID: AEEventID; VAR handler: AEEventHandlerUPP; VAR handlerRefcon: LONGINT; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0921, $A816;
	{$ENDC}



{*************************************************************************
  These calls are used to set up and modify special hooks into the
  AppleEvent manager.
*************************************************************************}
{
 *  AEInstallSpecialHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEInstallSpecialHandler(functionClass: AEKeyword; handler: AEEventHandlerUPP; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0500, $A816;
	{$ENDC}

{
 *  AERemoveSpecialHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AERemoveSpecialHandler(functionClass: AEKeyword; handler: AEEventHandlerUPP; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0501, $A816;
	{$ENDC}

{
 *  AEGetSpecialHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEGetSpecialHandler(functionClass: AEKeyword; VAR handler: AEEventHandlerUPP; isSysHandler: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $052D, $A816;
	{$ENDC}


{*************************************************************************
  This call was added in version 1.0.1. If called with the keyword
  keyAERecorderCount ('recr'), the number of recorders that are
  currently active is returned in 'result'
  (available only in vers 1.0.1 and greater).
*************************************************************************}
{
 *  AEManagerInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AEManagerInfo(keyWord: AEKeyword; VAR result: LONGINT): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0441, $A816;
	{$ENDC}





{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AppleEventsIncludes}

{$ENDC} {__APPLEEVENTS__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AppleGuide.p
 
     Contains:   Apple Guide Interfaces.
 
     Version:    Technology: Mac OS 8
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1994-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AppleGuide;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __APPLEGUIDE__}
{$SETC __APPLEGUIDE__ := 1}

{$I+}
{$SETC AppleGuideIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __APPLEEVENTS__}
{$I AppleEvents.p}
{$ENDC}
{$IFC UNDEFINED __FILES__}
{$I Files.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{  Types }

TYPE
	AGRefNum							= UInt32;
	AGCoachRefNum						= UInt32;
	AGContextRefNum						= UInt32;
	AGAppInfoPtr = ^AGAppInfo;
	AGAppInfo = RECORD
		eventId:				AEEventID;
		refCon:					LONGINT;
		contextObj:				Ptr;									{  private system field }
	END;

	AGAppInfoHdl						= ^AGAppInfoPtr;
{$IFC TYPED_FUNCTION_POINTERS}
	CoachReplyProcPtr = FUNCTION(VAR pRect: Rect; name: Ptr; refCon: LONGINT): OSErr;
{$ELSEC}
	CoachReplyProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ContextReplyProcPtr = FUNCTION(pInputData: Ptr; inputDataSize: Size; VAR ppOutputData: Ptr; VAR pOutputDataSize: Size; hAppInfo: AGAppInfoHdl): OSErr;
{$ELSEC}
	ContextReplyProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	CoachReplyUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	CoachReplyUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ContextReplyUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ContextReplyUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppCoachReplyProcInfo = $00000FE0;
	uppContextReplyProcInfo = $0000FFE0;
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  NewCoachReplyUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION NewCoachReplyUPP(userRoutine: CoachReplyProcPtr): CoachReplyUPP; { old name was NewCoachReplyProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewContextReplyUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NewContextReplyUPP(userRoutine: ContextReplyProcPtr): ContextReplyUPP; { old name was NewContextReplyProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeCoachReplyUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeCoachReplyUPP(userUPP: CoachReplyUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeContextReplyUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeContextReplyUPP(userUPP: ContextReplyUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeCoachReplyUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION InvokeCoachReplyUPP(VAR pRect: Rect; name: Ptr; refCon: LONGINT; userRoutine: CoachReplyUPP): OSErr; { old name was CallCoachReplyProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeContextReplyUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION InvokeContextReplyUPP(pInputData: Ptr; inputDataSize: Size; VAR ppOutputData: Ptr; VAR pOutputDataSize: Size; hAppInfo: AGAppInfoHdl; userRoutine: ContextReplyUPP): OSErr; { old name was CallContextReplyProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}

{  Constants }



CONST
	kAGDefault					= 0;
	kAGFrontDatabase			= 1;
	kAGNoMixin					= -1;


	kAGViewFullHowdy			= 1;							{  Full-size Howdy }
	kAGViewTopicAreas			= 2;							{  Full-size Topic Areas }
	kAGViewIndex				= 3;							{  Full-size Index Terms }
	kAGViewLookFor				= 4;							{  Full-size Look-For (Search) }
	kAGViewSingleHowdy			= 5;							{  Single-list-size Howdy }
	kAGViewSingleTopics			= 6;							{  Single-list-size Topics }


	kAGFileMain					= 'poco';
	kAGFileMixin				= 'mixn';

	{  To test against AGGetAvailableDBTypes }
	kAGDBTypeBitAny				= $00000001;
	kAGDBTypeBitHelp			= $00000002;
	kAGDBTypeBitTutorial		= $00000004;
	kAGDBTypeBitShortcuts		= $00000008;
	kAGDBTypeBitAbout			= $00000010;
	kAGDBTypeBitOther			= $00000080;



TYPE
	AGStatus							= UInt16;
	{  Returned by AGGetStatus }

CONST
	kAGIsNotRunning				= 0;
	kAGIsSleeping				= 1;
	kAGIsActive					= 2;

	{  Flags used in AGOpen, AGOpenWithSearch, AGOpenWithView }
	kHelpViewerSearchAll		= $01;


TYPE
	AGWindowKind						= UInt16;
	{  Returned by AGGetFrontWindowKind }

CONST
	kAGNoWindow					= 0;
	kAGAccessWindow				= 1;
	kAGPresentationWindow		= 2;

	{  Error Codes }

	{  Not an enum, because other OSErrs are valid. }

TYPE
	AGErr								= SInt16;
	{  Apple Guide error codes }

CONST
																{  -------------------- Apple event reply codes }
	kAGErrUnknownEvent			= -2900;
	kAGErrCantStartup			= -2901;
	kAGErrNoAccWin				= -2902;
	kAGErrNoPreWin				= -2903;
	kAGErrNoSequence			= -2904;
	kAGErrNotOopsSequence		= -2905;
	kAGErrReserved06			= -2906;
	kAGErrNoPanel				= -2907;
	kAGErrContentNotFound		= -2908;
	kAGErrMissingString			= -2909;
	kAGErrInfoNotAvail			= -2910;
	kAGErrEventNotAvailable		= -2911;
	kAGErrCannotMakeCoach		= -2912;
	kAGErrSessionIDsNotMatch	= -2913;
	kAGErrMissingDatabaseSpec	= -2914;
	kAGMissingSequenceMap		= -2915;						{  -------------------- Coach's Chalkboard reply codes }
	kAGErrItemNotFound			= -2925;
	kAGErrBalloonResourceNotFound = -2926;
	kAGErrChalkResourceNotFound	= -2927;
	kAGErrChdvResourceNotFound	= -2928;
	kAGErrAlreadyShowing		= -2929;
	kAGErrBalloonResourceSkip	= -2930;
	kAGErrItemNotVisible		= -2931;
	kAGErrReserved32			= -2932;
	kAGErrNotFrontProcess		= -2933;
	kAGErrMacroResourceNotFound	= -2934;						{  -------------------- API reply codes }
	kAGErrAppleGuideNotAvailable = -2951;
	kAGErrCannotInitCoach		= -2952;
	kAGErrCannotInitContext		= -2953;
	kAGErrCannotOpenAliasFile	= -2954;
	kAGErrNoAliasResource		= -2955;
	kAGErrDatabaseNotAvailable	= -2956;
	kAGErrDatabaseNotOpen		= -2957;
	kAGErrMissingAppInfoHdl		= -2958;
	kAGErrMissingContextObject	= -2959;
	kAGErrInvalidRefNum			= -2960;
	kAGErrDatabaseOpen			= -2961;
	kAGErrInsufficientMemory	= -2962;

	{  Events }

	{  Not an enum because we want to make assignments. }

TYPE
	AGEvent								= UInt32;
	{  Handy events for AGGeneral. }

CONST
																{  Panel actions (Require a presentation window). }
	kAGEventDoCoach				= 'doco';
	kAGEventDoHuh				= 'dhuh';
	kAGEventGoNext				= 'gonp';
	kAGEventGoPrev				= 'gopp';
	kAGEventHidePanel			= 'pahi';
	kAGEventReturnBack			= 'gobk';
	kAGEventShowPanel			= 'pash';
	kAGEventTogglePanel			= 'patg';

	{  Functions }

	{
	   AGClose
	   Close the database associated with the AGRefNum.
	}

{$IFC CALL_NOT_IN_CARBON }
	{
	 *  AGClose()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION AGClose(VAR refNum: AGRefNum): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7011, $AA6E;
	{$ENDC}

{
   AGGeneral
   Cause various events to happen.
}

{
 *  AGGeneral()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGGeneral(refNum: AGRefNum; theEvent: AGEvent): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $700D, $AA6E;
	{$ENDC}

{
   AGGetAvailableDBTypes
   Return the database types available for this application.
}

{
 *  AGGetAvailableDBTypes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGGetAvailableDBTypes: UInt32;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7008, $AA6E;
	{$ENDC}

{
   AGGetFrontWindowKind
   Return the kind of the front window.
}

{
 *  AGGetFrontWindowKind()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGGetFrontWindowKind(refNum: AGRefNum): AGWindowKind;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $700C, $AA6E;
	{$ENDC}

{
   AGGetFSSpec
   Return the FSSpec for the AGRefNum.
}

{
 *  AGGetFSSpec()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGGetFSSpec(refNum: AGRefNum; VAR fileSpec: FSSpec): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $700F, $AA6E;
	{$ENDC}

{
   AGGetStatus
   Return the status of Apple Guide.
}

{
 *  AGGetStatus()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGGetStatus: AGStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7009, $AA6E;
	{$ENDC}

{
   AGInstallCoachHandler
   Install a Coach object location query handler.
}

{
 *  AGInstallCoachHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGInstallCoachHandler(coachReplyProc: CoachReplyUPP; refCon: LONGINT; VAR resultRefNum: AGCoachRefNum): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7012, $AA6E;
	{$ENDC}

{
   AGInstallContextHandler
   Install a context check query handler.
}

{
 *  AGInstallContextHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGInstallContextHandler(contextReplyProc: ContextReplyUPP; eventID: AEEventID; refCon: LONGINT; VAR resultRefNum: AGContextRefNum): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7013, $AA6E;
	{$ENDC}

{
   AGIsDatabaseOpen
   Return true if the database associated with the AGRefNum is open.
}

{
 *  AGIsDatabaseOpen()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGIsDatabaseOpen(refNum: AGRefNum): BOOLEAN;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7006, $AA6E;
	{$ENDC}

{
   AGOpen
   Open a guide database.
}

{
 *  AGOpen()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGOpen(fileSpec: ConstFSSpecPtr; flags: UInt32; mixinControl: Handle; VAR resultRefNum: AGRefNum): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7001, $AA6E;
	{$ENDC}

{
   AGOpenWithSearch
   Open a guide database and preset a search string.
}

{
 *  AGOpenWithSearch()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGOpenWithSearch(fileSpec: ConstFSSpecPtr; flags: UInt32; mixinControl: Handle; searchString: Str255; VAR resultRefNum: AGRefNum): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7002, $AA6E;
	{$ENDC}

{
   AGOpenWithSequence
   Open a guide database and display a presentation window sequence.
}

{
 *  AGOpenWithSequence()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGOpenWithSequence(fileSpec: ConstFSSpecPtr; flags: UInt32; mixinControl: Handle; sequenceID: INTEGER; VAR resultRefNum: AGRefNum): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7004, $AA6E;
	{$ENDC}

{
   AGOpenWithView
   Open a guide database and override the default view.
}

{
 *  AGOpenWithView()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGOpenWithView(fileSpec: ConstFSSpecPtr; flags: UInt32; mixinControl: Handle; viewNum: INTEGER; VAR resultRefNum: AGRefNum): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7005, $AA6E;
	{$ENDC}

{
   AGQuit
   Make Apple Guide quit.
}

{
 *  AGQuit()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGQuit: AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7010, $AA6E;
	{$ENDC}

{
   AGRemoveCoachHandler
   Remove the Coach object location query handler.
}

{
 *  AGRemoveCoachHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGRemoveCoachHandler(VAR resultRefNum: AGCoachRefNum): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7014, $AA6E;
	{$ENDC}

{
   AGRemoveContextHandler
   Remove the context check query handler.
}

{
 *  AGRemoveContextHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGRemoveContextHandler(VAR resultRefNum: AGContextRefNum): AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7015, $AA6E;
	{$ENDC}

{
   AGStart
   Start up Apple Guide in the background.
}

{
 *  AGStart()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGStart: AGErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $700A, $AA6E;
	{$ENDC}



{  typedef's }

{$ENDC}  {CALL_NOT_IN_CARBON}


TYPE
	AGFileFSSpecType					= FSSpec;
	AGFileFSSpecTypePtr 				= ^AGFileFSSpecType;
	AGFileSelectorCountType				= INTEGER;
	AGFileSelectorIndexType				= INTEGER;
	AGFileSelectorType					= OSType;
	AGFileSelectorValueType				= LONGINT;
	AGFileDBType						= INTEGER;
	AGFileDBMenuNamePtr					= Str63;
	AGFileDBScriptType					= INTEGER;
	AGFileDBRegionType					= INTEGER;
	AGFileMajorRevType					= INTEGER;
	AGFileMinorRevType					= INTEGER;
	AGFileCountType						= INTEGER;
	{  Database types (for AGFileDBType parameter). }

CONST
	kAGFileDBTypeAny			= 0;
	kAGFileDBTypeHelp			= 1;
	kAGFileDBTypeTutorial		= 2;
	kAGFileDBTypeShortcuts		= 3;
	kAGFileDBTypeAbout			= 4;
	kAGFileDBTypeOther			= 8;



{$IFC CALL_NOT_IN_CARBON }
	{
	 *  AGFileGetDBMenuName()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION AGFileGetDBMenuName({CONST}VAR fileSpec: FSSpec; VAR menuItemNameString: Str63): OSErr;

{  Get the database type. }
{
 *  AGFileGetDBType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetDBType({CONST}VAR fileSpec: FSSpec; VAR databaseType: AGFileDBType): OSErr;

{
   Get the version of the software
   that created this database.
}
{
 *  AGFileGetDBVersion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetDBVersion({CONST}VAR fileSpec: FSSpec; VAR majorRev: AGFileMajorRevType; VAR minorRev: AGFileMinorRevType): OSErr;

{  Get the database script and region information. }
{
 *  AGFileGetDBCountry()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetDBCountry({CONST}VAR fileSpec: FSSpec; VAR script: AGFileDBScriptType; VAR region: AGFileDBRegionType): OSErr;

{  Return the number of selectors in database. }
{
 *  AGFileGetSelectorCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetSelectorCount({CONST}VAR fileSpec: FSSpec): AGFileSelectorCountType;

{
   Get the i-th database selector (1 to AGFileSelectorCountType)
   and its value.
}
{
 *  AGFileGetSelector()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetSelector({CONST}VAR fileSpec: FSSpec; selectorNumber: AGFileSelectorIndexType; VAR selector: AGFileSelectorType; VAR value: AGFileSelectorValueType): OSErr;

{  Return true if database is mixin. }
{
 *  AGFileIsMixin()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileIsMixin({CONST}VAR fileSpec: FSSpec): BOOLEAN;

{
   Return the number of database files
   of the specified databaseType and main/mixin.
   Any file creator is acceptible,
   but type must be kAGFileMain or kAGFileMixin.
}
{
 *  AGFileGetDBCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetDBCount(vRefNum: INTEGER; dirID: LONGINT; databaseType: AGFileDBType; wantMixin: BOOLEAN): AGFileCountType;

{
   Get the FSSpec for the dbIndex-th database
   of the specified databaseType and main/mixin.
   Any file creator is acceptible,
   but type must be kAGFileMain or kAGFileMixin.
}
{
 *  AGFileGetIndDB()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetIndDB(vRefNum: INTEGER; dirID: LONGINT; databaseType: AGFileDBType; wantMixin: BOOLEAN; dbIndex: INTEGER; VAR fileSpec: FSSpec): OSErr;

{
   This selector must match with the application
   creator in order for this file to appear in the 
   application's Help menu. Ignored for mixin files
   because they never appear in the Help menu anyway.
   If empty (zeros), will appear in the Help menu
   of any host application.
}
{
 *  AGFileGetHelpMenuAppCreator()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetHelpMenuAppCreator({CONST}VAR fileSpec: FSSpec; VAR helpMenuAppCreator: OSType): OSErr;

{
   This selector must match in the main and mixin
   files in order for the mixin to mix-in with the main.
   Empty (zeros) selectors are valid matches.
   A '****' selector will mix-in with any main.
}
{
 *  AGFileGetMixinMatchSelector()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetMixinMatchSelector({CONST}VAR fileSpec: FSSpec; VAR mixinMatchSelector: OSType): OSErr;

{
   This is the text of the balloon for the
   Help menu item for this database.
}
{
 *  AGFileGetHelpMenuBalloonText()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGFileGetHelpMenuBalloonText({CONST}VAR fileSpec: FSSpec; VAR helpMenuBalloonString: Str255): OSErr;


{
 *  AGGetSystemDB()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleGuideLib 2.2 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AGGetSystemDB(databaseType: AGFileDBType; wantMixin: BOOLEAN; VAR pFileSpec: FSSpec): OSErr;

{$ENDC}  {CALL_NOT_IN_CARBON}

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AppleGuideIncludes}

{$ENDC} {__APPLEGUIDE__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AppleHelp.p
 
     Contains:   Apple Help
 
     Version:    Technology: Mac OS X/CarbonLib 1.1
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 2000-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}

{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AppleHelp;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __APPLEHELP__}
{$SETC __APPLEHELP__ := 1}

{$I+}
{$SETC AppleHelpIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __FILES__}
{$I Files.p}
{$ENDC}
{$IFC UNDEFINED __CFSTRING__}
{$I CFString.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{ AppleHelp Error Codes }

CONST
	kAHInternalErr				= -10790;
	kAHInternetConfigPrefErr	= -10791;



TYPE
	AHTOCType 					= SInt16;
CONST
	kAHTOCTypeUser				= 0;
	kAHTOCTypeDeveloper			= 1;

	{
	 *  AHSearch()
	 *  
	 *  Discussion:
	 *    Delivers a request to perform the specified search to the Help
	 *    Viewer application.
	 *  
	 *  Parameters:
	 *    
	 *    bookname:
	 *      Optionally, the AppleTitle of the Help book to be searched. If
	 *      NULL, all installed Help books are searched.
	 *    
	 *    query:
	 *      The query to be made. This string can, if desired, have boolean
	 *      operators or be a natural language phrase.
	 *  
	 *  Result:
	 *    An operating system result code that indicates whether the
	 *    request was successfully sent to the Help Viewer application.
	 *    Possible values: noErr, paramErr, kAHInternalErr,
	 *    kAHInternetConfigPrefErr.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION AHSearch(bookname: CFStringRef; query: CFStringRef): OSStatus; C;

{
 *  AHGotoMainTOC()
 *  
 *  Discussion:
 *    Delivers a request to load the main table of contents of
 *    installed help books to the Help Viewer application.
 *  
 *  Parameters:
 *    
 *    toctype:
 *      The type of table of contents to be loaded: user or developer.
 *  
 *  Result:
 *    An operating system result code that indicates whether the
 *    request was successfully sent to the Help Viewer application.
 *    Possible values: noErr, paramErr, kAHInternalErr,
 *    kAHInternetConfigPrefErr.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AHGotoMainTOC(toctype: AHTOCType): OSStatus; C;

{
 *  AHGotoPage()
 *  
 *  Discussion:
 *    Delivers a request to load a specific text/html file to the Help
 *    Viewer application.
 *  
 *  Parameters:
 *    
 *    bookname:
 *      Optionally, the AppleTitle of an installed Help book. If NULL,
 *      the path parameter must be a full file: URL to the file to be
 *      opened.
 *    
 *    path:
 *      Optionally, one of two types of paths: 1) a URL-style path to a
 *      file that is relative to the main folder of the book supplied
 *      in the bookname parameter, or 2) if bookname is NULL, a full
 *      file: URL to the file to be opened. If this parameter is NULL,
 *      then bookname must not be NULL, and is used to open the Help
 *      Viewer to the main page of Help content for the specified book.
 *    
 *    anchor:
 *      Optionally, the name of anchor tag to scroll to in the newly
 *      opened file. Can be NULL.
 *  
 *  Result:
 *    An operating system result code that indicates whether the
 *    request was successfully sent to the Help Viewer application.
 *    Possible values: noErr, paramErr, kAHInternalErr,
 *    kAHInternetConfigPrefErr.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AHGotoPage(bookname: CFStringRef; path: CFStringRef; anchor: CFStringRef): OSStatus; C;

{
 *  AHLookupAnchor()
 *  
 *  Discussion:
 *    Delivers a request to perform an anchor lookup to the Help Viewer
 *    application. Note: anchor lookups will fail unless you have
 *    indexed your help content with anchor indexing turned on in the
 *    indexing tool's preferences panel.
 *  
 *  Parameters:
 *    
 *    bookname:
 *      Optionally, the AppleTitle of the Help book to searched. If
 *      NULL, the anchor lookup is performed using all installed Help
 *      books.
 *    
 *    anchor:
 *      The name of the anchor tag to look up.
 *  
 *  Result:
 *    An operating system result code that indicates whether the
 *    request was successfully sent to the Help Viewer application.
 *    Possible values: noErr, paramErr, kAHInternalErr,
 *    kAHInternetConfigPrefErr.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AHLookupAnchor(bookname: CFStringRef; anchor: CFStringRef): OSStatus; C;


{
 *  AHRegisterHelpBook()
 *  
 *  Discussion:
 *    Registers a book of Help content such that the book will appear
 *    in the current user's main table of contents (Help Center) in the
 *    Help Viewer application. To be used when help books reside
 *    outside of the known help folders (i.e. help books that are kept
 *    inside of application bundles).
 *  
 *  Parameters:
 *    
 *    appBundleRef:
 *      An FSRef pointer to the bundle within which one or more Help
 *      books is stored. This is likely an FSRef to your application's
 *      main bundle.
 *  
 *  Result:
 *    An operating system result code that indicates whether all help
 *    books contained within the specified bundle were registered.
 *    Possible values: noErr, paramErr, kAHInternalErr, dirNFErr.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AHRegisterHelpBook({CONST}VAR appBundleRef: FSRef): OSStatus; C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AppleHelpIncludes}

{$ENDC} {__APPLEHELP__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AppleScript.p
 
     Contains:   AppleScript Specific Interfaces.
 
     Version:    Technology: AppleScript 1.1
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1992-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AppleScript;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __APPLESCRIPT__}
{$SETC __APPLESCRIPT__ := 1}

{$I+}
{$SETC AppleScriptIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACERRORS__}
{$I MacErrors.p}
{$ENDC}
{$IFC UNDEFINED __APPLEEVENTS__}
{$I AppleEvents.p}
{$ENDC}
{$IFC UNDEFINED __OSA__}
{$I OSA.p}
{$ENDC}
{$IFC UNDEFINED __TEXTEDIT__}
{$I TextEdit.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{*************************************************************************
    Types and Constants
*************************************************************************}
{
    The specific type for the AppleScript instance of the
    Open Scripting Architecture type.
}

CONST
	typeAppleScript				= 'ascr';
	kAppleScriptSubtype			= 'ascr';
	typeASStorage				= 'ascr';

	{	*************************************************************************
	    Component Selectors
	*************************************************************************	}

	kASSelectInit				= $1001;
	kASSelectSetSourceStyles	= $1002;
	kASSelectGetSourceStyles	= $1003;
	kASSelectGetSourceStyleNames = $1004;


	{	*************************************************************************
	    OSAGetScriptInfo Selectors
	*************************************************************************	}
	kASHasOpenHandler			= 'hsod';

	{	
	        This selector is used to query a context as to whether it contains
	        a handler for the kAEOpenDocuments event. This allows "applets" to be 
	        distinguished from "droplets."  OSAGetScriptInfo returns false if
	        there is no kAEOpenDocuments handler, and returns the error value 
	        errOSAInvalidAccess if the input is not a context.
	    	}
	{	*************************************************************************
	    Initialization
	*************************************************************************	}
	{
	 *  ASInit()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION ASInit(scriptingComponent: ComponentInstance; modeFlags: LONGINT; minStackSize: LONGINT; preferredStackSize: LONGINT; maxStackSize: LONGINT; minHeapSize: LONGINT; preferredHeapSize: LONGINT; maxHeapSize: LONGINT): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $001C, $1001, $7000, $A82A;
	{$ENDC}

{
        ComponentCallNow(kASSelectInit, 28);
        This call can be used to explicitly initialize AppleScript.  If it is
        not called, the a scripting size resource is looked for and used. If
        there is no scripting size resource, then the constants listed below
        are used.  If at any stage (the init call, the size resource, the 
        defaults) any of these parameters are zero, then parameters from the
        next stage are used.  ModeFlags are not currently used.
        Errors:
        errOSASystemError       initialization failed
    }
{
    These values will be used if ASInit is not called explicitly, or if any
    of ASInit's parameters are zero:
}

CONST
	kASDefaultMinStackSize		= 4096;
	kASDefaultPreferredStackSize = 16384;
	kASDefaultMaxStackSize		= 16384;
	kASDefaultMinHeapSize		= 4096;
	kASDefaultPreferredHeapSize	= 16384;
	kASDefaultMaxHeapSize		= 33554432;

	{	*************************************************************************
	    Source Styles
	*************************************************************************	}
	{
	 *  ASSetSourceStyles()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION ASSetSourceStyles(scriptingComponent: ComponentInstance; sourceStyles: STHandle): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $1002, $7000, $A82A;
	{$ENDC}

{
        ComponentCallNow(kASSelectSetSourceStyles, 4);
        Errors:
        errOSASystemError       operation failed
    }
{
 *  ASGetSourceStyles()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ASGetSourceStyles(scriptingComponent: ComponentInstance; VAR resultingSourceStyles: STHandle): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $1003, $7000, $A82A;
	{$ENDC}

{
        ComponentCallNow(kASSelectGetSourceStyles, 4);
        Errors:
        errOSASystemError       operation failed
    }
{
 *  ASGetSourceStyleNames()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ASGetSourceStyleNames(scriptingComponent: ComponentInstance; modeFlags: LONGINT; VAR resultingSourceStyleNamesList: AEDescList): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $1004, $7000, $A82A;
	{$ENDC}

{
        ComponentCallNow(kASSelectGetSourceStyleNames, 8);
        This call returns an AEList of styled text descriptors the names of the
        source styles in the current dialect.  The order of the names corresponds
        to the order of the source style constants, below.  The style of each
        name is the same as the styles returned by ASGetSourceStyles.
        
        Errors:
        errOSASystemError       operation failed
    }
{
    Elements of STHandle correspond to following categories of tokens, and
    accessed through following index constants:
}

CONST
	kASSourceStyleUncompiledText = 0;
	kASSourceStyleNormalText	= 1;
	kASSourceStyleLanguageKeyword = 2;
	kASSourceStyleApplicationKeyword = 3;
	kASSourceStyleComment		= 4;
	kASSourceStyleLiteral		= 5;
	kASSourceStyleUserSymbol	= 6;
	kASSourceStyleObjectSpecifier = 7;
	kASNumberOfSourceStyles		= 8;


{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AppleScriptIncludes}

{$ENDC} {__APPLESCRIPT__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AppleTalk.p
 
     Contains:   AppleTalk Interfaces.
 
     Version:    Technology: System 8.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1985-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AppleTalk;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __APPLETALK__}
{$SETC __APPLETALK__ := 1}

{$I+}
{$SETC AppleTalkIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __OSUTILS__}
{$I OSUtils.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


CONST
																{  Driver unit numbers (ADSP is dynamic)  }
	mppUnitNum					= 9;							{  MPP unit number  }
	atpUnitNum					= 10;							{  ATP unit number  }
	xppUnitNum					= 40;							{  XPP unit number  }

																{  Driver refNums (ADSP is dynamic)  }
	mppRefNum					= -10;							{  MPP reference number  }
	atpRefNum					= -11;							{  ATP reference number  }
	xppRefNum					= -41;							{  XPP reference number  }

																{  .MPP csCodes  }
	lookupReply					= 242;							{  This command queued to ourself  }
	writeLAP					= 243;							{  Write out LAP packet  }
	detachPH					= 244;							{  Detach LAP protocol handler  }
	attachPH					= 245;							{  Attach LAP protocol handler  }
	writeDDP					= 246;							{  Write out DDP packet  }
	closeSkt					= 247;							{  Close DDP socket  }
	openSkt						= 248;							{  Open DDP socket  }
	loadNBP						= 249;							{  Load NBP command-executing code  }
	lastResident				= 249;							{  Last resident command  }
	confirmName					= 250;							{  Confirm name  }
	lookupName					= 251;							{  Look up name on internet  }
	removeName					= 252;							{  Remove name from Names Table  }
	registerName				= 253;							{  Register name in Names Table  }
	killNBP						= 254;							{  Kill outstanding NBP request  }
	unloadNBP					= 255;							{  Unload NBP command code  }
	setSelfSend					= 256;							{  MPP: Set to allow writes to self  }
	SetMyZone					= 257;							{  Set my zone name  }
	GetATalkInfo				= 258;							{  get AppleTalk information  }
	ATalkClosePrep				= 259;							{  AppleTalk close query  }

																{  .ATP csCodes  }
	nSendRequest				= 248;							{  NSendRequest code  }
	relRspCB					= 249;							{  Release RspCB  }
	closeATPSkt					= 250;							{  Close ATP socket  }
	addResponse					= 251;							{  Add response code | Require open skt  }
	sendResponse				= 252;							{  Send response code  }
	getRequest					= 253;							{  Get request code  }
	openATPSkt					= 254;							{  Open ATP socket  }
	sendRequest					= 255;							{  Send request code  }
	relTCB						= 256;							{  Release TCB  }
	killGetReq					= 257;							{  Kill GetRequest  }
	killSendReq					= 258;							{  Kill SendRequest  }
	killAllGetReq				= 259;							{  Kill all getRequests for a skt  }

																{  .XPP csCodes  }
	openSess					= 255;							{  Open session  }
	closeSess					= 254;							{  Close session  }
	userCommand					= 253;							{  User command  }
	userWrite					= 252;							{  User write  }
	getStatus					= 251;							{  Get status  }
	afpCall						= 250;							{  AFP command (buffer has command code)  }
	getParms					= 249;							{  Get parameters  }
	abortOS						= 248;							{  Abort open session request  }
	closeAll					= 247;							{  Close all open sessions  }
	xCall						= 246;							{  .XPP extended calls  }

																{  Transition Queue transition types  }
	ATTransOpen					= 0;							{ AppleTalk has opened }
	ATTransClose				= 2;							{ AppleTalk is about to close }
	ATTransClosePrep			= 3;							{ Is it OK to close AppleTalk ? }
	ATTransCancelClose			= 4;							{ Cancel the ClosePrep transition }

	afpByteRangeLock			= 1;							{ AFPCall command codes }
	afpVolClose					= 2;							{ AFPCall command codes }
	afpDirClose					= 3;							{ AFPCall command codes }
	afpForkClose				= 4;							{ AFPCall command codes }
	afpCopyFile					= 5;							{ AFPCall command codes }
	afpDirCreate				= 6;							{ AFPCall command codes }
	afpFileCreate				= 7;							{ AFPCall command codes }
	afpDelete					= 8;							{ AFPCall command codes }
	afpEnumerate				= 9;							{ AFPCall command codes }
	afpFlush					= 10;							{ AFPCall command codes }
	afpForkFlush				= 11;							{ AFPCall command codes }
	afpGetDirParms				= 12;							{ AFPCall command codes }
	afpGetFileParms				= 13;							{ AFPCall command codes }
	afpGetForkParms				= 14;							{ AFPCall command codes }
	afpGetSInfo					= 15;							{ AFPCall command codes }
	afpGetSParms				= 16;							{ AFPCall command codes }
	afpGetVolParms				= 17;							{ AFPCall command codes }
	afpLogin					= 18;							{ AFPCall command codes }
	afpContLogin				= 19;							{ AFPCall command codes }
	afpLogout					= 20;							{ AFPCall command codes }
	afpMapID					= 21;							{ AFPCall command codes }
	afpMapName					= 22;							{ AFPCall command codes }
	afpMove						= 23;							{ AFPCall command codes }
	afpOpenVol					= 24;							{ AFPCall command codes }
	afpOpenDir					= 25;							{ AFPCall command codes }
	afpOpenFork					= 26;							{ AFPCall command codes }
	afpRead						= 27;							{ AFPCall command codes }
	afpRename					= 28;							{ AFPCall command codes }
	afpSetDirParms				= 29;							{ AFPCall command codes }
	afpSetFileParms				= 30;							{ AFPCall command codes }
	afpSetForkParms				= 31;							{ AFPCall command codes }
	afpSetVolParms				= 32;							{ AFPCall command codes }
	afpWrite					= 33;							{ AFPCall command codes }
	afpGetFlDrParms				= 34;							{ AFPCall command codes }
	afpSetFlDrParms				= 35;							{ AFPCall command codes }
	afpDTOpen					= 48;							{ AFPCall command codes }
	afpDTClose					= 49;							{ AFPCall command codes }
	afpGetIcon					= 51;							{ AFPCall command codes }
	afpGtIcnInfo				= 52;							{ AFPCall command codes }
	afpAddAPPL					= 53;							{ AFPCall command codes }
	afpRmvAPPL					= 54;							{ AFPCall command codes }
	afpGetAPPL					= 55;							{ AFPCall command codes }
	afpAddCmt					= 56;							{ AFPCall command codes }
	afpRmvCmt					= 57;							{ AFPCall command codes }
	afpGetCmt					= 58;							{ AFPCall command codes }
	afpAddIcon					= 192;							{ Special code for ASP Write commands }

	xppLoadedBit				= 5;							{  XPP bit in PortBUse  }
	scbMemSize					= 192;							{  Size of memory for SCB  }
	xppFlagClr					= 0;							{  Cs for AFPCommandBlock  }

	xppFlagSet					= 128;							{  StartEndFlag & NewLineFlag fields.  }

	lapSize						= 20;
	ddpSize						= 26;
	nbpSize						= 26;
	atpSize						= 56;

	atpXOvalue					= 32;							{ ATP exactly-once bit  }
	atpEOMvalue					= 16;							{ ATP End-Of-Message bit  }
	atpSTSvalue					= 8;							{ ATP Send-Transmission-Status bit  }
	atpTIDValidvalue			= 2;							{ ATP trans. ID valid bit  }
	atpSendChkvalue				= 1;							{ ATP send checksum bit  }

	zipGetLocalZones			= 5;
	zipGetZoneList				= 6;
	zipGetMyZone				= 7;

	LAPMgrPtr					= $0B18;						{ Entry point for LAP Manager }

	LAPMgrCall					= 2;							{ Offset to LAP routines }
	LAddAEQ						= 23;							{ LAPAddATQ routine selector }
	LRmvAEQ						= 24;							{ LAPRmvATQ routine selector }

	tLAPRead					= 0;
	tLAPWrite					= 1;
	tDDPRead					= 2;
	tDDPWrite					= 3;
	tNBPLookup					= 4;
	tNBPConfirm					= 5;
	tNBPRegister				= 6;
	tATPSndRequest				= 7;
	tATPGetRequest				= 8;
	tATPSdRsp					= 9;
	tATPAddRsp					= 10;
	tATPRequest					= 11;
	tATPResponse				= 12;


TYPE
	ABCallType							= SInt8;

CONST
	lapProto					= 0;
	ddpProto					= 1;
	nbpProto					= 2;
	atpProto					= 3;


TYPE
	ABProtoType							= UInt8;
	ABByte								= Byte;
	LAPAdrBlockPtr = ^LAPAdrBlock;
	LAPAdrBlock = PACKED RECORD
		dstNodeID:				UInt8;
		srcNodeID:				UInt8;
		lapProtType:			ABByte;
		filler:					UInt8;									{     Filler for proper byte alignment }
	END;

	ATQEntryPtr = ^ATQEntry;
{$IFC TYPED_FUNCTION_POINTERS}
	ATalkTransitionEventProcPtr = FUNCTION(eventCode: LONGINT; qElem: ATQEntryPtr; eventParameter: UNIV Ptr): LONGINT; C;
{$ELSEC}
	ATalkTransitionEventProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	ATalkTransitionEventUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATalkTransitionEventUPP = UniversalProcPtr;
{$ENDC}	
	ATalkTransitionEvent				= ATalkTransitionEventUPP;
	ATQEntry = RECORD
		qLink:					ATQEntryPtr;							{ next queue entry }
		qType:					INTEGER;								{ queue type }
		CallAddr:				ATalkTransitionEventUPP;				{ your routine descriptor }
	END;

	{	 
	    Real definition of EntityName is 3 PACKED strings of any length (32 is just an example). No
	    offests for Asm since each String address must be calculated by adding length byte to last string ptr.
	    In Pascal, String(32) will be 34 bytes long since fields never start on an odd byte unless they are 
	    only a byte long. So this will generate correct looking interfaces for Pascal and C, but they will not
	    be the same, which is OK since they are not used. 
		}
	EntityNamePtr = ^EntityName;
	EntityName = RECORD
		objStr:					Str32Field;
		typeStr:				Str32Field;
		zoneStr:				Str32Field;
	END;

	EntityPtr							= ^EntityName;
	AddrBlockPtr = ^AddrBlock;
	AddrBlock = PACKED RECORD
		aNet:					UInt16;
		aNode:					UInt8;
		aSocket:				UInt8;
	END;

	RetransTypePtr = ^RetransType;
	RetransType = PACKED RECORD
		retransInterval:		UInt8;
		retransCount:			UInt8;
	END;

	BDSElementPtr = ^BDSElement;
	BDSElement = RECORD
		buffSize:				INTEGER;
		buffPtr:				Ptr;
		dataSize:				INTEGER;
		userBytes:				LONGINT;
	END;

	BDSType								= ARRAY [0..7] OF BDSElement;
	BDSPtr								= ^BDSElement;
    BitMapType = PACKED ARRAY [0..7] OF BOOLEAN;
	ATLAPRecPtr = ^ATLAPRec;
	ATLAPRec = RECORD
		abOpcode:				ABCallType;
		filler:					SInt8;									{     Filler for proper byte alignment }
		abResult:				INTEGER;
		abUserReference:		LONGINT;
		lapAddress:				LAPAdrBlock;
		lapReqCount:			INTEGER;
		lapActCount:			INTEGER;
		lapDataPtr:				Ptr;
	END;

	ATLAPRecHandle						= ^ATLAPRecPtr;
	ATDDPRecPtr = ^ATDDPRec;
	ATDDPRec = RECORD
		abOpcode:				ABCallType;
		filler:					SInt8;									{     Filler for proper byte alignment }
		abResult:				INTEGER;
		abUserReference:		LONGINT;
		ddpType:				INTEGER;
		ddpSocket:				INTEGER;
		ddpAddress:				AddrBlock;
		ddpReqCount:			INTEGER;
		ddpActCount:			INTEGER;
		ddpDataPtr:				Ptr;
		ddpNodeID:				INTEGER;
	END;

	ATDDPRecHandle						= ^ATDDPRecPtr;
	ATNBPRecPtr = ^ATNBPRec;
	ATNBPRec = RECORD
		abOpcode:				ABCallType;
		filler:					SInt8;									{     Filler for proper byte alignment }
		abResult:				INTEGER;
		abUserReference:		LONGINT;
		nbpEntityPtr:			EntityPtr;
		nbpBufPtr:				Ptr;
		nbpBufSize:				INTEGER;
		nbpDataField:			INTEGER;
		nbpAddress:				AddrBlock;
		nbpRetransmitInfo:		RetransType;
	END;

	ATNBPRecHandle						= ^ATNBPRecPtr;
	ATATPRecPtr = ^ATATPRec;
	ATATPRec = RECORD
		abOpcode:				ABCallType;
		filler1:				SInt8;									{     Filler for proper byte alignment }
		abResult:				INTEGER;
		abUserReference:		LONGINT;
		atpSocket:				INTEGER;
		atpAddress:				AddrBlock;
		atpReqCount:			INTEGER;
		atpDataPtr:				Ptr;
		atpRspBDSPtr:			BDSPtr;
		atpBitMap:				SInt8;
		filler2:				SInt8;									{     Filler for proper byte alignment }
		atpTransID:				INTEGER;
		atpActCount:			INTEGER;
		atpUserData:			LONGINT;
		atpXO:					BOOLEAN;
		atpEOM:					BOOLEAN;
		atpTimeOut:				INTEGER;
		atpRetries:				INTEGER;
		atpNumBufs:				INTEGER;
		atpNumRsp:				INTEGER;
		atpBDSSize:				INTEGER;
		atpRspUData:			LONGINT;
		atpRspBuf:				Ptr;
		atpRspSize:				INTEGER;
	END;

	ATATPRecHandle						= ^ATATPRecPtr;
	AFPCommandBlockPtr = ^AFPCommandBlock;
	AFPCommandBlock = PACKED RECORD
		cmdByte:				UInt8;
		startEndFlag:			UInt8;
		forkRefNum:				INTEGER;
		rwOffset:				LONGINT;
		reqCount:				LONGINT;
		newLineFlag:			UInt8;
		newLineChar:			CHAR;
	END;

	MPPParamBlockPtr = ^MPPParamBlock;
	ATPParamBlockPtr = ^ATPParamBlock;
	XPPParamBlockPtr = ^XPPParamBlock;
	MPPPBPtr							= ^MPPParamBlock;
	ATPPBPtr							= ^ATPParamBlock;
	XPPParmBlkPtr						= ^XPPParamBlock;
{$IFC TYPED_FUNCTION_POINTERS}
	MPPCompletionProcPtr = PROCEDURE(thePBptr: MPPPBPtr);
{$ELSEC}
	MPPCompletionProcPtr = Register68kProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATPCompletionProcPtr = PROCEDURE(thePBptr: ATPPBPtr);
{$ELSEC}
	ATPCompletionProcPtr = Register68kProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	XPPCompletionProcPtr = PROCEDURE(thePBptr: XPPParmBlkPtr);
{$ELSEC}
	XPPCompletionProcPtr = Register68kProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	AttnRoutineProcPtr = PROCEDURE(sessRefnum: INTEGER; attnBytes: INTEGER);
{$ELSEC}
	AttnRoutineProcPtr = Register68kProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	MPPCompletionUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	MPPCompletionUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ATPCompletionUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATPCompletionUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	XPPCompletionUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	XPPCompletionUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	AttnRoutineUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AttnRoutineUPP = UniversalProcPtr;
{$ENDC}	

	WDSElementPtr = ^WDSElement;
	WDSElement = RECORD
		entryLength:			INTEGER;
		entryPtr:				Ptr;
	END;

	NTElementPtr = ^NTElement;
	NTElement = RECORD
		nteAddress:				AddrBlock;								{ network address of entity }
		filler:					SInt8;
		entityData:				ARRAY [0..98] OF SInt8;					{ Object, Type & Zone }
	END;

	NamesTableEntryPtr = ^NamesTableEntry;
	NamesTableEntry = RECORD
		qNext:					Ptr;									{ ptr to next NTE }
		nt:						NTElement;
	END;

{$IFC TYPED_FUNCTION_POINTERS}
	MPPProtocolHandlerProcPtr = FUNCTION(SCCAddr1: Ptr; SCCAddr2: Ptr; MPPLocalVars: Ptr; nextFreeByteInRHA: Ptr; ReadPacketAndReadRestPtr: Ptr; numBytesLeftToReadInPacket: INTEGER): BOOLEAN;
{$ELSEC}
	MPPProtocolHandlerProcPtr = Register68kProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	DDPSocketListenerProcPtr = FUNCTION(SCCAddr1: Ptr; SCCAddr2: Ptr; MPPLocalVars: Ptr; nextFreeByteInRHA: Ptr; ReadPacketAndReadRestPtr: Ptr; packetDestinationNumber: ByteParameter; numBytesLeftToReadInPacket: INTEGER): BOOLEAN;
{$ELSEC}
	DDPSocketListenerProcPtr = Register68kProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	MPPProtocolHandlerUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	MPPProtocolHandlerUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	DDPSocketListenerUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	DDPSocketListenerUPP = UniversalProcPtr;
{$ENDC}	
	{	
	    MPPProtocolHandlerProcs and  DDPSocketListenerProcs cannot be written 
	    in or called from a high-level language without the help of mixed mode 
	    or assembly glue because they use the following parameter-passing conventions:
	
	    typedef Boolean (*MPPProtocolHandlerProcPtr)(Ptr SCCAddr1, Ptr SCCAddr2, 
	            Ptr MPPLocalVars, Ptr nextFreeByteInRHA, Ptr ReadPacketAndReadRestPtr, 
	            short numBytesLeftToReadInPacket);
	
	        In:
	            =>  SCCAddr1                    A0.L
	            =>  SCCAddr2                    A1.L
	            =>  MPPLocalVars                A2.L
	            =>  nextFreeByteInRHA           A3.L
	            =>  ReadPacketAndReadRestPtr    A4.L
	            =>  numBytesLeftToReadInPacket  D1.W
	        Out:
	            <=  Boolean                     Z bit of CCR
	
	    typedef Boolean (*DDPSocketListenerProcPtr)(Ptr SCCAddr1, Ptr SCCAddr2, 
	            Ptr MPPLocalVars, Ptr nextFreeByteInRHA, Ptr ReadPacketAndReadRestPtr, 
	            UInt8 packetDestinationNumber, short numBytesLeftToReadInPacket);
	
	        In:
	            =>  SCCAddr1                    A0.L
	            =>  SCCAddr2                    A1.L
	            =>  MPPLocalVars                A2.L
	            =>  nextFreeByteInRHA           A3.L
	            =>  ReadPacketAndReadRestPtr    A4.L
	            =>  packetDestinationNumber     D0.B
	            =>  numBytesLeftToReadInPacket  D1.W
	        Out:
	            <=  Boolean                     Z bit of CCR
	
		}
	MPPParamBlock = PACKED RECORD
		qLink:					QElemPtr;								{ next queue entry }
		qType:					INTEGER;								{ queue type }
		ioTrap:					INTEGER;								{ routine trap }
		ioCmdAddr:				Ptr;									{ routine address }
		ioCompletion:			ATPCompletionUPP;						{ ATPCompletionUPP or MPPCompletionUPP }
		ioResult:				OSErr;									{ result code }
		userData:				LONGINT;								{ Command result (ATP user bytes) }
		reqTID:					INTEGER;								{ request transaction ID }
		ioRefNum:				INTEGER;								{ driver reference number }
		csCode:					INTEGER;								{ Call command code }
		CASE INTEGER OF
		0: (
			filler0:			INTEGER;
			wdsPointer:			Ptr;
		   );
		1: (
			protType:			UInt8;
			filler:				SInt8;
			handler:			MPPProtocolHandlerUPP;
		   );
		2: (
			socket:				UInt8;
			checksumFlag:		UInt8;
			listener:			DDPSocketListenerUPP;
		   );
		3: (
			interval:			UInt8;									{ retry interval  }
			count:				UInt8;									{ retry count  }
			nbpPtrs:			Ptr;
			CASE INTEGER OF
			0: (
				verifyFlag:		UInt8;
				filler3:		UInt8;
			   );
			1: (
				retBuffPtr:		Ptr;
				retBuffSize:	INTEGER;
				maxToGet:		INTEGER;
				numGotten:		INTEGER;
			   );
			2: (
				confirmAddr:	AddrBlock;
				newSocket:		UInt8;
				filler4:		UInt8;
			   );
			   );
			4: (
				newSelfFlag:	UInt8;									{ self-send toggle flag  }
				oldSelfFlag:	UInt8;									{ previous self-send state  }
			   );
			5: (
				nKillQEl:		Ptr;									{ ptr to i/o queue element to cancel  }
			   );
			6: (
				version:		INTEGER;								{ requested info version }
				varsPtr:		Ptr;									{ pointer to well known MPP vars }
				DCEPtr:			Ptr;									{ pointer to MPP DCE }
				portID:			INTEGER;								{ port number [0..7] }
				configuration:	LONGINT;								{ 32-bit configuration word }
				selfSend:		INTEGER;								{ non zero if SelfSend enabled }
				netLo:			INTEGER;								{ low value of network range }
				netHi:			INTEGER;								{ high value of network range }
				ourAdd:			LONGINT;								{ our 24-bit AppleTalk address }
				routerAddr:		LONGINT;								{ 24-bit address of (last) router }
				numOfPHs:		INTEGER;								{ max. number of protocol handlers }
				numOfSkts:		INTEGER;								{ max. number of static sockets }
				numNBPEs:		INTEGER;								{ max. concurrent NBP requests }
				nTQueue:		Ptr;									{ pointer to registered name queue }
				LAlength:		INTEGER;								{ length in bytes of data link addr }
				linkAddr:		Ptr;									{ data link address returned }
				zoneName:		Ptr;									{ zone name returned }
			   );
			7: (
				appName:		Ptr;									{ pointer to application name in buffer }
			   );
	END;

	XPPParamBlock = PACKED RECORD
		qLink:					QElemPtr;
		qType:					INTEGER;
		ioTrap:					INTEGER;
		ioCmdAddr:				Ptr;
		ioCompletion:			XPPCompletionUPP;
		ioResult:				OSErr;
		cmdResult:				LONGINT;
		ioVRefNum:				INTEGER;
		ioRefNum:				INTEGER;
		csCode:					INTEGER;
		CASE INTEGER OF
		0: (
			abortSCBPtr:		Ptr;									{  SCB pointer for AbortOS }
		   );
		1: (
			aspMaxCmdSize:		INTEGER;								{ For SPGetParms }
			aspQuantumSize:		INTEGER;
			numSesss:			INTEGER;
		   );
		2: (
			sessRefnum:			INTEGER;								{ Offset to session refnum  }
			aspTimeout:			UInt8;									{ Timeout for ATP  }
			aspRetry:			UInt8;									{ Retry count for ATP  }
			CASE INTEGER OF
			0: (
				serverAddr:		AddrBlock;								{ Server address block  }
				scbPointer:		Ptr;									{ SCB pointer  }
				attnRoutine:	AttnRoutineUPP;							{ Attention routine pointer }
			   );
			1: (
				cbSize:			INTEGER;								{ Command block size  }
				cbPtr:			Ptr;									{ Command block pointer  }
				rbSize:			INTEGER;								{ Reply buffer size  }
				rbPtr:			Ptr;									{ Reply buffer pointer  }
				CASE INTEGER OF
				0: (
					afpAddrBlock: AddrBlock;							{ block in AFP login  }
					afpSCBPtr:	Ptr;									{ SCB pointer in AFP login  }
					afpAttnRoutine: AttnRoutineUPP;						{ routine pointer in AFP login  }
				   );
				1: (
					wdSize:		INTEGER;								{ Write Data size }
					wdPtr:		Ptr;									{ Write Data pointer }
					ccbStart:	PACKED ARRAY [0..295] OF UInt8;			{ CCB memory allocated for driver afpWrite max size(CCB)=296 all other calls=150 }
				   );
				   );
				   );
				3: (
					xppSubCode:	INTEGER;
					xppTimeout:	UInt8;									{ retry interval (seconds) }
					xppRetry:	UInt8;									{ retry count }
					filler1:	INTEGER;
					zipBuffPtr:	Ptr;									{ pointer to buffer (must be 578 bytes) }
					zipNumZones: INTEGER;								{ no. of zone names in this response }
					zipLastFlag: UInt8;									{ non-zero if no more zones }
					filler2:	UInt8;									{ filler }
					zipInfoField: PACKED ARRAY [1..70] OF UInt8;		{ on initial call, set first word to zero }
				   );
	END;


	ATPParamBlock = PACKED RECORD
		qLink:					QElemPtr;								{ next queue entry }
		qType:					INTEGER;								{ queue type }
		ioTrap:					INTEGER;								{ routine trap }
		ioCmdAddr:				Ptr;									{ routine address }
		ioCompletion:			ATPCompletionUPP;						{ ATPCompletionUPP or MPPCompletionUPP }
		ioResult:				OSErr;									{ result code }
		userData:				LONGINT;								{ Command result (ATP user bytes) }
		reqTID:					INTEGER;								{ request transaction ID }
		ioRefNum:				INTEGER;								{ driver reference number }
		csCode:					INTEGER;								{ Call command code }
		atpSocket:				UInt8;									{ currbitmap for requests or ATP socket number }
		atpFlags:				UInt8;									{ control information }
		addrBlock:				AddrBlock;								{ source/dest. socket address }
		reqLength:				INTEGER;								{ request/response length }
		reqPointer:				Ptr;									{ ->request/response Data }
		bdsPointer:				Ptr;									{ ->response BDS  }
		CASE INTEGER OF
		0: (
			numOfBuffs:			UInt8;									{ numOfBuffs  }
			timeOutVal:			UInt8;									{ timeout interval  }
			numOfResps:			UInt8;									{ number of responses actually received  }
			retryCount:			UInt8;									{ number of retries  }
			intBuff:			INTEGER;								{ used internally for NSendRequest  }
			TRelTime:			UInt8;									{ TRelease time for extended send request  }
			filler0:			SInt8;
		   );
		1: (
			filler:				UInt8;
			bdsSize:			UInt8;									{ number of BDS elements  }
			transID:			INTEGER;								{ transaction ID recd.  }
		   );
		2: (
			bitMap:				UInt8;
			filler2:			UInt8;
		   );
		3: (
			rspNum:				UInt8;
			filler3:			UInt8;
		   );
		4: (
			aKillQEl:			Ptr;									{ ptr to i/o queue element to cancel }
		   );
	END;


CONST
	uppATalkTransitionEventProcInfo = $00000FF1;
	uppMPPCompletionProcInfo = $00009802;
	uppATPCompletionProcInfo = $00009802;
	uppXPPCompletionProcInfo = $00009802;
	uppAttnRoutineProcInfo = $00061002;
	uppMPPProtocolHandlerProcInfo = $0000007F;
	uppDDPSocketListenerProcInfo = $0000008F;
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  NewATalkTransitionEventUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION NewATalkTransitionEventUPP(userRoutine: ATalkTransitionEventProcPtr): ATalkTransitionEventUPP; { old name was NewATalkTransitionEventProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewMPPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NewMPPCompletionUPP(userRoutine: MPPCompletionProcPtr): MPPCompletionUPP; { old name was NewMPPCompletionProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewATPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NewATPCompletionUPP(userRoutine: ATPCompletionProcPtr): ATPCompletionUPP; { old name was NewATPCompletionProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewXPPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NewXPPCompletionUPP(userRoutine: XPPCompletionProcPtr): XPPCompletionUPP; { old name was NewXPPCompletionProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewAttnRoutineUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NewAttnRoutineUPP(userRoutine: AttnRoutineProcPtr): AttnRoutineUPP; { old name was NewAttnRoutineProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewMPPProtocolHandlerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NewMPPProtocolHandlerUPP(userRoutine: MPPProtocolHandlerProcPtr): MPPProtocolHandlerUPP; { old name was NewMPPProtocolHandlerProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewDDPSocketListenerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NewDDPSocketListenerUPP(userRoutine: DDPSocketListenerProcPtr): DDPSocketListenerUPP; { old name was NewDDPSocketListenerProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeATalkTransitionEventUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeATalkTransitionEventUPP(userUPP: ATalkTransitionEventUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeMPPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeMPPCompletionUPP(userUPP: MPPCompletionUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeATPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeATPCompletionUPP(userUPP: ATPCompletionUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeXPPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeXPPCompletionUPP(userUPP: XPPCompletionUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeAttnRoutineUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeAttnRoutineUPP(userUPP: AttnRoutineUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeMPPProtocolHandlerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeMPPProtocolHandlerUPP(userUPP: MPPProtocolHandlerUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeDDPSocketListenerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeDDPSocketListenerUPP(userUPP: DDPSocketListenerUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeATalkTransitionEventUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION InvokeATalkTransitionEventUPP(eventCode: LONGINT; qElem: ATQEntryPtr; eventParameter: UNIV Ptr; userRoutine: ATalkTransitionEventUPP): LONGINT; { old name was CallATalkTransitionEventProc }
{
 *  InvokeMPPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE InvokeMPPCompletionUPP(thePBptr: MPPPBPtr; userRoutine: MPPCompletionUPP); { old name was CallMPPCompletionProc }
{
 *  InvokeATPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE InvokeATPCompletionUPP(thePBptr: ATPPBPtr; userRoutine: ATPCompletionUPP); { old name was CallATPCompletionProc }
{
 *  InvokeXPPCompletionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE InvokeXPPCompletionUPP(thePBptr: XPPParmBlkPtr; userRoutine: XPPCompletionUPP); { old name was CallXPPCompletionProc }
{
 *  InvokeAttnRoutineUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE InvokeAttnRoutineUPP(sessRefnum: INTEGER; attnBytes: INTEGER; userRoutine: AttnRoutineUPP); { old name was CallAttnRoutineProc }
{
 *  InvokeMPPProtocolHandlerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION InvokeMPPProtocolHandlerUPP(SCCAddr1: Ptr; SCCAddr2: Ptr; MPPLocalVars: Ptr; nextFreeByteInRHA: Ptr; ReadPacketAndReadRestPtr: Ptr; numBytesLeftToReadInPacket: INTEGER; userRoutine: MPPProtocolHandlerUPP): BOOLEAN; { old name was CallMPPProtocolHandlerProc }
{
 *  InvokeDDPSocketListenerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION InvokeDDPSocketListenerUPP(SCCAddr1: Ptr; SCCAddr2: Ptr; MPPLocalVars: Ptr; nextFreeByteInRHA: Ptr; ReadPacketAndReadRestPtr: Ptr; packetDestinationNumber: ByteParameter; numBytesLeftToReadInPacket: INTEGER; userRoutine: DDPSocketListenerUPP): BOOLEAN; { old name was CallDDPSocketListenerProc }
{$ENDC}  {CALL_NOT_IN_CARBON}

{$IFC CALL_NOT_IN_CARBON }
{
 *  OpenXPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION OpenXPP(VAR xppRefnum: INTEGER): OSErr;

{
 *  ASPOpenSession()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ASPOpenSession(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  ASPCloseSession()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ASPCloseSession(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  ASPAbortOS()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ASPAbortOS(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  ASPGetParms()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ASPGetParms(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  ASPCloseAll()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ASPCloseAll(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  ASPUserWrite()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ASPUserWrite(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  ASPUserCommand()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ASPUserCommand(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  ASPGetStatus()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ASPGetStatus(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  AFPCommand()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AFPCommand(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  GetLocalZones()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION GetLocalZones(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  GetZoneList()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION GetZoneList(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  GetMyZone()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION GetMyZone(thePBptr: XPPParmBlkPtr; async: BOOLEAN): OSErr;

{
 *  PAttachPH()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PAttachPH(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PDetachPH()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PDetachPH(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PWriteLAP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PWriteLAP(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  POpenSkt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION POpenSkt(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PCloseSkt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PCloseSkt(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PWriteDDP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PWriteDDP(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PRegisterName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PRegisterName(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PLookupName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PLookupName(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PConfirmName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PConfirmName(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PRemoveName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PRemoveName(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PSetSelfSend()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PSetSelfSend(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PKillNBP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PKillNBP(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PGetAppleTalkInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PGetAppleTalkInfo(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  PATalkClosePrep()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PATalkClosePrep(thePBptr: MPPPBPtr; async: BOOLEAN): OSErr;

{
 *  POpenATPSkt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION POpenATPSkt(thePBptr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PCloseATPSkt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PCloseATPSkt(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PSendRequest()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PSendRequest(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PGetRequest()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PGetRequest(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PSendResponse()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PSendResponse(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PAddResponse()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PAddResponse(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PRelTCB()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PRelTCB(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PRelRspCB()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PRelRspCB(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PNSendRequest()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PNSendRequest(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PKillSendReq()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PKillSendReq(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  PKillGetReq()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION PKillGetReq(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  ATPKillAllGetReq()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPKillAllGetReq(thePBPtr: ATPPBPtr; async: BOOLEAN): OSErr;

{
 *  BuildLAPwds()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE BuildLAPwds(wdsPtr: Ptr; dataPtr: Ptr; destHost: INTEGER; prototype: INTEGER; frameLen: INTEGER);

{
 *  BuildDDPwds()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE BuildDDPwds(wdsPtr: Ptr; headerPtr: Ptr; dataPtr: Ptr; netAddr: AddrBlock; ddpType: INTEGER; dataLen: INTEGER);

{
 *  NBPSetEntity()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE NBPSetEntity(buffer: Ptr; nbpObject: Str32; nbpType: Str32; nbpZone: Str32);

{
 *  NBPSetNTE()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE NBPSetNTE(ntePtr: Ptr; nbpObject: Str32; nbpType: Str32; nbpZone: Str32; socket: INTEGER);

{
 *  GetBridgeAddress()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION GetBridgeAddress: INTEGER;

{
 *  BuildBDS()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION BuildBDS(buffPtr: Ptr; bdsPtr: Ptr; buffSize: INTEGER): INTEGER;

{
 *  MPPOpen()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION MPPOpen: OSErr;

{
 *  LAPAddATQ()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION LAPAddATQ(theATQEntry: ATQEntryPtr): OSErr;

{
 *  LAPRmvATQ()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION LAPRmvATQ(theATQEntry: ATQEntryPtr): OSErr;

{
 *  ATPLoad()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPLoad: OSErr;

{
 *  ATPUnload()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPUnload: OSErr;

{
 *  NBPExtract()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NBPExtract(theBuffer: Ptr; numInBuf: INTEGER; whichOne: INTEGER; VAR abEntity: EntityName; VAR address: AddrBlock): OSErr;

{
 *  GetNodeAddress()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION GetNodeAddress(VAR myNode: INTEGER; VAR myNet: INTEGER): OSErr;

{
 *  IsMPPOpen()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION IsMPPOpen: BOOLEAN;

{
 *  IsATPOpen()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION IsATPOpen: BOOLEAN;

{
 *  ATEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE ATEvent(event: LONGINT; infoPtr: Ptr);

{
 *  ATPreFlightEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPreFlightEvent(event: LONGINT; cancel: LONGINT; infoPtr: Ptr): OSErr;

{
    The following routines are obsolete and will not be supported on
    PowerPC. Equivalent functionality is provided by the routines
    above.
}
{$ENDC}  {CALL_NOT_IN_CARBON}

{$IFC TARGET_CPU_68K }
{$IFC CALL_NOT_IN_CARBON }
{
 *  MPPClose()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION MPPClose: OSErr;

{
 *  LAPOpenProtocol()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION LAPOpenProtocol(theLAPType: ByteParameter; protoPtr: Ptr): OSErr;

{
 *  LAPCloseProtocol()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION LAPCloseProtocol(theLAPType: ByteParameter): OSErr;

{
 *  LAPWrite()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION LAPWrite(abRecord: ATLAPRecHandle; async: BOOLEAN): OSErr;

{
 *  LAPRead()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION LAPRead(abRecord: ATLAPRecHandle; async: BOOLEAN): OSErr;

{
 *  LAPRdCancel()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION LAPRdCancel(abRecord: ATLAPRecHandle): OSErr;

{
 *  DDPOpenSocket()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION DDPOpenSocket(VAR theSocket: INTEGER; sktListener: Ptr): OSErr;

{
 *  DDPCloseSocket()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION DDPCloseSocket(theSocket: INTEGER): OSErr;

{
 *  DDPRead()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION DDPRead(abRecord: ATDDPRecHandle; retCksumErrs: BOOLEAN; async: BOOLEAN): OSErr;

{
 *  DDPWrite()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION DDPWrite(abRecord: ATDDPRecHandle; doChecksum: BOOLEAN; async: BOOLEAN): OSErr;

{
 *  DDPRdCancel()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION DDPRdCancel(abRecord: ATDDPRecHandle): OSErr;

{
 *  ATPOpenSocket()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPOpenSocket(addrRcvd: AddrBlock; VAR atpSocket: INTEGER): OSErr;

{
 *  ATPCloseSocket()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPCloseSocket(atpSocket: INTEGER): OSErr;

{
 *  ATPSndRequest()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPSndRequest(abRecord: ATATPRecHandle; async: BOOLEAN): OSErr;

{
 *  ATPRequest()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPRequest(abRecord: ATATPRecHandle; async: BOOLEAN): OSErr;

{
 *  ATPReqCancel()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPReqCancel(abRecord: ATATPRecHandle; async: BOOLEAN): OSErr;

{
 *  ATPGetRequest()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPGetRequest(abRecord: ATATPRecHandle; async: BOOLEAN): OSErr;

{
 *  ATPSndRsp()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPSndRsp(abRecord: ATATPRecHandle; async: BOOLEAN): OSErr;

{
 *  ATPAddRsp()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPAddRsp(abRecord: ATATPRecHandle): OSErr;

{
 *  ATPResponse()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPResponse(abRecord: ATATPRecHandle; async: BOOLEAN): OSErr;

{
 *  ATPRspCancel()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATPRspCancel(abRecord: ATATPRecHandle; async: BOOLEAN): OSErr;

{
 *  NBPRegister()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NBPRegister(abRecord: ATNBPRecHandle; async: BOOLEAN): OSErr;

{
 *  NBPLookup()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NBPLookup(abRecord: ATNBPRecHandle; async: BOOLEAN): OSErr;

{
 *  NBPConfirm()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NBPConfirm(abRecord: ATNBPRecHandle; async: BOOLEAN): OSErr;

{
 *  NBPRemove()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NBPRemove(abEntity: EntityPtr): OSErr;

{
 *  NBPLoad()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NBPLoad: OSErr;

{
 *  NBPUnload()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NBPUnload: OSErr;

{$ENDC}  {CALL_NOT_IN_CARBON}
{$ENDC}  {TARGET_CPU_68K}

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AppleTalkIncludes}

{$ENDC} {__APPLETALK__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       ApplicationServices.p
 
     Contains:   Master include for ApplicationServices public framework
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 2000-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT ApplicationServices;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __APPLICATIONSERVICES__}
{$SETC __APPLICATIONSERVICES__ := 1}

{$I+}
{$SETC ApplicationServicesIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CORESERVICES__}
{$I CoreServices.p}
{$ENDC}


{$IFC UNDEFINED __ATSLAYOUTTYPES__}
{$I ATSLayoutTypes.p}
{$ENDC}
{$IFC UNDEFINED __ATSFONT__}
{$I ATSFont.p}
{$ENDC}
{$IFC UNDEFINED __ATSTYPES__}
{$I ATSTypes.p}
{$ENDC}
{$IFC UNDEFINED __SCALERSTREAMTYPES__}
{$I ScalerStreamTypes.p}
{$ENDC}
{$IFC UNDEFINED __SCALERTYPES__}
{$I ScalerTypes.p}
{$ENDC}
{$IFC UNDEFINED __SFNTLAYOUTTYPES__}
{$I SFNTLayoutTypes.p}
{$ENDC}
{$IFC UNDEFINED __SFNTTYPES__}
{$I SFNTTypes.p}
{$ENDC}
{$IFC UNDEFINED __QUICKDRAW__}
{$I Quickdraw.p}
{$ENDC}
{$IFC UNDEFINED __QDOFFSCREEN__}
{$I QDOffscreen.p}
{$ENDC}
{$IFC UNDEFINED __QUICKDRAWTEXT__}
{$I QuickdrawText.p}
{$ENDC}
{$IFC UNDEFINED __FONTS__}
{$I Fonts.p}
{$ENDC}
{$IFC UNDEFINED __PALETTES__}
{$I Palettes.p}
{$ENDC}
{$IFC UNDEFINED __PICTUTILS__}
{$I PictUtils.p}
{$ENDC}
{$IFC UNDEFINED __ATSUNICODE__}
{$I ATSUnicode.p}
{$ENDC}
{$IFC UNDEFINED __VIDEO__}
{$I Video.p}
{$ENDC}
{$IFC UNDEFINED __DISPLAYS__}
{$I Displays.p}
{$ENDC}
{$IFC UNDEFINED __FONTSYNC__}
{$I FontSync.p}
{$ENDC}
{$IFC UNDEFINED __AEDATAMODEL__}
{$I AEDataModel.p}
{$ENDC}
{$IFC UNDEFINED __APPLEEVENTS__}
{$I AppleEvents.p}
{$ENDC}
{$IFC UNDEFINED __AEPACKOBJECT__}
{$I AEPackObject.p}
{$ENDC}
{$IFC UNDEFINED __AEOBJECTS__}
{$I AEObjects.p}
{$ENDC}
{$IFC UNDEFINED __AEREGISTRY__}
{$I AERegistry.p}
{$ENDC}
{$IFC UNDEFINED __AEUSERTERMTYPES__}
{$I AEUserTermTypes.p}
{$ENDC}
{$IFC UNDEFINED __AEHELPERS__}
{$I AEHelpers.p}
{$ENDC}
{$IFC UNDEFINED __AEMACH__}
{$I AEMach.p}
{$ENDC}
{$IFC UNDEFINED __CGBASE__}
{$I CGBase.p}
{$ENDC}
{$IFC UNDEFINED __CGAFFINETRANSFORM__}
{$I CGAffineTransform.p}
{$ENDC}
{$IFC UNDEFINED __CGBITMAPCONTEXT__}
{$I CGBitmapContext.p}
{$ENDC}
{$IFC UNDEFINED __CGCOLORSPACE__}
{$I CGColorSpace.p}
{$ENDC}
{$IFC UNDEFINED __CGCONTEXT__}
{$I CGContext.p}
{$ENDC}
{$IFC UNDEFINED __CGDATACONSUMER__}
{$I CGDataConsumer.p}
{$ENDC}
{$IFC UNDEFINED __CGDATAPROVIDER__}
{$I CGDataProvider.p}
{$ENDC}
{$IFC UNDEFINED __CGERROR__}
{$I CGError.p}
{$ENDC}
{$IFC UNDEFINED __CGDIRECTDISPLAY__}
{$I CGDirectDisplay.p}
{$ENDC}
{$IFC UNDEFINED __CGDIRECTPALETTE__}
{$I CGDirectPalette.p}
{$ENDC}
{$IFC UNDEFINED __CGREMOTEOPERATION__}
{$I CGRemoteOperation.p}
{$ENDC}
{$IFC UNDEFINED __CGWINDOWLEVEL__}
{$I CGWindowLevel.p}
{$ENDC}
{$IFC UNDEFINED __CGGEOMETRY__}
{$I CGGeometry.p}
{$ENDC}
{$IFC UNDEFINED __CGIMAGE__}
{$I CGImage.p}
{$ENDC}
{$IFC UNDEFINED __CGPDFCONTEXT__}
{$I CGPDFContext.p}
{$ENDC}
{$IFC UNDEFINED __CGPDFDOCUMENT__}
{$I CGPDFDocument.p}
{$ENDC}
{$IFC UNDEFINED __CMTYPES__}
{$I CMTypes.p}
{$ENDC}
{$IFC UNDEFINED __CMAPPLICATION__}
{$I CMApplication.p}
{$ENDC}
{$IFC UNDEFINED __CMICCPROFILE__}
{$I CMICCProfile.p}
{$ENDC}
{$IFC UNDEFINED __CMDEVICEINTEGRATION__}
{$I CMDeviceIntegration.p}
{$ENDC}
{$IFC UNDEFINED __CMMCOMPONENT__}
{$I CMMComponent.p}
{$ENDC}
{$IFC UNDEFINED __CMSCRIPTINGPLUGIN__}
{$I CMScriptingPlugin.p}
{$ENDC}
{$IFC UNDEFINED __FINDBYCONTENT__}
{$I FindByContent.p}
{$ENDC}
{$IFC UNDEFINED __PMCORE__}
{$I PMCore.p}
{$ENDC}
{$IFC UNDEFINED __PMDEFINITIONS__}
{$I PMDefinitions.p}
{$ENDC}
{$IFC UNDEFINED __LANGUAGEANALYSIS__}
{$I LanguageAnalysis.p}
{$ENDC}
{$IFC UNDEFINED __DICTIONARY__}
{$I Dictionary.p}
{$ENDC}
{$IFC UNDEFINED __SPEECHSYNTHESIS__}
{$I SpeechSynthesis.p}
{$ENDC}
{$IFC UNDEFINED __LAUNCHSERVICES__}
{$I LaunchServices.p}
{$ENDC}
{$SETC UsingIncludes := ApplicationServicesIncludes}

{$ENDC} {__APPLICATIONSERVICES__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       ASDebugging.p
 
     Contains:   AppleScript Debugging Interfaces.
 
     Version:    Technology: AppleScript 1.1
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1992-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT ASDebugging;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __ASDEBUGGING__}
{$SETC __ASDEBUGGING__ := 1}

{$I+}
{$SETC ASDebuggingIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __FILES__}
{$I Files.p}
{$ENDC}
{$IFC UNDEFINED __COMPONENTS__}
{$I Components.p}
{$ENDC}
{$IFC UNDEFINED __APPLEEVENTS__}
{$I AppleEvents.p}
{$ENDC}
{$IFC UNDEFINED __APPLESCRIPT__}
{$I AppleScript.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{*************************************************************************
    Mode Flags
*************************************************************************}
{    This mode flag can be passed to OSASetProperty or OSASetHandler
    and will prevent properties or handlers from being defined in a context
    that doesn't already have bindings for them. An error is returned if
    a current binding doesn't already exist. 
}

CONST
	kOSAModeDontDefine			= $0001;

	{	*************************************************************************
	    Component Selectors
	*************************************************************************	}
	kASSelectSetPropertyObsolete = $1101;
	kASSelectGetPropertyObsolete = $1102;
	kASSelectSetHandlerObsolete	= $1103;
	kASSelectGetHandlerObsolete	= $1104;
	kASSelectGetAppTerminologyObsolete = $1105;
	kASSelectSetProperty		= $1106;
	kASSelectGetProperty		= $1107;
	kASSelectSetHandler			= $1108;
	kASSelectGetHandler			= $1109;
	kASSelectGetAppTerminology	= $110A;
	kASSelectGetSysTerminology	= $110B;
	kASSelectGetPropertyNames	= $110C;
	kASSelectGetHandlerNames	= $110D;

	{	*************************************************************************
	    Context Accessors
	*************************************************************************	}
	{
	 *  OSASetProperty()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION OSASetProperty(scriptingComponent: ComponentInstance; modeFlags: LONGINT; contextID: OSAID; {CONST}VAR variableName: AEDesc; scriptValueID: OSAID): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $1106, $7000, $A82A;
	{$ENDC}

{
 *  OSAGetProperty()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION OSAGetProperty(scriptingComponent: ComponentInstance; modeFlags: LONGINT; contextID: OSAID; {CONST}VAR variableName: AEDesc; VAR resultingScriptValueID: OSAID): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $1107, $7000, $A82A;
	{$ENDC}

{
 *  OSAGetPropertyNames()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION OSAGetPropertyNames(scriptingComponent: ComponentInstance; modeFlags: LONGINT; contextID: OSAID; VAR resultingPropertyNames: AEDescList): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $110C, $7000, $A82A;
	{$ENDC}

{
 *  OSASetHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION OSASetHandler(scriptingComponent: ComponentInstance; modeFlags: LONGINT; contextID: OSAID; {CONST}VAR handlerName: AEDesc; compiledScriptID: OSAID): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $1108, $7000, $A82A;
	{$ENDC}

{
 *  OSAGetHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION OSAGetHandler(scriptingComponent: ComponentInstance; modeFlags: LONGINT; contextID: OSAID; {CONST}VAR handlerName: AEDesc; VAR resultingCompiledScriptID: OSAID): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $1109, $7000, $A82A;
	{$ENDC}

{
 *  OSAGetHandlerNames()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION OSAGetHandlerNames(scriptingComponent: ComponentInstance; modeFlags: LONGINT; contextID: OSAID; VAR resultingHandlerNames: AEDescList): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $110D, $7000, $A82A;
	{$ENDC}

{
 *  OSAGetAppTerminology()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION OSAGetAppTerminology(scriptingComponent: ComponentInstance; modeFlags: LONGINT; VAR fileSpec: FSSpec; terminologyID: INTEGER; VAR didLaunch: BOOLEAN; VAR terminologyList: AEDesc): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0012, $110A, $7000, $A82A;
	{$ENDC}

{ Errors:
       errOSASystemError        operation failed
    }
{
 *  OSAGetSysTerminology()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION OSAGetSysTerminology(scriptingComponent: ComponentInstance; modeFlags: LONGINT; terminologyID: INTEGER; VAR terminologyList: AEDesc): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000A, $110B, $7000, $A82A;
	{$ENDC}

{ Errors:
       errOSASystemError        operation failed
    }
{ Notes on terminology ID

    A terminology ID is derived from script code and language code
    as follows;

        terminologyID = ((scriptCode & 0x7F) << 8) | (langCode & 0xFF)
}
{*************************************************************************
    Obsolete versions provided for backward compatibility:
}
{
 *  ASSetProperty()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ASSetProperty(scriptingComponent: ComponentInstance; contextID: OSAID; {CONST}VAR variableName: AEDesc; scriptValueID: OSAID): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $1101, $7000, $A82A;
	{$ENDC}

{
 *  ASGetProperty()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ASGetProperty(scriptingComponent: ComponentInstance; contextID: OSAID; {CONST}VAR variableName: AEDesc; VAR resultingScriptValueID: OSAID): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $1102, $7000, $A82A;
	{$ENDC}

{
 *  ASSetHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ASSetHandler(scriptingComponent: ComponentInstance; contextID: OSAID; {CONST}VAR handlerName: AEDesc; compiledScriptID: OSAID): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $1103, $7000, $A82A;
	{$ENDC}

{
 *  ASGetHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ASGetHandler(scriptingComponent: ComponentInstance; contextID: OSAID; {CONST}VAR handlerName: AEDesc; VAR resultingCompiledScriptID: OSAID): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $1104, $7000, $A82A;
	{$ENDC}

{
 *  ASGetAppTerminology()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in AppleScriptLib 1.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ASGetAppTerminology(scriptingComponent: ComponentInstance; VAR fileSpec: FSSpec; terminologID: INTEGER; VAR didLaunch: BOOLEAN; VAR terminologyList: AEDesc): OSAError;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000E, $1105, $7000, $A82A;
	{$ENDC}

{ Errors:
        errOSASystemError       operation failed
    }
{************************************************************************}


{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := ASDebuggingIncludes}

{$ENDC} {__ASDEBUGGING__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       ASRegistry.p
 
     Contains:   AppleScript Registry constants.
 
     Version:    Technology: AppleScript 1.3
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1991-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT ASRegistry;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __ASREGISTRY__}
{$SETC __ASREGISTRY__ := 1}

{$I+}
{$SETC ASRegistryIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __AEREGISTRY__}
{$I AERegistry.p}
{$ENDC}
{$IFC UNDEFINED __AEOBJECTS__}
{$I AEObjects.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}



CONST
	keyAETarget					= 'targ';
	keySubjectAttr				= 'subj';						{  Magic 'returning' parameter:  }
	keyASReturning				= 'Krtn';						{  AppleScript Specific Codes:  }
	kASAppleScriptSuite			= 'ascr';
	kASScriptEditorSuite		= 'ToyS';						{  AppleScript 1.3 added from private headers  }
	kASTypeNamesSuite			= 'tpnm';						{  dynamic terminologies  }
	typeAETE					= 'aete';
	typeAEUT					= 'aeut';
	kGetAETE					= 'gdte';
	kGetAEUT					= 'gdut';
	kUpdateAEUT					= 'udut';
	kUpdateAETE					= 'udte';
	kCleanUpAEUT				= 'cdut';
	kASComment					= 'cmnt';
	kASLaunchEvent				= 'noop';
	keyScszResource				= 'scsz';
	typeScszResource			= 'scsz';						{  subroutine calls  }
	kASSubroutineEvent			= 'psbr';
	keyASSubroutineName			= 'snam';
	kASPrepositionalSubroutine	= 'psbr';						{  AppleScript 1.3 added from private headers  }
	keyASPositionalArgs			= 'parg';						{  AppleScript 1.3 added from private headers  }

	{	 New to AppleScript 1.5 and later 	}
																{  Add this parameter to a Get Data result if your app handled the 'as' parameter  }
	keyAppHandledCoercion		= 'idas';

																{  Miscellaneous AppleScript commands  }
	kASStartLogEvent			= 'log1';						{  AppleScript 1.3 Script Editor Start Log  }
	kASStopLogEvent				= 'log0';						{  AppleScript 1.3 Script Editor Stop Log  }
	kASCommentEvent				= 'cmnt';						{  AppleScript 1.3 magic "comment" event  }


	{	 Operator Events: 	}
																{  Binary:  }
	kASAdd						= '+   ';
	kASSubtract					= '-   ';
	kASMultiply					= '*   ';
	kASDivide					= '/   ';
	kASQuotient					= 'div ';
	kASRemainder				= 'mod ';
	kASPower					= '^   ';
	kASEqual					= '=   ';
	kASNotEqual					= '�   ';
	kASGreaterThan				= '>   ';
	kASGreaterThanOrEqual		= '>=  ';
	kASLessThan					= '<   ';
	kASLessThanOrEqual			= '<=  ';
	kASComesBefore				= 'cbfr';
	kASComesAfter				= 'cafr';
	kASConcatenate				= 'ccat';
	kASStartsWith				= 'bgwt';
	kASEndsWith					= 'ends';
	kASContains					= 'cont';

	kASAnd						= 'AND ';
	kASOr						= 'OR  ';						{  Unary:  }
	kASNot						= 'NOT ';
	kASNegate					= 'neg ';
	keyASArg					= 'arg ';

																{  event code for the 'error' statement  }
	kASErrorEventCode			= 'err ';
	kOSAErrorArgs				= 'erra';
	keyAEErrorObject			= 'erob';						{      Added in AppleScript 1.3 from AppleScript private headers  }
																{  Properties:  }
	pLength						= 'leng';
	pReverse					= 'rvse';
	pRest						= 'rest';
	pInherits					= 'c@#^';
	pProperties					= 'pALL';						{  User-Defined Record Fields:  }
	keyASUserRecordFields		= 'usrf';
	typeUserRecordFields		= 'list';

	{	 Prepositions: 	}
	keyASPrepositionAt			= 'at  ';
	keyASPrepositionIn			= 'in  ';
	keyASPrepositionFrom		= 'from';
	keyASPrepositionFor			= 'for ';
	keyASPrepositionTo			= 'to  ';
	keyASPrepositionThru		= 'thru';
	keyASPrepositionThrough		= 'thgh';
	keyASPrepositionBy			= 'by  ';
	keyASPrepositionOn			= 'on  ';
	keyASPrepositionInto		= 'into';
	keyASPrepositionOnto		= 'onto';
	keyASPrepositionBetween		= 'btwn';
	keyASPrepositionAgainst		= 'agst';
	keyASPrepositionOutOf		= 'outo';
	keyASPrepositionInsteadOf	= 'isto';
	keyASPrepositionAsideFrom	= 'asdf';
	keyASPrepositionAround		= 'arnd';
	keyASPrepositionBeside		= 'bsid';
	keyASPrepositionBeneath		= 'bnth';
	keyASPrepositionUnder		= 'undr';

	keyASPrepositionOver		= 'over';
	keyASPrepositionAbove		= 'abve';
	keyASPrepositionBelow		= 'belw';
	keyASPrepositionApartFrom	= 'aprt';
	keyASPrepositionGiven		= 'givn';
	keyASPrepositionWith		= 'with';
	keyASPrepositionWithout		= 'wout';
	keyASPrepositionAbout		= 'abou';
	keyASPrepositionSince		= 'snce';
	keyASPrepositionUntil		= 'till';

																{  Terminology & Dialect things:  }
	kDialectBundleResType		= 'Dbdl';						{  AppleScript Classes and Enums:  }
	cConstant					= 'enum';
	cClassIdentifier			= 'pcls';
	cObjectBeingExamined		= 'exmn';
	cList						= 'list';
	cSmallReal					= 'sing';
	cReal						= 'doub';
	cRecord						= 'reco';
	cReference					= 'obj ';
	cUndefined					= 'undf';
	cMissingValue				= 'msng';						{   AppleScript 1.3 newly created }
	cSymbol						= 'symb';
	cLinkedList					= 'llst';
	cVector						= 'vect';
	cEventIdentifier			= 'evnt';
	cKeyIdentifier				= 'kyid';
	cUserIdentifier				= 'uid ';
	cPreposition				= 'prep';
	cKeyForm					= 'kfrm';
	cScript						= 'scpt';
	cHandler					= 'hand';
	cProcedure					= 'proc';

	cHandleBreakpoint			= 'brak';

	cClosure					= 'clsr';
	cRawData					= 'rdat';
	cStringClass				= 'TEXT';
	cNumber						= 'nmbr';
	cListElement				= 'celm';						{  AppleScript 1.3 added from private headers  }
	cListOrRecord				= 'lr  ';
	cListOrString				= 'ls  ';
	cListRecordOrString			= 'lrs ';
	cNumberOrString				= 'ns  ';						{  AppleScript 1.3 for Display Dialog  }
	cNumberOrDateTime			= 'nd  ';
	cNumberDateTimeOrString		= 'nds ';
	cAliasOrString				= 'sf  ';
	cSeconds					= 'scnd';
	typeSound					= 'snd ';
	enumBooleanValues			= 'boov';						{   Use this instead of typeBoolean to avoid with/without conversion   }
	kAETrue						= 'true';
	kAEFalse					= 'fals';
	enumMiscValues				= 'misc';
	kASCurrentApplication		= 'cura';						{  User-defined property ospecs:  }
	formUserPropertyID			= 'usrp';

	cString						= 'TEXT';						{  old name for cStringClass - can't be used in .r files }

																{  Global properties:  }
	pASIt						= 'it  ';
	pASMe						= 'me  ';
	pASResult					= 'rslt';
	pASSpace					= 'spac';
	pASReturn					= 'ret ';
	pASTab						= 'tab ';
	pASPi						= 'pi  ';
	pASParent					= 'pare';
	kASInitializeEventCode		= 'init';
	pASPrintLength				= 'prln';
	pASPrintDepth				= 'prdp';
	pASTopLevelScript			= 'ascr';

																{  Considerations  }
	kAECase						= 'case';
	kAEDiacritic				= 'diac';
	kAEWhiteSpace				= 'whit';
	kAEHyphens					= 'hyph';
	kAEExpansion				= 'expa';
	kAEPunctuation				= 'punc';
	kAEZenkakuHankaku			= 'zkhk';
	kAESmallKana				= 'skna';
	kAEKataHiragana				= 'hika';						{  AppleScript considerations:  }
	kASConsiderReplies			= 'rmte';
	enumConsiderations			= 'cons';

	cCoercion					= 'coec';
	cCoerceUpperCase			= 'txup';
	cCoerceLowerCase			= 'txlo';
	cCoerceRemoveDiacriticals	= 'txdc';
	cCoerceRemovePunctuation	= 'txpc';
	cCoerceRemoveHyphens		= 'txhy';
	cCoerceOneByteToTwoByte		= 'txex';
	cCoerceRemoveWhiteSpace		= 'txws';
	cCoerceSmallKana			= 'txsk';
	cCoerceZenkakuhankaku		= 'txze';
	cCoerceKataHiragana			= 'txkh';						{  Lorax things:  }
	cZone						= 'zone';
	cMachine					= 'mach';
	cAddress					= 'addr';
	cRunningAddress				= 'radd';
	cStorage					= 'stor';

																{  DateTime things:  }
	pASWeekday					= 'wkdy';
	pASMonth					= 'mnth';
	pASDay						= 'day ';
	pASYear						= 'year';
	pASTime						= 'time';
	pASDateString				= 'dstr';
	pASTimeString				= 'tstr';						{  Months  }
	cMonth						= 'mnth';
	cJanuary					= 'jan ';
	cFebruary					= 'feb ';
	cMarch						= 'mar ';
	cApril						= 'apr ';
	cMay						= 'may ';
	cJune						= 'jun ';
	cJuly						= 'jul ';
	cAugust						= 'aug ';
	cSeptember					= 'sep ';
	cOctober					= 'oct ';
	cNovember					= 'nov ';
	cDecember					= 'dec ';

																{  Weekdays  }
	cWeekday					= 'wkdy';
	cSunday						= 'sun ';
	cMonday						= 'mon ';
	cTuesday					= 'tue ';
	cWednesday					= 'wed ';
	cThursday					= 'thu ';
	cFriday						= 'fri ';
	cSaturday					= 'sat ';						{  AS 1.1 Globals:  }
	pASQuote					= 'quot';
	pASSeconds					= 'secs';
	pASMinutes					= 'min ';
	pASHours					= 'hour';
	pASDays						= 'days';
	pASWeeks					= 'week';						{  Writing Code things:  }
	cWritingCodeInfo			= 'citl';
	pScriptCode					= 'pscd';
	pLangCode					= 'plcd';						{  Magic Tell and End Tell events for logging:  }
	kASMagicTellEvent			= 'tell';
	kASMagicEndTellEvent		= 'tend';

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := ASRegistryIncludes}

{$ENDC} {__ASREGISTRY__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       ATA.p
 
     Contains:   ATA (PC/AT Attachment) Interfaces
 
     Version:    Technology: System 7.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1995-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT ATA;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __ATA__}
{$SETC __ATA__ := 1}

{$I+}
{$SETC ATAIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __NAMEREGISTRY__}
{$I NameRegistry.p}
{$ENDC}
{$IFC UNDEFINED __CODEFRAGMENTS__}
{$I CodeFragments.p}
{$ENDC}
{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __MIXEDMODE__}
{$I MixedMode.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


{ This is the structure used for the AT Interface core routines below }

CONST
	kATATrap					= $AAF1;						{  Manager trap number <This should be defined in Traps.h> }
	kATAPBVers1					= $01;							{  parameter block version number 1 }
	kATAPBVers2					= $02;							{  parameter block version number for structures }
	kATAPBVers3					= $03;							{  parameter block version for ATA times }
	kATADefaultBlockSize		= 512;							{  default block size }

	{  Used to determine the presence of traps }
	kFSMTrap					= $AC;
	mDQEChanged					= 1;							{  DQE has changed  }

	{  Task file definition ��� Error Register ��� }
	bATABadBlock				= 7;							{  bit number of bad block error bit }
	bATAUncorrectable			= 6;							{  bit number of uncorrectable error bit }
	bATAMediaChanged			= 5;							{  bit number of media changed indicator }
	bATAIDNotFound				= 4;							{  bit number of ID not found error bit }
	bATAMediaChangeReq			= 3;							{  bit number of media changed request }
	bATACommandAborted			= 2;							{  bit number of command abort bit }
	bATATrack0NotFound			= 1;							{  bit number of track not found }
	bATAAddressNotFound			= 0;							{  bit number of address mark not found }
	mATABadBlock				= $80;							{  Bad Block Detected }
	mATAUncorrectable			= $40;							{  Uncorrectable Data Error }
	mATAMediaChanged			= $20;							{  Media Changed Indicator (for removable) }
	mATAIDNotFound				= $10;							{  ID Not Found }
	mATAMediaChangeReq			= $08;							{  Media Change Requested (NOT IMPLEMENTED) }
	mATACommandAborted			= $04;							{  Aborted Command }
	mATATrack0NotFound			= $02;							{  Track 0 Not Found }
	mATAAddressNotFound			= $01;							{  Address Mark Not Found }

	{  Task file definition ��� Features register ��� }
	bATAPIuseDMA				= 0;							{  bit number of useDMA bit (ATAPI) }
	mATAPIuseDMA				= $01;

	{  Task file definition ��� ataTFSDH Register ��� }
	mATAHeadNumber				= $0F;							{  Head Number (bits 0-3)  }
	mATASectorSize				= $A0;							{  bit 7=1; bit 5 = 01 (512 sector size) <DP4> }
	mATADriveSelect				= $10;							{  Drive (0 = master, 1 = slave)  }
	mATALBASelect				= $40;							{  LBA mode bit (0 = chs, 1 = LBA) }

	{  Task file definition ��� Status Register ��� }
	bATABusy					= 7;							{  bit number of BSY bit }
	bATADriveReady				= 6;							{  bit number of drive ready bit }
	bATAWriteFault				= 5;							{  bit number of write fault bit }
	bATASeekComplete			= 4;							{  bit number of seek complete bit }
	bATADataRequest				= 3;							{  bit number of data request bit }
	bATADataCorrected			= 2;							{  bit number of data corrected bit }
	bATAIndex					= 1;							{  bit number of index mark }
	bATAError					= 0;							{  bit number of error bit }
	mATABusy					= $80;							{  Unit is busy }
	mATADriveReady				= $40;							{  Unit is ready }
	mATAWriteFault				= $20;							{  Unit has a write fault condition }
	mATASeekComplete			= $10;							{  Unit seek complete }
	mATADataRequest				= $08;							{  Unit data request }
	mATADataCorrected			= $04;							{  Data corrected }
	mATAIndex					= $02;							{  Index mark - NOT USED }
	mATAError					= $01;							{  Error condition - see error register }

	{  Task file definition ��� Device Control Register ��� }
	bATADCROne					= 3;							{  bit number of always one bit }
	bATADCRReset				= 2;							{  bit number of reset bit }
	bATADCRnIntEnable			= 1;							{  bit number of interrupt disable }
	mATADCROne					= $08;							{  always one bit }
	mATADCRReset				= $04;							{  Reset (1 = reset) }
	mATADCRnIntEnable			= $02;							{  Interrupt Disable(0 = enabled) }

	{  ATA Command Opcode definition }
	kATAcmdWORetry				= $01;							{  Without I/O retry option }
	kATAcmdNOP					= $0000;						{  NOP operation - media detect }
	kATAcmdRecal				= $0010;						{  Recalibrate command  }
	kATAcmdRead					= $0020;						{  Read command  }
	kATAcmdReadLong				= $0022;						{  Read Long command }
	kATAcmdWrite				= $0030;						{  Write command  }
	kATAcmdWriteLong			= $0032;						{  Write Long }
	kATAcmdWriteVerify			= $003C;						{  Write verify }
	kATAcmdReadVerify			= $0040;						{  Read Verify command  }
	kATAcmdFormatTrack			= $0050;						{  Format Track command  }
	kATAcmdSeek					= $0070;						{  Seek command  }
	kATAcmdDiagnostic			= $0090;						{  Drive Diagnostic command  }
	kATAcmdInitDrive			= $0091;						{  Init drive parameters command  }
	kATAcmdReadMultiple			= $00C4;						{  Read multiple }
	kATAcmdWriteMultiple		= $00C5;						{  Write multiple }
	kATAcmdSetRWMultiple		= $00C6;						{  Set Multiple for Read/Write Multiple }
	kATAcmdReadDMA				= $00C8;						{  Read DMA (with retries) }
	kATAcmdWriteDMA				= $00CA;						{  Write DMA (with retries) }
	kATAcmdMCAcknowledge		= $00DB;						{  Acknowledge media change - removable }
	kATAcmdDoorLock				= $00DE;						{  Door lock }
	kATAcmdDoorUnlock			= $00DF;						{  Door unlock }
	kATAcmdStandbyImmed			= $00E0;						{  Standby Immediate }
	kATAcmdIdleImmed			= $00E1;						{  Idle Immediate }
	kATAcmdStandby				= $00E2;						{  Standby }
	kATAcmdIdle					= $00E3;						{  Idle }
	kATAcmdReadBuffer			= $00E4;						{  Read sector buffer command  }
	kATAcmdCheckPowerMode		= $00E5;						{  Check power mode command   <04/04/94> }
	kATAcmdSleep				= $00E6;						{  Sleep }
	kATAcmdWriteBuffer			= $00E8;						{  Write sector buffer command  }
	kATAcmdWriteSame			= $00E9;						{  Write same data to multiple sectors }
	kATAcmdDriveIdentify		= $00EC;						{  Identify Drive command  }
	kATAcmdMediaEject			= $00ED;						{  Media Eject }
	kATAcmdSetFeatures			= $00EF;						{  Set Features }

	{  Set feature command opcodes }
	kATAEnableWriteCache		= $02;							{        Enable write cache }
	kATASetTransferMode			= $03;							{        Set transfer mode }
	kATASetPIOMode				= $08;							{        PIO Flow Control Tx Mode bit }
	kATAEnableECC				= $88;							{        ECC enable }
	kATAEnableRetry				= $99;							{        Retry enable }
	kATAEnableReadAhead			= $AA;							{        Read look-ahead enable }

	{
	  --------------------------------------------------------------------------------
	   enums for dealing with device IDs
	}

	kATABusIDMask				= $000000FF;
	kATADeviceIDMask			= $0000FF00;
	kATADeviceIDClippingMask	= $0000FFFF;
	kMinBusID					= $00000000;
	kMaxBusID					= $000000FE;

	kATAStartIterateDeviceID	= $FFFF;
	kATAEndIterateDeviceID		= $FF;

	{ -------------------------------------------------------------------------------- }
	{	 Device Register Images  (8 bytes) 	}

TYPE
	ataTaskFilePtr = ^ataTaskFile;
	ataTaskFile = RECORD
		ataTFFeatures:			SInt8;									{  <-> Error(R) or ataTFFeatures(W) register image  }
		ataTFCount:				SInt8;									{  <-> Sector count/remaining  }
		ataTFSector:			SInt8;									{  <-> Sector start/finish  }
		ataTFReserved:			SInt8;									{  reserved              }
		ataTFCylinder:			UInt16;									{  <-> ataTFCylinder (Big endian)  }
		ataTFSDH:				SInt8;									{  <-> ataTFSDH register image }
		ataTFCommand:			SInt8;									{  <-> Status(R) or Command(W) register image  }
	END;

	{  ATA Manager Function Code Definition }

CONST
	kATAMgrNOP					= $00;							{  No Operation }
	kATAMgrExecIO				= $01;							{  Execute ATA I/O }
	kATAMgrBusInquiry			= $03;							{  Bus Inquiry }
	kATAMgrQRelease				= $04;							{  I/O Queue Release }
	kATAMgrAbort				= $10;							{  Abort command }
	kATAMgrBusReset				= $11;							{  Reset ATA bus }
	kATAMgrRegAccess			= $12;							{  Register Access }
	kATAMgrDriveIdentify		= $13;							{  Drive Identify        <DP03/10/94> }
	kATAMgrDriverLoad			= $82;							{  Load driver from either Media, ROM, etc. }
	kATAMgrDriveRegister		= $85;							{  Register a driver   <4/18/94> }
	kATAMgrFindDriverRefnum		= $86;							{  lookup a driver refnum <4/18/94> }
	kATAMgrRemoveDriverRefnum	= $87;							{  De-register a driver   <4/18/94> }
	kATAMgrModifyEventMask		= $88;							{  Modify driver event mask }
	kATAMgrDriveEject			= $89;							{  Eject the drive       <8/1/94> }
	kATAMgrGetDrvConfiguration	= $8A;							{  Get device configuration   <8/6/94> }
	kATAMgrSetDrvConfiguration	= $8B;							{  Set device configuration <8/6/94> }
	kATAMgrGetLocationIcon		= $8C;							{  Get card location icon <SM4> }
	kATAMgrManagerInquiry		= $90;							{  Manager Inquiry }
	kATAMgrManagerInit			= $91;							{  Manager initialization }
	kATAMgrManagerShutdown		= $92;							{  Manager ShutDown }
	kATAMgrAddATABus			= $93;							{  Add an AIM to ATA Manager  <3/1/2000> }
	kATAMgrRemoveATABus			= $94;							{  Remove an AIM from ATA Manager <3/1/2000> }
																{  note: functions 0x95 to 0x97 are reserved }
	kATAMgrFindSpecialDriverRefnum = $98;						{  lookup a driver refnum; driverloader,notify-all or ROM driver. }
	kATAMgrNextAvailable		= $99;

	{  used in the ataDrvrFlags field for kATAMgrDriveRegister,kATAMgrRemoveDriverRefnum & kATAMgrFindSpecialDriverRefnum }
	kATANotifyAllDriver			= 0;							{  Notify-All driver }
	kATADriverLoader			= 1;							{  Driver loader driver      }
	kATAROMDriver				= 2;							{  ROM driver }

	{  'ATAFlags' field of the PB header definition }
	bATAFlagUseConfigSpeed		= 15;							{  bit number of use default speed flag }
	bATAFlagByteSwap			= 14;							{  bit number of byte swap flag }
	bATAFlagIORead				= 13;							{  bit number of I/O read flag }
	bATAFlagIOWrite				= 12;							{  bit number of I/O write flag }
	bATAFlagImmediate			= 11;							{  bit number of immediate flag }
	bATAFlagQLock				= 10;							{  bit number of que lock on error }
	bATAFlagReserved1			= 9;							{  reserved }
	bATAFlagUseScatterGather	= 8;							{  bit numbers of scatter gather }
	bATAFlagUseDMA				= 7;							{  bit number of use DMA flag }
	bATAFlagProtocolATAPI		= 5;							{  bit number of ATAPI protocol }
	bATAFlagReserved2			= 4;							{  reserved }
	bATAFlagTFRead				= 3;							{  bit number of register update }
	bATAFlagLEDEnable			= 0;							{  bit number of LED enable }
	mATAFlagUseConfigSpeed		= $8000;
	mATAFlagByteSwap			= $4000;						{  Swap data bytes (read - after; write - before) }
	mATAFlagIORead				= $2000;						{  Read (in) operation }
	mATAFlagIOWrite				= $1000;						{  Write (out) operation }
	mATAFlagImmediate			= $0800;						{  Head of Que; Immediate operation }
	mATAFlagQLock				= $0400;						{  Manager queue lock on error (freeze the queue) }
	mATAFlagUseScatterGather	= $0100;						{  Scatter gather enable }
	mATAFlagUseDMA				= $80;
	mATAFlagProtocolATAPI		= $20;							{  ATAPI protocol indicator }
	mATAFlagTFRead				= $08;							{  update reg block request upon detection of an error }
	mATAFlagLEDEnable			= $01;							{  socket LED enable }

	{	 These are legacy ATAFlags definitions, which will go away in the future 	}
	bATAFlagScatterGather1		= 9;							{  9 }
	bATAFlagScatterGather0		= 8;							{  8 }
	bATAFlagProtocol1			= 5;							{  5 }
	bATAFlagProtocol0			= 4;							{  4 }
	mATAFlagScatterGather1		= $0200;
	mATAFlagScatterGather0		= $0100;
	mATAFlagScatterGathers		= $0300;
	mATAFlagProtocol1			= $20;
	mATAFlagProtocol0			= $10;
	mATAFlagProtocols			= $30;

	{	 The Function codes passed by ATA Manager to the AIM plug-in 	}
	kATAFnNOP					= $00;							{  No Operation  }
	kATAFnExecIO				= $01;							{  Execute ATA I/O  }
	kATAFnBusInquiry			= $02;							{  Bus Inquiry  }
	kATAFnQRelease				= $03;							{  I/O Queue Release  }
	kATAFnCmd					= $04;							{  ATA Command  }
	kATAFnAbort					= $05;							{  Abort command  }
	kATAFnBusReset				= $06;							{  Reset ATA bus  }
	kATAFnRegAccess				= $07;							{  Register Access  }
	kATAFnDriveIdentify			= $08;							{  Drive Identify  }
	kATAPIFnExecIO				= $09;							{  ATAPI I/O  }
	kATAPIFnCmd					= $0A;							{  ATAPI Command  }
	kATAFnGetDriveConfig		= $0B;							{  Get Drive specific bus configuration  }
	kATAFnSetDriveConfig		= $0C;							{  Set Drive specific bus configuration  }
	kATAFnKillIO				= $0D;							{  Kill any current interaction with bus  }

	{	 The state to put the device light in used in DeviceLight AIM plugin export 	}
	kATADeviceLightOff			= $00;							{  Turn light off  }
	kATADeviceLightOn			= $01;							{  Turn light on  }

	{	 The state to put the device lock in used in DeviceLock AIM plugin export 	}
	kATADeviceUnlock			= $00;							{  unlock  }
	kATADeviceLock				= $01;							{  lock  }


	{	 add bus flags 	}
	{	 �� Applies to the ataAddBus structure �� 	}
	mATANoDMAOnBus				= $80;



TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	ATACallbackProcPtr = PROCEDURE(ataPB: UNIV Ptr);
{$ELSEC}
	ATACallbackProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	ATACallbackUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATACallbackUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppATACallbackProcInfo = $000000C0;
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  NewATACallbackUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION NewATACallbackUPP(userRoutine: ATACallbackProcPtr): ATACallbackUPP; { old name was NewATACallbackProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeATACallbackUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeATACallbackUPP(userUPP: ATACallbackUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeATACallbackUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE InvokeATACallbackUPP(ataPB: UNIV Ptr; userRoutine: ATACallbackUPP); { old name was CallATACallbackProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}

{
   
   structure which defines the ATA bus/device ID, part of the Device 0/1 Software Guide
   see <http://developer.apple.com/techpubs/hardware/Developer_Notes/System_Software/ATA_Device_Zero_One.pdf>
   p 19 :   Although ataPBDeviceID remains defined as a 32-bit number, drivers and applications
            can typecast it to the ataDeviceID structure to determine the bus number and device number
            for a specific ATA or ATAPI device
}

TYPE
	ataDeviceIDPtr = ^ataDeviceID;
	ataDeviceID = RECORD
		Reserved:				UInt16;									{  The upperword is reserved (0) }
		devNum:					SInt8;									{  device number (0 or 1) }
		busNum:					SInt8;									{  bus number }
	END;

	{
	   The kATADevIDProperty property will be inserted by the AIM when creating name registry entries for each 
	   drive found on the bus. The 4-byte data shall be the ataDeviceID structure used by ATA Manager. <3/14/2000>
	}

CONST
	kATADevIDPropertyNameLength	= 10;							{  Number of characters in kATADevIDProperty including the terminating null. }
	kATADevIDPropertySize		= 4;							{  Size of the data }


TYPE
	ATADataObjectPtr = ^ATADataObject;
	ATADataObject = RECORD
		ioBuf:					Ptr;									{  if SG flag enabled then this points to the head of the list else it is the buffer  }
		Count:					UInt32;									{  if SG flag enabled then count of SG Lists else the size  }
	END;

	ATAResultPtr = ^ATAResult;
	ATAResult = RECORD
		ataResult:				OSStatus;								{  the final result see Error Codes  }
		ataStatusRegister:		SInt8;									{  the status register  }
		ataErrorRegister:		SInt8;									{  the error register  }
		actualXferCount:		UInt32;									{  in case of I/O the actual size of Xfer  }
		TaskFile:				ataTaskFilePtr;							{  if "mATAFlagTFRead" enabled  }
	END;

	{
	   For ATAPI devices the ExtendedPB field is a pointer to the Command Packet
	   record which exists of an array of words structured as follows�  <06/15/94>
	}
	ATAPICmdPacketPtr = ^ATAPICmdPacket;
	ATAPICmdPacket = RECORD
		atapiPacketSize:		SInt16;									{  Size of command packet in bytes    <06/15/94> }
		atapiCommandByte:		ARRAY [0..7] OF SInt16;					{  The command packet itself  <06/15/94> }
	END;

	ATADevInfoPtr = ^ATADevInfo;
	ATADevInfo = RECORD
		devType:				SInt8;
		devID:					SInt8;
	END;

	{	 ATA Device ID codes to be used with devID field of the ATADevInfo structure 	}

CONST
	kATAInvalidDeviceID			= -1;
	kATADevice0DeviceID			= 0;							{  aka, Master. Device 0 is the correct terminology  }
	kATADevice1DeviceID			= 1;							{  aka, Slave. Device 1 is the correct terminology  }

	{	 AIM initialization 	}

TYPE
	ATAInitInfoPtr = ^ATAInitInfo;
	ATAInitInfo = RECORD
		busID:					UInt32;									{  --> busID assigned by the Manager  }
		FirstDevice:			ATADevInfo;								{  <-- Type and ID of first device  }
		SecondDevice:			ATADevInfo;								{  <-- Type and ID of second device  }
		aimRegEntry:			RegEntryIDPtr;							{  --> Name Registry entry for this controller  }
		refCon:					UInt32;									{  <-- refCon to be associated with this instantiation of the AIM  }
	END;

	{	 AIM Diag result 	}
	ATADiagResultPtr = ^ATADiagResult;
	ATADiagResult = RECORD
		ataRegMask:				UInt16;									{  the registers to access  }
		ataResult:				OSStatus;								{  the final result see Error Codes  }
		ataDataReg:				UInt16;									{  16 bit access only  }
		ataTFFeatures:			SInt8;									{  Error(R)  or Feature(W) register  }
		ataTFCount:				SInt8;									{  Sector Count register  }
		ataTFSector:			SInt8;									{  Sector number register  }
		ataTFCylinderLo:		SInt8;									{  Cylinder low bytes   }
		ataTFCylinderHi:		SInt8;									{  Cylinder High bytes   }
		ataTFSDH:				SInt8;									{  SDH register  }
		ataTFCommand:			SInt8;									{  status(R) or command(W) register  }
		ataAltStatDevCnt:		SInt8;									{  AltStatus(R) or Dev Cntrl(W) register  }
	END;

	{	 AIM Bus Info 	}
	ATABusInfoPtr = ^ATABusInfo;
	ATABusInfo = RECORD
		ataPIOModes:			SInt8;									{  PIO modes supported (bit-significant)  }
		ataSingleDMAModes:		SInt8;									{  <--: Single Word DMA modes supported (b-sig)     }
		ataMultiDMAModes:		SInt8;									{  <--: Multiword DMA modes supported (b-sig)  }
		ataUltraDMAModes:		SInt8;									{  <--: Ultra DMA modes supported (b-sig)  }
		ataIOPBsize0:			UInt32;									{  the current size of the Transfer for device 0  }
		ataIOPBsize1:			UInt32;									{  the current size of the Transfer for device 1  }
		ataContrlType:			ARRAY [0..15] OF SInt8;					{  the controller signature  }
		ataHBAversion:			NumVersion;								{  version number of the AIM  }
		reserved3:				UInt32;
	END;

	{  reserved words at the end of the devConfig structure }

CONST
	kATAConfigReserved			= 5;							{  number of reserved words at the end }


	{	 Bus timing config info passed between ATA Mgr and the AIM 	}

TYPE
	ATADevConfigPtr = ^ATADevConfig;
	ATADevConfig = RECORD
		ataConfigSetting:		SInt32;									{  <->: Configuration setting   }
																		{       Bits 3 - 0: Reserved  }
																		{       Bit 4: Reserved   }
																		{       Bit 5: Reserved   }
																		{       Bit 6: ATAPIpacketDRQ  }
																		{        1 = Check for Interrupt DRQ on ATAPI command packet DRQ  }
																		{        0 = Default: Check only for the assertion of command packet DRQ  }
																		{       Bits 31 - 7: Reserved  }
		ataPIOSpeedMode:		SInt8;									{  <->: Device access speed in PIO Mode  }
		reserved:				SInt8;									{  � do not modify, use or rely on reserved fields  }
		atapcValid:				UInt16;									{  reserved  }
		ataRWMultipleCount:		UInt16;									{  AIM's must return 0   }
		ataSectorsPerCylinder:	UInt16;									{  AIM's must return 0   }
		ataHeads:				UInt16;									{  AIM's must return 0   }
		ataSectorsPerTrack:		UInt16;									{  AIM's must return 0  }
		ataSocketNumber:		UInt16;									{  Reserved  }
		ataSocketType:			SInt8;									{  <--: Specifies the socket type (get config only)  }
																		{        00 = Unknown socket  }
																		{       01 = Internal ATA bus  }
																		{        02 = Media Bay  }
																		{        03 = PCMCIA  }
		ataDeviceType:			SInt8;									{  <--: Specifies the device type (get config only)  }
																		{        00 = Unknown device  }
																		{        01 = standard ATA device (HD)  }
																		{        02 = ATAPI device  }
																		{        03 = PCMCIA ATA device  }
		atapcAccessMode:		SInt8;									{  Reserved  }
		atapcVcc:				SInt8;									{  Reserved  }
		atapcVpp1:				SInt8;									{  Reserved  }
		atapcVpp2:				SInt8;									{  Reserved  }
		atapcStatus:			SInt8;									{  Reserved  }
		atapcPin:				SInt8;									{  Reserved  }
		atapcCopy:				SInt8;									{  Reserved  }
		atapcConfigIndex:		SInt8;									{  Reserved  }
		ataSingleDMASpeed:		SInt8;									{  <->: Single Word DMA Timing Class  }
		ataMultiDMASpeed:		SInt8;									{  <->: Multiple Word DMA Timing Class  }
		ataPIOCycleTime:		UInt16;									{  <->:Cycle time in ms for PIO mode  }
		ataMultiCycleTime:		UInt16;									{  <->:Cycle time in ms for Multiword DMA mode  }
		ataUltraDMASpeed:		SInt8;									{  <-> Ultra DMA timing class bit-significant  }
		reserved2:				SInt8;									{  reserved  }
		ataUltraCycleTime:		UInt16;									{  <-> Cycle time in ms for Ultra DMA mode  }
		Reserved1:				ARRAY [0..4] OF UInt16;					{  Reserved for future  }
	END;

	{	 The Request block passed by the manager to the AIM 	}
	ATAReqBlockPtr = ^ATAReqBlock;
	ATAReqBlock = RECORD
																		{  Filled in by ATA Mgr v4.0 }
		connectionID:			UInt32;									{  the connection ID of the req block  }
		MsgID:					UInt32;									{  the ioTag value of this request  }
		result:					ATAResultPtr;							{  result of this operation  }
		DiagResult:				ATADiagResultPtr;						{  for diagnostics i.e. R(W) registers  }
		busInfo:				ATABusInfoPtr;							{  for bus info requests  }
		devConfig:				ATADevConfigPtr;						{  for device config requests  }
		ioObject:				ATADataObject;							{  The actual transfer data  }
		ataPBTaskFile:			ataTaskFile;							{  the task file  }
		packetCBD:				ATAPICmdPacket;							{  For the ATAPI cmd packets  }
		Timeout:				Duration;								{  timeout for this request  }
		BusID:					UInt32;									{  family assigned bus ID  }
		DevID:					SInt8;									{  device ID, -1(bus), 0(master), 1(slave)  }
		ataFunctionCode:		SInt8;
		AbortID:				UInt32;
		ataPBLogicalBlockSize:	UInt32;
		ataPBFlags:				UInt32;
		reserved:				UInt32;
																		{  Used internally by the AIM }
		nextREQ:				ATAReqBlockPtr;							{  the next req on this list  }
		ataPBResult:			OSStatus;
		ataPBErrorRegister:		SInt8;
		ataPBStatusRegister:	SInt8;
		ataPBactualXferCount:	UInt32;
		ataPBState:				UInt32;
		ataPBSemaphores:		UInt32;
		XferType:				SInt8;
		ataModeType:			SInt8;									{  tracks old ataPBVers, to do absolute or bitmap modes        }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		reserved2:				SInt8;
		reserved3:				UInt16;
	END;

	{  enum for modeType in ATAReqBlock, aligned with ataPBVers }

CONST
	kATAModeAbsolute			= 2;
	kATAModeBitmap				= 3;							{  actually three or above }

	kATAPluginVersion			= $00000001;
	kATAPluginCurrentVersion	= $00000001;

	kServiceCategoryATA			= 'ata-';						{  ata }


TYPE
	ataPBHeaderPtr = ^ataPBHeader;
	ataPBHeader = RECORD
																		{  Start of cloned common header ataPBHdr  }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
	END;

	{  data request entry structure (16 bytes) }
	IOBlockPtr = ^IOBlock;
	IOBlock = RECORD
		ataPBBuffer:			Ptr;									{  -->: Data buffer pointer }
		ataPBByteCount:			UInt32;									{  -->: Data transfer length in bytes }
	END;

	{  Manager parameter block structure (96 bytes) }
	ataIOPBPtr = ^ataIOPB;
	ataIOPB = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataPBStatusRegister:	SInt8;									{  <--: Last ATA status image }
		ataPBErrorRegister:		SInt8;									{  <--: Last ATA error image-valid if lsb of Status set }
		ataPBReserved5:			SInt16;									{  Reserved }
		ataPBLogicalBlockSize:	UInt32;									{  -->: Blind transfer size per interrupt (Logical block size) }
		ataPBBuffer:			Ptr;									{  -->: Data buffer pointer }
		ataPBByteCount:			UInt32;									{  -->: Data transfer length in bytes }
		ataPBActualTxCount:		UInt32;									{  <--: Actual transfer count }
		ataPBReserved6:			UInt32;									{  Reserved }
		ataPBTaskFile:			ataTaskFile;							{  <->:   Device register images }
		ataPBPacketPtr:			ATAPICmdPacketPtr;						{  -->: ATAPI packet command block pointer (valid with ATAPI bit set) }
		ataPBReserved7:			ARRAY [0..5] OF SInt16;					{  Reserved for future expansion }
	END;

	{  Parameter block structure for bus and Manager inquiry command }
	{  Manager parameter block structure }
	ataBusInquiryPtr = ^ataBusInquiry;
	ataBusInquiry = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataEngineCount:			UInt16;									{  <--: TBD; zero for now }
		ataReserved1:			UInt16;									{  Reserved }
		ataDataTypes:			UInt32;									{  <--: TBD; zero for now }
		ataIOpbSize:			UInt16;									{  <--: Size of ATA IO PB }
		ataMaxIOpbSize:			UInt16;									{  <--: TBD; zero for now }
		ataFeatureFlags:		UInt32;									{  <--: TBD }
		ataVersionNum:			SInt8;									{  <--: Version number for the HBA }
		ataHBAInquiry:			SInt8;									{  <--: TBD; zero for now }
		ataReserved2:			UInt16;									{  Reserved }
		ataHBAPrivPtr:			UInt32;									{  <--: Ptr to HBA private data area }
		ataHBAPrivSize:			UInt32;									{  <--: Size of HBA private data area }
		ataAsyncFlags:			UInt32;									{  <--: Event capability for callback }
		ataPIOModes:			SInt8;									{  <--: PIO modes supported (bit-significant) }
		ataUltraDMAModes:		SInt8;									{  <--: Ultra DMA modes supported (b-sig) }
		ataSingleDMAModes:		SInt8;									{  <--: Single Word DMA modes supported (b-sig)    }
		ataMultiDMAModes:		SInt8;									{  <--: Multiword DMA modes supported (b-sig) }
		ataReserved4:			ARRAY [0..3] OF UInt32;					{  Reserved }
		ataReserved5:			ARRAY [0..15] OF SInt8;					{  TBD }
		ataHBAVendor:			ARRAY [0..15] OF SInt8;					{  <--: Vendor ID of the HBA }
		ataContrlFamily:		ARRAY [0..15] OF SInt8;					{  <--: Family of ATA Controller }
		ataContrlType:			ARRAY [0..15] OF SInt8;					{  <--: Model number of controller }
		ataXPTversion:			ARRAY [0..3] OF SInt8;					{  <--: version number of XPT }
		ataReserved6:			ARRAY [0..3] OF SInt8;					{  Reserved }
		ataHBAversion:			NumVersion;								{  <--: version number of HBA }
		ataHBAslotType:			SInt8;									{  <--: type of slot }
		ataHBAslotNum:			SInt8;									{  <--: slot number of the HBA }
		ataReserved7:			UInt16;									{  Reserved }
		ataReserved8:			UInt32;									{  Reserved }
	END;

	{  Manager parameter block structure }
	ataMgrInquiryPtr = ^ataMgrInquiry;
	ataMgrInquiry = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataMgrVersion:			NumVersion;								{  Manager Version information }
		ataMgrPBVers:			SInt8;									{  <--: Manager PB version number supported }
		Reserved1:				SInt8;									{  Reserved }
		ataBusCnt:				UInt16;									{  <--: Number of ATA buses in the system }
		ataDevCnt:				UInt16;									{  <--: Total number of ATA devices detected }
		ataPioModes:			SInt8;									{  <--: Maximum Programmed I/O speed mode supported }
		Reserved2:				SInt8;									{  Reserved }
		ataIOClkResolution:		UInt16;									{  <--: IO Clock resolution in nsec (Not supported) }
		ataSingleDMAModes:		SInt8;									{  <--: Single Word DMA modes supported    }
		ataMultiDMAModes:		SInt8;									{  <--: Multiword DMA modes supported }
		Reserved:				ARRAY [0..15] OF SInt16;				{  Reserved for future expansion }
	END;

	{  Parameter block structure for Abort command }
	{  Manager parameter block structure }
	ataAbortPtr = ^ataAbort;
	ataAbort = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataAbortPB:				ataIOPBPtr;								{  -->: Parameter block to be aborted }
		Reserved:				ARRAY [0..21] OF SInt16;				{  Reserved for future expansion }
	END;

	{  Manager parameter block structure }
	ATAEventRecPtr = ^ATAEventRec;
	ATAEventRec = RECORD
		ataEventCode:			UInt16;									{  --> ATA event code }
		ataPhysicalID:			UInt16;									{  --> Physical drive reference }
		ataDrvrContext:			SInt32;									{  Context pointer saved by driver }
		ataMarker:				UInt32;									{  Always 'LOAD' }
		ataEventRecVersion:		UInt32;									{  Version number of this data structure }
		ataDeviceType:			UInt32;									{  Device type on bus (valid for load driver only) }
		ataRefNum:				UInt16;									{  RefNum of driver (valid for remove driver only) }
	END;

{$IFC TYPED_FUNCTION_POINTERS}
	ATAClientProcPtr = FUNCTION(ataERPtr: ATAEventRecPtr): SInt16;
{$ELSEC}
	ATAClientProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	ATAClientUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATAClientUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppATAClientProcInfo = $000000E0;
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  NewATAClientUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION NewATAClientUPP(userRoutine: ATAClientProcPtr): ATAClientUPP; { old name was NewATAClientProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeATAClientUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeATAClientUPP(userUPP: ATAClientUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeATAClientUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION InvokeATAClientUPP(ataERPtr: ATAEventRecPtr; userRoutine: ATAClientUPP): SInt16; { old name was CallATAClientProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}

{  Parameter block structure for Driver Register command }
{  Manager parameter block structure }

TYPE
	ataDrvrRegisterPtr = ^ataDrvrRegister;
	ataDrvrRegister = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataDrvrRefNum:			SInt16;									{  <->: Driver reference number }
		ataDrvrFlags:			UInt16;									{  -->: 1 = loader driver if ataPBDeviceID = -1 (PB2) }
		ataDeviceNextID:		UInt16;									{  <--: used to specified the next drive ID }
		ataDrvrLoadPriv:		SInt16;									{  Driver loader private storage }
		ataEventHandler:		ATAClientUPP;							{  <->: Pointer to ATA event callback routine (PB2) }
		ataDrvrContext:			SInt32;									{  <->: Context data saved by driver (PB2) }
		ataEventMask:			SInt32;									{  <->: Set to 1 for notification of event (PB2) }
		Reserved:				ARRAY [0..13] OF SInt16;				{  Reserved for future expansion - from [21] (PB2) }
	END;

	{  Parameter block structure for Modify driver event mask command }
	ataModifyEventMaskPtr = ^ataModifyEventMask;
	ataModifyEventMask = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataModifiedEventMask:	SInt32;									{  -->: new event mask value }
		Reserved:				ARRAY [0..21] OF SInt16;				{  Reserved for future expansion }
	END;

	{  'ataRegMask' field of the ataRegAccess definition }

CONST
	bATAAltSDevCValid			= 14;							{  bit number of alternate status/device cntrl valid bit }
	bATAStatusCmdValid			= 7;							{  bit number of status/command valid bit }
	bATASDHValid				= 6;							{  bit number of ataTFSDH valid bit }
	bATACylinderHiValid			= 5;							{  bit number of cylinder high valid bit }
	bATACylinderLoValid			= 4;							{  bit number of cylinder low valid bit }
	bATASectorNumValid			= 3;							{  bit number of sector number valid bit }
	bATASectorCntValid			= 2;							{  bit number of sector count valid bit }
	bATAErrFeaturesValid		= 1;							{  bit number of error/features valid bit }
	bATADataValid				= 0;							{  bit number of data valid bit }
	mATAAltSDevCValid			= $4000;						{  alternate status/device control valid }
	mATAStatusCmdValid			= $80;							{  status/command valid }
	mATASDHValid				= $40;							{  ataTFSDH valid }
	mATACylinderHiValid			= $20;							{  cylinder high valid }
	mATACylinderLoValid			= $10;							{  cylinder low valid }
	mATASectorNumValid			= $08;							{  sector number valid }
	mATASectorCntValid			= $04;							{  sector count valid }
	mATAErrFeaturesValid		= $02;							{  error/features valid }
	mATADataValid				= $01;							{  data valid }

	{  Parameter block structure for device register access command }

TYPE
	ataRegValueUnionPtr = ^ataRegValueUnion;
	ataRegValueUnion = RECORD
		CASE INTEGER OF
		0: (
			ataByteRegValue:	SInt8;									{  <->: Byte register value read or to be written }
			);
		1: (
			ataWordRegValue:	UInt16;									{  <->: Word register value read or to be written }
			);
	END;

	{  Manager parameter block structure }
	ataRegAccessPtr = ^ataRegAccess;
	ataRegAccess = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataRegSelect:			UInt16;									{  -->: Device Register Selector }
																		{          DataReg       0   }
																		{          ErrorReg(R) or FeaturesReg(W)    1 }
																		{          SecCntReg       2 }
																		{          SecNumReg       3 }
																		{          CylLoReg     4 }
																		{          CylHiReg     5 }
																		{          SDHReg      6 }
																		{          StatusReg(R) or CmdReg(W)       7 }
																		{          AltStatus(R) or DevCntr(W)   0E }
		ataRegValue:			ataRegValueUnion;
																		{  Following fields are valid only if ataRegSelect = 0xFFFF }
		ataRegMask:				UInt16;									{  -->: mask for register(s) to update }
																		{        bit 0 : data register valid }
																		{        bit 1 : error/feaures register valid }
																		{        bit 2 : sector count register valid }
																		{        bit 3 : sector number register valid }
																		{        bit 4 : cylinder low register valid }
																		{        bit 5 : cylinder high register valid }
																		{        bit 6 : ataTFSDH register valid }
																		{        bit 7 : status/command register valid }
																		{        bits 8 - 13 : reserved (set to 0) }
																		{        bit 14: alternate status / device control reg valid }
																		{       bit 15: reserved (set to 0) }
		ataRegisterImage:		ataTaskFile;							{  <->: register images }
		ataAltSDevCReg:			SInt8;									{  <->: Alternate status(R) or Device Control(W) register image }
		Reserved3:				SInt8;									{  Reserved }
		Reserved:				ARRAY [0..15] OF SInt16;				{  Reserved for future expansion }
	END;

	{  Manager parameter block structure    <DP03/10/94> }
	ataIdentifyPtr = ^ataIdentify;
	ataIdentify = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		Reserved1:				ARRAY [0..3] OF UInt16;					{  Reserved.  These are used internally by the Manager }
		ataPBBuffer:			Ptr;									{  Buffer for the identify data (512 bytes) }
		Reserved2:				ARRAY [0..11] OF UInt16;				{  Used internally by the ATA Manager }
		Reserved3:				ARRAY [0..5] OF SInt16;					{  Reserved for future expansion }
	END;

	{  'ataConfigSetting' field of the Get/Set Device Configuration definition <8/6/94> }

CONST
	ATAPIpacketDRQ_bit			= 6;							{  bit number of ATAPI command packet DRQ option }
	ATAPIpacketDRQ				= $40;							{  ATAPI command packet DRQ option }

	{  atapcValid field definition }
	bATApcAccessMode			= 0;
	bATApcVcc					= 1;
	bATApcVpp1					= 2;
	bATApcVpp2					= 3;
	bATApcStatus				= 4;
	bATApcPin					= 5;
	bATApcCopy					= 6;
	bATApcConfigIndex			= 7;
	bATApcLockUnlock			= 15;
	mATApcAccessMode			= $01;
	mATApcVcc					= $02;
	mATApcVpp1					= $04;
	mATApcVpp2					= $08;
	mATApcStatus				= $10;
	mATApcPin					= $20;
	mATApcCopy					= $40;
	mATApcConfigIndex			= $80;
	mATApcLockUnlock			= $8000;

	{  Device physical type & socket type indicator definition }
	kATADeviceUnknown			= $00;							{  no device or type undetermined }
	kATADeviceATA				= $01;							{  traditional ATA protocol device <7/29/94> }
	kATADeviceATAPI				= $02;							{  ATAPI protocol device  <7/29/94> }
	kATADeviceReserved			= $03;							{  reserved by Apple (was PCMCIA) }

	kATASocketInternal			= $01;							{  Internal ATA socket }
	kATASocketMB				= $02;							{  Media Bay socket }
	kATASocketPCMCIA			= $03;							{  PCMCIA socket }


	{
	   Get/Set Device Configuration parameter block structure <8/6/94>
	   Manager parameter block structure
	}

TYPE
	ataDevConfigurationPtr = ^ataDevConfiguration;
	ataDevConfiguration = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataConfigSetting:		SInt32;									{  <->: Configuration setting }
																		{       Bits 3 - 0: Reserved }
																		{       Bit 4: Reserved (allowLBAAccess) }
																		{       Bit 5: Reserved (allowRWMultiple) }
																		{       Bit 6: ATAPIpacketDRQ }
																		{        1 = Check for Interrupt DRQ on ATAPI command packet DRQ }
																		{        0 = Default: Check only for the assertion of command packet DRQ }
																		{       Bits 31 - 7: Reserved }
		ataPIOSpeedMode:		SInt8;									{  <->: Device access speed in PIO Mode }
		Reserved3:				SInt8;									{  Reserved to force word alignment }
		atapcValid:				UInt16;									{  <->: Set when pcXXX fields are valid (atapcAccessMode - atapcConfigIndex) }
																		{        bit 0 - atapcAccessMode field valid, when set }
																		{        bit 1 - atapcVcc field valid, when set }
																		{        bit 2 - atapcVpp1 field valid, when set }
																		{        bit 3 - atapcVpp2 field valid, when set }
																		{        bit 4 - atapcStatus field valid, when set }
																		{        bit 5 - atapcPin field valid, when set }
																		{        bit 6 - atapcCopy field valid, when set }
																		{        bit 7 - atapcConfigIndex field valid, when set }
																		{        bits 14-8 - Reserved }
																		{        bit 15 - device lock/unlock request (write only) }
		ataRWMultipleCount:		UInt16;									{  Reserved for future (not supported yet) }
		ataSectorsPerCylinder:	UInt16;									{  Reserved for future (not supported yet) }
		ataHeads:				UInt16;									{  Reserved for future (not supported yet) }
		ataSectorsPerTrack:		UInt16;									{  Reserved for future (not supported yet) }
		ataSocketNumber:		UInt16;									{  <--: Socket number used by the CardServices }
																		{        0xFF = socket number invalid (Not a CardServices device) }
																		{        other = socket number of the device }
		ataSocketType:			SInt8;									{  <--: Specifies the socket type (get config only) }
																		{        00 = Unknown socket }
																		{       01 = Internal ATA bus }
																		{        02 = Media Bay }
																		{        03 = PCMCIA }
		ataDeviceType:			SInt8;									{  <--: Specifies the device type (get config only) }
																		{        00 = Unknown device }
																		{        01 = standard ATA device (HD) }
																		{        02 = ATAPI device }
																		{        03 = PCMCIA ATA device }
		atapcAccessMode:		SInt8;									{  <->: Access mode: Memory vs. I/O (PCMCIA only) }
		atapcVcc:				SInt8;									{  <->: Voltage in tenths of a volt (PCMCIA only) }
		atapcVpp1:				SInt8;									{  <->: Voltage in tenths of a volt (PCMCIA only) }
		atapcVpp2:				SInt8;									{  <->: Voltage in tenths of a volt (PCMCIA only) }
		atapcStatus:			SInt8;									{  <->: Card Status register setting (PCMCIA only) }
		atapcPin:				SInt8;									{  <->: Card Pin register setting (PCMCIA only) }
		atapcCopy:				SInt8;									{  <->: Card Socket/Copy register setting (PCMCIA only) }
		atapcConfigIndex:		SInt8;									{  <->: Card Option register setting (PCMCIA only) }
		ataSingleDMASpeed:		SInt8;									{  <->: Single Word DMA Timing Class }
		ataMultiDMASpeed:		SInt8;									{  <->: Multiple Word DMA Timing Class }
		ataPIOCycleTime:		UInt16;									{  <->:Cycle time for PIO mode }
		ataMultiCycleTime:		UInt16;									{  <->:Cycle time for Multiword DMA mode }
		ataUltraDMASpeed:		SInt8;									{  <-> Ultra DMA timing class }
		reserved2:				SInt8;									{  reserved }
		ataUltraCycleTime:		UInt16;									{  <-> Cycle time for Ultra DMA mode }
		Reserved1:				ARRAY [0..4] OF UInt16;					{  Reserved for future }
	END;

	{  Get Card Location Icon/Text  <SM4> }

CONST
	kATALargeIconHFS			= $0001;						{  Large B&W icon with mask (HFS) }
	kATALargeIconProDOS			= $0081;						{  Large B&W icon with mask (ProDOS) }

	{  Manager parameter block structure }

TYPE
	ataLocationDataPtr = ^ataLocationData;
	ataLocationData = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataIconType:			SInt16;									{  -->: icon type specifier }
																		{       1 = Large B&W icon with mask (256 bytes) }
																		{        0x81 = Same as 1, but ProDOS icon }
		ataIconReserved:		SInt16;									{  Reserved to be longword aligned }
		ataLocationIconPtr:		Ptr;									{  -->: Icon Data buffer pointer }
		ataLocationStringPtr:	Ptr;									{  -->: Icon String buffer pointer }
		Reserved1:				ARRAY [0..17] OF UInt16;				{  Reserved for future }
	END;

	{  ataOSType available }

CONST
	kATAddTypeMacOS				= $0001;						{  Blue Mac O/S ddType value }

	{  Parameter block structure for adding an ATA bus; ATA Manager 4 and above. }

TYPE
	ataAddATABusPtr = ^ataAddATABus;
	ataAddATABus = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ProcPtr;								{  -->: Completion Routine Pointer     }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier         }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		ataNameRegEntry:		RegEntryIDPtr;							{  -->: Pointer to name registry data }
		connID:					CFragConnectionID;						{  -->: Reserved. Must be set to zero. }
		busID:					UInt32;									{  <--: bus ID }
		flags:					SInt8;									{  -->: add bus flags }
		socketType:				SInt8;									{  -->:   Socket type as defined in the enum }
		iconData:				Ptr;									{  -->: Ptr to 256 bytes of icon data (nil is OK) }
		stringData:				Ptr;									{  -->: C String defining location of device. (nil is OK) }
	END;

	{  Parameter block structure for adding an ATA bus; ATA Manager 4 and above. }
	ataRemoveATABusPtr = ^ataRemoveATABus;
	ataRemoveATABus = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ProcPtr;								{  -->: Completion Routine Pointer     }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier         }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		busID:					UInt32;									{  -->: Reserved. Must set to 0.              }
		ataNameRegEntry:		RegEntryIDPtr;							{  -->: Pointer to name registry data  }
	END;

	{  The parameter block definition for all other ATA Manager functions. }

	ataGenericPtr = ^ataGeneric;
	ataGeneric = RECORD
																		{  Start of cloned common header ataPBHdr }
		ataPBLink:				ataPBHeaderPtr;							{  a pointer to the next entry in the queue    }
		ataPBQType:				UInt16;									{  type byte for safety check }
		ataPBVers:				SInt8;									{  -->: parameter block version number; Must be 0x01 }
		ataPBReserved:			SInt8;									{  Reserved                          }
		ataPBReserved2:			Ptr;									{  Reserved                          }
		ataPBCallbackPtr:		ATACallbackUPP;							{  -->: Completion Routine Pointer }
		ataPBResult:			OSErr;									{  <--: Returned result           }
		ataPBFunctionCode:		SInt8;									{  -->: Manager Function Code  }
		ataPBIOSpeed:			SInt8;									{  -->: I/O Timing Class        }
		ataPBFlags:				UInt16;									{  -->: Various control options    }
		ataPBReserved3:			SInt16;									{  Reserved                          }
		ataPBDeviceID:			UInt32;									{  -->: Device identifier (see ataDeviceID)       }
		ataPBTimeOut:			UInt32;									{  -->: Transaction timeout value in msec  }
		ataPBClientPtr1:		Ptr;									{  Client's storage Ptr 1      }
		ataPBClientPtr2:		Ptr;									{  Client's storage Ptr 2      }
		ataPBState:				UInt16;									{  Reserved for Manager; Initialize to 0  }
		ataPBSemaphores:		UInt16;									{  Used internally by the manager }
		ataPBReserved4:			SInt32;									{  Reserved                          }
																		{  End of cloned common header ataPBHdr }
		Reserved:				ARRAY [0..23] OF UInt16;				{  Reserved for future }
	END;

	ataPBPtr = ^ataPB;
	ataPB = RECORD
		CASE INTEGER OF
		0: (
			ataIOParamBlock:	ataIOPB;								{  parameter block for I/O }
			);
		1: (
			ataBIParamBlock:	ataBusInquiry;							{  parameter block for bus inquiry }
			);
		2: (
			ataMIParamBlock:	ataMgrInquiry;							{  parameter block for Manager inquiry }
			);
		3: (
			ataAbortParamBlock:	ataAbort;								{  parameter block for abort }
			);
		4: (
			ataDRParamBlock:	ataDrvrRegister;						{  parameter block for driver register }
			);
		5: (
			ataMEParamBlock:	ataModifyEventMask;						{  parameter block for event mask modify }
			);
		6: (
			ataRAParamBlock:	ataRegAccess;							{  parameter block for register access }
			);
		7: (
			ataDIParamBlock:	ataIdentify;							{  parameter block for drive identify }
			);
		8: (
			ataDCParamBlock:	ataDevConfiguration;					{  parameter block for device configuration }
			);
		9: (
			ataLDParamBlock:	ataLocationData;						{  parameter block for location icon data }
			);
																		{ ataManagerInit  ataInitParamBlock;     // parameter block for Manager initialization }
																		{ ataManagerShutDn    ataSDParamBlock;     // parameter block for Manager shutdown }
																		{ ataDrvrLoad     ataDLParamBlock;     // parameter block for Driver loading }
		10: (
			ataGenericParamBlock: ataGeneric;							{  parameter block for all other functions }
			);
	END;

	{  The ATA Event codes� }

CONST
	kATANullEvent				= $00;							{  Just kidding -- nothing happened }
	kATAOnlineEvent				= $01;							{  An ATA device has come online }
	kATAOfflineEvent			= $02;							{  An ATA device has gone offline }
	kATARemovedEvent			= $03;							{  An ATA device has been removed from the bus }
	kATAResetEvent				= $04;							{  Someone gave a hard reset to the drive }
	kATAOfflineRequest			= $05;							{  Someone requesting to offline the drive }
	kATAEjectRequest			= $06;							{  Someone requesting to eject the drive }
	kATAUpdateEvent				= $07;							{  Potential configuration change reported by CardServices <SM4> }
	kATATaskTimeRequest			= $08;							{  The manager is requesting to be called at Task Time }
	kATALoadDriverNow			= $09;							{  Load the driver for the given bus immediately }
	kATAPIResetEvent			= $0A;							{  Someone gave a ATAPI reset to the drive }
																{  The following describes bit definitions in the eventMask field of ataDrvrRegister }
	bATANullEvent				= $01;							{  null event bit }
	bATAOnlineEvent				= $02;							{  online event bit }
	bATAOfflineEvent			= $04;							{  offline event bit }
	bATARemovedEvent			= $08;							{  removed event bit }
	bATAResetEvent				= $10;							{  ATA reset event bit }
	bATAOfflineRequest			= $20;							{  offline request event bit }
	bATAEjectRequest			= $40;							{  eject request event bit }
	bATAUpdateEvent				= $80;							{  configuration update event bit }
	bATAPIResetEvent			= $0400;						{  ATAPI reset event bit }

	kATAEventMarker				= 'LOAD';						{  Marker for the event data structure }
	kATAEventVersion1			= $00000001;					{  Version 1 of the event structure }


TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	ATADispatchProcPtr = FUNCTION(VAR pb: ataPB): OSErr;
{$ELSEC}
	ATADispatchProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	ATADispatchUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATADispatchUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppATADispatchProcInfo = $000000E0;
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  NewATADispatchUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION NewATADispatchUPP(userRoutine: ATADispatchProcPtr): ATADispatchUPP; { old name was NewATADispatchProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeATADispatchUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeATADispatchUPP(userUPP: ATADispatchUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeATADispatchUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION InvokeATADispatchUPP(VAR pb: ataPB; userRoutine: ATADispatchUPP): OSErr; { old name was CallATADispatchProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}

{$IFC CALL_NOT_IN_CARBON }
{
 *  ataManager()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ataManager(VAR pb: ataPB): SInt16;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $AAF1;
	{$ENDC}

{  Typedefs for the AIM entry point pointers }
{$ENDC}  {CALL_NOT_IN_CARBON}


TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginInit = FUNCTION(VAR pb: ATAInitInfo): OSStatus; C;
{$ELSEC}
	ATAPluginInit = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginClose = FUNCTION(refCon: UInt32; aimRegEntry: RegEntryIDPtr): OSStatus; C;
{$ELSEC}
	ATAPluginClose = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginAction = PROCEDURE(refCon: UInt32; VAR pb: ATAReqBlock); C;
{$ELSEC}
	ATAPluginAction = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginHandleBusEvent = PROCEDURE(refCon: UInt32; aimData: UInt32); C;
{$ELSEC}
	ATAPluginHandleBusEvent = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginPoll = FUNCTION(refCon: UInt32; interruptLevel: UInt32; VAR aimData: UInt32): BOOLEAN; C;
{$ELSEC}
	ATAPluginPoll = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginEjectDevice = PROCEDURE(refCon: UInt32); C;
{$ELSEC}
	ATAPluginEjectDevice = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginDeviceLight = PROCEDURE(refCon: UInt32; whichDevice: UInt32; lightState: UInt32); C;
{$ELSEC}
	ATAPluginDeviceLight = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginDeviceLock = PROCEDURE(refCon: UInt32; whichDevice: UInt32; lockState: UInt32); C;
{$ELSEC}
	ATAPluginDeviceLock = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginSuspend = PROCEDURE(refCon: UInt32); C;
{$ELSEC}
	ATAPluginSuspend = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATAPluginResume = PROCEDURE(refCon: UInt32); C;
{$ELSEC}
	ATAPluginResume = ProcPtr;
{$ENDC}

	{	 AIM Plugin header 	}
	ATAPluginHeaderPtr = ^ATAPluginHeader;
	ATAPluginHeader = RECORD
		headerVersion:			NumVersion;
		dispatchVersion:		NumVersion;
		reservedA:				UInt32;
		reservedB:				UInt32;
	END;

	ATAPluginDispatchTablePtr = ^ATAPluginDispatchTable;
	ATAPluginDispatchTable = RECORD
		header:					ATAPluginHeader;
		init:					ATAPluginInit;
		close:					ATAPluginClose;
		action:					ATAPluginAction;
		busEvent:				ATAPluginHandleBusEvent;
		poll:					ATAPluginPoll;
		eject:					ATAPluginEjectDevice;
		light:					ATAPluginDeviceLight;
		lock:					ATAPluginDeviceLock;
		suspend:				ATAPluginSuspend;
		resume:					ATAPluginResume;
	END;


	{  Callbacks into the System 7 ATA Manager }
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  ATAFamIODone()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in ATAManager 4 and later
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
PROCEDURE ATAFamIODone(VAR theReq: ATAReqBlock; result: OSStatus); C;

{
 *  ATAFamBusEventForAIM()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATAManager 4 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE ATAFamBusEventForAIM(busID: UInt32; busEvent: UInt32); C;

{
 *  NativeATAMgr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATAManager 4 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION NativeATAMgr(VAR request: ataPB): SInt16;



{ Device Error codes: 0xDB42 - 0xDB5F  }

{$ENDC}  {CALL_NOT_IN_CARBON}


CONST
	ATABaseErrCode				= -9406;						{  Base error code - 0xDB42    }
	ioPending					= 1;							{  Asynch I/O in progress status }
	AT_NRdyErr					= -9405;						{  0xDB43: Drive not Ready  }
	AT_IDNFErr					= -9404;						{  0xDB44: ID not found  }
	AT_DMarkErr					= -9403;						{  0xDB45: Data mark not found  }
	AT_BadBlkErr				= -9402;						{  0xDB46: Bad Block  }
	AT_CorDataErr				= -9401;						{  0xDB47: Data was corrected  }
	AT_UncDataErr				= -9400;						{  0xDB48: Data was not corrected  }
	AT_SeekErr					= -9399;						{  0xDB49: Seek error  }
	AT_WrFltErr					= -9398;						{  0xDB4A: Write fault  }
	AT_RecalErr					= -9397;						{  0xDB4B: Recalibrate failed  }
	AT_AbortErr					= -9396;						{  0xDB4C: Command aborted by drive  }
	AT_MCErr					= -9394;						{  0xDB4E: Media Changed error }
	ATAPICheckErr				= -9393;						{  0xDB4F: ATAPI Check condition <06/15/94> }
	AT_UltraDMAiCRCErr			= -9392;						{  0xDB50: CRC error during Ultra DMA xfer  }
																{  System error codes...Custom Driver Error Codes 0xDB60 - 0xDB6F }
	DRVRCantAllocate			= -9376;						{  0xDB60: Allocation error during initialization }
	NoATAMgr					= -9375;						{  0xDB61: MgrInquiry failed => No ATA Manager }
	ATAInitFail					= -9374;						{  0xDB62: Mgr Initialization failed }
	ATABufFail					= -9373;						{  0xDB63: Device buffer test failure }
	ATADevUnsupported			= -9372;						{  0xDB64: Device type not supported }
	ATAEjectDrvErr				= -9371;						{  0xDB65: Could not eject the drive }
																{  Manager Error Codes 0xDB70 - 0xDB8F }
	ATAMgrNotInitialized		= -9360;						{  0xDB70: Mgr has not been initialized }
	ATAPBInvalid				= -9359;						{  0xDB71: The bus base address couldn't be found }
	ATAFuncNotSupported			= -9358;						{  0xDB72: An unknown function code specified }
	ATABusy						= -9357;						{  0xDB73: Selected device is busy }
	ATATransTimeOut				= -9356;						{  0xDB74: Transaction timeout detected }
	ATAReqInProg				= -9355;						{  0xDB75: Channel busy; channel is processing another cmd }
	ATAUnknownState				= -9354;						{  0xDB76: Device status register reflects an unknown state }
	ATAQLocked					= -9353;						{  0xDB77: I/O Queue is locked due to previous I/O error. }
	ATAReqAborted				= -9352;						{  0xDB78: The I/O queue entry was aborted due to an abort req. }
																{          or due to Manager shutdown. }
	ATAUnableToAbort			= -9351;						{  0xDB79: The I/O queue entry could not be aborted. }
	ATAAbortedDueToRst			= -9350;						{  0xDB7A: Request aborted due to a device reset command. }
	ATAPIPhaseErr				= -9349;						{  0xDB7B: Unexpected phase - ���IS THIS VALID ERROR??? <06/15/94> }
	ATAPITxCntErr				= -9348;						{  0xDB7C: Overrun/Underrun condition detected }
	ATANoClientErr				= -9347;						{  0xDB7D: No client present to handle the event }
	ATAInternalErr				= -9346;						{  0xDB7E: MagnumOpus returned an error }
	ATABusErr					= -9345;						{  0xDB7F: Bus error detected on I/O   }
	AT_NoAddrErr				= -9344;						{  0xDB80: Invalid AT base adress  }
	DriverLocked				= -9343;						{  0xDB81: Current driver must be removed before adding another }
	CantHandleEvent				= -9342;						{  0xDB82: Particular event couldn't be handled (call others) }
	ATAMgrMemoryErr				= -9341;						{  0xDB83: Manager memory allocation error     }
	ATASDFailErr				= -9340;						{  0xDB84: Shutdown failure           }
	ATAXferParamErr				= -9339;						{  0xDB85: I/O xfer parameters inconsistent  }
	ATAXferModeErr				= -9338;						{  0xDB86: I/O xfer mode not supported  }
	ATAMgrConsistencyErr		= -9337;						{  0XDB87: Manager detected internal inconsistency.  }
	ATADmaXferErr				= -9336;						{  0XDB88: fatal error in DMA side of transfer  }
																{  Driver loader error Codes 0xDB90 - 0xDBA5 }
	ATAInvalidDrvNum			= -9328;						{  0xDB90: Invalid drive number from event }
	ATAMemoryErr				= -9327;						{  0xDB91: Memory allocation error }
	ATANoDDMErr					= -9326;						{  0xDB92: No DDM found on media   }
	ATANoDriverErr				= -9325;						{  0xDB93: No driver found on the media    }

	{	 ------------------------ Version 1 definition -------------------------------    	}
	v1ATABaseErrCode			= $0700;						{  This needs a home somewhere }
	v1AT_NRdyErr				= $FFFFF901;					{  0xF901: -0x1DBE  }
	v1AT_IDNFErr				= $FFFFF904;					{  0xF904: -0x1DC0  }
	v1AT_DMarkErr				= $FFFFF905;					{  0xF905: -0x1DC0  }
	v1AT_BadBlkErr				= $FFFFF906;					{  0xF906: -0x1DC0  }
	v1AT_CorDataErr				= $FFFFF907;					{  0xF907: -0x1DC0  }
	v1AT_UncDataErr				= $FFFFF908;					{  0xF908: -0x1DC0  }
	v1AT_SeekErr				= $FFFFF909;					{  0xF909: -0x1DC0  }
	v1AT_WrFltErr				= $FFFFF90A;					{  0xF90A: -0x1DC0  }
	v1AT_RecalErr				= $FFFFF90B;					{  0xF90B: -0x1DC0  }
	v1AT_AbortErr				= $FFFFF90C;					{  0xF90C: -0x1DC0  }
	v1AT_NoAddrErr				= $FFFFF90D;					{  0xF90D: -0x1D8D  }
	v1AT_MCErr					= $FFFFF90E;					{  0xF90E: -0x1DC0 }
																{  System error codes...Custom Driver Error Codes }
	v1DRVRCantAllocate			= -1793;						{  0xF8FF: -0x1D9F }
	v1NoATAMgr					= -1794;						{  0xF8FE: -0x1D9D }
	v1ATAInitFail				= -1795;						{  0xF8FD: -0x1D9B }
	v1ATABufFail				= -1796;						{  0xF8FC: -0x1D99 }
	v1ATADevUnsupported			= -1797;						{  0xF8FB: -0x1c97 }
																{  Manager Error Codes }
	v1ATAMgrNotInitialized		= -1802;						{  0xF8F6: -0x1D86 }
	v1ATAPBInvalid				= -1803;						{  0xF8F5: -0x1D84 }
	v1ATAFuncNotSupported		= -1804;						{  0xF8F4: -0x1D82 }
	v1ATABusy					= -1805;						{  0xF8F3: -0x1D80 }
	v1ATATransTimeOut			= -1806;						{  0xF8F2: -0x1D7E }
	v1ATAReqInProg				= -1807;						{  0xF8F1: -0x1D7C }
	v1ATAUnknownState			= -1808;						{  0xF8F0: -0x1D7A }
	v1ATAQLocked				= -1809;						{  0xF8EF: -0x1D78 }
	v1ATAReqAborted				= -1810;						{  0xF8EE: -0x1D76 }
	v1ATAUnableToAbort			= -1811;						{  0xF8ED: -0x1D74 }
	v1ATAAbortedDueToRst		= -1812;						{  0xF8EC: -0x1D72 }


{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := ATAIncludes}

{$ENDC} {__ATA__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       ATSFont.p
 
     Contains:   Public interface to the font access and data management functions of ATS.
 
     Version:    Technology: Mac OS
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 2000-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT ATSFont;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __ATSFONT__}
{$SETC __ATSFONT__ := 1}

{$I+}
{$SETC ATSFontIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __ATSTYPES__}
{$I ATSTypes.p}
{$ENDC}
{$IFC UNDEFINED __CFSTRING__}
{$I CFString.p}
{$ENDC}
{$IFC UNDEFINED __FILES__}
{$I Files.p}
{$ENDC}
{$IFC UNDEFINED __TEXTCOMMON__}
{$I TextCommon.p}
{$ENDC}
{$IFC UNDEFINED __SFNTTYPES__}
{$I SFNTTypes.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


CONST
	kATSOptionFlagsDefault		= 0;
	kATSOptionFlagsComposeFontPostScriptName = $01;				{  ATSFontGetPostScriptName  }
	kATSOptionFlagsUseDataForkAsResourceFork = $0100;			{  ATSFontActivateFromFileSpecification  }
	kATSOptionFlagsUseResourceFork = $0200;
	kATSOptionFlagsUseDataFork	= $0300;

	kATSIterationCompleted		= -980;
	kATSInvalidFontFamilyAccess	= -981;
	kATSInvalidFontAccess		= -982;
	kATSIterationScopeModified	= -983;
	kATSInvalidFontTableAccess	= -984;
	kATSInvalidFontContainerAccess = -985;


TYPE
	ATSFontContext						= UInt32;

CONST
	kATSFontContextUnspecified	= 0;
	kATSFontContextGlobal		= 1;


TYPE
	ATSFontFormat						= UInt32;

CONST
	kATSFontFormatUnspecified	= 0;


TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	ATSFontFamilyApplierFunction = FUNCTION(iFamily: ATSFontFamilyRef; iRefCon: UNIV Ptr): OSStatus; C;
{$ELSEC}
	ATSFontFamilyApplierFunction = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATSFontApplierFunction = FUNCTION(iFont: ATSFontRef; iRefCon: UNIV Ptr): OSStatus; C;
{$ELSEC}
	ATSFontApplierFunction = ProcPtr;
{$ENDC}

	ATSFontFamilyIterator    = ^LONGINT; { an opaque 32-bit type }
	ATSFontFamilyIteratorPtr = ^ATSFontFamilyIterator;  { when a VAR xx:ATSFontFamilyIterator parameter can be nil, it is changed to xx: ATSFontFamilyIteratorPtr }
	ATSFontIterator    = ^LONGINT; { an opaque 32-bit type }
	ATSFontIteratorPtr = ^ATSFontIterator;  { when a VAR xx:ATSFontIterator parameter can be nil, it is changed to xx: ATSFontIteratorPtr }

CONST
	kATSFontFilterCurrentVersion = 0;


TYPE
	ATSFontFilterSelector 		= SInt32;
CONST
	kATSFontFilterSelectorUnspecified = 0;
	kATSFontFilterSelectorGeneration = 3;
	kATSFontFilterSelectorFontFamily = 7;
	kATSFontFilterSelectorFontFamilyApplierFunction = 8;
	kATSFontFilterSelectorFontApplierFunction = 9;


TYPE
	ATSFontFilterPtr = ^ATSFontFilter;
	ATSFontFilter = RECORD
		version:				UInt32;
		filterSelector:			ATSFontFilterSelector;
		CASE INTEGER OF
		0: (
			generationFilter:	ATSGeneration;
			);
		1: (
			fontFamilyFilter:	ATSFontFamilyRef;
			);
		2: (
			fontFamilyApplierFunctionFilter: ATSFontFamilyApplierFunction;
			);
		3: (
			fontApplierFunctionFilter: ATSFontApplierFunction;
			);
	END;

	{	 ----------------------------------------------------------------------------------------- 	}
	{	 Font container                                                                            	}
	{	 ----------------------------------------------------------------------------------------- 	}
	{
	 *  ATSGetGeneration()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION ATSGetGeneration: ATSGeneration; C;

{
 *  ATSFontActivateFromFileSpecification()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontActivateFromFileSpecification({CONST}VAR iFile: FSSpec; iContext: ATSFontContext; iFormat: ATSFontFormat; iReserved: UNIV Ptr; iOptions: ATSOptionFlags; VAR oContainer: ATSFontContainerRef): OSStatus; C;

{
 *  ATSFontActivateFromMemory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontActivateFromMemory(iData: LogicalAddress; iLength: ByteCount; iContext: ATSFontContext; iFormat: ATSFontFormat; iReserved: UNIV Ptr; iOptions: ATSOptionFlags; VAR oContainer: ATSFontContainerRef): OSStatus; C;

{
 *  ATSFontDeactivate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontDeactivate(iContainer: ATSFontContainerRef; iRefCon: UNIV Ptr; iOptions: ATSOptionFlags): OSStatus; C;

{ ----------------------------------------------------------------------------------------- }
{ Font family                                                                               }
{ ----------------------------------------------------------------------------------------- }
{
 *  ATSFontFamilyApplyFunction()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyApplyFunction(iFunction: ATSFontFamilyApplierFunction; iRefCon: UNIV Ptr): OSStatus; C;

{
 *  ATSFontFamilyIteratorCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyIteratorCreate(iContext: ATSFontContext; iFilter: {Const}ATSFontFilterPtr; iRefCon: UNIV Ptr; iOptions: ATSOptionFlags; VAR ioIterator: ATSFontFamilyIterator): OSStatus; C;

{
 *  ATSFontFamilyIteratorRelease()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyIteratorRelease(VAR ioIterator: ATSFontFamilyIterator): OSStatus; C;

{
 *  ATSFontFamilyIteratorReset()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyIteratorReset(iContext: ATSFontContext; iFilter: {Const}ATSFontFilterPtr; iRefCon: UNIV Ptr; iOptions: ATSOptionFlags; VAR ioIterator: ATSFontFamilyIterator): OSStatus; C;

{
 *  ATSFontFamilyIteratorNext()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyIteratorNext(iIterator: ATSFontFamilyIterator; VAR oFamily: ATSFontFamilyRef): OSStatus; C;

{
 *  ATSFontFamilyFindFromName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyFindFromName(iName: CFStringRef; iOptions: ATSOptionFlags): ATSFontFamilyRef; C;

{
 *  ATSFontFamilyGetGeneration()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyGetGeneration(iFamily: ATSFontFamilyRef): ATSGeneration; C;

{
 *  ATSFontFamilyGetName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyGetName(iFamily: ATSFontFamilyRef; iOptions: ATSOptionFlags; VAR oName: CFStringRef): OSStatus; C;

{
 *  ATSFontFamilyGetEncoding()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyGetEncoding(iFamily: ATSFontFamilyRef): TextEncoding; C;

{ ----------------------------------------------------------------------------------------- }
{ Font                                                                                      }
{ ----------------------------------------------------------------------------------------- }
{
 *  ATSFontApplyFunction()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontApplyFunction(iFunction: ATSFontApplierFunction; iRefCon: UNIV Ptr): OSStatus; C;

{
 *  ATSFontIteratorCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontIteratorCreate(iContext: ATSFontContext; iFilter: {Const}ATSFontFilterPtr; iRefCon: UNIV Ptr; iOptions: ATSOptionFlags; VAR ioIterator: ATSFontIterator): OSStatus; C;

{
 *  ATSFontIteratorRelease()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontIteratorRelease(VAR ioIterator: ATSFontIterator): OSStatus; C;

{
 *  ATSFontIteratorReset()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontIteratorReset(iContext: ATSFontContext; iFilter: {Const}ATSFontFilterPtr; iRefCon: UNIV Ptr; iOptions: ATSOptionFlags; VAR ioIterator: ATSFontIterator): OSStatus; C;

{
 *  ATSFontIteratorNext()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontIteratorNext(iIterator: ATSFontIterator; VAR oFont: ATSFontRef): OSStatus; C;

{
 *  ATSFontFindFromName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFindFromName(iName: CFStringRef; iOptions: ATSOptionFlags): ATSFontRef; C;

{
 *  ATSFontFindFromPostScriptName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFindFromPostScriptName(iName: CFStringRef; iOptions: ATSOptionFlags): ATSFontRef; C;

{
 *  ATSFontFindFromContainer()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFindFromContainer(iContainer: ATSFontContainerRef; iOptions: ATSOptionFlags; iCount: ItemCount; VAR ioArray: ATSFontRef; VAR oCount: ItemCount): OSStatus; C;

{
 *  ATSFontGetGeneration()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontGetGeneration(iFont: ATSFontRef): ATSGeneration; C;

{
 *  ATSFontGetName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontGetName(iFont: ATSFontRef; iOptions: ATSOptionFlags; VAR oName: CFStringRef): OSStatus; C;

{
 *  ATSFontGetPostScriptName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontGetPostScriptName(iFont: ATSFontRef; iOptions: ATSOptionFlags; VAR oName: CFStringRef): OSStatus; C;

{
 *  ATSFontGetTableDirectory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontGetTableDirectory(iFont: ATSFontRef; iBufferSize: ByteCount; ioBuffer: UNIV Ptr; VAR oSize: ByteCount): OSStatus; C;

{
 *  ATSFontGetTable()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontGetTable(iFont: ATSFontRef; iTag: FourCharCode; iOffset: ByteOffset; iBufferSize: ByteCount; ioBuffer: UNIV Ptr; VAR oSize: ByteCount): OSStatus; C;

{
 *  ATSFontGetHorizontalMetrics()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontGetHorizontalMetrics(iFont: ATSFontRef; iOptions: ATSOptionFlags; VAR oMetrics: ATSFontMetrics): OSStatus; C;

{
 *  ATSFontGetVerticalMetrics()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontGetVerticalMetrics(iFont: ATSFontRef; iOptions: ATSOptionFlags; VAR oMetrics: ATSFontMetrics): OSStatus; C;

{ ----------------------------------------------------------------------------------------- }
{ Compatibiity                                                                              }
{ ----------------------------------------------------------------------------------------- }
{
 *  ATSFontFamilyFindFromQuickDrawName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyFindFromQuickDrawName(iName: Str255): ATSFontFamilyRef; C;

{
 *  ATSFontFamilyGetQuickDrawName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontFamilyGetQuickDrawName(iFamily: ATSFontFamilyRef; VAR oName: Str255): OSStatus; C;

{
 *  ATSFontGetFileSpecification()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontGetFileSpecification(iFont: ATSFontRef; VAR oFile: FSSpec): OSStatus; C;

{
 *  ATSFontGetFontFamilyResource()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available in CarbonLib 1.x, is availble on Mac OS X version 10.0 or later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSFontGetFontFamilyResource(iFont: ATSFontRef; iBufferSize: ByteCount; ioBuffer: UNIV Ptr; VAR oSize: ByteCount): OSStatus; C;


{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := ATSFontIncludes}

{$ENDC} {__ATSFONT__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       ATSLayoutTypes.p
 
     Contains:   Apple Type Services layout public structures and constants.
 
     Version:    Technology: Mac OS 9/Carbon
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1994-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT ATSLayoutTypes;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __ATSLAYOUTTYPES__}
{$SETC __ATSLAYOUTTYPES__ := 1}

{$I+}
{$SETC ATSLayoutTypesIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __SFNTLAYOUTTYPES__}
{$I SFNTLayoutTypes.p}
{$ENDC}

{$IFC UNDEFINED __ATSTYPES__}
{$I ATSTypes.p}
{$ENDC}

{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{ --------------------------------------------------------------------------- }
{ CONSTANTS and related scalar types }
{ --------------------------------------------------------------------------- }
{ Miscellaneous constants }

CONST
	kATSUseLineHeight			= $7FFFFFFF;					{  assignment to use natural line ascent/descent values  }
	kATSNoTracking				= $80000000;					{  negativeInfinity  }


TYPE
	ATSLineLayoutOptions				= UInt32;

CONST
	kATSLineNoLayoutOptions		= $00000000;					{  no options  }
	kATSLineIsDisplayOnly		= $00000001;					{  specifies to optimize for displaying text only  }
	kATSLineHasNoHangers		= $00000002;					{  specifies that no hangers to be formed on the line  }
	kATSLineHasNoOpticalAlignment = $00000004;					{  specifies that no optical alignment to be performed on the line  }
	kATSLineKeepSpacesOutOfMargin = $00000008;					{  specifies that space charcters should not be treated as hangers  }
	kATSLineNoSpecialJustification = $00000010;					{  specifies no post-compensation justification is to be performed  }
	kATSLineLastNoJustification	= $00000020;					{  specifies that if the line is the last of a paragraph, it will not get justified  }
	kATSLineFractDisable		= $00000040;					{  specifies that the displayed line glyphs will adjust for device metrics  }
	kATSLineImposeNoAngleForEnds = $00000080;					{  specifies that the carets at the ends of the line will be guarenteed to be perpendicular to the baseline  }
	kATSLineFillOutToWidth		= $00000100;					{  highlights for the line end characters will be extended to 0 and the specified line width  }
	kATSLineTabAdjustEnabled	= $00000200;					{  specifies that the tab character width will be automatically adjusted to fit the specified line width  }
	kATSLineAppleReserved		= $FFFFFC00;					{  these bits are reserved by Apple and will result in a invalid value error if attemped to set  }


TYPE
	ATSStyleRenderingOptions			= UInt32;

CONST
	kATSStyleNoOptions			= $00000000;					{  no options  }
	kATSStyleApplyHints			= $00000001;					{  specifies that ATS produce "hinted" glyph outlines (default is on)  }
																{     kATSStyleApplyAntiAliasing           = 0x00000002L,  /* specifies that ATS produce antialiased glyph images (default is on) future feature */ }
	kATSStyleAppleReserved		= $FFFFFFFE;					{  these bits are reserved by Apple and will result in a invalid value error if attemped to set  }

	{	 For accessing glyph bounds 	}
	kATSUseCaretOrigins			= 0;
	kATSUseDeviceOrigins		= 1;
	kATSUseFractionalOrigins	= 2;
	kATSUseOriginFlags			= 3;

	{	 --------------------------------------------------------------------------- 	}
	{	 STRUCTURED TYPES and related constants 	}
	{	 --------------------------------------------------------------------------- 	}

	{	
	    The ATSTrapezoid structure supplies a convenient container
	    for glyph bounds in trapezoidal form.
		}

TYPE
	ATSTrapezoidPtr = ^ATSTrapezoid;
	ATSTrapezoid = RECORD
		upperLeft:				FixedPoint;
		upperRight:				FixedPoint;
		lowerRight:				FixedPoint;
		lowerLeft:				FixedPoint;
	END;

	{	
	    The JustWidthDeltaEntryOverride structure specifies values for the grow and shrink case during
	    justification, both on the left and on the right. It also contains flags.  This particular structure
	    is used for passing justification overrides to LLC.  For further sfnt resource 'just' table
	    constants and structures, see SFNTLayoutTypes.h.
		}
	ATSJustWidthDeltaEntryOverridePtr = ^ATSJustWidthDeltaEntryOverride;
	ATSJustWidthDeltaEntryOverride = RECORD
		beforeGrowLimit:		Fixed;									{  ems AW can grow by at most on LT  }
		beforeShrinkLimit:		Fixed;									{  ems AW can shrink by at most on LT  }
		afterGrowLimit:			Fixed;									{  ems AW can grow by at most on RB  }
		afterShrinkLimit:		Fixed;									{  ems AW can shrink by at most on RB  }
		growFlags:				JustificationFlags;						{  flags controlling grow case  }
		shrinkFlags:			JustificationFlags;						{  flags controlling shrink case  }
	END;

	{	 The JustPriorityOverrides type is an array of 4 width delta records, one per priority level override. 	}
	ATSJustPriorityWidthDeltaOverrides	= ARRAY [0..3] OF ATSJustWidthDeltaEntryOverride;
	{	 --------------------------------------------------------------------------- 	}
{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := ATSLayoutTypesIncludes}

{$ENDC} {__ATSLAYOUTTYPES__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       ATSTypes.p
 
     Contains:   Public interfaces for Apple Type Services components.
 
     Version:    Technology: CarbonLib 1.1
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1997-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT ATSTypes;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __ATSTYPES__}
{$SETC __ATSTYPES__ := 1}

{$I+}
{$SETC ATSTypesIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __FILES__}
{$I Files.p}
{$ENDC}
{$IFC UNDEFINED __MIXEDMODE__}
{$I MixedMode.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
	FMGeneration						= UInt32;
	{	 The FMFontFamily reference represents a collection of fonts with the same design
	   characteristics. It replaces the standard QuickDraw font identifer and may be used
	   with all QuickDraw functions including GetFontName and TextFont. It cannot be used
	   with the Resource Manager to access information from a FOND resource handle. A font
	   reference does not imply a particular script system, nor is the character encoding
	   of a font family determined by an arithmetic mapping of its value.
		}
	FMFontFamily						= SInt16;
	FMFontStyle							= SInt16;
	FMFontSize							= SInt16;
	{	 
	   The font family is a collection of fonts, each of which is identified
	   by an FMFont reference that maps to a single object registered with
	   the font database. The font references associated with the font
	   family consist of individual outline and bitmapped fonts that may be
	   used with the font access routines of the Font Manager and ATS.
		}
	FMFont								= UInt32;
	FMFontFamilyInstancePtr = ^FMFontFamilyInstance;
	FMFontFamilyInstance = RECORD
		fontFamily:				FMFontFamily;
		fontStyle:				FMFontStyle;
	END;

	FMFontFamilyIteratorPtr = ^FMFontFamilyIterator;
	FMFontFamilyIterator = RECORD
		reserved:				ARRAY [0..15] OF UInt32;
	END;

	FMFontIteratorPtr = ^FMFontIterator;
	FMFontIterator = RECORD
		reserved:				ARRAY [0..15] OF UInt32;
	END;

	FMFontFamilyInstanceIteratorPtr = ^FMFontFamilyInstanceIterator;
	FMFontFamilyInstanceIterator = RECORD
		reserved:				ARRAY [0..15] OF UInt32;
	END;


CONST
	kInvalidGeneration			= 0;
	kInvalidFontFamily			= -1;
	kInvalidFont				= 0;

	kFMCurrentFilterFormat		= 0;

	kFMDefaultOptions			= 0;
	kFMUseGlobalScopeOption		= $00000001;


TYPE
	FMFilterSelector 			= UInt32;
CONST
	kFMFontTechnologyFilterSelector = 1;
	kFMFontContainerFilterSelector = 2;
	kFMGenerationFilterSelector	= 3;
	kFMFontFamilyCallbackFilterSelector = 4;
	kFMFontCallbackFilterSelector = 5;
	kFMFontDirectoryFilterSelector = 6;

	kFMTrueTypeFontTechnology	= 'true';
	kFMPostScriptFontTechnology	= 'typ1';


TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	FMFontFamilyCallbackFilterProcPtr = FUNCTION(iFontFamily: FMFontFamily; iRefCon: UNIV Ptr): OSStatus;
{$ELSEC}
	FMFontFamilyCallbackFilterProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	FMFontCallbackFilterProcPtr = FUNCTION(iFont: FMFont; iRefCon: UNIV Ptr): OSStatus;
{$ELSEC}
	FMFontCallbackFilterProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	FMFontFamilyCallbackFilterUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	FMFontFamilyCallbackFilterUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	FMFontCallbackFilterUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	FMFontCallbackFilterUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppFMFontFamilyCallbackFilterProcInfo = $000003B0;
	uppFMFontCallbackFilterProcInfo = $000003F0;
	{
	 *  NewFMFontFamilyCallbackFilterUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewFMFontFamilyCallbackFilterUPP(userRoutine: FMFontFamilyCallbackFilterProcPtr): FMFontFamilyCallbackFilterUPP; { old name was NewFMFontFamilyCallbackFilterProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewFMFontCallbackFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewFMFontCallbackFilterUPP(userRoutine: FMFontCallbackFilterProcPtr): FMFontCallbackFilterUPP; { old name was NewFMFontCallbackFilterProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeFMFontFamilyCallbackFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeFMFontFamilyCallbackFilterUPP(userUPP: FMFontFamilyCallbackFilterUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeFMFontCallbackFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeFMFontCallbackFilterUPP(userUPP: FMFontCallbackFilterUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeFMFontFamilyCallbackFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeFMFontFamilyCallbackFilterUPP(iFontFamily: FMFontFamily; iRefCon: UNIV Ptr; userRoutine: FMFontFamilyCallbackFilterUPP): OSStatus; { old name was CallFMFontFamilyCallbackFilterProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeFMFontCallbackFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeFMFontCallbackFilterUPP(iFont: FMFont; iRefCon: UNIV Ptr; userRoutine: FMFontCallbackFilterUPP): OSStatus; { old name was CallFMFontCallbackFilterProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}


TYPE
	FMFontDirectoryFilterPtr = ^FMFontDirectoryFilter;
	FMFontDirectoryFilter = RECORD
		fontFolderDomain:		SInt16;
		reserved:				ARRAY [0..1] OF UInt32;
	END;

	FMFilterPtr = ^FMFilter;
	FMFilter = RECORD
		format:					UInt32;
		selector:				FMFilterSelector;
		CASE INTEGER OF
		0: (
			fontTechnologyFilter: FourCharCode;
			);
		1: (
			fontContainerFilter: FSSpec;
			);
		2: (
			generationFilter:	FMGeneration;
			);
		3: (
			fontFamilyCallbackFilter: FMFontFamilyCallbackFilterUPP;
			);
		4: (
			fontCallbackFilter:	FMFontCallbackFilterUPP;
			);
		5: (
			fontDirectoryFilter: FMFontDirectoryFilter;
			);
	END;

	ATSOptionFlags						= OptionBits;
	ATSGeneration						= UInt32;
	ATSFontContainerRef					= UInt32;
	ATSFontFamilyRef					= UInt32;
	ATSFontRef							= UInt32;
	ATSGlyphRef							= UInt16;
	ATSFontSize							= Float32;

CONST
	kATSGenerationUnspecified	= 0;
	kATSFontContainerRefUnspecified = 0;
	kATSFontFamilyRefUnspecified = 0;
	kATSFontRefUnspecified		= 0;


TYPE
	ATSFontMetricsPtr = ^ATSFontMetrics;
	ATSFontMetrics = RECORD
		version:				UInt32;
		ascent:					Float32;								{  Maximum height above baseline reached by the glyphs in the font  }
																		{  or maximum distance to the right of the centerline reached by the glyphs in the font  }
		descent:				Float32;								{  Maximum depth below baseline reached by the glyphs in the font  }
																		{  or maximum distance to the left of the centerline reached by the glyphs in the font  }
		leading:				Float32;								{  Desired spacing between lines of text  }
		avgAdvanceWidth:		Float32;
		maxAdvanceWidth:		Float32;								{  Maximum advance width or height of the glyphs in the font  }
		minLeftSideBearing:		Float32;								{  Minimum left or top side bearing  }
		minRightSideBearing:	Float32;								{  Minimum right or bottom side bearing  }
		stemWidth:				Float32;								{  Width of the dominant vertical stems of the glyphs in the font  }
		stemHeight:				Float32;								{  Vertical width of the dominant horizontal stems of glyphs in the font  }
		capHeight:				Float32;								{  Height of a capital letter from the baseline to the top of the letter  }
		xHeight:				Float32;								{  Height of lowercase characters in a font, specifically the letter x, excluding ascenders and descenders  }
		italicAngle:			Float32;								{  Angle in degrees counterclockwise from the vertical of the dominant vertical strokes of the glyphs in the font  }
		underlinePosition:		Float32;								{  Distance from the baseline for positioning underlining strokes  }
		underlineThickness:		Float32;								{  Stroke width for underlining  }
	END;


CONST
	kATSItalicQDSkew			= $00004000;					{  fixed value of 0.25  }
	kATSBoldQDStretch			= $00018000;					{  fixed value of 1.50  }
	kATSRadiansFactor			= 1144;							{  fixed value of approx. pi/180 (0.0174560546875)  }

	{	 Glyph outline path constants used in ATSFontGetNativeCurveType. 	}

TYPE
	ATSCurveType 				= UInt16;
CONST
	kATSCubicCurveType			= $0001;
	kATSQuadCurveType			= $0002;
	kATSOtherCurveType			= $0003;


TYPE
	ATSUCurvePathPtr = ^ATSUCurvePath;
	ATSUCurvePath = RECORD
		vectors:				UInt32;
		controlBits:			ARRAY [0..0] OF UInt32;
		vector:					ARRAY [0..0] OF Float32Point;
	END;

	ATSUCurvePathsPtr = ^ATSUCurvePaths;
	ATSUCurvePaths = RECORD
		contours:				UInt32;
		contour:				ARRAY [0..0] OF ATSUCurvePath;
	END;

	{	 Glyph ideal metrics 	}
	ATSGlyphIdealMetricsPtr = ^ATSGlyphIdealMetrics;
	ATSGlyphIdealMetrics = RECORD
		advance:				Float32Point;
		sideBearing:			Float32Point;
		otherSideBearing:		Float32Point;
	END;

	{	 Glyph screen metrics 	}
	ATSGlyphScreenMetricsPtr = ^ATSGlyphScreenMetrics;
	ATSGlyphScreenMetrics = RECORD
		deviceAdvance:			Float32Point;
		topLeft:				Float32Point;
		height:					UInt32;
		width:					UInt32;
		sideBearing:			Float32Point;
		otherSideBearing:		Float32Point;
	END;

	GlyphID								= ATSGlyphRef;
{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := ATSTypesIncludes}

{$ENDC} {__ATSTYPES__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       ATSUnicode.p
 
     Contains:   Public interfaces for Apple Type Services for Unicode Imaging
 
     Version:    Technology: Mac OS 9 / Carbon
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1997-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT ATSUnicode;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __ATSUNICODE__}
{$SETC __ATSUNICODE__ := 1}

{$I+}
{$SETC ATSUnicodeIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __MACERRORS__}
{$I MacErrors.p}
{$ENDC}
{$IFC UNDEFINED __MACMEMORY__}
{$I MacMemory.p}
{$ENDC}
{$IFC UNDEFINED __ATSLAYOUTTYPES__}
{$I ATSLayoutTypes.p}
{$ENDC}
{$IFC UNDEFINED __FONTS__}
{$I Fonts.p}
{$ENDC}
{$IFC UNDEFINED __QUICKDRAW__}
{$I Quickdraw.p}
{$ENDC}
{$IFC UNDEFINED __SFNTTYPES__}
{$I SFNTTypes.p}
{$ENDC}
{$IFC UNDEFINED __SFNTLAYOUTTYPES__}
{$I SFNTLayoutTypes.p}
{$ENDC}
{$IFC UNDEFINED __TEXTCOMMON__}
{$I TextCommon.p}
{$ENDC}
{$IFC UNDEFINED __ATSTYPES__}
{$I ATSTypes.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{******************************}
{  Types and related constants }
{******************************}
{
   UniCharArrayHandle and UniCharArrayOffset are defined in the
   TextCommon interface file.
}

{
    ATSUTextMeasurement is specific to ATSUI in that measurement
    quantities are in fractional Fixed format instead of shorts
    used in QuickDraw Text.  This provides exact outline metrics and
    line specifications such as line width, ascent, descent, and so on.  
}

TYPE
	ATSUTextMeasurement					= Fixed;
	{
	    ATSUFontID indicates a particular font family and face.  
	    ATSUFontID's are not guaranteed to remain constant across 
	    reboots.  Clients should use the font's unique name to 
	    get a font token to store in documents which is 
	    guaranteed to remain constant across reboots. 
	}
	ATSUFontID							= FMFont;
	{
	    ATSUFontFeatureType and ATSUFontFeatureSelector are used 
	    to identify font features.  
	}
	ATSUFontFeatureType					= UInt16;
	ATSUFontFeatureSelector				= UInt16;
	{
	    ATSUFontVariationAxis and ATSUFontVariationValue are used 
	    in connection with font variations.  
	}
	ATSUFontVariationAxis				= FourCharCode;
	ATSUFontVariationValue				= Fixed;
	{  Ptr types }
	ATSUFontFeatureTypePtr				= ^ATSUFontFeatureType;
	ATSUFontFeatureSelectorPtr			= ^ATSUFontFeatureSelector;
	ATSUFontVariationAxisPtr			= ^ATSUFontVariationAxis;
	ATSUFontVariationValuePtr			= ^ATSUFontVariationValue;
	{
	    ATSUTextLayout is used to store the attribute information 
	    associated with a contiguous block of UniChar's (UInt16's) 
	    in memory.  It's typed to be an opaque structure.  
	}
	ATSUTextLayout    = ^LONGINT; { an opaque 32-bit type }
	ATSUTextLayoutPtr = ^ATSUTextLayout;  { when a VAR xx:ATSUTextLayout parameter can be nil, it is changed to xx: ATSUTextLayoutPtr }
	{
	    ATSUStyle is used to store a set of individual attributes, 
	    font features, and font variations.  It's typed to be 
	    an opaque structure.  
	}
	ATSUStyle    = ^LONGINT; { an opaque 32-bit type }
	ATSUStylePtr = ^ATSUStyle;  { when a VAR xx:ATSUStyle parameter can be nil, it is changed to xx: ATSUStylePtr }
	{
	    ATSUAttributeTag is used to indicate the particular type 
	    of attribute under consideration:  font, size, color, 
	    and so on.  
	    Each style run may have at most one attribute with a 
	    given ATSUAttributeTag (i.e., a style run can't have 
	    more than one font or size) but may have none.  
	    Note: Apple reserves values 0 to 65,535 (0 to 0x0000FFFF).
	    ATSUI clients may create their own tags with any other value.
	}
	ATSUAttributeTag 			= UInt32;
CONST
																{     Layout and Line Control Attribute Tags }
	kATSULineWidthTag			= 1;							{     Type:       ATSUTextMeasurement }
																{     Default value: 0 }
	kATSULineRotationTag		= 2;							{     Type:       Fixed (fixed value in degrees in right-handed coordinate system) }
																{     Default value: 0 }
	kATSULineDirectionTag		= 3;							{     Type:       Boolean; values 0 or 1 (see below for value identities) }
																{     Default value: GetSysDirection() ? kATSURightToLeftBaseDirection : kATSULeftToRightBaseDirection }
	kATSULineJustificationFactorTag = 4;						{     Type:       Fract between 0 and 1 }
																{     Default value: kATSUNoJustification }
	kATSULineFlushFactorTag		= 5;							{     Type:       Fract between 0 and 1  }
																{     Default value: kATSUStartAlignment }
	kATSULineBaselineValuesTag	= 6;							{     Type:       BslnBaselineRecord }
																{     Default value: All zeros.  Calculated from other style attributes (e.g., font and point size) }
	kATSULineLayoutOptionsTag	= 7;							{     Type:       ATSLineLayoutOptions (see ATSLayoutTypes.h) }
																{     Default value: kATSLineNoLayoutOptions - other options listed in ATSLayoutTypes.h }
	kATSULineAscentTag			= 8;							{     Type:       ATSUTextMeasurement }
																{     Default value: kATSUseLineHeight }
	kATSULineDescentTag			= 9;							{     Type:       ATSUTextMeasurement }
																{     Default value: kATSUseLineHeight }
	kATSULineLangRegionTag		= 10;							{     Type:       RegionCode - region values listed in script.h interface file }
																{     Default value: kTextRegionDontCare }
	kATSULineTextLocatorTag		= 11;							{     Type:       TextBreakLocatorRef }
																{     Default value: NULL - set Region derived locator or the default Text Utilities locator }
	kATSULineTruncationTag		= 12;							{     Type:       ATSULineTruncation }
																{     Default value: kATSUTruncateNone                                                        }
	kATSULineFontFallbacksTag	= 13;							{     Type:       ATSUFontFallbacks }
																{     Default value: globally set font fallbacks using the ATSUSetFontFallbacks                                                      }
	kATSUMaxLineTag				= 14;							{     This is just for convenience - the upper limit of the ATSUTextLayout attribute tags }
																{  obsolete layout tags  }
	kATSULineLanguageTag		= 10;							{     Use kATSULineLangRegionTag            }
																{     Run Style Attribute Tags }
																{  QuickDraw compatibility tags  }
	kATSUQDBoldfaceTag			= 256;							{     Type:       Boolean     }
																{     Default value: false }
	kATSUQDItalicTag			= 257;							{     Type:       Boolean        }
																{     Default value: false }
	kATSUQDUnderlineTag			= 258;							{     Type:       Boolean     }
																{     Default value: false }
	kATSUQDCondensedTag			= 259;							{     Type:       Boolean     }
																{     Default value: false }
	kATSUQDExtendedTag			= 260;							{     Type:       Boolean     }
																{     Default value: false }
																{  Common run tags  }
	kATSUFontTag				= 261;							{     Type:       ATSUFontID  }
																{     Default value: GetScriptVariable( smSystemScript, smScriptAppFond ) }
	kATSUSizeTag				= 262;							{     Type:       Fixed   }
																{     Default value: GetScriptVariable( smSystemScript, smScriptAppFondSize )     }
	kATSUColorTag				= 263;							{     Type:       RGBColor    }
																{     Default value: (0, 0, 0) }
																{     Less common run tags  }
	kATSULangRegionTag			= 264;							{     Type:       RegionCode - region values listed in script.h interface file }
																{     Default value: GetScriptManagerVariable( smRegionCode ) }
	kATSUVerticalCharacterTag	= 265;							{     Type:       ATSUVerticalCharacterType   }
																{     Default value: kATSUStronglyHorizontal }
	kATSUImposeWidthTag			= 266;							{     Type:       ATSUTextMeasurement }
																{     Default value: 0 - all glyphs use their own font defined advance widths }
	kATSUBeforeWithStreamShiftTag = 267;						{     Type:       Fixed }
																{     Default value: 0 }
	kATSUAfterWithStreamShiftTag = 268;							{     Type:       Fixed }
																{     Default value: 0 }
	kATSUCrossStreamShiftTag	= 269;							{     Type:       Fixed }
																{     Default value: 0 }
	kATSUTrackingTag			= 270;							{     Type:       Fixed }
																{     Default value: kATSNoTracking }
	kATSUHangingInhibitFactorTag = 271;							{     Type:       Fract between 0 and 1 }
																{     Default value: 0 }
	kATSUKerningInhibitFactorTag = 272;							{     Type:       Fract between 0 and 1 }
																{     Default value: 0 }
	kATSUDecompositionFactorTag	= 273;							{     Type:       Fixed (-1.0 -> 1.0) }
																{     Default value: 0 }
	kATSUBaselineClassTag		= 274;							{     Type:       BslnBaselineClass  (see SFNTLayoutTypes.h) }
																{     Default value: kBSLNRomanBaseline - set to kBSLNNoBaselineOverride to use intrinsic baselines }
	kATSUPriorityJustOverrideTag = 275;							{     Type:       ATSJustPriorityWidthDeltaOverrides (see ATSLayoutTypes.h) }
																{     Default value: all zeros }
	kATSUNoLigatureSplitTag		= 276;							{     Type:       Boolean }
																{     Default value: false - ligatures and compound characters have divisable components. }
	kATSUNoCaretAngleTag		= 277;							{     Type:       Boolean }
																{     Default value: false - use the character's angularity to determine its boundaries }
	kATSUSuppressCrossKerningTag = 278;							{     Type:       Boolean }
																{     Default value: false - do not suppress automatic cross kerning (defined by font) }
	kATSUNoOpticalAlignmentTag	= 279;							{     Type:       Boolean }
																{     Default value: false - do not suppress character's automatic optical positional alignment }
	kATSUForceHangingTag		= 280;							{     Type:       Boolean }
																{     Default value: false - do not force the character's to hang beyond the line boundaries }
	kATSUNoSpecialJustificationTag = 281;						{     Type:       Boolean }
																{     Default value: false - perform post-compensation justification if needed }
	kATSUStyleTextLocatorTag	= 282;							{     Type:       TextBreakLocatorRef }
																{     Default value: NULL - region derived locator or the default Text Utilities locator }
	kATSUStyleRenderingOptionsTag = 283;						{     Type:       ATSStyleRenderingOptions (see ATSLayoutTypes.h) }
																{     Default value: kATSStyleApplyHints - ATS glyph rendering uses hinting }
	kATSUMaxStyleTag			= 284;							{     This is just for convenience - the upper limit of the ATSUStyle attribute tags  }
																{  obsolete style tags  }
	kATSULanguageTag			= 264;							{     use kATSULangRegionTag                }
																{  special layout tag for Mac OS X  }
	kATSUCGContextTag			= 32767;						{   Type:          CGContext, Default value:    NULL    }
																{  max  }
	kATSUMaxATSUITagValue		= 65535;						{     This is the maximum Apple ATSUI reserved tag value.  Client defined tags must be larger. }

	{
	    ATSUAttributeValuePtr is used to provide generic access to
	    storage of attribute values, which vary in size.
	    ConstATSUAttributeValuePtr is a pointer to a const attribute value.
	}

TYPE
	ATSUAttributeValuePtr				= Ptr;
	ConstATSUAttributeValuePtr			= Ptr;
	{
	    ATSUAttributeInfo is used to provide a tag/size pairing.  
	    This makes it possible to provide the client information   
	    about all the attributes for a given range of text.  This   
	    structure is only used to return to the client information   
	    about a complete set of attributes.  An array of   
	    ATSUAttributeInfos is passed as a parameter so that the   
	    client can find out what attributes are set and what their   
	    individual sizes are; with that information, they can then   
	    query about the values of the attributes they're interested   
	    in.  Because arrays of ATSUAttributeInfos are used as parameters   
	    to functions, they have to be of a fixed size, hence the   
	    value is not included in the structure.  
	}
	ATSUAttributeInfoPtr = ^ATSUAttributeInfo;
	ATSUAttributeInfo = RECORD
		fTag:					ATSUAttributeTag;
		fValueSize:				ByteCount;
	END;

	{
	    ATSUCaret contains the complete information needed to render a
	    caret.  fX and fY is the position of one of the caret's ends
	    relative to the origin position of the line the caret belongs.
	    fDeltaX and fDeltaY is the position of the caret's other end.
	    Hence, to draw a caret, simply call MoveTo(fX, fY) followed by
	    LineTo(fDeltaX, fDeltaY) or equivalent.  The ATSUCaret will
	    contain the positions needed to draw carets on angled lines
	    and reflect angled carets and leading/trailing split caret
	    appearances.
	}
	ATSUCaretPtr = ^ATSUCaret;
	ATSUCaret = RECORD
		fX:						Fixed;
		fY:						Fixed;
		fDeltaX:				Fixed;
		fDeltaY:				Fixed;
	END;

	{
	    ATSUCursorMovementType is used to indicate how much to move
	    the cursor when using the ATSUI cusor movement routines. 
	    Note that kATSUByCharacterCluster is only available in Mac OS X
	    and in CarbonLib versions 1.3 and later.
	}
	ATSUCursorMovementType 		= UInt16;
CONST
	kATSUByCharacter			= 0;
	kATSUByTypographicCluster	= 1;							{  clusters based on characters or ligatures }
	kATSUByWord					= 2;
	kATSUByCharacterCluster		= 3;							{  clusters based on characters only }
	kATSUByCluster				= 1;							{  obsolete name for kATSUByTypographicCluster }

	{
	    ATSULineTruncation is for identifying where truncation will occur when
	    using a ATSUTextLayout with the ATSULineTruncation layout attribute.
	}

TYPE
	ATSULineTruncation 			= UInt32;
CONST
	kATSUTruncateNone			= 0;
	kATSUTruncateStart			= 1;
	kATSUTruncateEnd			= 2;
	kATSUTruncateMiddle			= 3;

	{
	    ATSUVerticalCharacterType currently can take two values 
	    and is used to indicate whether text is to be laid out 
	    as vertical glyphs or horizontal glyphs.  
	}

TYPE
	ATSUVerticalCharacterType 	= UInt16;
CONST
	kATSUStronglyHorizontal		= 0;
	kATSUStronglyVertical		= 1;


	{
	    ATSUStyleComparison is an enumeration with four values, 
	    and is used by ATSUCompareStyles() to indicate if the
	    first style parameter contains as a proper subset, is
	    equal to, or is contained by the second style parameter.
	}

TYPE
	ATSUStyleComparison 		= UInt16;
CONST
	kATSUStyleUnequal			= 0;
	kATSUStyleContains			= 1;
	kATSUStyleEquals			= 2;
	kATSUStyleContainedBy		= 3;


	{
	    ATSUFontFallbackMethod type defines the method by which ATSUI will try to
	    find an appropriate font for a character if the assigned font does not
	    contain the needed glyph(s) to represent it.  This affects ATSUMatchFontsToText
	    and font selection during layout and drawing when ATSUSetTransientFontMatching
	    is set ON.
	}

TYPE
	ATSUFontFallbackMethod 		= UInt16;
CONST
	kATSUDefaultFontFallbacks	= 0;
	kATSULastResortOnlyFallback	= 1;
	kATSUSequentialFallbacksPreferred = 2;
	kATSUSequentialFallbacksExclusive = 3;


{$IFC CALL_NOT_IN_CARBON }
	{
	    ATSUMemoryCallbacks is a union struct that allows the ATSUI 
	    client to specify a specific heap for ATSUI use or allocation
	    callbacks of which ATSUI is to use each time ATSUI performs a
	    memory operation (alloc, grow, free).
	}

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	ATSUCustomAllocFunc = FUNCTION(refCon: UNIV Ptr; howMuch: ByteCount): Ptr; C;
{$ELSEC}
	ATSUCustomAllocFunc = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATSUCustomFreeFunc = PROCEDURE(refCon: UNIV Ptr; doomedBlock: UNIV Ptr); C;
{$ELSEC}
	ATSUCustomFreeFunc = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATSUCustomGrowFunc = FUNCTION(refCon: UNIV Ptr; oldBlock: UNIV Ptr; oldSize: ByteCount; newSize: ByteCount): Ptr; C;
{$ELSEC}
	ATSUCustomGrowFunc = ProcPtr;
{$ENDC}

	ATSUMemoryCallbacksPtr = ^ATSUMemoryCallbacks;
	ATSUMemoryCallbacks = RECORD
		CASE INTEGER OF
		0: (
			Alloc:				ATSUCustomAllocFunc;
			Free:				ATSUCustomFreeFunc;
			Grow:				ATSUCustomGrowFunc;
			memoryRefCon:		Ptr;
		   );
		1: (
			heapToUse:			THz;
			);
	END;

	{
	    ATSUHeapSpec provides the ATSUI client a means of specifying the heap
	    from which ATSUI should allocate its dynamic memory or specifying
	    that ATSUI should use the memory callback provided by the client.
	}
	ATSUHeapSpec 				= UInt16;
CONST
	kATSUUseCurrentHeap			= 0;
	kATSUUseAppHeap				= 1;
	kATSUUseSpecificHeap		= 2;
	kATSUUseCallbacks			= 3;


	{
	    ATSUMemorySetting is used to store the results from a ATSUSetMemoryAlloc
	    or a ATSUGetCurrentMemorySetting call.  It can also be used to change the
	    current ATSUMemorySetting by passing it into the ATSUSetCurrentMemorySetting
	    call.
	}

TYPE
	ATSUMemorySetting    = ^LONGINT; { an opaque 32-bit type }
	ATSUMemorySettingPtr = ^ATSUMemorySetting;  { when a VAR xx:ATSUMemorySetting parameter can be nil, it is changed to xx: ATSUMemorySettingPtr }
{$ENDC}  {CALL_NOT_IN_CARBON}

{ Types for ATSUI Low Level API }

TYPE
	ATSUGlyphInfoPtr = ^ATSUGlyphInfo;
	ATSUGlyphInfo = RECORD
		glyphID:				GlyphID;
		reserved:				UInt16;
		layoutFlags:			UInt32;
		charIndex:				UniCharArrayOffset;
		style:					ATSUStyle;
		deltaY:					Float32;
		idealX:					Float32;
		screenX:				SInt16;
		caretX:					SInt16;
	END;

	ATSUGlyphInfoArrayPtr = ^ATSUGlyphInfoArray;
	ATSUGlyphInfoArray = RECORD
		layout:					ATSUTextLayout;
		numGlyphs:				ItemCount;
		glyphs:					ARRAY [0..0] OF ATSUGlyphInfo;
	END;

	{	******************	}
	{	  Other constants 	}
	{	******************	}
	{	 Line direction types (used for kATSULineDirectionTag values) 	}

CONST
	kATSULeftToRightBaseDirection = 0;							{     Impose left-to-right or top-to-bottom dominant direction  }
	kATSURightToLeftBaseDirection = 1;							{     Impose right-to-left or bottom-to-top dominant direction  }

	{	 LineFlushFactor convenience defined values 	}
	kATSUStartAlignment			= $00000000;
	kATSUEndAlignment			= $40000000;
	kATSUCenterAlignment		= $20000000;

	{	 LineJustificationFactor convenience defined values 	}
	kATSUNoJustification		= $00000000;
	kATSUFullJustification		= $40000000;

	{	 Other constants  	}
	kATSUInvalidFontID			= 0;


	kATSUUseLineControlWidth	= $7FFFFFFF;


	kATSUNoSelector				= $0000FFFF;


	kATSUUseGrafPortPenLoc		= $FFFFFFFF;
	kATSUClearAll				= $FFFFFFFF;


	kATSUFromTextBeginning		= $FFFFFFFF;
	kATSUToTextEnd				= $FFFFFFFF;


	{	**************	}
	{	  Functions   	}
	{	**************	}

	{	  Clipboard support, flattened style version 0 (it is advised to not use these routines and perform your own flattening)  	}
	{
	 *  ATSUCopyToHandle()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION ATSUCopyToHandle(iStyle: ATSUStyle; oStyleHandle: Handle): OSStatus; C;

{
 *  ATSUPasteFromHandle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUPasteFromHandle(iStyle: ATSUStyle; iStyleHandle: Handle): OSStatus; C;

{  Memory allocation specification functions (not in Carbon)   }
{$IFC CALL_NOT_IN_CARBON }
{
 *  ATSUCreateMemorySetting()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATSUCreateMemorySetting(iHeapSpec: ATSUHeapSpec; VAR iMemoryCallbacks: ATSUMemoryCallbacks; VAR oMemorySetting: ATSUMemorySetting): OSStatus; C;

{
 *  ATSUSetCurrentMemorySetting()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATSUSetCurrentMemorySetting(iMemorySetting: ATSUMemorySetting): OSStatus; C;

{
 *  ATSUGetCurrentMemorySetting()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATSUGetCurrentMemorySetting: ATSUMemorySetting; C;

{
 *  ATSUDisposeMemorySetting()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION ATSUDisposeMemorySetting(iMemorySetting: ATSUMemorySetting): OSStatus; C;

{$ENDC}  {CALL_NOT_IN_CARBON}

{  Basic style functions   }
{
 *  ATSUCreateStyle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCreateStyle(VAR oStyle: ATSUStyle): OSStatus; C;

{
 *  ATSUCreateAndCopyStyle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCreateAndCopyStyle(iStyle: ATSUStyle; VAR oStyle: ATSUStyle): OSStatus; C;

{
 *  ATSUDisposeStyle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUDisposeStyle(iStyle: ATSUStyle): OSStatus; C;

{
 *  ATSUSetStyleRefCon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetStyleRefCon(iStyle: ATSUStyle; iRefCon: UInt32): OSStatus; C;

{
 *  ATSUGetStyleRefCon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetStyleRefCon(iStyle: ATSUStyle; VAR oRefCon: UInt32): OSStatus; C;

{  Style comparison        }
{
 *  ATSUCompareStyles()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCompareStyles(iFirstStyle: ATSUStyle; iSecondStyle: ATSUStyle; VAR oComparison: ATSUStyleComparison): OSStatus; C;

{  Attribute manipulations }
{
 *  ATSUCopyAttributes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCopyAttributes(iSourceStyle: ATSUStyle; iDestinationStyle: ATSUStyle): OSStatus; C;

{
 *  ATSUOverwriteAttributes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUOverwriteAttributes(iSourceStyle: ATSUStyle; iDestinationStyle: ATSUStyle): OSStatus; C;

{
 *  ATSUUnderwriteAttributes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUUnderwriteAttributes(iSourceStyle: ATSUStyle; iDestinationStyle: ATSUStyle): OSStatus; C;

{  Empty styles    }
{
 *  ATSUClearStyle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUClearStyle(iStyle: ATSUStyle): OSStatus; C;

{
 *  ATSUStyleIsEmpty()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUStyleIsEmpty(iStyle: ATSUStyle; VAR oIsClear: BOOLEAN): OSStatus; C;

{  Get and set attributes }
{
 *  ATSUCalculateBaselineDeltas()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCalculateBaselineDeltas(iStyle: ATSUStyle; iBaselineClass: BslnBaselineClass; VAR oBaselineDeltas: BslnBaselineRecord): OSStatus; C;

{
 *  ATSUSetAttributes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetAttributes(iStyle: ATSUStyle; iAttributeCount: ItemCount; {CONST}VAR iTag: ATSUAttributeTag; {CONST}VAR iValueSize: ByteCount; {CONST}VAR iValue: ATSUAttributeValuePtr): OSStatus; C;

{
 *  ATSUGetAttribute()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetAttribute(iStyle: ATSUStyle; iTag: ATSUAttributeTag; iExpectedValueSize: ByteCount; oValue: ATSUAttributeValuePtr; VAR oActualValueSize: ByteCount): OSStatus; C;

{
 *  ATSUGetAllAttributes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetAllAttributes(iStyle: ATSUStyle; VAR oAttributeInfoArray: ATSUAttributeInfo; iTagValuePairArraySize: ItemCount; VAR oTagValuePairCount: ItemCount): OSStatus; C;

{
 *  ATSUClearAttributes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUClearAttributes(iStyle: ATSUStyle; iTagCount: ItemCount; {CONST}VAR iTag: ATSUAttributeTag): OSStatus; C;

{  Font features   }
{
 *  ATSUSetFontFeatures()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetFontFeatures(iStyle: ATSUStyle; iFeatureCount: ItemCount; {CONST}VAR iType: ATSUFontFeatureType; {CONST}VAR iSelector: ATSUFontFeatureSelector): OSStatus; C;

{
 *  ATSUGetFontFeature()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontFeature(iStyle: ATSUStyle; iFeatureIndex: ItemCount; VAR oFeatureType: ATSUFontFeatureType; VAR oFeatureSelector: ATSUFontFeatureSelector): OSStatus; C;

{
 *  ATSUGetAllFontFeatures()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetAllFontFeatures(iStyle: ATSUStyle; iMaximumFeatureCount: ItemCount; VAR oFeatureType: ATSUFontFeatureType; VAR oFeatureSelector: ATSUFontFeatureSelector; VAR oActualFeatureCount: ItemCount): OSStatus; C;

{
 *  ATSUClearFontFeatures()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUClearFontFeatures(iStyle: ATSUStyle; iFeatureCount: ItemCount; {CONST}VAR iType: ATSUFontFeatureType; {CONST}VAR iSelector: ATSUFontFeatureSelector): OSStatus; C;

{  Font variations }
{
 *  ATSUSetVariations()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetVariations(iStyle: ATSUStyle; iVariationCount: ItemCount; {CONST}VAR iAxes: ATSUFontVariationAxis; {CONST}VAR iValue: ATSUFontVariationValue): OSStatus; C;

{
 *  ATSUGetFontVariationValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontVariationValue(iStyle: ATSUStyle; iFontVariationAxis: ATSUFontVariationAxis; VAR oFontVariationValue: ATSUFontVariationValue): OSStatus; C;

{
 *  ATSUGetAllFontVariations()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetAllFontVariations(iStyle: ATSUStyle; iVariationCount: ItemCount; VAR oVariationAxes: ATSUFontVariationAxis; VAR oFontVariationValues: ATSUFontVariationValue; VAR oActualVariationCount: ItemCount): OSStatus; C;

{
 *  ATSUClearFontVariations()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUClearFontVariations(iStyle: ATSUStyle; iAxisCount: ItemCount; {CONST}VAR iAxis: ATSUFontVariationAxis): OSStatus; C;

{  Basic text-layout functions }
{
 *  ATSUCreateTextLayout()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCreateTextLayout(VAR oTextLayout: ATSUTextLayout): OSStatus; C;

{
 *  ATSUCreateAndCopyTextLayout()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCreateAndCopyTextLayout(iTextLayout: ATSUTextLayout; VAR oTextLayout: ATSUTextLayout): OSStatus; C;

{
 *  ATSUCreateTextLayoutWithTextPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCreateTextLayoutWithTextPtr(iText: ConstUniCharArrayPtr; iTextOffset: UniCharArrayOffset; iTextLength: UniCharCount; iTextTotalLength: UniCharCount; iNumberOfRuns: ItemCount; {CONST}VAR iRunLengths: UniCharCount; VAR iStyles: ATSUStyle; VAR oTextLayout: ATSUTextLayout): OSStatus; C;

{
 *  ATSUCreateTextLayoutWithTextHandle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCreateTextLayoutWithTextHandle(iText: UniCharArrayHandle; iTextOffset: UniCharArrayOffset; iTextLength: UniCharCount; iTextTotalLength: UniCharCount; iNumberOfRuns: ItemCount; {CONST}VAR iRunLengths: UniCharCount; VAR iStyles: ATSUStyle; VAR oTextLayout: ATSUTextLayout): OSStatus; C;

{
 *  ATSUClearLayoutCache()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUClearLayoutCache(iTextLayout: ATSUTextLayout; iLineStart: UniCharArrayOffset): OSStatus; C;

{
 *  ATSUDisposeTextLayout()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUDisposeTextLayout(iTextLayout: ATSUTextLayout): OSStatus; C;

{
 *  ATSUSetTextLayoutRefCon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetTextLayoutRefCon(iTextLayout: ATSUTextLayout; iRefCon: UInt32): OSStatus; C;

{
 *  ATSUGetTextLayoutRefCon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetTextLayoutRefCon(iTextLayout: ATSUTextLayout; VAR oRefCon: UInt32): OSStatus; C;

{  Glyph bounds retrieval  }
{
 *  ATSUGetGlyphBounds()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetGlyphBounds(iTextLayout: ATSUTextLayout; iTextBasePointX: ATSUTextMeasurement; iTextBasePointY: ATSUTextMeasurement; iBoundsCharStart: UniCharArrayOffset; iBoundsCharLength: UniCharCount; iTypeOfBounds: UInt16; iMaxNumberOfBounds: ItemCount; VAR oGlyphBounds: ATSTrapezoid; VAR oActualNumberOfBounds: ItemCount): OSStatus; C;

{  Idle processing }
{
 *  ATSUIdle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUIdle(iTextLayout: ATSUTextLayout): OSStatus; C;

{  Text location   }
{
 *  ATSUSetTextPointerLocation()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetTextPointerLocation(iTextLayout: ATSUTextLayout; iText: ConstUniCharArrayPtr; iTextOffset: UniCharArrayOffset; iTextLength: UniCharCount; iTextTotalLength: UniCharCount): OSStatus; C;

{
 *  ATSUSetTextHandleLocation()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetTextHandleLocation(iTextLayout: ATSUTextLayout; iText: UniCharArrayHandle; iTextOffset: UniCharArrayOffset; iTextLength: UniCharCount; iTextTotalLength: UniCharCount): OSStatus; C;

{
 *  ATSUGetTextLocation()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetTextLocation(iTextLayout: ATSUTextLayout; VAR oText: UNIV Ptr; VAR oTextIsStoredInHandle: BOOLEAN; VAR oOffset: UniCharArrayOffset; VAR oTextLength: UniCharCount; VAR oTextTotalLength: UniCharCount): OSStatus; C;

{  Text manipulation   }
{
 *  ATSUTextDeleted()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUTextDeleted(iTextLayout: ATSUTextLayout; iDeletedRangeStart: UniCharArrayOffset; iDeletedRangeLength: UniCharCount): OSStatus; C;

{
 *  ATSUTextInserted()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUTextInserted(iTextLayout: ATSUTextLayout; iInsertionLocation: UniCharArrayOffset; iInsertionLength: UniCharCount): OSStatus; C;

{
 *  ATSUTextMoved()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUTextMoved(iTextLayout: ATSUTextLayout; iNewLocation: ConstUniCharArrayPtr): OSStatus; C;

{  Layout controls }
{
 *  ATSUCopyLayoutControls()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCopyLayoutControls(iSourceTextLayout: ATSUTextLayout; iDestTextLayout: ATSUTextLayout): OSStatus; C;

{
 *  ATSUSetLayoutControls()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetLayoutControls(iTextLayout: ATSUTextLayout; iAttributeCount: ItemCount; {CONST}VAR iTag: ATSUAttributeTag; {CONST}VAR iValueSize: ByteCount; {CONST}VAR iValue: ATSUAttributeValuePtr): OSStatus; C;

{
 *  ATSUGetLayoutControl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetLayoutControl(iTextLayout: ATSUTextLayout; iTag: ATSUAttributeTag; iExpectedValueSize: ByteCount; oValue: ATSUAttributeValuePtr; VAR oActualValueSize: ByteCount): OSStatus; C;

{
 *  ATSUGetAllLayoutControls()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetAllLayoutControls(iTextLayout: ATSUTextLayout; VAR oAttributeInfoArray: ATSUAttributeInfo; iTagValuePairArraySize: ItemCount; VAR oTagValuePairCount: ItemCount): OSStatus; C;

{
 *  ATSUClearLayoutControls()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUClearLayoutControls(iTextLayout: ATSUTextLayout; iTagCount: ItemCount; {CONST}VAR iTag: ATSUAttributeTag): OSStatus; C;

{  Single line layout controls }
{
 *  ATSUCopyLineControls()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCopyLineControls(iSourceTextLayout: ATSUTextLayout; iSourceLineStart: UniCharArrayOffset; iDestTextLayout: ATSUTextLayout; iDestLineStart: UniCharArrayOffset): OSStatus; C;

{
 *  ATSUSetLineControls()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetLineControls(iTextLayout: ATSUTextLayout; iLineStart: UniCharArrayOffset; iAttributeCount: ItemCount; {CONST}VAR iTag: ATSUAttributeTag; {CONST}VAR iValueSize: ByteCount; {CONST}VAR iValue: ATSUAttributeValuePtr): OSStatus; C;

{
 *  ATSUGetLineControl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetLineControl(iTextLayout: ATSUTextLayout; iLineStart: UniCharArrayOffset; iTag: ATSUAttributeTag; iExpectedValueSize: ByteCount; oValue: ATSUAttributeValuePtr; VAR oActualValueSize: ByteCount): OSStatus; C;

{
 *  ATSUGetAllLineControls()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetAllLineControls(iTextLayout: ATSUTextLayout; iLineStart: UniCharArrayOffset; VAR oAttributeInfoArray: ATSUAttributeInfo; iTagValuePairArraySize: ItemCount; VAR oTagValuePairCount: ItemCount): OSStatus; C;

{
 *  ATSUClearLineControls()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUClearLineControls(iTextLayout: ATSUTextLayout; iLineStart: UniCharArrayOffset; iTagCount: ItemCount; {CONST}VAR iTag: ATSUAttributeTag): OSStatus; C;

{  Style run processing    }
{
 *  ATSUSetRunStyle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetRunStyle(iTextLayout: ATSUTextLayout; iStyle: ATSUStyle; iRunStart: UniCharArrayOffset; iRunLength: UniCharCount): OSStatus; C;

{
 *  ATSUGetRunStyle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetRunStyle(iTextLayout: ATSUTextLayout; iOffset: UniCharArrayOffset; VAR oStyle: ATSUStyle; VAR oRunStart: UniCharArrayOffset; VAR oRunLength: UniCharCount): OSStatus; C;

{
 *  ATSUGetContinuousAttributes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetContinuousAttributes(iTextLayout: ATSUTextLayout; iOffset: UniCharArrayOffset; iLength: UniCharCount; oStyle: ATSUStyle): OSStatus; C;

{  Drawing and measuring   }
{
 *  ATSUDrawText()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUDrawText(iTextLayout: ATSUTextLayout; iLineOffset: UniCharArrayOffset; iLineLength: UniCharCount; iLocationX: ATSUTextMeasurement; iLocationY: ATSUTextMeasurement): OSStatus; C;

{
 *  ATSUMeasureText()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUMeasureText(iTextLayout: ATSUTextLayout; iLineStart: UniCharArrayOffset; iLineLength: UniCharCount; VAR oTextBefore: ATSUTextMeasurement; VAR oTextAfter: ATSUTextMeasurement; VAR oAscent: ATSUTextMeasurement; VAR oDescent: ATSUTextMeasurement): OSStatus; C;

{
 *  ATSUMeasureTextImage()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUMeasureTextImage(iTextLayout: ATSUTextLayout; iLineOffset: UniCharArrayOffset; iLineLength: UniCharCount; iLocationX: ATSUTextMeasurement; iLocationY: ATSUTextMeasurement; VAR oTextImageRect: Rect): OSStatus; C;

{  Highlighting    }
{
 *  ATSUHighlightText()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUHighlightText(iTextLayout: ATSUTextLayout; iTextBasePointX: ATSUTextMeasurement; iTextBasePointY: ATSUTextMeasurement; iHighlightStart: UniCharArrayOffset; iHighlightLength: UniCharCount): OSStatus; C;

{
 *  ATSUUnhighlightText()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUUnhighlightText(iTextLayout: ATSUTextLayout; iTextBasePointX: ATSUTextMeasurement; iTextBasePointY: ATSUTextMeasurement; iHighlightStart: UniCharArrayOffset; iHighlightLength: UniCharCount): OSStatus; C;

{
 *  ATSUGetTextHighlight()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetTextHighlight(iTextLayout: ATSUTextLayout; iTextBasePointX: ATSUTextMeasurement; iTextBasePointY: ATSUTextMeasurement; iHighlightStart: UniCharArrayOffset; iHighlightLength: UniCharCount; oHighlightRegion: RgnHandle): OSStatus; C;

{  Hit-testing }
{
 *  ATSUPositionToOffset()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUPositionToOffset(iTextLayout: ATSUTextLayout; iLocationX: ATSUTextMeasurement; iLocationY: ATSUTextMeasurement; VAR ioPrimaryOffset: UniCharArrayOffset; VAR oIsLeading: BOOLEAN; VAR oSecondaryOffset: UniCharArrayOffset): OSStatus; C;

{
 *  ATSUOffsetToPosition()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUOffsetToPosition(iTextLayout: ATSUTextLayout; iOffset: UniCharArrayOffset; iIsLeading: BOOLEAN; VAR oMainCaret: ATSUCaret; VAR oSecondCaret: ATSUCaret; VAR oCaretIsSplit: BOOLEAN): OSStatus; C;

{  Cursor movement }
{
 *  ATSUNextCursorPosition()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUNextCursorPosition(iTextLayout: ATSUTextLayout; iOldOffset: UniCharArrayOffset; iMovementType: ATSUCursorMovementType; VAR oNewOffset: UniCharArrayOffset): OSStatus; C;

{
 *  ATSUPreviousCursorPosition()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUPreviousCursorPosition(iTextLayout: ATSUTextLayout; iOldOffset: UniCharArrayOffset; iMovementType: ATSUCursorMovementType; VAR oNewOffset: UniCharArrayOffset): OSStatus; C;

{
 *  ATSURightwardCursorPosition()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSURightwardCursorPosition(iTextLayout: ATSUTextLayout; iOldOffset: UniCharArrayOffset; iMovementType: ATSUCursorMovementType; VAR oNewOffset: UniCharArrayOffset): OSStatus; C;

{
 *  ATSULeftwardCursorPosition()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSULeftwardCursorPosition(iTextLayout: ATSUTextLayout; iOldOffset: UniCharArrayOffset; iMovementType: ATSUCursorMovementType; VAR oNewOffset: UniCharArrayOffset): OSStatus; C;

{  Line breaking   }
{
 *  ATSUBreakLine()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUBreakLine(iTextLayout: ATSUTextLayout; iLineStart: UniCharArrayOffset; iLineWidth: ATSUTextMeasurement; iUseAsSoftLineBreak: BOOLEAN; VAR oLineBreak: UniCharArrayOffset): OSStatus; C;

{
 *  ATSUSetSoftLineBreak()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetSoftLineBreak(iTextLayout: ATSUTextLayout; iLineBreak: UniCharArrayOffset): OSStatus; C;

{
 *  ATSUGetSoftLineBreaks()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetSoftLineBreaks(iTextLayout: ATSUTextLayout; iRangeStart: UniCharArrayOffset; iRangeLength: UniCharCount; iMaximumBreaks: ItemCount; VAR oBreaks: UniCharArrayOffset; VAR oBreakCount: ItemCount): OSStatus; C;

{
 *  ATSUClearSoftLineBreaks()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUClearSoftLineBreaks(iTextLayout: ATSUTextLayout; iRangeStart: UniCharArrayOffset; iRangeLength: UniCharCount): OSStatus; C;

{  Font matching   }
{
 *  ATSUSetFontFallbacks()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetFontFallbacks(iFontFallbacksCount: ItemCount; {CONST}VAR iFontIDs: ATSUFontID; iFontFallbackMethod: ATSUFontFallbackMethod): OSStatus; C;

{
 *  ATSUGetFontFallbacks()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontFallbacks(iMaxFontFallbacksCount: ItemCount; VAR oFontIDs: ATSUFontID; VAR oFontFallbackMethod: ATSUFontFallbackMethod; VAR oActualFallbacksCount: ItemCount): OSStatus; C;

{
 *  ATSUMatchFontsToText()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUMatchFontsToText(iTextLayout: ATSUTextLayout; iTextStart: UniCharArrayOffset; iTextLength: UniCharCount; VAR oFontID: ATSUFontID; VAR oChangedOffset: UniCharArrayOffset; VAR oChangedLength: UniCharCount): OSStatus; C;

{
 *  ATSUSetTransientFontMatching()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUSetTransientFontMatching(iTextLayout: ATSUTextLayout; iTransientFontMatching: BOOLEAN): OSStatus; C;

{
 *  ATSUGetTransientFontMatching()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetTransientFontMatching(iTextLayout: ATSUTextLayout; VAR oTransientFontMatching: BOOLEAN): OSStatus; C;

{  Font ID's   }
{
 *  ATSUFontCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUFontCount(VAR oFontCount: ItemCount): OSStatus; C;

{
 *  ATSUGetFontIDs()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontIDs(VAR oFontIDs: ATSUFontID; iArraySize: ItemCount; VAR oFontCount: ItemCount): OSStatus; C;

{
 *  ATSUFONDtoFontID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUFONDtoFontID(iFONDNumber: INTEGER; iFONDStyle: ByteParameter; VAR oFontID: ATSUFontID): OSStatus; C;

{
 *  ATSUFontIDtoFOND()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUFontIDtoFOND(iFontID: ATSUFontID; VAR oFONDNumber: INTEGER; VAR oFONDStyle: Style): OSStatus; C;

{  Font names  }
{
 *  ATSUCountFontNames()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCountFontNames(iFontID: ATSUFontID; VAR oFontNameCount: ItemCount): OSStatus; C;

{
 *  ATSUGetIndFontName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetIndFontName(iFontID: ATSUFontID; iFontNameIndex: ItemCount; iMaximumNameLength: ByteCount; oName: Ptr; VAR oActualNameLength: ByteCount; VAR oFontNameCode: FontNameCode; VAR oFontNamePlatform: FontPlatformCode; VAR oFontNameScript: FontScriptCode; VAR oFontNameLanguage: FontLanguageCode): OSStatus; C;

{
 *  ATSUFindFontName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUFindFontName(iFontID: ATSUFontID; iFontNameCode: FontNameCode; iFontNamePlatform: FontPlatformCode; iFontNameScript: FontScriptCode; iFontNameLanguage: FontLanguageCode; iMaximumNameLength: ByteCount; oName: Ptr; VAR oActualNameLength: ByteCount; VAR oFontNameIndex: ItemCount): OSStatus; C;

{
 *  ATSUFindFontFromName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUFindFontFromName(iName: Ptr; iNameLength: ByteCount; iFontNameCode: FontNameCode; iFontNamePlatform: FontPlatformCode; iFontNameScript: FontScriptCode; iFontNameLanguage: FontLanguageCode; VAR oFontID: ATSUFontID): OSStatus; C;

{  Font features   }
{
 *  ATSUCountFontFeatureTypes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCountFontFeatureTypes(iFontID: ATSUFontID; VAR oTypeCount: ItemCount): OSStatus; C;

{
 *  ATSUCountFontFeatureSelectors()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCountFontFeatureSelectors(iFontID: ATSUFontID; iType: ATSUFontFeatureType; VAR oSelectorCount: ItemCount): OSStatus; C;

{
 *  ATSUGetFontFeatureTypes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontFeatureTypes(iFontID: ATSUFontID; iMaximumTypes: ItemCount; VAR oTypes: ATSUFontFeatureType; VAR oActualTypeCount: ItemCount): OSStatus; C;

{
 *  ATSUGetFontFeatureSelectors()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontFeatureSelectors(iFontID: ATSUFontID; iType: ATSUFontFeatureType; iMaximumSelectors: ItemCount; VAR oSelectors: ATSUFontFeatureSelector; VAR oSelectorIsOnByDefault: BOOLEAN; VAR oActualSelectorCount: ItemCount; VAR oIsMutuallyExclusive: BOOLEAN): OSStatus; C;

{
 *  ATSUGetFontFeatureNameCode()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontFeatureNameCode(iFontID: ATSUFontID; iType: ATSUFontFeatureType; iSelector: ATSUFontFeatureSelector; VAR oNameCode: FontNameCode): OSStatus; C;

{  Font tracking value & names }
{
 *  ATSUCountFontTracking()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCountFontTracking(iFontID: ATSUFontID; iCharacterOrientation: ATSUVerticalCharacterType; VAR oTrackingCount: ItemCount): OSStatus; C;

{
 *  ATSUGetIndFontTracking()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.6 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetIndFontTracking(iFontID: ATSUFontID; iCharacterOrientation: ATSUVerticalCharacterType; iTrackIndex: ItemCount; VAR oFontTrackingValue: Fixed; VAR oNameCode: FontNameCode): OSStatus; C;

{  Font variations }
{
 *  ATSUCountFontVariations()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCountFontVariations(iFontID: ATSUFontID; VAR oVariationCount: ItemCount): OSStatus; C;

{
 *  ATSUGetIndFontVariation()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetIndFontVariation(iFontID: ATSUFontID; iVariationIndex: ItemCount; VAR oATSUFontVariationAxis: ATSUFontVariationAxis; VAR oMinimumValue: ATSUFontVariationValue; VAR oMaximumValue: ATSUFontVariationValue; VAR oDefaultValue: ATSUFontVariationValue): OSStatus; C;

{
 *  ATSUGetFontVariationNameCode()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontVariationNameCode(iFontID: ATSUFontID; iAxis: ATSUFontVariationAxis; VAR oNameCode: FontNameCode): OSStatus; C;

{  Font Instances  }
{
 *  ATSUCountFontInstances()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUCountFontInstances(iFontID: ATSUFontID; VAR oInstances: ItemCount): OSStatus; C;

{
 *  ATSUGetFontInstance()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontInstance(iFontID: ATSUFontID; iFontInstanceIndex: ItemCount; iMaximumVariations: ItemCount; VAR oAxes: ATSUFontVariationAxis; VAR oValues: ATSUFontVariationValue; VAR oActualVariationCount: ItemCount): OSStatus; C;

{
 *  ATSUGetFontInstanceNameCode()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetFontInstanceNameCode(iFontID: ATSUFontID; iInstanceIndex: ItemCount; VAR oNameCode: FontNameCode): OSStatus; C;


{*****************************************************************************}
{ ATSUI Low-Level API                                                         }
{*****************************************************************************}
{ GlyphInfo access }
{
 *  ATSUGetGlyphInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetGlyphInfo(iTextLayout: ATSUTextLayout; iLineStart: UniCharArrayOffset; iLineLength: UniCharCount; VAR ioBufferSize: ByteCount; VAR oGlyphInfoPtr: ATSUGlyphInfoArray): OSStatus; C;

{
 *  ATSUDrawGlyphInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUDrawGlyphInfo(VAR iGlyphInfoArray: ATSUGlyphInfoArray; iLocation: Float32Point): OSStatus; C;

{ Font Data Access }
{
 *  ATSUGlyphGetIdealMetrics()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGlyphGetIdealMetrics(iATSUStyle: ATSUStyle; iNumOfGlyphs: ItemCount; VAR iGlyphIDs: GlyphID; iInputOffset: ByteOffset; VAR oIdealMetrics: ATSGlyphIdealMetrics): OSStatus; C;

{
 *  ATSUGetNativeCurveType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGetNativeCurveType(iATSUStyle: ATSUStyle; VAR oCurveType: ATSCurveType): OSStatus; C;

{ Device specific routines }
{
 *  ATSUGlyphGetScreenMetrics()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGlyphGetScreenMetrics(iATSUStyle: ATSUStyle; iNumOfGlyphs: ItemCount; VAR iGlyphIDs: GlyphID; iInputOffset: ByteOffset; iForcingAntiAlias: BOOLEAN; iAntiAliasSwitch: BOOLEAN; VAR oScreenMetrics: ATSGlyphScreenMetrics): OSStatus; C;

{ ATSUGlyphGetQuadraticPaths callbacks }

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	ATSQuadraticLineProcPtr = FUNCTION({CONST}VAR pt1: Float32Point; {CONST}VAR pt2: Float32Point; callBackDataPtr: UNIV Ptr): OSStatus;
{$ELSEC}
	ATSQuadraticLineProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATSQuadraticCurveProcPtr = FUNCTION({CONST}VAR pt1: Float32Point; {CONST}VAR controlPt: Float32Point; {CONST}VAR pt2: Float32Point; callBackDataPtr: UNIV Ptr): OSStatus;
{$ELSEC}
	ATSQuadraticCurveProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATSQuadraticNewPathProcPtr = FUNCTION(callBackDataPtr: UNIV Ptr): OSStatus;
{$ELSEC}
	ATSQuadraticNewPathProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATSQuadraticClosePathProcPtr = FUNCTION(callBackDataPtr: UNIV Ptr): OSStatus;
{$ELSEC}
	ATSQuadraticClosePathProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	ATSQuadraticLineUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATSQuadraticLineUPP = ATSQuadraticLineProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ATSQuadraticCurveUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATSQuadraticCurveUPP = ATSQuadraticCurveProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ATSQuadraticNewPathUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATSQuadraticNewPathUPP = ATSQuadraticNewPathProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ATSQuadraticClosePathUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATSQuadraticClosePathUPP = ATSQuadraticClosePathProcPtr;
{$ENDC}	

CONST
	uppATSQuadraticLineProcInfo = $00000FF0;
	uppATSQuadraticCurveProcInfo = $00003FF0;
	uppATSQuadraticNewPathProcInfo = $000000F0;
	uppATSQuadraticClosePathProcInfo = $000000F0;
	{
	 *  NewATSQuadraticLineUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewATSQuadraticLineUPP(userRoutine: ATSQuadraticLineProcPtr): ATSQuadraticLineUPP;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewATSQuadraticCurveUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewATSQuadraticCurveUPP(userRoutine: ATSQuadraticCurveProcPtr): ATSQuadraticCurveUPP;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewATSQuadraticNewPathUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewATSQuadraticNewPathUPP(userRoutine: ATSQuadraticNewPathProcPtr): ATSQuadraticNewPathUPP;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewATSQuadraticClosePathUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewATSQuadraticClosePathUPP(userRoutine: ATSQuadraticClosePathProcPtr): ATSQuadraticClosePathUPP;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeATSQuadraticLineUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeATSQuadraticLineUPP(userUPP: ATSQuadraticLineUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeATSQuadraticCurveUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeATSQuadraticCurveUPP(userUPP: ATSQuadraticCurveUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeATSQuadraticNewPathUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeATSQuadraticNewPathUPP(userUPP: ATSQuadraticNewPathUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeATSQuadraticClosePathUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeATSQuadraticClosePathUPP(userUPP: ATSQuadraticClosePathUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeATSQuadraticLineUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeATSQuadraticLineUPP({CONST}VAR pt1: Float32Point; {CONST}VAR pt2: Float32Point; callBackDataPtr: UNIV Ptr; userRoutine: ATSQuadraticLineUPP): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeATSQuadraticCurveUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeATSQuadraticCurveUPP({CONST}VAR pt1: Float32Point; {CONST}VAR controlPt: Float32Point; {CONST}VAR pt2: Float32Point; callBackDataPtr: UNIV Ptr; userRoutine: ATSQuadraticCurveUPP): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeATSQuadraticNewPathUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeATSQuadraticNewPathUPP(callBackDataPtr: UNIV Ptr; userRoutine: ATSQuadraticNewPathUPP): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeATSQuadraticClosePathUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeATSQuadraticClosePathUPP(callBackDataPtr: UNIV Ptr; userRoutine: ATSQuadraticClosePathUPP): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  ATSUGlyphGetQuadraticPaths()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGlyphGetQuadraticPaths(iATSUStyle: ATSUStyle; iGlyphID: GlyphID; iNewPathProc: ATSQuadraticNewPathUPP; iLineProc: ATSQuadraticLineUPP; iCurveProc: ATSQuadraticCurveUPP; iClosePathProc: ATSQuadraticClosePathUPP; iCallbackDataPtr: UNIV Ptr; VAR oCallbackResult: OSStatus): OSStatus; C;

{ ATSUGlyphGetCubicPaths callbacks }

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	ATSCubicMoveToProcPtr = FUNCTION({CONST}VAR pt: Float32Point; callBackDataPtr: UNIV Ptr): OSStatus;
{$ELSEC}
	ATSCubicMoveToProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATSCubicLineToProcPtr = FUNCTION({CONST}VAR pt: Float32Point; callBackDataPtr: UNIV Ptr): OSStatus;
{$ELSEC}
	ATSCubicLineToProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATSCubicCurveToProcPtr = FUNCTION({CONST}VAR pt1: Float32Point; {CONST}VAR pt2: Float32Point; {CONST}VAR pt3: Float32Point; callBackDataPtr: UNIV Ptr): OSStatus;
{$ELSEC}
	ATSCubicCurveToProcPtr = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	ATSCubicClosePathProcPtr = FUNCTION(callBackDataPtr: UNIV Ptr): OSStatus;
{$ELSEC}
	ATSCubicClosePathProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	ATSCubicMoveToUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATSCubicMoveToUPP = ATSCubicMoveToProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ATSCubicLineToUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATSCubicLineToUPP = ATSCubicLineToProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ATSCubicCurveToUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATSCubicCurveToUPP = ATSCubicCurveToProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	ATSCubicClosePathUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	ATSCubicClosePathUPP = ATSCubicClosePathProcPtr;
{$ENDC}	

CONST
	uppATSCubicMoveToProcInfo = $000003F0;
	uppATSCubicLineToProcInfo = $000003F0;
	uppATSCubicCurveToProcInfo = $00003FF0;
	uppATSCubicClosePathProcInfo = $000000F0;
	{
	 *  NewATSCubicMoveToUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewATSCubicMoveToUPP(userRoutine: ATSCubicMoveToProcPtr): ATSCubicMoveToUPP;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewATSCubicLineToUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewATSCubicLineToUPP(userRoutine: ATSCubicLineToProcPtr): ATSCubicLineToUPP;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewATSCubicCurveToUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewATSCubicCurveToUPP(userRoutine: ATSCubicCurveToProcPtr): ATSCubicCurveToUPP;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewATSCubicClosePathUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewATSCubicClosePathUPP(userRoutine: ATSCubicClosePathProcPtr): ATSCubicClosePathUPP;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeATSCubicMoveToUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeATSCubicMoveToUPP(userUPP: ATSCubicMoveToUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeATSCubicLineToUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeATSCubicLineToUPP(userUPP: ATSCubicLineToUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeATSCubicCurveToUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeATSCubicCurveToUPP(userUPP: ATSCubicCurveToUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeATSCubicClosePathUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeATSCubicClosePathUPP(userUPP: ATSCubicClosePathUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeATSCubicMoveToUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeATSCubicMoveToUPP({CONST}VAR pt: Float32Point; callBackDataPtr: UNIV Ptr; userRoutine: ATSCubicMoveToUPP): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeATSCubicLineToUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeATSCubicLineToUPP({CONST}VAR pt: Float32Point; callBackDataPtr: UNIV Ptr; userRoutine: ATSCubicLineToUPP): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeATSCubicCurveToUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeATSCubicCurveToUPP({CONST}VAR pt1: Float32Point; {CONST}VAR pt2: Float32Point; {CONST}VAR pt3: Float32Point; callBackDataPtr: UNIV Ptr; userRoutine: ATSCubicCurveToUPP): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeATSCubicClosePathUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeATSCubicClosePathUPP(callBackDataPtr: UNIV Ptr; userRoutine: ATSCubicClosePathUPP): OSStatus;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  ATSUGlyphGetCubicPaths()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGlyphGetCubicPaths(iATSUStyle: ATSUStyle; iGlyphID: GlyphID; iMoveToProc: ATSCubicMoveToUPP; iLineToProc: ATSCubicLineToUPP; iCurveToProc: ATSCubicCurveToUPP; iClosePathProc: ATSCubicClosePathUPP; iCallbackDataPtr: UNIV Ptr; VAR oCallbackResult: OSStatus): OSStatus; C;

{
 *  ATSUGlyphGetCurvePaths()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in ATSUnicodeLib 9.1 and later
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ATSUGlyphGetCurvePaths(iATSUStyle: ATSUStyle; iGlyphID: GlyphID; VAR ioBufferSize: ByteCount; VAR oPaths: ATSUCurvePaths): OSStatus; C;


{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := ATSUnicodeIncludes}

{$ENDC} {__ATSUNICODE__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AVComponents.p
 
     Contains:   Standard includes for standard AV panels
 
     Version:    Technology: System 7.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1989-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AVComponents;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AVCOMPONENTS__}
{$SETC __AVCOMPONENTS__ := 1}

{$I+}
{$SETC AVComponentsIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __DIALOGS__}
{$I Dialogs.p}
{$ENDC}
{$IFC UNDEFINED __VIDEO__}
{$I Video.p}
{$ENDC}
{$IFC UNDEFINED __DISPLAYS__}
{$I Displays.p}
{$ENDC}
{$IFC UNDEFINED __COMPONENTS__}
{$I Components.p}
{$ENDC}
{$IFC UNDEFINED __CMAPPLICATION__}
{$I CMApplication.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{
    The subtypes listed here are for example only.  The display manager will find _all_ panels
    with the appropriate types.  These panels return class information that is used to devide them
    up into groups to be displayed in the AV Windows (class means "geometry" or "color" or other groupings
    like that.
}

CONST
	kAVPanelType				= 'avpc';						{  Panel subtypes         }
	kBrightnessPanelSubType		= 'brit';
	kContrastPanelSubType		= 'cont';
	kBitDepthPanelSubType		= 'bitd';
	kAVEngineType				= 'avec';						{  Engine subtypes           }
	kBrightnessEngineSubType	= 'brit';
	kContrastEngineSubType		= 'cont';						{     kBitDepthEngineSubType     = 'bitd',       // Not used               }
	kAVPortType					= 'avdp';						{  subtypes are defined in each port's public .h file  }
	kAVUtilityType				= 'avuc';
	kAVBackChannelSubType		= 'avbc';
	kAVCommunicationType		= 'avcm';
	kAVDialogType				= 'avdg';

	{	 PortComponent subtypes are up to the port and display manager does not use the subtype
	    to find port components.  Instead, display manager uses an internal cache to search for portcompoennts.
	    It turns out to be useful to have a unique subtype so that engines can see if they should apply themselves to
	    a particular port component.
	  
	   PortKinds are the "class" of port.  When a port is registered with display manager (creating a display ID), the
	    caller of DMNewDisplayIDByPortComponent passes a portKind.  Ports of this type are returned by
	    DMNewDevicePortList.
	  
	   PortKinds are NOT subtypes of components
	   PortKinds ARE used to register and find port components with Display Manager.  Here are the basic port kinds:
	  
	   Video displays are distinct from video out because there are some video out ports that are not actaully displays.
	    if EZAV is looking to configure displays, it needs to look for kAVVideoDisplayPortKind not kAVVideoOutPortKind.
		}
	kAVVideoDisplayPortKind		= 'pkdo';						{  Video Display (CRT or panel display)           }
	kAVVideoOutPortKind			= 'pkvo';						{  Video out port (camera output).                 }
	kAVVideoInPortKind			= 'pkvi';						{  Video in port (camera input)                }
	kAVSoundOutPortKind			= 'pkso';						{  Sound out port (speaker or speaker jack)       }
	kAVSoundInPortKind			= 'pksi';						{  Sound in port (microphone or microphone jack)   }
	kAVDeviceType				= 'avdc';						{  Device Component subtypes are up to the manufacturor since each device may contain multiple function types (eg telecaster)  }
	kAVDisplayDeviceKind		= 'dkvo';						{  Display device }
																{  Device Component subtypes are up to the manufacturor since each device may contain multiple function types (eg telecaster) }
	kAVCategoryType				= 'avcc';
	kAVSoundInSubType			= 'avao';
	kAVSoundOutSubType			= 'avai';
	kAVVideoInSubType			= 'vdin';
	kAVVideoOutSubType			= 'vdou';
	kAVInvalidType				= 'badt';						{  Some calls return a component type, in case of errors, these types are set to kAVInvalidComponentType  }

	{
	   Interface Signatures are used to identify what kind of component
	   calls can be made for a given component. Today this applies only
	   to ports, but could be applied to other components as well.
	}
	kAVGenericInterfaceSignature = 'dmgr';
	kAVAppleVisionInterfaceSignature = 'avav';

	{	 =============================                    	}
	{	 Panel Class Constants                            	}
	{	 =============================                    	}
	kAVPanelClassDisplayDefault	= 'cdsp';
	kAVPanelClassColor			= 'cclr';
	kAVPanelClassGeometry		= 'cgeo';
	kAVPanelClassSound			= 'csnd';
	kAVPanelClassPreferences	= 'cprf';
	kAVPanelClassLCD			= 'clcd';
	kAVPanelClassMonitorSound	= 'cres';
	kAVPanelClassAlert			= 'calr';
	kAVPanelClassExtras			= 'cext';
	kAVPanelClassRearrange		= 'crea';


	{	 =============================                    	}
	{	 AV Notification Types                            	}
	{	 =============================                    	}
	{
	   This notification will be sent whenever a
	   device has been reset, for whatever reason.
	}
	kAVNotifyDeviceReset		= 'rset';


	{	 =============================                    	}
	{	 Component interface revision levels and history  	}
	{	 =============================                    	}
	kAVPanelComponentInterfaceRevOne = 1;
	kAVPanelComponentInterfaceRevTwo = 2;
	kAVEngineComponentInterfaceRevOne = 1;
	kAVPortComponentInterfaceRevOne = 1;
	kAVDeviceComponentInterfaceRevOne = 1;
	kAVUtilityComponentInterfaceRevOne = 1;


	{	 =============================                    	}
	{	 Adornment Constants                              	}
	{	 =============================                    	}
	kAVPanelAdornmentNoBorder	= 0;
	kAVPanelAdornmentStandardBorder = 1;

	kAVPanelAdornmentNoName		= 0;
	kAVPanelAdornmentStandardName = 1;


	{	 =============================                    	}
	{	 Selector Ranges                                  	}
	{	 =============================                    	}
	kBaseAVComponentSelector	= 256;							{  First apple-defined selector for AV components  }
	kAppleAVComponentSelector	= 512;							{  First apple-defined type-specific selector for AV components  }


	{	 =============================                	}
	{	 Panel Standard component selectors           	}
	{	 =============================                	}
	kAVPanelFakeRegisterSelect	= -5;							{  -5  }
	kAVPanelSetCustomDataSelect	= 0;
	kAVPanelGetDitlSelect		= 1;
	kAVPanelGetTitleSelect		= 2;
	kAVPanelInstallSelect		= 3;
	kAVPanelEventSelect			= 4;
	kAVPanelItemSelect			= 5;
	kAVPanelRemoveSelect		= 6;
	kAVPanelValidateInputSelect	= 7;
	kAVPanelGetSettingsIdentifiersSelect = 8;
	kAVPanelGetSettingsSelect	= 9;
	kAVPanelSetSettingsSelect	= 10;
	kAVPanelSelectorGetFidelitySelect = 256;
	kAVPanelSelectorTargetDeviceSelect = 257;
	kAVPanelSelectorGetPanelClassSelect = 258;
	kAVPanelSelectorGetPanelAdornmentSelect = 259;
	kAVPanelSelectorGetBalloonHelpStringSelect = 260;
	kAVPanelSelectorAppleGuideRequestSelect = 261;
	kAVPanelSelectorGetFocusStatusSelect = 262;
	kAVPanelSelectorSetFocusStatusSelect = 263;


	{	 =============================                	}
	{	 Engine Standard component selectors          	}
	{	 =============================                	}
	kAVEngineGetEngineFidelitySelect = 256;
	kAVEngineTargetDeviceSelect	= 257;


	{	 =============================                    	}
	{	 Video Port Specific calls                        	}
	{	 =============================                    	}
	kAVPortCheckTimingModeSelect = 0;
	kAVPortReserved1Select		= 1;							{  Reserved }
	kAVPortReserved2Select		= 2;							{  Reserved }
	kAVPortGetDisplayTimingInfoSelect = 512;
	kAVPortGetDisplayProfileCountSelect = 513;
	kAVPortGetIndexedDisplayProfileSelect = 514;
	kAVPortGetDisplayGestaltSelect = 515;
	kAVPortGetDisplayTimingCountSelect = 516;
	kAVPortGetIndexedDisplayTimingSelect = 517;
	kAVPortGetDisplayTimingRangeCountSelect = 518;
	kAVPortGetIndexedDisplayTimingRangeSelect = 519;


	{	 =============================                    	}
	{	 AV Port Specific calls                           	}
	{	 =============================                    	}
	kAVPortGetAVDeviceFidelitySelect = 256;						{  Port Standard Component selectors  }
	kAVPortGetWiggleSelect		= 257;
	kAVPortSetWiggleSelect		= 258;
	kAVPortGetNameSelect		= 259;
	kAVPortGetGraphicInfoSelect	= 260;
	kAVPortSetActiveSelect		= 261;
	kAVPortGetActiveSelect		= 262;
	kAVPortUnsed1Select			= 263;							{  Selector removed as part of API change.  We don't want to mess up the following selectors, so we put in this spacer (ie kPadSelector).  }
	kAVPortGetAVIDSelect		= 264;
	kAVPortSetAVIDSelect		= 265;
	kAVPortSetDeviceAVIDSelect	= 266;							{  For registrar to set device (instead of hitting global directly) -- should only be called once  }
	kAVPortGetDeviceAVIDSelect	= 267;							{  Called by display mgr for generic ports  }
	kAVPortGetPowerStateSelect	= 268;
	kAVPortSetPowerStateSelect	= 269;
	kAVPortGetMakeAndModelSelect = 270;							{  Get Make and model information }
	kAVPortGetInterfaceSignatureSelect = 271;					{  To determine what VideoPort-specific calls can be made }
	kAVPortReserved3Select		= 272;							{  Reserved }
	kAVPortGetManufactureInfoSelect = 273;						{  Get more Make and model information   }




	{	 =============================                    	}
	{	 Device Component Standard Component selectors    	}
	{	 =============================                    	}
	kAVDeviceGetNameSelect		= 256;
	kAVDeviceGetGraphicInfoSelect = 257;
	kAVDeviceGetPowerStateSelect = 258;
	kAVDeviceSetPowerStateSelect = 259;
	kAVDeviceGetAVIDSelect		= 260;
	kAVDeviceSetAVIDSelect		= 261;

	{	 =============================                    	}
	{	 AV Back-Channel Selectors                        	}
	{	 =============================                    	}
	kAVBackChannelReservedSelector = 1;
	kAVBackChannelPreModalFilterSelect = 2;
	kAVBackChannelModalFilterSelect = 3;
	kAVBackChannelAppleGuideLaunchSelect = 4;







	{	 =============================                	}
	{	 Engine Standard component selectors          	}
	{	 =============================                	}
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  AVEngineComponentGetFidelity()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION AVEngineComponentGetFidelity(engineComponent: ComponentInstance; displayID: DisplayIDType; VAR engineFidelity: DMFidelityType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0100, $7000, $A82A;
	{$ENDC}

{
 *  AVEngineComponentTargetDevice()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVEngineComponentTargetDevice(engineComponent: ComponentInstance; displayID: DisplayIDType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0101, $7000, $A82A;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}

{ =============================                }
{ Panel Standard Component calls               }
{ =============================                }
{$IFC CALL_NOT_IN_CARBON }
{
 *  AVPanelFakeRegister()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelFakeRegister(ci: ComponentInstance): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0000, $FFFB, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelSetCustomData()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelSetCustomData(ci: ComponentInstance; theCustomData: LONGINT): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0000, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelGetDitl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelGetDitl(ci: ComponentInstance; VAR ditl: Handle): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0001, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelGetTitle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelGetTitle(ci: ComponentInstance; title: StringPtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0002, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelInstall()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelInstall(ci: ComponentInstance; dialog: DialogRef; itemOffset: LONGINT): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0003, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelEvent(ci: ComponentInstance; dialog: DialogRef; itemOffset: LONGINT; VAR event: EventRecord; VAR itemHit: INTEGER; VAR handled: BOOLEAN): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0014, $0004, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelItem(ci: ComponentInstance; dialog: DialogRef; itemOffset: LONGINT; itemNum: INTEGER): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000A, $0005, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelRemove()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelRemove(ci: ComponentInstance; dialog: DialogRef; itemOffset: LONGINT): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0006, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelValidateInput()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelValidateInput(ci: ComponentInstance; VAR ok: BOOLEAN): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0007, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelGetSettingsIdentifiers()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelGetSettingsIdentifiers(ci: ComponentInstance; VAR theID: INTEGER; VAR theType: OSType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0008, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelGetSettings()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelGetSettings(ci: ComponentInstance; VAR userDataHand: Handle; flags: LONGINT; theDialog: DialogRef; itemsOffset: LONGINT): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $0009, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelSetSettings()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelSetSettings(ci: ComponentInstance; userDataHand: Handle; flags: LONGINT; theDialog: DialogRef; itemsOffset: LONGINT): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $000A, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelGetFidelity()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelGetFidelity(panelComponent: ComponentInstance; displayID: DisplayIDType; VAR panelFidelity: DMFidelityType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0100, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelComponentTargetDevice()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelComponentTargetDevice(panelComponent: ComponentInstance; displayID: DisplayIDType; theDialog: DialogRef; itemsOffset: LONGINT): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $0101, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelComponentGetPanelClass()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelComponentGetPanelClass(panelComponent: ComponentInstance; VAR panelClass: ResType; VAR subClass: ResType; reserved1: Ptr; reserved2: Ptr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $0102, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelComponentGetPanelAdornment()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelComponentGetPanelAdornment(panelComponent: ComponentInstance; VAR panelBorderType: LONGINT; VAR panelNameType: LONGINT): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0103, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelComponentGetBalloonHelpString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelComponentGetBalloonHelpString(panelComponent: ComponentInstance; item: INTEGER; balloonString: StringPtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0006, $0104, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelComponentAppleGuideRequest()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelComponentAppleGuideRequest(panelComponent: ComponentInstance; agSelector: OSType; agDataReply: UNIV Ptr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0105, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelComponentGetFocusStatus()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelComponentGetFocusStatus(panelComponent: ComponentInstance; VAR hasFocus: BOOLEAN): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0106, $7000, $A82A;
	{$ENDC}

{
 *  AVPanelComponentSetFocusStatus()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPanelComponentSetFocusStatus(panelComponent: ComponentInstance; theDialog: DialogPtr; itemOffset: LONGINT; gettingFocus: BOOLEAN; VAR tookFocus: BOOLEAN): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000E, $0107, $7000, $A82A;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}

{ =============================                }
{ Port Component Standard Component selectors  }
{ =============================                }
{$IFC CALL_NOT_IN_CARBON }
{
 *  AVPortGetAVDeviceFidelity()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetAVDeviceFidelity(portComponent: ComponentInstance; deviceAVID: AVIDType; VAR portFidelity: DMFidelityType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0100, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetWiggle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetWiggle(portComponent: ComponentInstance; VAR wiggleDevice: BOOLEAN): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0101, $7000, $A82A;
	{$ENDC}

{
 *  AVPortSetWiggle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortSetWiggle(portComponent: ComponentInstance; wiggleDevice: BOOLEAN): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0002, $0102, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetName(portComponent: ComponentInstance; VAR portName: Str255): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0103, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetGraphicInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetGraphicInfo(portComponent: ComponentInstance; VAR thePict: PicHandle; VAR theIconSuite: Handle; theLocation: AVLocationPtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $0104, $7000, $A82A;
	{$ENDC}

{
 *  AVPortSetActive()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortSetActive(portComponent: ComponentInstance; setActive: BOOLEAN): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0002, $0105, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetActive()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetActive(portComponent: ComponentInstance; VAR isPortActive: BOOLEAN; VAR portCanBeActivated: BOOLEAN; reserved: UNIV Ptr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $0106, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetAVID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetAVID(portComponent: ComponentInstance; VAR avPortID: AVIDType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0108, $7000, $A82A;
	{$ENDC}

{
 *  AVPortSetAVID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortSetAVID(portComponent: ComponentInstance; avPortID: AVIDType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0109, $7000, $A82A;
	{$ENDC}

{
 *  AVPortSetDeviceAVID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortSetDeviceAVID(portComponent: ComponentInstance; avDeviceID: AVIDType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $010A, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetDeviceAVID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetDeviceAVID(portComponent: ComponentInstance; VAR avDeviceID: AVIDType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $010B, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetPowerState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetPowerState(portComponent: ComponentInstance; getPowerState: AVPowerStatePtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $010C, $7000, $A82A;
	{$ENDC}

{
 *  AVPortSetPowerState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortSetPowerState(portComponent: ComponentInstance; setPowerState: AVPowerStatePtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $010D, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetMakeAndModel()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetMakeAndModel(portComponent: ComponentInstance; theDisplayID: DisplayIDType; VAR manufacturer: ResType; VAR model: UInt32; VAR serialNumber: UInt32): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $010E, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetInterfaceSignature()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetInterfaceSignature(portComponent: ComponentInstance; VAR interfaceSignature: OSType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $010F, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetManufactureInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetManufactureInfo(portComponent: ComponentInstance; theDisplayID: DisplayIDType; theMakeAndModel: DMMakeAndModelPtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0111, $7000, $A82A;
	{$ENDC}


{ =============================                }
{ Video Out Port Component Selectors           }
{ =============================                }
{
 *  AVPortCheckTimingMode()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortCheckTimingMode(displayComponent: ComponentInstance; theDisplayID: DisplayIDType; connectInfo: VDDisplayConnectInfoPtr; modeTiming: VDTimingInfoPtr; theDetailedTiming: VDDetailedTimingPtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $0000, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetDisplayTimingInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetDisplayTimingInfo(displayComponent: ComponentInstance; modeTiming: VDTimingInfoPtr; requestedVersion: UInt32; modeInfo: DMDisplayTimingInfoPtr; theDetailedTiming: VDDetailedTimingPtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $0200, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetDisplayProfileCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetDisplayProfileCount(displayComponent: ComponentInstance; reserved: UInt32; VAR profileCount: UInt32; VAR profileSeed: UInt32): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $0201, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetIndexedDisplayProfile()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetIndexedDisplayProfile(displayComponent: ComponentInstance; reserved: UInt32; profileIndex: UInt32; profileSeed: UInt32; VAR indexedProfile: CMProfileRef): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $0202, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetDisplayGestalt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetDisplayGestalt(displayComponent: ComponentInstance; displayGestaltSelector: ResType; VAR displayGestaltResponse: UInt32): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0008, $0203, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetDisplayTimingCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetDisplayTimingCount(displayComponent: ComponentInstance; reserved: UNIV Ptr; VAR timingCount: UInt32; VAR timingsSeed: UInt32): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $0204, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetIndexedDisplayTiming()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetIndexedDisplayTiming(displayComponent: ComponentInstance; reserved: UNIV Ptr; timingIndex: UInt32; timingsSeed: UInt32; indexedTiming: VDDetailedTimingPtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $0205, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetDisplayTimingRangeCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetDisplayTimingRangeCount(displayComponent: ComponentInstance; reserved: UNIV Ptr; VAR rangeCount: UInt32; VAR rangeSeed: UInt32): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $0206, $7000, $A82A;
	{$ENDC}

{
 *  AVPortGetIndexedDisplayTimingRange()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVPortGetIndexedDisplayTimingRange(displayComponent: ComponentInstance; reserved: UNIV Ptr; rangeIndex: UInt32; rangeSeed: UInt32; indexedRange: VDDisplayTimingRangePtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0010, $0207, $7000, $A82A;
	{$ENDC}


{$ENDC}  {CALL_NOT_IN_CARBON}

{ =============================                }
{ AV Device Component Selectors                }
{ =============================                }
{$IFC CALL_NOT_IN_CARBON }
{
 *  AVDeviceGetName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVDeviceGetName(deviceComponent: ComponentInstance; VAR portName: Str255): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0100, $7000, $A82A;
	{$ENDC}

{
 *  AVDeviceGetGraphicInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVDeviceGetGraphicInfo(deviceComponent: ComponentInstance; VAR thePict: PicHandle; VAR theIconSuite: Handle; theLocation: AVLocationPtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $000C, $0101, $7000, $A82A;
	{$ENDC}

{
 *  AVDeviceGetPowerState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVDeviceGetPowerState(deviceComponent: ComponentInstance; getPowerState: AVPowerStatePtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0102, $7000, $A82A;
	{$ENDC}

{
 *  AVDeviceSetPowerState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVDeviceSetPowerState(deviceComponent: ComponentInstance; setPowerState: AVPowerStatePtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0103, $7000, $A82A;
	{$ENDC}

{
 *  AVDeviceGetAVID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVDeviceGetAVID(deviceComponent: ComponentInstance; VAR avDeviceID: AVIDType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0104, $7000, $A82A;
	{$ENDC}

{
 *  AVDeviceSetAVID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVDeviceSetAVID(deviceComponent: ComponentInstance; avDeviceID: AVIDType): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0105, $7000, $A82A;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}

{ =============================                }
{ AV BackChannel Component Selectors           }
{ =============================                }
{$IFC CALL_NOT_IN_CARBON }
{
 *  AVBackChannelPreModalFilter()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVBackChannelPreModalFilter(compInstance: ComponentInstance): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0000, $0002, $7000, $A82A;
	{$ENDC}

{
 *  AVBackChannelModalFilter()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVBackChannelModalFilter(compInstance: ComponentInstance; VAR theEvent: EventRecord): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0003, $7000, $A82A;
	{$ENDC}

{
 *  AVBackChannelAppleGuideLaunch()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION AVBackChannelAppleGuideLaunch(compInstance: ComponentInstance; theSubject: StringPtr): ComponentResult;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2F3C, $0004, $0004, $7000, $A82A;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}



{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AVComponentsIncludes}

{$ENDC} {__AVCOMPONENTS__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       AVLTree.p
 
     Contains:   Prototypes for routines which create, destroy, allow for
 
     Version:    Technology: 
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT AVLTree;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __AVLTREE__}
{$SETC __AVLTREE__ := 1}

{$I+}
{$SETC AVLTreeIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __MIXEDMODE__}
{$I MixedMode.p}
{$ENDC}

{ The visit stage for AVLWalk() walkProcs }

{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
	AVLVisitStage 				= UInt16;
CONST
	kAVLPreOrder				= 0;
	kAVLInOrder					= 1;
	kAVLPostOrder				= 2;

	{	 The order the tree is walked or disposed of. 	}

TYPE
	AVLOrder 					= UInt16;
CONST
	kLeftToRight				= 0;
	kRightToLeft				= 1;

	{	 The type of the node being passed to a callback proc. 	}

TYPE
	AVLNodeType 				= UInt16;
CONST
	kAVLIsTree					= 0;
	kAVLIsLeftBranch			= 1;
	kAVLIsRightBranch			= 2;
	kAVLIsLeaf					= 3;
	kAVLNullNode				= 4;

	errItemAlreadyInTree		= -960;
	errNotValidTree				= -961;
	errItemNotFoundInTree		= -962;
	errCanNotInsertWhileWalkProcInProgress = -963;
	errTreeIsLocked				= -964;

	{   The structure of a tree.  It's opaque; don't assume it's 36 bytes in size. }

TYPE
	AVLTreeStructPtr = ^AVLTreeStruct;
	AVLTreeStruct = RECORD
		signature:				OSType;
		privateStuff:			ARRAY [0..7] OF UInt32;
	END;

	AVLTreePtr							= ^AVLTreeStruct;
	{
	    Every tree must have a function which compares the data for two items and returns < 0, 0, or >0
	    for the items - < 0 if the first item is 'before' the second item according to some criteria,
	    == 0 if the two items are identical according to the criteria, or > 0 if the first item is
	    'after' the second item according to the criteria.  The comparison function is also passed the
	    node type, but most of the time this can be ignored.
	}
{$IFC TYPED_FUNCTION_POINTERS}
	AVLCompareItemsProcPtr = FUNCTION(tree: AVLTreePtr; i1: UNIV Ptr; i2: UNIV Ptr; nd_typ: AVLNodeType): SInt32;
{$ELSEC}
	AVLCompareItemsProcPtr = ProcPtr;
{$ENDC}

	{
	    Every tree must have a itemSizeProc; this routine gets passed a pointer to the item's data and
	    returns the size of the data.  If a tree contains records of a fixed size, this function can
	    just return sizeof( that-struct ); otherwise it should calculate the size of the item based on
	    the data for the item.
	}
{$IFC TYPED_FUNCTION_POINTERS}
	AVLItemSizeProcPtr = FUNCTION(tree: AVLTreePtr; itemPtr: UNIV Ptr): UInt32;
{$ELSEC}
	AVLItemSizeProcPtr = ProcPtr;
{$ENDC}

	{
	    A tree may have an optional disposeItemProc, which gets called whenever an item is removed
	    from the tree ( via AVLRemove() or when AVLDispose() deletes all of the items in the tree ).
	    This might be useful if the nodes in the tree own 'resources'  ( like, open files ) which
	    should be released before the item is removed.
	}
{$IFC TYPED_FUNCTION_POINTERS}
	AVLDisposeItemProcPtr = PROCEDURE(tree: AVLTreePtr; dataP: UNIV Ptr);
{$ELSEC}
	AVLDisposeItemProcPtr = ProcPtr;
{$ENDC}

	{
	    The common way to iterate across all of the items in a tree is via AVLWalk(), which takes
	    a walkProcPtr.  This function will get called for every item in the tree three times, as
	    the tree is being walked across.  First, the walkProc will get called with visitStage ==
	    kAVLPreOrder, at which point internally the node of the tree for the given data has just
	    been reached.  Later, this function will get called with visitStage == kAVLInOrder, and
	    lastly this function will get called with visitStage == kAVLPostOrder.
	    The 'minimum' item in the tree will get called with visitStage == kInOrder first, followed
	    by the 'next' item in the tree, up until the last item in the tree structure is called.
	    In general, you'll only care about calls to this function when visitStage == kAVLInOrder.
	}
{$IFC TYPED_FUNCTION_POINTERS}
	AVLWalkProcPtr = FUNCTION(tree: AVLTreePtr; dataP: UNIV Ptr; visitStage: AVLVisitStage; node: AVLNodeType; level: UInt32; balance: SInt32; refCon: UNIV Ptr): OSErr;
{$ELSEC}
	AVLWalkProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	AVLCompareItemsUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AVLCompareItemsUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	AVLItemSizeUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AVLItemSizeUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	AVLDisposeItemUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AVLDisposeItemUPP = UniversalProcPtr;
{$ENDC}	
{$IFC OPAQUE_UPP_TYPES}
	AVLWalkUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	AVLWalkUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppAVLCompareItemsProcInfo = $00002FF0;
	uppAVLItemSizeProcInfo = $000003F0;
	uppAVLDisposeItemProcInfo = $000003C0;
	uppAVLWalkProcInfo = $000FEBE0;
	{
	 *  NewAVLCompareItemsUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewAVLCompareItemsUPP(userRoutine: AVLCompareItemsProcPtr): AVLCompareItemsUPP; { old name was NewAVLCompareItemsProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewAVLItemSizeUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewAVLItemSizeUPP(userRoutine: AVLItemSizeProcPtr): AVLItemSizeUPP; { old name was NewAVLItemSizeProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewAVLDisposeItemUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewAVLDisposeItemUPP(userRoutine: AVLDisposeItemProcPtr): AVLDisposeItemUPP; { old name was NewAVLDisposeItemProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  NewAVLWalkUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION NewAVLWalkUPP(userRoutine: AVLWalkProcPtr): AVLWalkUPP; { old name was NewAVLWalkProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeAVLCompareItemsUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAVLCompareItemsUPP(userUPP: AVLCompareItemsUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeAVLItemSizeUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAVLItemSizeUPP(userUPP: AVLItemSizeUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeAVLDisposeItemUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAVLDisposeItemUPP(userUPP: AVLDisposeItemUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  DisposeAVLWalkUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeAVLWalkUPP(userUPP: AVLWalkUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeAVLCompareItemsUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeAVLCompareItemsUPP(tree: AVLTreePtr; i1: UNIV Ptr; i2: UNIV Ptr; nd_typ: AVLNodeType; userRoutine: AVLCompareItemsUPP): SInt32; { old name was CallAVLCompareItemsProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeAVLItemSizeUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeAVLItemSizeUPP(tree: AVLTreePtr; itemPtr: UNIV Ptr; userRoutine: AVLItemSizeUPP): UInt32; { old name was CallAVLItemSizeProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeAVLDisposeItemUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE InvokeAVLDisposeItemUPP(tree: AVLTreePtr; dataP: UNIV Ptr; userRoutine: AVLDisposeItemUPP); { old name was CallAVLDisposeItemProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InvokeAVLWalkUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeAVLWalkUPP(tree: AVLTreePtr; dataP: UNIV Ptr; visitStage: AVLVisitStage; node: AVLNodeType; level: UInt32; balance: SInt32; refCon: UNIV Ptr; userRoutine: AVLWalkUPP): OSErr; { old name was CallAVLWalkProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
    Create an AVL tree.  The compareItemsProc and the sizeItemProc are required; disposeItemProc is
    optional and can be nil.  The refCon is stored with the list, and is passed back to the
    compareItemsProc, sizeItemProc, and disposeItemsProc calls.  The allocation of the tree ( and all
    nodes later added to the list with AVLInsert ) will be created in what is the current zone at the
    time AVLInit() is called.  Always call AVLDispose() to dispose of a list created with AVLInit().
}
{
 *  AVLInit()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AVLInit(flags: UInt32; compareItemsProc: AVLCompareItemsUPP; sizeItemProc: AVLItemSizeUPP; disposeItemProc: AVLDisposeItemUPP; refCon: UNIV Ptr; VAR tree: AVLTreePtr): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0C01, $AA80;
	{$ENDC}

{
    Dispose of an AVL tree.  This will dispose of each item in the tree in the order specified,
    call the tree's disposeProc proc for each item, and then dispose of the space allocated for
    the tree itself.
}
{
 *  AVLDispose()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AVLDispose(VAR tree: AVLTreePtr; order: AVLOrder): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0302, $AA80;
	{$ENDC}

{
    Iterate across all of the items in the tree, in the order specified.  kLeftToRight is
    basically lowest-to-highest order, kRightToLeft is highest-to-lowest order.  For each
    node in the tree, it will call the walkProc with three messages ( at the appropriate 
    time ).  First, with kAVLPreOrder when the walking gets to this node in the tree,
    before handling either the left or right subtree, secondly, with kAVLInOrder after
    handling one subtree but before handling the other, and lastly with kAVLPostOrder after
    handling both subtrees.  If you want to handle items in order, then only do something
    if the visit stage is kAVLInOrder.  You can only call AVLRemove() from inside a walkProc
    if visit stage is kAVLPostOrder ( because if you remove a node during the pre or in order
    stages you will corrupt the list ) OR if you return a non-zero result from the walkProc
    call which called AVLRemove() to immediately terminate the walkProc.  Do not call AVLInsert()
    to insert a node into the tree from inside a walkProc.
    The walkProc function gets called with the AVLTreePtr, a pointer to the data for the
    current node ( which you can change in place as long as you do not affect the order within
    the tree ), the visit stage, the type of the current node ( leaf node, right or left branch,
    or full tree ), the level within the tree ( the root is level 1 ), the balance for the
    current node, and the refCon passed to AVLWalk().  This refCon is different from the one passed
    into AVLInit(); use AVLGetRefCon() to get that refCon if you want it inside a walkProc.
    ( Most walkProcs will not care about the values for node type, level, or balance. )
}
{
 *  AVLWalk()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AVLWalk(tree: AVLTreePtr; walkProc: AVLWalkUPP; order: AVLOrder; walkRefCon: UNIV Ptr): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0703, $AA80;
	{$ENDC}

{   Return  the number of items in the given tree. }
{
 *  AVLCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AVLCount(tree: AVLTreePtr; VAR count: UInt32): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0804, $AA80;
	{$ENDC}

{
    Return the one-based index-th item from the tree by putting it's data at dataPtr
    if dataPtr is non-nil, and it's size into *itemSize if itemSize is non-nil.
    If index is out of range, return errItemNotFoundInTree.  ( Internally, this does
    an AVLWalk(), so the tree can not be modified while this call is in progress ).
}
{
 *  AVLGetIndItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AVLGetIndItem(tree: AVLTreePtr; index: UInt32; dataPtr: UNIV Ptr; VAR itemSize: UInt32): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0805, $AA80;
	{$ENDC}

{
    Insert the given item into the tree.  This will call the tree's sizeItemProc
    to determine how big the item at data is, and then will make a copy of the
    item and insert it into the tree in the appropriate place.  If an item already
    exists in the tree with the same key ( so that the compareItemsUPP returns 0
    when asked to compare this item to an existing one ), then it will return
    errItemNotFoundInTree.
}
{
 *  AVLInsert()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AVLInsert(tree: AVLTreePtr; data: UNIV Ptr): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0406, $AA80;
	{$ENDC}

{
    Remove any item from the tree with the given key.  If dataPtr != nil, then
    copy the item's data to dataPtr before removing it from the tree.  Before
    removing the item, call the tree's disposeItemProc to let it release anything
    used by the data in the tree.  It is not necessary to fill in a complete
    record for key, only that the compareItemsProc return 0 when asked to compare
    the data at key with the node in the tree to be deleted.  If the item cannot
    be found in the tree, this will return errItemNotFoundInTree.
}
{
 *  AVLRemove()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AVLRemove(tree: AVLTreePtr; key: UNIV Ptr; dataPtr: UNIV Ptr; VAR itemSize: UInt32): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0807, $AA80;
	{$ENDC}

{
    Find the item in the tree with the given key, and return it's data in
    dataPtr ( if dataPtr != nil ), and it's size in *itemSize ( if itemSize
    != nil ).  It is not necessary to fill in a complete record for key,
    only that the compareItemsProc return 0 when asked to compare the data
    at key with the node in the tree to be deleted.  If the item cannot
    be found in the tree, this will return errItemNotFoundInTree.
}
{
 *  AVLFind()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AVLFind(tree: AVLTreePtr; key: UNIV Ptr; dataPtr: UNIV Ptr; VAR itemSize: UInt32): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0808, $AA80;
	{$ENDC}

{
    Get the refCon for the given tree ( set in AVLInit ) and return it.
    If the given tree is invalid, then return nil.
}
{
 *  AVLGetRefcon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AVLGetRefcon(tree: AVLTreePtr; VAR refCon: UNIV Ptr): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0409, $AA80;
	{$ENDC}

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := AVLTreeIncludes}

{$ENDC} {__AVLTREE__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       Balloons.p
 
     Contains:   Balloon Help Package Interfaces.
 
     Version:    Technology: System 7.0
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1990-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT Balloons;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __BALLOONS__}
{$SETC __BALLOONS__ := 1}

{$I+}
{$SETC BalloonsIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __QUICKDRAW__}
{$I Quickdraw.p}
{$ENDC}
{$IFC UNDEFINED __MENUS__}
{$I Menus.p}
{$ENDC}
{$IFC UNDEFINED __TEXTEDIT__}
{$I TextEdit.p}
{$ENDC}
{$IFC UNDEFINED __MACERRORS__}
{$I MacErrors.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{
   Carbon clients should use MacHelp. The definitions below will NOT work for Carbon and
   are only defined for those files that need to build pre-Carbon applications.
}
{  ��constants }


TYPE
	BalloonVariant 				= SInt16;
CONST
	kTopLeftTipPointsLeftVariant = 0;
	kTopLeftTipPointsUpVariant	= 1;
	kTopRightTipPointsUpVariant	= 2;
	kTopRightTipPointsRightVariant = 3;
	kBottomRightTipPointsRightVariant = 4;
	kBottomRightTipPointsDownVariant = 5;
	kBottomLeftTipPointsDownVariant = 6;
	kBottomLeftTipPointsLeftVariant = 7;
	kBalloonVariantCount		= 8;


	hmBalloonHelpVersion		= $0002;						{  The real version of the Help Manager  }

	kHMHelpMenuID				= -16490;						{  Resource ID and menu ID of help menu  }
	kHMAboutHelpItem			= 1;							{  help menu item number of About Balloon Help�  }
	kHMShowBalloonsItem			= 3;							{  help menu item number of Show/Hide Balloons  }

	kHMHelpID					= -5696;						{  ID of various Help Mgr package resources (in Pack14 range)  }
	kBalloonWDEFID				= 126;							{  Resource ID of the WDEF proc used in standard balloons  }

																{  Dialog item template type constant  }
	helpItem					= 1;							{  key value in DITL template that corresponds to the help item  }

																{  Options for Help Manager resources in 'hmnu', 'hdlg', 'hrct', 'hovr', & 'hfdr' resources  }
	hmDefaultOptions			= 0;							{  default options for help manager resources  }
	hmUseSubIDBit				= 0;
	hmAbsoluteCoordsBit			= 1;
	hmSaveBitsNoWindowBit		= 2;
	hmSaveBitsWindowBit			= 3;
	hmMatchInTitleBit			= 4;
	hmUseSubIDMask				= $01;							{  treat resID's in resources as subID's of driver base ID (for Desk Accessories)  }
	hmAbsoluteCoordsMask		= $02;							{  ignore window port origin and treat rectangles as absolute coords (local to window)  }
	hmSaveBitsNoWindowMask		= $04;							{  don't create a window, just blast bits on screen. No update event is generated  }
	hmSaveBitsWindowMask		= $08;							{  create a window, but restore bits behind window when window goes away & generate update event  }
	hmMatchInTitleMask			= $10;							{  for hwin resources, match string anywhere in window title string  }

{$IFC OLDROUTINENAMES }
	hmUseSubID					= $01;
	hmAbsoluteCoords			= $02;
	hmSaveBitsNoWindow			= $04;
	hmSaveBitsWindow			= $08;
	hmMatchInTitle				= $10;

{$ENDC}  {OLDROUTINENAMES}

																{  Constants for Help Types in 'hmnu', 'hdlg', 'hrct', 'hovr', & 'hfdr' resources  }
	kHMStringItem				= 1;							{  pstring used in resource  }
	kHMPictItem					= 2;							{  'PICT' ResID used in resource  }
	kHMStringResItem			= 3;							{  'STR#' ResID & index used in resource  }
	kHMTEResItem				= 6;							{  Styled Text Edit ResID used in resource ('TEXT' & 'styl')  }
	kHMSTRResItem				= 7;							{  'STR ' ResID used in resource  }
	kHMSkipItem					= 256;							{  don't display a balloon  }
	kHMCompareItem				= 512;							{  Compare pstring in menu item w/ PString in resource item ('hmnu' only)  }
	kHMNamedResourceItem		= 1024;							{  Use pstring in menu item to get 'STR#', 'PICT', or 'STR ' resource ('hmnu' only)  }
	kHMTrackCntlItem			= 2048;							{  Reserved  }

																{  Constants for hmmHelpType's when filling out HMMessageRecord  }
	khmmString					= 1;							{  help message contains a PString  }
	khmmPict					= 2;							{  help message contains a resource ID to a 'PICT' resource  }
	khmmStringRes				= 3;							{  help message contains a res ID & index to a 'STR#' resource  }
	khmmTEHandle				= 4;							{  help message contains a Text Edit handle  }
	khmmPictHandle				= 5;							{  help message contains a Picture handle  }
	khmmTERes					= 6;							{  help message contains a res ID to 'TEXT' & 'styl' resources  }
	khmmSTRRes					= 7;							{  help message contains a res ID to a 'STR ' resource  }
	kHMEnabledItem				= 0;							{  item is enabled, but not checked or control value = 0  }

																{  ResTypes for Styled TE Handles in Resources  }
	kHMTETextResType			= 'TEXT';						{  Resource Type of text data for styled TE record w/o style info  }
	kHMTEStyleResType			= 'styl';						{  Resource Type of style information for styled TE record  }

	kHMDisabledItem				= 1;							{  item is disabled, grayed in menus or disabled in dialogs  }
	kHMCheckedItem				= 2;							{  item is enabled, and checked or control value = 1  }
	kHMOtherItem				= 3;							{  item is enabled, and control value > 1  }
																{  Method parameters to pass to HMShowBalloon  }
	kHMRegularWindow			= 0;							{  Create a regular window floating above all windows  }
	kHMSaveBitsNoWindow			= 1;							{  Just save the bits and draw (for MDEF calls)  }
	kHMSaveBitsWindow			= 2;							{  Regular window, save bits behind, AND generate update event  }

																{  Resource Types for whichType parameter used when extracting 'hmnu' & 'hdlg' messages  }
	kHMMenuResType				= 'hmnu';						{  ResType of help resource for supporting menus  }
	kHMDialogResType			= 'hdlg';						{  ResType of help resource for supporting dialogs  }
	kHMWindListResType			= 'hwin';						{  ResType of help resource for supporting windows  }
	kHMRectListResType			= 'hrct';						{  ResType of help resource for rectangles in windows  }
	kHMOverrideResType			= 'hovr';						{  ResType of help resource for overriding system balloons  }
	kHMFinderApplResType		= 'hfdr';						{  ResType of help resource for custom balloon in Finder  }


TYPE
	HMStringResTypePtr = ^HMStringResType;
	HMStringResType = RECORD
		hmmResID:				INTEGER;
		hmmIndex:				INTEGER;
	END;

	HMMessageRecordPtr = ^HMMessageRecord;
	HMMessageRecord = RECORD
		hmmHelpType:			SInt16;
		CASE INTEGER OF
		0: (
			hmmString:			Str255;
			);
		1: (
			hmmPict:			SInt16;
			);
		2: (
			hmmTEHandle:		TEHandle;
			);
		3: (
			hmmStringRes:		HMStringResType;
			);
		4: (
			hmmPictRes:			SInt16;
			);
		5: (
			hmmPictHandle:		PicHandle;
			);
		6: (
			hmmTERes:			SInt16;
			);
		7: (
			hmmSTRRes:			SInt16;
			);
	END;

	HMMessageRecPtr						= ^HMMessageRecord;
{$IFC TYPED_FUNCTION_POINTERS}
	TipFunctionProcPtr = FUNCTION(tip: Point; structure: RgnHandle; VAR r: Rect; VAR balloonVariant: BalloonVariant): OSErr;
{$ELSEC}
	TipFunctionProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	TipFunctionUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	TipFunctionUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppTipFunctionProcInfo = $00003FE0;
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  NewTipFunctionUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION NewTipFunctionUPP(userRoutine: TipFunctionProcPtr): TipFunctionUPP; { old name was NewTipFunctionProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeTipFunctionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposeTipFunctionUPP(userUPP: TipFunctionUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeTipFunctionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION InvokeTipFunctionUPP(tip: Point; structure: RgnHandle; VAR r: Rect; VAR balloonVariant: BalloonVariant; userRoutine: TipFunctionUPP): OSErr; { old name was CallTipFunctionProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}

{  Public Interfaces  }
{$IFC CALL_NOT_IN_CARBON }
{
 *  HMGetHelpMenuHandle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMGetHelpMenuHandle(VAR mh: MenuRef): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0200, $A830;
	{$ENDC}

{
 *  HMShowBalloon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMShowBalloon({CONST}VAR inHelpMessage: HMMessageRecord; inTip: Point; inHotRect: RectPtr; inTipProc: TipFunctionUPP; inWindowProcID: SInt16; inBalloonVariant: BalloonVariant; inMethod: SInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0B01, $A830;
	{$ENDC}

{
 *  HMShowMenuBalloon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMShowMenuBalloon(itemNum: SInt16; itemMenuID: SInt16; itemFlags: SInt32; itemReserved: SInt32; tip: Point; alternateRect: RectPtr; tipProc: TipFunctionUPP; theProc: SInt16; balloonVariant: BalloonVariant): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0E05, $A830;
	{$ENDC}

{
 *  HMRemoveBalloon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMRemoveBalloon: OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0002, $A830;
	{$ENDC}

{
 *  HMGetIndHelpMsg()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMGetIndHelpMsg(inWhichResType: ResType; inWhichResID: SInt16; inMessageIndex: SInt16; inMessageState: SInt16; VAR outOptions: UInt32; VAR outTip: Point; VAR outHotRect: Rect; VAR outWindowProcID: SInt16; VAR outBalloonVariant: BalloonVariant; VAR outHelpMessage: HMMessageRecord; VAR outMessageCount: SInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $1306, $A830;
	{$ENDC}

{
 *  HMIsBalloon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMIsBalloon: BOOLEAN;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0007, $A830;
	{$ENDC}

{
 *  HMGetBalloons()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMGetBalloons: BOOLEAN;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0003, $A830;
	{$ENDC}

{
 *  HMSetBalloons()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMSetBalloons(flag: BOOLEAN): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0104, $A830;
	{$ENDC}

{
 *  HMSetFont()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMSetFont(font: SInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0108, $A830;
	{$ENDC}

{
 *  HMSetFontSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMSetFontSize(fontSize: UInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0109, $A830;
	{$ENDC}

{
 *  HMGetFont()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMGetFont(VAR font: SInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $020A, $A830;
	{$ENDC}

{
 *  HMGetFontSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMGetFontSize(VAR fontSize: UInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $020B, $A830;
	{$ENDC}

{
 *  HMSetDialogResID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMSetDialogResID(resID: SInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $010C, $A830;
	{$ENDC}

{
 *  HMSetMenuResID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMSetMenuResID(menuID: SInt16; resID: SInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $020D, $A830;
	{$ENDC}

{
 *  HMBalloonRect()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMBalloonRect({CONST}VAR inMessage: HMMessageRecord; VAR outRect: Rect): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $040E, $A830;
	{$ENDC}

{
 *  HMBalloonPict()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMBalloonPict({CONST}VAR inMessage: HMMessageRecord; VAR outPict: PicHandle): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $040F, $A830;
	{$ENDC}

{
 *  HMScanTemplateItems()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMScanTemplateItems(whichID: SInt16; whichResFile: SInt16; whichType: ResType): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0410, $A830;
	{$ENDC}

{
 *  HMExtractHelpMsg()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMExtractHelpMsg(inType: ResType; inResID: SInt16; inMessageIndex: SInt16; inMessageState: SInt16; VAR outMessage: HMMessageRecord): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0711, $A830;
	{$ENDC}

{
 *  HMGetDialogResID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMGetDialogResID(VAR resID: SInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0213, $A830;
	{$ENDC}

{
 *  HMGetMenuResID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMGetMenuResID(menuID: SInt16; VAR resID: SInt16): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0314, $A830;
	{$ENDC}

{
 *  HMGetBalloonWindow()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION HMGetBalloonWindow(VAR window: WindowRef): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $303C, $0215, $A830;
	{$ENDC}





{$ENDC}  {CALL_NOT_IN_CARBON}

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := BalloonsIncludes}

{$ENDC} {__BALLOONS__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       Carbon.p
 
     Contains:   Master include for all of Carbon
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 2000-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT Carbon;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CARBON__}
{$SETC __CARBON__ := 1}

{$I+}
{$SETC CarbonIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CORESERVICES__}
{$I CoreServices.p}
{$ENDC}
{$IFC UNDEFINED __APPLICATIONSERVICES__}
{$I ApplicationServices.p}
{$ENDC}

{$IFC UNDEFINED __APPLICATIONSERVICES__}
{$I ApplicationServices.p}
{$ENDC}
{$IFC UNDEFINED __BALLOONS__}
{$I Balloons.p}
{$ENDC}
{$IFC UNDEFINED __EVENTS__}
{$I Events.p}
{$ENDC}
{$IFC UNDEFINED __PROCESSES__}
{$I Processes.p}
{$ENDC}
{$IFC UNDEFINED __NOTIFICATION__}
{$I Notification.p}
{$ENDC}
{$IFC UNDEFINED __DRAG__}
{$I Drag.p}
{$ENDC}
{$IFC UNDEFINED __ICONS__}
{$I Icons.p}
{$ENDC}
{$IFC UNDEFINED __CONTROLS__}
{$I Controls.p}
{$ENDC}
{$IFC UNDEFINED __APPEARANCE__}
{$I Appearance.p}
{$ENDC}
{$IFC UNDEFINED __MACWINDOWS__}
{$I MacWindows.p}
{$ENDC}
{$IFC UNDEFINED __TEXTEDIT__}
{$I TextEdit.p}
{$ENDC}
{$IFC UNDEFINED __MENUS__}
{$I Menus.p}
{$ENDC}
{$IFC UNDEFINED __DIALOGS__}
{$I Dialogs.p}
{$ENDC}
{$IFC UNDEFINED __LISTS__}
{$I Lists.p}
{$ENDC}
{$IFC UNDEFINED __CARBONEVENTS__}
{$I CarbonEvents.p}
{$ENDC}
{$IFC UNDEFINED __TEXTSERVICES__}
{$I TextServices.p}
{$ENDC}
{$IFC UNDEFINED __SCRAP__}
{$I Scrap.p}
{$ENDC}
{$IFC UNDEFINED __MACTEXTEDITOR__}
{$I MacTextEditor.p}
{$ENDC}
{$IFC UNDEFINED __MACHELP__}
{$I MacHelp.p}
{$ENDC}
{$IFC UNDEFINED __CONTROLDEFINITIONS__}
{$I ControlDefinitions.p}
{$ENDC}
{$IFC UNDEFINED __TSMTE__}
{$I TSMTE.p}
{$ENDC}
{$IFC UNDEFINED __TRANSLATIONEXTENSIONS__}
{$I TranslationExtensions.p}
{$ENDC}
{$IFC UNDEFINED __TRANSLATION__}
{$I Translation.p}
{$ENDC}
{$IFC UNDEFINED __AEINTERACTION__}
{$I AEInteraction.p}
{$ENDC}
{$IFC UNDEFINED __TYPESELECT__}
{$I TypeSelect.p}
{$ENDC}
{$IFC UNDEFINED __INTERNETCONFIG__}
{$I InternetConfig.p}
{$ENDC}
{$IFC UNDEFINED __MACAPPLICATION__}
{$I MacApplication.p}
{$ENDC}
{$IFC UNDEFINED __KEYBOARDS__}
{$I Keyboards.p}
{$ENDC}
{$IFC UNDEFINED __SOUND__}
{$I Sound.p}
{$ENDC}
{$IFC UNDEFINED __OSA__}
{$I OSA.p}
{$ENDC}
{$IFC UNDEFINED __OSACOMP__}
{$I OSAComp.p}
{$ENDC}
{$IFC UNDEFINED __OSAGENERIC__}
{$I OSAGeneric.p}
{$ENDC}
{$IFC UNDEFINED __APPLESCRIPT__}
{$I AppleScript.p}
{$ENDC}
{$IFC UNDEFINED __ASDEBUGGING__}
{$I ASDebugging.p}
{$ENDC}
{$IFC UNDEFINED __ASREGISTRY__}
{$I ASRegistry.p}
{$ENDC}
{$IFC UNDEFINED __FINDERREGISTRY__}
{$I FinderRegistry.p}
{$ENDC}
{$IFC UNDEFINED __PMAPPLICATION__}
{$I PMApplication.p}
{$ENDC}
{$IFC UNDEFINED __NAVIGATION__}
{$I Navigation.p}
{$ENDC}
{$IFC UNDEFINED __URLACCESS__}
{$I URLAccess.p}
{$ENDC}
{$IFC UNDEFINED __COLORPICKER__}
{$I ColorPicker.p}
{$ENDC}
{$IFC UNDEFINED __CMCALIBRATOR__}
{$I CMCalibrator.p}
{$ENDC}
{$IFC UNDEFINED __HTMLRENDERING__}
{$I HTMLRendering.p}
{$ENDC}
{$IFC UNDEFINED __SPEECHRECOGNITION__}
{$I SpeechRecognition.p}
{$ENDC}
{$IFC UNDEFINED __NSL__}
{$I NSL.p}
{$ENDC}
{$IFC UNDEFINED __KEYCHAINHI__}
{$I KeychainHI.p}
{$ENDC}
{$IFC UNDEFINED __IBCARBONRUNTIME__}
{$I IBCarbonRuntime.p}
{$ENDC}
{$IFC UNDEFINED __APPLEHELP__}
{$I AppleHelp.p}
{$ENDC}
{$IFC UNDEFINED __ICAAPPLICATION__}
{$I ICAApplication.p}
{$ENDC}
{$IFC UNDEFINED __ICADEVICE__}
{$I ICADevice.p}
{$ENDC}
{$IFC UNDEFINED __ICACAMERA__}
{$I ICACamera.p}
{$ENDC}



{$SETC UsingIncludes := CarbonIncludes}

{$ENDC} {__CARBON__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CarbonEvents.p
 
     Contains:   Carbon Event Manager
 
     Version:    Technology: Mac OS X/CarbonLib 1.3
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CarbonEvents;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CARBONEVENTS__}
{$SETC __CARBONEVENTS__ := 1}

{$I+}
{$SETC CarbonEventsIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __EVENTS__}
{$I Events.p}
{$ENDC}
{$IFC UNDEFINED __MENUS__}
{$I Menus.p}
{$ENDC}
{$IFC UNDEFINED __CONTROLS__}
{$I Controls.p}
{$ENDC}
{$IFC UNDEFINED __MACWINDOWS__}
{$I MacWindows.p}
{$ENDC}
{$IFC UNDEFINED __CFSTRING__}
{$I CFString.p}
{$ENDC}
{$IFC UNDEFINED __AEREGISTRY__}
{$I AERegistry.p}
{$ENDC}
{$IFC UNDEFINED __AEDATAMODEL__}
{$I AEDataModel.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{======================================================================================}
{  EVENT COMMON                                                                        }
{======================================================================================}



{
 *  Discussion:
 *    The following are all errors which can be returned from the
 *    routines contained in this file.
 }

CONST
	eventAlreadyPostedErr		= -9860;
	eventClassInvalidErr		= -9862;
	eventClassIncorrectErr		= -9864;
	eventHandlerAlreadyInstalledErr = -9866;
	eventInternalErr			= -9868;
	eventKindIncorrectErr		= -9869;
	eventParameterNotFoundErr	= -9870;
	eventNotHandledErr			= -9874;
	eventLoopTimedOutErr		= -9875;
	eventLoopQuitErr			= -9876;
	eventNotInQueueErr			= -9877;
	eventHotKeyExistsErr		= -9878;
	eventHotKeyInvalidErr		= -9879;

	{	======================================================================================	}
	{	  EVENT CORE                                                                          	}
	{	======================================================================================	}
	{	��������������������������������������������������������������������������������������	}
	{	  � Event Flags, options                                                              	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  EventPriority
	 *  
	 *  Discussion:
	 *    These values define the relative priority of an event, and are
	 *    used when posting events with PostEventToQueue. In general events
	 *    are pulled from the queue in order of first posted to last
	 *    posted. These priorities are a way to alter that when posting
	 *    events. You can post a standard priority event and then a high
	 *    priority event and the high priority event will be pulled from
	 *    the queue first.
	 	}

TYPE
	EventPriority 				= SInt16;
CONST
	kEventPriorityLow			= 0;
	kEventPriorityStandard		= 1;
	kEventPriorityHigh			= 2;

	kEventLeaveInQueue			= false;
	kEventRemoveFromQueue		= true;

	{	��������������������������������������������������������������������������������������	}
	{	 � Event Times                                                                        	}
	{	                                                                                      	}
	{	 EventTime is in seconds since boot. Use the constants to make life easy.             	}
	{	��������������������������������������������������������������������������������������	}

TYPE
	EventTime							= Double;
	EventTimeout						= EventTime;
	EventTimerInterval					= EventTime;

CONST
	kEventDurationSecond		= 1.0;
	kEventDurationMillisecond	= kEventDurationSecond/1000;
	kEventDurationMicrosecond	= kEventDurationSecond/1000000;
	kEventDurationNanosecond	= kEventDurationSecond/1000000000;
	kEventDurationMinute		= kEventDurationSecond*60;
	kEventDurationHour			= kEventDurationMinute*60;
	kEventDurationDay			= kEventDurationHour*24;
	kEventDurationNoWait		= 0.0;
	kEventDurationForever		= -1.0;


	{	��������������������������������������������������������������������������������������	}
	{	 EventTypeSpec structure                                                              	}
	{	                                                                                      	}
	{	 This structure is used in many routines to pass a list of event types to a function. 	}
	{	 You typically would declare a const array of these types to pass in.                 	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  EventTypeSpec
	 *  
	 *  Discussion:
	 *    This structure is used to specify an event. Typically, a static
	 *    array of EventTypeSpecs are passed into functions such as
	 *    InstallEventHandler, as well as routines such as
	 *    FlushEventsMatchingListFromQueue.
	 	}

TYPE
	EventTypeSpecPtr = ^EventTypeSpec;
	EventTypeSpec = RECORD
		eventClass:				UInt32;
		eventKind:				UInt32;
	END;


	{
	 *  Discussion:
	 *    These are returned from calls to TrackMouseLocation and
	 *    TrackMouseRegion. Those routines are designed as replacements to
	 *    calls such as StillDown and WaitMouseUp. The advantage over those
	 *    routines is that TrackMouseLocation and TrackMouseRegion will
	 *    block if the user is not moving the mouse, whereas mouse tracking
	 *    loops based on StillDown and WaitMouseUp will spin, chewing up
	 *    valuable CPU time that could be better spent elsewhere. It is
	 *    highly recommended that any tracking loops in your application
	 *    stop using StillDown and WaitMouseUp and start using
	 *    TrackMouseLocation/Region. See the notes on those routines for
	 *    more information.
	 	}

CONST
	kTrackMouseLocationOptionDontConsumeMouseUp = $01;


TYPE
	MouseTrackingResult 		= UInt16;
CONST
	kMouseTrackingMousePressed	= 1;
	kMouseTrackingMouseReleased	= 2;
	kMouseTrackingMouseExited	= 3;
	kMouseTrackingMouseEntered	= 4;
	kMouseTrackingMouseMoved	= 5;
	kMouseTrackingKeyModifiersChanged = 6;
	kMouseTrackingUserCancelled	= 7;
	kMouseTrackingTimedOut		= 8;


TYPE
	EventParamName						= OSType;
	EventParamType						= OSType;
	{	��������������������������������������������������������������������������������������	}
	{	  � EventLoop                                                                         	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  EventLoopRef
	 *  
	 *  Discussion:
	 *    An EventLoopRef represents an 'event loop', which is the
	 *    conceptual entity that you 'run' to fetch events from hardware
	 *    and other sources and also fires timers that might be installed
	 *    with InstallEventLoopTimer. The term 'run' is a bit of a
	 *    misnomer, as the event loop's goal is to stay as blocked as
	 *    possible to minimize CPU usage for the current application. The
	 *    event loop is run implicitly thru APIs like ReceiveNextEvent,
	 *    RunApplicationEventLoop, or even WaitNextEvent. It can also be
	 *    run explicitly thru a call to RunCurrentEventLoop. Each
	 *    preemptive thread can have an event loop. Cooperative threads
	 *    share the main thread's event loop.
	 	}
	EventLoopRef    = ^LONGINT; { an opaque 32-bit type }
	EventLoopRefPtr = ^EventLoopRef;  { when a VAR xx:EventLoopRef parameter can be nil, it is changed to xx: EventLoopRefPtr }
	{
	 *  GetCurrentEventLoop()
	 *  
	 *  Discussion:
	 *    Returns the current event loop for the current thread. If the
	 *    current thread is a cooperative thread, the main event loop is
	 *    returned.
	 *  
	 *  Result:
	 *    An event loop reference.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION GetCurrentEventLoop: EventLoopRef;

{
 *  GetMainEventLoop()
 *  
 *  Discussion:
 *    Returns the event loop object for the main application thread.
 *  
 *  Result:
 *    An event loop reference.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetMainEventLoop: EventLoopRef;


{
 *  RunCurrentEventLoop()
 *  
 *  Discussion:
 *    This routine 'runs' the event loop, returning only if aborted or
 *    the timeout specified is reached. The event loop is mostly
 *    blocked while in this function, occasionally waking up to fire
 *    timers or pick up events. The typical use of this function is to
 *    cause the current thread to wait for some operation to complete,
 *    most likely on another thread of execution.
 *  
 *  Parameters:
 *    
 *    inTimeout:
 *      The time to wait until returning (can be kEventDurationForever).
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION RunCurrentEventLoop(inTimeout: EventTimeout): OSStatus;

{
 *  QuitEventLoop()
 *  
 *  Discussion:
 *    Causes a specific event loop to terminate. Usage of this is
 *    similar to WakeUpProcess, in that it causes the eventloop
 *    specified to return immediately (as opposed to timing out).
 *    Typically this call is used in conjunction with
 *    RunCurrentEventLoop.
 *  
 *  Parameters:
 *    
 *    inEventLoop:
 *      The event loop to terminate.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION QuitEventLoop(inEventLoop: EventLoopRef): OSStatus;

{��������������������������������������������������������������������������������������}
{  � Low-level event fetching                                                          }
{��������������������������������������������������������������������������������������}
{
 *  ReceiveNextEvent()
 *  
 *  Discussion:
 *    This routine tries to fetch the next event of a specified type.
 *    If no events in the event queue match, this routine will run the
 *    current event loop until an event that matches arrives, or the
 *    timeout expires. Except for timers firing, your application is
 *    blocked waiting for events to arrive when inside this function.
 *  
 *  Parameters:
 *    
 *    inNumTypes:
 *      The number of event types we are waiting for (0 if any event
 *      should cause this routine to return).
 *    
 *    inList:
 *      The list of event types we are waiting for (pass NULL if any
 *      event should cause this routine to return).
 *    
 *    inTimeout:
 *      The time to wait (passing kEventDurationForever is preferred).
 *    
 *    inPullEvent:
 *      Pass true for this parameter to actually remove the next
 *      matching event from the queue.
 *    
 *    outEvent:
 *      The next event that matches the list passed in. If inPullEvent
 *      is true, the event is owned by you, and you will need to
 *      release it when done.
 *  
 *  Result:
 *    A result indicating whether an event was received, the timeout
 *    expired, or the current event loop was quit.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ReceiveNextEvent(inNumTypes: UInt32; {CONST}VAR inList: EventTypeSpec; inTimeout: EventTimeout; inPullEvent: BOOLEAN; VAR outEvent: EventRef): OSStatus;

{��������������������������������������������������������������������������������������}
{  � Core event lifetime APIs                                                          }
{��������������������������������������������������������������������������������������}

TYPE
	EventAttributes 			= UInt32;
CONST
	kEventAttributeNone			= 0;
	kEventAttributeUserEvent	= $01;

	{
	 *  [Mac]CreateEvent()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CreateEvent(inAllocator: CFAllocatorRef; inClassID: UInt32; kind: UInt32; when: EventTime; flags: EventAttributes; VAR outEvent: EventRef): OSStatus;

{
 *  CopyEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CopyEvent(inOther: EventRef): EventRef;

{
 *  RetainEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION RetainEvent(inEvent: EventRef): EventRef;

{
 *  GetEventRetainCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetEventRetainCount(inEvent: EventRef): UInt32;

{
 *  ReleaseEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE ReleaseEvent(inEvent: EventRef);

{
 *  SetEventParameter()
 *  
 *  Discussion:
 *    Sets a piece of data for the given event.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to set the data for.
 *    
 *    inName:
 *      The symbolic name of the parameter.
 *    
 *    inType:
 *      The symbolic type of the parameter.
 *    
 *    inSize:
 *      The size of the parameter data.
 *    
 *    inDataPtr:
 *      The pointer to the parameter data.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetEventParameter(inEvent: EventRef; inName: EventParamName; inType: EventParamType; inSize: UInt32; inDataPtr: UNIV Ptr): OSStatus;


{
 *  GetEventParameter()
 *  
 *  Discussion:
 *    Gets a piece of data from the given event, if it exists.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to get the parameter from.
 *    
 *    inName:
 *      The symbolic name of the parameter.
 *    
 *    inDesiredType:
 *      The desired type of the parameter. At present we do not support
 *      coercion, so this parameter must be the actual type of data
 *      stored in the event, or an error will be returned.
 *    
 *    outActualType:
 *      The actual type of the parameter, can be NULL if you are not
 *      interested in receiving this information.
 *    
 *    inBufferSize:
 *      The size of the output buffer specified by ioBuffer.
 *    
 *    outActualSize:
 *      The actual size of the data, or NULL if you don't want this
 *      information.
 *    
 *    outData:
 *      The pointer to the buffer which will receive the parameter data.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetEventParameter(inEvent: EventRef; inName: EventParamName; inDesiredType: EventParamType; VAR outActualType: EventParamType; inBufferSize: UInt32; VAR outActualSize: UInt32; outData: UNIV Ptr): OSStatus;


{��������������������������������������������������������������������������������������}
{  � Getters for 'base-class' event info                                               }
{��������������������������������������������������������������������������������������}
{
 *  GetEventClass()
 *  
 *  Discussion:
 *    Returns the class of the given event, such as mouse, keyboard,
 *    etc.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event in question.
 *  
 *  Result:
 *    The class ID of the event.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetEventClass(inEvent: EventRef): UInt32;

{
 *  GetEventKind()
 *  
 *  Discussion:
 *    Returns the kind of the given event (mousedown, etc.). Event
 *    kinds overlap between event classes, e.g. kEventMouseDown and
 *    kEventAppActivated have the same value (1). The combination of
 *    class and kind is what determines an event signature.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event in question.
 *  
 *  Result:
 *    The kind of the event.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetEventKind(inEvent: EventRef): UInt32;

{
 *  GetEventTime()
 *  
 *  Discussion:
 *    Returns the time the event specified occurred, specified in
 *    EventTime, which is a floating point number representing seconds
 *    since the last system startup.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event in question.
 *  
 *  Result:
 *    The time the event occurred.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetEventTime(inEvent: EventRef): EventTime;

{��������������������������������������������������������������������������������������}
{  � Setters for 'base-class' event info                                               }
{��������������������������������������������������������������������������������������}

{
 *  SetEventTime()
 *  
 *  Discussion:
 *    This routine allows you to set the time of a given event, if you
 *    so desire. In general, you would never use this routine, except
 *    for those special cases where you reuse an event from time to
 *    time instead of creating a new event each time.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event in question.
 *    
 *    inTime:
 *      The new time.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetEventTime(inEvent: EventRef; inTime: EventTime): OSStatus;

{��������������������������������������������������������������������������������������}
{  � Event Queue routines (posting, finding, flushing)                                 }
{��������������������������������������������������������������������������������������}


TYPE
	EventQueueRef    = ^LONGINT; { an opaque 32-bit type }
	EventQueueRefPtr = ^EventQueueRef;  { when a VAR xx:EventQueueRef parameter can be nil, it is changed to xx: EventQueueRefPtr }
	{
	 *  GetCurrentEventQueue()
	 *  
	 *  Discussion:
	 *    Returns the current event queue for the current thread. If the
	 *    current thread is a cooperative thread, the main event queue is
	 *    returned.
	 *  
	 *  Result:
	 *    An event queue reference.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION GetCurrentEventQueue: EventQueueRef;

{
 *  GetMainEventQueue()
 *  
 *  Discussion:
 *    Returns the event queue object for the main application thread.
 *  
 *  Result:
 *    An event queue reference.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetMainEventQueue: EventQueueRef;


{
 *  EventComparatorProcPtr
 *  
 *  Discussion:
 *    Type of a callback function used by queue searches.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to compare.
 *    
 *    inCompareData:
 *      The data used to compare the event.
 *  
 *  Result:
 *    A boolean value indicating whether the event matches (true) or
 *    not (false).
 }

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	EventComparatorProcPtr = FUNCTION(inEvent: EventRef; inCompareData: UNIV Ptr): BOOLEAN;
{$ELSEC}
	EventComparatorProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	EventComparatorUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	EventComparatorUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppEventComparatorProcInfo = $000003D0;
	{
	 *  NewEventComparatorUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewEventComparatorUPP(userRoutine: EventComparatorProcPtr): EventComparatorUPP; { old name was NewEventComparatorProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeEventComparatorUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeEventComparatorUPP(userUPP: EventComparatorUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeEventComparatorUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeEventComparatorUPP(inEvent: EventRef; inCompareData: UNIV Ptr; userRoutine: EventComparatorUPP): BOOLEAN; { old name was CallEventComparatorProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  PostEventToQueue()
 *  
 *  Discussion:
 *    Posts an event to the queue specified. This automatically wakes
 *    up the event loop of the thread the queue belongs to. After
 *    posting the event, you should release the event. The event queue
 *    retains it.
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to post the event onto.
 *    
 *    inEvent:
 *      The event to post.
 *    
 *    inPriority:
 *      The priority of the event.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION PostEventToQueue(inQueue: EventQueueRef; inEvent: EventRef; inPriority: EventPriority): OSStatus;

{
 *  FlushEventsMatchingListFromQueue()
 *  
 *  Discussion:
 *    Flushes events matching a specified list of classes and kinds
 *    from an event queue.
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to flush events from.
 *    
 *    inNumTypes:
 *      The number of event kinds to flush.
 *    
 *    inList:
 *      The list of event classes and kinds to flush from the queue.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FlushEventsMatchingListFromQueue(inQueue: EventQueueRef; inNumTypes: UInt32; {CONST}VAR inList: EventTypeSpec): OSStatus;

{
 *  FlushSpecificEventsFromQueue()
 *  
 *  Discussion:
 *    Flushes events that match a comparator function.
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to flush events from.
 *    
 *    inComparator:
 *      The comparison function to invoke for each event in the queue.
 *    
 *    inCompareData:
 *      The data you wish to pass to your comparison function.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FlushSpecificEventsFromQueue(inQueue: EventQueueRef; inComparator: EventComparatorUPP; inCompareData: UNIV Ptr): OSStatus;

{
 *  FlushEventQueue()
 *  
 *  Discussion:
 *    Flushes all events from an event queue.
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to flush.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FlushEventQueue(inQueue: EventQueueRef): OSStatus;

{
 *  FindSpecificEventInQueue()
 *  
 *  Discussion:
 *    Returns the first event that matches a comparator function, or
 *    NULL if no events match.
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to search.
 *    
 *    inComparator:
 *      The comparison function to invoke for each event in the queue.
 *    
 *    inCompareData:
 *      The data you wish to pass to your comparison function.
 *  
 *  Result:
 *    An event reference.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION FindSpecificEventInQueue(inQueue: EventQueueRef; inComparator: EventComparatorUPP; inCompareData: UNIV Ptr): EventRef;

{
 *  GetNumEventsInQueue()
 *  
 *  Discussion:
 *    Returns the number of events in an event queue.
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to query.
 *  
 *  Result:
 *    The number of items in the queue.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetNumEventsInQueue(inQueue: EventQueueRef): UInt32;

{
 *  RemoveEventFromQueue()
 *  
 *  Discussion:
 *    Removes the given event from the queue which it was posted. When
 *    you call this function, the event ownership is transferred to
 *    you, the caller, at no charge. You must release the event when
 *    you are through with it.
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The queue to remove the event from.
 *    
 *    inEvent:
 *      The event to remove.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION RemoveEventFromQueue(inQueue: EventQueueRef; inEvent: EventRef): OSStatus;

{
 *  IsEventInQueue()
 *  
 *  Discussion:
 *    Returns true if the specified event is posted to a queue.
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The queue to check.
 *    
 *    inEvent:
 *      The event in question.
 *  
 *  Result:
 *    A boolean value.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION IsEventInQueue(inQueue: EventQueueRef; inEvent: EventRef): BOOLEAN;

{��������������������������������������������������������������������������������������}
{  � Helpful utilities                                                                 }
{��������������������������������������������������������������������������������������}

{
 *  GetCurrentEventTime()
 *  
 *  Discussion:
 *    Returns the current time since last system startup in seconds.
 *  
 *  Result:
 *    EventTime.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetCurrentEventTime: EventTime;

{
 *  IsUserCancelEventRef()
 *  
 *  Discussion:
 *    Tests the event given to see whether the event represents a 'user
 *    cancel' event. Currently this is defined to be either the escape
 *    key being pressed, or command-period being pressed.
 *  
 *  Result:
 *    A boolean value indicating whether the event is a user cancel
 *    event.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION IsUserCancelEventRef(event: EventRef): BOOLEAN;

{
 *  TrackMouseLocation()
 *  
 *  Discussion:
 *    Once entered, this routine waits for certain mouse events (move,
 *    mouse down, mouse up). When one of these events occurs, the
 *    function returns and tells the caller what happened and where the
 *    mouse is currently located. While there is no activity, the
 *    current event loop is run, effectively blocking the current
 *    thread (save for any timers that fire). This helps to minimize
 *    CPU usage when there is nothing going on.
 *  
 *  Parameters:
 *    
 *    inPort:
 *      The grafport to consider for mouse coordinates. You can pass
 *      NULL for this parameter to indicate the current port. The mouse
 *      location is returned in terms of local coordinates of this port.
 *    
 *    outPt:
 *      On exit, this parameter receives the mouse location from the
 *      last mouse event that caused this function to exit.
 *    
 *    outResult:
 *      On exit, this parameter receives a value representing what kind
 *      of event was received that cause the function to exit, such as
 *      kMouseTrackingMouseReleased.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION TrackMouseLocation(inPort: GrafPtr; VAR outPt: Point; VAR outResult: MouseTrackingResult): OSStatus;

{
 *  TrackMouseLocationWithOptions()
 *  
 *  Discussion:
 *    Once entered, this routine waits for certain mouse events (move,
 *    mouse down, mouse up). When one of these events occurs, the
 *    function returns and tells the caller what happened and where the
 *    mouse is currently located. While there is no activity, the
 *    current event loop is run, effectively blocking the current
 *    thread (save for any timers that fire). This helps to minimize
 *    CPU usage when there is nothing going on.
 *  
 *  Parameters:
 *    
 *    inPort:
 *      The grafport to consider for mouse coordinates. You can pass
 *      NULL for this parameter to indicate the current port. The mouse
 *      location is returned in terms of local coordinates of this port.
 *    
 *    inOptions:
 *      The only option supported by this routine at present is the
 *      option to have the toolbox leave mouse up events in the queue,
 *      rather than pulling them (which is the default).
 *    
 *    inTimeout:
 *      The amount of time to wait for an event. If no events arrive
 *      within this time, kMouseTrackingTimedOut is returned in
 *      outResult.
 *    
 *    outPt:
 *      On exit, this parameter receives the mouse location from the
 *      last mouse event that caused this function to exit. If a
 *      timeout or key modifiers changed event caused this function to
 *      exit, the current mouse position at the time is returned.
 *    
 *    outModifiers:
 *      On exit, this parameter receives the most recent state of the
 *      keyboard modifiers.
 *    
 *    outResult:
 *      On exit, this parameter receives a value representing what kind
 *      of event was received that cause the function to exit, such as
 *      kMouseTrackingMouseReleased.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION TrackMouseLocationWithOptions(inPort: GrafPtr; inOptions: OptionBits; inTimeout: EventTimeout; VAR outPt: Point; VAR outModifiers: UInt32; VAR outResult: MouseTrackingResult): OSStatus; C;

{
 *  TrackMouseRegion()
 *  
 *  Discussion:
 *    This routine is largely identical to TrackMouseLocation. Please
 *    read the notes on that function as well. The difference between
 *    TrackMouseLocation and TrackMouseRegion is that TrackMouseRegion
 *    only returns when the mouse enters or exits a specified region
 *    that you pass in to the function, as opposed to whenever the
 *    mouse moves (it also returns for mouse up/down events). This is
 *    useful if you don't need to know intermediate mouse events, but
 *    rather just if the mouse enters or leaves an area.
 *  
 *  Parameters:
 *    
 *    inPort:
 *      The grafport to consider for mouse coordinates. You can pass
 *      NULL for this parameter to indicate the current port.
 *    
 *    inRegion:
 *      The region to consider. This should be in the coordinates of
 *      the port you passed to inPort.
 *    
 *    ioWasInRgn:
 *      On enter, this parameter should be set to true if the mouse is
 *      currently inside the region passed in inRegion, or false if the
 *      mouse is currently outside the region. On exit, this parameter
 *      is updated to reflect the current reality, e.g. if the
 *      outResult parameter returns kMouseTrackingMouseExited,
 *      ioWasInRgn will be set to false when this function exits.
 *      Because it is updated from within, you should only need to set
 *      this yourself before the first call to this function in your
 *      tracking loop.
 *    
 *    outResult:
 *      On exit, this parameter receives a value representing what kind
 *      of event was received that cause the function to exit, such as
 *      kMouseTrackingMouseEntered.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION TrackMouseRegion(inPort: GrafPtr; inRegion: RgnHandle; VAR ioWasInRgn: BOOLEAN; VAR outResult: MouseTrackingResult): OSStatus;

{
 *  ConvertEventRefToEventRecord()
 *  
 *  Discussion:
 *    This is a convenience routine to help you if there are places in
 *    your application where you need an EventRecord and all you have
 *    is an EventRef. If the event can be converted, outEvent is filled
 *    in and the function returns true. If not, false is returned and
 *    outEvent will contain a nullEvent.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The EventRef to convert into an EventRecord.
 *    
 *    outEvent:
 *      The EventRecord to fill out.
 *  
 *  Result:
 *    A boolean indicating if the conversion was successful (true) or
 *    not (false).
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ConvertEventRefToEventRecord(inEvent: EventRef; VAR outEvent: EventRecord): BOOLEAN;

{
 *  IsEventInMask()
 *  
 *  Discussion:
 *    This is a companion function for ConvertEventRefToEventRecord,
 *    and is provided as a convenience routine to help you if there are
 *    places in your application where you want to check an EventRef to
 *    see if it matches a classic EventMask bitfield. If the event
 *    matches, the function returns true.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The EventRef to convert into an EventRecord.
 *    
 *    inMask:
 *      The mask to consider.
 *  
 *  Result:
 *    A boolean indicating if the event was considered to be in the
 *    mask provided.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION IsEventInMask(inEvent: EventRef; inMask: EventMask): BOOLEAN;

{
 *  GetLastUserEventTime()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetLastUserEventTime: EventTime;

{��������������������������������������������������������������������������������������}
{  � Timers                                                                            }
{��������������������������������������������������������������������������������������}

{
 *  EventLoopTimerRef
 *  
 *  Discussion:
 *    An EventLoopTimerRef represents what we term a 'timer'. A timer
 *    is a function that is called either once or at regular intervals.
 *    It executes at task level and should not be confused with Time
 *    Manager Tasks or any other interrupt-level callback. This means
 *    you can call Toolbox routines, allocate memory and draw. When a
 *    timer 'fires', it calls a callback that you specify when the
 *    timer is installed. Timers in general have two uses - as a
 *    timeout mechanism and as a periodic task. An everyday example of
 *    using a timer for a timeout might be a light that goes out if no
 *    motion is detected in a room for 5 minutes. For this, you might
 *    install a timer which will fire in 5 minutes. If motion is
 *    detected, you would reset the timer fire time and let the clock
 *    start over. If no motion is detected for the full 5 minutes, the
 *    timer will fire and you could power off the light. A periodic
 *    timer is one that fires at regular intervals (say every second or
 *    so). You might use such a timer to blink the insertion point in
 *    your editor, etc. One advantage of timers is that you can install
 *    the timer right from the code that wants the time. For example,
 *    the standard Toolbox Edit Text control can install a timer to
 *    blink the cursor when it's active, meaning that IdleControls is a
 *    no-op for that control and doesn't need to be called. When the
 *    control is inactive, it removes its timer and doesn't waste CPU
 *    time in that state. NOTE: Currently, if you do decide to draw
 *    when your timer is called, be sure to save and restore the
 *    current port so that calling your timer doesn't inadvertently
 *    change the port out from under someone.
 }

TYPE
	EventLoopTimerRef    = ^LONGINT; { an opaque 32-bit type }
	EventLoopTimerRefPtr = ^EventLoopTimerRef;  { when a VAR xx:EventLoopTimerRef parameter can be nil, it is changed to xx: EventLoopTimerRefPtr }

	{
	 *  EventLoopTimerProcPtr
	 *  
	 *  Discussion:
	 *    Called when a timer fires.
	 *  
	 *  Parameters:
	 *    
	 *    inTimer:
	 *      The timer that fired.
	 *    
	 *    inUserData:
	 *      The data passed into InstallEventLoopTimer.
	 	}
{$IFC TYPED_FUNCTION_POINTERS}
	EventLoopTimerProcPtr = PROCEDURE(inTimer: EventLoopTimerRef; inUserData: UNIV Ptr);
{$ELSEC}
	EventLoopTimerProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	EventLoopTimerUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	EventLoopTimerUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppEventLoopTimerProcInfo = $000003C0;
	{
	 *  NewEventLoopTimerUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewEventLoopTimerUPP(userRoutine: EventLoopTimerProcPtr): EventLoopTimerUPP; { old name was NewEventLoopTimerProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeEventLoopTimerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeEventLoopTimerUPP(userUPP: EventLoopTimerUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeEventLoopTimerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE InvokeEventLoopTimerUPP(inTimer: EventLoopTimerRef; inUserData: UNIV Ptr; userRoutine: EventLoopTimerUPP); { old name was CallEventLoopTimerProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{
 *  InstallEventLoopTimer()
 *  
 *  Discussion:
 *    Installs a timer onto the event loop specified. The timer can
 *    either fire once or repeatedly at a specified interval depending
 *    on the parameters passed to this function.
 *  
 *  Parameters:
 *    
 *    inEventLoop:
 *      The event loop to add the timer.
 *    
 *    inFireDelay:
 *      The delay before first firing this timer (can be 0).
 *    
 *    inInterval:
 *      The timer interval (pass 0 for one-shot timers).
 *    
 *    inTimerProc:
 *      The routine to call when the timer fires.
 *    
 *    inTimerData:
 *      Data to pass to the timer proc when called.
 *    
 *    outTimer:
 *      A reference to the newly installed timer.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InstallEventLoopTimer(inEventLoop: EventLoopRef; inFireDelay: EventTimerInterval; inInterval: EventTimerInterval; inTimerProc: EventLoopTimerUPP; inTimerData: UNIV Ptr; VAR outTimer: EventLoopTimerRef): OSStatus;


{
 *  RemoveEventLoopTimer()
 *  
 *  Discussion:
 *    Removes a timer that was previously installed by a call to
 *    InstallEventLoopTimer. You call this function when you are done
 *    using a timer.
 *  
 *  Parameters:
 *    
 *    inTimer:
 *      The timer to remove.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION RemoveEventLoopTimer(inTimer: EventLoopTimerRef): OSStatus;

{
 *  SetEventLoopTimerNextFireTime()
 *  
 *  Discussion:
 *    This routine is used to 'reset' a timer. It controls the next
 *    time the timer fires. This will override any interval you might
 *    have set. For example, if you have a timer that fires every
 *    second, and you call this function setting the next time to 5
 *    seconds from now, the timer will sleep for 5 seconds, then fire.
 *    It will then resume it's one second interval after that. It is as
 *    if you removed the timer and reinstalled it with a new first-fire
 *    delay.
 *  
 *  Parameters:
 *    
 *    inTimer:
 *      The timer to adjust
 *    
 *    inNextFire:
 *      The interval from the current time to wait until firing the
 *      timer again.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetEventLoopTimerNextFireTime(inTimer: EventLoopTimerRef; inNextFire: EventTimerInterval): OSStatus;

{======================================================================================}
{  EVENT CLASSES                                                                       }
{======================================================================================}

{
 *  Discussion:
 *    Event classes
 }

CONST
	kEventClassMouse			= 'mous';
	kEventClassKeyboard			= 'keyb';
	kEventClassTextInput		= 'text';
	kEventClassApplication		= 'appl';
	kEventClassAppleEvent		= 'eppc';
	kEventClassMenu				= 'menu';
	kEventClassWindow			= 'wind';
	kEventClassControl			= 'cntl';
	kEventClassCommand			= 'cmds';
	kEventClassTablet			= 'tblt';
	kEventClassVolume			= 'vol ';

	{	��������������������������������������������������������������������������������������	}
	{	 Mouse Events                                                                         	}
	{	��������������������������������������������������������������������������������������	}
	{	 Mouse Events 	}

	{
	 *  Discussion:
	 *    Mouse events (kEventClassMouse)
	 	}
	kEventMouseDown				= 1;
	kEventMouseUp				= 2;
	kEventMouseMoved			= 5;
	kEventMouseDragged			= 6;
	kEventMouseWheelMoved		= 10;

	{	
	    Parameters for mouse events:
	
	    kEventMouseDown
	        -->     kEventParamMouseLocation    typeQDPoint
	        -->     kEventParamKeyModifiers     typeUInt32
	        -->     kEventParamMouseButton      typeMouseButton
	        -->     kEventParamClickCount       typeUInt32
	        -->     kEventParamMouseChord       typeUInt32  (X Only)
	
	    kEventMouseUp
	        -->     kEventParamMouseLocation    typeQDPoint
	        -->     kEventParamKeyModifiers     typeUInt32
	        -->     kEventParamMouseButton      typeMouseButton
	        -->     kEventParamClickCount       typeUInt32
	        -->     kEventParamMouseChord       typeUInt32  (X Only)
	
	    kEventMouseMoved
	        -->     kEventParamMouseLocation    typeQDPoint
	        -->     kEventParamKeyModifiers     typeUInt32
	
	    kEventMouseDragged
	        -->     kEventParamMouseLocation    typeQDPoint
	        -->     kEventParamKeyModifiers     typeUInt32
	        -->     kEventParamMouseButton      typeMouseButton
	        -->     kEventParamMouseChord       typeUInt32  (X Only)
	
	    kEventMouseWheelMoved
	        -->     kEventParamMouseLocation    typeQDPoint
	        -->     kEventParamKeyModifiers     typeUInt32
	        -->     kEventParamMouseWheelAxis   typeMouseWheelAxis
	        -->     kEventParamMouseWheelDelta  typeLongInteger
		}

	{
	 *  EventMouseButton
	 *  
	 	}

TYPE
	EventMouseButton 			= UInt16;
CONST
	kEventMouseButtonPrimary	= 1;
	kEventMouseButtonSecondary	= 2;
	kEventMouseButtonTertiary	= 3;



	{
	 *  EventMouseWheelAxis
	 *  
	 	}

TYPE
	EventMouseWheelAxis 		= UInt16;
CONST
	kEventMouseWheelAxisX		= 0;
	kEventMouseWheelAxisY		= 1;




	{	��������������������������������������������������������������������������������������	}
	{	 Text Input Events                                                                    	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Text input events (kEventClassTextInput)
	 *  
	 *  Discussion:
	 *    The following TextInput events reimplement the AppleEvents
	 *    defined in Inside Mac Text - Text Services Manager, and provide
	 *    the benefits of Carbon Event targeting, dispatching and
	 *    propagation to applications that have formerly handled the TSM
	 *    suite of AppleEvents. TextInput handlers may be installed on
	 *    controls, windows, or the application event target (equivalent to
	 *    AppleEvent-based handling). In all cases, if a given TextInput
	 *    handler is not installed, TSM will convert that TextInput to an
	 *    AppleEvent and redispatch via AESend to the current process,
	 *    making adoption as gradual as is desired.
	 	}
	kEventTextInputUpdateActiveInputArea = 1;
	kEventTextInputUnicodeForKeyEvent = 2;
	kEventTextInputOffsetToPos	= 3;
	kEventTextInputPosToOffset	= 4;
	kEventTextInputShowHideBottomWindow = 5;
	kEventTextInputGetSelectedText = 6;

	{	
	    Parameters for TextInput events:
	    
	    kEventTextInputUpdateActiveInputArea
	        Required parameters:
	        -->     kEventParamTextInputSendComponentInstance           typeComponentInstance
	        -->     kEventParamTextInputSendRefCon                      typeLongInteger
	        -->     kEventParamTextInputSendSLRec                       typeIntlWritingCode
	        -->     kEventParamTextInputSendFixLen                      typeLongInteger
	        -->     kEventParamTextInputSendText                        typeUnicodeText, typeChar
	                    (data type depends on TSMDocument type created via NewTSMDocument...
	                     typeChar for kTextService document, typeUnicodeText for kUnicodeDocument)
	        
	        Optional parameters:
	        -->     kEventParamTextInputSendUpdateRng                   typeTextRangeArray
	        -->     kEventParamTextInputSendHiliteRng                   typeTextRangeArray
	        -->     kEventParamTextInputSendClauseRng                   typeOffsetArray
	        -->     kEventParamTextInputSendPinRng                      typeTextRange
	        -->     kEventParamTextInputSendPinRng                      typeTextRange
	        -->     kEventParamTextInputSendTextServiceEncoding         typeUInt32
	        -->     kEventParamTextInputSendTextServiceMacEncoding      typeUInt32
	        
	    kEventTextInputUnicodeForKeyEvent
	        Required parameters:
	        -->     kEventParamTextInputSendComponentInstance           typeComponentInstance
	        -->     kEventParamTextInputSendRefCon                      typeLongInteger
	        -->     kEventParamTextInputSendSLRec                       typeIntlWritingCode
	        -->     kEventParamTextInputSendText                        typeUnicodeText
	        -->     kEventParamTextInputSendKeyboardEvent               typeEventRef
	                    (This parameter is the original raw keyboard event that produced the
	                     text.  It enables access to kEventParamKeyModifiers and 
	                     kEventParamKeyCode parameters.
	                     You can also extract from this event either Unicodes or Mac encoding
	                     characters as follows:
	                            kEventParamKeyUnicodes              typeUnicodeText
	                            kEventParamKeyMacCharCodes          typeChar (if available)
	                     The kEventParamKeyUnicodes parameter of the raw keyboard event is
	                     identical to the TextInput event's kEventParamTextInputSendText
	                     parameter.  Note that when contents of TSM's bottom-line input
	                     window (i.e. during typing Chinese, Korean, or Japanese) are confirmed,
	                     the raw keyboard event's keyCode and modifiers are set to default values.)
	
	    kEventTextInputOffsetToPos
	        Required parameters:
	        -->     kEventParamTextInputSendComponentInstance           typeComponentInstance
	        -->     kEventParamTextInputSendRefCon                      typeLongInteger
	        -->     kEventParamTextInputSendTextOffset                  typeLongInteger
	        <--     kEventParamTextInputReplyPoint                      typeQDPoint
	        
	        Optional parameters:
	        -->     kEventParamTextInputSendSLRec                       typeIntlWritingCode
	        -->     kEventParamTextInputSendLeadingEdge                 typeBoolean
	        <--     kEventParamTextInputReplySLRec                      typeIntlWritingCode
	        <--     kEventParamTextInputReplyFont                       typeLongInteger
	        <--     kEventParamTextInputReplyPointSize                  typeFixed
	        <--     kEventParamTextInputReplyLineHeight                 typeShortInteger
	        <--     kEventParamTextInputReplyLineAscent                 typeShortInteger
	        <--     kEventParamTextInputReplyTextAngle                  typeFixed
	
	    kEventTextInputPosToOffset
	        Required parameters:
	        -->     kEventParamTextInputSendComponentInstance           typeComponentInstance
	        -->     kEventParamTextInputSendRefCon                      typeLongInteger
	        -->     kEventParamTextInputSendCurrentPoint                typeQDPoint
	        <--     kEventParamTextInputReplyRegionClass                typeLongInteger
	        <--     kEventParamTextInputReplyTextOffset                 typeLongInteger
	                    (required if the position is inside the document's body)
	        
	        Optional parameters:
	        -->     kEventParamTextInputSendDraggingMode                typeBoolean
	        <--     kEventParamTextInputReplyLeadingEdge                typeBoolean
	        <--     kEventParamTextInputReplySLRec                      typeIntlWritingCode
	        
	    kEventTextInputShowHideBottomWindow
	        Required parameters:
	        -->     kEventParamTextInputSendComponentInstance           typeComponentInstance
	        -->     kEventParamTextInputSendRefCon                      typeLongInteger
	        
	        Optional parameters:
	        -->     kEventParamTextInputSendShowHide                    typeBoolean
	        <--     kEventParamTextInputReplyShowHide                   typeBoolean
	
	    kEventTextInputGetSelectedText
	        Required parameters:
	        -->     kEventParamTextInputSendComponentInstance           typeComponentInstance
	        -->     kEventParamTextInputSendRefCon                      typeLongInteger
	        
	        Optional parameters:
	        -->     kEventParamTextInputSendLeadingEdge                 typeBoolean
	        -->     kEventParamTextInputSendTextServiceEncoding         typeUInt32
	        -->     kEventParamTextInputSendTextServiceMacEncoding      typeUInt32
	        <--     kEventParamTextInputReplyText                       typeUnicodeText, typeChar
	                    (data type depends on TSMDocument.  See kEventTextInputUpdateActiveInputArea Notes)
	        <--     kEventParamTextInputReplySLRec                      typeIntlWritingCode
		}
	{	��������������������������������������������������������������������������������������	}
	{	 Raw Keyboard Events                                                                  	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Keyboard events (kEventClassKeyboard)
	 *  
	 *  Discussion:
	 *    These events are the lowest-level keyboard events.
	 	}
	kEventRawKeyDown			= 1;							{  hardware-level events }
	kEventRawKeyRepeat			= 2;
	kEventRawKeyUp				= 3;
	kEventRawKeyModifiersChanged = 4;
	kEventHotKeyPressed			= 5;
	kEventHotKeyReleased		= 6;							{  X Only }



	{
	 *  Summary:
	 *    Key modifier change event bits and masks
	 *  
	 *  Discussion:
	 *    From bit 8, cmdKeyBit, to bit 15, rightControlKeyBit, are
	 *    compatible with Event Manager modifiers.
	 	}
	kEventKeyModifierNumLockBit	= 16;							{  Num Lock is on? (Mac OS X only) }
	kEventKeyModifierFnBit		= 17;							{  Fn key is down? (Mac OS X only) }

	kEventKeyModifierNumLockMask = $00010000;
	kEventKeyModifierFnMask		= $00020000;

	{	
	    Parameters for keyboard events:
	
	    kEventRawKeyDown
	        -->     kEventParamKeyMacCharCodes  typeChar
	        -->     kEventParamKeyCode          typeUInt32
	        -->     kEventParamKeyModifiers     typeUInt32
	
	    kEventRawKeyRepeat
	        -->     kEventParamKeyMacCharCodes  typeChar
	        -->     kEventParamKeyCode          typeUInt32
	        -->     kEventParamKeyModifiers     typeUInt32
	
	    kEventRawKeyUp
	        -->     kEventParamKeyMacCharCodes  typeChar
	        -->     kEventParamKeyCode          typeUInt32
	        -->     kEventParamKeyModifiers     typeUInt32
	
	    kEventRawKeyModifiersChanged
	        -->     kEventParamKeyModifiers     typeUInt32
	
	    kEventHotKeyPressed
	        -->     kEventParamDirectObject     typeEventHotKeyID
	
	    kEventHotKeyReleased
	        -->     kEventParamDirectObject     typeEventHotKeyID
		}

	{	��������������������������������������������������������������������������������������	}
	{	 Application Events                                                                   	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Application events (kEventClassApplication)
	 	}
	kEventAppActivated			= 1;							{  resume, in old parlance }
	kEventAppDeactivated		= 2;							{  suspend, in old parlance }
	kEventAppQuit				= 3;							{  this app is quitting }
	kEventAppLaunchNotification	= 4;							{  response to async application launch }
	kEventAppLaunched			= 5;							{  (CarbonLib 1.3 or later) some other app was launched }
	kEventAppTerminated			= 6;							{  (CarbonLib 1.3 or later) some other app was terminated }
	kEventAppFrontSwitched		= 7;							{  (CarbonLib 1.3 or later) the frontmost app has changed }

	{	��������������������������������������������������������������������������������������	}
	{	  Apple Events                                                                        	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Apple events (kEventClassAppleEvent)
	 	}
	kEventAppleEvent			= 1;


	{	
	    Parameters for Apple events:
	
	    kEventAppleEvent
	        -->     kEventParamAEEventClass     typeType        // the eventClass of the Apple event
	        -->     kEventParamAEEventID        typeType        // the eventID of the Apple event
		}
	{	��������������������������������������������������������������������������������������	}
	{	  Window Events                                                                       	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Window refresh events (kEventClassWindow)
	 *  
	 *  Discussion:
	 *    Events related to drawing a window's content.
	 	}
	kEventWindowUpdate			= 1;
	kEventWindowDrawContent		= 2;

	{	
	    Parameters for window refresh events:
	
	    kEventWindowUpdate
	        -->     kEventParamDirectObject     typeWindowRef
	
	    kEventWindowDrawContent
	        -->     kEventParamDirectObject     typeWindowRef
		}

	{
	 *  Summary:
	 *    Window activation events (kEventClassWindow)
	 *  
	 *  Discussion:
	 *    Events related to activating and deactivating a window.
	 	}
	kEventWindowActivated		= 5;
	kEventWindowDeactivated		= 6;
	kEventWindowGetClickActivation = 7;

	{	
	    Parameters for window activation events:
	
	    kEventWindowActivated
	        -->     kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowDeactivated
	        -->     kEventParamDirectObject     typeWindowRef
	
	    kEventWindowGetClickActivation
	        -->     kEventParamDirectObject     typeWindowRef
	        -->     kEventParamMouseLocation    typeQDPoint
	        -->     kEventParamKeyModifiers     typeUInt32
	        -->     kEventParamWindowDefPart    typeWindowDefPartCode
	        -->     kEventParamControlRef       typeControlRef (only present if the click was on a control)
	        <--     kEventParamClickActivation  typeClickActivationResult
		}

	{
	 *  Summary:
	 *    Window state change events (kEventClassWindow)
	 *  
	 *  Discussion:
	 *    Events that notify of a change in the window's state. These
	 *    events are sent to all windows, regardless of whether the window
	 *    has the standard handler installed.
	 	}
	kEventWindowShowing			= 22;
	kEventWindowHiding			= 23;
	kEventWindowShown			= 24;
	kEventWindowHidden			= 25;
	kEventWindowBoundsChanging	= 26;
	kEventWindowBoundsChanged	= 27;
	kEventWindowResizeStarted	= 28;
	kEventWindowResizeCompleted	= 29;
	kEventWindowDragStarted		= 30;
	kEventWindowDragCompleted	= 31;


	{
	 *  Summary:
	 *    Window bounds change event attributes
	 *  
	 *  Discussion:
	 *    When the toolbox sends out a kEventWindowBoundsChanging or
	 *    kEventWindowBoundsChanged event, it also sends along a parameter
	 *    containing attributes of the event. These attributes can be used
	 *    to determine what aspect of the window changed (origin, size, or
	 *    both), and whether or not some user action is driving the change
	 *    (drag or resize).
	 	}
	kWindowBoundsChangeUserDrag	= $01;
	kWindowBoundsChangeUserResize = $02;
	kWindowBoundsChangeSizeChanged = $04;
	kWindowBoundsChangeOriginChanged = $08;


	{	
	    Parameters for window state change events:
	    
	    kEventWindowBoundsChanging
	        -->     kEventParamDirectObject     typeWindowRef
	        -->     kEventParamAttributes       typeUInt32
	        -->     kEventParamOriginalBounds   typeQDRectangle
	        -->     kEventParamPreviousBounds   typeQDRectangle
	        <->     kEventParamCurrentBounds    typeQDRectangle
	        
	    kEventWindowBoundsChanged
	        -->     kEventParamDirectObject     typeWindowRef
	        -->     kEventParamAttributes       typeUInt32
	        -->     kEventParamOriginalBounds   typeQDRectangle
	        -->     kEventParamPreviousBounds   typeQDRectangle
	        -->     kEventParamCurrentBounds    typeQDRectangle
	    
	    kEventWindowShown
	        -->     kEventParamDirectObject     typeWindowRef
	
	    kEventWindowHidden
	        -->     kEventParamDirectObject     typeWindowRef
		}

	{
	 *  Summary:
	 *    Window click events (kEventClassWindow)
	 *  
	 *  Discussion:
	 *    Low-level events which generate higher-level �action� events.
	 *    These events are only generated for windows with the standard
	 *    window handler installed. Most clients should allow the standard
	 *    handler to implement these events.
	 	}
	kEventWindowClickDragRgn	= 32;
	kEventWindowClickResizeRgn	= 33;
	kEventWindowClickCollapseRgn = 34;
	kEventWindowClickCloseRgn	= 35;
	kEventWindowClickZoomRgn	= 36;
	kEventWindowClickContentRgn	= 37;
	kEventWindowClickProxyIconRgn = 38;


	{
	 *  Summary:
	 *    Window cursor change events (kEventClassWindow)
	 	}
	kEventWindowCursorChange	= 40;

	{	
	    Parameters for window cursor change events:
	    
	    kEventWindowCursorChange
	        -->     kEventParamDirectObject     typeWindowRef
	        -->     kEventParamMouseLocation    typeQDPoint
	        -->     kEventParamKeyModifiers     typeUInt32
		}

	{
	 *  Summary:
	 *    Window action events
	 *  
	 *  Discussion:
	 *    Events which indicate that certain changes have been made to the
	 *    window. These events have greater semantic meaning than the
	 *    low-level window click events and are usually prefered for
	 *    overriding.
	 	}
	kEventWindowCollapse		= 66;
	kEventWindowCollapsed		= 67;
	kEventWindowCollapseAll		= 68;
	kEventWindowExpand			= 69;
	kEventWindowExpanded		= 70;
	kEventWindowExpandAll		= 71;
	kEventWindowClose			= 72;
	kEventWindowClosed			= 73;
	kEventWindowCloseAll		= 74;
	kEventWindowZoom			= 75;
	kEventWindowZoomed			= 76;
	kEventWindowZoomAll			= 77;
	kEventWindowContextualMenuSelect = 78;
	kEventWindowPathSelect		= 79;
	kEventWindowGetIdealSize	= 80;
	kEventWindowGetMinimumSize	= 81;
	kEventWindowGetMaximumSize	= 82;
	kEventWindowConstrain		= 83;
	kEventWindowHandleContentClick = 85;
	kEventWindowProxyBeginDrag	= 128;
	kEventWindowProxyEndDrag	= 129;

	{	
	    Parameters for window action events:
	    
	    kEventWindowCollapse
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowCollapsed
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowCollapseAll
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowExpand
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowExpanded
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowExpandAll
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowClose
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowClosed
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowCloseAll
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowZoom
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowZoomed
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowZoomAll
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowContextualMenuSelect
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowPathSelect
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowGetIdealSize
	        --> kEventParamDirectObject     typeWindowRef
	        <-- kEventParamDimensions       typeQDPoint
	        
	    kEventWindowGetMinimumSize
	        --> kEventParamDirectObject     typeWindowRef
	        <-- kEventParamDimensions       typeQDPoint
	        
	    kEventWindowGetMaximumSize
	        --> kEventParamDirectObject     typeWindowRef
	        <-- kEventParamDimensions       typeQDPoint
	    
	    kEventWindowConstrain
	        --> kEventParamAvailableBounds  typeQDRectangle
	    
	    kEventWindowHandleContentClick
	        --> kEventParamDirectObject     typeWindowRef
	        --> kEventParamMouseLocation    typeQDPoint
	        --> kEventParamKeyModifiers     typeUInt32
	
	    kEventWindowProxyBeginDrag
	        --> kEventParamDirectObject     typeWindowRef
	        
	    kEventWindowProxyEndDrag
	        --> kEventParamDirectObject     typeWindowRef
		}

	{
	 *  Summary:
	 *    Window focus events (kEventClassWindow)
	 *  
	 *  Discussion:
	 *    Events related to focus changes between windows. These events are
	 *    generated by SetUserFocusWindow; since that API is only called by
	 *    default by the standard window handler, these events are normally
	 *    only sent to windows with the standard handler installed.
	 	}
	kEventWindowFocusAcquired	= 200;
	kEventWindowFocusRelinquish	= 201;

	{	
	    Parameters for window focus events:
	    
	    kEventWindowFocusAcquire
	        -->     kEventParamDirectObject     typeWindowRef
	
	    kEventWindowFocusRelinquish
	        -->     kEventParamDirectObject     typeWindowRef
		}

	{
	 *  Summary:
	 *    Window definition events (kEventClassWindow)
	 *  
	 *  Discussion:
	 *    Events that correspond to WDEF messages. Sent to all windows,
	 *    regardless of whether they have the standard window handler
	 *    installed.
	 	}
	kEventWindowDrawFrame		= 1000;
	kEventWindowDrawPart		= 1001;
	kEventWindowGetRegion		= 1002;
	kEventWindowHitTest			= 1003;
	kEventWindowInit			= 1004;
	kEventWindowDispose			= 1005;
	kEventWindowDragHilite		= 1006;
	kEventWindowModified		= 1007;
	kEventWindowSetupProxyDragImage = 1008;
	kEventWindowStateChanged	= 1009;
	kEventWindowMeasureTitle	= 1010;
	kEventWindowDrawGrowBox		= 1011;
	kEventWindowGetGrowImageRegion = 1012;
	kEventWindowPaint			= 1013;

	{	
	    Parameters for window definition events:
	    
	    kEventWindowDrawFrame
	        -->     kEventParamDirectObject     typeWindowRef               the window
	
	    kEventWindowDrawPart
	        -->     kEventParamDirectObject     typeWindowRef               the window
	        -->     kEventParamWindowDefPart    typeWindowDefPartCode       the part to draw
	
	    kEventWindowGetRegion
	        -->     kEventParamDirectObject     typeWindowRef               the window
	        -->     kEventParamWindowRegionCode typeWindowRegionCode        the region to get
	        -->     kEventParamRgnHandle        typeQDRgnHandle             the region to munge
	
	    kEventWindowHitTest
	        -->     kEventParamDirectObject     typeWindowRef               the window
	        -->     kEventParamMouseLocation    typeQDPoint                 the mouse location
	        <--     kEventParamWindowDefPart    typeWindowDefPartCode       the part hit
	
	    kEventWindowInit
	        -->     kEventParamDirectObject     typeWindowRef               the window
	        <--     kEventParamWindowFeatures   typeUInt32                  the window features
	
	    kEventWindowDispose
	        -->     kEventParamDirectObject     typeWindowRef               the window
	
	    kEventWindowDragHilite
	        -->     kEventParamDirectObject             typeWindowRef       the window
	        -->     kEventParamWindowDragHiliteFlag     typeBoolean         whether to draw (true) or
	                                                                        erase (false) the hilite
	
	    kEventWindowModified
	        -->     kEventParamDirectObject             typeWindowRef       the window
	        -->     kEventParamWindowModifiedFlag       typeBoolean         the new modified state
	
	    kEventWindowSetupProxyDragImage
	        -->     kEventParamDirectObject             typeWindowRef       the window
	        -->     kEventParamWindowProxyImageRgn      typeQDRgnHandle     the region you modify
	                                                                        to contain the clip
	                                                                        region for the GWorld.
	        -->     kEventParamWindowProxyOutlineRgn    typeQDRgnHandle     the region you modify
	                                                                        to contain the drag
	                                                                        outline used when the
	                                                                        GWorld cannot be used.
	        <--     kEventParamWindowProxyGWorldPtr     typeGWorldPtr       a GWorld you allocate
	                                                                        which contains the
	                                                                        drag image.
	
	    kEventWindowStateChanged
	        -->     kEventParamDirectObject             typeWindowRef       the window
	        -->     kEventParamWindowStateChangedFlags  typeUInt32          the state change flags
	
	    kEventWindowMeasureTitle
	        -->     kEventParamDirectObject             typeWindowRef       the window
	        <--     kEventParamWindowTitleFullWidth     typeSInt16          the length of the whole title area
	        <--     kEventParamWindowTitleTextWidth     typeSInt16          the length just the title text
	
	    kEventWindowDrawGrowBox
	        -->     kEventParamDirectObject     typeWindowRef               the window
	
	    kEventWindowGetGrowImageRegion
	        -->     kEventParamDirectObject     typeWindowRef               the window
	        -->     kEventParamWindowGrowRect   typeQDRectangle             the global rect
	        -->     kEventParamRgnHandle        typeQDRgnHandle             the region to modify
	
	    kEventWindowPaint
	        -->     kEventParamDirectObject     typeWindowRef               the window
		}
	{	��������������������������������������������������������������������������������������	}
	{	  Menu Events                                                                         	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Menu events (kEventClassMenu)
	 	}
	kEventMenuBeginTracking		= 1;
	kEventMenuEndTracking		= 2;
	kEventMenuChangeTrackingMode = 3;
	kEventMenuOpening			= 4;
	kEventMenuClosed			= 5;
	kEventMenuTargetItem		= 6;
	kEventMenuMatchKey			= 7;
	kEventMenuEnableItems		= 8;
	kEventMenuDispose			= 1001;

	{	
	    Parameters for menu events:
	    
	    kEventMenuBeginTracking
	        -->     kEventParamDirectObject             typeMenuRef
	        -->     kEventParamCurrentMenuTrackingMode  typeMenuTrackingMode
	        
	    kEventMenuEndTracking
	        -->     kEventParamDirectObject             typeMenuRef
	        
	    kEventMenuOpening
	        -->     kEventParamDirectObject             typeMenuRef
	        -->     kEventParamMenuFirstOpen            typeBoolean
	        
	    kEventMenuClosed
	        -->     kEventParamDirectObject             typeMenuRef
	        
	    kEventMenuTargetItem
	        -->     kEventParamDirectObject             typeMenuRef
	        -->     kEventParamMenuItemIndex            typeMenuItemIndex
	        -->     kEventParamMenuCommand              typeMenuCommand
	    
	    kEventMenuMatchKey
	        -->     kEventParamDirectObject             typeMenuRef
	        -->     kEventParamEventRef                 typeEventRef
	        -->     kEventParamMenuEventOptions         typeMenuEventOptions
	        <--     kEventParamMenuItemIndex            typeMenuItemIndex
	        
	    kEventMenuEnableItems
	        -->     kEventParamDirectObject             typeMenuRef
	        -->     kEventParamEnableMenuForKeyEvent    typeBoolean
	        
	    kEventMenuDispose
	        -->     kEventParamDirectObject             typeMenuRef
		}
	{	��������������������������������������������������������������������������������������	}
	{	  Command Events                                                                      	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Command events (kEventClassCommand)
	 	}
	kEventProcessCommand		= 1;
	kEventCommandProcess		= 1;
	kEventCommandUpdateStatus	= 2;

	{	
	    Parameters for command events:
	
	    kEventCommandProcess
	        -->     kEventParamDirectObject     typeHICommand
	        -->     kEventParamKeyModifiers     typeUInt32 (optional)
	
	    kEventCommandUpdateStatus
	        -->     kEventParamDirectObject     typeHICommand
		}
	{	 HI Commands 	}
	kHICommandOK				= 'ok  ';
	kHICommandCancel			= 'not!';
	kHICommandQuit				= 'quit';
	kHICommandUndo				= 'undo';
	kHICommandRedo				= 'redo';
	kHICommandCut				= 'cut ';
	kHICommandCopy				= 'copy';
	kHICommandPaste				= 'past';
	kHICommandClear				= 'clea';
	kHICommandSelectAll			= 'sall';
	kHICommandHide				= 'hide';
	kHICommandPreferences		= 'pref';
	kHICommandZoomWindow		= 'zoom';
	kHICommandMinimizeWindow	= 'mini';
	kHICommandArrangeInFront	= 'frnt';
	kHICommandAbout				= 'abou';

	kHICommandFromMenu			= $00000001;


TYPE
	HICommandPtr = ^HICommand;
	HICommand = RECORD
		attributes:				UInt32;
		commandID:				UInt32;
		menuRef:				MenuRef;
		menuItemIndex:			MenuItemIndex;
	END;

	{	��������������������������������������������������������������������������������������	}
	{	  Control Events                                                                      	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Control events (kEventClassControl)
	 	}

CONST
	kEventControlInitialize		= 1000;
	kEventControlDispose		= 1001;
	kEventControlGetOptimalBounds = 1003;
	kEventControlDefInitialize	= 1000;
	kEventControlDefDispose		= 1001;
	kEventControlHit			= 1;
	kEventControlSimulateHit	= 2;
	kEventControlHitTest		= 3;
	kEventControlDraw			= 4;
	kEventControlApplyBackground = 5;
	kEventControlApplyTextColor	= 6;
	kEventControlSetFocusPart	= 7;
	kEventControlGetFocusPart	= 8;
	kEventControlActivate		= 9;
	kEventControlDeactivate		= 10;
	kEventControlSetCursor		= 11;
	kEventControlContextualMenuClick = 12;
	kEventControlClick			= 13;
	kEventControlTrack			= 51;
	kEventControlGetScrollToHereStartPoint = 52;
	kEventControlGetIndicatorDragConstraint = 53;
	kEventControlIndicatorMoved	= 54;
	kEventControlGhostingFinished = 55;
	kEventControlGetActionProcPart = 56;
	kEventControlGetPartRegion	= 101;
	kEventControlGetPartBounds	= 102;
	kEventControlSetData		= 103;
	kEventControlGetData		= 104;
	kEventControlValueFieldChanged = 151;
	kEventControlAddedSubControl = 152;
	kEventControlRemovingSubControl = 153;
	kEventControlBoundsChanged	= 154;
	kEventControlOwningWindowChanged = 159;
	kEventControlArbitraryMessage = 201;


	{
	 *  Summary:
	 *    Control bounds change event attributes
	 *  
	 *  Discussion:
	 *    When the toolbox sends out a kEventControlBoundsChanged event, it
	 *    also sends along a parameter containing attributes of the event.
	 *    These attributes can be used to determine what aspect of the
	 *    control changed (position, size, or both).
	 	}
	kControlBoundsChangeSizeChanged = $04;
	kControlBoundsChangePositionChanged = $08;

	{	
	    Parameters for control events:
	
	    kEventControlInitialize
	        -->     kEventParamDirectObject     typeControlRef
	        -->     kEventParamInitCollection   typeCollection
	        <--     kEventParamControlFeatures  typeUInt32
	        
	    kEventControlDispose
	        -->     kEventParamDirectObject     typeControlRef
	
	    kEventControlGetOptimalBounds
	        Required parameters:
	        -->     kEventParamDirectObject                     typeControlRef
	        <--     kEventParamControlOptimalBounds             typeQDRectangle
	        
	        Optional parameters:
	        <--     kEventParamControlOptimalBaselineOffset     typeShortInteger (optional)
	        
	    kEventControlHit
	        -->     kEventParamDirectObject     typeControlRef
	        -->     kEventParamControlPart      typeControlPartCode
	        -->     kEventParamKeyModifiers     typeUInt32
	
	    kEventControlSimulateHit
	        -->     kEventParamDirectObject     typeControlRef
	        
	    kEventControlHitTest
	        -->     kEventParamDirectObject     typeControlRef
	        -->     kEventParamMouseLocation    typeQDPoint
	        <--     kEventParamControlPart      typeControlPartCode
	        
	    kEventControlDraw
	        Required parameters:
	        -->     kEventParamDirectObject     typeControlRef
	        
	        Optional parameters:
	        -->     kEventParamControlPart      typeControlPartCode
	                    (draw the entire control if kEventParamControlPart is not present)
	        -->     kEventParamGrafPort         typeGrafPtr
	                    (draw into the current port if kEventParamGrafPort is not present)
	
	    kEventControlApplyBackground
	        Required parameters:
	        -->     kEventParamDirectObject         typeControlRef
	        -->     kEventParamControlSubControl    typeControlRef
	        -->     kEventParamControlDrawDepth     typeShortInteger
	        -->     kEventParamControlDrawInColor   typeBoolean
	        
	        Optional parameters:
	        -->     kEventParamGrafPort             typeGrafPtr
	                    (apply to the current port if kEventParamGrafPort is not present)
	
	    kEventControlApplyTextColor
	        Required parameters:
	        -->     kEventParamDirectObject         typeControlRef
	        -->     kEventParamControlSubControl    typeControlRef
	        -->     kEventParamControlDrawDepth     typeShortInteger
	        -->     kEventParamControlDrawInColor   typeBoolean
	        
	        Optional parameters:
	        -->     kEventParamCGContextRef         typeCGContextRef
	        -->     kEventParamGrafPort             typeGrafPtr
	                    (apply to the current port if kEventParamGrafPort is not present)
	
	    kEventControlSetFocusPart
	        -->     kEventParamDirectObject     typeControlRef
	        <->     kEventParamControlPart      typeControlPartCode
	
	    kEventControlGetFocusPart
	        -->     kEventParamDirectObject     typeControlRef
	        <--     kEventParamControlPart      typeControlPartCode
	
	    kEventControlActivate
	        -->     kEventParamDirectObject     typeControlRef
	
	    kEventControlDeactivate
	        -->     kEventParamDirectObject     typeControlRef
	
	    kEventControlSetCursor
	        -->     kEventParamDirectObject     typeControlRef
	        -->     kEventParamMouseLocation    typeQDPoint
	        -->     kEventParamKeyModifiers     typeUInt32
	
	    kEventControlContextualMenuClick
	        -->     kEventParamDirectObject     typeControlRef
	        -->     kEventParamMouseLocation    typeQDPoint
	
	    kEventControlTrack
	        -->     kEventParamDirectObject     typeControlRef
	        -->     kEventParamMouseLocation    typeQDPoint
	        <->     kEventParamKeyModifiers     typeUInt32
	        -->     kEventParamControlAction    typeControlActionUPP
	        <--     kEventParamControlPart      typeControlPartCode
	
	    kEventControlGetScrollToHereStartPoint
	        -->     kEventParamDirectObject     typeControlRef
	        <->     kEventParamMouseLocation    typeQDPoint
	        -->     kEventParamKeyModifiers     typeUInt32
	
	    kEventControlGetIndicatorDragConstraint
	        -->     kEventParamDirectObject                     typeControlRef
	        -->     kEventParamMouseLocation                    typeQDPoint
	        -->     kEventParamKeyModifiers                     typeUInt32
	        <--     kEventParamControlIndicatorDragConstraint   typeIndicatorDragConstraint
	
	    kEventControlIndicatorMoved
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamControlIndicatorRegion   typeQDRgnHandle
	        -->     kEventParamControlIsGhosting        typeBoolean
	
	    kEventControlGhostingFinished
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamControlIndicatorOffset   typeQDPoint
	
	    kEventControlGetActionProcPart
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamKeyModifiers             typeUInt32
	        <->     kEventParamControlPart              typeControlPartCode
	
	    kEventControlGetPartRegion
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamControlPart              typeControlPartCode
	        -->     kEventParamControlRegion            typeQDRgnHandle
	
	    kEventControlGetPartBounds
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamControlPart              typeControlPartCode
	        <--     kEventParamControlPartBounds        typeQDRectangle
	
	    kEventControlSetData
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamControlPart              typeControlPartCode
	        -->     kEventParamControlDataTag           typeEnumeration
	        -->     kEventParamControlDataBuffer        typePtr
	        -->     kEventParamControlDataBufferSize    typeLongInteger
	
	    kEventControlGetData
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamControlPart              typeControlPartCode
	        -->     kEventParamControlDataTag           typeEnumeration
	        -->     kEventParamControlDataBuffer        typePtr
	        <->     kEventParamControlDataBufferSize    typeLongInteger
	
	    kEventControlValueFieldChanged
	        -->     kEventParamDirectObject             typeControlRef
	
	    kEventControlAddedSubControl
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamControlSubControl        typeControlRef
	
	    kEventControlRemovingSubControl
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamControlSubControl        typeControlRef
	
	    kEventControlBoundsChanged
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamAttributes               typeUInt32
	        -->     kEventParamOriginalBounds           typeQDRectangle
	        -->     kEventParamPreviousBounds           typeQDRectangle
	        -->     kEventParamCurrentBounds            typeQDRectangle
	
	    kEventControlOwningWindowChanged
	        -->     kEventParamDirectObject                 typeControlRef
	        -->     kEventParamAttributes                   typeUInt32
	        -->     kEventParamControlOriginalOwningWindow  typeWindowRef
	        -->     kEventParamControlCurrentOwningWindow   typeWindowRef
	
	    kEventControlArbitraryMessage
	        -->     kEventParamDirectObject             typeControlRef
	        -->     kEventParamControlMessage           typeShortInteger
	        -->     kEventParamControlParam             typeLongInteger
	        <--     kEventParamControlResult            typeLongInteger
		}
	{	��������������������������������������������������������������������������������������	}
	{	  Tablet Events                                                                       	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Tablet events (kEventClassTablet)
	 	}
	kEventTabletPointer			= 1;
	kEventTabletProximity		= 2;


TYPE
	TabletPointerRecPtr = ^TabletPointerRec;
	TabletPointerRec = RECORD
		absX:					SInt32;									{  absolute x coordinate in tablet space at full tablet resolution  }
		absY:					SInt32;									{  absolute y coordinate in tablet space at full tablet resolution  }
		absZ:					SInt32;									{  absolute z coordinate in tablet space at full tablet resolution  }
		buttons:				UInt16;									{  one bit per button - bit 0 is first button - 1 = closed  }
		pressure:				UInt16;									{  scaled pressure value; MAXPRESSURE=(2^16)-1, MINPRESSURE=0  }
		tiltX:					SInt16;									{  scaled tilt x value; range is -((2^15)-1) to (2^15)-1 (-32767 to 32767)  }
		tiltY:					SInt16;									{  scaled tilt y value; range is -((2^15)-1) to (2^15)-1 (-32767 to 32767)  }
		rotation:				UInt16;									{  Fixed-point representation of device rotation in a 10.6 format  }
		tangentialPressure:		SInt16;									{  tangential pressure on the device; range same as tilt  }
		deviceID:				UInt16;									{  system-assigned unique device ID - matches to deviceID field in proximity event  }
		vendor1:				SInt16;									{  vendor-defined signed 16-bit integer  }
		vendor2:				SInt16;									{  vendor-defined signed 16-bit integer  }
		vendor3:				SInt16;									{  vendor-defined signed 16-bit integer  }
	END;

	TabletProximityRecPtr = ^TabletProximityRec;
	TabletProximityRec = RECORD
		vendorID:				UInt16;									{  vendor-defined ID - typically will be USB vendor ID  }
		tabletID:				UInt16;									{  vendor-defined tablet ID - typically will be USB product ID for the tablet  }
		pointerID:				UInt16;									{  vendor-defined ID of the specific pointing device  }
		deviceID:				UInt16;									{  system-assigned unique device ID - matches to deviceID field in tablet event  }
		systemTabletID:			UInt16;									{  system-assigned unique tablet ID  }
		vendorPointerType:		UInt16;									{  vendor-defined pointer type  }
		pointerSerialNumber:	UInt32;									{  vendor-defined serial number of the specific pointing device  }
		uniqueID:				UInt64;									{  vendor-defined unique ID for this pointer  }
		capabilityMask:			UInt32;									{  mask representing the capabilities of the device  }
		pointerType:			SInt8;									{  type of pointing device - enum to be defined  }
		enterProximity:			SInt8;									{  non-zero = entering; zero = leaving  }
	END;

	{	��������������������������������������������������������������������������������������	}
	{	 Volume Events                                                                        	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  Summary:
	 *    Volume events (kEventClassVolume)
	 	}

CONST
	kEventVolumeMounted			= 1;							{  new volume mounted }
	kEventVolumeUnmounted		= 2;							{  volume has been ejected or unmounted }

	{	
	    Parameters for volume events:
	
	    kEventVolumeMounted
	        -->     kEventParamDirectObject     typeFSVolumeRefNum
	    
	    kEventVolumeUnmounted
	        -->     kEventParamDirectObject     typeFSVolumeRefNum
		}

	{  types for volume events }

	typeFSVolumeRefNum			= 'voln';						{  FSVolumeRefNum }

	{	��������������������������������������������������������������������������������������	}
	{	 Parameter names and types                                                            	}
	{	��������������������������������������������������������������������������������������	}
	kEventParamDirectObject		= '----';						{  type varies depending on event }

	{  Generic toolbox types and parameter names }

	kEventParamWindowRef		= 'wind';						{  typeWindowRef }
	kEventParamGrafPort			= 'graf';						{  typeGrafPtr }
	kEventParamDragRef			= 'drag';						{  typeDragRef }
	kEventParamMenuRef			= 'menu';						{  typeMenuRef }
	kEventParamEventRef			= 'evnt';						{  typeEventRef }
	kEventParamControlRef		= 'ctrl';						{  typeControlRef }
	kEventParamRgnHandle		= 'rgnh';						{  typeQDRgnHandle }
	kEventParamEnabled			= 'enab';						{  typeBoolean }
	kEventParamDimensions		= 'dims';						{  typeQDPoint }
	kEventParamAvailableBounds	= 'avlb';						{  typeQDRectangle }
	kEventParamAEEventID		= 'evti';						{  typeType }
	kEventParamAEEventClass		= 'evcl';						{  typeType }
	kEventParamCGContextRef		= 'cntx';						{  typeCGContextRef }
	typeWindowRef				= 'wind';						{  WindowRef }
	typeGrafPtr					= 'graf';						{  CGrafPtr }
	typeGWorldPtr				= 'gwld';						{  GWorldPtr }
	typeDragRef					= 'drag';						{  DragRef }
	typeMenuRef					= 'menu';						{  MenuRef }
	typeControlRef				= 'ctrl';						{  ControlRef }
	typeCollection				= 'cltn';						{  Collection }
	typeQDRgnHandle				= 'rgnh';						{  RgnHandle }
	typeOSStatus				= 'osst';						{  OSStatus }
	typeCGContextRef			= 'cntx';						{  CGContextRef }

	{  mouse-event-related event parameters }

	kEventParamMouseLocation	= 'mloc';						{  typeQDPoint }
	kEventParamMouseButton		= 'mbtn';						{  typeMouseButton }
	kEventParamClickCount		= 'ccnt';						{  typeUInt32 }
	kEventParamMouseWheelAxis	= 'mwax';						{  typeMouseWheelAxis }
	kEventParamMouseWheelDelta	= 'mwdl';						{  typeSInt32 }
	kEventParamMouseDelta		= 'mdta';						{  typeQDPoint }
	kEventParamMouseChord		= 'chor';						{  typeUInt32 }
	typeMouseButton				= 'mbtn';						{  EventMouseButton }
	typeMouseWheelAxis			= 'mwax';						{  EventMouseWheelAxis }

	{  keyboard parameter types }

	kEventParamKeyCode			= 'kcod';						{  typeUInt32 }
	kEventParamKeyMacCharCodes	= 'kchr';						{  typeChar }
	kEventParamKeyModifiers		= 'kmod';						{  typeUInt32 }
	kEventParamKeyUnicodes		= 'kuni';						{  typeUnicodeText }
	typeEventHotKeyID			= 'hkid';						{  EventHotKeyID }

	{  TextInput parameter types }

	kEventParamTextInputSendRefCon = 'tsrc';					{     typeLongInteger }
	kEventParamTextInputSendComponentInstance = 'tsci';			{     typeComponentInstance }
	kEventParamTextInputSendSLRec = 'tssl';						{     typeIntlWritingCode }
	kEventParamTextInputReplySLRec = 'trsl';					{     typeIntlWritingCode }
	kEventParamTextInputSendText = 'tstx';						{     typeUnicodeText (if TSMDocument is Unicode), otherwise typeChar }
	kEventParamTextInputReplyText = 'trtx';						{     typeUnicodeText (if TSMDocument is Unicode), otherwise typeChar }
	kEventParamTextInputSendUpdateRng = 'tsup';					{     typeTextRangeArray }
	kEventParamTextInputSendHiliteRng = 'tshi';					{     typeTextRangeArray }
	kEventParamTextInputSendClauseRng = 'tscl';					{     typeOffsetArray }
	kEventParamTextInputSendPinRng = 'tspn';					{     typeTextRange }
	kEventParamTextInputSendFixLen = 'tsfx';					{     typeLongInteger }
	kEventParamTextInputSendLeadingEdge = 'tsle';				{     typeBoolean }
	kEventParamTextInputReplyLeadingEdge = 'trle';				{     typeBoolean }
	kEventParamTextInputSendTextOffset = 'tsto';				{     typeLongInteger }
	kEventParamTextInputReplyTextOffset = 'trto';				{     typeLongInteger }
	kEventParamTextInputReplyRegionClass = 'trrg';				{     typeLongInteger }
	kEventParamTextInputSendCurrentPoint = 'tscp';				{     typeQDPoint }
	kEventParamTextInputSendDraggingMode = 'tsdm';				{     typeBoolean }
	kEventParamTextInputReplyPoint = 'trpt';					{     typeQDPoint }
	kEventParamTextInputReplyFont = 'trft';						{     typeLongInteger }
	kEventParamTextInputReplyPointSize = 'trpz';				{     typeFixed }
	kEventParamTextInputReplyLineHeight = 'trlh';				{     typeShortInteger }
	kEventParamTextInputReplyLineAscent = 'trla';				{     typeShortInteger }
	kEventParamTextInputReplyTextAngle = 'trta';				{     typeFixed }
	kEventParamTextInputSendShowHide = 'tssh';					{     typeBoolean }
	kEventParamTextInputReplyShowHide = 'trsh';					{     typeBoolean }
	kEventParamTextInputSendKeyboardEvent = 'tske';				{     typeEventRef }
	kEventParamTextInputSendTextServiceEncoding = 'tsse';		{     typeUInt32 }
	kEventParamTextInputSendTextServiceMacEncoding = 'tssm';	{     typeUInt32 }



	{  HICommand stuff }

	kEventParamHICommand		= 'hcmd';						{  typeHICommand }
	typeHICommand				= 'hcmd';						{  HICommand }

	{  Window-related stuff }
	kEventParamWindowFeatures	= 'wftr';						{  typeUInt32 }
	kEventParamWindowDefPart	= 'wdpc';						{  typeWindowDefPartCode }
	kEventParamCurrentBounds	= 'crct';						{  typeQDRectangle }
	kEventParamOriginalBounds	= 'orct';						{  typeQDRectangle }
	kEventParamPreviousBounds	= 'prct';						{  typeQDRectangle }
	kEventParamClickActivation	= 'clac';						{  typeClickActivationResult }
	kEventParamWindowRegionCode	= 'wshp';						{  typeWindowRegionCode }
	kEventParamWindowDragHiliteFlag = 'wdhf';					{  typeBoolean }
	kEventParamWindowModifiedFlag = 'wmff';						{  typeBoolean }
	kEventParamWindowProxyGWorldPtr = 'wpgw';					{  typeGWorldPtr }
	kEventParamWindowProxyImageRgn = 'wpir';					{  typeQDRgnHandle }
	kEventParamWindowProxyOutlineRgn = 'wpor';					{  typeQDRgnHandle }
	kEventParamWindowStateChangedFlags = 'wscf';				{  typeUInt32  }
	kEventParamWindowTitleFullWidth = 'wtfw';					{  typeSInt16 }
	kEventParamWindowTitleTextWidth = 'wttw';					{  typeSInt16 }
	kEventParamWindowGrowRect	= 'grct';						{  typeQDRectangle }
	kEventParamAttributes		= 'attr';						{  typeUInt32 }
	typeWindowRegionCode		= 'wshp';						{  WindowRegionCode }
	typeWindowDefPartCode		= 'wdpt';						{  WindowDefPartCode }
	typeClickActivationResult	= 'clac';						{  ClickActivationResult }


	{  control stuff }

	kEventParamControlPart		= 'cprt';						{  typeControlPartCode }
	kEventParamInitCollection	= 'icol';						{  typeCollection }
	kEventParamControlMessage	= 'cmsg';						{  typeShortInteger }
	kEventParamControlParam		= 'cprm';						{  typeLongInteger }
	kEventParamControlResult	= 'crsl';						{  typeLongInteger }
	kEventParamControlRegion	= 'crgn';						{  typeQDRgnHandle }
	kEventParamControlAction	= 'caup';						{  typeControlActionUPP }
	kEventParamControlIndicatorDragConstraint = 'cidc';			{  typeIndicatorDragConstraint }
	kEventParamControlIndicatorRegion = 'cirn';					{  typeQDRgnHandle }
	kEventParamControlIsGhosting = 'cgst';						{  typeBoolean }
	kEventParamControlIndicatorOffset = 'ciof';					{  typeQDPoint }
	kEventParamControlClickActivationResult = 'ccar';			{  typeClickActivationResult }
	kEventParamControlSubControl = 'csub';						{  typeControlRef }
	kEventParamControlOptimalBounds = 'cobn';					{  typeQDRectangle }
	kEventParamControlOptimalBaselineOffset = 'cobo';			{  typeShortInteger }
	kEventParamControlDataTag	= 'cdtg';						{  typeEnumeration }
	kEventParamControlDataBuffer = 'cdbf';						{  typePtr }
	kEventParamControlDataBufferSize = 'cdbs';					{  typeLongInteger }
	kEventParamControlDrawDepth	= 'cddp';						{  typeShortInteger }
	kEventParamControlDrawInColor = 'cdic';						{  typeBoolean }
	kEventParamControlFeatures	= 'cftr';						{  typeUInt32 }
	kEventParamControlPartBounds = 'cpbd';						{  typeQDRectangle }
	kEventParamControlOriginalOwningWindow = 'coow';			{  typeWindowRef }
	kEventParamControlCurrentOwningWindow = 'ccow';				{  typeWindowRef }
	typeControlActionUPP		= 'caup';						{  ControlActionUPP }
	typeIndicatorDragConstraint	= 'cidc';						{  IndicatorDragConstraint }
	typeControlPartCode			= 'cprt';						{  ControlPartCode }

	{  menu-related event parameters }

	kEventParamCurrentMenuTrackingMode = 'cmtm';				{  typeMenuTrackingMode }
	kEventParamNewMenuTrackingMode = 'nmtm';					{  typeMenuTrackingMode }
	kEventParamMenuFirstOpen	= '1sto';						{  typeBoolean }
	kEventParamMenuItemIndex	= 'item';						{  typeMenuItemIndex }
	kEventParamMenuCommand		= 'mcmd';						{  typeMenuCommand }
	kEventParamEnableMenuForKeyEvent = 'fork';					{  typeBoolean }
	kEventParamMenuEventOptions	= 'meop';						{  typeMenuEventOptions }
	typeMenuItemIndex			= 'midx';						{  MenuItemIndex }
	typeMenuCommand				= 'mcmd';						{  MenuCommand }
	typeMenuTrackingMode		= 'mtmd';						{  MenuTrackingMode }
	typeMenuEventOptions		= 'meop';						{  MenuEventOptions }

	{  application-event parameters }

	kEventParamProcessID		= 'psn ';						{  typeProcessSerialNumber }
	kEventParamLaunchRefCon		= 'lref';						{  typeWildcard }
	kEventParamLaunchErr		= 'err ';						{  typeOSStatus }

	{  tablet event parameters }

	kEventParamTabletPointerRec	= 'tbrc';						{  typeTabletPointerRec }
	kEventParamTabletProximityRec = 'tbpx';						{  typeTabletProximityRec }
	typeTabletPointerRec		= 'tbrc';						{  kEventParamTabletPointerRec }
	typeTabletProximityRec		= 'tbpx';						{  kEventParamTabletProximityRec }


	{	======================================================================================	}
	{	  EVENT HANDLERS                                                                      	}
	{	======================================================================================	}


TYPE
	EventHandlerRef    = ^LONGINT; { an opaque 32-bit type }
	EventHandlerRefPtr = ^EventHandlerRef;  { when a VAR xx:EventHandlerRef parameter can be nil, it is changed to xx: EventHandlerRefPtr }
	EventHandlerCallRef    = ^LONGINT; { an opaque 32-bit type }
	EventHandlerCallRefPtr = ^EventHandlerCallRef;  { when a VAR xx:EventHandlerCallRef parameter can be nil, it is changed to xx: EventHandlerCallRefPtr }

	{	��������������������������������������������������������������������������������������	}
	{	  � EventHandler specification                                                        	}
	{	��������������������������������������������������������������������������������������	}

	{
	 *  EventHandlerProcPtr
	 *  
	 *  Discussion:
	 *    Callback for receiving events sent to a target this callback is
	 *    installed on.
	 *  
	 *  Parameters:
	 *    
	 *    inHandlerCallRef:
	 *      A reference to the current handler call chain. This is sent to
	 *      your handler so that you can call CallNextEventHandler if you
	 *      need to.
	 *    
	 *    inEvent:
	 *      The Event.
	 *    
	 *    inUserData:
	 *      The app-specified data you passed in a call to
	 *      InstallEventHandler.
	 *  
	 *  Result:
	 *    An operating system result code. Returning noErr indicates you
	 *    handled the event. Returning eventNotHandledErr indicates you did
	 *    not handle the event and perhaps the toolbox should take other
	 *    action.
	 	}
{$IFC TYPED_FUNCTION_POINTERS}
	EventHandlerProcPtr = FUNCTION(inHandlerCallRef: EventHandlerCallRef; inEvent: EventRef; inUserData: UNIV Ptr): OSStatus;
{$ELSEC}
	EventHandlerProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	EventHandlerUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	EventHandlerUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppEventHandlerProcInfo = $00000FF0;
	{
	 *  NewEventHandlerUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION NewEventHandlerUPP(userRoutine: EventHandlerProcPtr): EventHandlerUPP; { old name was NewEventHandlerProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposeEventHandlerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE DisposeEventHandlerUPP(userUPP: EventHandlerUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokeEventHandlerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InvokeEventHandlerUPP(inHandlerCallRef: EventHandlerCallRef; inEvent: EventRef; inUserData: UNIV Ptr; userRoutine: EventHandlerUPP): OSStatus; { old name was CallEventHandlerProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{��������������������������������������������������������������������������������������}
{  � Installing Event Handlers                                                         }
{                                                                                      }
{ Use these routines to install event handlers for a specific toolbox object. You may  }
{ pass zero for inNumTypes and NULL for inList if you need to be in a situation where  }
{ you know you will be receiving events, but not exactly which ones at the time you    }
{ are installing the handler. Later, your application can call the Add/Remove routines }
{ listed below this section.                                                           }
{                                                                                      }
{ You can only install a specific handler once. The combination of inHandler and       }
{ inUserData is considered the 'signature' of a handler. Any attempt to install a new  }
{ handler with the same proc and user data as an already-installed handler will result }
{ in eventHandlerAlreadyInstalledErr. Installing the same proc and user data on a      }
{ different object is legal.                                                           }
{                                                                                      }
{ Upon successful completion of this routine, you are returned an EventHandlerRef,     }
{ which you can use in various other calls, and is passed to your event handler. You   }
{ use it to extract information about the handler, such as the target (window, etc.)   }
{ if you have the same handler installed for different objects and need to perform     }
{ actions on the current target (say, call a window manager function).                 }
{��������������������������������������������������������������������������������������}

TYPE
	EventTargetRef    = ^LONGINT; { an opaque 32-bit type }
	EventTargetRefPtr = ^EventTargetRef;  { when a VAR xx:EventTargetRef parameter can be nil, it is changed to xx: EventTargetRefPtr }
	{
	 *  GetWindowEventTarget()
	 *  
	 *  Discussion:
	 *    Returns the EventTargetRef for the specified window. Once you
	 *    obtain this reference, you can send events to the target and
	 *    install an event handler on it.
	 *  
	 *  Parameters:
	 *    
	 *    inWindow:
	 *      The window to return the target for.
	 *  
	 *  Result:
	 *    An EventTargetRef.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION GetWindowEventTarget(inWindow: WindowRef): EventTargetRef;

{
 *  GetControlEventTarget()
 *  
 *  Discussion:
 *    Returns the EventTargetRef for the specified control. Once you
 *    obtain this reference, you can send events to the target and
 *    install event handler on it.
 *  
 *  Parameters:
 *    
 *    inControl:
 *      The control to return the target for.
 *  
 *  Result:
 *    An EventTargetRef.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetControlEventTarget(inControl: ControlRef): EventTargetRef;

{
 *  GetMenuEventTarget()
 *  
 *  Discussion:
 *    Returns the EventTargetRef for the specified menu. Once you
 *    obtain this reference, you can send events to the target and
 *    install event handler on it.
 *  
 *  Parameters:
 *    
 *    inMenu:
 *      The menu to return the target for.
 *  
 *  Result:
 *    An EventTargetRef.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetMenuEventTarget(inMenu: MenuRef): EventTargetRef;

{
 *  GetApplicationEventTarget()
 *  
 *  Discussion:
 *    Returns the EventTargetRef for the application. Once you obtain
 *    this reference, you can send events to the target and install
 *    event handler on it.
 *  
 *  Result:
 *    An EventTargetRef.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetApplicationEventTarget: EventTargetRef;

{
 *  GetUserFocusEventTarget()
 *  
 *  Discussion:
 *    Returns the EventTargetRef for the current user focus at the time
 *    of the call. Keyboard events are always sent to this target.
 *  
 *  Result:
 *    An EventTargetRef.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetUserFocusEventTarget: EventTargetRef;

{
 *  GetEventDispatcherTarget()
 *  
 *  Discussion:
 *    Returns the EventTargetRef for the standard toolbox dispatcher.
 *    You typically would never need to use this, but there are some
 *    exotic apps that need to pick events off the event queue and call
 *    the dispatcher themselves. This allows you to do just that
 *    instead of calling RunApplicationEventLoop to handle it all.
 *  
 *  Result:
 *    An EventTargetRef.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetEventDispatcherTarget: EventTargetRef; C;

{
 *  InstallEventHandler()
 *  
 *  Discussion:
 *    Installs an event handler on a specified target. Your handler
 *    proc will be called with the events you registered with when an
 *    event of the corresponding type and class are send to the target
 *    you are installing your handler on.
 *  
 *  Parameters:
 *    
 *    inTarget:
 *      The target to register your handler with.
 *    
 *    inHandler:
 *      A pointer to your handler function.
 *    
 *    inNumTypes:
 *      The number of events you are registering for.
 *    
 *    inList:
 *      A pointer to an array of EventTypeSpec entries representing the
 *      events you are interested in.
 *    
 *    inUserData:
 *      The value passed in this parameter is passed on to your event
 *      handler proc when it is called.
 *    
 *    outRef:
 *      Receives an EventHandlerRef, which you can use later to remove
 *      the handler. You can pass null if you don't want the reference
 *      - when the target is disposed, the handler will be disposed as
 *      well.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InstallEventHandler(inTarget: EventTargetRef; inHandler: EventHandlerUPP; inNumTypes: UInt32; {CONST}VAR inList: EventTypeSpec; inUserData: UNIV Ptr; outRef: EventHandlerRefPtr): OSStatus;

{
 *  InstallStandardEventHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION InstallStandardEventHandler(inTarget: EventTargetRef): OSStatus;

{
 *  RemoveEventHandler()
 *  
 *  Discussion:
 *    Removes an event handler from the target it was bound to.
 *  
 *  Parameters:
 *    
 *    inHandlerRef:
 *      The handler ref to remove (returned in a call to
 *      InstallEventHandler). After you call this function, the handler
 *      ref is considered to be invalid and can no longer be used.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION RemoveEventHandler(inHandlerRef: EventHandlerRef): OSStatus;

{��������������������������������������������������������������������������������������}
{  � Adjusting set of event types after a handler is created                           }
{                                                                                      }
{ After installing a handler with the routine above, you can adjust the event type     }
{ list telling the toolbox what events to send to that handler by calling the two      }
{ routines below. If you add an event type twice for the same handler, your handler    }
{ will only be called once, but it will take two RemoveEventType calls to stop your    }
{ handler from being called with that event type. In other words, the install count    }
{ for each event type is maintained by the toolbox. This might allow you, for example  }
{ to have subclasses of a window object register for types without caring if the base  }
{ class has already registered for that type. When the subclass removes its types, it  }
{ can successfully do so without affecting the base class's reception of its event     }
{ types, yielding eternal bliss.                                                       }
{��������������������������������������������������������������������������������������}

{
 *  AddEventTypesToHandler()
 *  
 *  Discussion:
 *    Adds additional events to an event handler that has already been
 *    installed.
 *  
 *  Parameters:
 *    
 *    inHandlerRef:
 *      The event handler to add the additional events to.
 *    
 *    inNumTypes:
 *      The number of events to add.
 *    
 *    inList:
 *      A pointer to an array of EventTypeSpec entries.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION AddEventTypesToHandler(inHandlerRef: EventHandlerRef; inNumTypes: UInt32; {CONST}VAR inList: EventTypeSpec): OSStatus;

{
 *  RemoveEventTypesFromHandler()
 *  
 *  Discussion:
 *    Removes events from an event handler that has already been
 *    installed.
 *  
 *  Parameters:
 *    
 *    inHandlerRef:
 *      The event handler to remove the events from.
 *    
 *    inNumTypes:
 *      The number of events to remove.
 *    
 *    inList:
 *      A pointer to an array of EventTypeSpec entries.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION RemoveEventTypesFromHandler(inHandlerRef: EventHandlerRef; inNumTypes: UInt32; {CONST}VAR inList: EventTypeSpec): OSStatus;

{��������������������������������������������������������������������������������������}
{  � Explicit Propogation                                                              }
{                                                                                      }
{  CallNextEventHandler can be used to call thru to all handlers below the current     }
{  handler being called. You pass the EventHandlerCallRef passed to your EventHandler  }
{  into this call so that we know how to properly forward the event. The result of     }
{  this function should normally be the result of your own handler that you called     }
{  this API from. The typical use of this routine would be to allow the toolbox to do  }
{  its standard processing and then follow up with some type of embellishment.         }
{��������������������������������������������������������������������������������������}

{
 *  CallNextEventHandler()
 *  
 *  Discussion:
 *    Calls thru to the event handlers below you in the event handler
 *    stack of the target to which your handler is bound. You might use
 *    this to call thru to the default toolbox handling in order to
 *    post-process the event. You can only call this routine from
 *    within an event handler.
 *  
 *  Parameters:
 *    
 *    inCallRef:
 *      The event handler call ref passed into your event handler.
 *    
 *    inEvent:
 *      The event to pass thru.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CallNextEventHandler(inCallRef: EventHandlerCallRef; inEvent: EventRef): OSStatus;

{��������������������������������������������������������������������������������������}
{  � Sending Events                                                                    }
{��������������������������������������������������������������������������������������}
{
 *  SendEventToEventTarget()
 *  
 *  Discussion:
 *    Sends an event to the specified event target.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to send.
 *    
 *    inTarget:
 *      The target to send it to.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SendEventToEventTarget(inEvent: EventRef; inTarget: EventTargetRef): OSStatus;

{======================================================================================}
{  EVENT-BASED OBJECT CLASSES                                                          }
{                                                                                      }
{  Here it is - the replacement for classic defprocs. This is also a convenient way    }
{  to create toolbox objects (windows, etc.) that have a specific behavior without     }
{  installing handlers on each instance of the object. With a toolbox object class,    }
{  you register your class, then use special creation routines to create objects of    }
{  that class. The event handlers are automatically installed and ready to go.         }
{======================================================================================}


TYPE
	ToolboxObjectClassRef    = ^LONGINT; { an opaque 32-bit type }
	ToolboxObjectClassRefPtr = ^ToolboxObjectClassRef;  { when a VAR xx:ToolboxObjectClassRef parameter can be nil, it is changed to xx: ToolboxObjectClassRefPtr }

	{
	 *  RegisterToolboxObjectClass()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION RegisterToolboxObjectClass(inClassID: CFStringRef; inBaseClass: ToolboxObjectClassRef; inNumEvents: UInt32; {CONST}VAR inEventList: EventTypeSpec; inEventHandler: EventHandlerUPP; inEventHandlerData: UNIV Ptr; VAR outClassRef: ToolboxObjectClassRef): OSStatus;

{
 *  UnregisterToolboxObjectClass()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION UnregisterToolboxObjectClass(inClassRef: ToolboxObjectClassRef): OSStatus;

{======================================================================================}
{  � Command Routines                                                                  }
{======================================================================================}

{
 *  ProcessHICommand()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION ProcessHICommand({CONST}VAR inCommand: HICommand): OSStatus;

{��������������������������������������������������������������������������������������}
{  � Event Loop Routines                                                               }
{��������������������������������������������������������������������������������������}

{
 *  RunApplicationEventLoop()
 *  
 *  Discussion:
 *    This routine is used as the main event loop for a Carbon
 *    Event-based application. Once entered, this function waits for
 *    events to arrive and dispatches them to your event handlers
 *    automatically.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE RunApplicationEventLoop;

{
 *  QuitApplicationEventLoop()
 *  
 *  Discussion:
 *    This routine is used to quit the RunApplicationEventLoop
 *    function. Typically, your application doesn't need to call this.
 *    If your application has the Quit menu item tagged with the
 *    kHICommandQuit Menu Command ID, the toolbox will automatically
 *    call this for your application, automatically terminating your
 *    event loop. If your application wants to do pre-processing before
 *    the event loop exits, it should intercept either the
 *    kHICommandQuit menu command, or the kEventApplicationQuit event.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE QuitApplicationEventLoop;

{��������������������������������������������������������������������������������������}
{  � Event Modality routines                                                           }
{��������������������������������������������������������������������������������������}

{
 *  RunAppModalLoopForWindow()
 *  
 *  Discussion:
 *    This routine is used as a replacement to ModalDialog to drive a
 *    Carbon Event-based modal dialog. Once called, this routine will
 *    not exit until QuitAppModalLoopForWindow is called.
 *  
 *  Parameters:
 *    
 *    inWindow:
 *      The window you wish to behave modally.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION RunAppModalLoopForWindow(inWindow: WindowRef): OSStatus; C;

{
 *  QuitAppModalLoopForWindow()
 *  
 *  Discussion:
 *    This routine is used to quit a currently running call to
 *    RunAppModalLoopForWindow, i.e. it terminates a modal loop.
 *    Typically this would be called from a handler you have installed
 *    on the modal window in question when the user clicks the
 *    appropriate button, etc.
 *  
 *  Parameters:
 *    
 *    inWindow:
 *      The window for which to quit the modal state.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION QuitAppModalLoopForWindow(inWindow: WindowRef): OSStatus; C;

{
 *  BeginAppModalStateForWindow()
 *  
 *  Discussion:
 *    This routine is a lower level routine than
 *    RunAppModalLoopForWindow. It can be used if you wish to enter an
 *    app modal state for a window, but need to control the event loop
 *    yourself for whatever reason. In most cases, you would use
 *    RunAppModalLoopForWindow. Once you begin your app modal state,
 *    the menu bar will disable and prepare for the modal situation.
 *  
 *  Parameters:
 *    
 *    inWindow:
 *      The window you wish to behave modally.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION BeginAppModalStateForWindow(inWindow: WindowRef): OSStatus; C;

{
 *  EndAppModalStateForWindow()
 *  
 *  Discussion:
 *    This routine ends an app modal state started with
 *    BeginAppModalStateForWindow.
 *  
 *  Parameters:
 *    
 *    inWindow:
 *      The window you wish to stop acting as app modal.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION EndAppModalStateForWindow(inWindow: WindowRef): OSStatus; C;


{��������������������������������������������������������������������������������������}
{  � User Focus                                                                        }
{                                                                                      }
{ The 'user focus' is where keyboard input goes. We also use the term 'key' applied    }
{ to windows to mean this. The user focus window is normally the active non-floating   }
{ window or dialog. It is possible to make a floater get the focus, however, by calling}
{ SetUserFocusWindow. After that call, the event model will automatically route key    }
{ input to the active keyboard focus of that window, if any. Passing kUserFocusAuto    }
{ into the window parameter tells the toolbox to pick what it considers to be the best }
{ candidate for focus. You should call this to restore focus, rather than getting the  }
{ focus, setting it to a special window, and then restoring to the saved focus. There  }
{ are cases, however, when you might want to restore to an explicit window, but the    }
{ typical usage should just be to restore to the kUserFocusAuto focus.                 }
{                                                                                      }
{ Keep in mind that setting the focus will only last until you restore focus, or the   }
{ user starts clicking in other windows. When that happens, the toolbox will auto-     }
{ redirect the user focus to a newly selected window.                                  }
{��������������������������������������������������������������������������������������}

CONST
	kUserFocusAuto				= -1;

	{
	 *  SetUserFocusWindow()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION SetUserFocusWindow(inWindow: WindowRef): OSStatus;

{
 *  GetUserFocusWindow()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetUserFocusWindow: WindowRef;


{��������������������������������������������������������������������������������������}
{  � Default/Cancel buttons                                                            }
{                                                                                      }
{ In our quest to eliminate the need for dialogs when using the new event model, we    }
{ have added the following routines which add dialog-like button control to normal     }
{ windows. With these routines, you can set the default and cancel buttons for a       }
{ window; these work just like the corresponding concepts in dialogs, and when         }
{ present, the standard toolbox handlers will handle keyboard input mapping to these   }
{ buttons. This means that pressing return or enter will 'press' the default button    }
{ and escape or command-period will 'press' the cancel button.                         }
{��������������������������������������������������������������������������������������}

{
 *  SetWindowDefaultButton()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetWindowDefaultButton(inWindow: WindowRef; inControl: ControlRef): OSStatus;

{
 *  SetWindowCancelButton()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION SetWindowCancelButton(inWindow: WindowRef; inControl: ControlRef): OSStatus;

{
 *  GetWindowDefaultButton()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetWindowDefaultButton(inWindow: WindowRef; VAR outControl: ControlRef): OSStatus;

{
 *  GetWindowCancelButton()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION GetWindowCancelButton(inWindow: WindowRef; VAR outControl: ControlRef): OSStatus;


{��������������������������������������������������������������������������������������}
{  � Global HotKey API                                                                 }
{��������������������������������������������������������������������������������������}

TYPE
	EventHotKeyIDPtr = ^EventHotKeyID;
	EventHotKeyID = RECORD
		signature:				OSType;
		id:						UInt32;
	END;

	EventHotKeyRef    = ^LONGINT; { an opaque 32-bit type }
	EventHotKeyRefPtr = ^EventHotKeyRef;  { when a VAR xx:EventHotKeyRef parameter can be nil, it is changed to xx: EventHotKeyRefPtr }
	{
	 *  RegisterEventHotKey()
	 *  
	 *  Discussion:
	 *    Registers a global hot key based on the virtual key code and
	 *    modifiers you pass in. Only one such combination can exist for
	 *    the current application, i.e. multiple entities in the same
	 *    application cannot register for the same hot key combination. The
	 *    same hot key can, however, be registered by multiple
	 *    applications. This means that multiple applications can
	 *    potentially be notified when a particular hot key is requested.
	 *    This might not necessarily be desirable, but it is how it works
	 *    at present.
	 *  
	 *  Parameters:
	 *    
	 *    inHotKeyCode:
	 *      The virtual key code of the key to watch
	 *    
	 *    inHotKeyModifiers:
	 *      The keyboard modifiers to look for. There must be a modifier
	 *      specified, or this function will return paramErr.
	 *    
	 *    inHotKeyID:
	 *      The application-specified hot key ID. You will receive this in
	 *      the kEventHotKeyPressed event as the direct object parameter.
	 *    
	 *    inTarget:
	 *      The target to notify when the hot key is pressed.
	 *    
	 *    inOptions:
	 *      Currently unused. Pass 0 or face the consequences.
	 *    
	 *    outRef:
	 *      The EventHotKeyRef that represents your new, shiny hot key. You
	 *      need this if you later wish to unregister it.
	 *  
	 *  Result:
	 *    An operating system status code.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.3 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION RegisterEventHotKey(inHotKeyCode: UInt32; inHotKeyModifiers: UInt32; inHotKeyID: EventHotKeyID; inTarget: EventTargetRef; inOptions: OptionBits; VAR outRef: EventHotKeyRef): OSStatus; C;

{
 *  UnregisterEventHotKey()
 *  
 *  Discussion:
 *    Unregisters a global hot key that was previously registered with
 *    the RegisterEventHotKey API. You do not need to unregister a hot
 *    key when your application terminates, the system will take care
 *    of that for you. This would be used if the user changes a hot key
 *    for something in your application - you would unregister the
 *    previous key and register your new key.
 *  
 *  Parameters:
 *    
 *    inHotKey:
 *      The EventHotKeyRef to unregister.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION UnregisterEventHotKey(inHotKey: EventHotKeyRef): OSStatus; C;


{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CarbonEventsIncludes}

{$ENDC} {__CARBONEVENTS__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CardServices.p
 
     Contains:   The client interface to Card and Socket Services.
 
     Version:    Technology: System 7.5
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1994-2001 by Apple Computer, Inc. All rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CardServices;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CARDSERVICES__}
{$SETC __CARDSERVICES__ := 1}

{$I+}
{$SETC CardServicesIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}
{$IFC UNDEFINED __PCCARDTUPLES__}
{$I PCCardTuples.p}
{$ENDC}
{$IFC UNDEFINED __MIXEDMODE__}
{$I MixedMode.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{   miscellaneous }


CONST
	CS_MAX_SOCKETS				= 32;							{  a long is used as a socket bitmap }


	{  Will move to <Traps.h> }
	_PCCardDispatch				= $AAF0;						{  Card Services entry trap }

	{  Will move to <Errors.h> }

	{   result codes }

	kCSBadAdapterErr			= -9050;						{  invalid adapter number }
	kCSBadAttributeErr			= -9051;						{  specified attributes field value is invalid }
	kCSBadBaseErr				= -9052;						{  specified base system memory address is invalid }
	kCSBadEDCErr				= -9053;						{  specified EDC generator specified is invalid }
	kCSBadIRQErr				= -9054;						{  specified IRQ level is invalid }
	kCSBadOffsetErr				= -9055;						{  specified PC card memory array offset is invalid }
	kCSBadPageErr				= -9056;						{  specified page is invalid }
	kCSBadSizeErr				= -9057;						{  specified size is invalid }
	kCSBadSocketErr				= -9058;						{  specified logical or physical socket number is invalid }
	kCSBadTypeErr				= -9059;						{  specified window or interface type is invalid }
	kCSBadVccErr				= -9060;						{  specified Vcc power level index is invalid }
	kCSBadVppErr				= -9061;						{  specified Vpp1 or Vpp2 power level index is invalid }
	kCSBadWindowErr				= -9062;						{  specified window is invalid }
	kCSBadArgLengthErr			= -9063;						{  ArgLength argument is invalid }
	kCSBadArgsErr				= -9064;						{  values in argument packet are invalid }
	kCSBadHandleErr				= -9065;						{  clientHandle is invalid }
	kCSBadCISErr				= -9066;						{  CIS on card is invalid }
	kCSBadSpeedErr				= -9067;						{  specified speed is unavailable }
	kCSReadFailureErr			= -9068;						{  unable to complete read request }
	kCSWriteFailureErr			= -9069;						{  unable to complete write request }
	kCSGeneralFailureErr		= -9070;						{  an undefined error has occurred }
	kCSNoCardErr				= -9071;						{  no PC card in the socket }
	kCSUnsupportedFunctionErr	= -9072;						{  function is not supported by this implementation }
	kCSUnsupportedModeErr		= -9073;						{  mode is not supported }
	kCSBusyErr					= -9074;						{  unable to process request at this time - try later }
	kCSWriteProtectedErr		= -9075;						{  media is write-protected }
	kCSConfigurationLockedErr	= -9076;						{  a configuration has already been locked }
	kCSInUseErr					= -9077;						{  requested resource is being used by a client }
	kCSNoMoreItemsErr			= -9078;						{  there are no more of the requested item }
	kCSOutOfResourceErr			= -9079;						{  Card Services has exhausted the resource }



	{   messages sent to client's event handler }

	kCSNullMessage				= $00;							{  no messages pending (not sent to clients) }
	kCSCardInsertionMessage		= $01;							{  card has been inserted into the socket }
	kCSCardRemovalMessage		= $02;							{  card has been removed from the socket }
	kCSCardLockMessage			= $03;							{  card is locked into the socket with a mechanical latch }
	kCSCardUnlockMessage		= $04;							{  card is no longer locked into the socket }
	kCSCardReadyMessage			= $05;							{  card is ready to be accessed }
	kCSCardResetMessage			= $06;							{  physical reset has completed }
	kCSInsertionRequestMessage	= $07;							{  request to insert a card using insertion motor }
	kCSInsertionCompleteMessage	= $08;							{  insertion motor has finished inserting a card }
	kCSEjectionRequestMessage	= $09;							{  user or other client is requesting a card ejection }
	kCSEjectionFailedMessage	= $0A;							{  eject failure due to electrical/mechanical problems }
	kCSPMResumeMessage			= $0B;							{  power management resume (TBD) }
	kCSPMSuspendMessage			= $0C;							{  power management suspend (TBD) }
	kCSResetPhysicalMessage		= $0D;							{  physical reset is about to occur on this card }
	kCSResetRequestMessage		= $0E;							{  physical reset has been requested by a client }
	kCSResetCompleteMessage		= $0F;							{  ResetCard() background reset has completed }
	kCSBatteryDeadMessage		= $10;							{  battery is no longer useable, data will be lost }
	kCSBatteryLowMessage		= $11;							{  battery is weak and should be replaced }
	kCSWriteProtectMessage		= $12;							{  card is now write protected }
	kCSWriteEnabledMessage		= $13;							{  card is now write enabled }
	kCSClientInfoMessage		= $14;							{  client is to return client information }
	kCSSSUpdatedMessage			= $15;							{  AddSocketServices/ReplaceSocket services has changed SS support }
	kCSFunctionInterruptMessage	= $16;							{  card function interrupt }
	kCSAccessErrorMessage		= $17;							{  client bus errored on access to socket }
	kCSCardUnconfiguredMessage	= $18;							{  a CARD_READY was delivered to all clients and no client  }
																{     requested a configuration for the socket }
	kCSStatusChangedMessage		= $19;							{  status change for cards in I/O mode }

	{	
	    The following is a mapping of the PCMCIA name space to the Macintosh name space.
	    These two enum lists will be removed and given to developers as a separate file.
		}
	SUCCESS						= 0;
	BAD_ADAPTER					= -9050;
	BAD_ATTRIBUTE				= -9051;
	BAD_BASE					= -9052;
	BAD_EDC						= -9053;
	BAD_IRQ						= -9054;
	BAD_OFFSET					= -9055;
	BAD_PAGE					= -9056;
	BAD_SIZE					= -9057;
	BAD_SOCKET					= -9058;
	BAD_TYPE					= -9059;
	BAD_VCC						= -9060;
	BAD_VPP						= -9061;
	BAD_WINDOW					= -9062;
	BAD_ARG_LENGTH				= -9063;
	BAD_ARGS					= -9064;
	BAD_HANDLE					= -9065;
	BAD_CIS						= -9066;
	BAD_SPEED					= -9067;
	READ_FAILURE				= -9068;
	WRITE_FAILURE				= -9069;
	GENERAL_FAILURE				= -9070;
	NO_CARD						= -9071;
	UNSUPPORTED_FUNCTION		= -9072;
	UNSUPPORTED_MODE			= -9073;
	BUSY						= -9074;
	WRITE_PROTECTED				= -9075;
	CONFIGURATION_LOCKED		= -9076;
	IN_USE						= -9077;
	NO_MORE_ITEMS				= -9078;
	OUT_OF_RESOURCE				= -9079;


	{   messages sent to client's event handler }

	NULL_MESSAGE				= $00;
	CARD_INSERTION				= $01;
	CARD_REMOVAL				= $02;
	CARD_LOCK					= $03;
	CARD_UNLOCK					= $04;
	CARD_READY					= $05;
	CARD_RESET					= $06;
	INSERTION_REQUEST			= $07;
	INSERTION_COMPLETE			= $08;
	EJECTION_REQUEST			= $09;
	EJECTION_FAILED				= $0A;
	PM_RESUME					= $0B;
	PM_SUSPEND					= $0C;
	RESET_PHYSICAL				= $0D;
	RESET_REQUEST				= $0E;
	RESET_COMPLETE				= $0F;
	BATTERY_DEAD				= $10;
	BATTERY_LOW					= $11;
	WRITE_PROTECT				= $12;
	WRITE_ENABLED				= $13;
	CLIENT_INFO					= $14;
	SS_UPDATED					= $15;
	FUNCTION_INTERRUPT			= $16;
	ACCESS_ERROR				= $17;
	CARD_UNCONFIGURED			= $18;
	STATUS_CHANGED				= $19;


	{ ----------------      CSAccessConfigurationRegister   ---------------- }


TYPE
	AccessConfigurationRegisterPBPtr = ^AccessConfigurationRegisterPB;
	AccessConfigurationRegisterPB = RECORD
		socket:					UInt16;									{   -> global socket number }
		action:					SInt8;									{   -> read/write }
		offset:					SInt8;									{   -> offset from config register base }
		value:					SInt8;									{  <-> value to read/write }
		padding:				SInt8;									{   }
	END;

	{   �action� field values }


CONST
	kCSReadConfigRegister		= $00;
	kCSWriteConfigRegister		= $01;


	{ ----------------      CSGetCardServicesInfo           ---------------- }


TYPE
	GetCardServicesInfoPBPtr = ^GetCardServicesInfoPB;
	GetCardServicesInfoPB = RECORD
		signature:				PACKED ARRAY [0..1] OF UInt8;			{  <-  two ascii chars 'CS' }
		count:					UInt16;									{  <-  total number of sockets installed }
		revision:				UInt16;									{  <-  BCD }
		csLevel:				UInt16;									{  <-  BCD }
		reserved:				UInt16;									{   -> zero }
		vStrLen:				UInt16;									{  <-> in: client's buffer size, out: vendor string length }
		vendorString:			Ptr;									{  <-> in: pointer to buffer to hold CS vendor string (zero-terminated) }
																		{     out: CS vendor string copied to buffer }
	END;

	{ ----------------      CSGetClientInfo                 ---------------- }


	{  upper byte of attributes is kCSClientInfoSubfunction }
	ClientInfoParamPtr = ^ClientInfoParam;
	ClientInfoParam = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		attributes:				UInt16;									{  <-> subfunction + bitmapped client attributes }
		revision:				UInt16;									{  <-  BCD value of client's revision }
		csLevel:				UInt16;									{  <-  BCD value of CS release }
		revDate:				UInt16;									{  <-  revision date: y[15-9], m[8-5], d[4-0] }
		nameLen:				SInt16;									{  <-> in: max length of client name string, out: actual length }
		vStringLen:				SInt16;									{  <-> in: max length of vendor string, out: actual length }
		nameString:				Ptr;									{  <-  pointer to client name string (zero-terminated) }
		vendorString:			Ptr;									{  <-  pointer to vendor string (zero-terminated) }
	END;

	{
	   upper byte of attributes is kCSCardNameSubfunction,
	                               kCSCardTypeSubfunction,
	                               kCSHelpStringSubfunction
	}
	AlternateTextStringParamPtr = ^AlternateTextStringParam;
	AlternateTextStringParam = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		attributes:				UInt16;									{  <-> subfunction + bitmapped client attributes }
		socket:					UInt16;									{   -> logical socket number }
		reserved:				UInt16;									{   -> zero }
		length:					SInt16;									{  <-> in: max length of string, out: actual length }
		text:					Ptr;									{  <-  pointer to string (zero-terminated) }
	END;

	{  upper byte of attributes is kCSCardIconSubfunction }
	AlternateCardIconParamPtr = ^AlternateCardIconParam;
	AlternateCardIconParam = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		attributes:				UInt16;									{  <-> subfunction + bitmapped client attributes }
		socket:					UInt16;									{   -> logical socket number }
		iconSuite:				Handle;									{  <-  handle to icon suite containing all icons }
	END;

	{  upper byte of attributes is kCSActionProcSubfunction }
	CustomActionProcParamPtr = ^CustomActionProcParam;
	CustomActionProcParam = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		attributes:				UInt16;									{  <-> subfunction + bitmapped client attributes }
		socket:					UInt16;									{   -> logical socket number }
	END;

	GetClientInfoPBPtr = ^GetClientInfoPB;
	GetClientInfoPB = RECORD
		CASE INTEGER OF
		0: (
			clientInfo:			ClientInfoParam;
			);
		1: (
			alternateTextString: AlternateTextStringParam;
			);
		2: (
			alternateIcon:		AlternateCardIconParam;
			);
		3: (
			customActionProc:	CustomActionProcParam;
			);
	END;

	{   �attributes� field values }

CONST
	kCSMemoryClient				= $0001;
	kCSIOClient					= $0004;
	kCSClientTypeMask			= $0007;
	kCSShareableCardInsertEvents = $0008;
	kCSExclusiveCardInsertEvents = $0010;
	kCSInfoSubfunctionMask		= $FF00;
	kCSClientInfoSubfunction	= $0000;
	kCSCardNameSubfunction		= $8000;
	kCSCardTypeSubfunction		= $8100;
	kCSHelpStringSubfunction	= $8200;
	kCSCardIconSubfunction		= $8300;
	kCSActionProcSubfunction	= $8400;


	{
	  ----------------      CSGetConfigurationInfo          ----------------
	  ----------------      CSModifyConfiguration           ----------------
	  ----------------      CSRequestConfiguration          ----------------
	}


TYPE
	GetModRequestConfigInfoPBPtr = ^GetModRequestConfigInfoPB;
	GetModRequestConfigInfoPB = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		socket:					UInt16;									{   -> logical socket number }
		attributes:				UInt16;									{  <-> bitmap of configuration attributes }
		vcc:					SInt8;									{  <-> Vcc setting }
		vpp1:					SInt8;									{  <-> Vpp1 setting }
		vpp2:					SInt8;									{  <-> Vpp2 setting }
		intType:				SInt8;									{  <-> interface type (memory or memory+I/O) }
		configBase:				UInt32;									{  <-> card base address of configuration registers }
		status:					SInt8;									{  <-> card status register setting, if present }
		pin:					SInt8;									{  <-> card pin register setting, if present }
		copy:					SInt8;									{  <-> card socket/copy register setting, if present }
		configIndex:			SInt8;									{  <-> card option register setting, if present }
		present:				SInt8;									{  <-> bitmap of which configuration registers are present }
		firstDevType:			SInt8;									{  <-  from DeviceID tuple }
		funcCode:				SInt8;									{  <-  from FuncID tuple }
		sysInitMask:			SInt8;									{  <-  from FuncID tuple }
		manufCode:				UInt16;									{  <-  from ManufacturerID tuple }
		manufInfo:				UInt16;									{  <-  from ManufacturerID tuple }
		cardValues:				SInt8;									{  <-  valid card register values }
		padding:				SInt8;									{   }
	END;

	{   �attributes� field values }

CONST
	kCSExclusivelyUsed			= $0001;
	kCSEnableIREQs				= $0002;
	kCSVccChangeValid			= $0004;
	kCSVpp1ChangeValid			= $0008;
	kCSVpp2ChangeValid			= $0010;
	kCSValidClient				= $0020;
	kCSSleepPower				= $0040;						{  request that power be applied to socket during Sleep }
	kCSLockSocket				= $0080;
	kCSTurnOnInUse				= $0100;

	{   �intType� field values }

	kCSMemoryInterface			= $01;
	kCSMemory_And_IO_Interface	= $02;

	{   �present� field values }

	kCSOptionRegisterPresent	= $01;
	kCSStatusRegisterPresent	= $02;
	kCSPinReplacementRegisterPresent = $04;
	kCSCopyRegisterPresent		= $08;

	{   �cardValues� field values }

	kCSOptionValueValid			= $01;
	kCSStatusValueValid			= $02;
	kCSPinReplacementValueValid	= $04;
	kCSCopyValueValid			= $08;


	{
	  ----------------      CSGetClientEventMask            ----------------
	  ----------------      CSSetClientEventMask            ----------------
	}


TYPE
	GetSetClientEventMaskPBPtr = ^GetSetClientEventMaskPB;
	GetSetClientEventMaskPB = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		attributes:				UInt16;									{  <-> bitmap of attributes }
		eventMask:				UInt16;									{  <-> bitmap of events to be passed to client for this socket }
		socket:					UInt16;									{   -> logical socket number }
	END;

	{   �attributes� field values }

CONST
	kCSEventMaskThisSocketOnly	= $0001;

	{   �eventMask� field values }

	kCSWriteProtectEvent		= $0001;
	kCSCardLockChangeEvent		= $0002;
	kCSEjectRequestEvent		= $0004;
	kCSInsertRequestEvent		= $0008;
	kCSBatteryDeadEvent			= $0010;
	kCSBatteryLowEvent			= $0020;
	kCSReadyChangeEvent			= $0040;
	kCSCardDetectChangeEvent	= $0080;
	kCSPMChangeEvent			= $0100;
	kCSResetEvent				= $0200;
	kCSSSUpdateEvent			= $0400;
	kCSFunctionInterrupt		= $0800;
	kCSAllEvents				= $FFFF;


	{
	  ----------------      CSGetFirstClient                ----------------
	  ----------------      CSGetNextClient                 ----------------
	}


TYPE
	GetClientPBPtr = ^GetClientPB;
	GetClientPB = RECORD
		clientHandle:			UInt32;									{  <-  clientHandle for this client }
		socket:					UInt16;									{   -> logical socket number }
		attributes:				UInt16;									{   -> bitmap of attributes }
	END;

	{   �attributes� field values }

CONST
	kCSClientsForAllSockets		= $0000;
	kCSClientsThisSocketOnly	= $0001;


	{
	  ----------------      CSGetFirstTuple                 ----------------
	  ----------------      CSGetNextTuple                  ----------------
	  ----------------      CSGetTupleData                  ----------------
	}


TYPE
	GetTuplePBPtr = ^GetTuplePB;
	GetTuplePB = RECORD
		socket:					UInt16;									{   -> logical socket number }
		attributes:				UInt16;									{   -> bitmap of attributes }
		desiredTuple:			SInt8;									{   -> desired tuple code value, or $FF for all }
		tupleOffset:			SInt8;									{   -> offset into tuple from link byte }
		flags:					UInt16;									{  <-> internal use }
		linkOffset:				UInt32;									{  <-> internal use }
		cisOffset:				UInt32;									{  <-> internal use }
		CASE INTEGER OF
		0: (
			tupleCode:			SInt8;									{  <-  tuple code found }
			tupleLink:			SInt8;									{  <-  link value for tuple found }
		   );
		1: (
			tupleDataMax:		UInt16;									{   -> maximum size of tuple data area }
			tupleDataLen:		UInt16;									{  <-  number of bytes in tuple body }
			tupleData:			TupleBody;								{  <-  tuple data }
		   );
	END;

	{   �attributes� field values }

CONST
	kCSReturnLinkTuples			= $0001;


	{
	  ----------------      CSRequestSocketMask             ----------------
	  ----------------      CSReleaseSocketMask             ----------------
	}


TYPE
	ReqRelSocketMaskPBPtr = ^ReqRelSocketMaskPB;
	ReqRelSocketMaskPB = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		socket:					UInt16;									{   -> logical socket }
		eventMask:				UInt16;									{   -> bitmap of events to be passed to client for this socket }
	END;

	{   �eventMask� field values (see above for Get/SetClientEventMask }

	{ ----------------      CSGetStatus                     ---------------- }

	GetStatusPBPtr = ^GetStatusPB;
	GetStatusPB = RECORD
		socket:					UInt16;									{   -> logical socket number }
		cardState:				UInt16;									{  <-  current state of installed card }
		socketState:			UInt16;									{  <-  current state of the socket }
	END;

	{   �cardState� field values }

CONST
	kCSWriteProtected			= $0001;
	kCSCardLocked				= $0002;
	kCSEjectRequest				= $0004;
	kCSInsertRequest			= $0008;
	kCSBatteryDead				= $0010;
	kCSBatteryLow				= $0020;
	kCSReady					= $0040;
	kCSCardDetected				= $0080;

	{   �socketState� field values }

	kCSWriteProtectChanged		= $0001;
	kCSCardLockChanged			= $0002;
	kCSEjectRequestPending		= $0004;
	kCSInsertRequestPending		= $0008;
	kCSBatteryDeadChanged		= $0010;
	kCSBatteryLowChanged		= $0020;
	kCSReadyChanged				= $0040;
	kCSCardDetectChanged		= $0080;


	{
	  ----------------      CSModifyWindow                  ----------------
	  ----------------      CSReleaseWindow                 ----------------
	  ----------------      CSRequestWindow                 ----------------
	}


TYPE
	ReqModRelWindowPBPtr = ^ReqModRelWindowPB;
	ReqModRelWindowPB = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		windowHandle:			UInt32;									{  <-> window descriptor }
		socket:					UInt16;									{   -> logical socket number }
		attributes:				UInt16;									{   -> window attributes (bitmap) }
		base:					UInt32;									{  <-> system base address }
		size:					UInt32;									{  <-> memory window size }
		accessSpeed:			SInt8;									{   -> window access speed (bitmap) }
																		{        (not applicable for I/O mode) }
		padding:				SInt8;									{   }
	END;

	{   �attributes� field values }

CONST
	kCSMemoryWindow				= $0001;
	kCSIOWindow					= $0002;
	kCSAttributeWindow			= $0004;						{  not normally used by Card Services clients }
	kCSWindowTypeMask			= $0007;
	kCSEnableWindow				= $0008;
	kCSAccessSpeedValid			= $0010;
	kCSLittleEndian				= $0020;						{  configure socket for little endianess }
	kCS16BitDataPath			= $0040;
	kCSWindowPaged				= $0080;						{   }
	kCSWindowShared				= $0100;
	kCSWindowFirstShared		= $0200;						{   }
	kCSWindowProgrammable		= $0400;						{   }

	{   �accessSpeed� field values }

	kCSDeviceSpeedCodeMask		= $07;
	kCSSpeedExponentMask		= $07;
	kCSSpeedMantissaMask		= $78;
	kCSUseWait					= $80;
	kCSAccessSpeed250nsec		= $01;
	kCSAccessSpeed200nsec		= $02;
	kCSAccessSpeed150nsec		= $03;
	kCSAccessSpeed100nsec		= $04;
	kCSExtAccSpeedMant1pt0		= $01;
	kCSExtAccSpeedMant1pt2		= $02;
	kCSExtAccSpeedMant1pt3		= $03;
	kCSExtAccSpeedMant1pt5		= $04;
	kCSExtAccSpeedMant2pt0		= $05;
	kCSExtAccSpeedMant2pt5		= $06;
	kCSExtAccSpeedMant3pt0		= $07;
	kCSExtAccSpeedMant3pt5		= $08;
	kCSExtAccSpeedMant4pt0		= $09;
	kCSExtAccSpeedMant4pt5		= $0A;
	kCSExtAccSpeedMant5pt0		= $0B;
	kCSExtAccSpeedMant5pt5		= $0C;
	kCSExtAccSpeedMant6pt0		= $0D;
	kCSExtAccSpeedMant7pt0		= $0E;
	kCSExtAccSpeedMant8pt0		= $0F;
	kCSExtAccSpeedExp1ns		= $00;
	kCSExtAccSpeedExp10ns		= $01;
	kCSExtAccSpeedExp100ns		= $02;
	kCSExtAccSpeedExp1us		= $03;
	kCSExtAccSpeedExp10us		= $04;
	kCSExtAccSpeedExp100us		= $05;
	kCSExtAccSpeedExp1ms		= $06;
	kCSExtAccSpeedExp10ms		= $07;


	{
	  ----------------      CSRegisterClient                ----------------
	  ----------------      CSDeregisterClient              ----------------
	}


TYPE
	ClientCallbackPBPtr = ^ClientCallbackPB;
	ClientCallbackPB = RECORD
		message:				UInt16;									{   -> which event this is }
		socket:					UInt16;									{   -> logical socket number }
		info:					UInt16;									{   -> function-specific }
		misc:					UInt16;									{   -> function-specific }
		reserved:				Ptr;									{   -> pointer to MTD request block }
		buffer:					Ptr;									{   -> function-specific }
		clientData:				Ptr;									{   -> pointer to client's data (from RegisterClient) }
	END;

{$IFC TYPED_FUNCTION_POINTERS}
	PCCardCSClientProcPtr = FUNCTION(ccPBPtr: ClientCallbackPBPtr): UInt16;
{$ELSEC}
	PCCardCSClientProcPtr = ProcPtr;
{$ENDC}

{$IFC OPAQUE_UPP_TYPES}
	PCCardCSClientUPP = ^LONGINT; { an opaque UPP }
{$ELSEC}
	PCCardCSClientUPP = UniversalProcPtr;
{$ENDC}	

CONST
	uppPCCardCSClientProcInfo = $000000E0;
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  NewPCCardCSClientUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION NewPCCardCSClientUPP(userRoutine: PCCardCSClientProcPtr): PCCardCSClientUPP; { old name was NewPCCardCSClientProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $2E9F;
	{$ENDC}

{
 *  DisposePCCardCSClientUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
PROCEDURE DisposePCCardCSClientUPP(userUPP: PCCardCSClientUPP);
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $584F;
	{$ENDC}

{
 *  InvokePCCardCSClientUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION InvokePCCardCSClientUPP(ccPBPtr: ClientCallbackPBPtr; userRoutine: PCCardCSClientUPP): UInt16; { old name was CallPCCardCSClientProc }
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $205F, $4E90;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}


TYPE
	RegisterClientPBPtr = ^RegisterClientPB;
	RegisterClientPB = RECORD
		clientHandle:			UInt32;									{  <-  client descriptor }
		clientEntry:			PCCardCSClientUPP;						{   -> universal procPtr to client's event handler }
		attributes:				UInt16;									{   -> bitmap of client attributes }
		eventMask:				UInt16;									{   -> bitmap of events to notify client }
		clientData:				Ptr;									{   -> pointer to client's data }
		version:				UInt16;									{   -> Card Services version this client expects }
	END;

	{   �attributes� field values (see GetClientInfo) }
	{
	    kCSMemoryClient                 = 0x0001,
	    kCSIOClient                     = 0x0004,
	    kCSShareableCardInsertEvents    = 0x0008,
	    kCSExclusiveCardInsertEvents    = 0x0010
	}


	{ ----------------      CSReleaseConfiguration          ---------------- }

	ReleaseConfigurationPBPtr = ^ReleaseConfigurationPB;
	ReleaseConfigurationPB = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		socket:					UInt16;									{   ->  }
	END;

	{ ----------------      CSResetCard                     ---------------- }

	ResetCardPBPtr = ^ResetCardPB;
	ResetCardPB = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		socket:					UInt16;									{   ->  }
		attributes:				UInt16;									{   -> xxx }
	END;

	{ ----------------      CSValidateCIS                   ---------------- }

	ValidateCISPBPtr = ^ValidateCISPB;
	ValidateCISPB = RECORD
		socket:					UInt16;									{   ->  }
		chains:					UInt16;									{   -> whether link/null tuples should be included }
	END;

	{
	  ----------------      CSRequestIO                     ----------------
	  ----------------      CSReleaseIO                     ----------------
	}

	ReqRelIOPBPtr = ^ReqRelIOPB;
	ReqRelIOPB = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		socket:					UInt16;									{   -> socket number }
		reserved:				UInt16;
		basePort1:				UInt16;									{     -> base I/O port for range }
		numPorts1:				SInt8;									{     -> number of ports (e.g., bytes). }
		attributes1:			SInt8;									{     -> attributes }
		basePort2:				UInt16;									{     -> base I/O port for range }
		numPorts2:				SInt8;									{     -> number of ports }
		attributes2:			SInt8;									{     -> attributes }
		ioAddrLines:			SInt8;									{     -> number of I/O lines decoded by card }
		reserved1:				SInt8;
	END;

	{ ----------------      CSVendorSpecific                ---------------- }
	VendorSpecificPBPtr = ^VendorSpecificPB;
	VendorSpecificPB = RECORD
		clientHandle:			UInt32;									{   -> clientHandle returned by RegisterClient }
		vsCode:					UInt16;
		socket:					UInt16;
		dataLen:				UInt32;									{   -> length of buffer pointed to by vsDataPtr }
		vsDataPtr:				Ptr;									{   -> Card Services version this client expects }
	END;

	{   �vsCode� field values }


CONST
	vsAppleReserved				= $0000;
	vsEjectCard					= $0001;
	vsGetCardInfo				= $0002;
	vsEnableSocketEvents		= $0003;
	vsGetCardLocationIcon		= $0004;
	vsGetCardLocationText		= $0005;
	vsGetAdapterInfo			= $0006;

	{
	  ///////////////////////////////////////////////////////////////////////////////////////
	    GetAdapterInfo parameter block (vendor-specific call #6)
	}


TYPE
	GetAdapterInfoPBPtr = ^GetAdapterInfoPB;
	GetAdapterInfoPB = RECORD
		attributes:				UInt32;									{  <-  capabilties of socket's adapter }
		revision:				UInt16;									{  <-  id of adapter }
		reserved:				UInt16;									{   }
		numVoltEntries:			UInt16;									{  <-  number of valid voltage values }
		voltages:				Ptr;									{  <-> array of BCD voltage values }
	END;

	{   �attributes� field values }

CONST
	kCSLevelModeInterrupts		= $00000001;
	kCSPulseModeInterrupts		= $00000002;
	kCSProgrammableWindowAddr	= $00000004;
	kCSProgrammableWindowSize	= $00000008;
	kCSSocketSleepPower			= $00000010;
	kCSSoftwareEject			= $00000020;
	kCSLockableSocket			= $00000040;
	kCSInUseIndicator			= $00000080;

	{
	  ///////////////////////////////////////////////////////////////////////////////////////
	    GetCardInfo parameter block (vendor-specific call #2)
	}


TYPE
	GetCardInfoPBPtr = ^GetCardInfoPB;
	GetCardInfoPB = RECORD
		cardType:				SInt8;									{  <-  type of card in this socket (defined at top of file) }
		subType:				SInt8;									{  <-  more detailed card type (defined at top of file) }
		reserved:				UInt16;									{  <-> reserved (should be set to zero) }
		cardNameLen:			UInt16;									{   -> maximum length of card name to be returned }
		vendorNameLen:			UInt16;									{   -> maximum length of vendor name to be returned }
		cardName:				Ptr;									{   -> pointer to card name string (read from CIS), or nil }
		vendorName:				Ptr;									{   -> pointer to vendor name string (read from CIS), or nil }
	END;

	{   GetCardInfo card types }

CONST
	kCSUnknownCardType			= 0;
	kCSMultiFunctionCardType	= 1;
	kCSMemoryCardType			= 2;
	kCSSerialPortCardType		= 3;
	kCSSerialOnlyType			= 0;
	kCSDataModemType			= 1;
	kCSFaxModemType				= 2;
	kCSFaxAndDataModemMask		= 3;
	kCSVoiceEncodingType		= 4;
	kCSParallelPortCardType		= 4;
	kCSFixedDiskCardType		= 5;
	kCSUnknownFixedDiskType		= 0;
	kCSATAInterface				= 1;
	kCSRotatingDevice			= $00;
	kCSSiliconDevice			= $80;
	kCSVideoAdaptorCardType		= 6;
	kCSNetworkAdaptorCardType	= 7;
	kCSAIMSCardType				= 8;
	kCSNumCardTypes				= 9;


{$IFC UNDEFINED __PCCARDENABLERPLUGIN__ }
	{	
	    NOTE: These prototypes conflict with PCCardEnablerPlugin.�
	          You cannot use both PCCardEnablerPlugin.h and CardServices.h
	          
		}
{$IFC CALL_NOT_IN_CARBON }
	{
	 *  CSVendorSpecific()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
FUNCTION CSVendorSpecific(VAR pb: VendorSpecificPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7000, $AAF0;
	{$ENDC}

{
 *  CSRegisterClient()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSRegisterClient(VAR pb: RegisterClientPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7001, $AAF0;
	{$ENDC}

{
 *  CSDeregisterClient()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSDeregisterClient(VAR pb: RegisterClientPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7002, $AAF0;
	{$ENDC}

{
 *  CSGetFirstTuple()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetFirstTuple(VAR pb: GetTuplePB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7003, $AAF0;
	{$ENDC}

{
 *  CSGetNextTuple()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetNextTuple(VAR pb: GetTuplePB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7004, $AAF0;
	{$ENDC}

{
 *  CSGetTupleData()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetTupleData(VAR pb: GetTuplePB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7005, $AAF0;
	{$ENDC}

{
 *  CSGetConfigurationInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetConfigurationInfo(VAR pb: GetModRequestConfigInfoPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7006, $AAF0;
	{$ENDC}

{
 *  CSGetCardServicesInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetCardServicesInfo(VAR pb: GetCardServicesInfoPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7007, $AAF0;
	{$ENDC}

{
 *  CSGetStatus()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetStatus(VAR pb: GetStatusPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7008, $AAF0;
	{$ENDC}

{
 *  CSValidateCIS()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSValidateCIS(VAR pb: ValidateCISPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7009, $AAF0;
	{$ENDC}

{
 *  CSGetFirstClient()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetFirstClient(VAR pb: GetClientPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $700F, $AAF0;
	{$ENDC}

{
 *  CSGetNextClient()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetNextClient(VAR pb: GetClientPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7010, $AAF0;
	{$ENDC}

{
 *  CSGetClientInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetClientInfo(VAR pb: GetClientInfoPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7011, $AAF0;
	{$ENDC}

{
 *  CSResetCard()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSResetCard(VAR pb: ResetCardPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7012, $AAF0;
	{$ENDC}

{
 *  CSRequestWindow()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSRequestWindow(VAR pb: ReqModRelWindowPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7013, $AAF0;
	{$ENDC}

{
 *  CSModifyWindow()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSModifyWindow(VAR pb: ReqModRelWindowPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7014, $AAF0;
	{$ENDC}

{
 *  CSReleaseWindow()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSReleaseWindow(VAR pb: ReqModRelWindowPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7015, $AAF0;
	{$ENDC}

{
 *  CSRequestConfiguration()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSRequestConfiguration(VAR pb: GetModRequestConfigInfoPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $701B, $AAF0;
	{$ENDC}

{
 *  CSModifyConfiguration()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSModifyConfiguration(VAR pb: GetModRequestConfigInfoPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $701C, $AAF0;
	{$ENDC}

{
 *  CSAccessConfigurationRegister()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSAccessConfigurationRegister(VAR pb: AccessConfigurationRegisterPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $701D, $AAF0;
	{$ENDC}

{
 *  CSReleaseConfiguration()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSReleaseConfiguration(VAR pb: ReleaseConfigurationPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $701E, $AAF0;
	{$ENDC}

{
 *  CSGetClientEventMask()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSGetClientEventMask(VAR pb: GetSetClientEventMaskPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $701F, $AAF0;
	{$ENDC}

{
 *  CSSetClientEventMask()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSSetClientEventMask(VAR pb: GetSetClientEventMaskPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7020, $AAF0;
	{$ENDC}

{
 *  CSRequestSocketMask()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSRequestSocketMask(VAR pb: ReqRelSocketMaskPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7021, $AAF0;
	{$ENDC}

{
 *  CSReleaseSocketMask()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSReleaseSocketMask(VAR pb: ReqRelSocketMaskPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7022, $AAF0;
	{$ENDC}


{
    Additional calls which are required for all I/O clients when running on
    systems which do not reserve dedicated I/O-spaces for each PC Card.
}

{
 *  CSRequestIO()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSRequestIO(VAR pb: ReqRelIOPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7025, $AAF0;
	{$ENDC}

{
 *  CSReleaseIO()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in PCCardLib 1.0 thru 2.0
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
FUNCTION CSReleaseIO(VAR pb: ReqRelIOPB): OSErr;
	{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
	INLINE $7026, $AAF0;
	{$ENDC}

{$ENDC}  {CALL_NOT_IN_CARBON}
{$ENDC}

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CardServicesIncludes}

{$ENDC} {__CARDSERVICES__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFArray.p
 
     Contains:   CoreFoundation array collection
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFArray;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFARRAY__}
{$SETC __CFARRAY__ := 1}

{$I+}
{$SETC CFArrayIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


{
 *  CFArray
 *  
 *  Discussion:
 *    CFArray implements an ordered, compact container of pointer-sized
 *    values. Values are accessed via integer keys (indices), from the
 *    range 0 to N-1, where N is the number of values in the array when
 *    an operation is performed. The array is said to be "compact"
 *    because deleted or inserted values do not leave a gap in the key
 *    space -- the values with higher-numbered indices have their
 *    indices renumbered lower (or higher, in the case of insertion) so
 *    that the set of valid indices is always in the integer range [0,
 *    N-1]. Thus, the index to access a particular value in the array
 *    may change over time as other values are inserted into or deleted
 *    from the array. 
 *    
 *    Arrays come in two flavors, immutable, which cannot have values
 *    added to them or removed from them after the array is created,
 *    and mutable, to which you can add values or from which remove
 *    values. Mutable arrays have two subflavors, fixed-capacity, for
 *    which there is a maximum number set at creation time of values
 *    which can be put into the array, and variable capacity, which can
 *    have an unlimited number of values (or rather, limited only by
 *    constraints external to CFArray, like the amount of available
 *    memory). Fixed-capacity arrays can be somewhat higher performing,
 *    if you can put a definate upper limit on the number of values
 *    that might be put into the array. 
 *    
 *    As with all CoreFoundation collection types, arrays maintain hard
 *    references on the values you put in them, but the retaining and
 *    releasing functions are user-defined callbacks that can actually
 *    do whatever the user wants (for example, nothing). 
 *    
 *    Computational Complexity The access time for a value in the array
 *    is guaranteed to be at worst O(lg N) for any implementation,
 *    current and future, but will often be O(1) (constant time).
 *    Linear search operations similarly have a worst case complexity
 *    of O(N*lg N), though typically the bounds will be tighter, and so
 *    on. Insertion or deletion operations will typically be linear in
 *    the number of values in the array, but may be O(N*lg N) clearly
 *    in the worst case in some implementations. There are no favored
 *    positions within the array for performance; that is, it is not
 *    necessarily faster access values with low indices, or to insert
 *    or delete values with high indices, or whatever.
 }

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	CFArrayRetainCallBack = FUNCTION(allocator: CFAllocatorRef; value: UNIV Ptr): Ptr; C;
{$ELSEC}
	CFArrayRetainCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFArrayReleaseCallBack = PROCEDURE(allocator: CFAllocatorRef; value: UNIV Ptr); C;
{$ELSEC}
	CFArrayReleaseCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFArrayCopyDescriptionCallBack = FUNCTION(value: UNIV Ptr): CFStringRef; C;
{$ELSEC}
	CFArrayCopyDescriptionCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFArrayEqualCallBack = FUNCTION(value1: UNIV Ptr; value2: UNIV Ptr): BOOLEAN; C;
{$ELSEC}
	CFArrayEqualCallBack = ProcPtr;
{$ENDC}


	{
	 *  CFArrayCallBacks
	 *  
	 *  Discussion:
	 *    Structure containing the callbacks of a CFArray.
	 	}
	CFArrayCallBacksPtr = ^CFArrayCallBacks;
	CFArrayCallBacks = RECORD
		version:				CFIndex;
		retain:					CFArrayRetainCallBack;
		release:				CFArrayReleaseCallBack;
		copyDescription:		CFArrayCopyDescriptionCallBack;
		equal:					CFArrayEqualCallBack;
	END;

	{
	 *  kCFTypeArrayCallBacks
	 *  
	 *  Discussion:
	 *    Predefined CFArrayCallBacks structure containing a set of
	 *    callbacks appropriate for use when the values in a CFArray are
	 *    all CFTypes.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}

	{
	 *  CFArrayApplierFunction
	 *  
	 *  Discussion:
	 *    Type of the callback function used by the apply functions of
	 *    CFArrays.
	 *  
	 *  Parameters:
	 *    
	 *    val:
	 *      The current value from the array.
	 *    
	 *    context:
	 *      The user-defined context parameter given to the apply function.
	 	}
{$IFC TYPED_FUNCTION_POINTERS}
	CFArrayApplierFunction = PROCEDURE(value: UNIV Ptr; context: UNIV Ptr); C;
{$ELSEC}
	CFArrayApplierFunction = ProcPtr;
{$ENDC}


	{
	 *  CFArrayRef
	 *  
	 *  Discussion:
	 *    This is the type of a reference to immutable CFArrays.
	 	}
	CFArrayRef    = ^LONGINT; { an opaque 32-bit type }
	CFArrayRefPtr = ^CFArrayRef;  { when a VAR xx:CFArrayRef parameter can be nil, it is changed to xx: CFArrayRefPtr }

	{
	 *  CFMutableArrayRef
	 *  
	 *  Discussion:
	 *    This is the type of a reference to mutable CFArrays.
	 	}
	CFMutableArrayRef    = CFArrayRef;
	CFMutableArrayRefPtr = ^CFMutableArrayRef;  { when a VAR xx:CFMutableArrayRef parameter can be nil, it is changed to xx: CFMutableArrayRefPtr }
	{
	 *  CFArrayGetTypeID()
	 *  
	 *  Discussion:
	 *    Returns the type identifier of all CFArray instances.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFArrayGetTypeID: CFTypeID; C;

{
 *  CFArrayCreate()
 *  
 *  Discussion:
 *    Creates a new immutable array with the given values.
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The CFAllocator which should be used to allocate memory for the
 *      array and its storage for values. This parameter may be NULL in
 *      which case the current default CFAllocator is used. If this
 *      reference is not a valid CFAllocator, the behavior is undefined.
 *    
 *    values:
 *      A C array of the pointer-sized values to be in the array. The
 *      values in the array are ordered in the same order in which they
 *      appear in this C array. This parameter may be NULL if the
 *      numValues parameter is 0. This C array is not changed or freed
 *      by this function. If this parameter is not a valid pointer to a
 *      C array of at least numValues pointers, the behavior is
 *      undefined.
 *    
 *    numValues:
 *      The number of values to copy from the values C array into the
 *      CFArray. This number will be the count of the array. If this
 *      parameter is negative, or greater than the number of values
 *      actually in the values C array, the behavior is undefined.
 *    
 *    callBacks:
 *      A pointer to a CFArrayCallBacks structure initialized with the
 *      callbacks for the array to use on each value in the array. The
 *      retain callback will be used within this function, for example,
 *      to retain all of the new values from the values C array. A copy
 *      of the contents of the callbacks structure is made, so that a
 *      pointer to a structure on the stack can be passed in, or can be
 *      reused for multiple array creations. If the version field of
 *      this callbacks structure is not one of the defined ones for
 *      CFArray, the behavior is undefined. The retain field may be
 *      NULL, in which case the CFArray will do nothing to add a retain
 *      to the contained values for the array. The release field may be
 *      NULL, in which case the CFArray will do nothing to remove the
 *      array's retain (if any) on the values when the array is
 *      destroyed. If the copyDescription field is NULL, the array will
 *      create a simple description for the value. If the equal field
 *      is NULL, the array will use pointer equality to test for
 *      equality of values. This callbacks parameter itself may be
 *      NULL, which is treated as if a valid structure of version 0
 *      with all fields NULL had been passed in. Otherwise, if any of
 *      the fields are not valid pointers to functions of the correct
 *      type, or this parameter is not a valid pointer to a 
 *      CFArrayCallBacks callbacks structure, the behavior is
 *      undefined. If any of the values put into the array is not one
 *      understood by one of the callback functions the behavior when
 *      that callback function is used is undefined.
 *  
 *  Result:
 *    A reference to the new immutable CFArray.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayCreate(allocator: CFAllocatorRef; VAR values: UNIV Ptr; numValues: CFIndex; {CONST}VAR callBacks: CFArrayCallBacks): CFArrayRef; C;

{
 *  CFArrayCreateCopy()
 *  
 *  Discussion:
 *    Creates a new immutable array with the values from the given
 *    array.
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The CFAllocator which should be used to allocate memory for the
 *      array and its storage for values. This parameter may be NULL in
 *      which case the current default CFAllocator is used. If this
 *      reference is not a valid CFAllocator, the behavior is undefined.
 *    
 *    theArray:
 *      The array which is to be copied. The values from the array are
 *      copied as pointers into the new array (that is, the values
 *      themselves are copied, not that which the values point to, if
 *      anything). However, the values are also retained by the new
 *      array. The count of the new array will be the same as the given
 *      array. The new array uses the same callbacks as the array to be
 *      copied. If this parameter is not a valid CFArray, the behavior
 *      is undefined.
 *  
 *  Result:
 *    A reference to the new immutable CFArray.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayCreateCopy(allocator: CFAllocatorRef; theArray: CFArrayRef): CFArrayRef; C;

{
 *  CFArrayCreateMutable()
 *  
 *  Discussion:
 *    Creates a new empty mutable array.
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The CFAllocator which should be used to allocate memory for the
 *      array and its storage for values. This parameter may be NULL in
 *      which case the current default CFAllocator is used. If this
 *      reference is not a valid CFAllocator, the behavior is undefined.
 *    
 *    capacity:
 *      The maximum number of values that can be contained by the
 *      CFArray. The array starts empty, and can grow to this number of
 *      values (and it can have less). If this parameter is 0, the
 *      array's maximum capacity is unlimited (or rather, only limited
 *      by address space and available memory constraints). If this
 *      parameter is negative, the behavior is undefined.
 *    
 *    callBacks:
 *      A pointer to a CFArrayCallBacks structure initialized with the
 *      callbacks for the array to use on each value in the array. A
 *      copy of the contents of the callbacks structure is made, so
 *      that a pointer to a structure on the stack can be passed in, or
 *      can be reused for multiple array creations. If the version
 *      field of this callbacks structure is not one of the defined
 *      ones for CFArray, the behavior is undefined. The retain field
 *      may be NULL, in which case the CFArray will do nothing to add a
 *      retain to the contained values for the array. The release field
 *      may be NULL, in which case the CFArray will do nothing to
 *      remove the arrays retain (if any) on the values when the array
 *      is destroyed. If the copyDescription field is NULL, the array
 *      will create a simple description for the value. If the equal
 *      field is NULL, the array will use pointer equality to test for
 *      equality of values. This callbacks parameter itself may be
 *      NULL, which is treated as if a valid structure of version 0
 *      with all fields NULL had been passed in. Otherwise, if any of
 *      the fields are not valid pointers to functions of the correct
 *      type, or this parameter is not a valid pointer to a 
 *      CFArrayCallBacks callbacks structure, the behavior is
 *      undefined. If any of the values put into the array is not one
 *      understood by one of the callback functions the behavior when
 *      that callback function is used is undefined.
 *  
 *  Result:
 *    A reference to the new mutable CFArray.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayCreateMutable(allocator: CFAllocatorRef; capacity: CFIndex; {CONST}VAR callBacks: CFArrayCallBacks): CFMutableArrayRef; C;

{
 *  CFArrayCreateMutableCopy()
 *  
 *  Discussion:
 *    Creates a new mutable array with the values from the given array.
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The CFAllocator which should be used to allocate memory for the
 *      array and its storage for values. This parameter may be NULL in
 *      which case the current default CFAllocator is used. If this
 *      reference is not a valid CFAllocator, the behavior is undefined.
 *    
 *    capacity:
 *      The maximum number of values that can be contained by the
 *      CFArray. The array starts empty, and can grow to this number of
 *      values (and it can have less). If this parameter is 0, the
 *      array's maximum capacity is unlimited (or rather, only limited
 *      by address space and available memory constraints). This
 *      parameter must be greater than or equal to the count of the
 *      array which is to be copied, or the behavior is undefined. If
 *      this parameter is negative, the behavior is undefined.
 *    
 *    theArray:
 *      The array which is to be copied. The values from the array are
 *      copied as pointers into the new array (that is, the values
 *      themselves are copied, not that which the values point to, if
 *      anything). However, the values are also retained by the new
 *      array. The count of the new array will be the same as the given
 *      array. The new array uses the same callbacks as the array to be
 *      copied. If this parameter is not a valid CFArray, the behavior
 *      is undefined.
 *  
 *  Result:
 *    A reference to the new mutable CFArray.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayCreateMutableCopy(allocator: CFAllocatorRef; capacity: CFIndex; theArray: CFArrayRef): CFMutableArrayRef; C;

{
 *  CFArrayGetCount()
 *  
 *  Discussion:
 *    Returns the number of values currently in the array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to be queried. If this parameter is not a valid
 *      CFArray, the behavior is undefined.
 *  
 *  Result:
 *    The number of values in the array.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayGetCount(theArray: CFArrayRef): CFIndex; C;

{
 *  CFArrayGetCountOfValue()
 *  
 *  Discussion:
 *    Counts the number of times the given value occurs in the array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to be searched. If this parameter is not a valid
 *      CFArray, the behavior is undefined.
 *    
 *    range:
 *      The range within the array to search. If the range location or
 *      end point (defined by the location plus length minus 1) are
 *      outside the index space of the array (0 to N-1 inclusive, where
 *      N is the count of the array), the behavior is undefined. If the
 *      range length is negative, the behavior is undefined. The range
 *      may be empty (length 0).
 *    
 *    value:
 *      The value for which to find matches in the array. The equal()
 *      callback provided when the array was created is used to
 *      compare. If the equal() callback was NULL, pointer equality (in
 *      C, ==) is used. If value, or any of the values in the array,
 *      are not understood by the equal() callback, the behavior is
 *      undefined.
 *  
 *  Result:
 *    The number of times the given value occurs in the array, within
 *    the specified range.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayGetCountOfValue(theArray: CFArrayRef; range: CFRange; value: UNIV Ptr): CFIndex; C;

{
 *  CFArrayContainsValue()
 *  
 *  Discussion:
 *    Reports whether or not the value is in the array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to be searched. If this parameter is not a valid
 *      CFArray, the behavior is undefined.
 *    
 *    range:
 *      The range within the array to search. If the range location or
 *      end point (defined by the location plus length minus 1) are
 *      outside the index space of the array (0 to N-1 inclusive, where
 *      N is the count of the array), the behavior is undefined. If the
 *      range length is negative, the behavior is undefined. The range
 *      may be empty (length 0).
 *    
 *    value:
 *      The value for which to find matches in the array. The equal()
 *      callback provided when the array was created is used to
 *      compare. If the equal() callback was NULL, pointer equality (in
 *      C, ==) is used. If value, or any of the values in the array,
 *      are not understood by the equal() callback, the behavior is
 *      undefined.
 *  
 *  Result:
 *    TRUE, if the value is in the specified range of the array,
 *    otherwise FALSE.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayContainsValue(theArray: CFArrayRef; range: CFRange; value: UNIV Ptr): BOOLEAN; C;

{
 *  CFArrayGetValueAtIndex()
 *  
 *  Discussion:
 *    Retrieves the value at the given index.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to be queried. If this parameter is not a valid
 *      CFArray, the behavior is undefined.
 *    
 *    idx:
 *      The index of the value to retrieve. If the index is outside the
 *      index space of the array (0 to N-1 inclusive, where N is the
 *      count of the array), the behavior is undefined.
 *  
 *  Result:
 *    The value with the given index in the array.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayGetValueAtIndex(theArray: CFArrayRef; idx: CFIndex): Ptr; C;

{
 *  CFArrayGetValues()
 *  
 *  Discussion:
 *    Fills the buffer with values from the array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to be queried. If this parameter is not a valid
 *      CFArray, the behavior is undefined.
 *    
 *    range:
 *      The range of values within the array to retrieve. If the range
 *      location or end point (defined by the location plus length
 *      minus 1) are outside the index space of the array (0 to N-1
 *      inclusive, where N is the count of the array), the behavior is
 *      undefined. If the range length is negative, the behavior is
 *      undefined. The range may be empty (length 0), in which case no
 *      values are put into the buffer.
 *    
 *    values:
 *      A C array of pointer-sized values to be filled with values from
 *      the array. The values in the C array are ordered in the same
 *      order in which they appear in the array. If this parameter is
 *      not a valid pointer to a C array of at least range.length
 *      pointers, the behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArrayGetValues(theArray: CFArrayRef; range: CFRange; VAR values: UNIV Ptr); C;

{
 *  CFArrayApplyFunction()
 *  
 *  Discussion:
 *    Calls a function once for each value in the array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to be operated upon. If this parameter is not a valid
 *      CFArray, the behavior is undefined.
 *    
 *    range:
 *      The range of values within the array to which to apply the
 *      function. If the range location or end point (defined by the
 *      location plus length minus 1) are outside the index space of
 *      the array (0 to N-1 inclusive, where N is the count of the
 *      array), the behavior is undefined. If the range length is
 *      negative, the behavior is undefined. The range may be empty
 *      (length 0).
 *    
 *    applier:
 *      The callback function to call once for each value in the given
 *      range in the array. If this parameter is not a pointer to a
 *      function of the correct prototype, the behavior is undefined.
 *      If there are values in the range which the applier function
 *      does not expect or cannot properly apply to, the behavior is
 *      undefined.
 *    
 *    context:
 *      A pointer-sized user-defined value, which is passed as the
 *      second parameter to the applier function, but is otherwise
 *      unused by this function. If the context is not what is expected
 *      by the applier function, the behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArrayApplyFunction(theArray: CFArrayRef; range: CFRange; applier: CFArrayApplierFunction; context: UNIV Ptr); C;

{
 *  CFArrayGetFirstIndexOfValue()
 *  
 *  Discussion:
 *    Searches the array for the value.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to be searched. If this parameter is not a valid
 *      CFArray, the behavior is undefined.
 *    
 *    range:
 *      The range within the array to search. If the range location or
 *      end point (defined by the location plus length minus 1) are
 *      outside the index space of the array (0 to N-1 inclusive, where
 *      N is the count of the array), the behavior is undefined. If the
 *      range length is negative, the behavior is undefined. The range
 *      may be empty (length 0). The search progresses from the
 *      smallest index defined by the range to the largest.
 *    
 *    value:
 *      The value for which to find a match in the array. The equal()
 *      callback provided when the array was created is used to
 *      compare. If the equal() callback was NULL, pointer equality (in
 *      C, ==) is used. If value, or any of the values in the array,
 *      are not understood by the equal() callback, the behavior is
 *      undefined.
 *  
 *  Result:
 *    The lowest index of the matching values in the range, or -1 if no
 *    value in the range matched.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayGetFirstIndexOfValue(theArray: CFArrayRef; range: CFRange; value: UNIV Ptr): CFIndex; C;

{
 *  CFArrayGetLastIndexOfValue()
 *  
 *  Discussion:
 *    Searches the array for the value.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to be searched. If this parameter is not a valid
 *      CFArray, the behavior is undefined.
 *    
 *    range:
 *      The range within the array to search. If the range location or
 *      end point (defined by the location plus length minus 1) are
 *      outside the index space of the array (0 to N-1 inclusive, where
 *      N is the count of the array), the behavior is undefined. If the
 *      range length is negative, the behavior is undefined. The range
 *      may be empty (length 0). The search progresses from the largest
 *      index defined by the range to the smallest.
 *    
 *    value:
 *      The value for which to find a match in the array. The equal()
 *      callback provided when the array was created is used to
 *      compare. If the equal() callback was NULL, pointer equality (in
 *      C, ==) is used. If value, or any of the values in the array,
 *      are not understood by the equal() callback, the behavior is
 *      undefined.
 *  
 *  Result:
 *    The highest index of the matching values in the range, or -1 if
 *    no value in the range matched.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayGetLastIndexOfValue(theArray: CFArrayRef; range: CFRange; value: UNIV Ptr): CFIndex; C;

{
 *  CFArrayBSearchValues()
 *  
 *  Discussion:
 *    Searches the array for the value using a binary search algorithm.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to be searched. If this parameter is not a valid
 *      CFArray, the behavior is undefined. If the array is not sorted
 *      from least to greatest according to the comparator function,
 *      the behavior is undefined.
 *    
 *    range:
 *      The range within the array to search. If the range location or
 *      end point (defined by the location plus length minus 1) are
 *      outside the index space of the array (0 to N-1 inclusive, where
 *      N is the count of the array), the behavior is undefined. If the
 *      range length is negative, the behavior is undefined. The range
 *      may be empty (length 0).
 *    
 *    value:
 *      The value for which to find a match in the array. If value, or
 *      any of the values in the array, are not understood by the
 *      comparator callback, the behavior is undefined.
 *    
 *    comparator:
 *      The function with the comparator function type signature which
 *      is used in the binary search operation to compare values in the
 *      array with the given value. If this parameter is not a pointer
 *      to a function of the correct prototype, the behavior is
 *      undefined. If there are values in the range which the
 *      comparator function does not expect or cannot properly compare,
 *      the behavior is undefined.
 *    
 *    context:
 *      A pointer-sized user-defined value, which is passed as the
 *      third parameter to the comparator function, but is otherwise
 *      unused by this function. If the context is not what is expected
 *      by the comparator function, the behavior is undefined.
 *  
 *  Result:
 *    The return value is either 1) the index of a value that matched,
 *    if the target value matches one or more in the range, 2) greater
 *    than or equal to the end point of the range, if the value is
 *    greater than all the values in the range, or 3) the index of the
 *    value greater than the target value, if the value lies between
 *    two of (or less than all of) the values in the range.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFArrayBSearchValues(theArray: CFArrayRef; range: CFRange; value: UNIV Ptr; comparator: CFComparatorFunction; context: UNIV Ptr): CFIndex; C;

{
 *  CFArrayAppendValue()
 *  
 *  Discussion:
 *    Adds the value to the array giving it the new largest index.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to which the value is to be added. If this parameter
 *      is not a valid mutable CFArray, the behavior is undefined. If
 *      the array is a fixed-capacity array and it is full before this
 *      operation, the behavior is undefined.
 *    
 *    value:
 *      The value to add to the array. The value is retained by the
 *      array using the retain callback provided when the array was
 *      created. If the value is not of the sort expected by the retain
 *      callback, the behavior is undefined. The value is assigned to
 *      the index one larger than the previous largest index, and the
 *      count of the array is increased by one.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArrayAppendValue(theArray: CFMutableArrayRef; value: UNIV Ptr); C;

{
 *  CFArrayInsertValueAtIndex()
 *  
 *  Discussion:
 *    Adds the value to the array giving it the given index.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to which the value is to be added. If this parameter
 *      is not a valid mutable CFArray, the behavior is undefined. If
 *      the array is a fixed-capacity array and it is full before this
 *      operation, the behavior is undefined.
 *    
 *    idx:
 *      The index to which to add the new value. If the index is
 *      outside the index space of the array (0 to N inclusive, where N
 *      is the count of the array before the operation), the behavior
 *      is undefined. If the index is the same as N, this function has
 *      the same effect as CFArrayAppendValue().
 *    
 *    value:
 *      The value to add to the array. The value is retained by the
 *      array using the retain callback provided when the array was
 *      created. If the value is not of the sort expected by the retain
 *      callback, the behavior is undefined. The value is assigned to
 *      the given index, and all values with equal and larger indices
 *      have their indexes increased by one.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArrayInsertValueAtIndex(theArray: CFMutableArrayRef; idx: CFIndex; value: UNIV Ptr); C;

{
 *  CFArraySetValueAtIndex()
 *  
 *  Discussion:
 *    Changes the value with the given index in the array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array in which the value is to be changed. If this
 *      parameter is not a valid mutable CFArray, the behavior is
 *      undefined. If the array is a fixed-capacity array and it is
 *      full before this operation and the index is the same as N, the
 *      behavior is undefined.
 *    
 *    idx:
 *      The index to which to set the new value. If the index is
 *      outside the index space of the array (0 to N inclusive, where N
 *      is the count of the array before the operation), the behavior
 *      is undefined. If the index is the same as N, this function has
 *      the same effect as CFArrayAppendValue().
 *    
 *    value:
 *      The value to set in the array. The value is retained by the
 *      array using the retain callback provided when the array was
 *      created, and the previous value with that index is released. If
 *      the value is not of the sort expected by the retain callback,
 *      the behavior is undefined. The indices of other values is not
 *      affected.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArraySetValueAtIndex(theArray: CFMutableArrayRef; idx: CFIndex; value: UNIV Ptr); C;

{
 *  CFArrayRemoveValueAtIndex()
 *  
 *  Discussion:
 *    Removes the value with the given index from the array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array from which the value is to be removed. If this
 *      parameter is not a valid mutable CFArray, the behavior is
 *      undefined.
 *    
 *    idx:
 *      The index from which to remove the value. If the index is
 *      outside the index space of the array (0 to N-1 inclusive, where
 *      N is the count of the array before the operation), the behavior
 *      is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArrayRemoveValueAtIndex(theArray: CFMutableArrayRef; idx: CFIndex); C;

{
 *  CFArrayRemoveAllValues()
 *  
 *  Discussion:
 *    Removes all the values from the array, making it empty.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array from which all of the values are to be removed. If
 *      this parameter is not a valid mutable CFArray, the behavior is
 *      undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArrayRemoveAllValues(theArray: CFMutableArrayRef); C;

{
 *  CFArrayReplaceValues()
 *  
 *  Discussion:
 *    Replaces a range of values in the array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array from which all of the values are to be removed. If
 *      this parameter is not a valid mutable CFArray, the behavior is
 *      undefined.
 *    
 *    range:
 *      The range of values within the array to replace. If the range
 *      location or end point (defined by the location plus length
 *      minus 1) are outside the index space of the array (0 to N
 *      inclusive, where N is the count of the array), the behavior is
 *      undefined. If the range length is negative, the behavior is
 *      undefined. The range may be empty (length 0), in which case the
 *      new values are merely inserted at the range location.
 *    
 *    newValues:
 *      A C array of the pointer-sized values to be placed into the
 *      array. The new values in the array are ordered in the same
 *      order in which they appear in this C array. This parameter may
 *      be NULL if the newCount parameter is 0. This C array is not
 *      changed or freed by this function. If this parameter is not a
 *      valid pointer to a C array of at least newCount pointers, the
 *      behavior is undefined.
 *    
 *    newCount:
 *      The number of values to copy from the values C array into the
 *      CFArray. If this parameter is different than the range length,
 *      the excess newCount values will be inserted after the range, or
 *      the excess range values will be deleted. This parameter may be
 *      0, in which case no new values are replaced into the array and
 *      the values in the range are simply removed. If this parameter
 *      is negative, or greater than the number of values actually in
 *      the newValues C array, the behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArrayReplaceValues(theArray: CFMutableArrayRef; range: CFRange; VAR newValues: UNIV Ptr; newCount: CFIndex); C;

{
 *  CFArrayExchangeValuesAtIndices()
 *  
 *  Discussion:
 *    Exchanges the values at two indices of the array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array of which the values are to be swapped. If this
 *      parameter is not a valid mutable CFArray, the behavior is
 *      undefined.
 *    
 *    idx1:
 *      The first index whose values should be swapped. If the index is
 *      outside the index space of the array (0 to N-1 inclusive, where
 *      N is the count of the array before the operation), the behavior
 *      is undefined.
 *    
 *    idx2:
 *      The second index whose values should be swapped. If the index
 *      is outside the index space of the array (0 to N-1 inclusive,
 *      where N is the count of the array before the operation), the
 *      behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArrayExchangeValuesAtIndices(theArray: CFMutableArrayRef; idx1: CFIndex; idx2: CFIndex); C;

{
 *  CFArraySortValues()
 *  
 *  Discussion:
 *    Sorts the values in the array using the given comparison function.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array whose values are to be sorted. If this parameter is
 *      not a valid mutable CFArray, the behavior is undefined.
 *    
 *    range:
 *      The range of values within the array to sort. If the range
 *      location or end point (defined by the location plus length
 *      minus 1) are outside the index space of the array (0 to N-1
 *      inclusive, where N is the count of the array), the behavior is
 *      undefined. If the range length is negative, the behavior is
 *      undefined. The range may be empty (length 0).
 *    
 *    comparator:
 *      The function with the comparator function type signature which
 *      is used in the sort operation to compare values in the array
 *      with the given value. If this parameter is not a pointer to a
 *      function of the correct prototype, the the behavior is
 *      undefined. If there are values in the array which the
 *      comparator function does not expect or cannot properly compare,
 *      the behavior is undefined. The values in the range are sorted
 *      from least to greatest according to this function.
 *    
 *    context:
 *      A pointer-sized user-defined value, which is passed as the
 *      third parameter to the comparator function, but is otherwise
 *      unused by this function. If the context is not what is expected
 *      by the comparator function, the behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArraySortValues(theArray: CFMutableArrayRef; range: CFRange; comparator: CFComparatorFunction; context: UNIV Ptr); C;

{
 *  CFArrayAppendArray()
 *  
 *  Discussion:
 *    Adds the values from an array to another array.
 *  
 *  Parameters:
 *    
 *    theArray:
 *      The array to which values from the otherArray are to be added.
 *      If this parameter is not a valid mutable CFArray, the behavior
 *      is undefined. If the array is a fixed-capacity array and adding
 *      range.length values from the otherArray exceeds the capacity of
 *      the array, the behavior is undefined.
 *    
 *    otherArray:
 *      The array providing the values to be added to the array. If
 *      this parameter is not a valid CFArray, the behavior is
 *      undefined.
 *    
 *    otherRange:
 *      The range within the otherArray from which to add the values to
 *      the array. If the range location or end point (defined by the
 *      location plus length minus 1) are outside the index space of
 *      the otherArray (0 to N-1 inclusive, where N is the count of the
 *      otherArray), the behavior is undefined. The new values are
 *      retained by the array using the retain callback provided when
 *      the array was created. If the values are not of the sort
 *      expected by the retain callback, the behavior is undefined. The
 *      values are assigned to the indices one larger than the previous
 *      largest index in the array, and beyond, and the count of the
 *      array is increased by range.length. The values are assigned new
 *      indices in the array from smallest to largest index in the
 *      order in which they appear in the otherArray.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFArrayAppendArray(theArray: CFMutableArrayRef; otherArray: CFArrayRef; otherRange: CFRange); C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFArrayIncludes}

{$ENDC} {__CFARRAY__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFBag.p
 
     Contains:   CoreFoundation bag collection
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFBag;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFBAG__}
{$SETC __CFBAG__ := 1}

{$I+}
{$SETC CFBagIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	CFBagRetainCallBack = FUNCTION(allocator: CFAllocatorRef; value: UNIV Ptr): Ptr; C;
{$ELSEC}
	CFBagRetainCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFBagReleaseCallBack = PROCEDURE(allocator: CFAllocatorRef; value: UNIV Ptr); C;
{$ELSEC}
	CFBagReleaseCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFBagCopyDescriptionCallBack = FUNCTION(value: UNIV Ptr): CFStringRef; C;
{$ELSEC}
	CFBagCopyDescriptionCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFBagEqualCallBack = FUNCTION(value1: UNIV Ptr; value2: UNIV Ptr): BOOLEAN; C;
{$ELSEC}
	CFBagEqualCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFBagHashCallBack = FUNCTION(value: UNIV Ptr): CFHashCode; C;
{$ELSEC}
	CFBagHashCallBack = ProcPtr;
{$ENDC}

	CFBagCallBacksPtr = ^CFBagCallBacks;
	CFBagCallBacks = RECORD
		version:				CFIndex;
		retain:					CFBagRetainCallBack;
		release:				CFBagReleaseCallBack;
		copyDescription:		CFBagCopyDescriptionCallBack;
		equal:					CFBagEqualCallBack;
		hash:					CFBagHashCallBack;
	END;

	{
	 *  kCFTypeBagCallBacks
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{
	 *  kCFCopyStringBagCallBacks
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
{$IFC TYPED_FUNCTION_POINTERS}
	CFBagApplierFunction = PROCEDURE(value: UNIV Ptr; context: UNIV Ptr); C;
{$ELSEC}
	CFBagApplierFunction = ProcPtr;
{$ENDC}

	CFBagRef    = ^LONGINT; { an opaque 32-bit type }
	CFBagRefPtr = ^CFBagRef;  { when a VAR xx:CFBagRef parameter can be nil, it is changed to xx: CFBagRefPtr }
	CFMutableBagRef    = CFBagRef;
	CFMutableBagRefPtr = ^CFMutableBagRef;  { when a VAR xx:CFMutableBagRef parameter can be nil, it is changed to xx: CFMutableBagRefPtr }
	{
	 *  CFBagGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFBagGetTypeID: CFTypeID; C;

{
 *  CFBagCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBagCreate(allocator: CFAllocatorRef; VAR values: UNIV Ptr; numValues: CFIndex; {CONST}VAR callBacks: CFBagCallBacks): CFBagRef; C;

{
 *  CFBagCreateCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBagCreateCopy(allocator: CFAllocatorRef; theBag: CFBagRef): CFBagRef; C;

{
 *  CFBagCreateMutable()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBagCreateMutable(allocator: CFAllocatorRef; capacity: CFIndex; {CONST}VAR callBacks: CFBagCallBacks): CFMutableBagRef; C;

{
 *  CFBagCreateMutableCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBagCreateMutableCopy(allocator: CFAllocatorRef; capacity: CFIndex; theBag: CFBagRef): CFMutableBagRef; C;

{
 *  CFBagGetCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBagGetCount(theBag: CFBagRef): CFIndex; C;

{
 *  CFBagGetCountOfValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBagGetCountOfValue(theBag: CFBagRef; value: UNIV Ptr): CFIndex; C;

{
 *  CFBagContainsValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBagContainsValue(theBag: CFBagRef; value: UNIV Ptr): BOOLEAN; C;

{
 *  CFBagGetValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBagGetValue(theBag: CFBagRef; value: UNIV Ptr): Ptr; C;

{
 *  CFBagGetValueIfPresent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBagGetValueIfPresent(theBag: CFBagRef; candidate: UNIV Ptr; VAR value: UNIV Ptr): BOOLEAN; C;

{
 *  CFBagGetValues()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBagGetValues(theBag: CFBagRef; VAR values: UNIV Ptr); C;

{
 *  CFBagApplyFunction()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBagApplyFunction(theBag: CFBagRef; applier: CFBagApplierFunction; context: UNIV Ptr); C;

{
 *  CFBagAddValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBagAddValue(theBag: CFMutableBagRef; value: UNIV Ptr); C;

{
 *  CFBagReplaceValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBagReplaceValue(theBag: CFMutableBagRef; value: UNIV Ptr); C;

{
 *  CFBagSetValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBagSetValue(theBag: CFMutableBagRef; value: UNIV Ptr); C;

{
 *  CFBagRemoveValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBagRemoveValue(theBag: CFMutableBagRef; value: UNIV Ptr); C;

{
 *  CFBagRemoveAllValues()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBagRemoveAllValues(theBag: CFMutableBagRef); C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFBagIncludes}

{$ENDC} {__CFBAG__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFBase.p
 
     Contains:   CoreFoundation base types
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFBase;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFBASE__}
{$SETC __CFBASE__ := 1}

{$I+}
{$SETC CFBaseIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __MACTYPES__}
{$I MacTypes.p}
{$ENDC}



{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
	CFTypeID							= UInt32;
	CFOptionFlags						= UInt32;
	CFHashCode							= UInt32;
	CFIndex								= SInt32;
	CFStringRef    = ^LONGINT; { an opaque 32-bit type }
	CFStringRefPtr = ^CFStringRef;  { when a VAR xx:CFStringRef parameter can be nil, it is changed to xx: CFStringRefPtr }
	CFMutableStringRef    = CFStringRef;
	CFMutableStringRefPtr = ^CFMutableStringRef;  { when a VAR xx:CFMutableStringRef parameter can be nil, it is changed to xx: CFMutableStringRefPtr }
	{	 Values returned from comparison functions 	}
	CFComparisonResult 			= SInt32;
CONST
	kCFCompareLessThan			= -1;
	kCFCompareEqualTo			= 0;
	kCFCompareGreaterThan		= 1;

	{	 A standard comparison function 	}

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	CFComparatorFunction = FUNCTION(val1: UNIV Ptr; val2: UNIV Ptr; context: UNIV Ptr): CFComparisonResult; C;
{$ELSEC}
	CFComparatorFunction = ProcPtr;
{$ENDC}

	{	 Constant used by some functions to indicate failed searches. 	}
	{	 This is of type CFIndex. 	}
	CFNotFound 					= SInt32;
CONST
	kCFNotFound					= -1;

	{	 Range type 	}

TYPE
	CFRangePtr = ^CFRange;
	CFRange = RECORD
		location:				CFIndex;
		length:					CFIndex;
	END;

	{	 Allocator API
	
	   Most of the time when specifying an allocator to Create functions, the NULL
	   argument indicates "use the default"; this is the same as using kCFAllocatorDefault
	   or the return value from CFAllocatorGetDefault().  This assures that you will use
	   the allocator in effect at that time.
	
	   You should rarely use kCFAllocatorSystemDefault, the default default allocator.
		}
	CFAllocatorRef    = ^LONGINT; { an opaque 32-bit type }
	CFAllocatorRefPtr = ^CFAllocatorRef;  { when a VAR xx:CFAllocatorRef parameter can be nil, it is changed to xx: CFAllocatorRefPtr }
	{	 This is a synonym for NULL, if you'd rather use a named constant. 	}
	{
	 *  kCFAllocatorDefault
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 Default system allocator; you rarely need to use this. 	}
	{
	 *  kCFAllocatorSystemDefault
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 This allocator uses malloc(), realloc(), and free(). This should not be
	   generally used; stick to kCFAllocatorDefault whenever possible. This
	   allocator is useful as the "bytesDeallocator" in CFData or
	   "contentsDeallocator" in CFString where the memory was obtained as a
	   result of malloc() type functions.
		}
	{
	 *  kCFAllocatorMalloc
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.1 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 Null allocator which does nothing and allocates no memory. This allocator
	   is useful as the "bytesDeallocator" in CFData or "contentsDeallocator"
	   in CFString where the memory should not be freed.
		}
	{
	 *  kCFAllocatorNull
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 Special allocator argument to CFAllocatorCreate() which means
	   "use the functions given in the context to allocate the allocator
	   itself as well".
		}
	{
	 *  kCFAllocatorUseContext
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
{$IFC TYPED_FUNCTION_POINTERS}
	CFAllocatorRetainCallBack = FUNCTION(info: UNIV Ptr): Ptr; C;
{$ELSEC}
	CFAllocatorRetainCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFAllocatorReleaseCallBack = PROCEDURE(info: UNIV Ptr); C;
{$ELSEC}
	CFAllocatorReleaseCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFAllocatorCopyDescriptionCallBack = FUNCTION(info: UNIV Ptr): CFStringRef; C;
{$ELSEC}
	CFAllocatorCopyDescriptionCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFAllocatorAllocateCallBack = FUNCTION(allocSize: CFIndex; hint: CFOptionFlags; info: UNIV Ptr): Ptr; C;
{$ELSEC}
	CFAllocatorAllocateCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFAllocatorReallocateCallBack = FUNCTION(ptr: UNIV Ptr; newsize: CFIndex; hint: CFOptionFlags; info: UNIV Ptr): Ptr; C;
{$ELSEC}
	CFAllocatorReallocateCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFAllocatorDeallocateCallBack = PROCEDURE(ptr: UNIV Ptr; info: UNIV Ptr); C;
{$ELSEC}
	CFAllocatorDeallocateCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFAllocatorPreferredSizeCallBack = FUNCTION(size: CFIndex; hint: CFOptionFlags; info: UNIV Ptr): CFIndex; C;
{$ELSEC}
	CFAllocatorPreferredSizeCallBack = ProcPtr;
{$ENDC}

	CFAllocatorContextPtr = ^CFAllocatorContext;
	CFAllocatorContext = RECORD
		version:				CFIndex;
		info:					Ptr;
		retain:					CFAllocatorRetainCallBack;
		release:				CFAllocatorReleaseCallBack;
		copyDescription:		CFAllocatorCopyDescriptionCallBack;
		allocate:				CFAllocatorAllocateCallBack;
		reallocate:				CFAllocatorReallocateCallBack;
		deallocate:				CFAllocatorDeallocateCallBack;
		preferredSize:			CFAllocatorPreferredSizeCallBack;
	END;

	{
	 *  CFAllocatorGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFAllocatorGetTypeID: CFTypeID; C;

{
    CFAllocatorSetDefault() sets the allocator that is used in the current
    thread whenever NULL is specified as an allocator argument. This means
    that most, if not all allocations will go through this allocator. It
    also means that any allocator set as the default needs to be ready to
    deal with arbitrary memory allocation requests; in addition, the size
    and number of requests will change between releases.

    An allocator set as the default will never be released, even if later
    another allocator replaces it as the default. Not only is it impractical
    for it to be released (as there might be caches created under the covers
    that refer to the allocator), in general it's also safer and more
    efficient to keep it around.

    If you wish to use a custom allocator in a context, it's best to provide
    it as the argument to the various creation functions rather than setting
    it as the default. Setting the default allocator is not encouraged.

    If you do set an allocator as the default, either do it for all time in
    your app, or do it in a nested fashion (by restoring the previous allocator
    when you exit your context). The latter might be appropriate for plug-ins
    or libraries that wish to set the default allocator.
}
{
 *  CFAllocatorSetDefault()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFAllocatorSetDefault(allocator: CFAllocatorRef); C;

{
 *  CFAllocatorGetDefault()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAllocatorGetDefault: CFAllocatorRef; C;

{
 *  CFAllocatorCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAllocatorCreate(allocator: CFAllocatorRef; VAR context: CFAllocatorContext): CFAllocatorRef; C;

{
 *  CFAllocatorAllocate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAllocatorAllocate(allocator: CFAllocatorRef; size: CFIndex; hint: CFOptionFlags): Ptr; C;

{
 *  CFAllocatorReallocate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAllocatorReallocate(allocator: CFAllocatorRef; ptr: UNIV Ptr; newsize: CFIndex; hint: CFOptionFlags): Ptr; C;

{
 *  CFAllocatorDeallocate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFAllocatorDeallocate(allocator: CFAllocatorRef; ptr: UNIV Ptr); C;

{
 *  CFAllocatorGetPreferredSizeForSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAllocatorGetPreferredSizeForSize(allocator: CFAllocatorRef; size: CFIndex; hint: CFOptionFlags): CFIndex; C;

{
 *  CFAllocatorGetContext()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFAllocatorGetContext(allocator: CFAllocatorRef; VAR context: CFAllocatorContext); C;

{ Base "type" of all "CF objects", and polymorphic functions on them }

TYPE
	CFTypeRef							= Ptr;
	{
	 *  CFGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFGetTypeID(cf: CFTypeRef): CFTypeID; C;

{
 *  CFCopyTypeIDDescription()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCopyTypeIDDescription(type_id: CFTypeID): CFStringRef; C;

{
 *  CFRetain()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFRetain(cf: CFTypeRef): CFTypeRef; C;

{
 *  CFRelease()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFRelease(cf: CFTypeRef); C;

{
 *  CFGetRetainCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFGetRetainCount(cf: CFTypeRef): CFIndex; C;

{
 *  CFEqual()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFEqual(cf1: CFTypeRef; cf2: CFTypeRef): BOOLEAN; C;

{
 *  CFHash()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFHash(cf: CFTypeRef): CFHashCode; C;

{
 *  CFCopyDescription()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCopyDescription(cf: CFTypeRef): CFStringRef; C;

{
 *  CFGetAllocator()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFGetAllocator(cf: CFTypeRef): CFAllocatorRef; C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFBaseIncludes}

{$ENDC} {__CFBASE__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFBundle.p
 
     Contains:   CoreFoundation bundle
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFBundle;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFBUNDLE__}
{$SETC __CFBUNDLE__ := 1}

{$I+}
{$SETC CFBundleIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}
{$IFC UNDEFINED __CFARRAY__}
{$I CFArray.p}
{$ENDC}
{$IFC UNDEFINED __CFDICTIONARY__}
{$I CFDictionary.p}
{$ENDC}
{$IFC UNDEFINED __CFSTRING__}
{$I CFString.p}
{$ENDC}
{$IFC UNDEFINED __CFURL__}
{$I CFURL.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
	CFBundleRef    = ^LONGINT; { an opaque 32-bit type }
	CFBundleRefPtr = ^CFBundleRef;  { when a VAR xx:CFBundleRef parameter can be nil, it is changed to xx: CFBundleRefPtr }
	CFPlugInRef    = CFBundleRef;
	CFPlugInRefPtr = ^CFPlugInRef;  { when a VAR xx:CFPlugInRef parameter can be nil, it is changed to xx: CFPlugInRefPtr }
	{	 ===================== Standard Info.plist keys ===================== 	}
	{
	 *  kCFBundleInfoDictionaryVersionKey
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 The version of the Info.plist format 	}
	{
	 *  kCFBundleExecutableKey
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 The name of the executable in this bundle (if any) 	}
	{
	 *  kCFBundleIdentifierKey
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 The bundle identifier (for CFBundleGetBundleWithIdentifier()) 	}
	{
	 *  kCFBundleVersionKey
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 The version number of the bundle.  Clients should use CFBundleGetVersionNumber() instead of accessing this key directly
	    since that function will properly convert a version number in string format into its interger representation. 	}
	{
	 *  kCFBundleDevelopmentRegionKey
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 The name of the development language of the bundle. 	}
	{
	 *  kCFBundleNameKey
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{	 The human-readable name of the bundle.  This key is often found in the InfoPlist.strings since it is usually localized. 	}
	{	 ===================== Finding Bundles ===================== 	}
	{
	 *  CFBundleGetMainBundle()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFBundleGetMainBundle: CFBundleRef; C;

{
 *  CFBundleGetBundleWithIdentifier()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetBundleWithIdentifier(bundleID: CFStringRef): CFBundleRef; C;

{ A bundle can name itself by providing a key in the info dictionary. }
{ This facility is meant to allow bundle-writers to get hold of their }
{ bundle from their code without having to know where it was on the disk. }
{ This is meant to be a replacement mechanism for +bundleForClass: users. }
{
 *  CFBundleGetAllBundles()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetAllBundles: CFArrayRef; C;

{ This is potentially expensive.  Use with care. }
{ ===================== Creating Bundles ===================== }
{
 *  CFBundleGetTypeID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetTypeID: UInt32; C;

{
 *  CFBundleCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCreate(allocator: CFAllocatorRef; bundleURL: CFURLRef): CFBundleRef; C;

{ Might return an existing instance with the ref-count bumped. }
{
 *  CFBundleCreateBundlesFromDirectory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCreateBundlesFromDirectory(allocator: CFAllocatorRef; directoryURL: CFURLRef; bundleType: CFStringRef): CFArrayRef; C;

{ Create instances for all bundles in the given directory matching the given }
{ type (or all of them if bundleType is NULL) }
{ ==================== Basic Bundle Info ==================== }
{
 *  CFBundleCopyBundleURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyBundleURL(bundle: CFBundleRef): CFURLRef; C;

{
 *  CFBundleGetValueForInfoDictionaryKey()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetValueForInfoDictionaryKey(bundle: CFBundleRef; key: CFStringRef): CFTypeRef; C;

{ Returns a localized value if available, otherwise the global value. }
{
 *  CFBundleGetInfoDictionary()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetInfoDictionary(bundle: CFBundleRef): CFDictionaryRef; C;

{ This is the global info dictionary.  Note that CFBundle may add }
{ extra keys to the dictionary for its own use. }
{
 *  CFBundleGetLocalInfoDictionary()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetLocalInfoDictionary(bundle: CFBundleRef): CFDictionaryRef; C;

{ This is the localized info dictionary. }
{
 *  CFBundleGetPackageInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBundleGetPackageInfo(bundle: CFBundleRef; VAR packageType: UInt32; VAR packageCreator: UInt32); C;

{
 *  CFBundleGetIdentifier()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetIdentifier(bundle: CFBundleRef): CFStringRef; C;

{
 *  CFBundleGetVersionNumber()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetVersionNumber(bundle: CFBundleRef): UInt32; C;

{
 *  CFBundleGetDevelopmentRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetDevelopmentRegion(bundle: CFBundleRef): CFStringRef; C;

{
 *  CFBundleCopySupportFilesDirectoryURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopySupportFilesDirectoryURL(bundle: CFBundleRef): CFURLRef; C;

{
 *  CFBundleCopyResourcesDirectoryURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyResourcesDirectoryURL(bundle: CFBundleRef): CFURLRef; C;

{
 *  CFBundleCopyPrivateFrameworksURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyPrivateFrameworksURL(bundle: CFBundleRef): CFURLRef; C;

{
 *  CFBundleCopySharedFrameworksURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopySharedFrameworksURL(bundle: CFBundleRef): CFURLRef; C;

{
 *  CFBundleCopySharedSupportURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopySharedSupportURL(bundle: CFBundleRef): CFURLRef; C;

{
 *  CFBundleCopyBuiltInPlugInsURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyBuiltInPlugInsURL(bundle: CFBundleRef): CFURLRef; C;

{ ------------- Basic Bundle Info without a CFBundle instance ------------- }
{ This API is provided to enable developers to retrieve basic information }
{ about a bundle without having to create an instance of CFBundle. }
{
 *  CFBundleCopyInfoDictionaryInDirectory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyInfoDictionaryInDirectory(bundleURL: CFURLRef): CFDictionaryRef; C;

{
 *  CFBundleGetPackageInfoInDirectory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetPackageInfoInDirectory(url: CFURLRef; VAR packageType: UInt32; VAR packageCreator: UInt32): BOOLEAN; C;

{ ==================== Resource Handling API ==================== }
{
 *  CFBundleCopyResourceURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyResourceURL(bundle: CFBundleRef; resourceName: CFStringRef; resourceType: CFStringRef; subDirName: CFStringRef): CFURLRef; C;

{
 *  CFBundleCopyResourceURLsOfType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyResourceURLsOfType(bundle: CFBundleRef; resourceType: CFStringRef; subDirName: CFStringRef): CFArrayRef; C;

{
 *  CFBundleCopyLocalizedString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyLocalizedString(bundle: CFBundleRef; key: CFStringRef; value: CFStringRef; tableName: CFStringRef): CFStringRef; C;

{ ------------- Resource Handling without a CFBundle instance ------------- }
{ This API is provided to enable developers to use the CFBundle resource }
{ searching policy without having to create an instance of CFBundle. }
{ Because of caching behavior when a CFBundle instance exists, it will be faster }
{ to actually create a CFBundle if you need to access several resources. }
{
 *  CFBundleCopyResourceURLInDirectory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyResourceURLInDirectory(bundleURL: CFURLRef; resourceName: CFStringRef; resourceType: CFStringRef; subDirName: CFStringRef): CFURLRef; C;

{
 *  CFBundleCopyResourceURLsOfTypeInDirectory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyResourceURLsOfTypeInDirectory(bundleURL: CFURLRef; resourceType: CFStringRef; subDirName: CFStringRef): CFArrayRef; C;

{ =========== Localization-specific Resource Handling API =========== }
{ This API allows finer-grained control over specific localizations,  }
{ as distinguished from the above API, which always uses the user's   }
{ preferred localizations.  }
{
 *  CFBundleCopyBundleLocalizations()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyBundleLocalizations(bundle: CFBundleRef): CFArrayRef; C;

{ Lists the localizations that a bundle contains.  }
{
 *  CFBundleCopyPreferredLocalizationsFromArray()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyPreferredLocalizationsFromArray(locArray: CFArrayRef): CFArrayRef; C;

{ Given an array of possible localizations, returns the one or more }
{ that CFBundle would use in the current context. To find out which }
{ localizations are in use for a particular bundle, apply this to   }
{ the result of CFBundleCopyBundleLocalizations.  }
{
 *  CFBundleCopyResourceURLForLocalization()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyResourceURLForLocalization(bundle: CFBundleRef; resourceName: CFStringRef; resourceType: CFStringRef; subDirName: CFStringRef; localizationName: CFStringRef): CFURLRef; C;

{
 *  CFBundleCopyResourceURLsOfTypeForLocalization()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyResourceURLsOfTypeForLocalization(bundle: CFBundleRef; resourceType: CFStringRef; subDirName: CFStringRef; localizationName: CFStringRef): CFArrayRef; C;

{ ==================== Primitive Code Loading API ==================== }
{ This API abstracts the various different executable formats supported on }
{ various platforms.  It can load DYLD, CFM, or DLL shared libraries (on their }
{ appropriate platforms) and gives a uniform API for looking up functions. }
{ Note that Cocoa-based bundles containing Objective-C or Java code must }
{ be loaded with NSBundle, not CFBundle.  Once they are loaded, however, }
{ either CFBundle or NSBundle can be used. }
{
 *  CFBundleCopyExecutableURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyExecutableURL(bundle: CFBundleRef): CFURLRef; C;

{
 *  CFBundleIsExecutableLoaded()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleIsExecutableLoaded(bundle: CFBundleRef): BOOLEAN; C;

{
 *  CFBundleLoadExecutable()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleLoadExecutable(bundle: CFBundleRef): BOOLEAN; C;

{
 *  CFBundleUnloadExecutable()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBundleUnloadExecutable(bundle: CFBundleRef); C;

{
 *  CFBundleGetFunctionPointerForName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetFunctionPointerForName(bundle: CFBundleRef; functionName: CFStringRef): Ptr; C;

{
 *  CFBundleGetFunctionPointersForNames()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBundleGetFunctionPointersForNames(bundle: CFBundleRef; functionNames: CFArrayRef; VAR ftbl: UNIV Ptr); C;

{
 *  CFBundleGetDataPointerForName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetDataPointerForName(bundle: CFBundleRef; symbolName: CFStringRef): Ptr; C;

{
 *  CFBundleGetDataPointersForNames()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.3 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBundleGetDataPointersForNames(bundle: CFBundleRef; symbolNames: CFArrayRef; VAR stbl: UNIV Ptr); C;

{
 *  CFBundleCopyAuxiliaryExecutableURL()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleCopyAuxiliaryExecutableURL(bundle: CFBundleRef; executableName: CFStringRef): CFURLRef; C;

{ This function can be used to find executables other than your main }
{ executable.  This is useful, for instance, for applications that have }
{ some command line tool that is packaged with and used by the application. }
{ The tool can be packaged in the various platform executable directories }
{ in the bundle and can be located with this function.  This allows an }
{ app to ship versions of the tool for each platform as it does for the }
{ main app executable. }
{ ==================== Getting a bundle's plugIn ==================== }
{
 *  CFBundleGetPlugIn()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleGetPlugIn(bundle: CFBundleRef): CFPlugInRef; C;

{ ==================== Resource Manager-Related API ==================== }
{
 *  CFBundleOpenBundleResourceMap()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleOpenBundleResourceMap(bundle: CFBundleRef): INTEGER; C;

{ This function opens the non-localized and the localized resource files }
{ (if any) for the bundle, creates and makes current a single read-only }
{ resource map combining both, and returns a reference number for it. }
{ If it is called multiple times, it opens the files multiple times, }
{ and returns distinct reference numbers.  }
{
 *  CFBundleOpenBundleResourceFiles()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBundleOpenBundleResourceFiles(bundle: CFBundleRef; VAR refNum: INTEGER; VAR localizedRefNum: INTEGER): SInt32; C;

{ Similar to CFBundleOpenBundleResourceMap, except that it creates two }
{ separate resource maps and returns reference numbers for both. }
{
 *  CFBundleCloseBundleResourceMap()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFBundleCloseBundleResourceMap(bundle: CFBundleRef; refNum: INTEGER); C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFBundleIncludes}

{$ENDC} {__CFBUNDLE__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFCharacterSet.p
 
     Contains:   CoreFoundation character sets
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFCharacterSet;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFCHARACTERSET__}
{$SETC __CFCHARACTERSET__ := 1}

{$I+}
{$SETC CFCharacterSetIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}
{$IFC UNDEFINED __CFDATA__}
{$I CFData.p}
{$ENDC}
{$IFC UNDEFINED __CFSTRING__}
{$I CFString.p}
{$ENDC}



{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
	CFCharacterSetRef    = ^LONGINT; { an opaque 32-bit type }
	CFCharacterSetRefPtr = ^CFCharacterSetRef;  { when a VAR xx:CFCharacterSetRef parameter can be nil, it is changed to xx: CFCharacterSetRefPtr }
	CFMutableCharacterSetRef    = CFCharacterSetRef;
	CFMutableCharacterSetRefPtr = ^CFMutableCharacterSetRef;  { when a VAR xx:CFMutableCharacterSetRef parameter can be nil, it is changed to xx: CFMutableCharacterSetRefPtr }
	CFCharacterSetPredefinedSet  = SInt32;
CONST
	kCFCharacterSetControl		= 1;
	kCFCharacterSetWhitespace	= 2;
	kCFCharacterSetWhitespaceAndNewline = 3;
	kCFCharacterSetDecimalDigit	= 4;
	kCFCharacterSetLetter		= 5;
	kCFCharacterSetLowercaseLetter = 6;
	kCFCharacterSetUppercaseLetter = 7;
	kCFCharacterSetNonBase		= 8;
	kCFCharacterSetDecomposable	= 9;
	kCFCharacterSetAlphaNumeric	= 10;
	kCFCharacterSetPunctuation	= 11;
	kCFCharacterSetIllegal		= 12;

	{
	 *  CFCharacterSetGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFCharacterSetGetTypeID: CFTypeID; C;

{
 *  CFCharacterSetGetPredefined()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCharacterSetGetPredefined(theSetIdentifier: CFCharacterSetPredefinedSet): CFCharacterSetRef; C;

{
 *  CFCharacterSetCreateWithCharactersInRange()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCharacterSetCreateWithCharactersInRange(alloc: CFAllocatorRef; theRange: CFRange): CFCharacterSetRef; C;

{
 *  CFCharacterSetCreateWithCharactersInString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCharacterSetCreateWithCharactersInString(alloc: CFAllocatorRef; theString: CFStringRef): CFCharacterSetRef; C;

{
 *  CFCharacterSetCreateWithBitmapRepresentation()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCharacterSetCreateWithBitmapRepresentation(alloc: CFAllocatorRef; theData: CFDataRef): CFCharacterSetRef; C;

{
 *  CFCharacterSetCreateMutable()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCharacterSetCreateMutable(alloc: CFAllocatorRef): CFMutableCharacterSetRef; C;

{
 *  CFCharacterSetCreateMutableCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCharacterSetCreateMutableCopy(alloc: CFAllocatorRef; theSet: CFCharacterSetRef): CFMutableCharacterSetRef; C;

{
 *  CFCharacterSetIsCharacterMember()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCharacterSetIsCharacterMember(theSet: CFCharacterSetRef; theChar: UniChar): BOOLEAN; C;

{
 *  CFCharacterSetCreateBitmapRepresentation()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFCharacterSetCreateBitmapRepresentation(alloc: CFAllocatorRef; theSet: CFCharacterSetRef): CFDataRef; C;

{
 *  CFCharacterSetAddCharactersInRange()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFCharacterSetAddCharactersInRange(theSet: CFMutableCharacterSetRef; theRange: CFRange); C;

{
 *  CFCharacterSetRemoveCharactersInRange()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFCharacterSetRemoveCharactersInRange(theSet: CFMutableCharacterSetRef; theRange: CFRange); C;

{
 *  CFCharacterSetAddCharactersInString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFCharacterSetAddCharactersInString(theSet: CFMutableCharacterSetRef; theString: CFStringRef); C;

{
 *  CFCharacterSetRemoveCharactersInString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFCharacterSetRemoveCharactersInString(theSet: CFMutableCharacterSetRef; theString: CFStringRef); C;

{
 *  CFCharacterSetUnion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFCharacterSetUnion(theSet: CFMutableCharacterSetRef; theOtherSet: CFCharacterSetRef); C;

{
 *  CFCharacterSetIntersect()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFCharacterSetIntersect(theSet: CFMutableCharacterSetRef; theOtherSet: CFCharacterSetRef); C;

{
 *  CFCharacterSetInvert()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFCharacterSetInvert(theSet: CFMutableCharacterSetRef); C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFCharacterSetIncludes}

{$ENDC} {__CFCHARACTERSET__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFData.p
 
     Contains:   CoreFoundation block of bytes
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFData;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFDATA__}
{$SETC __CFDATA__ := 1}

{$I+}
{$SETC CFDataIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
	CFDataRef    = ^LONGINT; { an opaque 32-bit type }
	CFDataRefPtr = ^CFDataRef;  { when a VAR xx:CFDataRef parameter can be nil, it is changed to xx: CFDataRefPtr }
	CFMutableDataRef    = CFDataRef;
	CFMutableDataRefPtr = ^CFMutableDataRef;  { when a VAR xx:CFMutableDataRef parameter can be nil, it is changed to xx: CFMutableDataRefPtr }
	{
	 *  CFDataGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFDataGetTypeID: CFTypeID; C;

{
 *  CFDataCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDataCreate(allocator: CFAllocatorRef; {CONST}VAR bytes: UInt8; length: CFIndex): CFDataRef; C;

{
 *  CFDataCreateWithBytesNoCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDataCreateWithBytesNoCopy(allocator: CFAllocatorRef; {CONST}VAR bytes: UInt8; length: CFIndex; bytesDeallocator: CFAllocatorRef): CFDataRef; C;

{ Pass kCFAllocatorNull as bytesDeallocator to assure the bytes aren't freed }
{
 *  CFDataCreateCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDataCreateCopy(allocator: CFAllocatorRef; theData: CFDataRef): CFDataRef; C;

{
 *  CFDataCreateMutable()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDataCreateMutable(allocator: CFAllocatorRef; capacity: CFIndex): CFMutableDataRef; C;

{
 *  CFDataCreateMutableCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDataCreateMutableCopy(allocator: CFAllocatorRef; capacity: CFIndex; theData: CFDataRef): CFMutableDataRef; C;

{
 *  CFDataGetLength()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDataGetLength(theData: CFDataRef): CFIndex; C;

{
 *  CFDataGetBytePtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDataGetBytePtr(theData: CFDataRef): Ptr; C;

{
 *  CFDataGetMutableBytePtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDataGetMutableBytePtr(theData: CFMutableDataRef): Ptr; C;

{
 *  CFDataGetBytes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDataGetBytes(theData: CFDataRef; range: CFRange; VAR buffer: UInt8); C;

{
 *  CFDataSetLength()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDataSetLength(theData: CFMutableDataRef; length: CFIndex); C;

{
 *  CFDataIncreaseLength()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDataIncreaseLength(theData: CFMutableDataRef; extraLength: CFIndex); C;

{
 *  CFDataAppendBytes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDataAppendBytes(theData: CFMutableDataRef; {CONST}VAR bytes: UInt8; length: CFIndex); C;

{
 *  CFDataReplaceBytes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDataReplaceBytes(theData: CFMutableDataRef; range: CFRange; {CONST}VAR newBytes: UInt8; newLength: CFIndex); C;

{
 *  CFDataDeleteBytes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDataDeleteBytes(theData: CFMutableDataRef; range: CFRange); C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFDataIncludes}

{$ENDC} {__CFDATA__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFDate.p
 
     Contains:   CoreFoundation date
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFDate;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFDATE__}
{$SETC __CFDATE__ := 1}

{$I+}
{$SETC CFDateIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}



{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
	CFTimeInterval						= Double;
	CFAbsoluteTime						= CFTimeInterval;
	{	 absolute time is the time interval since the reference date 	}
	{	 the reference date (epoch) is 00:00:00 1 January 2001. 	}
	{
	 *  CFAbsoluteTimeGetCurrent()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFAbsoluteTimeGetCurrent: CFAbsoluteTime; C;

{
 *  kCFAbsoluteTimeIntervalSince1970
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFAbsoluteTimeIntervalSince1904
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }

TYPE
	CFDateRef    = ^LONGINT; { an opaque 32-bit type }
	CFDateRefPtr = ^CFDateRef;  { when a VAR xx:CFDateRef parameter can be nil, it is changed to xx: CFDateRefPtr }
	{
	 *  CFDateGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFDateGetTypeID: CFTypeID; C;

{
 *  CFDateCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDateCreate(allocator: CFAllocatorRef; at: CFAbsoluteTime): CFDateRef; C;

{
 *  CFDateGetAbsoluteTime()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDateGetAbsoluteTime(theDate: CFDateRef): CFAbsoluteTime; C;

{
 *  CFDateGetTimeIntervalSinceDate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDateGetTimeIntervalSinceDate(theDate: CFDateRef; otherDate: CFDateRef): CFTimeInterval; C;

{
 *  CFDateCompare()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDateCompare(theDate: CFDateRef; otherDate: CFDateRef; context: UNIV Ptr): CFComparisonResult; C;


TYPE
	CFTimeZoneRef    = ^LONGINT; { an opaque 32-bit type }
	CFTimeZoneRefPtr = ^CFTimeZoneRef;  { when a VAR xx:CFTimeZoneRef parameter can be nil, it is changed to xx: CFTimeZoneRefPtr }
	CFGregorianDatePtr = ^CFGregorianDate;
	CFGregorianDate = RECORD
		year:					SInt32;
		month:					SInt8;
		day:					SInt8;
		hour:					SInt8;
		minute:					SInt8;
		second:					Double;
	END;

	CFGregorianUnitsPtr = ^CFGregorianUnits;
	CFGregorianUnits = RECORD
		years:					SInt32;
		months:					SInt32;
		days:					SInt32;
		hours:					SInt32;
		minutes:				SInt32;
		seconds:				Double;
	END;

	CFGregorianUnitFlags 		= SInt32;
CONST
	kCFGregorianUnitsYears		= $01;
	kCFGregorianUnitsMonths		= $02;
	kCFGregorianUnitsDays		= $04;
	kCFGregorianUnitsHours		= $08;
	kCFGregorianUnitsMinutes	= $10;
	kCFGregorianUnitsSeconds	= $20;
	kCFGregorianAllUnits		= $00FFFFFF;

	{
	 *  CFGregorianDateIsValid()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFGregorianDateIsValid(gdate: CFGregorianDate; unitFlags: CFOptionFlags): BOOLEAN; C;

{
 *  CFGregorianDateGetAbsoluteTime()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFGregorianDateGetAbsoluteTime(gdate: CFGregorianDate; tz: CFTimeZoneRef): CFAbsoluteTime; C;

{
 *  CFAbsoluteTimeGetGregorianDate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAbsoluteTimeGetGregorianDate(at: CFAbsoluteTime; tz: CFTimeZoneRef): CFGregorianDate; C;

{
 *  CFAbsoluteTimeAddGregorianUnits()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAbsoluteTimeAddGregorianUnits(at: CFAbsoluteTime; tz: CFTimeZoneRef; units: CFGregorianUnits): CFAbsoluteTime; C;

{
 *  CFAbsoluteTimeGetDifferenceAsGregorianUnits()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAbsoluteTimeGetDifferenceAsGregorianUnits(at1: CFAbsoluteTime; at2: CFAbsoluteTime; tz: CFTimeZoneRef; unitFlags: CFOptionFlags): CFGregorianUnits; C;

{
 *  CFAbsoluteTimeGetDayOfWeek()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAbsoluteTimeGetDayOfWeek(at: CFAbsoluteTime; tz: CFTimeZoneRef): SInt32; C;

{
 *  CFAbsoluteTimeGetDayOfYear()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAbsoluteTimeGetDayOfYear(at: CFAbsoluteTime; tz: CFTimeZoneRef): SInt32; C;

{
 *  CFAbsoluteTimeGetWeekOfYear()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFAbsoluteTimeGetWeekOfYear(at: CFAbsoluteTime; tz: CFTimeZoneRef): SInt32; C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFDateIncludes}

{$ENDC} {__CFDATE__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFDictionary.p
 
     Contains:   CoreFoundation dictionary collection
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFDictionary;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFDICTIONARY__}
{$SETC __CFDICTIONARY__ := 1}

{$I+}
{$SETC CFDictionaryIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


{
 *  CFDictionary
 *  
 *  Discussion:
 *    CFDictionary implements a container which pairs pointer-sized
 *    keys with pointer-sized values. Values are accessed via arbitrary
 *    user-defined keys. A CFDictionary differs from a CFArray in that
 *    the key used to access a particular value in the dictionary
 *    remains the same as values are added to or removed from the
 *    dictionary, unless a value associated with its particular key is
 *    replaced or removed. In a CFArray, the key (or index) used to
 *    retrieve a particular value can change over time as values are
 *    added to or deleted from the array. Also unlike an array, there
 *    is no ordering among values in a dictionary. To enable later
 *    retrieval of a value, the key of the key-value pair should be
 *    constant (or treated as constant); if the key changes after being
 *    used to put a value in the dictionary, the value may not be
 *    retrievable. The keys of a dictionary form a set; that is, no two
 *    keys which are equal to one another are present in the dictionary
 *    at any time. 
 *    
 *    Dictionaries come in two flavors, immutable, which cannot have
 *    values added to them or removed from them after the dictionary is
 *    created, and mutable, to which you can add values or from which
 *    remove values. Mutable dictionaries have two subflavors,
 *    fixed-capacity, for which there is a maximum number set at
 *    creation time of values which can be put into the dictionary, and
 *    variable capacity, which can have an unlimited number of values
 *    (or rather, limited only by constraints external to CFDictionary,
 *    like the amount of available memory). Fixed-capacity dictionaries
 *    can be somewhat higher performing, if you can put a definate
 *    upper limit on the number of values that might be put into the
 *    dictionary. 
 *    
 *    As with all CoreFoundation collection types, dictionaries
 *    maintain hard references on the values you put in them, but the
 *    retaining and releasing functions are user-defined callbacks that
 *    can actually do whatever the user wants (for example, nothing).
 *    
 *    
 *    Although a particular implementation of CFDictionary may not use
 *    hashing and a hash table for storage of the values, the keys have
 *    a hash-code generating function defined for them, and a function
 *    to test for equality of two keys. These two functions together
 *    must maintain the invariant that if equal(X, Y), then hash(X) ==
 *    hash(Y). Note that the converse will not generally be true (but
 *    the contrapositive, if hash(X) != hash(Y), then !equal(X, Y),
 *    will be as required by Boolean logic). If the hash() and equal()
 *    key callbacks are NULL, the key is used as a pointer-sized
 *    integer, and pointer equality is used. Care should be taken to
 *    provide a hash() callback which will compute sufficiently
 *    dispersed hash codes for the key set for best performance.
 *    
 *    
 *    Computational Complexity The access time for a value in the
 *    dictionary is guaranteed to be at worst O(lg N) for any
 *    implementation, current and future, but will often be O(1)
 *    (constant time). Insertion or deletion operations will typically
 *    be constant time as well, but are O(N*lg N) in the worst case in
 *    some implementations. Access of values through a key is faster
 *    than accessing values directly (if there are any such
 *    operations). Dictionaries will tend to use significantly more
 *    memory than a array with the same number of values.
 }

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	CFDictionaryRetainCallBack = FUNCTION(allocator: CFAllocatorRef; value: UNIV Ptr): Ptr; C;
{$ELSEC}
	CFDictionaryRetainCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFDictionaryReleaseCallBack = PROCEDURE(allocator: CFAllocatorRef; value: UNIV Ptr); C;
{$ELSEC}
	CFDictionaryReleaseCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFDictionaryCopyDescriptionCallBack = FUNCTION(value: UNIV Ptr): CFStringRef; C;
{$ELSEC}
	CFDictionaryCopyDescriptionCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFDictionaryEqualCallBack = FUNCTION(value1: UNIV Ptr; value2: UNIV Ptr): BOOLEAN; C;
{$ELSEC}
	CFDictionaryEqualCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFDictionaryHashCallBack = FUNCTION(value: UNIV Ptr): CFHashCode; C;
{$ELSEC}
	CFDictionaryHashCallBack = ProcPtr;
{$ENDC}


	{
	 *  CFDictionaryKeyCallBacks
	 *  
	 *  Discussion:
	 *    Structure containing the callbacks for keys of a CFDictionary.
	 	}
	CFDictionaryKeyCallBacksPtr = ^CFDictionaryKeyCallBacks;
	CFDictionaryKeyCallBacks = RECORD
		version:				CFIndex;
		retain:					CFDictionaryRetainCallBack;
		release:				CFDictionaryReleaseCallBack;
		copyDescription:		CFDictionaryCopyDescriptionCallBack;
		equal:					CFDictionaryEqualCallBack;
		hash:					CFDictionaryHashCallBack;
	END;

	{
	 *  kCFTypeDictionaryKeyCallBacks
	 *  
	 *  Discussion:
	 *    Predefined CFDictionaryKeyCallBacks structure containing a set of
	 *    callbacks appropriate for use when the keys of a CFDictionary are
	 *    all CFTypes.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{
	 *  kCFCopyStringDictionaryKeyCallBacks
	 *  
	 *  Discussion:
	 *    Predefined CFDictionaryKeyCallBacks structure containing a set of
	 *    callbacks appropriate for use when the keys of a CFDictionary are
	 *    all CFStrings, which may be mutable and need to be copied in
	 *    order to serve as constant keys for the values in the dictionary.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}

	{
	 *  CFDictionaryValueCallBacks
	 *  
	 *  Discussion:
	 *    Structure containing the callbacks for values of a CFDictionary.
	 	}
	CFDictionaryValueCallBacksPtr = ^CFDictionaryValueCallBacks;
	CFDictionaryValueCallBacks = RECORD
		version:				CFIndex;
		retain:					CFDictionaryRetainCallBack;
		release:				CFDictionaryReleaseCallBack;
		copyDescription:		CFDictionaryCopyDescriptionCallBack;
		equal:					CFDictionaryEqualCallBack;
	END;

	{
	 *  kCFTypeDictionaryValueCallBacks
	 *  
	 *  Discussion:
	 *    Predefined CFDictionaryValueCallBacks structure containing a set
	 *    of callbacks appropriate for use when the values in a
	 *    CFDictionary are all CFTypes.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}

	{
	 *  CFDictionaryApplierFunction
	 *  
	 *  Discussion:
	 *    Type of the callback function used by the apply functions of
	 *    CFDictionarys.
	 *  
	 *  Parameters:
	 *    
	 *    key:
	 *      The current key for the value.
	 *    
	 *    val:
	 *      The current value from the dictionary.
	 *    
	 *    context:
	 *      The user-defined context parameter given to the apply function.
	 	}
{$IFC TYPED_FUNCTION_POINTERS}
	CFDictionaryApplierFunction = PROCEDURE(key: UNIV Ptr; value: UNIV Ptr; context: UNIV Ptr); C;
{$ELSEC}
	CFDictionaryApplierFunction = ProcPtr;
{$ENDC}


	{
	 *  CFDictionaryRef
	 *  
	 *  Discussion:
	 *    This is the type of a reference to immutable CFDictionarys.
	 	}
	CFDictionaryRef    = ^LONGINT; { an opaque 32-bit type }
	CFDictionaryRefPtr = ^CFDictionaryRef;  { when a VAR xx:CFDictionaryRef parameter can be nil, it is changed to xx: CFDictionaryRefPtr }

	{
	 *  CFMutableDictionaryRef
	 *  
	 *  Discussion:
	 *    This is the type of a reference to mutable CFDictionarys.
	 	}
	CFMutableDictionaryRef    = CFDictionaryRef;
	CFMutableDictionaryRefPtr = ^CFMutableDictionaryRef;  { when a VAR xx:CFMutableDictionaryRef parameter can be nil, it is changed to xx: CFMutableDictionaryRefPtr }
	{
	 *  CFDictionaryGetTypeID()
	 *  
	 *  Discussion:
	 *    Returns the type identifier of all CFDictionary instances.
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFDictionaryGetTypeID: CFTypeID; C;

{
 *  CFDictionaryCreate()
 *  
 *  Discussion:
 *    Creates a new immutable dictionary with the given values.
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The CFAllocator which should be used to allocate memory for the
 *      dictionary and its storage for values. This parameter may be
 *      NULL in which case the current default CFAllocator is used. If
 *      this reference is not a valid CFAllocator, the behavior is
 *      undefined.
 *    
 *    keys:
 *      A C array of the pointer-sized keys to be used for the parallel
 *      C array of values to be put into the dictionary. This parameter
 *      may be NULL if the numValues parameter is 0. This C array is
 *      not changed or freed by this function. If this parameter is not
 *      a valid pointer to a C array of at least numValues pointers,
 *      the behavior is undefined.
 *    
 *    values:
 *      A C array of the pointer-sized values to be in the dictionary.
 *      This parameter may be NULL if the numValues parameter is 0.
 *      This C array is not changed or freed by this function. If this
 *      parameter is not a valid pointer to a C array of at least
 *      numValues pointers, the behavior is undefined.
 *    
 *    numValues:
 *      The number of values to copy from the keys and values C arrays
 *      into the CFDictionary. This number will be the count of the
 *      dictionary. If this parameter is negative, or greater than the
 *      number of values actually in the keys or values C arrays, the
 *      behavior is undefined.
 *    
 *    keyCallBacks:
 *      A pointer to a CFDictionaryKeyCallBacks structure initialized
 *      with the callbacks for the dictionary to use on each key in the
 *      dictionary. The retain callback will be used within this
 *      function, for example, to retain all of the new keys from the
 *      keys C array. A copy of the contents of the callbacks structure
 *      is made, so that a pointer to a structure on the stack can be
 *      passed in, or can be reused for multiple dictionary creations.
 *      If the version field of this callbacks structure is not one of
 *      the defined ones for CFDictionary, the behavior is undefined.
 *      The retain field may be NULL, in which case the CFDictionary
 *      will do nothing to add a retain to the keys of the contained
 *      values. The release field may be NULL, in which case the
 *      CFDictionary will do nothing to remove the dictionary's retain
 *      (if any) on the keys when the dictionary is destroyed or a
 *      key-value pair is removed. If the copyDescription field is
 *      NULL, the dictionary will create a simple description for a
 *      key. If the equal field is NULL, the dictionary will use
 *      pointer equality to test for equality of keys. If the hash
 *      field is NULL, a key will be converted from a pointer to an
 *      integer to compute the hash code. This callbacks parameter
 *      itself may be NULL, which is treated as if a valid structure of
 *      version 0 with all fields NULL had been passed in. Otherwise,
 *      if any of the fields are not valid pointers to functions of the
 *      correct type, or this parameter is not a valid pointer to a
 *      CFDictionaryKeyCallBacks callbacks structure, the behavior is
 *      undefined. If any of the keys put into the dictionary is not
 *      one understood by one of the callback functions the behavior
 *      when that callback function is used is undefined.
 *    
 *    valueCallBacks:
 *      A pointer to a CFDictionaryValueCallBacks structure initialized
 *      with the callbacks for the dictionary to use on each value in
 *      the dictionary. The retain callback will be used within this
 *      function, for example, to retain all of the new values from the
 *      values C array. A copy of the contents of the callbacks
 *      structure is made, so that a pointer to a structure on the
 *      stack can be passed in, or can be reused for multiple
 *      dictionary creations. If the version field of this callbacks
 *      structure is not one of the defined ones for CFDictionary, the
 *      behavior is undefined. The retain field may be NULL, in which
 *      case the CFDictionary will do nothing to add a retain to values
 *      as they are put into the dictionary. The release field may be
 *      NULL, in which case the CFDictionary will do nothing to remove
 *      the dictionary's retain (if any) on the values when the
 *      dictionary is destroyed or a key-value pair is removed. If the
 *      copyDescription field is NULL, the dictionary will create a
 *      simple description for a value. If the equal field is NULL, the
 *      dictionary will use pointer equality to test for equality of
 *      values. This callbacks parameter itself may be NULL, which is
 *      treated as if a valid structure of version 0 with all fields
 *      NULL had been passed in. Otherwise, if any of the fields are
 *      not valid pointers to functions of the correct type, or this
 *      parameter is not a valid pointer to a
 *      CFDictionaryValueCallBacks callbacks structure, the behavior is
 *      undefined. If any of the values put into the dictionary is not
 *      one understood by one of the callback functions the behavior
 *      when that callback function is used is undefined.
 *  
 *  Result:
 *    A reference to the new immutable CFDictionary.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryCreate(allocator: CFAllocatorRef; VAR keys: UNIV Ptr; VAR values: UNIV Ptr; numValues: CFIndex; {CONST}VAR keyCallBacks: CFDictionaryKeyCallBacks; {CONST}VAR valueCallBacks: CFDictionaryValueCallBacks): CFDictionaryRef; C;

{
 *  CFDictionaryCreateCopy()
 *  
 *  Discussion:
 *    Creates a new immutable dictionary with the key-value pairs from
 *    the given dictionary.
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The CFAllocator which should be used to allocate memory for the
 *      dictionary and its storage for values. This parameter may be
 *      NULL in which case the current default CFAllocator is used. If
 *      this reference is not a valid CFAllocator, the behavior is
 *      undefined.
 *    
 *    theDict:
 *      The dictionary which is to be copied. The keys and values from
 *      the dictionary are copied as pointers into the new dictionary
 *      (that is, the values themselves are copied, not that which the
 *      values point to, if anything). However, the keys and values are
 *      also retained by the new dictionary using the retain function
 *      of the original dictionary. The count of the new dictionary
 *      will be the same as the given dictionary. The new dictionary
 *      uses the same callbacks as the dictionary to be copied. If this
 *      parameter is not a valid CFDictionary, the behavior is
 *      undefined.
 *  
 *  Result:
 *    A reference to the new immutable CFDictionary.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryCreateCopy(allocator: CFAllocatorRef; theDict: CFDictionaryRef): CFDictionaryRef; C;

{
 *  CFDictionaryCreateMutable()
 *  
 *  Discussion:
 *    Creates a new mutable dictionary.
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The CFAllocator which should be used to allocate memory for the
 *      dictionary and its storage for values. This parameter may be
 *      NULL in which case the current default CFAllocator is used. If
 *      this reference is not a valid CFAllocator, the behavior is
 *      undefined.
 *    
 *    capacity:
 *      The maximum number of values that can be contained by the
 *      CFDictionary. The dictionary starts empty, and can grow to this
 *      number of values (and it can have less). If this parameter is
 *      0, the dictionary's maximum capacity is unlimited (or rather,
 *      only limited by address space and available memory
 *      constraints). If this parameter is negative, the behavior is
 *      undefined.
 *    
 *    keyCallBacks:
 *      A pointer to a CFDictionaryKeyCallBacks structure initialized
 *      with the callbacks for the dictionary to use on each key in the
 *      dictionary. A copy of the contents of the callbacks structure
 *      is made, so that a pointer to a structure on the stack can be
 *      passed in, or can be reused for multiple dictionary creations.
 *      If the version field of this callbacks structure is not one of
 *      the defined ones for CFDictionary, the behavior is undefined.
 *      The retain field may be NULL, in which case the CFDictionary
 *      will do nothing to add a retain to the keys of the contained
 *      values. The release field may be NULL, in which case the
 *      CFDictionary will do nothing to remove the dictionary's retain
 *      (if any) on the keys when the dictionary is destroyed or a
 *      key-value pair is removed. If the copyDescription field is
 *      NULL, the dictionary will create a simple description for a
 *      key. If the equal field is NULL, the dictionary will use
 *      pointer equality to test for equality of keys. If the hash
 *      field is NULL, a key will be converted from a pointer to an
 *      integer to compute the hash code. This callbacks parameter
 *      itself may be NULL, which is treated as if a valid structure of
 *      version 0 with all fields NULL had been passed in. Otherwise,
 *      if any of the fields are not valid pointers to functions of the
 *      correct type, or this parameter is not a valid pointer to a
 *      CFDictionaryKeyCallBacks callbacks structure, the behavior is
 *      undefined. If any of the keys put into the dictionary is not
 *      one understood by one of the callback functions the behavior
 *      when that callback function is used is undefined.
 *    
 *    valueCallBacks:
 *      A pointer to a CFDictionaryValueCallBacks structure initialized
 *      with the callbacks for the dictionary to use on each value in
 *      the dictionary. The retain callback will be used within this
 *      function, for example, to retain all of the new values from the
 *      values C array. A copy of the contents of the callbacks
 *      structure is made, so that a pointer to a structure on the
 *      stack can be passed in, or can be reused for multiple
 *      dictionary creations. If the version field of this callbacks
 *      structure is not one of the defined ones for CFDictionary, the
 *      behavior is undefined. The retain field may be NULL, in which
 *      case the CFDictionary will do nothing to add a retain to values
 *      as they are put into the dictionary. The release field may be
 *      NULL, in which case the CFDictionary will do nothing to remove
 *      the dictionary's retain (if any) on the values when the
 *      dictionary is destroyed or a key-value pair is removed. If the
 *      copyDescription field is NULL, the dictionary will create a
 *      simple description for a value. If the equal field is NULL, the
 *      dictionary will use pointer equality to test for equality of
 *      values. This callbacks parameter itself may be NULL, which is
 *      treated as if a valid structure of version 0 with all fields
 *      NULL had been passed in. Otherwise, if any of the fields are
 *      not valid pointers to functions of the correct type, or this
 *      parameter is not a valid pointer to a
 *      CFDictionaryValueCallBacks callbacks structure, the behavior is
 *      undefined. If any of the values put into the dictionary is not
 *      one understood by one of the callback functions the behavior
 *      when that callback function is used is undefined.
 *  
 *  Result:
 *    A reference to the new mutable CFDictionary.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryCreateMutable(allocator: CFAllocatorRef; capacity: CFIndex; {CONST}VAR keyCallBacks: CFDictionaryKeyCallBacks; {CONST}VAR valueCallBacks: CFDictionaryValueCallBacks): CFMutableDictionaryRef; C;

{
 *  CFDictionaryCreateMutableCopy()
 *  
 *  Discussion:
 *    Creates a new mutable dictionary with the key-value pairs from
 *    the given dictionary.
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The CFAllocator which should be used to allocate memory for the
 *      dictionary and its storage for values. This parameter may be
 *      NULL in which case the current default CFAllocator is used. If
 *      this reference is not a valid CFAllocator, the behavior is
 *      undefined.
 *    
 *    capacity:
 *      The maximum number of values that can be contained by the
 *      CFDictionary. The dictionary starts empty, and can grow to this
 *      number of values (and it can have less). If this parameter is
 *      0, the dictionary's maximum capacity is unlimited (or rather,
 *      only limited by address space and available memory
 *      constraints). This parameter must be greater than or equal to
 *      the count of the dictionary which is to be copied, or the
 *      behavior is undefined. If this parameter is negative, the
 *      behavior is undefined.
 *    
 *    theDict:
 *      The dictionary which is to be copied. The keys and values from
 *      the dictionary are copied as pointers into the new dictionary
 *      (that is, the values themselves are copied, not that which the
 *      values point to, if anything). However, the keys and values are
 *      also retained by the new dictionary using the retain function
 *      of the original dictionary. The count of the new dictionary
 *      will be the same as the given dictionary. The new dictionary
 *      uses the same callbacks as the dictionary to be copied. If this
 *      parameter is not a valid CFDictionary, the behavior is
 *      undefined.
 *  
 *  Result:
 *    A reference to the new mutable CFDictionary.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryCreateMutableCopy(allocator: CFAllocatorRef; capacity: CFIndex; theDict: CFDictionaryRef): CFMutableDictionaryRef; C;

{
 *  CFDictionaryGetCount()
 *  
 *  Discussion:
 *    Returns the number of values currently in the dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to be queried. If this parameter is not a valid
 *      CFDictionary, the behavior is undefined.
 *  
 *  Result:
 *    The number of values in the dictionary.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryGetCount(theDict: CFDictionaryRef): CFIndex; C;

{
 *  CFDictionaryGetCountOfKey()
 *  
 *  Discussion:
 *    Counts the number of times the given key occurs in the dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to be searched. If this parameter is not a valid
 *      CFDictionary, the behavior is undefined.
 *    
 *    key:
 *      The key for which to find matches in the dictionary. The hash()
 *      and equal() key callbacks provided when the dictionary was
 *      created are used to compare. If the hash() key callback was
 *      NULL, the key is treated as a pointer and converted to an
 *      integer. If the equal() key callback was NULL, pointer equality
 *      (in C, ==) is used. If key, or any of the keys in the
 *      dictionary, are not understood by the equal() callback, the
 *      behavior is undefined.
 *  
 *  Result:
 *    Returns 1 if a matching key is used by the dictionary, 0
 *    otherwise.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryGetCountOfKey(theDict: CFDictionaryRef; key: UNIV Ptr): CFIndex; C;

{
 *  CFDictionaryGetCountOfValue()
 *  
 *  Discussion:
 *    Counts the number of times the given value occurs in the
 *    dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to be searched. If this parameter is not a valid
 *      CFDictionary, the behavior is undefined.
 *    
 *    value:
 *      The value for which to find matches in the dictionary. The
 *      equal() callback provided when the dictionary was created is
 *      used to compare. If the equal() value callback was NULL,
 *      pointer equality (in C, ==) is used. If value, or any of the
 *      values in the dictionary, are not understood by the equal()
 *      callback, the behavior is undefined.
 *  
 *  Result:
 *    The number of times the given value occurs in the dictionary.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryGetCountOfValue(theDict: CFDictionaryRef; value: UNIV Ptr): CFIndex; C;

{
 *  CFDictionaryContainsKey()
 *  
 *  Discussion:
 *    Reports whether or not the key is in the dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to be searched. If this parameter is not a valid
 *      CFDictionary, the behavior is undefined.
 *    
 *    key:
 *      The key for which to find matches in the dictionary. The hash()
 *      and equal() key callbacks provided when the dictionary was
 *      created are used to compare. If the hash() key callback was
 *      NULL, the key is treated as a pointer and converted to an
 *      integer. If the equal() key callback was NULL, pointer equality
 *      (in C, ==) is used. If key, or any of the keys in the
 *      dictionary, are not understood by the equal() callback, the
 *      behavior is undefined.
 *  
 *  Result:
 *    TRUE, if the key is in the dictionary, otherwise FALSE.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryContainsKey(theDict: CFDictionaryRef; key: UNIV Ptr): BOOLEAN; C;

{
 *  CFDictionaryContainsValue()
 *  
 *  Discussion:
 *    Reports whether or not the value is in the dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to be searched. If this parameter is not a valid
 *      CFDictionary, the behavior is undefined.
 *    
 *    value:
 *      The value for which to find matches in the dictionary. The
 *      equal() callback provided when the dictionary was created is
 *      used to compare. If the equal() callback was NULL, pointer
 *      equality (in C, ==) is used. If value, or any of the values in
 *      the dictionary, are not understood by the equal() callback, the
 *      behavior is undefined.
 *  
 *  Result:
 *    TRUE, if the value is in the dictionary, otherwise FALSE.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryContainsValue(theDict: CFDictionaryRef; value: UNIV Ptr): BOOLEAN; C;

{
 *  CFDictionaryGetValue()
 *  
 *  Discussion:
 *    Retrieves the value associated with the given key.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to be queried. If this parameter is not a valid
 *      CFDictionary, the behavior is undefined.
 *    
 *    key:
 *      The key for which to find a match in the dictionary. The hash()
 *      and equal() key callbacks provided when the dictionary was
 *      created are used to compare. If the hash() key callback was
 *      NULL, the key is treated as a pointer and converted to an
 *      integer. If the equal() key callback was NULL, pointer equality
 *      (in C, ==) is used. If key, or any of the keys in the
 *      dictionary, are not understood by the equal() callback, the
 *      behavior is undefined.
 *  
 *  Result:
 *    The value with the given key in the dictionary, or NULL if no
 *    key-value pair with a matching key exists. Since NULL can be a
 *    valid value in some dictionaries, the function
 *    CFDictionaryGetValueIfPresent() must be used to distinguish
 *    NULL-no-found from NULL-is-the-value.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryGetValue(theDict: CFDictionaryRef; key: UNIV Ptr): Ptr; C;

{
 *  CFDictionaryGetValueIfPresent()
 *  
 *  Discussion:
 *    Retrieves the value associated with the given key.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to be queried. If this parameter is not a valid
 *      CFDictionary, the behavior is undefined.
 *    
 *    key:
 *      The key for which to find a match in the dictionary. The hash()
 *      and equal() key callbacks provided when the dictionary was
 *      created are used to compare. If the hash() key callback was
 *      NULL, the key is treated as a pointer and converted to an
 *      integer. If the equal() key callback was NULL, pointer equality
 *      (in C, ==) is used. If key, or any of the keys in the
 *      dictionary, are not understood by the equal() callback, the
 *      behavior is undefined.
 *    
 *    value:
 *      A pointer to memory which should be filled with the
 *      pointer-sized value if a matching key is found. If no key match
 *      is found, the contents of the storage pointed to by this
 *      parameter are undefined. This parameter may be NULL, in which
 *      case the value from the dictionary is not returned (but the
 *      return value of this function still indicates whether or not
 *      the key-value pair was present).
 *  
 *  Result:
 *    TRUE, if a matching key was found, FALSE otherwise.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFDictionaryGetValueIfPresent(theDict: CFDictionaryRef; key: UNIV Ptr; VAR value: UNIV Ptr): BOOLEAN; C;

{
 *  CFDictionaryGetKeysAndValues()
 *  
 *  Discussion:
 *    Fills the two buffers with the keys and values from the
 *    dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to be queried. If this parameter is not a valid
 *      CFDictionary, the behavior is undefined.
 *    
 *    keys:
 *      A C array of pointer-sized values to be filled with keys from
 *      the dictionary. The keys and values C arrays are parallel to
 *      each other (that is, the items at the same indices form a
 *      key-value pair from the dictionary). This parameter may be NULL
 *      if the keys are not desired. If this parameter is not a valid
 *      pointer to a C array of at least CFDictionaryGetCount()
 *      pointers, or NULL, the behavior is undefined.
 *    
 *    values:
 *      A C array of pointer-sized values to be filled with values from
 *      the dictionary. The keys and values C arrays are parallel to
 *      each other (that is, the items at the same indices form a
 *      key-value pair from the dictionary). This parameter may be NULL
 *      if the values are not desired. If this parameter is not a valid
 *      pointer to a C array of at least CFDictionaryGetCount()
 *      pointers, or NULL, the behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDictionaryGetKeysAndValues(theDict: CFDictionaryRef; VAR keys: UNIV Ptr; VAR values: UNIV Ptr); C;

{
 *  CFDictionaryApplyFunction()
 *  
 *  Discussion:
 *    Calls a function once for each value in the dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to be queried. If this parameter is not a valid
 *      CFDictionary, the behavior is undefined.
 *    
 *    applier:
 *      The callback function to call once for each value in the
 *      dictionary. If this parameter is not a pointer to a function of
 *      the correct prototype, the behavior is undefined. If there are
 *      keys or values which the applier function does not expect or
 *      cannot properly apply to, the behavior is undefined.
 *    
 *    context:
 *      A pointer-sized user-defined value, which is passed as the
 *      third parameter to the applier function, but is otherwise
 *      unused by this function. If the context is not what is expected
 *      by the applier function, the behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDictionaryApplyFunction(theDict: CFDictionaryRef; applier: CFDictionaryApplierFunction; context: UNIV Ptr); C;

{
 *  CFDictionaryAddValue()
 *  
 *  Discussion:
 *    Adds the key-value pair to the dictionary if no such key already
 *    exists.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to which the value is to be added. If this
 *      parameter is not a valid mutable CFDictionary, the behavior is
 *      undefined. If the dictionary is a fixed-capacity dictionary and
 *      it is full before this operation, the behavior is undefined.
 *    
 *    key:
 *      The key of the value to add to the dictionary. The key is
 *      retained by the dictionary using the retain callback provided
 *      when the dictionary was created. If the key is not of the sort
 *      expected by the retain callback, the behavior is undefined. If
 *      a key which matches this key is already present in the
 *      dictionary, this function does nothing ("add if absent").
 *    
 *    value:
 *      The value to add to the dictionary. The value is retained by
 *      the dictionary using the retain callback provided when the
 *      dictionary was created. If the value is not of the sort
 *      expected by the retain callback, the behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDictionaryAddValue(theDict: CFMutableDictionaryRef; key: UNIV Ptr; value: UNIV Ptr); C;

{
 *  CFDictionarySetValue()
 *  
 *  Discussion:
 *    Sets the value of the key in the dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to which the value is to be set. If this
 *      parameter is not a valid mutable CFDictionary, the behavior is
 *      undefined. If the dictionary is a fixed-capacity dictionary and
 *      it is full before this operation, and the key does not exist in
 *      the dictionary, the behavior is undefined.
 *    
 *    key:
 *      The key of the value to set into the dictionary. If a key which
 *      matches this key is already present in the dictionary, only the
 *      value is changed ("add if absent, replace if present"). If no
 *      key matches the given key, the key-value pair is added to the
 *      dictionary. If added, the key is retained by the dictionary,
 *      using the retain callback provided when the dictionary was
 *      created. If the key is not of the sort expected by the key
 *      retain callback, the behavior is undefined.
 *    
 *    value:
 *      The value to add to or replace into the dictionary. The value
 *      is retained by the dictionary using the retain callback
 *      provided when the dictionary was created, and the previous
 *      value if any is released. If the value is not of the sort
 *      expected by the retain or release callbacks, the behavior is
 *      undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDictionarySetValue(theDict: CFMutableDictionaryRef; key: UNIV Ptr; value: UNIV Ptr); C;

{
 *  CFDictionaryReplaceValue()
 *  
 *  Discussion:
 *    Replaces the value of the key in the dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary to which the value is to be replaced. If this
 *      parameter is not a valid mutable CFDictionary, the behavior is
 *      undefined.
 *    
 *    key:
 *      The key of the value to replace in the dictionary. If a key
 *      which matches this key is present in the dictionary, the value
 *      is changed to the given value, otherwise this function does
 *      nothing ("replace if present").
 *    
 *    value:
 *      The value to replace into the dictionary. The value is retained
 *      by the dictionary using the retain callback provided when the
 *      dictionary was created, and the previous value is released. If
 *      the value is not of the sort expected by the retain or release
 *      callbacks, the behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDictionaryReplaceValue(theDict: CFMutableDictionaryRef; key: UNIV Ptr; value: UNIV Ptr); C;

{
 *  CFDictionaryRemoveValue()
 *  
 *  Discussion:
 *    Removes the value of the key from the dictionary.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary from which the value is to be removed. If this
 *      parameter is not a valid mutable CFDictionary, the behavior is
 *      undefined.
 *    
 *    key:
 *      The key of the value to remove from the dictionary. If a key
 *      which matches this key is present in the dictionary, the
 *      key-value pair is removed from the dictionary, otherwise this
 *      function does nothing ("remove if present").
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDictionaryRemoveValue(theDict: CFMutableDictionaryRef; key: UNIV Ptr); C;

{
 *  CFDictionaryRemoveAllValues()
 *  
 *  Discussion:
 *    Removes all the values from the dictionary, making it empty.
 *  
 *  Parameters:
 *    
 *    theDict:
 *      The dictionary from which all of the values are to be removed.
 *      If this parameter is not a valid mutable CFDictionary, the
 *      behavior is undefined.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFDictionaryRemoveAllValues(theDict: CFMutableDictionaryRef); C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFDictionaryIncludes}

{$ENDC} {__CFDICTIONARY__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFNumber.p
 
     Contains:   CoreFoundation numbers
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFNumber;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFNUMBER__}
{$SETC __CFNUMBER__ := 1}

{$I+}
{$SETC CFNumberIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}



{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
	CFBooleanRef    = ^LONGINT; { an opaque 32-bit type }
	CFBooleanRefPtr = ^CFBooleanRef;  { when a VAR xx:CFBooleanRef parameter can be nil, it is changed to xx: CFBooleanRefPtr }
	{
	 *  kCFBooleanTrue
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{
	 *  kCFBooleanFalse
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{
	 *  CFBooleanGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFBooleanGetTypeID: CFTypeID; C;

{
 *  CFBooleanGetValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFBooleanGetValue(bool: CFBooleanRef): BOOLEAN; C;


TYPE
	CFNumberType 				= SInt32;
CONST
																{  Types from MacTypes.h  }
	kCFNumberSInt8Type			= 1;
	kCFNumberSInt16Type			= 2;
	kCFNumberSInt32Type			= 3;
	kCFNumberSInt64Type			= 4;
	kCFNumberFloat32Type		= 5;
	kCFNumberFloat64Type		= 6;							{  64-bit IEEE 754  }
																{  Basic C types  }
	kCFNumberCharType			= 7;
	kCFNumberShortType			= 8;
	kCFNumberIntType			= 9;
	kCFNumberLongType			= 10;
	kCFNumberLongLongType		= 11;
	kCFNumberFloatType			= 12;
	kCFNumberDoubleType			= 13;							{  Other  }
	kCFNumberCFIndexType		= 14;
	kCFNumberMaxType			= 14;


TYPE
	CFNumberRef    = ^LONGINT; { an opaque 32-bit type }
	CFNumberRefPtr = ^CFNumberRef;  { when a VAR xx:CFNumberRef parameter can be nil, it is changed to xx: CFNumberRefPtr }
	{
	 *  kCFNumberPositiveInfinity
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{
	 *  kCFNumberNegativeInfinity
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{
	 *  kCFNumberNaN
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{
	 *  CFNumberGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFNumberGetTypeID: CFTypeID; C;

{
    Creates a CFNumber with the given value. The type of number pointed
    to by the valuePtr is specified by type. If type is a floating point
    type and the value represents one of the infinities or NaN, the
    well-defined CFNumber for that value is returned. If either of
    valuePtr or type is an invalid value, the result is undefined.
}
{
 *  CFNumberCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFNumberCreate(allocator: CFAllocatorRef; theType: CFNumberType; valuePtr: UNIV Ptr): CFNumberRef; C;

{
    Returns the storage format of the CFNumber's value.  Note that
    this is not necessarily the type provided in CFNumberCreate().
}
{
 *  CFNumberGetType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFNumberGetType(number: CFNumberRef): CFNumberType; C;

{
    Returns the size in bytes of the type of the number.
}
{
 *  CFNumberGetByteSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFNumberGetByteSize(number: CFNumberRef): CFIndex; C;

{
    Returns TRUE if the type of the CFNumber's value is one of
    the defined floating point types.
}
{
 *  CFNumberIsFloatType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFNumberIsFloatType(number: CFNumberRef): BOOLEAN; C;

{
    Copies the CFNumber's value into the space pointed to by
    valuePtr, as the specified type. If conversion needs to take
    place, the conversion rules follow human expectation and not
    C's promotion and truncation rules. If the conversion is
    lossy, or the value is out of range, FALSE is returned. Best
    attempt at conversion will still be in *valuePtr.
}
{
 *  CFNumberGetValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFNumberGetValue(number: CFNumberRef; theType: CFNumberType; valuePtr: UNIV Ptr): BOOLEAN; C;

{
    Compares the two CFNumber instances. If conversion of the
    types of the values is needed, the conversion and comparison
    follow human expectations and not C's promotion and comparison
    rules. Negative zero compares less than positive zero.
    Positive infinity compares greater than everything except
    itself, to which it compares equal. Negative infinity compares
    less than everything except itself, to which it compares equal.
    Unlike standard practice, if both numbers are NaN, then they
    compare equal; if only one of the numbers is NaN, then the NaN
    compares greater than the other number if it is negative, and
    smaller than the other number if it is positive. (Note that in
    CFEqual() with two CFNumbers, if either or both of the numbers
    is NaN, FALSE is returned.)
}
{
 *  CFNumberCompare()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFNumberCompare(number: CFNumberRef; otherNumber: CFNumberRef; context: UNIV Ptr): CFComparisonResult; C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFNumberIncludes}

{$ENDC} {__CFNUMBER__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFPlugIn.p
 
     Contains:   CoreFoundation plugins
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFPlugIn;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFPLUGIN__}
{$SETC __CFPLUGIN__ := 1}

{$I+}
{$SETC CFPlugInIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}
{$IFC UNDEFINED __CFARRAY__}
{$I CFArray.p}
{$ENDC}
{$IFC UNDEFINED __CFBUNDLE__}
{$I CFBundle.p}
{$ENDC}
{$IFC UNDEFINED __CFSTRING__}
{$I CFString.p}
{$ENDC}
{$IFC UNDEFINED __CFURL__}
{$I CFURL.p}
{$ENDC}
{$IFC UNDEFINED __CFUUID__}
{$I CFUUID.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{ ================ Standard Info.plist keys for plugIns ================ }
{
 *  kCFPlugInDynamicRegistrationKey
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFPlugInDynamicRegisterFunctionKey
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFPlugInUnloadFunctionKey
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFPlugInFactoriesKey
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFPlugInTypesKey
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{ ================= Function prototypes for various callbacks ================= }
{ Function types that plugIn authors can implement for various purposes. }

TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	CFPlugInDynamicRegisterFunction = PROCEDURE(plugIn: CFPlugInRef); C;
{$ELSEC}
	CFPlugInDynamicRegisterFunction = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFPlugInUnloadFunction = PROCEDURE(plugIn: CFPlugInRef); C;
{$ELSEC}
	CFPlugInUnloadFunction = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFPlugInFactoryFunction = FUNCTION(allocator: CFAllocatorRef; typeUUID: CFUUIDRef): Ptr; C;
{$ELSEC}
	CFPlugInFactoryFunction = ProcPtr;
{$ENDC}

	{	 ================= Creating PlugIns ================= 	}
	{
	 *  CFPlugInGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFPlugInGetTypeID: UInt32; C;

{
 *  CFPlugInCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInCreate(allocator: CFAllocatorRef; plugInURL: CFURLRef): CFPlugInRef; C;

{ Might return an existing instance with the ref-count bumped. }
{
 *  CFPlugInGetBundle()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInGetBundle(plugIn: CFPlugInRef): CFBundleRef; C;

{ ================= Controlling load on demand ================= }
{ For plugIns. }
{ PlugIns that do static registration are load on demand by default. }
{ PlugIns that do dynamic registration are not load on demand by default. }
{ A dynamic registration function can call CFPlugInSetLoadOnDemand(). }
{
 *  CFPlugInSetLoadOnDemand()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFPlugInSetLoadOnDemand(plugIn: CFPlugInRef; flag: BOOLEAN); C;

{
 *  CFPlugInIsLoadOnDemand()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInIsLoadOnDemand(plugIn: CFPlugInRef): BOOLEAN; C;

{ ================= Finding factories and creating instances ================= }
{ For plugIn hosts. }
{ Functions for finding factories to create specific types and actually creating instances of a type. }
{
 *  CFPlugInFindFactoriesForPlugInType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInFindFactoriesForPlugInType(typeUUID: CFUUIDRef): CFArrayRef; C;

{ This function finds all the factories from any plugin for the given type.  }
{
 *  CFPlugInFindFactoriesForPlugInTypeInPlugIn()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInFindFactoriesForPlugInTypeInPlugIn(typeUUID: CFUUIDRef; plugIn: CFPlugInRef): CFArrayRef; C;

{ This function restricts the result to factories from the given plug-in that can create the given type }
{
 *  CFPlugInInstanceCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInInstanceCreate(allocator: CFAllocatorRef; factoryUUID: CFUUIDRef; typeUUID: CFUUIDRef): Ptr; C;

{ This function returns the IUnknown interface for the new instance. }
{ ================= Registering factories and types ================= }
{ For plugIn writers who must dynamically register things. }
{ Functions to register factory functions and to associate factories with types. }
{
 *  CFPlugInRegisterFactoryFunction()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInRegisterFactoryFunction(factoryUUID: CFUUIDRef; func: CFPlugInFactoryFunction): BOOLEAN; C;

{
 *  CFPlugInRegisterFactoryFunctionByName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInRegisterFactoryFunctionByName(factoryUUID: CFUUIDRef; plugIn: CFPlugInRef; functionName: CFStringRef): BOOLEAN; C;

{
 *  CFPlugInUnregisterFactory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInUnregisterFactory(factoryUUID: CFUUIDRef): BOOLEAN; C;

{
 *  CFPlugInRegisterPlugInType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInRegisterPlugInType(factoryUUID: CFUUIDRef; typeUUID: CFUUIDRef): BOOLEAN; C;

{
 *  CFPlugInUnregisterPlugInType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInUnregisterPlugInType(factoryUUID: CFUUIDRef; typeUUID: CFUUIDRef): BOOLEAN; C;

{ ================= Registering instances ================= }
{ When a new instance of a type is created, the instance is responsible for registering itself with the factory that created it and unregistering when it deallocates. }
{ This means that an instance must keep track of the CFUUIDRef of the factory that created it so it can unregister when it goes away. }
{
 *  CFPlugInAddInstanceForFactory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFPlugInAddInstanceForFactory(factoryID: CFUUIDRef); C;

{
 *  CFPlugInRemoveInstanceForFactory()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFPlugInRemoveInstanceForFactory(factoryID: CFUUIDRef); C;


{ Obsolete API }

TYPE
	CFPlugInInstanceRef    = ^LONGINT; { an opaque 32-bit type }
	CFPlugInInstanceRefPtr = ^CFPlugInInstanceRef;  { when a VAR xx:CFPlugInInstanceRef parameter can be nil, it is changed to xx: CFPlugInInstanceRefPtr }
{$IFC TYPED_FUNCTION_POINTERS}
	CFPlugInInstanceGetInterfaceFunction = FUNCTION(instance: CFPlugInInstanceRef; interfaceName: CFStringRef; VAR ftbl: UNIV Ptr): BOOLEAN; C;
{$ELSEC}
	CFPlugInInstanceGetInterfaceFunction = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFPlugInInstanceDeallocateInstanceDataFunction = PROCEDURE(instanceData: UNIV Ptr); C;
{$ELSEC}
	CFPlugInInstanceDeallocateInstanceDataFunction = ProcPtr;
{$ENDC}

	{
	 *  CFPlugInInstanceGetInterfaceFunctionTable()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFPlugInInstanceGetInterfaceFunctionTable(instance: CFPlugInInstanceRef; interfaceName: CFStringRef; VAR ftbl: UNIV Ptr): BOOLEAN; C;

{
 *  CFPlugInInstanceGetFactoryName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInInstanceGetFactoryName(instance: CFPlugInInstanceRef): CFStringRef; C;

{
 *  CFPlugInInstanceGetInstanceData()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInInstanceGetInstanceData(instance: CFPlugInInstanceRef): Ptr; C;

{
 *  CFPlugInInstanceGetTypeID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInInstanceGetTypeID: UInt32; C;

{
 *  CFPlugInInstanceCreateWithInstanceDataSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPlugInInstanceCreateWithInstanceDataSize(allocator: CFAllocatorRef; instanceDataSize: CFIndex; deallocateInstanceFunction: CFPlugInInstanceDeallocateInstanceDataFunction; factoryName: CFStringRef; getInterfaceFunction: CFPlugInInstanceGetInterfaceFunction): CFPlugInInstanceRef; C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFPlugInIncludes}

{$ENDC} {__CFPLUGIN__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFPlugInCOM.p
 
     Contains:   CoreFoundation plugins
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFPlugInCOM;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFPLUGINCOM__}
{$SETC __CFPLUGINCOM__ := 1}

{$I+}
{$SETC CFPlugInCOMIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFPLUGIN__}
{$I CFPlugIn.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{ ================= IUnknown definition (C struct) ================= }
{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFPlugInCOMIncludes}

{$ENDC} {__CFPLUGINCOM__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFPreferences.p
 
     Contains:   CoreFoundation preferences
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFPreferences;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFPREFERENCES__}
{$SETC __CFPREFERENCES__ := 1}

{$I+}
{$SETC CFPreferencesIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}
{$IFC UNDEFINED __CFARRAY__}
{$I CFArray.p}
{$ENDC}
{$IFC UNDEFINED __CFPROPERTYLIST__}
{$I CFPropertyList.p}
{$ENDC}
{$IFC UNDEFINED __CFSTRING__}
{$I CFString.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{
 *  kCFPreferencesAnyApplication
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFPreferencesCurrentApplication
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFPreferencesAnyHost
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFPreferencesCurrentHost
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFPreferencesAnyUser
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{
 *  kCFPreferencesCurrentUser
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
{    The "App" functions search the various sources of defaults that
    apply to the given application, and should never be called with
    kCFPreferencesAnyApplication - only kCFPreferencesCurrentApplication
    or an application's ID (its bundle identifier).
}
{ Searches the various sources of application defaults to find the
value for the given key. key must not be NULL.  If a value is found,
it returns it; otherwise returns NULL.  Caller must release the
returned value }
{
 *  CFPreferencesCopyAppValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPreferencesCopyAppValue(key: CFStringRef; applicationID: CFStringRef): CFPropertyListRef; C;

{ Convenience to interpret a preferences value as a boolean directly.
Returns FALSE if the key doesn't exist, or has an improper format; under
those conditions, keyExistsAndHasValidFormat (if non-NULL) is set to FALSE }
{
 *  CFPreferencesGetAppBooleanValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPreferencesGetAppBooleanValue(key: CFStringRef; applicationID: CFStringRef; VAR keyExistsAndHasValidFormat: BOOLEAN): BOOLEAN; C;

{ Convenience to interpret a preferences value as an integer directly.
Returns 0 if the key doesn't exist, or has an improper format; under
those conditions, keyExistsAndHasValidFormat (if non-NULL) is set to FALSE }
{
 *  CFPreferencesGetAppIntegerValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPreferencesGetAppIntegerValue(key: CFStringRef; applicationID: CFStringRef; VAR keyExistsAndHasValidFormat: BOOLEAN): CFIndex; C;

{ Sets the given value for the given key in the "normal" place for
application preferences.  key must not be NULL.  If value is NULL,
key is removed instead. }
{
 *  CFPreferencesSetAppValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFPreferencesSetAppValue(key: CFStringRef; value: CFPropertyListRef; applicationID: CFStringRef); C;

{ Adds the preferences for the given suite to the app preferences for
the specified application.  To write to the suite domain, use
CFPreferencesSetValue(), below, using the suiteName in place
of the appName }
{
 *  CFPreferencesAddSuitePreferencesToApp()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFPreferencesAddSuitePreferencesToApp(applicationID: CFStringRef; suiteID: CFStringRef); C;

{
 *  CFPreferencesRemoveSuitePreferencesFromApp()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFPreferencesRemoveSuitePreferencesFromApp(applicationID: CFStringRef; suiteID: CFStringRef); C;

{ Writes all changes in all sources of application defaults.
Returns success or failure. }
{
 *  CFPreferencesAppSynchronize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPreferencesAppSynchronize(applicationID: CFStringRef): BOOLEAN; C;

{ The primitive get mechanism; all arguments must be non-NULL
(use the constants above for common values).  Only the exact
location specified by app-user-host is searched.  The returned
CFType must be released by the caller when it is finished with it. }
{
 *  CFPreferencesCopyValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPreferencesCopyValue(key: CFStringRef; applicationID: CFStringRef; userName: CFStringRef; hostName: CFStringRef): CFPropertyListRef; C;

{ Convenience to fetch multiple keys at once.  Keys in
keysToFetch that are not present in the returned dictionary
are not present in the domain.  If keysToFetch is NULL, all
keys are fetched. }
{
 *  CFPreferencesCopyMultiple()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPreferencesCopyMultiple(keysToFetch: CFArrayRef; applicationID: CFStringRef; userName: CFStringRef; hostName: CFStringRef): CFDictionaryRef; C;

{ The primitive set function; all arguments except value must be
non-NULL.  If value is NULL, the given key is removed }
{
 *  CFPreferencesSetValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFPreferencesSetValue(key: CFStringRef; value: CFPropertyListRef; applicationID: CFStringRef; userName: CFStringRef; hostName: CFStringRef); C;

{ Convenience to set multiple values at once.  Behavior is undefined
if a key is in both keysToSet and keysToRemove }
{
 *  CFPreferencesSetMultiple()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFPreferencesSetMultiple(keysToSet: CFDictionaryRef; keysToRemove: CFArrayRef; applicationID: CFStringRef; userName: CFStringRef; hostName: CFStringRef); C;

{
 *  CFPreferencesSynchronize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPreferencesSynchronize(applicationID: CFStringRef; userName: CFStringRef; hostName: CFStringRef): BOOLEAN; C;

{ Constructs and returns the list of the name of all applications
which have preferences in the scope of the given user and host.
The returned value must be released by the caller; neither argument
may be NULL. }
{
 *  CFPreferencesCopyApplicationList()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPreferencesCopyApplicationList(userName: CFStringRef; hostName: CFStringRef): CFArrayRef; C;

{ Constructs and returns the list of all keys set in the given
location.  The returned value must be released by the caller;
all arguments must be non-NULL }
{
 *  CFPreferencesCopyKeyList()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPreferencesCopyKeyList(applicationID: CFStringRef; userName: CFStringRef; hostName: CFStringRef): CFArrayRef; C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFPreferencesIncludes}

{$ENDC} {__CFPREFERENCES__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFPropertyList.p
 
     Contains:   CoreFoundation PropertyList
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFPropertyList;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFPROPERTYLIST__}
{$SETC __CFPROPERTYLIST__ := 1}

{$I+}
{$SETC CFPropertyListIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}
{$IFC UNDEFINED __CFDATA__}
{$I CFData.p}
{$ENDC}
{$IFC UNDEFINED __CFSTRING__}
{$I CFString.p}
{$ENDC}



{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{
    Type to mean any instance of a property list type;
    currently, CFString, CFData, CFNumber, CFBoolean, CFDate,
    CFArray, and CFDictionary.
}

TYPE
	CFPropertyListRef					= CFTypeRef;
	CFPropertyListMutabilityOptions  = SInt32;
CONST
	kCFPropertyListImmutable	= 0;
	kCFPropertyListMutableContainers = 1;
	kCFPropertyListMutableContainersAndLeaves = 2;

	{	
	    Creates a property list object from its XML description; xmlData should
	    be the raw bytes of that description, possibly the contents of an XML
	    file. Returns NULL if the data cannot be parsed; if the parse fails
	    and errorString is non-NULL, a human-readable description of the failure
	    is returned in errorString. It is the caller's responsibility to release
	    either the returned object or the error string, whichever is applicable.
		}
	{
	 *  CFPropertyListCreateFromXMLData()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFPropertyListCreateFromXMLData(allocator: CFAllocatorRef; xmlData: CFDataRef; mutabilityOption: CFOptionFlags; VAR errorString: CFStringRef): CFPropertyListRef; C;

{
    Returns the XML description of the given object; propertyList must
    be one of the supported property list types, and (for composite types
    like CFArray and CFDictionary) must not contain any elements that
    are not themselves of a property list type. If a non-property list
    type is encountered, NULL is returned. The returned data is
    appropriate for writing out to an XML file. Note that a data, not a
    string, is returned because the bytes contain in them a description
    of the string encoding used.
}
{
 *  CFPropertyListCreateXMLData()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPropertyListCreateXMLData(allocator: CFAllocatorRef; propertyList: CFPropertyListRef): CFDataRef; C;

{
    Recursively creates a copy of the given property list (so nested arrays
    and dictionaries are copied as well as the top-most container). The
    resulting property list has the mutability characteristics determined
    by mutabilityOption.
}
{
 *  CFPropertyListCreateDeepCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFPropertyListCreateDeepCopy(allocator: CFAllocatorRef; propertyList: CFPropertyListRef; mutabilityOption: CFOptionFlags): CFPropertyListRef; C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFPropertyListIncludes}

{$ENDC} {__CFPROPERTYLIST__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFSet.p
 
     Contains:   CoreFoundation set collection
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFSet;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFSET__}
{$SETC __CFSET__ := 1}

{$I+}
{$SETC CFSetIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}


{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}


TYPE
{$IFC TYPED_FUNCTION_POINTERS}
	CFSetRetainCallBack = FUNCTION(allocator: CFAllocatorRef; value: UNIV Ptr): Ptr; C;
{$ELSEC}
	CFSetRetainCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFSetReleaseCallBack = PROCEDURE(allocator: CFAllocatorRef; value: UNIV Ptr); C;
{$ELSEC}
	CFSetReleaseCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFSetCopyDescriptionCallBack = FUNCTION(value: UNIV Ptr): CFStringRef; C;
{$ELSEC}
	CFSetCopyDescriptionCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFSetEqualCallBack = FUNCTION(value1: UNIV Ptr; value2: UNIV Ptr): BOOLEAN; C;
{$ELSEC}
	CFSetEqualCallBack = ProcPtr;
{$ENDC}

{$IFC TYPED_FUNCTION_POINTERS}
	CFSetHashCallBack = FUNCTION(value: UNIV Ptr): CFHashCode; C;
{$ELSEC}
	CFSetHashCallBack = ProcPtr;
{$ENDC}

	CFSetCallBacksPtr = ^CFSetCallBacks;
	CFSetCallBacks = RECORD
		version:				CFIndex;
		retain:					CFSetRetainCallBack;
		release:				CFSetReleaseCallBack;
		copyDescription:		CFSetCopyDescriptionCallBack;
		equal:					CFSetEqualCallBack;
		hash:					CFSetHashCallBack;
	END;

	{
	 *  kCFTypeSetCallBacks
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
	{
	 *  kCFCopyStringSetCallBacks
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
{$IFC TYPED_FUNCTION_POINTERS}
	CFSetApplierFunction = PROCEDURE(value: UNIV Ptr; context: UNIV Ptr); C;
{$ELSEC}
	CFSetApplierFunction = ProcPtr;
{$ENDC}

	CFSetRef    = ^LONGINT; { an opaque 32-bit type }
	CFSetRefPtr = ^CFSetRef;  { when a VAR xx:CFSetRef parameter can be nil, it is changed to xx: CFSetRefPtr }
	CFMutableSetRef    = CFSetRef;
	CFMutableSetRefPtr = ^CFMutableSetRef;  { when a VAR xx:CFMutableSetRef parameter can be nil, it is changed to xx: CFMutableSetRefPtr }
	{
	 *  CFSetGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFSetGetTypeID: CFTypeID; C;

{
 *  CFSetCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFSetCreate(allocator: CFAllocatorRef; VAR values: UNIV Ptr; numValues: CFIndex; {CONST}VAR callBacks: CFSetCallBacks): CFSetRef; C;

{
 *  CFSetCreateCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFSetCreateCopy(allocator: CFAllocatorRef; theSet: CFSetRef): CFSetRef; C;

{
 *  CFSetCreateMutable()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFSetCreateMutable(allocator: CFAllocatorRef; capacity: CFIndex; {CONST}VAR callBacks: CFSetCallBacks): CFMutableSetRef; C;

{
 *  CFSetCreateMutableCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFSetCreateMutableCopy(allocator: CFAllocatorRef; capacity: CFIndex; theSet: CFSetRef): CFMutableSetRef; C;

{
 *  CFSetGetCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFSetGetCount(theSet: CFSetRef): CFIndex; C;

{
 *  CFSetGetCountOfValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFSetGetCountOfValue(theSet: CFSetRef; value: UNIV Ptr): CFIndex; C;

{
 *  CFSetContainsValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFSetContainsValue(theSet: CFSetRef; value: UNIV Ptr): BOOLEAN; C;

{
 *  CFSetGetValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFSetGetValue(theSet: CFSetRef; value: UNIV Ptr): Ptr; C;

{
 *  CFSetGetValueIfPresent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFSetGetValueIfPresent(theSet: CFSetRef; candidate: UNIV Ptr; VAR value: UNIV Ptr): BOOLEAN; C;

{
 *  CFSetGetValues()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFSetGetValues(theSet: CFSetRef; VAR values: UNIV Ptr); C;

{
 *  CFSetApplyFunction()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFSetApplyFunction(theSet: CFSetRef; applier: CFSetApplierFunction; context: UNIV Ptr); C;

{
 *  CFSetAddValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFSetAddValue(theSet: CFMutableSetRef; value: UNIV Ptr); C;

{
 *  CFSetReplaceValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFSetReplaceValue(theSet: CFMutableSetRef; value: UNIV Ptr); C;

{
 *  CFSetSetValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFSetSetValue(theSet: CFMutableSetRef; value: UNIV Ptr); C;

{
 *  CFSetRemoveValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFSetRemoveValue(theSet: CFMutableSetRef; value: UNIV Ptr); C;

{
 *  CFSetRemoveAllValues()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFSetRemoveAllValues(theSet: CFMutableSetRef); C;

{$ALIGN RESET}
{$POP}

{$SETC UsingIncludes := CFSetIncludes}

{$ENDC} {__CFSET__}

{$IFC NOT UsingIncludes}
 END.
{$ENDC}
{
     File:       CFString.p
 
     Contains:   CoreFoundation strings
 
     Version:    Technology: Mac OS X
                 Release:    Universal Interfaces 3.4
 
     Copyright:  � 1999-2001 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
 
}
{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
 UNIT CFString;
 INTERFACE
{$ENDC}

{$IFC UNDEFINED __CFSTRING__}
{$SETC __CFSTRING__ := 1}

{$I+}
{$SETC CFStringIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}

{$IFC UNDEFINED __CFBASE__}
{$I CFBase.p}
{$ENDC}
{$IFC UNDEFINED __CFARRAY__}
{$I CFArray.p}
{$ENDC}
{$IFC UNDEFINED __CFDATA__}
{$I CFData.p}
{$ENDC}
{$IFC UNDEFINED __CFDICTIONARY__}
{$I CFDictionary.p}
{$ENDC}



{$PUSH}
{$ALIGN MAC68K}
{$LibExport+}

{
Please note: CFStrings are conceptually an array of Unicode characters.
However, in general, how a CFString stores this array is an implementation
detail. For instance, CFString might choose to use an array of 8-bit characters;
to store its contents; or it might use multiple blocks of memory; or whatever.
Furthermore, the implementation might change depending on the default
system encoding, the user's language, the OS, or even a given release.

What this means is that you should use the following advanced functions with care:

  CFStringGetPascalStringPtr()
  CFStringGetCStringPtr()
  CFStringGetCharactersPtr()

These functions either return the desired pointer quickly, in constant time, or they
return NULL, which indicates you should use some of the other function, as shown
in this example:

    Str255 buffer;
    StringPtr ptr = CFStringGetPascalStringPtr(str, encoding);
    if (ptr == NULL) (
        if (CFStringGetPascalString(str, buffer, 256, encoding)) ptr = buffer;
    )

Note that CFStringGetPascalString call might still return NULL --- but that will happen
in two circumstances only: The conversion from the UniChar contents of CFString
to the specified encoding fails, or the buffer is too small.

If you need a copy of the buffer in the above example, you might consider simply
calling CFStringGetPascalString() in all cases --- CFStringGetPascalStringPtr()
is simply an optimization.

In addition, the following functions, which create immutable CFStrings from developer
supplied buffers without copying the buffers, might have to actually copy
under certain circumstances (If they do copy, the buffer will be dealt with by the
"contentsDeallocator" argument.):

  CFStringCreateWithPascalStringNoCopy()
  CFStringCreateWithCStringNoCopy()
  CFStringCreateWithCharactersNoCopy()

You should of course never depend on the backing store of these CFStrings being
what you provided, and in other no circumstance should you change the contents
of that buffer (given that would break the invariant about the CFString being immutable).

Having said all this, there are actually ways to create a CFString where the backing store
is external, and can be manipulated by the developer or CFString itself:

  CFStringCreateMutableWithExternalCharactersNoCopy()
  CFStringSetExternalCharactersNoCopy()

A "contentsAllocator" is used to realloc or free the backing store by CFString.
kCFAllocatorNull can be provided to assure CFString will never realloc or free the buffer.
Developer can call CFStringSetExternalCharactersNoCopy() to update
CFString's idea of what's going on, if the buffer is changed externally. In these
strings, CFStringGetCharactersPtr() is guaranteed to return the external buffer.

These functions are here to allow wrapping a buffer of UniChar characters in a CFString,
allowing the buffer to passed into CFString functions and also manipulated via CFString
mutation functions. In general, developers should not use this technique for all strings,
as it prevents CFString from using certain optimizations.
}
{ Identifier for character encoding; the values are the same as Text Encoding Converter TextEncoding.
}

TYPE
	CFStringEncoding					= UInt32;
	CFStringEncodingPtr					= ^CFStringEncoding;
	{	 Platform-independent built-in encodings; always available on all platforms.
	   Call CFStringGetSystemEncoding() to get the default system encoding.
		}
	CFStringBuiltInEncodings 	= SInt32;
CONST
	kCFStringEncodingInvalidId	= $FFFFFFFF;
	kCFStringEncodingMacRoman	= 0;
	kCFStringEncodingWindowsLatin1 = $0500;						{  ANSI codepage 1252  }
	kCFStringEncodingISOLatin1	= $0201;						{  ISO 8859-1  }
	kCFStringEncodingNextStepLatin = $0B01;						{  NextStep encoding }
	kCFStringEncodingASCII		= $0600;						{  0..127 (in creating CFString, values greater than 0x7F are treated as corresponding Unicode value)  }
	kCFStringEncodingUnicode	= $0100;						{  kTextEncodingUnicodeDefault  + kTextEncodingDefaultFormat (aka kUnicode16BitFormat)  }
	kCFStringEncodingUTF8		= $08000100;					{  kTextEncodingUnicodeDefault + kUnicodeUTF8Format  }
	kCFStringEncodingNonLossyASCII = $0BFF;						{  7bit Unicode variants used by YellowBox & Java  }

	{	 CFString type ID 	}
	{
	 *  CFStringGetTypeID()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 or later
	 	}
FUNCTION CFStringGetTypeID: CFTypeID; C;

{ Macro to allow creation of compile-time constant strings; the argument should be a constant string.

CFSTR(), not being a "Copy" or "Create" function, does not return a new
reference for you. So, you should not release the return value. This is
much like constant C or Pascal strings --- when you use "hello world"
in a program, you do not free it.

However, strings returned from CFSTR() can be retained and released in a
properly nested fashion, just like any other CF type. That is, if you pass
a CFSTR() return value to a function such as SetMenuItemWithCFString(), the
function can retain it, then later, when it's done with it, it can release it.
}
{** Immutable string creation functions **}
{ Functions to create basic immutable strings. The provided allocator is used for all memory activity in these functions.
}
{ These functions copy the provided buffer into CFString's internal storage. }
{
 *  CFStringCreateWithPascalString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateWithPascalString(alloc: CFAllocatorRef; pStr: Str255; encoding: CFStringEncoding): CFStringRef; C;

{
 *  CFStringCreateWithCString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateWithCString(alloc: CFAllocatorRef; cStr: ConstCStringPtr; encoding: CFStringEncoding): CFStringRef; C;

{
 *  CFStringCreateWithCharacters()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateWithCharacters(alloc: CFAllocatorRef; {CONST}VAR chars: UniChar; numChars: CFIndex): CFStringRef; C;

{ These functions try not to copy the provided buffer. The buffer will be deallocated
with the provided contentsDeallocator when it's no longer needed; to not free
the buffer, specify kCFAllocatorNull here. As usual, NULL means default allocator.
NOTE: Do not count on these buffers as being used by the string;
in some cases the CFString might free the buffer and use something else
(for instance if it decides to always use Unicode encoding internally).
In addition, some encodings are not used internally; in
those cases CFString might also dump the provided buffer and use its own.
}
{
 *  CFStringCreateWithPascalStringNoCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateWithPascalStringNoCopy(alloc: CFAllocatorRef; pStr: Str255; encoding: CFStringEncoding; contentsDeallocator: CFAllocatorRef): CFStringRef; C;

{
 *  CFStringCreateWithCStringNoCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateWithCStringNoCopy(alloc: CFAllocatorRef; cStr: ConstCStringPtr; encoding: CFStringEncoding; contentsDeallocator: CFAllocatorRef): CFStringRef; C;

{
 *  CFStringCreateWithCharactersNoCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateWithCharactersNoCopy(alloc: CFAllocatorRef; {CONST}VAR chars: UniChar; numChars: CFIndex; contentsDeallocator: CFAllocatorRef): CFStringRef; C;

{ Create copies of part or all of the string.
}
{
 *  CFStringCreateWithSubstring()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateWithSubstring(alloc: CFAllocatorRef; str: CFStringRef; range: CFRange): CFStringRef; C;

{
 *  CFStringCreateCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateCopy(alloc: CFAllocatorRef; theString: CFStringRef): CFStringRef; C;

{ Functions to create mutable strings. "maxLength", if not 0, is a hard bound on the length of the string. If 0, there is no limit on the length.
}
{
 *  CFStringCreateMutable()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateMutable(alloc: CFAllocatorRef; maxLength: CFIndex): CFMutableStringRef; C;

{
 *  CFStringCreateMutableCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateMutableCopy(alloc: CFAllocatorRef; maxLength: CFIndex; theString: CFStringRef): CFMutableStringRef; C;

{ This function creates a mutable string that has a developer supplied and directly editable backing store.
The string will be manipulated within the provided buffer (if any) until it outgrows capacity; then the
externalCharactersAllocator will be consulted for more memory. When the CFString is deallocated, the
buffer will be freed with the externalCharactersAllocator. Provide kCFAllocatorNull here to prevent the buffer
from ever being reallocated or deallocated by CFString. See comments at top of this file for more info.
}
{
 *  CFStringCreateMutableWithExternalCharactersNoCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringCreateMutableWithExternalCharactersNoCopy(alloc: CFAllocatorRef; VAR chars: UniChar; numChars: CFIndex; capacity: CFIndex; externalCharactersAllocator: CFAllocatorRef): CFMutableStringRef; C;

{** Basic accessors for the contents **}
{ Number of 16-bit Unicode characters in the string.
}
{
 *  CFStringGetLength()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringGetLength(theString: CFStringRef): CFIndex; C;

{ Extracting the contents of the string. For obtaining multiple characters, calling
CFStringGetCharacters() is more efficient than multiple calls to CFStringGetCharacterAtIndex().
If the length of the string is not known (so you can't use a fixed size buffer for CFStringGetCharacters()),
another method is to use is CFStringGetCharacterFromInlineBuffer() (see further below).
}
{
 *  CFStringGetCharacterAtIndex()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringGetCharacterAtIndex(theString: CFStringRef; idx: CFIndex): UniChar; C;

{
 *  CFStringGetCharacters()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
PROCEDURE CFStringGetCharacters(theString: CFStringRef; range: CFRange; VAR buffer: UniChar); C;

{** Conversion to other encodings **}
{ These two convert into the provided buffer; they return FALSE if conversion isn't possible
(due to conversion error, or not enough space in the provided buffer).
These functions do zero-terminate or put the length byte; the provided bufferSize should include
space for this (so pass 256 for Str255). More sophisticated usages can go through CFStringGetBytes().
These functions are equivalent to calling CFStringGetBytes() with
the range of the string; lossByte = 0; and isExternalRepresentation = FALSE;
if successful, they then insert the leading length of terminating zero, as desired.
}
{
 *  CFStringGetPascalString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringGetPascalString(theString: CFStringRef; buffer: StringPtr; bufferSize: CFIndex; encoding: CFStringEncoding): BOOLEAN; C;

{
 *  CFStringGetCString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringGetCString(theString: CFStringRef; buffer: CStringPtr; bufferSize: CFIndex; encoding: CFStringEncoding): BOOLEAN; C;

{ These functions attempt to return in O(1) time the desired format for the string.
Note that although this means a pointer to the internal structure is being returned,
this can't always be counted on. Please see note at the top of the file for more
details.
}
{
 *  CFStringGetPascalStringPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 or later
 }
FUNCTION CFStringGetPascalStringPtr(theString: CFStringRef; encoding: CFStringEncoding): ConstStringPtr; C;

{ Be prepared for NULL }
{
 *  CFStringGetCStringPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.