The following arguments can be either used in the command line or the `godot_kotlin_configuration.json` file at the root
of the project to customize the behaviour of the Godot Kotlin/JVM binding.

!!! info
    Note that in case the same argument is used in both JSON and command-line, the command-line argument got the priority.


| Command-line                        | Configuration  json           | Default value | Description                                                                                                                                                                                                                                                          | Example                                                                       |
|-------------------------------------|-------------------------------|---------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------|
| --jvm-vm-type                       | vm_type                       | auto          | Defines the VM to run on. Possible values are `auto`, `jvm`, `graal_native_image` and `art`. When set to `graal_native_image` it uses Graal native image. This has no effect on android platform.                                                                    | `--jvm-vm-type=jvm` or `vm-type=jvm`                                          |
| --jvm-use-debug                     | use_debug                     | false         | Defines if the jvm debug server should be started.                                                                                                                                                                                                                   | `--jvm-use_debug` or `use_debug=true`                                         |
| --jvm-debug-port                    | debug_port                    | 5005          | Defines the port to which you can attach a remote debugger. **Note:** the module `jdk.jdwp.agent` is needed in the embedded JRE if you want to debug your application. If you need `jmx`, also the module `jdk.management.agent` is needed                           | `--jvm-debug-port=5005` or `debug-port=5005`                                  |
| --jvm-debug-address                 | debug_address                 | localhost     | Defines which adresses are allowed for debugging                                                                                                                                                                                                                     | `--jvm-debug-address=localhost` or `debug-address=localhost`                  |
| --jvm-wait-for-debugger             | wait_for_debugger             | true          | Accepted values: `true` or `false`. Defines if the jvm should suspend execution until a remote debugger is attached. Only effective if either `--jvm-debug-port` or `--jvm-debug-address` is set                                                                     | `--wait-for-debugger` or `wait-for-debugger=true`                             |
| --jvm-jmx-port                      | jmx_port                      | -1 (disabled) | Defines the jmx port. **Note:** the module `jdk.management.agent` is needed in the embedded JRE to be able to use jmx                                                                                                                                                | `--jvm-jmx-port=5006` or `jmx-port=5006`                                      |
| --jvm-max-string-size               | max_string_size               | 512           | Maximum size of strings sent through the buffer. When above that value, strings are sent with a slower JNI Call. A bigger size means a bigger buffer. Increase if you need a lot of long strings and don't mind using more memory. One buffer exists for each thread | `--jvm-max-string-size=512` or `max-string-size=512`                          |
| --jvm-disable-gc                    | disable_gc                    | false         | Disables our GC. **Caution:** If you disable our GC you **will** have memory leaks as all Reference types and Native Types are not Garbage collected anymore                                                                                                         | `--jvm-disable-gc` or `disable-gc=true`                                       |
| Not available                       | jvm_args                      |               | Allows to set your own arguments for the JVM, make sure they are valid if you don't want the JVM not starting properly. Avoid overlapping with others arguments if you want to set debug or jmx.                                                                     |                                                                               |