The basic project setup is the same as for regular Godot Kotlin/JVM projects.
Head over to the corresponding [getting started](../getting-started/requirements.md) guide to set up the basics of the project.

## Library specific setup

The following configuration properties for customizing the behaviour of your library are available to you in the `build.gradle.kts` file:

| Property                              | default value             | usage                                                                                                                                                                                                                                                                                                                         |
|---------------------------------------|---------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `classPrefix`                         | _not set_                 | Allows you to define a prefix with which each registered class is prefixed. This helps prevent naming conflicts in the users project. Use this if you register classes which names are pretty generic.                                                                                                                        |
| `projectName`                         | _the gradle project name_ | Defines the name of your project. For the user, this is the directory to which the `gdj` registration files are generated to. For example: `gdj/dependencies/<your_library_name>/ARegisteredClassFromYourLibrary.gdj`                                                                                                         |
| `isRegistrationFileGenerationEnabled` | true                      | Defines whether `gdj` files are generated during the build of your library. Safe to turn off if you don't have any sample projects or tests in your library project which depend on these registration files. The registration files for the consumer are not affected. These are generated from special metadata annotaions. |