# How to Contribute

First off, thank you for considering contributing to GEM. It's people like you that make GEM a great tool!

Following these guidelines helps to communicate that you respect the time of the developers managing and developing this open source project. In return, they should reciprocate that respect in addressing your issue, assessing changes, and helping you finalize your pull requests.

## What we are looking for

Improving documentation, bug triaging, or writing tutorials are all helpful contributions we are looking forward to.
Especially submitting bug reports, feature requests, or code which can be incorporated directly into GEM is what we would love to receive.

## Code of Conduct

The goal is to maintain a diverse community that's pleasant for everyone. That's why we would greatly appreciate it if everyone contributing to and interacting with the community also followed our [Code of Conduct](https://github.com/upb-lea/gym-electric-motor/blob/master/CODE_OF_CONDUCT.md).

## Asking for support and requesting features
Please create issues with the __question__ label for support questions and for feature requests.
Even if you want to contribute a new feature yourself please state your intention in the issue tracker first, such that the maintainers can give valuable feedback on how to tackle this in the most appropriate way.

## Reporting Bugs
The best way to report an issue and to ensure a timely response is to use the issue tracker.

* Create a GitHub account. 
    * You need to create a GitHub account to be able to create new issues and participate in the discussion.

* Determine if your bug is really a bug.
    * You shouldn't file a bug if you're requesting support. For that you can use the contact [here](https://ei.uni-paderborn.de/en/lea/team/arbeitsgruppe/team/).

* Make sure your bug hasn't already been reported.
    * Search through the Issue tracker. If a bug like yours was found, check if you have new information that could be reported to help the developers fix the bug.

* Check if you're using the latest version.
    * A bug could be fixed by some other improvements and fixes - it might not have an existing report in the bug tracker. Make sure you're using the latest releases.

* Collect information about the bug.
    * To have the best chance of having a bug fixed, we need to be able to easily reproduce the conditions that caused it. Most of the time this information will be from a Python traceback message, though some bugs might be in design, spelling or other errors on the website/docs/code.

    * If the error is from a Python traceback, include it in the bug report.

    * We also need to know what platform you're running (Windows, macOS, Linux, etc.), the version of your Python interpreter, and the version of GEM, and related packages that you were running when the bug occurred.

    * If you're reporting a race condition or a deadlock, tracebacks can be hard to get or might not be that useful. Try to inspect the process to get more diagnostic data.

    * Your issue might be tagged as Needs Test Case. A test case represents all the details needed to reproduce what your issue is reporting. A test case can be some minimal code that reproduces the issue or detailed instructions and configuration values that reproduces said issue.

* Submit the bug.
    * By default GitHub will email you to let you know when new comments have been made on your bug. In the event you've turned this feature off, you should check back on occasion to ensure you don't miss any questions a developer trying to fix the bug might ask.


## Versions and Tags

Version numbers consists of a major version, minor version and a bug-fix version.

Tags are used exclusively for tagging releases. A release tag is named with the format vX.Y.Z -- for example v2.3.1.
Experimental releases contain an additional identifier vX.Y.Z-id -- for example v3.0.0-rc1.
Experimental tags may be removed after the official release.

