# Text To Speech

## VLSP 2018 Shared Task: Aspect Text-To-Speech Evaluation

* :scroll: [VLSP 2018 Shared Task: Aspect Text-To-Speech Evaluation paper](https://drive.google.com/file/d/1v3Yf3UGjH9HRpPoG3xjxPfo0n3L0icXx/view?usp=sharing)

In order to evaluate the quality of TTS systems, the test set contains 30 numbered sentences in the news domain. These sentences have different length, and contain some information on date, personal name, foreign location name, and some Vietnamese popular abbreviations, etc. The test set are collected from titles of e-newspapers such as dantri.com.vn, vnexpress.net, vietnamnet.vn, etc. on March 7 th , 2018. The TTS test set is released on March 8 th , 2018 at 8:30am. Each registered team can choose to generate speech in one or more dialects of the three regions: Northern, Southern and Central.

### Leaderboard

<table>
  <tr>
    <th rowspan="2">Model</th>
    <th colspan="3">Score</th>
    <th rowspan="2">Paper/Source</th>
    <th rowspan="2">Code</th>
  </tr>
  <tr>
    <td>MOS</td>
    <td>Naturalness</td>
    <td>Intelligibility</td>
  </tr>
  <tr>
    <td>Viettel</td>
    <td>4.66</td>
    <td>91.58</td>
    <td>94.18</td>
    <td><a href="https://drive.google.com/file/d/1FrV6pZmkvj3JLwIXGYm1bFFO1WjBBKs2/view?usp=sharing">Nguyen et al. VLSP'18</a></td>
    <td></td>
  </tr>
  <tr>
    <td>MICA</td>
    <td>3.90</td>
    <td>76.06</td>
    <td>82.10</td>
    <td><a href="https://drive.google.com/file/d/1-gjj71afaoXOa2DKOiLitnHaQI5Bputi/view?usp=sharing">Nguyen et al. VLSP'18</a></td>
    <td></td>
  </tr>
  <tr>
    <td>VAIS</td>
    <td>3.46</td>
    <td>65.96</td>
    <td>72.51</td>
    <td><a href="https://drive.google.com/file/d/1buzfM07HDoyFZwjWVPeGm5GkKEmpOySn/view?usp=sharing">Do et al. VLSP'18</a></td>
    <td></td>
  </tr>
</table>

## Miscellaneous

:file_folder: **Open sources**

* https://github.com/TensorSpeech/TensorFlowTTS
* https://github.com/NTT123/vietTTS
* https://github.com/NTT123/Vietnamese-Text-To-Speech-Dataset
* [Smart Meeting Diarization](http://quochoi.vietcap.org/) - Smart Meeting Diarization *by AILab (2017)* `demo`
* [VOS](http://ailab.hcmus.edu.vn/vosdemo) - Voice of Southern Vietnam *by AILab (2017)* `demo`
* [vaisvn/hts_for_vietnamese](https://bitbucket.org/vaisvn/hts_for_vietnamese) - HTS for Vietnamese *by VAIS (2016)* `perl,bash` `data`

:dizzy: **Services**

* [vbee.vn (2018-)](https://vbee.vn/) 
* [vtcc.ai TTS (2018-)](https://vtcc.ai/tts)
* [OpenFPT: Speech Synthesis (2017-)](http://doc.openfpt.vn/#speech-synthesis)
* [ResponsiveVoice (2017)](https://responsivevoice.org/text-to-speech-languages/van-ban-de-noi-trong-tieng-viet/)

:file_folder: **Dataset**

* [VIVOS](http://ailab.hcmus.edu.vn/vivos/) - a free Vietnamese speech corpus consisting of 15 hours of recording speech *by AILab (2017)* `data`
* [InfoRe1](https://drive.google.com/u/0/uc?id=1Pe-5lKT_lZsliv2WxQDai2mjhI9ZMFlj) - a public access speech corpus consisting of 25 hours of recording speech *by InfoRe (2019)* `data`

