export default function TermsPage() {
	return (
		<main className="mx-auto flex max-w-screen-xl flex-col !gap-4 px-4 md:p-8 ">
			<h1 className="text-4xl">Terms and Conditions</h1>
			<p>Last Updated: 9 September 2023</p>
			<p className="font-bold">
				Please read these terms and conditions carefully before using
				Our Service.
			</p>
			<p className="text-lg font-bold">Interpretation and Definitions</p>
			<p className="font-bold">Interpretation</p>
			<p>
				The words of which the initial letter is capitalized have
				meanings defined under the following conditions. The following
				definitions shall have the same meaning regardless of whether
				they appear in singular or in plural.
			</p>
			<p className="font-bold">Definitions</p>

			<p>For the purposes of these Terms and Conditions:</p>

			<p>
				<span className="font-bold">Affiliate</span> means an entity
				that controls, is controlled by, or is under common control with
				a party, where &quot;control&quot; means ownership of 50% or
				more of the shares, equity interest, or other securities
				entitled to vote for the election of directors or other managing
				authority.
			</p>

			<p>
				<span className="font-bold">Country</span> refers to: New York,
				United States
			</p>

			<p>
				<span className="font-bold">Owner</span> (referred to as either
				&quot;the Owner,&quot; &quot;We,&quot; &quot;Us,&quot; or
				&quot;Our&quot; in this Agreement) refers to Umut YILDIRIM
			</p>

			<p>
				<span className="font-bold">Device</span> means any device that
				can access the Service, such as a computer, a cellphone, or a
				digital tablet.
			</p>

			<p>
				<span className="font-bold">Service</span> refers to the
				Website.
			</p>

			<p>
				<span className="font-bold">Terms and Conditions</span> (also
				referred to as &quot;Terms&quot;) mean these Terms and
				Conditions that form the entire agreement between You and the
				Owner regarding the use of the Service.
			</p>

			<p>
				<span className="font-bold">
					Third-party Social Media Service
				</span>{" "}
				means any services or content (including data, information,
				products, or services) provided by a third-party that may be
				displayed, included, or made available by the Service.
			</p>

			<p>
				<span className="font-bold">Website</span> refers to MarkAI,
				accessible from markai.umutyildirim.com
			</p>

			<p>
				<span className="font-bold">You</span> means the individual
				accessing or using the Service, or the Owner, or other legal
				entity on behalf of which such individual is accessing or using
				the Service, as applicable.
			</p>

			<p className="font-bold">Acknowledgment</p>
			<p>
				These are the Terms and Conditions governing the use of this
				Service and the agreement that operates between You and the
				Owner. These Terms and Conditions set out the rights and
				obligations of all users regarding the use of the Service.
			</p>

			<p>
				Your access to and use of the Service is conditioned on Your
				acceptance of and compliance with these Terms and Conditions.
				These Terms and Conditions apply to all visitors, users, and
				others who access or use the Service.
			</p>

			<p>
				By accessing or using the Service, You agree to be bound by
				these Terms and Conditions. If You disagree with any part of
				these Terms and Conditions, then You may not access the Service.
			</p>

			<p>
				Your access to and use of the Service is also conditioned on
				Your acceptance of and compliance with the Privacy Policy of the
				Owner. Our Privacy Policy describes Our policies and procedures
				on the collection, use, and disclosure of Your personal
				information when You use the Application or the Website and
				tells You about Your privacy rights and how the law protects
				You. Please read Our Privacy Policy carefully before using Our
				Service.
			</p>

			<p className="font-bold">Refund Policy</p>
			<p>
				By using this site and buying credits, you agree to our refund
				policy and will not seek to ask for refunds if you are unhappy
				with the results of your AI-generated icons or brand names. You
				understand the limitations of AI art. Some of these limitations
				include an inability to generate letters and characters, often
				misinterprets prompts, often might have deformed results, etc.
				When buying credits, you accept the risk that some AI-generated
				icons or brand names may not be perfect. By using this site you
				might have to pay additional fees to your bank.
			</p>

			<p className="font-bold">Links to Other Websites</p>
			<p>
				Our Service may contain links to third-party websites or
				services that are not owned or controlled by the Owner.
			</p>

			<p>
				The Owner has no control over, and assumes no responsibility
				for, the content, privacy policies, or practices of any
				third-party websites or services. You further acknowledge and
				agree that the Owner shall not be responsible or liable,
				directly or indirectly, for any damage or loss caused or alleged
				to be caused by or in connection with the use of or reliance on
				any such content, goods, or services available on or through any
				such websites or services.
			</p>

			<p>
				We strongly advise You to read the terms and conditions and
				privacy policies of any third-party websites or services that
				You visit.
			</p>

			<p className="font-bold">Icon and Brand Generation</p>
			<p>
				We can use your icons or brand names to promote our service.
				This includes, but is not limited to: online ads, physical ads,
				social media posts, and anywhere inside this application.
			</p>

			<p className="font-bold">Termination</p>
			<p>
				We may terminate or suspend Your access immediately, without
				prior notice or liability, for any reason whatsoever, including
				without limitation if You breach these Terms and Conditions.
			</p>

			<p>
				Upon termination, Your right to use the Service will cease
				immediately.
			</p>

			<p className="font-bold">Limitation of Liability</p>
			<p>
				Our service uses AI provided by OpenAI to generate brand names.
				Please review copyright laws for your country and state in
				regards to AI generated art or images. By using our services,
				you agree that our Owner and service assume no responsibility
				for the images generated. Nor do we assume responsibility for
				damages or loss caused by these images.
			</p>

			<p>
				Notwithstanding any damages that You might incur, the entire
				liability of the Owner and any of its suppliers under any
				provision of this Terms and Your exclusive remedy for all of the
				foregoing shall be limited to the amount actually paid by You
				through the Service or 100 USD if You haven&apos;t purchased
				anything through the Service.
			</p>

			<p>
				To the maximum extent permitted by applicable law, in no event
				shall the Owner or its suppliers be liable for any special,
				incidental, indirect, or consequential damages whatsoever
				(including, but not limited to, damages for loss of profits,
				loss of data or other information, for business interruption,
				for personal injury, loss of privacy arising out of or in any
				way related to the use of or inability to use the Service,
				third-party software and/or third-party hardware used with the
				Service, or otherwise in connection with any provision of this
				Terms), even if the Owner or any supplier has been advised of
				the possibility of such damages and even if the remedy fails of
				its essential purpose.
			</p>

			<p>
				Some states do not allow the exclusion of implied warranties or
				limitation of liability for incidental or consequential damages,
				which means that some of the above limitations may not apply. In
				these states, each party&apos;s liability will be limited to the
				greatest extent permitted by law.
			</p>

			<p className="font-bold">
				&quot;AS IS&quot; and &quot;AS AVAILABLE&quot; Disclaimer
			</p>
			<p>
				The Service is provided to You &quot;AS IS&quot; and &quot;AS
				AVAILABLE&quot; and with all faults and defects without warranty
				of any kind. To the maximum extent permitted under applicable
				law, the Owner, on its own behalf and on behalf of its
				Affiliates and its and their respective licensors and service
				providers, expressly disclaims all warranties, whether express,
				implied, statutory or otherwise, with respect to the Service,
				including all implied warranties of merchantability, fitness for
				a particular purpose, title and non-infringement, and warranties
				that may arise out of course of dealing, course of performance,
				usage or trade practice. Without limitation to the foregoing,
				the Owner provides no warranty or undertaking, and makes no
				representation of any kind that the Service will meet Your
				requirements, achieve any intended results, be compatible or
				work with any other software, applications, systems or services,
				operate without interruption, meet any performance or
				reliability standards or be error free or that any errors or
				defects can or will be corrected.
			</p>

			<p>
				Without limiting the foregoing, neither the Owner nor any of the
				Owner&apos;s provider makes any representation or warranty of
				any kind, express or implied: (i) as to the operation or
				availability of the Service, or the information, content, and
				materials or products included thereon; (ii) that the Service
				will be uninterrupted or error-free; (iii) as to the accuracy,
				reliability, or currency of any information or content provided
				through the Service; or (iv) that the Service, its servers, the
				content, or e-mails sent from or on behalf of the Owner are free
				of viruses, scripts, trojan horses, worms, malware, timebombs or
				other harmful components.
			</p>

			<p>
				Some jurisdictions do not allow the exclusion of certain types
				of warranties or limitations on applicable statutory rights of a
				consumer, so some or all of the above exclusions and limitations
				may not apply to You. But in such a case the exclusions and
				limitations set forth in this section shall be applied to the
				greatest extent enforceable under applicable law.
			</p>

			<p className="font-bold">Governing Law</p>
			<p>
				The laws of the Country, excluding its conflicts of law rules,
				shall govern this Terms and Your use of the Service. Your use of
				the Application may also be subject to other local, state,
				national, or international laws.
			</p>

			<p className="font-bold">Disputes Resolution</p>
			<p>
				If You have any concern or dispute about the Service, You agree
				to first try to resolve the dispute informally by contacting the
				Owner.
			</p>

			<p className="font-bold">For European Union (EU) Users</p>
			<p>
				If You are a European Union consumer, you will benefit from any
				mandatory provisions of the law of the country in which you are
				resident in.
			</p>

			<p className="font-bold">United States Legal Compliance</p>
			<p>
				You represent and warrant that (i) You are not located in a
				country that is subject to the United States government embargo
				or that has been designated by the United States government as a
				&quot;terrorist supporting&quot; country, and (ii) You are not
				listed on any United States government list of prohibited or
				restricted parties.
			</p>

			<p className="font-bold">Severability and Waiver</p>

			<p>
				<span className="font-bold">Severability</span>
			</p>
			<p>
				If any provision of these Terms is held to be unenforceable or
				invalid, such provision will be changed and interpreted to
				accomplish the objectives of such provision to the greatest
				extent possible under applicable law, and the remaining
				provisions will continue in full force and effect.
			</p>

			<p>
				<span className="font-bold">Waiver</span>
			</p>
			<p>
				Except as provided herein, the failure to exercise a right or to
				require performance of an obligation under these Terms shall not
				affect a party&apos;s ability to exercise such right or require
				such performance at any time thereafter nor shall the waiver of
				a breach constitute a waiver of any subsequent breach.
			</p>

			<p className="font-bold">Translation Interpretation</p>
			<p>
				These Terms and Conditions may have been translated if We have
				made them available to You on our Service. You agree that the
				original English text shall prevail in the case of a dispute.
			</p>

			<p className="font-bold">Changes to These Terms and Conditions</p>
			<p>
				We reserve the right, at Our sole discretion, to modify or
				replace these Terms at any time. If a revision is material We
				will make reasonable efforts to provide at least 30 days&apos;
				notice prior to any new terms taking effect. What constitutes a
				material change will be determined at Our sole discretion.
			</p>

			<p>
				By continuing to access or use Our Service after those revisions
				become effective, You agree to be bound by the revised terms. If
				You do not agree to the new terms, in whole or in part, please
				stop using the website and the Service.
			</p>

			<p className="font-bold">Contact Us</p>
			<p>
				If you have any questions about these Terms and Conditions, You
				can contact us:
			</p>
			<a href="mailto:info@umutyildirim.com" className="text-success">
				info@umutyildirim.com
			</a>
		</main>
	);
}
