# MarkAI - Another RAG template

![License](https://img.shields.io/github/license/umuthopeyildirim/markai)

MarkAI is a AI-platform that guides you on your employees to be more efficient. It is a platform that you can ask questions to your AI and get answers from your documents. We designed it to be serverless and scalable. It is a platform that you can use for your company or personal use.

## Key Features 🎯

-   **Fast and Efficient**: Designed with speed and efficiency at its core. MarkAI ensures rapid access to your data.
-   **Secure**: Your data, your control. Always.
-   **File Compatibility**: Text, Markdown, HTML
-   **Open Source**: Freedom is beautiful, and so is MarkAI. Open source and free to use.
-   **Public/Private**: Invite your team to collaborate, or keep your data private.

![MarkAI](./docs/images/Vector.png)

## Setup 🛠

Just follow the instructions on the [setup.md](docs/setup.md).

## Used Technologies

-   [Clerk](https://clerk.com) for authentication
-   [Supabase](https://supabase.com) for database and vector search
-   [LangChain](https://www.langchain.com/) for Agents and Embeddings
-   [Cloudflare](https://cloudflare.com) (Optional) for custom domain and AI Gateway(Monitoring)
-   [Vercel](https://vercel.com) for deployment, CI/CD and serverless functions
-   [OpenAI](https://openai.com) for AI API calls
-   [TailwindCSS](https://tailwindcss.com) for styling
-   [Next.js](https://nextjs.org) for frontend
-   [NextUI](https://nextui.org) for UI components

## Contributing

If you encounter a bug or have a feature request, please open an issue. If you want to contribute code, fork this repository and make a pull request.

## Contributors ✨

Thanks go to these wonderful people:

<a href="https://github.com/umuthopeyildirim/markai/graphs/contributors">
<img src="https://contrib.rocks/image?repo=umuthopeyildirim/markai" />
</a>

## Stars History 📈

<a href="https://star-history.com/#umuthopeyildirim/markai&Timeline">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=umuthopeyildirim/markai&type=Timeline&theme=dark" />
    <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=umuthopeyildirim/markai&type=Timeline" />
    <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=umuthopeyildirim/markai&type=Timeline" />
  </picture>
</a>
