<!--
## x.x.x (unreleased)

-->

## 0.8.2 (2023/04/04)

- 構造体のサポート。
- 配列のサポート。
- 文字型と文字リテラルのサポート。
- 意味解析エラー検出処理の改善。
- ビルトイン関数をリニューアルしました。(詳細は下記)
- CLI: 段階的にプロジェクト機能をサポート。
- JavaScript APIでソースコードを直接実行する機能の廃止。
- CLI: `run`コマンドに`--check-skip`オプションが追加されました。
- CLI: `check`コマンドが追加されました。
- CLI: `new`コマンドが追加されました。
- 意味解析のバグ修正。
- CLI: バージョン情報が表示できない問題を修正。

### ビルトイン関数のリニューアル

以下のビルトイン関数が追加されました。
- `number.parse`
- `char.fromNumber`
- `char.toNumber`
- `char.toString`
- `string.fromChars`
- `string.toChars`
- `array.insert`
- `array.add`
- `array.removeAt`
- `array.count`
- `console.read`

以下のビルトイン関数の名前が変更になりました。
- `toString` -> `number.toString`
- `assertEqNum` -> `number.assertEq`
- `concatStr` -> `string.concat`
- `assertEqStr` -> `string.assertEq`
- `printStr` -> `console.write`
- `printNum` -> `console.writeNum`

## 0.7.0 (2023/03/13)

- 実装がRustからNode.jsに移行されました。
- `string`型を追加
- 文字列リテラルを追加。例 `"hello"`
- ビルトイン関数を廃止: `printLF` `assertEq`
- ビルトイン関数を追加: `printStr` `concatStr` `toString` `assertEqNum` `assertEqStr`
- 構文: bool型では大小関係の比較は出来ないように仕様を変更。

## 0.6.0 (2023/02/10)

- CLI: `run`サブコマンドからスクリプトを実行するように変わりました。`$ uguisu run <filename>`
- 構文: 変数宣言のキーワードが`var`に変わりました。`const`や`let`は変数宣言のキーワードとしては使用できなくなりました。
- 命名にキャメルケースが使用されるようになりました。  
  ビルトイン関数の名前が変更になります:
  - `print_num` → `printNum`
  - `print_lf` → `printLF`
  - `assert_eq` → `assertEq`
- 実行エンジン: 型チェックを改善しました。
- 構文: 変数宣言の初期値の代入を後から行えるようになりました。
- 実行エンジン: パフォーマンスが向上しました。
- ビルトイン関数「getUnixtime」が追加されました。
- 実行エンジン: 静的解析の処理が大きく変更されました。
- CLI: runサブコマンドに内部向けのオプションがいくつか追加されました。

## 0.5.0 (2023/02/01)

- 演算子が追加されました: `%` `&&` `||` `!`
- 代入文の種類が増えました: `%=`
- 文法に関するドキュメントがdocsディレクトリに移動されました。
- ビルトイン関数「print_num」は改行しないように動作が変更されました。
- ビルトイン関数「print_lf」が追加されました。
- ほとんどの文法エラーで、そのエラーが発生した位置が表示されるようになりました。
- 変数宣言のセミコロンの前に任意のスペースを挿入できないバグを修正しました。
- 既に廃止された関数宣言の属性である「External」がコードから削除されました。

## 0.4.0 (2023/01/27)

- コメント構文が利用できるようになりました。`// single-line comment` `/* multi-line comment */`
- 一部のエラーで、そのエラーが発生した位置が表示されるようになりました。
- 一部のエラーメッセージが改善されました。
- 内部的な型「void」が追加されました。ユーザーは明示的に指定できませんが、関数の戻り値がない場合にUguisuの実行エンジンにより使用されます。
- バグ修正 #32

## 0.3.0 (2023/01/26)

- 代入文の種類が増えました: `+=` `-=` `*=` `/=`
- 各種エラーメッセージが改善されました。

## 0.2.1 (2023/01/25)

- CLI: オプションのパース処理がより良くなりました。
- 算術演算のオーバーフローに関する改善が行われました。

## 0.2.0 (2023/01/24)

- `loop`文が追加されました。
- `break`文が追加されました。
- CLIコマンドの表示が改善されました。
- バイナリファイルの名前が「uguisu-cli」から「uguisu」に変わりました。

## 0.1.0 (2023/01/23)

Initial release.
