# Change Log

## 2.11.0

### Minor Changes

- 8c619c6: Add `rewriteUnknownContent` helper, which can strip your editor JSON of content which is invalid within the current editor's schema

### Patch Changes

- 283e606: Fixed an issue on Android where the focus command would cause the keyboard to flash
- ca6269e: Added support for drag-and-drop between multiple editors
- e0dfecc: Updates the typings to be inline with prosemirror-view #5867
- 722ec00: Use an `AllSelection` for the `selectAll` command #5516
- b7ef150: Fixed an issue with nodeviews preventing any drag events in child nodes of the nodeview wrapper element

## 2.10.4

## 2.10.3

### Patch Changes

- 7c6774e: Updates the typings to be inline with Prosemirror-view #5867

## 2.10.2

### Patch Changes

- e7f143d: This reverts typings that were causing issues for users #5859

## 2.10.1

### Patch Changes

- 87d63d8: Update TypeScript types to allow options to be optional

## 2.10.0

### Minor Changes

- 7619215: Previously, only a json representation of the node could be inserted into the editor. This change allows for the insertion of Prosemirror `Node`s and `Fragment`s directly into the editor through the `insertContentAt`, `setContent` and `insertContent` commands.

### Patch Changes

- 7619215: preserve existing node attributes when running setNode
- 7619215: Addresses a bug with `insertContentAt`'s `simulatedPasteRules` option where it could only accept text and not Prosemirror `Node` and `Content`
- 7619215: Updates the types of `addOptions` and `addStorage` to have the parent be possibly undefined which is the most accurate typing
- 7619215: feat: add `once` to EventEmitters
- 7619215: Add Node `linebreakReplacement` support and enable on hard-break nodes
- 7619215: Improve handling of selections with `updateAttributes`. Should no longer modify parent nodes of the same type.
- 2ea807d: getMarkRange would greedily match more content than it should have if it was the same type of mark, now it will match only the mark at the position #3872

## 2.9.1

## 2.9.0

### Patch Changes

- ffb51d3: insertContentAt, setContent, and insertContent commands now respect the editor's pre-defined parseOptions configuration if the command does not specify it's own parseOptions
- 873a67c: This allows the Editor isntance to unregister multiple plugins in a single editor state replacement
- d96f679: Fixed an issue while updating attributes on a NodePos that was not a text
- e606c06: Updates the typings of `DecorationsWithTypes` to be more accurate to the prosemirror implementation even though it is not completely exposed as an API
- a2eea24: Added role and aria-label attributes to the contenteditable field for better screenreader support and mouseless controls
- d96f679: Fixed issues with NodePos child positions causing wrong positions when used on non-text atoms
- 4efd227: Fixed an issue with getMarkRange not returning the correct range when cursor is at the start of the specified mark

## 2.8.0

### Minor Changes

- 6834a7f: Bundling of packages no longer includes tiptap dependency type definitions

### Patch Changes

- 8ee534d: This refactors the `onDrop` and `onPaste` event callbacks to be Tiptap extensions rather than separate Prosemirror plugins which was forcing the editor to recreate the view on initialization.

## 2.7.4

### Patch Changes

- 7ef401d: This plugs a memory leak where there is a circular reference between the view's DOM node and the editor instance, to resolve this, before destroying the view we need to delete the reference to the editor instance on the DOM node #5654

## 2.7.3

### Patch Changes

- f76515a: Update the typing for NodeViewProps to be an interface rather than a concrete type #5632
- d57ee51: filter rendered extensionAttributes (#5588)

## 2.7.2

## 2.7.1

### Patch Changes

- 888f574: Fixed Slice import in DropPlugin

## 2.7.0

### Minor Changes

- 97ea55f: Fixes #5490. The `preventClearDocument` meta tag can now be used to prevent the `clearDocument` plugin in the core keymap extension from modifying transactions that appear to clear the document (but might be clearing it for other reasons).
- 9e18d24: Added `onPaste` and `onDrop` options to the editor allowing for easier event binding for both cases
- 97ea55f: An object can now be passed to `enableCoreExtensions` to allow disabling only specific core extensions.

### Patch Changes

- f805333: fix: check for schema's nesting rules on contentCheck
- 07fa49d: Copy over node attributes on node toggling (for example to keep text styles while toggling a headline)
- 7f24a66: Update the Typescript types for NodeViews, bringing them inline with there actual implementation
- a22767e: Merging inline style attributes now can properly merge conflicting style attribute names, resulting in cleaner HTML output and correctness

## 2.7.0-pre.0

### Minor Changes

- 97ea55f: Fixes #5490. The `preventClearDocument` meta tag can now be used to prevent the `clearDocument` plugin in the core keymap extension from modifying transactions that appear to clear the document (but might be clearing it for other reasons).
- 9e18d24: Added `onPaste` and `onDrop` options to the editor allowing for easier event binding for both cases
- 97ea55f: An object can now be passed to `enableCoreExtensions` to allow disabling only specific core extensions.

### Patch Changes

- f805333: fix: check for schema's nesting rules on contentCheck
- 07fa49d: Copy over node attributes on node toggling (for example to keep text styles while toggling a headline)
- 7f24a66: Update the Typescript types for NodeViews, bringing them inline with there actual implementation
- a22767e: Merging inline style attributes now can properly merge conflicting style attribute names, resulting in cleaner HTML output and correctness
- Updated dependencies [bd34793]
  - @tiptap/pm@2.7.0-pre.0

## 2.6.6

### Patch Changes

- 8d8d999: fix: check for schema's nesting rules on contentCheck
  - @tiptap/pm@2.6.6

## 2.6.5

### Patch Changes

- @tiptap/pm@2.6.5

## 2.6.4

### Patch Changes

- @tiptap/pm@2.6.4

## 2.6.3

### Patch Changes

- da76972: Resolve several selection related bug #2690 #5208
  - @tiptap/pm@2.6.3

## 2.6.2

### Patch Changes

- @tiptap/pm@2.6.2

## 2.6.1

### Patch Changes

- @tiptap/pm@2.6.1

## 2.6.0

### Minor Changes

- 86a8553: Add `getContent` to nodePasteRules to allow specifying inner content to a created node
- 222f2ac: Add the ability to add new attributes to a splitted list item
- e31673d: This PR significantly improves the performance of React NodeViews in a couple of ways:

  - It now uses useSyncExternalStore to synchronize changes between React & the editor instance
  - It dramatically reduces the number of re-renders by re-using instances of React portals that have already been initialized and unaffected by the change made in the editor

  We were seeing performance problems with React NodeViews because a change to one of them would cause a re-render to all instances of node views. For an application that heavily relies on node views in React, this was quite expensive.
  This should dramatically cut down on the number of instances that have to re-render, and, making each of those re-renders much less costly.

### Patch Changes

- @tiptap/pm@2.6.0

## 2.5.9

### Patch Changes

- 84ebd51: Fix change criteria for isNodeEmpty to resolve #5415
- 0ec0af6: fix(core): findDuplicates - use Array.from when converting Set
- ae0254d: Add `ignoreWhitespace` option to `isNodeEmpty` to ignore any whitespace and hardbreaks in a node to check for emptiness
- efb27fa: This fixes a discrepency between `getMarksBetween` and `isActive(markName)` where the position used for getMarksBetween was off by one
  - @tiptap/pm@2.5.9

## 2.5.8

### Patch Changes

- a08bf85: This fixes a bug with inputrules not being able to resolve positions properly
  - @tiptap/pm@2.5.8

## 2.5.7

### Patch Changes

- b012471: This addresses an issue with `isNodeEmpty` function where it was also comparing node attributes and finding mismatches on actually empty nodes. This helps placeholders find empty content correctly
- cc3497e: Fixes a bug where if `enableContentCheck` was true, inserting content as JSON nodes would fail. This was because the node that was being created technically had a different schema than the content being inserted, so it would fail to generate the correct content value
  - @tiptap/pm@2.5.7

## 2.5.6

### Patch Changes

- 618bca9: Adjust the `splitBlock` command to return `false` when it was unsuccessful.
- 35682d1: This fixes a bug with the placeholder extension where a heading level other than the default was not considered empty, when comparing node contents, we need to consider that the node attributes are carried over for a fair comparison of content instead of attribute values
- 2104f0f: Add a check beforecreateNodeViews so that view.setProps is not called when the view has already been destroyed
- Updated dependencies [b5c1b32]
  - @tiptap/pm@2.5.6

## 2.5.5

### Patch Changes

- 4cca382: Make sure that atoms are used in-full without cutting the content. Node size for atoms is 1 which causes text to be cut unexpectedly.
- 3b67e8a: This changes the typing to not declare types on all HTMLElements, just a local one with the editor instance attached
  - @tiptap/pm@2.5.5

## 2.5.4

### Patch Changes

- dd7f9ac: There was an issue with the cjs bundling of packages and default exports, now we resolve default exports in legacy compatible way
- Updated dependencies [dd7f9ac]
  - @tiptap/pm@2.5.4

## 2.5.3

### Patch Changes

- @tiptap/pm@2.5.3

## 2.5.2

### Patch Changes

- 07f4c03: There was a bug where doing a `.configure` on an extension, node or mark would overwrite the extensions options instead of being merged with the default options.
  - @tiptap/pm@2.5.2

## 2.5.1

### Patch Changes

- @tiptap/pm@2.5.1

## 2.5.0

### Patch Changes

- fb45149: Made some minor changes to how packages are built
- fb45149: When `parseOptions.whitespace === 'full' or parseOptions.whitespace === true` setting content will no longer strip whitespaces on setContent
- fb45149: Faster performance for checking if a node is empty and if something is a fragment
- fb45149: Vue 3 bubble menus are properly synchronized with state transitions with the new beforeTransaction hook which is fired before the transaction is applied to the view
  - @tiptap/pm@2.5.0

## 2.5.0-pre.16

### Patch Changes

- @tiptap/pm@2.5.0-pre.16

## 2.5.0-pre.15

### Patch Changes

- @tiptap/pm@2.5.0-pre.15

## 2.5.0-pre.14

### Patch Changes

- @tiptap/pm@2.5.0-pre.14

## 2.5.0-pre.13

### Patch Changes

- 74a37ff: CI build testing
  - @tiptap/pm@2.5.0-pre.13

## 2.5.0-pre.12

### Patch Changes

- 74a37ff: CI build testing
  - @tiptap/pm@2.5.0-pre.12

## 2.5.0-pre.11

### Patch Changes

- 74a37ff: CI build testing
  - @tiptap/pm@2.5.0-pre.11

## 2.5.0-pre.10

### Patch Changes

- 74a37ff: CI build testing
  - @tiptap/pm@2.5.0-pre.10

## 2.5.0-pre.9

### Patch Changes

- 14a00f4: Made some minor changes to how packages are built
  - @tiptap/pm@2.5.0-pre.9

## 2.5.0-pre.8

### Patch Changes

- 509676e: Vue 3 bubble menus are properly synchronized with state transitions with the new beforeTransaction hook which is fired before the transaction is applied to the view
  - @tiptap/pm@2.5.0-pre.8

## 2.5.0-pre.7

### Patch Changes

- @tiptap/pm@2.5.0-pre.7

---

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [2.4.0](https://github.com/ueberdosis/tiptap/compare/v2.3.2...v2.4.0) (2024-05-14)

### Bug Fixes

- **core:** configure should use the parent of the current instance, to avoid duplication ([#5147](https://github.com/ueberdosis/tiptap/issues/5147)) ([4db463c](https://github.com/ueberdosis/tiptap/commit/4db463c6bbcc3a17ee8eb591bea8e357120ecb35))

### Features

- added jsdocs ([#4356](https://github.com/ueberdosis/tiptap/issues/4356)) ([b941eea](https://github.com/ueberdosis/tiptap/commit/b941eea6daba09d48a5d18ccc1b9a1d84b2249dd))

## [2.3.2](https://github.com/ueberdosis/tiptap/compare/v2.3.1...v2.3.2) (2024-05-08)

### Bug Fixes

- NodePos querySelectorAll function ([#5094](https://github.com/ueberdosis/tiptap/issues/5094)) ([4900a27](https://github.com/ueberdosis/tiptap/commit/4900a27c5389d9a2d0d69f407ca3db0155304315))

## [2.3.1](https://github.com/ueberdosis/tiptap/compare/v2.3.0...v2.3.1) (2024-04-30)

**Note:** Version bump only for package @tiptap/core

# [2.3.0](https://github.com/ueberdosis/tiptap/compare/v2.2.6...v2.3.0) (2024-04-09)

### Bug Fixes

- **core:** fix nodepos child lookup ([#5038](https://github.com/ueberdosis/tiptap/issues/5038)) ([22ced31](https://github.com/ueberdosis/tiptap/commit/22ced318723003365fbfd8f59b8dac79c7563017))

### Features

- **core:** apply input and paste rules when using insertContent methods ([#5046](https://github.com/ueberdosis/tiptap/issues/5046)) ([96b6abc](https://github.com/ueberdosis/tiptap/commit/96b6abcf6edbc6cac03a391130d9feebb6de3a04))

## [2.2.6](https://github.com/ueberdosis/tiptap/compare/v2.2.5...v2.2.6) (2024-04-06)

### Bug Fixes

- unexpected renderText() for contentful nodes ([#3410](https://github.com/ueberdosis/tiptap/issues/3410)) ([d6c71a8](https://github.com/ueberdosis/tiptap/commit/d6c71a838d590f78fdff15c805d93f43c8a5a1a5))

## [2.2.5](https://github.com/ueberdosis/tiptap/compare/v2.2.4...v2.2.5) (2024-04-05)

**Note:** Version bump only for package @tiptap/core

## [2.2.4](https://github.com/ueberdosis/tiptap/compare/v2.2.3...v2.2.4) (2024-02-23)

### Bug Fixes

- typecheck drag and clipboard events for testing environments ([bbee9a3](https://github.com/ueberdosis/tiptap/commit/bbee9a3c3090fa40bf366591682b42a3f6ec5f91))

## [2.2.3](https://github.com/ueberdosis/tiptap/compare/v2.2.2...v2.2.3) (2024-02-15)

**Note:** Version bump only for package @tiptap/core

## [2.2.2](https://github.com/ueberdosis/tiptap/compare/v2.2.1...v2.2.2) (2024-02-07)

**Note:** Version bump only for package @tiptap/core

## [2.2.1](https://github.com/ueberdosis/tiptap/compare/v2.2.0...v2.2.1) (2024-01-31)

**Note:** Version bump only for package @tiptap/core

# [2.2.0](https://github.com/ueberdosis/tiptap/compare/v2.1.16...v2.2.0) (2024-01-29)

### Bug Fixes

- **core:** fix new lines being added via elementFromString ([#4767](https://github.com/ueberdosis/tiptap/issues/4767)) ([b7a2504](https://github.com/ueberdosis/tiptap/commit/b7a2504f16f46563537c890930cb2c332c256175))
- fix bug [#4785](https://github.com/ueberdosis/tiptap/issues/4785) ([#4836](https://github.com/ueberdosis/tiptap/issues/4836)) ([f3cba1e](https://github.com/ueberdosis/tiptap/commit/f3cba1e0b0288156c1427437e5a0b9e03cd67e63))
- fix imports, fix demos, unpin y-prosemirror ([681aa57](https://github.com/ueberdosis/tiptap/commit/681aa577bff500015c3f925e300c55a71c73efaf))
- fix newline stripping via insertContent ([8954007](https://github.com/ueberdosis/tiptap/commit/8954007b2b92b040d69b26a0866ae58fabf5e512))

# [2.2.0-rc.8](https://github.com/ueberdosis/tiptap/compare/v2.1.14...v2.2.0-rc.8) (2024-01-08)

### Bug Fixes

- **core:** fix options now being empty ([fc67cb1](https://github.com/ueberdosis/tiptap/commit/fc67cb1b7166c1ab6b6e0174539c9e29c364eace))

# [2.2.0-rc.7](https://github.com/ueberdosis/tiptap/compare/v2.2.0-rc.6...v2.2.0-rc.7) (2023-11-27)

### Bug Fixes

- **core:** set defaultOptions to undefined by default ([448b433](https://github.com/ueberdosis/tiptap/commit/448b433ee7847bfba4cd803d8c8820763ceedafc))

# [2.2.0-rc.6](https://github.com/ueberdosis/tiptap/compare/v2.2.0-rc.5...v2.2.0-rc.6) (2023-11-23)

# [2.2.0-rc.4](https://github.com/ueberdosis/tiptap/compare/v2.1.11...v2.2.0-rc.4) (2023-10-10)

# [2.2.0-rc.3](https://github.com/ueberdosis/tiptap/compare/v2.2.0-rc.2...v2.2.0-rc.3) (2023-08-18)

# [2.2.0-rc.1](https://github.com/ueberdosis/tiptap/compare/v2.2.0-rc.0...v2.2.0-rc.1) (2023-08-18)

# [2.2.0-rc.0](https://github.com/ueberdosis/tiptap/compare/v2.1.5...v2.2.0-rc.0) (2023-08-18)

## [2.1.16](https://github.com/ueberdosis/tiptap/compare/v2.1.15...v2.1.16) (2024-01-10)

### Bug Fixes

- **core:** fix new lines being added via elementFromString ([#4767](https://github.com/ueberdosis/tiptap/issues/4767)) ([2235908](https://github.com/ueberdosis/tiptap/commit/2235908c28f388eda041d1d5d017554d513fe909))

## [2.1.15](https://github.com/ueberdosis/tiptap/compare/v2.1.14...v2.1.15) (2024-01-08)

### Bug Fixes

- **core:** fix insertContentAt keeping new lines in html content ([#4465](https://github.com/ueberdosis/tiptap/issues/4465)) ([135a12f](https://github.com/ueberdosis/tiptap/commit/135a12f7aa2df839a0b619704110a360b980c738))

## [2.1.14](https://github.com/ueberdosis/tiptap/compare/v2.1.13...v2.1.14) (2024-01-08)

**Note:** Version bump only for package @tiptap/core

## [2.1.13](https://github.com/ueberdosis/tiptap/compare/v2.1.12...v2.1.13) (2023-11-30)

**Note:** Version bump only for package @tiptap/core

## [2.1.12](https://github.com/ueberdosis/tiptap/compare/v2.1.11...v2.1.12) (2023-10-11)

**Note:** Version bump only for package @tiptap/core

## [2.1.11](https://github.com/ueberdosis/tiptap/compare/v2.1.10...v2.1.11) (2023-09-20)

### Reverts

- Revert "v2.2.11" ([6aa755a](https://github.com/ueberdosis/tiptap/commit/6aa755a04b9955fc175c7ab33dee527d0d5deef0))

## [2.1.10](https://github.com/ueberdosis/tiptap/compare/v2.1.9...v2.1.10) (2023-09-15)

**Note:** Version bump only for package @tiptap/core

## [2.1.9](https://github.com/ueberdosis/tiptap/compare/v2.1.8...v2.1.9) (2023-09-14)

**Note:** Version bump only for package @tiptap/core

## [2.1.8](https://github.com/ueberdosis/tiptap/compare/v2.1.7...v2.1.8) (2023-09-04)

**Note:** Version bump only for package @tiptap/core

## [2.1.7](https://github.com/ueberdosis/tiptap/compare/v2.1.6...v2.1.7) (2023-09-04)

**Note:** Version bump only for package @tiptap/core

## [2.1.6](https://github.com/ueberdosis/tiptap/compare/v2.1.5...v2.1.6) (2023-08-18)

### Bug Fixes

- **core:** fix broken export ([4227f32](https://github.com/ueberdosis/tiptap/commit/4227f324a5bfd4f0905c70ac8ea68903352f911b))

## [2.1.5](https://github.com/ueberdosis/tiptap/compare/v2.1.4...v2.1.5) (2023-08-18)

**Note:** Version bump only for package @tiptap/core

## [2.1.4](https://github.com/ueberdosis/tiptap/compare/v2.1.3...v2.1.4) (2023-08-18)

### Bug Fixes

- replace the whole node in nodeInputRule ([#4341](https://github.com/ueberdosis/tiptap/issues/4341)) ([ffeefe2](https://github.com/ueberdosis/tiptap/commit/ffeefe21ff3c1f951a5a4f9ae9697317ddd1c5ad))

## [2.1.3](https://github.com/ueberdosis/tiptap/compare/v2.1.2...v2.1.3) (2023-08-18)

**Note:** Version bump only for package @tiptap/core

## [2.1.2](https://github.com/ueberdosis/tiptap/compare/v2.1.1...v2.1.2) (2023-08-17)

### Bug Fixes

- **core:** fix error when merging class attributes ([#4340](https://github.com/ueberdosis/tiptap/issues/4340)) ([a251946](https://github.com/ueberdosis/tiptap/commit/a2519468589e2baa44901a66a3a06b24dc8626d6))

## [2.1.1](https://github.com/ueberdosis/tiptap/compare/v2.1.0...v2.1.1) (2023-08-16)

**Note:** Version bump only for package @tiptap/core

# [2.1.0](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.14...v2.1.0) (2023-08-16)

**Note:** Version bump only for package @tiptap/core

# [2.1.0-rc.14](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.13...v2.1.0-rc.14) (2023-08-11)

**Note:** Version bump only for package @tiptap/core

# [2.1.0-rc.13](https://github.com/ueberdosis/tiptap/compare/v2.0.4...v2.1.0-rc.13) (2023-08-11)

# [2.1.0-rc.12](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.11...v2.1.0-rc.12) (2023-07-14)

# [2.1.0-rc.11](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.10...v2.1.0-rc.11) (2023-07-07)

### Bug Fixes

- **core:** fix cut and insertContentAt functions ([#4187](https://github.com/ueberdosis/tiptap/issues/4187)) ([6b65af8](https://github.com/ueberdosis/tiptap/commit/6b65af8fc31ffbbcf79b89bfdaceee7aadbf3f27))

# [2.1.0-rc.10](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.9...v2.1.0-rc.10) (2023-07-07)

# [2.1.0-rc.9](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.8...v2.1.0-rc.9) (2023-06-15)

# [2.1.0-rc.8](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.7...v2.1.0-rc.8) (2023-05-25)

# [2.1.0-rc.5](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.4...v2.1.0-rc.5) (2023-05-25)

### Features

- add tiptap class ([614fc80](https://github.com/ueberdosis/tiptap/commit/614fc8082c376bf3c40a05c23ceda6b4a6fbf8d0))

# [2.1.0-rc.4](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.3...v2.1.0-rc.4) (2023-04-27)

# [2.1.0-rc.3](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.2...v2.1.0-rc.3) (2023-04-26)

### Bug Fixes

- **core:** remove configure from extend functionality ([4af54da](https://github.com/ueberdosis/tiptap/commit/4af54da3e09c69c0b5326f9952d456436855914d))

# [2.1.0-rc.2](https://github.com/ueberdosis/tiptap/compare/v2.0.3...v2.1.0-rc.2) (2023-04-26)

# [2.1.0-rc.1](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.0...v2.1.0-rc.1) (2023-04-12)

# [2.1.0-rc.0](https://github.com/ueberdosis/tiptap/compare/v2.0.2...v2.1.0-rc.0) (2023-04-05)

### Bug Fixes

- clear nodes when cursor at start of empty isolating parent ([#3943](https://github.com/ueberdosis/tiptap/issues/3943)) ([7278ee2](https://github.com/ueberdosis/tiptap/commit/7278ee2b05de2f96efddf3b1dc3bfd3d52262cbb))
- **lists:** improve list behaviour ([684e48a](https://github.com/ueberdosis/tiptap/commit/684e48a4a7778a0140c94f0c5345db868174ad81))
- Update peerDependencies to fix lerna version tasks ([#3914](https://github.com/ueberdosis/tiptap/issues/3914)) ([0c1bba3](https://github.com/ueberdosis/tiptap/commit/0c1bba3137b535776bcef95ff3c55e13f5a2db46))

# [2.1.0-rc.12](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.11...v2.1.0-rc.12) (2023-07-14)

**Note:** Version bump only for package @tiptap/core

# [2.1.0-rc.11](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.10...v2.1.0-rc.11) (2023-07-07)

### Bug Fixes

- **core:** fix cut and insertContentAt functions ([#4187](https://github.com/ueberdosis/tiptap/issues/4187)) ([6b65af8](https://github.com/ueberdosis/tiptap/commit/6b65af8fc31ffbbcf79b89bfdaceee7aadbf3f27))

# [2.1.0-rc.10](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.9...v2.1.0-rc.10) (2023-07-07)

**Note:** Version bump only for package @tiptap/core

# [2.1.0-rc.9](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.8...v2.1.0-rc.9) (2023-06-15)

### Bug Fixes

- **lists:** improve list behaviour ([684e48a](https://github.com/ueberdosis/tiptap/commit/684e48a4a7778a0140c94f0c5345db868174ad81))

# [2.1.0-rc.8](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.7...v2.1.0-rc.8) (2023-05-25)

**Note:** Version bump only for package @tiptap/core

# [2.1.0-rc.7](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.6...v2.1.0-rc.7) (2023-05-25)

**Note:** Version bump only for package @tiptap/core

# [2.1.0-rc.6](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.5...v2.1.0-rc.6) (2023-05-25)

**Note:** Version bump only for package @tiptap/core

# [2.1.0-rc.5](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.4...v2.1.0-rc.5) (2023-05-25)

### Features

- add tiptap class ([614fc80](https://github.com/ueberdosis/tiptap/commit/614fc8082c376bf3c40a05c23ceda6b4a6fbf8d0))

# [2.1.0-rc.4](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.3...v2.1.0-rc.4) (2023-04-27)

**Note:** Version bump only for package @tiptap/core

# [2.1.0-rc.3](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.2...v2.1.0-rc.3) (2023-04-26)

### Bug Fixes

- **core:** remove configure from extend functionality ([4af54da](https://github.com/ueberdosis/tiptap/commit/4af54da3e09c69c0b5326f9952d456436855914d))

# [2.1.0-rc.2](https://github.com/ueberdosis/tiptap/compare/v2.0.3...v2.1.0-rc.2) (2023-04-26)

# [2.1.0-rc.1](https://github.com/ueberdosis/tiptap/compare/v2.1.0-rc.0...v2.1.0-rc.1) (2023-04-12)

# [2.1.0-rc.0](https://github.com/ueberdosis/tiptap/compare/v2.0.2...v2.1.0-rc.0) (2023-04-05)

### Bug Fixes

- clear nodes when cursor at start of empty isolating parent ([#3943](https://github.com/ueberdosis/tiptap/issues/3943)) ([7278ee2](https://github.com/ueberdosis/tiptap/commit/7278ee2b05de2f96efddf3b1dc3bfd3d52262cbb))
- Update peerDependencies to fix lerna version tasks ([#3914](https://github.com/ueberdosis/tiptap/issues/3914)) ([0c1bba3](https://github.com/ueberdosis/tiptap/commit/0c1bba3137b535776bcef95ff3c55e13f5a2db46))

# [2.1.0-rc.0](https://github.com/ueberdosis/tiptap/compare/v2.0.2...v2.1.0-rc.0) (2023-04-05)

### Bug Fixes

- clear nodes when cursor at start of empty isolating parent ([#3943](https://github.com/ueberdosis/tiptap/issues/3943)) ([7278ee2](https://github.com/ueberdosis/tiptap/commit/7278ee2b05de2f96efddf3b1dc3bfd3d52262cbb))

## [2.0.3](https://github.com/ueberdosis/tiptap/compare/v2.0.2...v2.0.3) (2023-04-13)

**Note:** Version bump only for package @tiptap/core

## [2.0.2](https://github.com/ueberdosis/tiptap/compare/v2.0.1...v2.0.2) (2023-04-03)

**Note:** Version bump only for package @tiptap/core

## [2.0.1](https://github.com/ueberdosis/tiptap/compare/v2.0.0...v2.0.1) (2023-03-30)

### Bug Fixes

- Update peerDependencies to fix lerna version tasks ([#3914](https://github.com/ueberdosis/tiptap/issues/3914)) ([0534f76](https://github.com/ueberdosis/tiptap/commit/0534f76401bf5399c01ca7f39d87f7221d91b4f7))

# [2.0.0-beta.220](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.219...v2.0.0-beta.220) (2023-02-28)

### Bug Fixes

- **core:** fix destroyed view causing errors on dispatchTransaction ([#3799](https://github.com/ueberdosis/tiptap/issues/3799)) ([3c07ca0](https://github.com/ueberdosis/tiptap/commit/3c07ca0b9c48cef60d56acdd44812e20e05fc928))

# [2.0.0-beta.219](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.218...v2.0.0-beta.219) (2023-02-27)

### Bug Fixes

- [#3773](https://github.com/ueberdosis/tiptap/issues/3773) - Array for content breaks editor ([#3786](https://github.com/ueberdosis/tiptap/issues/3786)) ([89cc59a](https://github.com/ueberdosis/tiptap/commit/89cc59a8372467feee7c70948d4395b95b13ed55))
- **core:** allow insertContentAt and insertContent text node arrays ([#3790](https://github.com/ueberdosis/tiptap/issues/3790)) ([0300630](https://github.com/ueberdosis/tiptap/commit/0300630a5b04b61d4eef8155f24ca0ef2d683966))
- update typings for node view decorations ([#3783](https://github.com/ueberdosis/tiptap/issues/3783)) ([f869507](https://github.com/ueberdosis/tiptap/commit/f8695073968c5c6865ad8faf05351020abb2a3cc))

### Features

- [#3540](https://github.com/ueberdosis/tiptap/issues/3540) Ability to preserve marks on lists ([#3541](https://github.com/ueberdosis/tiptap/issues/3541)) ([36bb1e1](https://github.com/ueberdosis/tiptap/commit/36bb1e1041f91da6437272e7196702df868eae0f))

# [2.0.0-beta.218](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.217...v2.0.0-beta.218) (2023-02-18)

### Bug Fixes

- Prevent drag event from being ignored ([#3677](https://github.com/ueberdosis/tiptap/issues/3677)) ([2b6e4e3](https://github.com/ueberdosis/tiptap/commit/2b6e4e369130466387ab1136e10ad64f6e37df5b))

# [2.0.0-beta.217](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.216...v2.0.0-beta.217) (2023-02-09)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.216](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.215...v2.0.0-beta.216) (2023-02-08)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.215](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.214...v2.0.0-beta.215) (2023-02-08)

### Bug Fixes

- fix builds including prosemirror ([a380ec4](https://github.com/ueberdosis/tiptap/commit/a380ec41d198ebacc80cea9e79b0a8aa3092618a))

# [2.0.0-beta.214](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.213...v2.0.0-beta.214) (2023-02-08)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.213](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.212...v2.0.0-beta.213) (2023-02-07)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.212](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.211...v2.0.0-beta.212) (2023-02-03)

### Bug Fixes

- **core:** fix broken types in definition file ([f659037](https://github.com/ueberdosis/tiptap/commit/f659037d52b91a6534513faaa5046409dc84c808))

# [2.0.0-beta.211](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.210...v2.0.0-beta.211) (2023-02-02)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.210](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.209...v2.0.0-beta.210) (2023-02-02)

### Features

- **pm:** new prosemirror package for dependency resolving ([f387ad3](https://github.com/ueberdosis/tiptap/commit/f387ad3dd4c2b30eaea33fb0ba0b42e0cd39263b))

# [2.0.0-beta.209](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.208...v2.0.0-beta.209) (2022-12-16)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.208](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.207...v2.0.0-beta.208) (2022-12-16)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.207](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.206...v2.0.0-beta.207) (2022-12-08)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.206](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.205...v2.0.0-beta.206) (2022-12-08)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.205](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.204...v2.0.0-beta.205) (2022-12-05)

### Bug Fixes

- **core:** implement deleteCurrentNode command & fix node joining on Delete key ([#3192](https://github.com/ueberdosis/tiptap/issues/3192)) ([ef8a1a2](https://github.com/ueberdosis/tiptap/commit/ef8a1a2f3d94f60cbdb73f03179b89ece0539560))

### Features

- **commands:** add joinUp and joinDown command ([#3455](https://github.com/ueberdosis/tiptap/issues/3455)) ([343ce75](https://github.com/ueberdosis/tiptap/commit/343ce756a8e0efccadddcd05d5a1b414135d009a))

# [2.0.0-beta.204](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.203...v2.0.0-beta.204) (2022-11-25)

### Bug Fixes

- **core:** rename esm modules to esm.js ([c1a0c3a](https://github.com/ueberdosis/tiptap/commit/c1a0c3ae43baac9dd5ed90903d3a0d4eaeea7702))

# [2.0.0-beta.203](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.202...v2.0.0-beta.203) (2022-11-24)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.202](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.201...v2.0.0-beta.202) (2022-11-04)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.201](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.200...v2.0.0-beta.201) (2022-11-04)

### Reverts

- Revert "Fixed dragged text not being deleted after drop on another editor (#3279)" ([403b99c](https://github.com/ueberdosis/tiptap/commit/403b99cd1ad4fa00721158fe7195674fc01b642c)), closes [#3279](https://github.com/ueberdosis/tiptap/issues/3279)

# [2.0.0-beta.200](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.199...v2.0.0-beta.200) (2022-11-04)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.199](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.198...v2.0.0-beta.199) (2022-09-30)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.198](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.197...v2.0.0-beta.198) (2022-09-29)

### Bug Fixes

- **core:** InputRules does not work for ranges containing multiple text nodes ([#3205](https://github.com/ueberdosis/tiptap/issues/3205)) ([2f9ba32](https://github.com/ueberdosis/tiptap/commit/2f9ba324a03868283cf467520f99bd2a1596375a)), closes [#3071](https://github.com/ueberdosis/tiptap/issues/3071)

# [2.0.0-beta.197](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.196...v2.0.0-beta.197) (2022-09-26)

### Bug Fixes

- **core:** Can() does not work for setting marks ([#3223](https://github.com/ueberdosis/tiptap/issues/3223)) ([17a41da](https://github.com/ueberdosis/tiptap/commit/17a41da5a7a14879cf490c81914084791c4c494c))

# [2.0.0-beta.196](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.195...v2.0.0-beta.196) (2022-09-20)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.195](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.194...v2.0.0-beta.195) (2022-09-14)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.194](https://github.com/ueberdosis/tiptap/compare/v2.0.0-beta.193...v2.0.0-beta.194) (2022-09-11)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.193](https://github.com/ueberdosis/tiptap/compare/v0.1.2...v2.0.0-beta.193) (2022-09-10)

### Bug Fixes

- add attributes to pre tag instead of code tag by default, fix [#2440](https://github.com/ueberdosis/tiptap/issues/2440) ([85fcc29](https://github.com/ueberdosis/tiptap/commit/85fcc29ac6ef9e07847d5e0a5cdd318f4300a832))
- add correct type for parseOptions ([592892e](https://github.com/ueberdosis/tiptap/commit/592892edd1c4d6dbaa9ea3ddd21f4615f0087053))
- add correct windows and px keymap ([75e5601](https://github.com/ueberdosis/tiptap/commit/75e56017676ac7905c41b87d54b7f099d0290eeb))
- add CreateNodeFromContentOptions to insertContent ([#1678](https://github.com/ueberdosis/tiptap/issues/1678)) ([aabdfd6](https://github.com/ueberdosis/tiptap/commit/aabdfd6f7de65e62a57bd237eb775256b413abea))
- add exports to package.json ([1277fa4](https://github.com/ueberdosis/tiptap/commit/1277fa47151e9c039508cdb219bdd0ffe647f4ee))
- add marks to JSONContent type ([f829b45](https://github.com/ueberdosis/tiptap/commit/f829b45bf018aa769780a9987a1b2cdaaad8a44a))
- add missing ProseMirror styles ([12602e7](https://github.com/ueberdosis/tiptap/commit/12602e77ef5d35b430d3d14b93788b327a0f17da))
- add scrollIntoView for insertContent ([e7fe724](https://github.com/ueberdosis/tiptap/commit/e7fe7248af44df66fe322045953f8df186d82bec))
- add support for CellSelection in isActive helper, fix [#1947](https://github.com/ueberdosis/tiptap/issues/1947) ([b42e442](https://github.com/ueberdosis/tiptap/commit/b42e442a5af167f78edb5252dd8dbdcb8e0a96ed))
- add support for multiple ranges in clipboardTextSerializer, fix [#1982](https://github.com/ueberdosis/tiptap/issues/1982) ([98a1cb3](https://github.com/ueberdosis/tiptap/commit/98a1cb36408765f0f042e7abb8dad3c19cdf0a09))
- add support for priority and nested extension for getSchema ([129ad83](https://github.com/ueberdosis/tiptap/commit/129ad83167900526d65c5c25da8249d0d65bcef7))
- add topNode to getDebugJSON ([f65e1b3](https://github.com/ueberdosis/tiptap/commit/f65e1b32a16c25622c2d507e74dd0dde9dac9376))
- add way to cancel inputrules and pasterules ([#2368](https://github.com/ueberdosis/tiptap/issues/2368)) ([669efd0](https://github.com/ueberdosis/tiptap/commit/669efd00e9a508bbb4d6275d47092470b2e16561))
- allow input rules after hard break, fix [#2302](https://github.com/ueberdosis/tiptap/issues/2302) ([ded6f96](https://github.com/ueberdosis/tiptap/commit/ded6f9618fb588f2c259edc9bc77415f8723431c))
- allow to re-apply current mark for input rules and paste rules, fix [#2003](https://github.com/ueberdosis/tiptap/issues/2003) ([3958bf1](https://github.com/ueberdosis/tiptap/commit/3958bf1c226621142e9216c8eda91a70b71a211a))
- better merge mark attributes for existing marks, fix [#1039](https://github.com/ueberdosis/tiptap/issues/1039) ([cfd29fa](https://github.com/ueberdosis/tiptap/commit/cfd29fac86e03d72a0c05ec8d26aac905d19c5a2))
- call selectAll on 'cmd+a', set a TextSelection instead of AllSelection, fix [#1908](https://github.com/ueberdosis/tiptap/issues/1908) ([bad16d9](https://github.com/ueberdosis/tiptap/commit/bad16d9f3a9f47db83ad170c6de4d6ff11dba007))
- check for atom nodes in ignoreMutation handler, fix [#1448](https://github.com/ueberdosis/tiptap/issues/1448) ([2deb07f](https://github.com/ueberdosis/tiptap/commit/2deb07fb005d4376790d1e22b3fc53353d1665eb))
- check for excluded marks in isMarkActive, fix [#1388](https://github.com/ueberdosis/tiptap/issues/1388) ([3c4cc96](https://github.com/ueberdosis/tiptap/commit/3c4cc96fee7fc32e363d3b8a2503684435f30c35))
- check for invalid content in `insertContentAt` command ([e09fd93](https://github.com/ueberdosis/tiptap/commit/e09fd93e59dbae5bca9da7def6ddafc6beda9987))
- check for NodeSelection within posToDOMRect ([a4ec4ff](https://github.com/ueberdosis/tiptap/commit/a4ec4ffcfd855894b0fa780f9f72f87399e36402))
- check for storedMarks in getMarkAttributes, fix [#2039](https://github.com/ueberdosis/tiptap/issues/2039) ([22c82ba](https://github.com/ueberdosis/tiptap/commit/22c82ba61fe14db19e1049dfcf9bef0b7abb796d))
- **core:** :bug: fix inputrule not recognizing text content of non-text leaf nodes ([64b23e1](https://github.com/ueberdosis/tiptap/commit/64b23e120c0d4906573079923fddae3271f58918))
- **core:** createCan command props shouldn't try dispatch ([#3025](https://github.com/ueberdosis/tiptap/issues/3025)) ([#3026](https://github.com/ueberdosis/tiptap/issues/3026)) ([40f4ea3](https://github.com/ueberdosis/tiptap/commit/40f4ea31efc59c1578b783a5b64572ac2846c5a6))
- **core:** dont use selection for setContent replacement ([#2934](https://github.com/ueberdosis/tiptap/issues/2934)) ([134a4bd](https://github.com/ueberdosis/tiptap/commit/134a4bd1fbbd7f56faa1fc70c97d3b58554fc3f1))
- **core:** fix focus command passing through editor state instead of existing transaction ([5b0b7d9](https://github.com/ueberdosis/tiptap/commit/5b0b7d91023c87e9ddb85ff3a776273d12a22d16))
- **core:** Increment `i` in `defaultBlockAt` ([655957d](https://github.com/ueberdosis/tiptap/commit/655957d73304f57d87b8e95d89de00da762c0fa9))
- **core:** insert PasteRule Node at matched position ([#2942](https://github.com/ueberdosis/tiptap/issues/2942)) ([#2943](https://github.com/ueberdosis/tiptap/issues/2943)) ([bda6e8d](https://github.com/ueberdosis/tiptap/commit/bda6e8d3083074337b2d39fbb5d20d02bb942f63))
- **core:** isNodeSelection, isTextSelection not always false ([#3089](https://github.com/ueberdosis/tiptap/issues/3089)) ([574cd69](https://github.com/ueberdosis/tiptap/commit/574cd69e06bfdc3771006ed4eda341a6c9722a42)), closes [#2979](https://github.com/ueberdosis/tiptap/issues/2979)
- **core:** make setEditable trigger all 'update' listeners ([#3140](https://github.com/ueberdosis/tiptap/issues/3140)) ([4851fc5](https://github.com/ueberdosis/tiptap/commit/4851fc5e9b6daccc15a1839e471db489401eca0c))
- **core:** make setEditable trigger onUpdate function ([#2935](https://github.com/ueberdosis/tiptap/issues/2935)) ([de1253a](https://github.com/ueberdosis/tiptap/commit/de1253a8b06eeb7339f0bba8c04917890c9b21ae))
- **core:** only respect text of node before current position ([#2937](https://github.com/ueberdosis/tiptap/issues/2937)) ([#2941](https://github.com/ueberdosis/tiptap/issues/2941)) ([e280a02](https://github.com/ueberdosis/tiptap/commit/e280a02597d15460fce97a7555f91ff04926f0e7))
- **core:** setNodeSelection should not clamp pos by Selection.atStart/atEnd ([#3091](https://github.com/ueberdosis/tiptap/issues/3091)) ([313b8b8](https://github.com/ueberdosis/tiptap/commit/313b8b8d0af7059c420ffc96c9362f0f4acc2138)), closes [#3090](https://github.com/ueberdosis/tiptap/issues/3090)
- do not apply paste rules for ProseMirror HTML ([9d281e9](https://github.com/ueberdosis/tiptap/commit/9d281e9e998a5cfa9ca1002ad428caf1cee59682))
- do not check for node selection within posToDOMRect ([c0e68d5](https://github.com/ueberdosis/tiptap/commit/c0e68d5a25608e0b6d9c127bbc507b4ba2a94a61))
- don't override behaviour of Home / End in pc keymap ([d270419](https://github.com/ueberdosis/tiptap/commit/d270419ad8dc6182a949c5d263c47e90ee4466ff))
- don't remove the tiptap styles on destroy, fix [#2120](https://github.com/ueberdosis/tiptap/issues/2120), fix [#2143](https://github.com/ueberdosis/tiptap/issues/2143) ([a0a88ac](https://github.com/ueberdosis/tiptap/commit/a0a88acd13ee221587834def8d2655ac13233f27))
- don’t add tabindex when readonly, fix [#2458](https://github.com/ueberdosis/tiptap/issues/2458) ([01411f8](https://github.com/ueberdosis/tiptap/commit/01411f8462e8a36f96e56cdba227a9e5bb3e1812))
- don’t check for active node in wrapIn command, fix [#1059](https://github.com/ueberdosis/tiptap/issues/1059) ([170ec4b](https://github.com/ueberdosis/tiptap/commit/170ec4be5b3c8362890ca3100a223b505f788381))
- don’t merge classes ([dba0c1a](https://github.com/ueberdosis/tiptap/commit/dba0c1ac15e9beda3ebd027c67c969a4fe7ae7c7))
- fix a bug in detecting a current list in toggleList command ([a35b253](https://github.com/ueberdosis/tiptap/commit/a35b2533eb87c683c0bff56b574aff490f490980))
- fix a bug in markPasteRule ([c2ccf68](https://github.com/ueberdosis/tiptap/commit/c2ccf68e8b4c869f707f3b1fdf51474e7f64b6f3))
- fix a bug that messed up pasted link attributes, fix [#1284](https://github.com/ueberdosis/tiptap/issues/1284) ([7da647d](https://github.com/ueberdosis/tiptap/commit/7da647d99f1dcefabc653347a8e2abfae3bb972e))
- fix a bug when configurating the same extension multiple times ([655c564](https://github.com/ueberdosis/tiptap/commit/655c5647f0951851f818a0cc2500c48969f20797))
- fix a bug when detecting changes within node views ([708ac94](https://github.com/ueberdosis/tiptap/commit/708ac94cebce2ed9304ae7e87eb4c3251758f903))
- fix a bug when dragging node views ([4e6d43b](https://github.com/ueberdosis/tiptap/commit/4e6d43bbfb488d2987f71ad15732af8d25b9897a))
- fix a bug when insert newline at node start, fix [#1411](https://github.com/ueberdosis/tiptap/issues/1411) ([b97bebe](https://github.com/ueberdosis/tiptap/commit/b97bebe021e6e587770cb99f94b18ee6d96c1630))
- fix a bug when parsing attributes if no parseHTML method is provided, fix [#2058](https://github.com/ueberdosis/tiptap/issues/2058) ([5da313a](https://github.com/ueberdosis/tiptap/commit/5da313a5480db011374ffd236159e2aedc011b97))
- fix a bug where paste rules doesn’t worked at the start of the document, see [#1225](https://github.com/ueberdosis/tiptap/issues/1225) ([ff67ee1](https://github.com/ueberdosis/tiptap/commit/ff67ee1da380d8308e85fa4b0386ea6947ec7ff1))
- fix adding mark only with insertContent(), fix [#264](https://github.com/ueberdosis/tiptap/issues/264) ([0a63123](https://github.com/ueberdosis/tiptap/commit/0a6312382f38af5b8fdf7f94fc4b6c1de1a15e25))
- fix End key handler, fix [#2446](https://github.com/ueberdosis/tiptap/issues/2446) ([b584920](https://github.com/ueberdosis/tiptap/commit/b584920ea172bc9f5207b8d03cb2b7f80925a5be))
- fix error when calculating contentMatch within clearNodes command, fix [#1361](https://github.com/ueberdosis/tiptap/issues/1361) ([3709668](https://github.com/ueberdosis/tiptap/commit/370966847efd7bbc1b033cf5952f2427e62c1525))
- fix export for getAttributes ([5b8808a](https://github.com/ueberdosis/tiptap/commit/5b8808a89990b808d7f84c004a07e14b046c12b9))
- fix extension name for clipboardTextSerializer ([15f90ec](https://github.com/ueberdosis/tiptap/commit/15f90ec5916460359827f7073e5c36147867fef7))
- fix extension option merging ([aa002a0](https://github.com/ueberdosis/tiptap/commit/aa002a012bfe888c03da5cd32f98b40965a5fa7b))
- fix focus on iOS, fix [#1806](https://github.com/ueberdosis/tiptap/issues/1806) ([3a06938](https://github.com/ueberdosis/tiptap/commit/3a0693869d10793620e0073b0782dd34ac5aea89))
- fix fragile schema validity test in splitBlock ([e52f41a](https://github.com/ueberdosis/tiptap/commit/e52f41ae7864210bc0e4107db21e09607d2e586f))
- fix isEditable check on initialization ([f6f8cf9](https://github.com/ueberdosis/tiptap/commit/f6f8cf9f9366adbea30600a34619bdd4e6d3a4e4))
- fix mappes positions for paste rules, fix [#2002](https://github.com/ueberdosis/tiptap/issues/2002) ([770c4e1](https://github.com/ueberdosis/tiptap/commit/770c4e18e19504f4c44feb85b7d202fcc5201b12))
- fix merging options on configure for multiple extension instances ([d037c56](https://github.com/ueberdosis/tiptap/commit/d037c5656a113ac7205104a815310727b23c30d4))
- fix missing extensions when using `addExtension`, fix [#1309](https://github.com/ueberdosis/tiptap/issues/1309) ([28737b1](https://github.com/ueberdosis/tiptap/commit/28737b1631719315cebc354f7cb5a1d924b0b543))
- fix onBeforeCreate event handler, fix [#1236](https://github.com/ueberdosis/tiptap/issues/1236) ([0b67f18](https://github.com/ueberdosis/tiptap/commit/0b67f18e3a109609cd9b2371396c5f6b8ed85f96))
- fix order of executed plugins, fix [#1547](https://github.com/ueberdosis/tiptap/issues/1547) ([f8efdf7](https://github.com/ueberdosis/tiptap/commit/f8efdf797a10a01235b75091729b15aca076e47a))
- fix RangeError bug when selecting all text, fix [#2490](https://github.com/ueberdosis/tiptap/issues/2490) ([70422dd](https://github.com/ueberdosis/tiptap/commit/70422dd107ed1ecdd8dfe41a8a93297124d2f1e0))
- fix removing the caret on blur in some situations when using safari, fix [#2405](https://github.com/ueberdosis/tiptap/issues/2405) ([9d31712](https://github.com/ueberdosis/tiptap/commit/9d317128a08a66f18c4d51385b6a9fccc5cd66f4))
- fix some react focus issues ([#1724](https://github.com/ueberdosis/tiptap/issues/1724)), fix [#1716](https://github.com/ueberdosis/tiptap/issues/1716), fix [#1608](https://github.com/ueberdosis/tiptap/issues/1608), fix [#1520](https://github.com/ueberdosis/tiptap/issues/1520) ([956566e](https://github.com/ueberdosis/tiptap/commit/956566eaad0a522d6bc27d44594aa36d6c33f8b3))
- fix storage context when using configure ([ef254ce](https://github.com/ueberdosis/tiptap/commit/ef254cead7b9be052ec0211849fb78ae577095dd))
- fix type error for commands ([26785db](https://github.com/ueberdosis/tiptap/commit/26785dbec00cbb3dc3196bd9a7cbebb7452e4a2e))
- fix type for emitUpdate, fix [#276](https://github.com/ueberdosis/tiptap/issues/276) ([4137e00](https://github.com/ueberdosis/tiptap/commit/4137e00d987c152b883022525056df94ad033be7))
- fix type for insertContent command ([4295c6b](https://github.com/ueberdosis/tiptap/commit/4295c6bd2181bdaa98ef7777bfab44efbcf22a32))
- fix updating editorProps via setOptions ([#1540](https://github.com/ueberdosis/tiptap/issues/1540)), fix [#1518](https://github.com/ueberdosis/tiptap/issues/1518) ([e6f67ca](https://github.com/ueberdosis/tiptap/commit/e6f67caef37d3fb73adadfb64060541a0b791924))
- fixed type for Content ([39147f5](https://github.com/ueberdosis/tiptap/commit/39147f5b02388b68ddea91d40bd2e846597f813b))
- getHTMLFromFragment now expects a fragment instead of node ([2c9cf03](https://github.com/ueberdosis/tiptap/commit/2c9cf03398e2b14fceaec4386fdb53cae5261ae7))
- handle backspace also on shift ([32ae386](https://github.com/ueberdosis/tiptap/commit/32ae3868eaf42bb3f5d016038b57337ff64c21b4))
- ignore editable in dispatchTransaction, fix [#1239](https://github.com/ueberdosis/tiptap/issues/1239) ([b3fb022](https://github.com/ueberdosis/tiptap/commit/b3fb0228e04a227bfc4536b167a93b3172169378))
- Ignore iOS mutations when unfocused ([#2170](https://github.com/ueberdosis/tiptap/issues/2170)) ([10fea3b](https://github.com/ueberdosis/tiptap/commit/10fea3b44ef7bdc62d9392f8b04409cada233292))
- improve `setNode` behavior for list items, fix [#2261](https://github.com/ueberdosis/tiptap/issues/2261) ([f2ced69](https://github.com/ueberdosis/tiptap/commit/f2ced6971d60c555ce1e6bc7116fe0168f018bf1))
- improve active mark detection for inline nodes, fix [#1893](https://github.com/ueberdosis/tiptap/issues/1893) ([6437790](https://github.com/ueberdosis/tiptap/commit/6437790431e564c871ebe7daa3aab6e4d3577a8f))
- Improve backspace handling ([#2284](https://github.com/ueberdosis/tiptap/issues/2284)), fix [#2281](https://github.com/ueberdosis/tiptap/issues/2281) ([8ed485b](https://github.com/ueberdosis/tiptap/commit/8ed485ba53e809207a23ca6871aab2eb0806f0ab))
- Improve behavior when using insertContent ([#2147](https://github.com/ueberdosis/tiptap/issues/2147)) ([8fc915c](https://github.com/ueberdosis/tiptap/commit/8fc915cade394bff2015be1e1e2d7c008e8c908e))
- improve calculation for min/max positions in selections, fix [#1588](https://github.com/ueberdosis/tiptap/issues/1588) ([9425e72](https://github.com/ueberdosis/tiptap/commit/9425e7249a15e0fb4e8c714545c09f367d216536))
- improve default gapcursor position when surrounded by margins ([cd14731](https://github.com/ueberdosis/tiptap/commit/cd14731612b40fc460675e9fbaaab1618ac02abf))
- improve default styling for .ProseMirror-separator ([0e94afe](https://github.com/ueberdosis/tiptap/commit/0e94afe42a5c15a47698152b3bc88e6bc4f8c01f))
- improve drag position for node views ([5e5b8db](https://github.com/ueberdosis/tiptap/commit/5e5b8db6eb707aa570b462caf184401189228b02))
- improve drag position for node views even more ([d2c5b71](https://github.com/ueberdosis/tiptap/commit/d2c5b71c28b04ff64715ff6562e7dcb01cfd7ec8))
- improve JSONContent type to allow pure JSON content ([ce7f52a](https://github.com/ueberdosis/tiptap/commit/ce7f52a8f0c278ef39b25010950dd734bebd679b))
- improve performance for isActive method, see [#1930](https://github.com/ueberdosis/tiptap/issues/1930) ([fcca1e6](https://github.com/ueberdosis/tiptap/commit/fcca1e6f4db273ee2f3c0a543c44738c395193a8))
- improve types for generateHTML ([502b5b1](https://github.com/ueberdosis/tiptap/commit/502b5b1cc9f1a8beb49ef2da81a9db56c7e92424))
- initialize autofocus selection in `createView` ([#2212](https://github.com/ueberdosis/tiptap/issues/2212)) ([de39853](https://github.com/ueberdosis/tiptap/commit/de39853026ee63bb558ed59b1dab3899c07ae073))
- insertContent keeps marks when using plain text, fix [#2406](https://github.com/ueberdosis/tiptap/issues/2406) ([d242706](https://github.com/ueberdosis/tiptap/commit/d2427064ff1765004173f3c718cd1e4eba4dc355))
- lint error ([e17c414](https://github.com/ueberdosis/tiptap/commit/e17c41498aa0df71a827bf41f5c52745f3853c43))
- Mark `@tiptap/react` and `@tiptap/core` as side effect free ([#2361](https://github.com/ueberdosis/tiptap/issues/2361)) ([e609b2d](https://github.com/ueberdosis/tiptap/commit/e609b2d11615dd85fd219731d1b73deaeccccd69))
- nodeInputRule() support for group match ([#1574](https://github.com/ueberdosis/tiptap/issues/1574)) ([8ee0d67](https://github.com/ueberdosis/tiptap/commit/8ee0d67b83fea6a38d3abf02528d62ab482fe509))
- preserve whitespace when using insertContent command ([8f10181](https://github.com/ueberdosis/tiptap/commit/8f101810feace676fedce449e71d3af1d152436b))
- prevent a bug for node views when pressing enter on iOS, fix [#1214](https://github.com/ueberdosis/tiptap/issues/1214) ([234d238](https://github.com/ueberdosis/tiptap/commit/234d23887bfcb19c3591deb391688ec9d4e49a8a))
- prevent bug when editor is destroyed very fast ([939fc3d](https://github.com/ueberdosis/tiptap/commit/939fc3d93ab67d54b7fe67b64c423290b3a40df8))
- prevent dispatch empty fragment when parsing content with insertContent ([2a4e02a](https://github.com/ueberdosis/tiptap/commit/2a4e02ade3b74999a9632673a607568644d6d26c))
- prevent error in toggleList command, fix [#2279](https://github.com/ueberdosis/tiptap/issues/2279) ([66eb2f2](https://github.com/ueberdosis/tiptap/commit/66eb2f2a47cdf21590881153a6cb6b1f3f38641a))
- prevent RangeError for posToDOMRect, fix [#2112](https://github.com/ueberdosis/tiptap/issues/2112) ([010418d](https://github.com/ueberdosis/tiptap/commit/010418d0fd04ebef10180a3559abfbbd24b6a959))
- prevent removing inline nodes when using insertContentAt, fix [#2156](https://github.com/ueberdosis/tiptap/issues/2156) ([53ffce5](https://github.com/ueberdosis/tiptap/commit/53ffce501835f727dbc39f07a8759903245a3f30))
- properly calculate setDragImage position ([7401d45](https://github.com/ueberdosis/tiptap/commit/7401d45b7e3ff40e2ac894810bf85461761eb25b))
- remove custom coordsAtPos method, fix [#583](https://github.com/ueberdosis/tiptap/issues/583) ([485fb8c](https://github.com/ueberdosis/tiptap/commit/485fb8c74c831256aaa2cefdf130e05438c2e476))
- remove debug log ([beb96c5](https://github.com/ueberdosis/tiptap/commit/beb96c5cbfdb81869763e23f82f5ab270c30f0ea))
- remove defaultOptions fallback, fix [#2219](https://github.com/ueberdosis/tiptap/issues/2219) ([20b6d79](https://github.com/ueberdosis/tiptap/commit/20b6d79f33217d0f8fcd416a1cc54712ea6fc743))
- remove editable check in updateAttributes, fix [#1415](https://github.com/ueberdosis/tiptap/issues/1415) ([fbc8fff](https://github.com/ueberdosis/tiptap/commit/fbc8fffb701dd78994ca4e20c32a940236bf768d))
- remove editor from addExtensions context ([cbc0dd8](https://github.com/ueberdosis/tiptap/commit/cbc0dd8920ab7d36516387ceac59239f9162b4ec))
- remove empty attributes in getDebugJSON ([940fd69](https://github.com/ueberdosis/tiptap/commit/940fd69b61b6eb56ca05235d22993eb202a20c1d))
- remove empty mark attributes from getDebugJSON ([07cabe6](https://github.com/ueberdosis/tiptap/commit/07cabe65f4852a3c7fcab5c60b51318a05272aee))
- revert adding exports ([bc320d0](https://github.com/ueberdosis/tiptap/commit/bc320d0b4b80b0e37a7e47a56e0f6daec6e65d98))
- revert adding type: module ([f8d6475](https://github.com/ueberdosis/tiptap/commit/f8d6475e2151faea6f96baecdd6bd75880d50d2c))
- revert async focus, fix [#1658](https://github.com/ueberdosis/tiptap/issues/1658) ([c9869c8](https://github.com/ueberdosis/tiptap/commit/c9869c8d3021510366a46e840a66e8c06a6586ed))
- revert changes to selectAll command, fix [#2491](https://github.com/ueberdosis/tiptap/issues/2491) ([bdab760](https://github.com/ueberdosis/tiptap/commit/bdab760cdbf89da7a56dcc1a183010974d2e1290))
- run pasterules for pasted content, fix [#2408](https://github.com/ueberdosis/tiptap/issues/2408) ([bc03c0d](https://github.com/ueberdosis/tiptap/commit/bc03c0d77812376f910accba1fb130c751ea7f0d))
- Separate drags from drops in stopEvent ([#2070](https://github.com/ueberdosis/tiptap/issues/2070)) ([bebaa40](https://github.com/ueberdosis/tiptap/commit/bebaa4045e6be2e59d1b9c2e1f61f088a47fdf1b))
- set correct priority when extending extensions, fix [#1288](https://github.com/ueberdosis/tiptap/issues/1288) ([b4e2b6f](https://github.com/ueberdosis/tiptap/commit/b4e2b6fc9dd722cce5ee85eb2df994453a0f5d39))
- set correct type for emitUpdate ([9a40c17](https://github.com/ueberdosis/tiptap/commit/9a40c17b3422b22a2cfe1fbac76ca06c9e78ae8c))
- set max textselection correctly, fix [#2401](https://github.com/ueberdosis/tiptap/issues/2401) ([4be16fc](https://github.com/ueberdosis/tiptap/commit/4be16fcd2e6c107e59679eebf1ea1d6112a88afb))
- support all characters for suggestion char, fix [#2385](https://github.com/ueberdosis/tiptap/issues/2385) ([42d3ee8](https://github.com/ueberdosis/tiptap/commit/42d3ee8fc9882a9fb9f87e696cebd0e6146d2e62))
- update getJSON return type to JSONContent ([#2153](https://github.com/ueberdosis/tiptap/issues/2153)) ([6583ede](https://github.com/ueberdosis/tiptap/commit/6583edeb1f2a015f31cea378f5440fa6a31a47f6))

### Features

- [#1898](https://github.com/ueberdosis/tiptap/issues/1898) Made the EventEmitter generic to improve the types of the tiptap events ([#1959](https://github.com/ueberdosis/tiptap/issues/1959)) ([54e85fd](https://github.com/ueberdosis/tiptap/commit/54e85fd28491fcf2d5a88fb5abda1f8414ada92b))
- add 'all' option to focus command, fix [#2181](https://github.com/ueberdosis/tiptap/issues/2181) ([3c571c9](https://github.com/ueberdosis/tiptap/commit/3c571c9a3f2fdbf1d70e9efa27294fbdf6bcbd3c))
- add `updateSelection` option to `insertContentAt` command ([9f2c368](https://github.com/ueberdosis/tiptap/commit/9f2c36896b5b8510cea87d727dc4e94742fdf980))
- add addExtensions option ([26e672e](https://github.com/ueberdosis/tiptap/commit/26e672e2f02a8f94941c704f3cd6cc4adef40df7))
- add coordsAtPos and posToClientRect helper methods ([8dab614](https://github.com/ueberdosis/tiptap/commit/8dab6144a661e4c90f33d9d2f300882009eadd46))
- add defaultBlockAt helper ([403c147](https://github.com/ueberdosis/tiptap/commit/403c147d4d0875cb8ca63d88abfec94093ff7926))
- add deleteNode command ([73f1c50](https://github.com/ueberdosis/tiptap/commit/73f1c50bca8ffcd074388519eec9c659b0fda14c))
- add deleteNode method to node views ([fcee5f8](https://github.com/ueberdosis/tiptap/commit/fcee5f82c6a282191afe5c2cb83b9f5820af28dd))
- add editor prop to KeyboardShortcutCommand ([e0c2460](https://github.com/ueberdosis/tiptap/commit/e0c2460a960c739ac4b543f0f185653cb41599e3))
- add editor.getAttributes, deprecate editor.getNodeAttributes and editor.getMarkAttributes ([072905c](https://github.com/ueberdosis/tiptap/commit/072905cb95e022a37f5bc937889999bfbb33ad88))
- add enableCoreExtensions flag ([#1923](https://github.com/ueberdosis/tiptap/issues/1923)) ([4178281](https://github.com/ueberdosis/tiptap/commit/4178281a749f2b7641740c0be1efae77ecb74587))
- add extendEmptyMarkRange option to mark commands ([#1859](https://github.com/ueberdosis/tiptap/issues/1859)) ([14e458e](https://github.com/ueberdosis/tiptap/commit/14e458ea7d7475a51ac00d6f67509dc769919d0b))
- Add extension storage ([#2069](https://github.com/ueberdosis/tiptap/issues/2069)) ([7ffabf2](https://github.com/ueberdosis/tiptap/commit/7ffabf251c408a652eec1931cc78a8bd43cccb67))
- add findChildrenInRange helper ([463661c](https://github.com/ueberdosis/tiptap/commit/463661c5ed2fe4a1530888c8f09bb966794e33e6))
- add forEach command ([783ce4e](https://github.com/ueberdosis/tiptap/commit/783ce4e3ac11c0705cb2d54158bfe76d39b3a36b))
- add getText() and generateText() methods (fix [#1428](https://github.com/ueberdosis/tiptap/issues/1428)) ([#1875](https://github.com/ueberdosis/tiptap/issues/1875)) ([fe6a3e7](https://github.com/ueberdosis/tiptap/commit/fe6a3e7491f6a42123d3d8a92ab588f2a40d7799))
- add ignoreMutation option to NodeViewRenderer, fix [#1538](https://github.com/ueberdosis/tiptap/issues/1538) ([651e691](https://github.com/ueberdosis/tiptap/commit/651e6911e3ea5407df6a48783ee16733e0a4f474))
- add insertContent() command, deprecate insertText(), insertHTML() and insertNode() ([b8d9b7d](https://github.com/ueberdosis/tiptap/commit/b8d9b7d4c70b38fb9eec3c079be8243d30166e5e))
- add name to extension context ([12f60ab](https://github.com/ueberdosis/tiptap/commit/12f60abb731edd080cb9a70e8e34ae721e37f80e))
- add parentConfig to extension context for more extendable extensions, fix [#259](https://github.com/ueberdosis/tiptap/issues/259) ([5e1ec5d](https://github.com/ueberdosis/tiptap/commit/5e1ec5d2a66be164f505d631f97861ab9344ba96))
- add priority option to extensions ([bb1ae65](https://github.com/ueberdosis/tiptap/commit/bb1ae659a463e97a7ada15af711347b5c004897a))
- add resetAttributes() command, deprecate resetNodeAttributes() ([3334d93](https://github.com/ueberdosis/tiptap/commit/3334d930f30bd4acb5c314b4ec1934b6a1e0b712))
- add scrollIntoView option to focus command, fix [#2172](https://github.com/ueberdosis/tiptap/issues/2172) ([e0f6490](https://github.com/ueberdosis/tiptap/commit/e0f64904b665512fbde80db87bb394557433e164))
- add selectTextblockStart and selectTextblockEnd commands ([0aa39f9](https://github.com/ueberdosis/tiptap/commit/0aa39f93cb1ea328bcf3c1b8da9b0ff1b6a00486))
- add setMeta command ([36dad2b](https://github.com/ueberdosis/tiptap/commit/36dad2bbae5ed66077822330133a9d8ee0d28747))
- add setNodeSelection and setTextSelection commands ([811bf69](https://github.com/ueberdosis/tiptap/commit/811bf693eb5b927ec5f8120b56b2ae92f5ba2734))
- add some improvements to `CharacterCount` extension ([#2256](https://github.com/ueberdosis/tiptap/issues/2256)), fix [#1049](https://github.com/ueberdosis/tiptap/issues/1049), fix [#1550](https://github.com/ueberdosis/tiptap/issues/1550), fix [#1839](https://github.com/ueberdosis/tiptap/issues/1839), fix [#2245](https://github.com/ueberdosis/tiptap/issues/2245) ([5daa870](https://github.com/ueberdosis/tiptap/commit/5daa870b0906f0387fe07041681bc6f5b3774617))
- Add support for autolink ([#2226](https://github.com/ueberdosis/tiptap/issues/2226)) ([3d68981](https://github.com/ueberdosis/tiptap/commit/3d68981b47d087fff40549d2143eb952fc9e0a50))
- add support for checking for attributes in extendMarkRange ([ff7dd9b](https://github.com/ueberdosis/tiptap/commit/ff7dd9b919c7b5e0f845369c744116045bab5028))
- add Tracker class ([a757716](https://github.com/ueberdosis/tiptap/commit/a757716f684e16c60bff5b58e508106f39368dc2))
- add transaction to all events if possible, see [#1461](https://github.com/ueberdosis/tiptap/issues/1461) ([7f6ed0b](https://github.com/ueberdosis/tiptap/commit/7f6ed0b1c078985a1acee736bc605fb9f93b5af2))
- add updateAttributes() command, deprecate updateNodeAttributes(), fix [#254](https://github.com/ueberdosis/tiptap/issues/254) ([aac32b4](https://github.com/ueberdosis/tiptap/commit/aac32b4df6a1dfd93500e09d3433fcd8acad5fbe))
- Allow a rule to be skipped from the getAttributes callback in markPasteRule ([#1625](https://github.com/ueberdosis/tiptap/issues/1625)) ([9ffd58c](https://github.com/ueberdosis/tiptap/commit/9ffd58cf256bf3c0cd5a217b8933826c70b9b841))
- Allow array of extensions for `enableInputRules` and `enablePasteRules` options ([#2119](https://github.com/ueberdosis/tiptap/issues/2119)) ([3158c37](https://github.com/ueberdosis/tiptap/commit/3158c37324420fb4c2414f47132e72a2836a63b4))
- allow number for setTextSelection and insertContentAt ([2f7a6ad](https://github.com/ueberdosis/tiptap/commit/2f7a6adca54290b65467121e55838e5cfcf9ea8b))
- Allow to use commands within InputRule and PasteRule ([#2035](https://github.com/ueberdosis/tiptap/issues/2035)) ([4303637](https://github.com/ueberdosis/tiptap/commit/4303637a786a164af0c7ffac17ae3621a8533c6e))
- allow wildcards when checking attributes in isActive, fix [#1752](https://github.com/ueberdosis/tiptap/issues/1752) ([64409ca](https://github.com/ueberdosis/tiptap/commit/64409cad66f281584a962e93317d8dd94ef6c5c0))
- **core:** add nodePasteRule to core ([15123ee](https://github.com/ueberdosis/tiptap/commit/15123ee092261fe86352d491121804607e08e031))
- export isList, fix [#1326](https://github.com/ueberdosis/tiptap/issues/1326) ([2bd17c7](https://github.com/ueberdosis/tiptap/commit/2bd17c7dc66d2d2c3131bce9e5a82326a990080c))
- export mark helpers ([313ab0e](https://github.com/ueberdosis/tiptap/commit/313ab0eac7d9209c279f0925c2372735882de56a))
- expose node helpers to core ([6048f9b](https://github.com/ueberdosis/tiptap/commit/6048f9b31b996b305f704c4ae3ed176fa42eb943))
- Integrate input rules and paste rules into the core ([#1997](https://github.com/ueberdosis/tiptap/issues/1997)) ([723b955](https://github.com/ueberdosis/tiptap/commit/723b955cecc5c92c8aad897ce16c60fb62976571))
- join lists on toggleList ([#2260](https://github.com/ueberdosis/tiptap/issues/2260)), fix [#1329](https://github.com/ueberdosis/tiptap/issues/1329) ([126ad72](https://github.com/ueberdosis/tiptap/commit/126ad722c7a1c4131fa332deb9f333798d4af056))
- parseHTML for attributes should return the value instead of an object now, fix [#1863](https://github.com/ueberdosis/tiptap/issues/1863) ([8a3b47a](https://github.com/ueberdosis/tiptap/commit/8a3b47a529d28b28b50d634c6ff69b8e5aad3080))
- remove deprecated commands insertHTML, insertNode and insertText ([86d570f](https://github.com/ueberdosis/tiptap/commit/86d570fb79b89a061cf1a5374a377ed6d9bca49e))
- remove resize event handler ([9f64015](https://github.com/ueberdosis/tiptap/commit/9f64015157a83032d0d80bc0353efb529b56a342))

### Reverts

- Revert "Publish" ([9c38d27](https://github.com/ueberdosis/tiptap/commit/9c38d2713e6feac5645ad9c1bfc57abdbf054576))
- Revert "use global namespace" ([0c9ce26](https://github.com/ueberdosis/tiptap/commit/0c9ce26c02c07d88a757c01b0a9d7f9e2b0b7502))

# [2.0.0-beta.183](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.182...@tiptap/core@2.0.0-beta.183) (2022-09-03)

### Bug Fixes

- **core:** createCan command props shouldn't try dispatch ([#3025](https://github.com/ueberdosis/tiptap/issues/3025)) ([#3026](https://github.com/ueberdosis/tiptap/issues/3026)) ([40f4ea3](https://github.com/ueberdosis/tiptap/commit/40f4ea31efc59c1578b783a5b64572ac2846c5a6))
- **core:** isNodeSelection, isTextSelection not always false ([#3089](https://github.com/ueberdosis/tiptap/issues/3089)) ([574cd69](https://github.com/ueberdosis/tiptap/commit/574cd69e06bfdc3771006ed4eda341a6c9722a42)), closes [#2979](https://github.com/ueberdosis/tiptap/issues/2979)
- **core:** make setEditable trigger all 'update' listeners ([#3140](https://github.com/ueberdosis/tiptap/issues/3140)) ([4851fc5](https://github.com/ueberdosis/tiptap/commit/4851fc5e9b6daccc15a1839e471db489401eca0c))
- **core:** make setEditable trigger onUpdate function ([#2935](https://github.com/ueberdosis/tiptap/issues/2935)) ([de1253a](https://github.com/ueberdosis/tiptap/commit/de1253a8b06eeb7339f0bba8c04917890c9b21ae))
- **core:** setNodeSelection should not clamp pos by Selection.atStart/atEnd ([#3091](https://github.com/ueberdosis/tiptap/issues/3091)) ([313b8b8](https://github.com/ueberdosis/tiptap/commit/313b8b8d0af7059c420ffc96c9362f0f4acc2138)), closes [#3090](https://github.com/ueberdosis/tiptap/issues/3090)

# [2.0.0-beta.182](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.181...@tiptap/core@2.0.0-beta.182) (2022-07-06)

### Bug Fixes

- **core:** dont use selection for setContent replacement ([#2934](https://github.com/ueberdosis/tiptap/issues/2934)) ([134a4bd](https://github.com/ueberdosis/tiptap/commit/134a4bd1fbbd7f56faa1fc70c97d3b58554fc3f1))
- **core:** only respect text of node before current position ([#2937](https://github.com/ueberdosis/tiptap/issues/2937)) ([#2941](https://github.com/ueberdosis/tiptap/issues/2941)) ([e280a02](https://github.com/ueberdosis/tiptap/commit/e280a02597d15460fce97a7555f91ff04926f0e7))

# [2.0.0-beta.181](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.180...@tiptap/core@2.0.0-beta.181) (2022-06-27)

### Bug Fixes

- **core:** fix focus command passing through editor state instead of existing transaction ([5b0b7d9](https://github.com/ueberdosis/tiptap/commit/5b0b7d91023c87e9ddb85ff3a776273d12a22d16))

### Features

- **core:** add nodePasteRule to core ([15123ee](https://github.com/ueberdosis/tiptap/commit/15123ee092261fe86352d491121804607e08e031))

# [2.0.0-beta.180](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.179...@tiptap/core@2.0.0-beta.180) (2022-06-20)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.179](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.177...@tiptap/core@2.0.0-beta.179) (2022-06-17)

### Reverts

- Revert "Publish" ([9c38d27](https://github.com/ueberdosis/tiptap/commit/9c38d2713e6feac5645ad9c1bfc57abdbf054576))

# [2.0.0-beta.177](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.177...@tiptap/core@2.0.0-beta.177) (2022-06-17)

### Reverts

- Revert "Publish" ([9c38d27](https://github.com/ueberdosis/tiptap/commit/9c38d2713e6feac5645ad9c1bfc57abdbf054576))

# [2.0.0-beta.176](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.175...@tiptap/core@2.0.0-beta.176) (2022-05-18)

### Bug Fixes

- lint error ([e17c414](https://github.com/ueberdosis/tiptap/commit/e17c41498aa0df71a827bf41f5c52745f3853c43))
- properly calculate setDragImage position ([7401d45](https://github.com/ueberdosis/tiptap/commit/7401d45b7e3ff40e2ac894810bf85461761eb25b))

# [2.0.0-beta.175](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.174...@tiptap/core@2.0.0-beta.175) (2022-04-27)

### Bug Fixes

- don't override behaviour of Home / End in pc keymap ([d270419](https://github.com/ueberdosis/tiptap/commit/d270419ad8dc6182a949c5d263c47e90ee4466ff))

# [2.0.0-beta.174](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.173...@tiptap/core@2.0.0-beta.174) (2022-02-07)

### Bug Fixes

- revert changes to selectAll command, fix [#2491](https://github.com/ueberdosis/tiptap/issues/2491) ([bdab760](https://github.com/ueberdosis/tiptap/commit/bdab760cdbf89da7a56dcc1a183010974d2e1290))

# [2.0.0-beta.173](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.172...@tiptap/core@2.0.0-beta.173) (2022-02-07)

### Bug Fixes

- fix RangeError bug when selecting all text, fix [#2490](https://github.com/ueberdosis/tiptap/issues/2490) ([70422dd](https://github.com/ueberdosis/tiptap/commit/70422dd107ed1ecdd8dfe41a8a93297124d2f1e0))

# [2.0.0-beta.172](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.171...@tiptap/core@2.0.0-beta.172) (2022-02-03)

### Bug Fixes

- don’t add tabindex when readonly, fix [#2458](https://github.com/ueberdosis/tiptap/issues/2458) ([01411f8](https://github.com/ueberdosis/tiptap/commit/01411f8462e8a36f96e56cdba227a9e5bb3e1812))

# [2.0.0-beta.171](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.170...@tiptap/core@2.0.0-beta.171) (2022-01-28)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.170](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.169...@tiptap/core@2.0.0-beta.170) (2022-01-27)

### Bug Fixes

- set max textselection correctly, fix [#2401](https://github.com/ueberdosis/tiptap/issues/2401) ([4be16fc](https://github.com/ueberdosis/tiptap/commit/4be16fcd2e6c107e59679eebf1ea1d6112a88afb))

# [2.0.0-beta.169](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.168...@tiptap/core@2.0.0-beta.169) (2022-01-27)

### Bug Fixes

- fix End key handler, fix [#2446](https://github.com/ueberdosis/tiptap/issues/2446) ([b584920](https://github.com/ueberdosis/tiptap/commit/b584920ea172bc9f5207b8d03cb2b7f80925a5be))

# [2.0.0-beta.168](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.167...@tiptap/core@2.0.0-beta.168) (2022-01-26)

### Bug Fixes

- add attributes to pre tag instead of code tag by default, fix [#2440](https://github.com/ueberdosis/tiptap/issues/2440) ([85fcc29](https://github.com/ueberdosis/tiptap/commit/85fcc29ac6ef9e07847d5e0a5cdd318f4300a832))

# [2.0.0-beta.167](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.166...@tiptap/core@2.0.0-beta.167) (2022-01-25)

### Bug Fixes

- add correct windows and px keymap ([75e5601](https://github.com/ueberdosis/tiptap/commit/75e56017676ac7905c41b87d54b7f099d0290eeb))

### Features

- add selectTextblockStart and selectTextblockEnd commands ([0aa39f9](https://github.com/ueberdosis/tiptap/commit/0aa39f93cb1ea328bcf3c1b8da9b0ff1b6a00486))

# [2.0.0-beta.166](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.165...@tiptap/core@2.0.0-beta.166) (2022-01-20)

### Bug Fixes

- insertContent keeps marks when using plain text, fix [#2406](https://github.com/ueberdosis/tiptap/issues/2406) ([d242706](https://github.com/ueberdosis/tiptap/commit/d2427064ff1765004173f3c718cd1e4eba4dc355))

# [2.0.0-beta.165](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.164...@tiptap/core@2.0.0-beta.165) (2022-01-20)

### Bug Fixes

- fix removing the caret on blur in some situations when using safari, fix [#2405](https://github.com/ueberdosis/tiptap/issues/2405) ([9d31712](https://github.com/ueberdosis/tiptap/commit/9d317128a08a66f18c4d51385b6a9fccc5cd66f4))

# [2.0.0-beta.164](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.163...@tiptap/core@2.0.0-beta.164) (2022-01-20)

### Bug Fixes

- run pasterules for pasted content, fix [#2408](https://github.com/ueberdosis/tiptap/issues/2408) ([bc03c0d](https://github.com/ueberdosis/tiptap/commit/bc03c0d77812376f910accba1fb130c751ea7f0d))

# [2.0.0-beta.163](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.162...@tiptap/core@2.0.0-beta.163) (2022-01-13)

### Bug Fixes

- support all characters for suggestion char, fix [#2385](https://github.com/ueberdosis/tiptap/issues/2385) ([42d3ee8](https://github.com/ueberdosis/tiptap/commit/42d3ee8fc9882a9fb9f87e696cebd0e6146d2e62))

# [2.0.0-beta.162](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.161...@tiptap/core@2.0.0-beta.162) (2022-01-11)

### Bug Fixes

- Mark `@tiptap/react` and `@tiptap/core` as side effect free ([#2361](https://github.com/ueberdosis/tiptap/issues/2361)) ([e609b2d](https://github.com/ueberdosis/tiptap/commit/e609b2d11615dd85fd219731d1b73deaeccccd69))

# [2.0.0-beta.161](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.160...@tiptap/core@2.0.0-beta.161) (2022-01-10)

### Bug Fixes

- add way to cancel inputrules and pasterules ([#2368](https://github.com/ueberdosis/tiptap/issues/2368)) ([669efd0](https://github.com/ueberdosis/tiptap/commit/669efd00e9a508bbb4d6275d47092470b2e16561))

# [2.0.0-beta.160](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.159...@tiptap/core@2.0.0-beta.160) (2022-01-04)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.159](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.158...@tiptap/core@2.0.0-beta.159) (2021-12-22)

### Bug Fixes

- allow input rules after hard break, fix [#2302](https://github.com/ueberdosis/tiptap/issues/2302) ([ded6f96](https://github.com/ueberdosis/tiptap/commit/ded6f9618fb588f2c259edc9bc77415f8723431c))

# [2.0.0-beta.158](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.157...@tiptap/core@2.0.0-beta.158) (2021-12-17)

### Bug Fixes

- remove empty mark attributes from getDebugJSON ([07cabe6](https://github.com/ueberdosis/tiptap/commit/07cabe65f4852a3c7fcab5c60b51318a05272aee))

# [2.0.0-beta.157](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.156...@tiptap/core@2.0.0-beta.157) (2021-12-16)

### Bug Fixes

- Improve backspace handling ([#2284](https://github.com/ueberdosis/tiptap/issues/2284)), fix [#2281](https://github.com/ueberdosis/tiptap/issues/2281) ([8ed485b](https://github.com/ueberdosis/tiptap/commit/8ed485ba53e809207a23ca6871aab2eb0806f0ab))

# [2.0.0-beta.156](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.155...@tiptap/core@2.0.0-beta.156) (2021-12-15)

### Bug Fixes

- prevent error in toggleList command, fix [#2279](https://github.com/ueberdosis/tiptap/issues/2279) ([66eb2f2](https://github.com/ueberdosis/tiptap/commit/66eb2f2a47cdf21590881153a6cb6b1f3f38641a))

# [2.0.0-beta.155](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.154...@tiptap/core@2.0.0-beta.155) (2021-12-15)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.154](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.153...@tiptap/core@2.0.0-beta.154) (2021-12-14)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.153](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.152...@tiptap/core@2.0.0-beta.153) (2021-12-13)

### Bug Fixes

- check for invalid content in `insertContentAt` command ([e09fd93](https://github.com/ueberdosis/tiptap/commit/e09fd93e59dbae5bca9da7def6ddafc6beda9987))
- don’t check for active node in wrapIn command, fix [#1059](https://github.com/ueberdosis/tiptap/issues/1059) ([170ec4b](https://github.com/ueberdosis/tiptap/commit/170ec4be5b3c8362890ca3100a223b505f788381))
- improve `setNode` behavior for list items, fix [#2261](https://github.com/ueberdosis/tiptap/issues/2261) ([f2ced69](https://github.com/ueberdosis/tiptap/commit/f2ced6971d60c555ce1e6bc7116fe0168f018bf1))

# [2.0.0-beta.152](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.151...@tiptap/core@2.0.0-beta.152) (2021-12-10)

### Features

- join lists on toggleList ([#2260](https://github.com/ueberdosis/tiptap/issues/2260)), fix [#1329](https://github.com/ueberdosis/tiptap/issues/1329) ([126ad72](https://github.com/ueberdosis/tiptap/commit/126ad722c7a1c4131fa332deb9f333798d4af056))

# [2.0.0-beta.151](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.150...@tiptap/core@2.0.0-beta.151) (2021-12-08)

### Features

- add some improvements to `CharacterCount` extension ([#2256](https://github.com/ueberdosis/tiptap/issues/2256)), fix [#1049](https://github.com/ueberdosis/tiptap/issues/1049), fix [#1550](https://github.com/ueberdosis/tiptap/issues/1550), fix [#1839](https://github.com/ueberdosis/tiptap/issues/1839), fix [#2245](https://github.com/ueberdosis/tiptap/issues/2245) ([5daa870](https://github.com/ueberdosis/tiptap/commit/5daa870b0906f0387fe07041681bc6f5b3774617))

# [2.0.0-beta.150](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.149...@tiptap/core@2.0.0-beta.150) (2021-12-06)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.149](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.148...@tiptap/core@2.0.0-beta.149) (2021-12-05)

### Bug Fixes

- add support for multiple ranges in clipboardTextSerializer, fix [#1982](https://github.com/ueberdosis/tiptap/issues/1982) ([98a1cb3](https://github.com/ueberdosis/tiptap/commit/98a1cb36408765f0f042e7abb8dad3c19cdf0a09))

# [2.0.0-beta.148](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.147...@tiptap/core@2.0.0-beta.148) (2021-12-03)

### Bug Fixes

- initialize autofocus selection in `createView` ([#2212](https://github.com/ueberdosis/tiptap/issues/2212)) ([de39853](https://github.com/ueberdosis/tiptap/commit/de39853026ee63bb558ed59b1dab3899c07ae073))

# [2.0.0-beta.147](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.146...@tiptap/core@2.0.0-beta.147) (2021-12-03)

### Features

- Add support for autolink ([#2226](https://github.com/ueberdosis/tiptap/issues/2226)) ([3d68981](https://github.com/ueberdosis/tiptap/commit/3d68981b47d087fff40549d2143eb952fc9e0a50))

# [2.0.0-beta.146](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.145...@tiptap/core@2.0.0-beta.146) (2021-12-02)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.145](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.144...@tiptap/core@2.0.0-beta.145) (2021-12-02)

### Bug Fixes

- remove defaultOptions fallback, fix [#2219](https://github.com/ueberdosis/tiptap/issues/2219) ([20b6d79](https://github.com/ueberdosis/tiptap/commit/20b6d79f33217d0f8fcd416a1cc54712ea6fc743))

# [2.0.0-beta.144](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.143...@tiptap/core@2.0.0-beta.144) (2021-12-02)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.143](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.142...@tiptap/core@2.0.0-beta.143) (2021-11-25)

### Features

- add scrollIntoView option to focus command, fix [#2172](https://github.com/ueberdosis/tiptap/issues/2172) ([e0f6490](https://github.com/ueberdosis/tiptap/commit/e0f64904b665512fbde80db87bb394557433e164))

# [2.0.0-beta.142](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.141...@tiptap/core@2.0.0-beta.142) (2021-11-23)

### Features

- add defaultBlockAt helper ([403c147](https://github.com/ueberdosis/tiptap/commit/403c147d4d0875cb8ca63d88abfec94093ff7926))

# [2.0.0-beta.141](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.140...@tiptap/core@2.0.0-beta.141) (2021-11-22)

### Bug Fixes

- improve default gapcursor position when surrounded by margins ([cd14731](https://github.com/ueberdosis/tiptap/commit/cd14731612b40fc460675e9fbaaab1618ac02abf))

### Features

- add 'all' option to focus command, fix [#2181](https://github.com/ueberdosis/tiptap/issues/2181) ([3c571c9](https://github.com/ueberdosis/tiptap/commit/3c571c9a3f2fdbf1d70e9efa27294fbdf6bcbd3c))

# [2.0.0-beta.140](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.139...@tiptap/core@2.0.0-beta.140) (2021-11-18)

### Bug Fixes

- Ignore iOS mutations when unfocused ([#2170](https://github.com/ueberdosis/tiptap/issues/2170)) ([10fea3b](https://github.com/ueberdosis/tiptap/commit/10fea3b44ef7bdc62d9392f8b04409cada233292))

### Features

- Allow array of extensions for `enableInputRules` and `enablePasteRules` options ([#2119](https://github.com/ueberdosis/tiptap/issues/2119)) ([3158c37](https://github.com/ueberdosis/tiptap/commit/3158c37324420fb4c2414f47132e72a2836a63b4))

# [2.0.0-beta.139](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.138...@tiptap/core@2.0.0-beta.139) (2021-11-17)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.138](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.137...@tiptap/core@2.0.0-beta.138) (2021-11-10)

### Bug Fixes

- prevent removing inline nodes when using insertContentAt, fix [#2156](https://github.com/ueberdosis/tiptap/issues/2156) ([53ffce5](https://github.com/ueberdosis/tiptap/commit/53ffce501835f727dbc39f07a8759903245a3f30))
- update getJSON return type to JSONContent ([#2153](https://github.com/ueberdosis/tiptap/issues/2153)) ([6583ede](https://github.com/ueberdosis/tiptap/commit/6583edeb1f2a015f31cea378f5440fa6a31a47f6))

# [2.0.0-beta.137](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.136...@tiptap/core@2.0.0-beta.137) (2021-11-09)

### Bug Fixes

- don't remove the tiptap styles on destroy, fix [#2120](https://github.com/ueberdosis/tiptap/issues/2120), fix [#2143](https://github.com/ueberdosis/tiptap/issues/2143) ([a0a88ac](https://github.com/ueberdosis/tiptap/commit/a0a88acd13ee221587834def8d2655ac13233f27))

# [2.0.0-beta.136](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.135...@tiptap/core@2.0.0-beta.136) (2021-11-09)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.135](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.134...@tiptap/core@2.0.0-beta.135) (2021-11-09)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.134](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.133...@tiptap/core@2.0.0-beta.134) (2021-11-09)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.133](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.132...@tiptap/core@2.0.0-beta.133) (2021-11-08)

### Bug Fixes

- fix a bug when parsing attributes if no parseHTML method is provided, fix [#2058](https://github.com/ueberdosis/tiptap/issues/2058) ([5da313a](https://github.com/ueberdosis/tiptap/commit/5da313a5480db011374ffd236159e2aedc011b97))
- Improve behavior when using insertContent ([#2147](https://github.com/ueberdosis/tiptap/issues/2147)) ([8fc915c](https://github.com/ueberdosis/tiptap/commit/8fc915cade394bff2015be1e1e2d7c008e8c908e))

# [2.0.0-beta.132](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.131...@tiptap/core@2.0.0-beta.132) (2021-11-08)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.131](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.130...@tiptap/core@2.0.0-beta.131) (2021-11-05)

### Bug Fixes

- improve JSONContent type to allow pure JSON content ([ce7f52a](https://github.com/ueberdosis/tiptap/commit/ce7f52a8f0c278ef39b25010950dd734bebd679b))

# [2.0.0-beta.130](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.129...@tiptap/core@2.0.0-beta.130) (2021-10-31)

### Bug Fixes

- prevent RangeError for posToDOMRect, fix [#2112](https://github.com/ueberdosis/tiptap/issues/2112) ([010418d](https://github.com/ueberdosis/tiptap/commit/010418d0fd04ebef10180a3559abfbbd24b6a959))

# [2.0.0-beta.129](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.128...@tiptap/core@2.0.0-beta.129) (2021-10-26)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.128](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.127...@tiptap/core@2.0.0-beta.128) (2021-10-25)

### Bug Fixes

- fix storage context when using configure ([ef254ce](https://github.com/ueberdosis/tiptap/commit/ef254cead7b9be052ec0211849fb78ae577095dd))

# [2.0.0-beta.127](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.126...@tiptap/core@2.0.0-beta.127) (2021-10-22)

### Bug Fixes

- improve default styling for .ProseMirror-separator ([0e94afe](https://github.com/ueberdosis/tiptap/commit/0e94afe42a5c15a47698152b3bc88e6bc4f8c01f))
- Separate drags from drops in stopEvent ([#2070](https://github.com/ueberdosis/tiptap/issues/2070)) ([bebaa40](https://github.com/ueberdosis/tiptap/commit/bebaa4045e6be2e59d1b9c2e1f61f088a47fdf1b))

# [2.0.0-beta.126](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.125...@tiptap/core@2.0.0-beta.126) (2021-10-22)

### Bug Fixes

- fix a bug where paste rules doesn’t worked at the start of the document, see [#1225](https://github.com/ueberdosis/tiptap/issues/1225) ([ff67ee1](https://github.com/ueberdosis/tiptap/commit/ff67ee1da380d8308e85fa4b0386ea6947ec7ff1))

### Features

- Add extension storage ([#2069](https://github.com/ueberdosis/tiptap/issues/2069)) ([7ffabf2](https://github.com/ueberdosis/tiptap/commit/7ffabf251c408a652eec1931cc78a8bd43cccb67))

# [2.0.0-beta.125](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.124...@tiptap/core@2.0.0-beta.125) (2021-10-14)

### Bug Fixes

- check for storedMarks in getMarkAttributes, fix [#2039](https://github.com/ueberdosis/tiptap/issues/2039) ([22c82ba](https://github.com/ueberdosis/tiptap/commit/22c82ba61fe14db19e1049dfcf9bef0b7abb796d))

# [2.0.0-beta.124](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.123...@tiptap/core@2.0.0-beta.124) (2021-10-14)

### Bug Fixes

- fix type for insertContent command ([4295c6b](https://github.com/ueberdosis/tiptap/commit/4295c6bd2181bdaa98ef7777bfab44efbcf22a32))

# [2.0.0-beta.123](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.122...@tiptap/core@2.0.0-beta.123) (2021-10-14)

### Features

- add `updateSelection` option to `insertContentAt` command ([9f2c368](https://github.com/ueberdosis/tiptap/commit/9f2c36896b5b8510cea87d727dc4e94742fdf980))
- Allow to use commands within InputRule and PasteRule ([#2035](https://github.com/ueberdosis/tiptap/issues/2035)) ([4303637](https://github.com/ueberdosis/tiptap/commit/4303637a786a164af0c7ffac17ae3621a8533c6e))

# [2.0.0-beta.122](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.121...@tiptap/core@2.0.0-beta.122) (2021-10-10)

### Bug Fixes

- allow to re-apply current mark for input rules and paste rules, fix [#2003](https://github.com/ueberdosis/tiptap/issues/2003) ([3958bf1](https://github.com/ueberdosis/tiptap/commit/3958bf1c226621142e9216c8eda91a70b71a211a))

# [2.0.0-beta.121](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.120...@tiptap/core@2.0.0-beta.121) (2021-10-10)

### Bug Fixes

- do not apply paste rules for ProseMirror HTML ([9d281e9](https://github.com/ueberdosis/tiptap/commit/9d281e9e998a5cfa9ca1002ad428caf1cee59682))

# [2.0.0-beta.120](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.119...@tiptap/core@2.0.0-beta.120) (2021-10-08)

### Bug Fixes

- fix mappes positions for paste rules, fix [#2002](https://github.com/ueberdosis/tiptap/issues/2002) ([770c4e1](https://github.com/ueberdosis/tiptap/commit/770c4e18e19504f4c44feb85b7d202fcc5201b12))

# [2.0.0-beta.119](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.118...@tiptap/core@2.0.0-beta.119) (2021-10-08)

### Features

- Integrate input rules and paste rules into the core ([#1997](https://github.com/ueberdosis/tiptap/issues/1997)) ([723b955](https://github.com/ueberdosis/tiptap/commit/723b955cecc5c92c8aad897ce16c60fb62976571))

# [2.0.0-beta.118](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.117...@tiptap/core@2.0.0-beta.118) (2021-10-03)

### Bug Fixes

- fix order of executed plugins, fix [#1547](https://github.com/ueberdosis/tiptap/issues/1547) ([f8efdf7](https://github.com/ueberdosis/tiptap/commit/f8efdf797a10a01235b75091729b15aca076e47a))

# [2.0.0-beta.117](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.116...@tiptap/core@2.0.0-beta.117) (2021-10-02)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.116](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.115...@tiptap/core@2.0.0-beta.116) (2021-09-30)

### Features

- [#1898](https://github.com/ueberdosis/tiptap/issues/1898) Made the EventEmitter generic to improve the types of the tiptap events ([#1959](https://github.com/ueberdosis/tiptap/issues/1959)) ([54e85fd](https://github.com/ueberdosis/tiptap/commit/54e85fd28491fcf2d5a88fb5abda1f8414ada92b))

# [2.0.0-beta.115](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.114...@tiptap/core@2.0.0-beta.115) (2021-09-29)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.114](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.113...@tiptap/core@2.0.0-beta.114) (2021-09-28)

### Bug Fixes

- getHTMLFromFragment now expects a fragment instead of node ([2c9cf03](https://github.com/ueberdosis/tiptap/commit/2c9cf03398e2b14fceaec4386fdb53cae5261ae7))

# [2.0.0-beta.113](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.112...@tiptap/core@2.0.0-beta.113) (2021-09-27)

### Bug Fixes

- add support for CellSelection in isActive helper, fix [#1947](https://github.com/ueberdosis/tiptap/issues/1947) ([b42e442](https://github.com/ueberdosis/tiptap/commit/b42e442a5af167f78edb5252dd8dbdcb8e0a96ed))
- handle backspace also on shift ([32ae386](https://github.com/ueberdosis/tiptap/commit/32ae3868eaf42bb3f5d016038b57337ff64c21b4))

# [2.0.0-beta.112](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.111...@tiptap/core@2.0.0-beta.112) (2021-09-23)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.111](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.110...@tiptap/core@2.0.0-beta.111) (2021-09-22)

### Bug Fixes

- improve performance for isActive method, see [#1930](https://github.com/ueberdosis/tiptap/issues/1930) ([fcca1e6](https://github.com/ueberdosis/tiptap/commit/fcca1e6f4db273ee2f3c0a543c44738c395193a8))
- nodeInputRule() support for group match ([#1574](https://github.com/ueberdosis/tiptap/issues/1574)) ([8ee0d67](https://github.com/ueberdosis/tiptap/commit/8ee0d67b83fea6a38d3abf02528d62ab482fe509))

# [2.0.0-beta.110](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.109...@tiptap/core@2.0.0-beta.110) (2021-09-21)

### Bug Fixes

- call selectAll on 'cmd+a', set a TextSelection instead of AllSelection, fix [#1908](https://github.com/ueberdosis/tiptap/issues/1908) ([bad16d9](https://github.com/ueberdosis/tiptap/commit/bad16d9f3a9f47db83ad170c6de4d6ff11dba007))

# [2.0.0-beta.109](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.108...@tiptap/core@2.0.0-beta.109) (2021-09-21)

### Features

- add enableCoreExtensions flag ([#1923](https://github.com/ueberdosis/tiptap/issues/1923)) ([4178281](https://github.com/ueberdosis/tiptap/commit/4178281a749f2b7641740c0be1efae77ecb74587))

# [2.0.0-beta.108](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.107...@tiptap/core@2.0.0-beta.108) (2021-09-20)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.107](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.106...@tiptap/core@2.0.0-beta.107) (2021-09-18)

### Bug Fixes

- fix extension name for clipboardTextSerializer ([15f90ec](https://github.com/ueberdosis/tiptap/commit/15f90ec5916460359827f7073e5c36147867fef7))

# [2.0.0-beta.106](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.105...@tiptap/core@2.0.0-beta.106) (2021-09-15)

### Bug Fixes

- improve active mark detection for inline nodes, fix [#1893](https://github.com/ueberdosis/tiptap/issues/1893) ([6437790](https://github.com/ueberdosis/tiptap/commit/6437790431e564c871ebe7daa3aab6e4d3577a8f))

# [2.0.0-beta.105](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.104...@tiptap/core@2.0.0-beta.105) (2021-09-09)

### Features

- add getText() and generateText() methods (fix [#1428](https://github.com/ueberdosis/tiptap/issues/1428)) ([#1875](https://github.com/ueberdosis/tiptap/issues/1875)) ([fe6a3e7](https://github.com/ueberdosis/tiptap/commit/fe6a3e7491f6a42123d3d8a92ab588f2a40d7799))

# [2.0.0-beta.104](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.103...@tiptap/core@2.0.0-beta.104) (2021-09-08)

### Features

- add extendEmptyMarkRange option to mark commands ([#1859](https://github.com/ueberdosis/tiptap/issues/1859)) ([14e458e](https://github.com/ueberdosis/tiptap/commit/14e458ea7d7475a51ac00d6f67509dc769919d0b))
- parseHTML for attributes should return the value instead of an object now, fix [#1863](https://github.com/ueberdosis/tiptap/issues/1863) ([8a3b47a](https://github.com/ueberdosis/tiptap/commit/8a3b47a529d28b28b50d634c6ff69b8e5aad3080))

# [2.0.0-beta.103](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.102...@tiptap/core@2.0.0-beta.103) (2021-09-06)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.102](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.101...@tiptap/core@2.0.0-beta.102) (2021-08-26)

### Bug Fixes

- fix focus on iOS, fix [#1806](https://github.com/ueberdosis/tiptap/issues/1806) ([3a06938](https://github.com/ueberdosis/tiptap/commit/3a0693869d10793620e0073b0782dd34ac5aea89))

# [2.0.0-beta.101](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.100...@tiptap/core@2.0.0-beta.101) (2021-08-24)

### Bug Fixes

- add topNode to getDebugJSON ([f65e1b3](https://github.com/ueberdosis/tiptap/commit/f65e1b32a16c25622c2d507e74dd0dde9dac9376))

# [2.0.0-beta.100](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.99...@tiptap/core@2.0.0-beta.100) (2021-08-20)

### Bug Fixes

- add missing ProseMirror styles ([12602e7](https://github.com/ueberdosis/tiptap/commit/12602e77ef5d35b430d3d14b93788b327a0f17da))

### Features

- allow wildcards when checking attributes in isActive, fix [#1752](https://github.com/ueberdosis/tiptap/issues/1752) ([64409ca](https://github.com/ueberdosis/tiptap/commit/64409cad66f281584a962e93317d8dd94ef6c5c0))

# [2.0.0-beta.99](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.98...@tiptap/core@2.0.0-beta.99) (2021-08-13)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.98](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.97...@tiptap/core@2.0.0-beta.98) (2021-08-13)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.97](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.96...@tiptap/core@2.0.0-beta.97) (2021-08-13)

### Features

- add transaction to all events if possible, see [#1461](https://github.com/ueberdosis/tiptap/issues/1461) ([7f6ed0b](https://github.com/ueberdosis/tiptap/commit/7f6ed0b1c078985a1acee736bc605fb9f93b5af2))

# [2.0.0-beta.96](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.95...@tiptap/core@2.0.0-beta.96) (2021-08-12)

### Bug Fixes

- fix some react focus issues ([#1724](https://github.com/ueberdosis/tiptap/issues/1724)), fix [#1716](https://github.com/ueberdosis/tiptap/issues/1716), fix [#1608](https://github.com/ueberdosis/tiptap/issues/1608), fix [#1520](https://github.com/ueberdosis/tiptap/issues/1520) ([956566e](https://github.com/ueberdosis/tiptap/commit/956566eaad0a522d6bc27d44594aa36d6c33f8b3))

# [2.0.0-beta.95](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.94...@tiptap/core@2.0.0-beta.95) (2021-08-11)

### Bug Fixes

- improve calculation for min/max positions in selections, fix [#1588](https://github.com/ueberdosis/tiptap/issues/1588) ([9425e72](https://github.com/ueberdosis/tiptap/commit/9425e7249a15e0fb4e8c714545c09f367d216536))

# [2.0.0-beta.94](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.93...@tiptap/core@2.0.0-beta.94) (2021-08-09)

### Bug Fixes

- add CreateNodeFromContentOptions to insertContent ([#1678](https://github.com/ueberdosis/tiptap/issues/1678)) ([aabdfd6](https://github.com/ueberdosis/tiptap/commit/aabdfd6f7de65e62a57bd237eb775256b413abea))
- fix isEditable check on initialization ([f6f8cf9](https://github.com/ueberdosis/tiptap/commit/f6f8cf9f9366adbea30600a34619bdd4e6d3a4e4))
- fix updating editorProps via setOptions ([#1540](https://github.com/ueberdosis/tiptap/issues/1540)), fix [#1518](https://github.com/ueberdosis/tiptap/issues/1518) ([e6f67ca](https://github.com/ueberdosis/tiptap/commit/e6f67caef37d3fb73adadfb64060541a0b791924))

# [2.0.0-beta.93](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.92...@tiptap/core@2.0.0-beta.93) (2021-07-30)

### Bug Fixes

- revert async focus, fix [#1658](https://github.com/ueberdosis/tiptap/issues/1658) ([c9869c8](https://github.com/ueberdosis/tiptap/commit/c9869c8d3021510366a46e840a66e8c06a6586ed))

# [2.0.0-beta.92](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.91...@tiptap/core@2.0.0-beta.92) (2021-07-28)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.91](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.90...@tiptap/core@2.0.0-beta.91) (2021-07-28)

### Bug Fixes

- fix a bug in markPasteRule ([c2ccf68](https://github.com/ueberdosis/tiptap/commit/c2ccf68e8b4c869f707f3b1fdf51474e7f64b6f3))

# [2.0.0-beta.90](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.89...@tiptap/core@2.0.0-beta.90) (2021-07-28)

### Features

- add deleteNode command ([73f1c50](https://github.com/ueberdosis/tiptap/commit/73f1c50bca8ffcd074388519eec9c659b0fda14c))

# [2.0.0-beta.89](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.88...@tiptap/core@2.0.0-beta.89) (2021-07-27)

### Features

- add ignoreMutation option to NodeViewRenderer, fix [#1538](https://github.com/ueberdosis/tiptap/issues/1538) ([651e691](https://github.com/ueberdosis/tiptap/commit/651e6911e3ea5407df6a48783ee16733e0a4f474))

# [2.0.0-beta.88](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.87...@tiptap/core@2.0.0-beta.88) (2021-07-26)

### Features

- Allow a rule to be skipped from the getAttributes callback in markPasteRule ([#1625](https://github.com/ueberdosis/tiptap/issues/1625)) ([9ffd58c](https://github.com/ueberdosis/tiptap/commit/9ffd58cf256bf3c0cd5a217b8933826c70b9b841))

# [2.0.0-beta.87](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.86...@tiptap/core@2.0.0-beta.87) (2021-07-26)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.86](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.85...@tiptap/core@2.0.0-beta.86) (2021-07-09)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.85](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.84...@tiptap/core@2.0.0-beta.85) (2021-06-23)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.84](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.83...@tiptap/core@2.0.0-beta.84) (2021-06-17)

### Bug Fixes

- improve types for generateHTML ([502b5b1](https://github.com/ueberdosis/tiptap/commit/502b5b1cc9f1a8beb49ef2da81a9db56c7e92424))

# [2.0.0-beta.83](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.82...@tiptap/core@2.0.0-beta.83) (2021-06-15)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.82](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.81...@tiptap/core@2.0.0-beta.82) (2021-06-14)

### Bug Fixes

- check for atom nodes in ignoreMutation handler, fix [#1448](https://github.com/ueberdosis/tiptap/issues/1448) ([2deb07f](https://github.com/ueberdosis/tiptap/commit/2deb07fb005d4376790d1e22b3fc53353d1665eb))
- remove editable check in updateAttributes, fix [#1415](https://github.com/ueberdosis/tiptap/issues/1415) ([fbc8fff](https://github.com/ueberdosis/tiptap/commit/fbc8fffb701dd78994ca4e20c32a940236bf768d))

# [2.0.0-beta.81](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.80...@tiptap/core@2.0.0-beta.81) (2021-06-07)

### Bug Fixes

- fix a bug when insert newline at node start, fix [#1411](https://github.com/ueberdosis/tiptap/issues/1411) ([b97bebe](https://github.com/ueberdosis/tiptap/commit/b97bebe021e6e587770cb99f94b18ee6d96c1630))

### Features

- add forEach command ([783ce4e](https://github.com/ueberdosis/tiptap/commit/783ce4e3ac11c0705cb2d54158bfe76d39b3a36b))
- add Tracker class ([a757716](https://github.com/ueberdosis/tiptap/commit/a757716f684e16c60bff5b58e508106f39368dc2))

# [2.0.0-beta.80](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.79...@tiptap/core@2.0.0-beta.80) (2021-06-03)

### Bug Fixes

- fix merging options on configure for multiple extension instances ([d037c56](https://github.com/ueberdosis/tiptap/commit/d037c5656a113ac7205104a815310727b23c30d4))

# [2.0.0-beta.79](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.77...@tiptap/core@2.0.0-beta.79) (2021-06-02)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.77](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.76...@tiptap/core@2.0.0-beta.77) (2021-06-02)

### Features

- add setMeta command ([36dad2b](https://github.com/ueberdosis/tiptap/commit/36dad2bbae5ed66077822330133a9d8ee0d28747))

# [2.0.0-beta.76](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.75...@tiptap/core@2.0.0-beta.76) (2021-06-01)

### Bug Fixes

- remove custom coordsAtPos method, fix [#583](https://github.com/ueberdosis/tiptap/issues/583) ([485fb8c](https://github.com/ueberdosis/tiptap/commit/485fb8c74c831256aaa2cefdf130e05438c2e476))

# [2.0.0-beta.75](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.74...@tiptap/core@2.0.0-beta.75) (2021-06-01)

### Bug Fixes

- prevent dispatch empty fragment when parsing content with insertContent ([2a4e02a](https://github.com/ueberdosis/tiptap/commit/2a4e02ade3b74999a9632673a607568644d6d26c))

# [2.0.0-beta.74](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.73...@tiptap/core@2.0.0-beta.74) (2021-05-31)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.73](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.72...@tiptap/core@2.0.0-beta.73) (2021-05-29)

### Bug Fixes

- check for excluded marks in isMarkActive, fix [#1388](https://github.com/ueberdosis/tiptap/issues/1388) ([3c4cc96](https://github.com/ueberdosis/tiptap/commit/3c4cc96fee7fc32e363d3b8a2503684435f30c35))

# [2.0.0-beta.72](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.71...@tiptap/core@2.0.0-beta.72) (2021-05-28)

### Bug Fixes

- fix error when calculating contentMatch within clearNodes command, fix [#1361](https://github.com/ueberdosis/tiptap/issues/1361) ([3709668](https://github.com/ueberdosis/tiptap/commit/370966847efd7bbc1b033cf5952f2427e62c1525))

# [2.0.0-beta.71](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.70...@tiptap/core@2.0.0-beta.71) (2021-05-28)

### Bug Fixes

- fix fragile schema validity test in splitBlock ([e52f41a](https://github.com/ueberdosis/tiptap/commit/e52f41ae7864210bc0e4107db21e09607d2e586f))

# [2.0.0-beta.70](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.69...@tiptap/core@2.0.0-beta.70) (2021-05-28)

### Bug Fixes

- prevent bug when editor is destroyed very fast ([939fc3d](https://github.com/ueberdosis/tiptap/commit/939fc3d93ab67d54b7fe67b64c423290b3a40df8))

# [2.0.0-beta.69](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.68...@tiptap/core@2.0.0-beta.69) (2021-05-27)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.68](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.67...@tiptap/core@2.0.0-beta.68) (2021-05-24)

### Bug Fixes

- do not check for node selection within posToDOMRect ([c0e68d5](https://github.com/ueberdosis/tiptap/commit/c0e68d5a25608e0b6d9c127bbc507b4ba2a94a61))

# [2.0.0-beta.67](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.66...@tiptap/core@2.0.0-beta.67) (2021-05-24)

### Bug Fixes

- check for NodeSelection within posToDOMRect ([a4ec4ff](https://github.com/ueberdosis/tiptap/commit/a4ec4ffcfd855894b0fa780f9f72f87399e36402))
- remove empty attributes in getDebugJSON ([940fd69](https://github.com/ueberdosis/tiptap/commit/940fd69b61b6eb56ca05235d22993eb202a20c1d))

# [2.0.0-beta.66](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.65...@tiptap/core@2.0.0-beta.66) (2021-05-19)

### Bug Fixes

- preserve whitespace when using insertContent command ([8f10181](https://github.com/ueberdosis/tiptap/commit/8f101810feace676fedce449e71d3af1d152436b))

# [2.0.0-beta.65](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.64...@tiptap/core@2.0.0-beta.65) (2021-05-18)

### Features

- allow number for setTextSelection and insertContentAt ([2f7a6ad](https://github.com/ueberdosis/tiptap/commit/2f7a6adca54290b65467121e55838e5cfcf9ea8b))

# [2.0.0-beta.64](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.63...@tiptap/core@2.0.0-beta.64) (2021-05-18)

### Bug Fixes

- add marks to JSONContent type ([f829b45](https://github.com/ueberdosis/tiptap/commit/f829b45bf018aa769780a9987a1b2cdaaad8a44a))

### Features

- add deleteNode method to node views ([fcee5f8](https://github.com/ueberdosis/tiptap/commit/fcee5f82c6a282191afe5c2cb83b9f5820af28dd))

# [2.0.0-beta.63](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.62...@tiptap/core@2.0.0-beta.63) (2021-05-18)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.62](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.61...@tiptap/core@2.0.0-beta.62) (2021-05-17)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.61](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.60...@tiptap/core@2.0.0-beta.61) (2021-05-17)

### Bug Fixes

- fix export for getAttributes ([5b8808a](https://github.com/ueberdosis/tiptap/commit/5b8808a89990b808d7f84c004a07e14b046c12b9))

### Features

- add findChildrenInRange helper ([463661c](https://github.com/ueberdosis/tiptap/commit/463661c5ed2fe4a1530888c8f09bb966794e33e6))
- add support for checking for attributes in extendMarkRange ([ff7dd9b](https://github.com/ueberdosis/tiptap/commit/ff7dd9b919c7b5e0f845369c744116045bab5028))
- export isList, fix [#1326](https://github.com/ueberdosis/tiptap/issues/1326) ([2bd17c7](https://github.com/ueberdosis/tiptap/commit/2bd17c7dc66d2d2c3131bce9e5a82326a990080c))

# [2.0.0-beta.60](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.59...@tiptap/core@2.0.0-beta.60) (2021-05-13)

### Bug Fixes

- fix missing extensions when using `addExtension`, fix [#1309](https://github.com/ueberdosis/tiptap/issues/1309) ([28737b1](https://github.com/ueberdosis/tiptap/commit/28737b1631719315cebc354f7cb5a1d924b0b543))

# [2.0.0-beta.59](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.57...@tiptap/core@2.0.0-beta.59) (2021-05-13)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.57](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.56...@tiptap/core@2.0.0-beta.57) (2021-05-13)

### Bug Fixes

- **core:** Increment `i` in `defaultBlockAt` ([655957d](https://github.com/ueberdosis/tiptap/commit/655957d73304f57d87b8e95d89de00da762c0fa9))

# [2.0.0-beta.57](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.56...@tiptap/core@2.0.0-beta.57) (2021-05-13)

### Bug Fixes

- **core:** Increment `i` in `defaultBlockAt` ([655957d](https://github.com/ueberdosis/tiptap/commit/655957d73304f57d87b8e95d89de00da762c0fa9))

# [2.0.0-beta.56](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.55...@tiptap/core@2.0.0-beta.56) (2021-05-13)

### Bug Fixes

- fix a bug in detecting a current list in toggleList command ([a35b253](https://github.com/ueberdosis/tiptap/commit/a35b2533eb87c683c0bff56b574aff490f490980))

# [2.0.0-beta.55](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.54...@tiptap/core@2.0.0-beta.55) (2021-05-11)

### Bug Fixes

- fix a bug when configurating the same extension multiple times ([655c564](https://github.com/ueberdosis/tiptap/commit/655c5647f0951851f818a0cc2500c48969f20797))

### Features

- export mark helpers ([313ab0e](https://github.com/ueberdosis/tiptap/commit/313ab0eac7d9209c279f0925c2372735882de56a))

# [2.0.0-beta.54](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.53...@tiptap/core@2.0.0-beta.54) (2021-05-09)

### Bug Fixes

- set correct priority when extending extensions, fix [#1288](https://github.com/ueberdosis/tiptap/issues/1288) ([b4e2b6f](https://github.com/ueberdosis/tiptap/commit/b4e2b6fc9dd722cce5ee85eb2df994453a0f5d39))

# [2.0.0-beta.53](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.52...@tiptap/core@2.0.0-beta.53) (2021-05-07)

### Features

- add editor.getAttributes, deprecate editor.getNodeAttributes and editor.getMarkAttributes ([072905c](https://github.com/ueberdosis/tiptap/commit/072905cb95e022a37f5bc937889999bfbb33ad88))

# [2.0.0-beta.52](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.51...@tiptap/core@2.0.0-beta.52) (2021-05-07)

### Features

- expose node helpers to core ([6048f9b](https://github.com/ueberdosis/tiptap/commit/6048f9b31b996b305f704c4ae3ed176fa42eb943))

# [2.0.0-beta.51](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.50...@tiptap/core@2.0.0-beta.51) (2021-05-07)

### Bug Fixes

- add support for priority and nested extension for getSchema ([129ad83](https://github.com/ueberdosis/tiptap/commit/129ad83167900526d65c5c25da8249d0d65bcef7))
- remove editor from addExtensions context ([cbc0dd8](https://github.com/ueberdosis/tiptap/commit/cbc0dd8920ab7d36516387ceac59239f9162b4ec))

# [2.0.0-beta.50](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.49...@tiptap/core@2.0.0-beta.50) (2021-05-07)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.49](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.48...@tiptap/core@2.0.0-beta.49) (2021-05-07)

### Bug Fixes

- fix a bug that messed up pasted link attributes, fix [#1284](https://github.com/ueberdosis/tiptap/issues/1284) ([7da647d](https://github.com/ueberdosis/tiptap/commit/7da647d99f1dcefabc653347a8e2abfae3bb972e))
- revert adding exports ([bc320d0](https://github.com/ueberdosis/tiptap/commit/bc320d0b4b80b0e37a7e47a56e0f6daec6e65d98))

# [2.0.0-beta.48](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.47...@tiptap/core@2.0.0-beta.48) (2021-05-06)

### Bug Fixes

- revert adding type: module ([f8d6475](https://github.com/ueberdosis/tiptap/commit/f8d6475e2151faea6f96baecdd6bd75880d50d2c))

# [2.0.0-beta.47](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.46...@tiptap/core@2.0.0-beta.47) (2021-05-06)

### Bug Fixes

- add exports to package.json ([1277fa4](https://github.com/ueberdosis/tiptap/commit/1277fa47151e9c039508cdb219bdd0ffe647f4ee))

# [2.0.0-beta.46](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.45...@tiptap/core@2.0.0-beta.46) (2021-05-06)

### Features

- add addExtensions option ([26e672e](https://github.com/ueberdosis/tiptap/commit/26e672e2f02a8f94941c704f3cd6cc4adef40df7))

# [2.0.0-beta.45](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.44...@tiptap/core@2.0.0-beta.45) (2021-05-06)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.44](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.43...@tiptap/core@2.0.0-beta.44) (2021-05-05)

### Features

- remove deprecated commands insertHTML, insertNode and insertText ([86d570f](https://github.com/ueberdosis/tiptap/commit/86d570fb79b89a061cf1a5374a377ed6d9bca49e))

# [2.0.0-beta.43](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.42...@tiptap/core@2.0.0-beta.43) (2021-05-05)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.42](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.41...@tiptap/core@2.0.0-beta.42) (2021-05-04)

### Bug Fixes

- ignore editable in dispatchTransaction, fix [#1239](https://github.com/ueberdosis/tiptap/issues/1239) ([b3fb022](https://github.com/ueberdosis/tiptap/commit/b3fb0228e04a227bfc4536b167a93b3172169378))

# [2.0.0-beta.41](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.40...@tiptap/core@2.0.0-beta.41) (2021-04-27)

### Bug Fixes

- fix onBeforeCreate event handler, fix [#1236](https://github.com/ueberdosis/tiptap/issues/1236) ([0b67f18](https://github.com/ueberdosis/tiptap/commit/0b67f18e3a109609cd9b2371396c5f6b8ed85f96))

# [2.0.0-beta.40](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.39...@tiptap/core@2.0.0-beta.40) (2021-04-27)

### Bug Fixes

- prevent a bug for node views when pressing enter on iOS, fix [#1214](https://github.com/ueberdosis/tiptap/issues/1214) ([234d238](https://github.com/ueberdosis/tiptap/commit/234d23887bfcb19c3591deb391688ec9d4e49a8a))

### Features

- add setNodeSelection and setTextSelection commands ([811bf69](https://github.com/ueberdosis/tiptap/commit/811bf693eb5b927ec5f8120b56b2ae92f5ba2734))

# [2.0.0-beta.39](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.38...@tiptap/core@2.0.0-beta.39) (2021-04-27)

### Bug Fixes

- add correct type for parseOptions ([592892e](https://github.com/ueberdosis/tiptap/commit/592892edd1c4d6dbaa9ea3ddd21f4615f0087053))
- fix type error for commands ([26785db](https://github.com/ueberdosis/tiptap/commit/26785dbec00cbb3dc3196bd9a7cbebb7452e4a2e))
- set correct type for emitUpdate ([9a40c17](https://github.com/ueberdosis/tiptap/commit/9a40c17b3422b22a2cfe1fbac76ca06c9e78ae8c))

# [2.0.0-beta.38](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.37...@tiptap/core@2.0.0-beta.38) (2021-04-23)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.37](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.36...@tiptap/core@2.0.0-beta.37) (2021-04-23)

### Bug Fixes

- better merge mark attributes for existing marks, fix [#1039](https://github.com/ueberdosis/tiptap/issues/1039) ([cfd29fa](https://github.com/ueberdosis/tiptap/commit/cfd29fac86e03d72a0c05ec8d26aac905d19c5a2))

# [2.0.0-beta.36](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.35...@tiptap/core@2.0.0-beta.36) (2021-04-22)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.35](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.34...@tiptap/core@2.0.0-beta.35) (2021-04-21)

### Features

- add editor prop to KeyboardShortcutCommand ([e0c2460](https://github.com/ueberdosis/tiptap/commit/e0c2460a960c739ac4b543f0f185653cb41599e3))
- add name to extension context ([12f60ab](https://github.com/ueberdosis/tiptap/commit/12f60abb731edd080cb9a70e8e34ae721e37f80e))

# [2.0.0-beta.34](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.33...@tiptap/core@2.0.0-beta.34) (2021-04-20)

### Bug Fixes

- fix a bug when dragging node views ([4e6d43b](https://github.com/ueberdosis/tiptap/commit/4e6d43bbfb488d2987f71ad15732af8d25b9897a))

# [2.0.0-beta.33](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.32...@tiptap/core@2.0.0-beta.33) (2021-04-20)

### Bug Fixes

- fix extension option merging ([aa002a0](https://github.com/ueberdosis/tiptap/commit/aa002a012bfe888c03da5cd32f98b40965a5fa7b))

# [2.0.0-beta.32](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.31...@tiptap/core@2.0.0-beta.32) (2021-04-16)

### Features

- add coordsAtPos and posToClientRect helper methods ([8dab614](https://github.com/ueberdosis/tiptap/commit/8dab6144a661e4c90f33d9d2f300882009eadd46))
- remove resize event handler ([9f64015](https://github.com/ueberdosis/tiptap/commit/9f64015157a83032d0d80bc0353efb529b56a342))

# [2.0.0-beta.31](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.30...@tiptap/core@2.0.0-beta.31) (2021-04-15)

### Bug Fixes

- fix type for emitUpdate, fix [#276](https://github.com/ueberdosis/tiptap/issues/276) ([4137e00](https://github.com/ueberdosis/tiptap/commit/4137e00d987c152b883022525056df94ad033be7))

# [2.0.0-beta.30](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.29...@tiptap/core@2.0.0-beta.30) (2021-04-15)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.29](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.28...@tiptap/core@2.0.0-beta.29) (2021-04-12)

### Bug Fixes

- fix adding mark only with insertContent(), fix [#264](https://github.com/ueberdosis/tiptap/issues/264) ([0a63123](https://github.com/ueberdosis/tiptap/commit/0a6312382f38af5b8fdf7f94fc4b6c1de1a15e25))

# [2.0.0-beta.28](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.27...@tiptap/core@2.0.0-beta.28) (2021-04-12)

### Features

- add parentConfig to extension context for more extendable extensions, fix [#259](https://github.com/ueberdosis/tiptap/issues/259) ([5e1ec5d](https://github.com/ueberdosis/tiptap/commit/5e1ec5d2a66be164f505d631f97861ab9344ba96))

# [2.0.0-beta.27](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.26...@tiptap/core@2.0.0-beta.27) (2021-04-09)

### Bug Fixes

- add scrollIntoView for insertContent ([e7fe724](https://github.com/ueberdosis/tiptap/commit/e7fe7248af44df66fe322045953f8df186d82bec))

# [2.0.0-beta.26](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.25...@tiptap/core@2.0.0-beta.26) (2021-04-09)

### Bug Fixes

- fix a bug when detecting changes within node views ([708ac94](https://github.com/ueberdosis/tiptap/commit/708ac94cebce2ed9304ae7e87eb4c3251758f903))

# [2.0.0-beta.25](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.24...@tiptap/core@2.0.0-beta.25) (2021-04-09)

### Bug Fixes

- fixed type for Content ([39147f5](https://github.com/ueberdosis/tiptap/commit/39147f5b02388b68ddea91d40bd2e846597f813b))

# [2.0.0-beta.24](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.23...@tiptap/core@2.0.0-beta.24) (2021-04-08)

### Bug Fixes

- improve drag position for node views even more ([d2c5b71](https://github.com/ueberdosis/tiptap/commit/d2c5b71c28b04ff64715ff6562e7dcb01cfd7ec8))

# [2.0.0-beta.23](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.22...@tiptap/core@2.0.0-beta.23) (2021-04-08)

### Bug Fixes

- improve drag position for node views ([5e5b8db](https://github.com/ueberdosis/tiptap/commit/5e5b8db6eb707aa570b462caf184401189228b02))

# [2.0.0-beta.22](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.21...@tiptap/core@2.0.0-beta.22) (2021-04-08)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.21](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.20...@tiptap/core@2.0.0-beta.21) (2021-04-08)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.20](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.19...@tiptap/core@2.0.0-beta.20) (2021-04-07)

### Features

- add resetAttributes() command, deprecate resetNodeAttributes() ([3334d93](https://github.com/ueberdosis/tiptap/commit/3334d930f30bd4acb5c314b4ec1934b6a1e0b712))

# [2.0.0-beta.19](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.18...@tiptap/core@2.0.0-beta.19) (2021-04-07)

### Features

- add updateAttributes() command, deprecate updateNodeAttributes(), fix [#254](https://github.com/ueberdosis/tiptap/issues/254) ([aac32b4](https://github.com/ueberdosis/tiptap/commit/aac32b4df6a1dfd93500e09d3433fcd8acad5fbe))

# [2.0.0-beta.18](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.17...@tiptap/core@2.0.0-beta.18) (2021-04-07)

### Features

- add priority option to extensions ([bb1ae65](https://github.com/ueberdosis/tiptap/commit/bb1ae659a463e97a7ada15af711347b5c004897a))

# [2.0.0-beta.17](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.16...@tiptap/core@2.0.0-beta.17) (2021-04-07)

### Bug Fixes

- remove debug log ([beb96c5](https://github.com/ueberdosis/tiptap/commit/beb96c5cbfdb81869763e23f82f5ab270c30f0ea))

# [2.0.0-beta.16](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.15...@tiptap/core@2.0.0-beta.16) (2021-04-07)

### Features

- add insertContent() command, deprecate insertText(), insertHTML() and insertNode() ([b8d9b7d](https://github.com/ueberdosis/tiptap/commit/b8d9b7d4c70b38fb9eec3c079be8243d30166e5e))

# [2.0.0-beta.15](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.14...@tiptap/core@2.0.0-beta.15) (2021-04-06)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.14](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.13...@tiptap/core@2.0.0-beta.14) (2021-04-04)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.13](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.12...@tiptap/core@2.0.0-beta.13) (2021-04-02)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.12](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.11...@tiptap/core@2.0.0-beta.12) (2021-04-01)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.11](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.10...@tiptap/core@2.0.0-beta.11) (2021-04-01)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.10](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.9...@tiptap/core@2.0.0-beta.10) (2021-03-31)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.9](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.8...@tiptap/core@2.0.0-beta.9) (2021-03-28)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.8](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.7...@tiptap/core@2.0.0-beta.8) (2021-03-28)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.7](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.6...@tiptap/core@2.0.0-beta.7) (2021-03-28)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.6](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.5...@tiptap/core@2.0.0-beta.6) (2021-03-24)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.5](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.4...@tiptap/core@2.0.0-beta.5) (2021-03-18)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.4](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.3...@tiptap/core@2.0.0-beta.4) (2021-03-18)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.3](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.2...@tiptap/core@2.0.0-beta.3) (2021-03-16)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.2](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-beta.1...@tiptap/core@2.0.0-beta.2) (2021-03-09)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-beta.1](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.22...@tiptap/core@2.0.0-beta.1) (2021-03-05)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.22](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.21...@tiptap/core@2.0.0-alpha.22) (2021-02-28)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.21](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.20...@tiptap/core@2.0.0-alpha.21) (2021-02-26)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.20](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.19...@tiptap/core@2.0.0-alpha.20) (2021-02-26)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.19](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.18...@tiptap/core@2.0.0-alpha.19) (2021-02-18)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.18](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.17...@tiptap/core@2.0.0-alpha.18) (2021-02-16)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.17](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.16...@tiptap/core@2.0.0-alpha.17) (2021-02-16)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.16](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.15...@tiptap/core@2.0.0-alpha.16) (2021-02-07)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.15](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.14...@tiptap/core@2.0.0-alpha.15) (2021-02-05)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.14](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.13...@tiptap/core@2.0.0-alpha.14) (2021-01-29)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.13](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.12...@tiptap/core@2.0.0-alpha.13) (2021-01-29)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.12](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.11...@tiptap/core@2.0.0-alpha.12) (2021-01-28)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.11](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.10...@tiptap/core@2.0.0-alpha.11) (2021-01-28)

### Bug Fixes

- don’t merge classes ([dba0c1a](https://github.com/ueberdosis/tiptap/commit/dba0c1ac15e9beda3ebd027c67c969a4fe7ae7c7))

# [2.0.0-alpha.10](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.9...@tiptap/core@2.0.0-alpha.10) (2021-01-06)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.9](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.8...@tiptap/core@2.0.0-alpha.9) (2020-12-18)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.8](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.7...@tiptap/core@2.0.0-alpha.8) (2020-12-18)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.7](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.6...@tiptap/core@2.0.0-alpha.7) (2020-12-02)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.6](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.5...@tiptap/core@2.0.0-alpha.6) (2020-11-19)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.5](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.4...@tiptap/core@2.0.0-alpha.5) (2020-11-18)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.4](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.3...@tiptap/core@2.0.0-alpha.4) (2020-11-16)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.3](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.2...@tiptap/core@2.0.0-alpha.3) (2020-11-16)

### Reverts

- Revert "use global namespace" ([0c9ce26](https://github.com/ueberdosis/tiptap/commit/0c9ce26c02c07d88a757c01b0a9d7f9e2b0b7502))

# [2.0.0-alpha.2](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.1...@tiptap/core@2.0.0-alpha.2) (2020-11-16)

**Note:** Version bump only for package @tiptap/core

# [2.0.0-alpha.1](https://github.com/ueberdosis/tiptap/compare/@tiptap/core@2.0.0-alpha.0...@tiptap/core@2.0.0-alpha.1) (2020-11-16)

**Note:** Version bump only for package @tiptap/core
