'use strict'
const path = require('path')

function resolve(dir) {
  return path.join(__dirname, dir)
}

module.exports = {
  //开发服务配置
  devServer: {
    port: 3000, // 端口号
    host: 'localhost',  // 主机
    https: false,  // 是否启用https
    open: false // 配置是否自动启动浏览器
  },
  configureWebpack: {
    resolve: {
      extensions: ['.js', '.vue', '.json', '.ts'],
      alias: {
        '@': resolve('src'),
      }
    },
    plugins: [],
    // webpack-load配置
    module: {
      rules: []
    }
  },
  publicPath: process.env.NODE_ENV === 'production' ? '././' : './',
  runtimeCompiler: true,
  chainWebpack: config => {
    config.module
      .rule('svg')
      .exclude.add(resolve('src/icons'))
      .end()
   
    config.module
      .rule('icons')
      .test(/\.svg$/)
      .include.add(resolve('src/icons'))
      .end()
      .use('svg-sprite-loader')
      .loader('svg-sprite-loader')
      .options({
        symbolId: 'icon-[name]'
      })
  }
}