export function GoldBadge({ className }: { className?: string }) {
  return (
    <svg
      width="240"
      height="240"
      viewBox="0 0 240 240"
      fill="none"
      className={className}
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clip-path="url(#clip0_1_71)">
        <circle cx="120" cy="120" r="120" fill="url(#paint0_linear_1_71)" />
        <path
          d="M138.156 33.3177L139.579 28.7621L150.529 24.2829C151.256 23.9849 151.889 23.6911 152.43 23.4016C152.98 23.1069 153.435 22.7699 153.796 22.3908C154.163 22.014 154.433 21.5522 154.603 21.0056C154.791 20.4058 154.822 19.8529 154.697 19.3471C154.579 18.8436 154.332 18.408 153.955 18.0403C153.58 17.6649 153.101 17.386 152.516 17.2033C151.932 17.0206 151.379 16.977 150.857 17.0724C150.343 17.1702 149.894 17.4089 149.508 17.7886C149.123 18.1682 148.828 18.6845 148.624 19.3375L142.611 17.4587C143.123 15.8187 143.933 14.5215 145.039 13.5672C146.146 12.6129 147.471 12.0267 149.014 11.8088C150.557 11.5909 152.232 11.7643 154.039 12.3289C155.907 12.9124 157.43 13.7176 158.61 14.7444C159.799 15.766 160.597 16.9321 161.004 18.2427C161.419 19.5557 161.4 20.9373 160.947 22.3875C160.667 23.2834 160.202 24.1174 159.553 24.8895C158.906 25.654 157.933 26.4209 156.634 27.1902C155.335 27.9595 153.566 28.8069 151.327 29.7323L148.571 30.8714L148.528 31.008L157.639 33.8547L156.059 38.9113L138.156 33.3177Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M166.608 46.0234C164.75 44.8089 163.421 43.3352 162.62 41.6022C161.82 39.8692 161.574 37.9605 161.883 35.876C162.193 33.7915 163.08 31.627 164.546 29.3824C166.016 27.1311 167.625 25.4539 169.374 24.3509C171.13 23.2522 172.948 22.7296 174.828 22.7833C176.716 22.8412 178.59 23.4741 180.452 24.6819C182.314 25.8897 183.654 27.3468 184.472 29.0531C185.294 30.7527 185.561 32.6281 185.274 34.6792C184.986 36.7303 184.109 38.8782 182.644 41.1228C181.176 43.3851 179.554 45.0822 177.776 46.2143C175.999 47.3464 174.156 47.9002 172.247 47.8755C170.349 47.8486 168.47 47.2312 166.608 46.0234ZM169.543 41.4989C170.504 42.1222 171.616 42.1326 172.879 41.5298C174.153 40.9248 175.486 39.5423 176.878 37.3825C177.791 35.9744 178.398 34.7323 178.698 33.6563C178.998 32.5802 179.039 31.6685 178.822 30.921C178.61 30.1669 178.184 29.582 177.543 29.1664C176.582 28.5431 175.482 28.5216 174.242 29.1019C173.003 29.6823 171.693 31.0225 170.311 33.1227C169.374 34.5531 168.745 35.8231 168.423 36.9325C168.106 38.0352 168.051 38.967 168.26 39.7278C168.474 40.4929 168.902 41.0833 169.543 41.4989Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M177.635 53.049L181.203 49.8793L192.895 51.6866C193.671 51.8057 194.365 51.8806 194.978 51.9112C195.601 51.9425 196.165 51.8885 196.669 51.7493C197.179 51.616 197.647 51.3592 198.076 50.9788C198.545 50.5615 198.857 50.1038 199.01 49.6058C199.169 49.1137 199.182 48.6129 199.049 48.1036C198.921 47.5889 198.654 47.1027 198.247 46.6447C197.841 46.1868 197.389 45.8643 196.893 45.6772C196.403 45.496 195.894 45.4688 195.368 45.5954C194.842 45.7221 194.324 46.0126 193.812 46.4669L189.628 41.7569C190.913 40.6158 192.275 39.9216 193.715 39.6744C195.156 39.4271 196.593 39.6079 198.028 40.2168C199.462 40.8257 200.808 41.8378 202.065 43.2532C203.365 44.7162 204.255 46.1916 204.736 47.6794C205.229 49.1678 205.312 50.5786 204.985 51.9115C204.663 53.2504 203.935 54.4244 202.799 55.4334C202.097 56.0568 201.269 56.5318 200.314 56.8585C199.365 57.1799 198.136 57.3353 196.627 57.3249C195.117 57.3145 193.165 57.1286 190.769 56.7671L187.82 56.3222L187.713 56.4173L194.052 63.5538L190.092 67.0721L177.635 53.049Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M194.38 66.5069L198.988 64.1964L217.218 66.0538L219.314 70.2349L213.171 73.3155L211.973 70.9263L202.089 69.9558L201.919 70.0414L208.422 83.0113L203.814 85.3217L194.38 66.5069ZM196.294 78.8417L201.115 76.4242L203.184 75.5468L218.202 68.0164L220.983 73.5627L199.139 84.516L196.294 78.8417Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M221.156 239.923L170.285 112.369C168.467 107.825 166.02 103.56 163.014 99.6991C155.432 89.9225 144.6 83.1843 132.479 80.7049C120.358 78.2255 107.75 80.1689 96.9385 86.1831C86.1268 92.1973 77.8265 101.885 73.5408 113.49C69.2551 125.096 69.2675 137.853 73.5757 149.451C73.8698 150.387 74.2366 151.299 74.6727 152.178C75.9245 154.694 77.7197 156.9 79.9285 158.637C82.1373 160.374 84.7045 161.599 87.4445 162.222C90.1844 162.845 93.0287 162.852 95.7715 162.241C98.5144 161.631 101.087 160.419 103.304 158.692C110.131 153.375 108.993 146.034 107.894 138.934C107.618 137.153 107.331 135.31 107.167 133.49C106.422 125.231 113.212 121.211 113.49 121.05L113.665 120.952L113.822 120.828C115.484 119.536 117.423 118.647 119.487 118.231C121.551 117.815 123.683 117.884 125.715 118.431C127.748 118.978 129.626 119.989 131.202 121.385C132.778 122.781 134.009 124.523 134.798 126.475L135.24 127.74L184.838 252.404C185.387 253.782 186.128 255.074 187.039 256.244L187.339 256.632C188.864 258.602 190.764 260.25 192.931 261.482C195.097 262.713 197.486 263.502 199.959 263.804C201.299 263.971 202.654 263.996 203.999 263.879C207.577 263.56 210.988 262.224 213.831 260.029C214.835 259.398 219.72 256.083 221.419 250.233C223.003 244.752 221.238 240.122 221.156 239.923ZM194.078 198.656C193.089 205.451 189.894 215.662 180.517 227.034L169.715 199.889C181.156 186.908 185.063 174.964 186.281 166.945L193.689 185.518C193.877 186.156 195.17 191.138 194.078 198.656ZM159.196 173.447C170.333 159.795 173.91 147.026 174.887 138.383L180.622 152.761C180.802 153.4 182.105 158.38 181.013 165.899C180.026 172.69 176.834 182.89 167.472 194.252L159.196 173.447ZM165.305 114.357L168.728 122.943C168.917 123.576 170.462 129.097 169.605 137.359C168.841 144.712 165.969 155.681 156.902 167.688L148.932 147.684C157.911 133.764 159.866 120.221 159.898 111.218C159.908 108.808 159.785 106.4 159.529 104.004C161.886 107.195 163.827 110.675 165.305 114.357ZM102.19 137.094C96.7977 135.367 91.8426 135.455 87.4123 137.368C82.9821 139.282 79.9112 142.715 77.959 145.732C75.7273 138.817 75.1526 131.475 76.2813 124.297C78.5997 122.526 84.1077 118.952 90.5159 119.26C94.9864 119.476 99.1966 121.559 103.047 125.459C101.957 128.155 101.538 131.076 101.826 133.97C101.921 135.028 102.052 136.069 102.19 137.094ZM100.003 154.461C97.1565 156.673 93.5491 157.666 89.9717 157.222C86.3943 156.778 83.139 154.934 80.92 152.093C80.8547 152.009 80.7956 151.926 80.7344 151.842C81.8344 149.377 84.5804 144.415 89.5708 142.278C93.3937 140.64 97.9313 140.936 103.074 143.151C103.731 148.381 103.454 151.778 100.009 154.46L100.003 154.461ZM110.66 116.489C108.846 117.636 107.231 119.07 105.876 120.734C101.292 116.449 96.2037 114.154 90.7135 113.901C85.7951 113.677 81.4093 115.154 78.0677 116.852C80.85 108.321 86.0673 100.791 93.0766 95.1898C96.0133 94.7742 109.497 94.013 117.012 113.303C114.715 113.955 112.562 115.036 110.666 116.489L110.66 116.489ZM124.511 112.741C123.835 112.657 123.155 112.61 122.474 112.599C120.403 106.895 117.68 102.163 114.36 98.5214C111.342 95.1924 107.816 92.7612 103.892 91.2946C102.794 90.8831 101.668 90.5497 100.522 90.2969C108.882 85.8832 118.4 84.1549 127.778 85.3475C127.987 85.3705 128.178 85.4013 128.379 85.4292C130.793 88.3761 132.71 91.6963 134.057 95.2594C136.73 102.459 136.366 109.413 132.98 115.97C130.463 114.222 127.558 113.114 124.517 112.741L124.511 112.741ZM139.832 124.645L139.788 124.531C139.125 122.871 138.231 121.314 137.131 119.905C137.094 119.857 137.055 119.812 137.017 119.764C141.76 111.469 142.459 102.324 139.013 93.1963C138.215 91.1071 137.241 89.0892 136.103 87.1642C142.228 89.0951 147.882 92.2865 152.7 96.5334C153.765 100.245 158.529 120.038 146.446 141.428L140.253 125.863L139.832 124.645ZM182.752 232.676C194.21 219.685 198.119 207.721 199.338 199.707L206.271 217.092C206.415 217.7 207.18 221.478 205.587 227.374C203.039 236.805 196.288 245.225 190.199 251.272C190.059 250.997 189.93 250.714 189.816 250.428L182.752 232.676ZM216.257 248.749C215.01 253.045 210.974 255.493 210.943 255.513L210.789 255.603L210.648 255.712C208.202 257.617 205.179 258.63 202.08 258.581C198.98 258.533 195.99 257.427 193.605 255.447C204.385 244.888 208.996 235.534 210.836 228.532L216.169 241.879C216.866 244.11 216.898 246.496 216.261 248.745L216.257 248.749Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
      </g>
      <defs>
        <linearGradient
          id="paint0_linear_1_71"
          x1="38.4"
          y1="-39"
          x2="212.4"
          y2="290.4"
          gradientUnits="userSpaceOnUse"
        >
          <stop stop-color="#C69B07" />
          <stop offset="0.5" stop-color="#DBCB96" />
          <stop offset="1" stop-color="#C69B07" />
        </linearGradient>
        <clipPath id="clip0_1_71">
          <rect width="240" height="240" rx="120" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}

export function PlatinumBadge({ className }: { className?: string }) {
  return (
    <svg
      width="240"
      height="240"
      viewBox="0 0 240 240"
      fill="none"
      className={className}
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clip-path="url(#clip0_1_41)">
        <circle cx="120" cy="120" r="120" fill="url(#paint0_linear_1_41)" />
        <path
          d="M135.445 32.2362L136.619 27.61L147.309 22.5426C148.018 22.2056 148.635 21.8778 149.159 21.5594C149.692 21.2352 150.129 20.874 150.468 20.4759C150.814 20.0796 151.058 19.604 151.199 19.0488C151.354 18.4397 151.355 17.886 151.202 17.3877C151.057 16.8914 150.787 16.4699 150.39 16.1231C149.996 15.7687 149.502 15.5162 148.908 15.3655C148.315 15.2149 147.76 15.2014 147.245 15.325C146.737 15.4505 146.301 15.7133 145.937 16.1133C145.573 16.5134 145.306 17.0449 145.138 17.708L139.032 16.1586C139.454 14.4932 140.192 13.154 141.245 12.1409C142.298 11.1279 143.589 10.4707 145.118 10.1693C146.647 9.86788 148.329 9.94998 150.164 10.4156C152.061 10.8968 153.626 11.6181 154.859 12.5793C156.102 13.5348 156.963 14.6558 157.441 15.9424C157.926 17.2309 157.982 18.6115 157.608 20.0841C157.378 20.9939 156.959 21.852 156.352 22.6582C155.747 23.4567 154.817 24.2754 153.562 25.1141C152.307 25.9528 150.587 26.895 148.401 27.9407L145.711 29.2277L145.676 29.3665L154.928 31.7141L153.626 36.8491L135.445 32.2362Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M164.545 43.3777C162.624 42.2659 161.217 40.8665 160.323 39.1796C159.43 37.4926 159.081 35.6001 159.276 33.5019C159.472 31.4037 160.24 29.1941 161.582 26.8732C162.927 24.5454 164.443 22.7833 166.13 21.5869C167.823 20.3944 169.61 19.7739 171.491 19.7253C173.378 19.6807 175.284 20.2108 177.209 21.3157C179.134 22.4206 180.551 23.8027 181.46 25.4621C182.374 27.1145 182.742 28.9726 182.567 31.0363C182.391 33.1 181.632 35.2923 180.291 37.6132C178.948 39.9519 177.421 41.7347 175.707 42.9616C173.994 44.1886 172.184 44.8416 170.276 44.9208C168.38 44.9969 166.469 44.4826 164.545 43.3777ZM167.23 38.7004C168.223 39.2707 169.334 39.2206 170.563 38.5501C171.802 37.8767 173.058 36.4239 174.33 34.1916C175.166 32.736 175.704 31.4628 175.945 30.3721C176.186 29.2813 176.178 28.3687 175.921 27.6341C175.668 26.8926 175.21 26.3318 174.548 25.9516C173.555 25.3814 172.455 25.4196 171.249 26.0665C170.043 26.7133 168.807 28.1227 167.542 30.2948C166.684 31.7741 166.124 33.0763 165.864 34.2016C165.607 35.3199 165.603 36.2533 165.852 37.0016C166.108 37.754 166.567 38.3202 167.23 38.7004Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M175.937 49.7939L179.328 46.4351L191.101 47.6046C191.882 47.6814 192.58 47.7185 193.193 47.7158C193.817 47.7131 194.377 47.6286 194.873 47.4622C195.374 47.3014 195.828 47.0195 196.235 46.6165C196.682 46.1742 196.968 45.7003 197.094 45.1947C197.226 44.6947 197.211 44.194 197.051 43.6926C196.896 43.1857 196.603 42.7146 196.171 42.2795C195.74 41.8443 195.272 41.5468 194.767 41.3869C194.267 41.2327 193.758 41.2331 193.24 41.3881C192.721 41.5431 192.219 41.8614 191.733 42.3428L187.3 37.867C188.52 36.6578 189.843 35.8907 191.268 35.5656C192.692 35.2404 194.137 35.3429 195.603 35.873C197.068 36.403 198.467 37.3405 199.8 38.6856C201.177 40.0758 202.146 41.5006 202.707 42.9601C203.279 44.4196 203.439 45.8238 203.185 47.1725C202.937 48.5269 202.273 49.7387 201.193 50.8079C200.526 51.4685 199.725 51.9878 198.79 52.3658C197.86 52.7383 196.641 52.9603 195.133 53.0319C193.626 53.1035 191.666 53.0239 189.254 52.7931L186.285 52.5091L186.184 52.6099L192.901 59.3914L189.137 63.1197L175.937 49.7939Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M193.388 62.3223L197.864 59.765L216.168 60.6294L218.489 64.6905L212.521 68.1002L211.195 65.7797L201.274 65.3474L201.108 65.4422L208.306 78.0396L203.831 80.597L193.388 62.3223ZM195.969 74.535L200.652 71.8593L202.671 70.8707L217.257 62.5356L220.336 67.9227L199.119 80.0464L195.969 74.535Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M219.956 235.123L169.085 107.569C167.267 103.025 164.82 98.7604 161.814 94.8991C154.232 85.1225 143.4 78.3843 131.279 75.9049C119.158 73.4255 106.55 75.3689 95.7385 81.3831C84.9268 87.3973 76.6265 97.0846 72.3408 108.69C68.0551 120.296 68.0675 133.053 72.3757 144.651C72.6698 145.587 73.0366 146.499 73.4727 147.378C74.7245 149.894 76.5197 152.1 78.7285 153.837C80.9373 155.574 83.5045 156.799 86.2445 157.422C88.9844 158.045 91.8287 158.052 94.5715 157.441C97.3144 156.831 99.8873 155.619 102.104 153.892C108.931 148.575 107.793 141.234 106.694 134.134C106.418 132.353 106.131 130.51 105.967 128.69C105.222 120.431 112.012 116.411 112.29 116.25L112.465 116.152L112.622 116.028C114.284 114.736 116.223 113.847 118.287 113.431C120.351 113.015 122.483 113.084 124.515 113.631C126.548 114.178 128.426 115.189 130.002 116.585C131.578 117.981 132.809 119.723 133.598 121.675L134.04 122.94L183.638 247.604C184.187 248.982 184.928 250.274 185.839 251.444L186.139 251.832C187.664 253.802 189.564 255.45 191.731 256.682C193.897 257.913 196.286 258.702 198.759 259.004C200.099 259.171 201.454 259.196 202.799 259.079C206.377 258.76 209.788 257.424 212.631 255.229C213.635 254.598 218.52 251.283 220.219 245.433C221.803 239.952 220.038 235.322 219.956 235.123ZM192.878 193.856C191.889 200.651 188.694 210.862 179.317 222.234L168.515 195.089C179.956 182.108 183.863 170.164 185.081 162.145L192.489 180.718C192.677 181.356 193.97 186.338 192.878 193.856ZM157.996 168.647C169.133 154.995 172.71 142.226 173.687 133.583L179.422 147.961C179.602 148.6 180.905 153.58 179.813 161.099C178.826 167.89 175.634 178.09 166.272 189.452L157.996 168.647ZM164.105 109.557L167.528 118.143C167.717 118.776 169.262 124.297 168.405 132.559C167.641 139.912 164.769 150.881 155.702 162.888L147.732 142.884C156.711 128.964 158.666 115.421 158.698 106.418C158.708 104.008 158.585 101.6 158.329 99.2036C160.686 102.395 162.627 105.875 164.105 109.557ZM100.99 132.294C95.5977 130.567 90.6426 130.655 86.2123 132.568C81.7821 134.482 78.7112 137.915 76.759 140.932C74.5273 134.017 73.9526 126.675 75.0813 119.497C77.3997 117.726 82.9077 114.152 89.3159 114.46C93.7864 114.676 97.9966 116.759 101.847 120.659C100.757 123.355 100.338 126.276 100.626 129.17C100.721 130.228 100.852 131.269 100.99 132.294ZM98.8025 149.661C95.9565 151.873 92.3491 152.866 88.7717 152.422C85.1943 151.978 81.939 150.134 79.72 147.293C79.6547 147.209 79.5956 147.126 79.5344 147.042C80.6344 144.577 83.3804 139.615 88.3708 137.478C92.1937 135.84 96.7313 136.136 101.874 138.351C102.531 143.581 102.254 146.978 98.8087 149.66L98.8025 149.661ZM109.46 111.689C107.646 112.836 106.031 114.27 104.676 115.934C100.092 111.649 95.0037 109.354 89.5135 109.101C84.5951 108.877 80.2093 110.354 76.8677 112.052C79.65 103.521 84.8673 95.9914 91.8766 90.3898C94.8133 89.9742 108.297 89.213 115.812 108.503C113.515 109.155 111.362 110.236 109.466 111.689L109.46 111.689ZM123.311 107.941C122.635 107.857 121.955 107.81 121.274 107.799C119.203 102.095 116.48 97.3634 113.16 93.7214C110.142 90.3924 106.616 87.9612 102.692 86.4946C101.594 86.0831 100.468 85.7497 99.3224 85.4969C107.682 81.0832 117.2 79.3549 126.578 80.5475C126.787 80.5705 126.978 80.6013 127.179 80.6292C129.593 83.5761 131.51 86.8963 132.857 90.4594C135.53 97.6595 135.166 104.613 131.78 111.17C129.263 109.422 126.358 108.314 123.317 107.941L123.311 107.941ZM138.632 119.845L138.588 119.731C137.925 118.071 137.031 116.514 135.931 115.105C135.894 115.057 135.855 115.012 135.817 114.964C140.56 106.669 141.259 97.5242 137.813 88.3963C137.015 86.3071 136.041 84.2892 134.903 82.3642C141.028 84.2951 146.682 87.4865 151.5 91.7334C152.565 95.4452 157.329 115.238 145.246 136.628L139.053 121.063L138.632 119.845ZM181.552 227.876C193.01 214.885 196.919 202.921 198.138 194.907L205.071 212.292C205.215 212.9 205.98 216.678 204.387 222.574C201.839 232.005 195.088 240.425 188.999 246.472C188.859 246.197 188.73 245.914 188.616 245.628L181.552 227.876ZM215.057 243.949C213.81 248.245 209.774 250.693 209.743 250.713L209.589 250.803L209.448 250.912C207.002 252.817 203.979 253.83 200.88 253.781C197.78 253.733 194.79 252.627 192.405 250.647C203.185 240.088 207.796 230.734 209.636 223.732L214.969 237.079C215.666 239.31 215.698 241.696 215.061 243.945L215.057 243.949Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
      </g>
      <defs>
        <linearGradient
          id="paint0_linear_1_41"
          x1="38.4"
          y1="-39"
          x2="212.4"
          y2="290.4"
          gradientUnits="userSpaceOnUse"
        >
          <stop stop-color="#048F8F" />
          <stop offset="0.5" stop-color="#9BE3E2" />
          <stop offset="1" stop-color="#048F8F" />
        </linearGradient>
        <clipPath id="clip0_1_41">
          <rect width="240" height="240" rx="120" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}

export function BronzeBadge({ className }: { className?: string }) {
  return (
    <svg
      width="240"
      height="240"
      viewBox="0 0 240 240"
      fill="none"
      className={className}
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clip-path="url(#clip0_1_61)">
        <circle cx="120" cy="120" r="120" fill="url(#paint0_linear_1_61)" />
        <path
          d="M132.737 32.2427L133.882 27.6094L144.542 22.4766C145.249 22.1352 145.863 21.8036 146.385 21.482C146.917 21.1546 147.351 20.7907 147.688 20.3905C148.032 19.9921 148.273 19.515 148.41 18.959C148.561 18.3489 148.559 17.7953 148.403 17.2979C148.255 16.8025 147.982 16.3826 147.584 16.0383C147.187 15.6863 146.692 15.4368 146.097 15.2898C145.502 15.1428 144.948 15.1327 144.433 15.2595C143.926 15.3881 143.492 15.6536 143.13 16.0558C142.768 16.4581 142.505 16.9912 142.341 17.6553L136.225 16.1434C136.638 14.4755 137.367 13.1317 138.414 12.1123C139.461 11.0928 140.748 10.4277 142.275 10.1169C143.802 9.80613 145.485 9.87791 147.323 10.3322C149.222 10.8018 150.792 11.5135 152.031 12.4671C153.28 13.415 154.147 14.5307 154.633 15.8143C155.126 17.0999 155.19 18.4801 154.826 19.955C154.6 20.8662 154.187 21.7268 153.585 22.5367C152.985 23.3389 152.061 24.1632 150.811 25.0096C149.561 25.856 147.846 26.8087 145.667 27.8678L142.985 29.1714L142.951 29.3104L152.217 31.6011L150.946 36.744L132.737 32.2427Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M161.905 43.2056C159.977 42.1056 158.561 40.7149 157.657 39.0335C156.754 37.352 156.393 35.4616 156.576 33.3623C156.758 31.2629 157.513 29.0487 158.841 26.7196C160.172 24.3836 161.677 22.6122 163.356 21.4055C165.042 20.2027 166.825 19.5712 168.706 19.5111C170.593 19.4549 172.502 19.9733 174.434 21.0664C176.365 22.1595 177.791 23.5329 178.71 25.1866C179.634 26.8334 180.014 28.6892 179.851 30.754C179.688 32.8187 178.942 35.0156 177.615 37.3447C176.287 39.6915 174.77 41.4837 173.064 42.7211C171.359 43.9586 169.553 44.6227 167.646 44.7135C165.75 44.8013 163.836 44.2987 161.905 43.2056ZM164.561 38.5119C165.558 39.0761 166.668 39.0192 167.893 38.3412C169.128 37.6602 170.375 36.1997 171.634 33.9597C172.461 32.499 172.991 31.2225 173.225 30.1303C173.459 29.0381 173.446 28.1255 173.184 27.3926C172.927 26.6527 172.466 26.0946 171.801 25.7185C170.804 25.1544 169.705 25.1994 168.503 25.8536C167.301 26.5078 166.074 27.9248 164.822 30.1046C163.973 31.5891 163.421 32.8947 163.167 34.0216C162.917 35.1415 162.919 36.0748 163.173 36.8216C163.434 37.5724 163.896 38.1358 164.561 38.5119Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M173.336 49.5518L176.707 46.1723L188.486 47.2696C189.268 47.3416 189.966 47.3744 190.579 47.3679C191.203 47.3614 191.763 47.2735 192.257 47.104C192.758 46.9402 193.21 46.6556 193.615 46.25C194.058 45.805 194.342 45.3294 194.465 44.823C194.593 44.3222 194.576 43.8216 194.412 43.3212C194.254 42.8152 193.958 42.346 193.524 41.9135C193.09 41.481 192.62 41.1863 192.114 41.0296C191.613 40.8784 191.104 40.8819 190.587 41.0401C190.07 41.1983 189.569 41.5196 189.086 42.004L184.625 37.5555C185.839 36.3388 187.157 35.5636 188.579 35.2298C190.002 34.8959 191.447 34.9895 192.916 35.5106C194.385 36.0316 195.79 36.9606 197.13 38.2974C198.516 39.6791 199.494 41.098 200.064 42.554C200.645 44.01 200.813 45.4132 200.567 46.7634C200.327 48.1193 199.671 49.3352 198.598 50.411C197.935 51.0756 197.137 51.5998 196.204 51.9836C195.277 52.3618 194.059 52.5913 192.552 52.6721C191.045 52.753 189.084 52.6854 186.671 52.4694L183.701 52.2035L183.6 52.3049L190.359 59.0452L186.618 62.7964L173.336 49.5518Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M190.864 61.973L195.324 59.3883L213.633 60.1405L215.978 64.1872L210.032 67.6335L208.692 65.3211L198.768 64.9497L198.603 65.0455L205.878 77.5986L201.418 80.1833L190.864 61.973ZM193.52 74.1696L198.186 71.4653L200.199 70.4643L214.734 62.04L217.845 67.4081L196.703 79.6616L193.52 74.1696Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M217.556 235.123L166.685 107.569C164.867 103.025 162.42 98.7604 159.414 94.8991C151.832 85.1225 141 78.3843 128.879 75.9049C116.758 73.4255 104.15 75.3689 93.3385 81.3831C82.5268 87.3973 74.2265 97.0846 69.9408 108.69C65.6551 120.296 65.6675 133.053 69.9757 144.651C70.2698 145.587 70.6366 146.499 71.0727 147.378C72.3245 149.894 74.1197 152.1 76.3285 153.837C78.5373 155.574 81.1045 156.799 83.8445 157.422C86.5844 158.045 89.4287 158.052 92.1715 157.441C94.9144 156.831 97.4873 155.619 99.7043 153.892C106.531 148.575 105.393 141.234 104.294 134.134C104.018 132.353 103.731 130.51 103.567 128.69C102.822 120.431 109.612 116.411 109.89 116.25L110.065 116.152L110.222 116.028C111.884 114.736 113.823 113.847 115.887 113.431C117.951 113.015 120.083 113.084 122.115 113.631C124.148 114.178 126.026 115.189 127.602 116.585C129.178 117.981 130.409 119.723 131.198 121.675L131.64 122.94L181.238 247.604C181.787 248.982 182.528 250.274 183.439 251.444L183.739 251.832C185.264 253.802 187.164 255.45 189.331 256.682C191.497 257.913 193.886 258.702 196.359 259.004C197.699 259.171 199.054 259.196 200.399 259.079C203.977 258.76 207.388 257.424 210.231 255.229C211.235 254.598 216.12 251.283 217.819 245.433C219.403 239.952 217.638 235.322 217.556 235.123ZM190.478 193.856C189.489 200.651 186.294 210.862 176.917 222.234L166.115 195.089C177.556 182.108 181.463 170.164 182.681 162.145L190.089 180.718C190.277 181.356 191.57 186.338 190.478 193.856ZM155.596 168.647C166.733 154.995 170.31 142.226 171.287 133.583L177.022 147.961C177.202 148.6 178.505 153.58 177.413 161.099C176.426 167.89 173.234 178.09 163.872 189.452L155.596 168.647ZM161.705 109.557L165.128 118.143C165.317 118.776 166.862 124.297 166.005 132.559C165.241 139.912 162.369 150.881 153.302 162.888L145.332 142.884C154.311 128.964 156.266 115.421 156.298 106.418C156.308 104.008 156.185 101.6 155.929 99.2036C158.286 102.395 160.227 105.875 161.705 109.557ZM98.5899 132.294C93.1977 130.567 88.2426 130.655 83.8123 132.568C79.3821 134.482 76.3112 137.915 74.359 140.932C72.1273 134.017 71.5526 126.675 72.6813 119.497C74.9997 117.726 80.5077 114.152 86.9159 114.46C91.3864 114.676 95.5966 116.759 99.4468 120.659C98.3567 123.355 97.9379 126.276 98.2262 129.17C98.3213 130.228 98.4521 131.269 98.5899 132.294ZM96.4025 149.661C93.5565 151.873 89.9491 152.866 86.3717 152.422C82.7943 151.978 79.539 150.134 77.32 147.293C77.2547 147.209 77.1956 147.126 77.1344 147.042C78.2344 144.577 80.9804 139.615 85.9708 137.478C89.7937 135.84 94.3313 136.136 99.4744 138.351C100.131 143.581 99.8541 146.978 96.4087 149.66L96.4025 149.661ZM107.06 111.689C105.246 112.836 103.631 114.27 102.276 115.934C97.6919 111.649 92.6037 109.354 87.1135 109.101C82.1951 108.877 77.8092 110.354 74.4677 112.052C77.25 103.521 82.4673 95.9914 89.4766 90.3898C92.4133 89.9742 105.897 89.213 113.412 108.503C111.115 109.155 108.961 110.236 107.066 111.689L107.06 111.689ZM120.911 107.941C120.235 107.857 119.555 107.81 118.874 107.799C116.803 102.095 114.08 97.3634 110.76 93.7214C107.742 90.3924 104.216 87.9612 100.292 86.4946C99.1936 86.0831 98.0677 85.7497 96.9224 85.4969C105.282 81.0832 114.8 79.3549 124.178 80.5475C124.387 80.5705 124.578 80.6013 124.779 80.6292C127.193 83.5761 129.11 86.8963 130.457 90.4594C133.13 97.6595 132.766 104.613 129.38 111.17C126.863 109.422 123.958 108.314 120.917 107.941L120.911 107.941ZM136.232 119.845L136.188 119.731C135.525 118.071 134.631 116.514 133.531 115.105C133.494 115.057 133.455 115.012 133.417 114.964C138.16 106.669 138.859 97.5242 135.413 88.3963C134.615 86.3071 133.641 84.2892 132.503 82.3642C138.628 84.2951 144.282 87.4865 149.1 91.7334C150.165 95.4452 154.929 115.238 142.846 136.628L136.653 121.063L136.232 119.845ZM179.152 227.876C190.61 214.885 194.519 202.921 195.738 194.907L202.671 212.292C202.815 212.9 203.58 216.678 201.987 222.574C199.439 232.005 192.688 240.425 186.599 246.472C186.459 246.197 186.33 245.914 186.216 245.628L179.152 227.876ZM212.657 243.949C211.41 248.245 207.374 250.693 207.343 250.713L207.189 250.803L207.048 250.912C204.602 252.817 201.579 253.83 198.48 253.781C195.38 253.733 192.39 252.627 190.005 250.647C200.785 240.088 205.396 230.734 207.236 223.732L212.569 237.079C213.266 239.31 213.298 241.696 212.661 243.945L212.657 243.949Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
      </g>
      <defs>
        <linearGradient
          id="paint0_linear_1_61"
          x1="38.4"
          y1="-39"
          x2="212.4"
          y2="290.4"
          gradientUnits="userSpaceOnUse"
        >
          <stop stop-color="#8A5A44" />
          <stop offset="0.5" stop-color="#DEAB90" />
          <stop offset="1" stop-color="#8A5A44" />
        </linearGradient>
        <clipPath id="clip0_1_61">
          <rect width="240" height="240" rx="120" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}

export function SilverBadge({ className }: { className?: string }) {
  return (
    <svg
      width="240"
      height="240"
      viewBox="0 0 240 240"
      fill="none"
      className={className}
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clip-path="url(#clip0_10_145)">
        <circle cx="120" cy="120" r="120" fill="url(#paint0_linear_10_145)" />
        <path
          d="M132.737 32.2427L133.882 27.6095L144.542 22.4766C145.249 22.1352 145.863 21.8037 146.385 21.482C146.917 21.1546 147.351 20.7907 147.688 20.3905C148.032 19.9922 148.273 19.515 148.41 18.959C148.561 18.349 148.559 17.7953 148.403 17.2979C148.255 16.8025 147.982 16.3826 147.584 16.0383C147.187 15.6863 146.692 15.4368 146.097 15.2898C145.502 15.1428 144.948 15.1327 144.433 15.2595C143.926 15.3882 143.492 15.6536 143.13 16.0558C142.768 16.4581 142.505 16.9912 142.341 17.6553L136.225 16.1435C136.638 14.4755 137.367 13.1318 138.414 12.1123C139.461 11.0928 140.748 10.4277 142.275 10.1169C143.802 9.80614 145.485 9.87792 147.323 10.3323C149.222 10.8019 150.792 11.5135 152.031 12.4672C153.28 13.415 154.147 14.5307 154.633 15.8143C155.126 17.0999 155.19 18.4801 154.826 19.955C154.6 20.8662 154.187 21.7268 153.585 22.5367C152.985 23.339 152.061 24.1633 150.811 25.0096C149.561 25.856 147.846 26.8088 145.667 27.8679L142.985 29.1714L142.951 29.3104L152.217 31.6011L150.946 36.744L132.737 32.2427Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M161.905 43.2056C159.977 42.1056 158.561 40.7149 157.657 39.0335C156.754 37.352 156.393 35.4616 156.576 33.3623C156.758 31.2629 157.513 29.0487 158.841 26.7196C160.172 24.3836 161.677 22.6122 163.356 21.4055C165.042 20.2027 166.825 19.5712 168.706 19.5111C170.593 19.4549 172.502 19.9733 174.434 21.0664C176.365 22.1595 177.791 23.5329 178.71 25.1866C179.634 26.8335 180.014 28.6892 179.851 30.754C179.688 32.8187 178.943 35.0156 177.615 37.3447C176.287 39.6916 174.77 41.4837 173.065 42.7211C171.359 43.9586 169.553 44.6227 167.646 44.7135C165.75 44.8013 163.836 44.2987 161.905 43.2056ZM164.561 38.5119C165.558 39.0761 166.668 39.0192 167.893 38.3412C169.128 37.6602 170.375 36.1997 171.634 33.9597C172.461 32.499 172.991 31.2226 173.225 30.1303C173.46 29.0381 173.446 28.1255 173.184 27.3926C172.927 26.6527 172.466 26.0947 171.801 25.7186C170.804 25.1544 169.705 25.1994 168.503 25.8536C167.301 26.5078 166.074 27.9248 164.822 30.1046C163.973 31.5891 163.421 32.8948 163.167 34.0216C162.917 35.1415 162.919 36.0748 163.173 36.8217C163.434 37.5724 163.896 38.1358 164.561 38.5119Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M173.336 49.5519L176.707 46.1723L188.486 47.2696C189.268 47.3417 189.966 47.3744 190.579 47.368C191.203 47.3615 191.763 47.2735 192.257 47.1041C192.758 46.9402 193.21 46.6556 193.615 46.25C194.058 45.8051 194.342 45.3294 194.465 44.823C194.593 44.3222 194.576 43.8216 194.412 43.3213C194.254 42.8152 193.958 42.346 193.524 41.9135C193.09 41.481 192.62 41.1864 192.114 41.0296C191.613 40.8784 191.104 40.8819 190.587 41.0401C190.07 41.1983 189.569 41.5196 189.086 42.004L184.625 37.5555C185.839 36.3389 187.157 35.5636 188.579 35.2298C190.002 34.8959 191.447 34.9895 192.916 35.5106C194.385 36.0317 195.79 36.9606 197.13 38.2974C198.516 39.6792 199.494 41.098 200.064 42.554C200.645 44.01 200.813 45.4132 200.567 46.7634C200.327 48.1193 199.671 49.3352 198.598 50.411C197.935 51.0756 197.137 51.5999 196.204 51.9836C195.277 52.3618 194.059 52.5913 192.552 52.6721C191.045 52.753 189.084 52.6854 186.671 52.4694L183.701 52.2035L183.6 52.3049L190.359 59.0452L186.618 62.7964L173.336 49.5519Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M190.864 61.9731L195.324 59.3883L213.633 60.1405L215.978 64.1873L210.032 67.6336L208.692 65.3211L198.768 64.9498L198.603 65.0455L205.878 77.5986L201.418 80.1833L190.864 61.9731ZM193.52 74.1697L198.186 71.4653L200.199 70.4643L214.734 62.04L217.845 67.4081L196.703 79.6616L193.52 74.1697Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
        <path
          d="M217.556 235.123L166.685 107.569C164.867 103.025 162.42 98.7604 159.414 94.8991C151.832 85.1225 141 78.3843 128.879 75.9049C116.758 73.4255 104.15 75.3689 93.3385 81.3831C82.5269 87.3973 74.2265 97.0845 69.9408 108.69C65.6551 120.296 65.6675 133.053 69.9757 144.651C70.2698 145.587 70.6366 146.499 71.0727 147.378C72.3245 149.894 74.1197 152.1 76.3285 153.837C78.5373 155.574 81.1045 156.799 83.8445 157.422C86.5845 158.045 89.4287 158.052 92.1716 157.441C94.9144 156.831 97.4874 155.619 99.7043 153.892C106.531 148.575 105.393 141.234 104.294 134.134C104.018 132.353 103.731 130.51 103.567 128.69C102.822 120.431 109.612 116.411 109.89 116.25L110.065 116.152L110.222 116.028C111.884 114.736 113.823 113.847 115.887 113.431C117.951 113.015 120.083 113.084 122.115 113.631C124.148 114.178 126.026 115.189 127.602 116.585C129.178 117.981 130.409 119.723 131.198 121.675L131.64 122.94L181.238 247.604C181.787 248.982 182.528 250.274 183.44 251.444L183.739 251.832C185.264 253.802 187.164 255.45 189.331 256.682C191.497 257.913 193.886 258.702 196.359 259.004C197.699 259.171 199.054 259.196 200.399 259.079C203.977 258.76 207.388 257.424 210.231 255.229C211.235 254.598 216.12 251.283 217.819 245.433C219.403 239.952 217.638 235.322 217.556 235.123ZM190.478 193.856C189.489 200.651 186.294 210.862 176.917 222.234L166.115 195.089C177.556 182.108 181.463 170.164 182.681 162.145L190.089 180.718C190.277 181.356 191.57 186.338 190.478 193.856ZM155.596 168.647C166.733 154.995 170.31 142.226 171.287 133.583L177.022 147.961C177.202 148.6 178.506 153.58 177.413 161.099C176.426 167.89 173.234 178.09 163.872 189.452L155.596 168.647ZM161.705 109.557L165.128 118.143C165.317 118.776 166.862 124.297 166.005 132.559C165.241 139.912 162.369 150.881 153.302 162.888L145.332 142.884C154.311 128.964 156.266 115.421 156.298 106.418C156.308 104.008 156.185 101.6 155.929 99.2036C158.286 102.395 160.227 105.875 161.705 109.557ZM98.5899 132.294C93.1978 130.567 88.2426 130.655 83.8123 132.568C79.3821 134.482 76.3112 137.915 74.359 140.932C72.1274 134.017 71.5527 126.675 72.6813 119.497C74.9998 117.726 80.5077 114.152 86.916 114.46C91.3864 114.676 95.5966 116.759 99.4469 120.659C98.3568 123.355 97.9379 126.276 98.2263 129.17C98.3213 130.228 98.4522 131.269 98.5899 132.294ZM96.4025 149.661C93.5565 151.873 89.9491 152.866 86.3717 152.422C82.7943 151.978 79.539 150.134 77.32 147.293C77.2547 147.209 77.1956 147.126 77.1344 147.042C78.2345 144.577 80.9804 139.615 85.9708 137.478C89.7937 135.84 94.3314 136.136 99.4745 138.351C100.131 143.581 99.8542 146.978 96.4087 149.66L96.4025 149.661ZM107.06 111.689C105.246 112.836 103.631 114.27 102.276 115.934C97.6919 111.649 92.6038 109.354 87.1135 109.101C82.1951 108.877 77.8093 110.354 74.4677 112.052C77.25 103.521 82.4673 95.9914 89.4766 90.3898C92.4133 89.9742 105.898 89.213 113.412 108.503C111.115 109.155 108.962 110.236 107.066 111.689L107.06 111.689ZM120.911 107.941C120.235 107.857 119.555 107.81 118.874 107.799C116.803 102.095 114.08 97.3634 110.76 93.7214C107.742 90.3924 104.216 87.9612 100.292 86.4946C99.1936 86.0831 98.0677 85.7497 96.9225 85.4968C105.282 81.0832 114.8 79.3549 124.178 80.5475C124.387 80.5705 124.578 80.6013 124.779 80.6292C127.193 83.5761 129.11 86.8962 130.457 90.4594C133.13 97.6595 132.766 104.613 129.38 111.17C126.863 109.422 123.958 108.314 120.917 107.941L120.911 107.941ZM136.232 119.845L136.188 119.731C135.525 118.071 134.631 116.514 133.531 115.105C133.494 115.057 133.455 115.012 133.417 114.964C138.16 106.669 138.859 97.5242 135.413 88.3963C134.615 86.3071 133.641 84.2892 132.503 82.3642C138.629 84.2951 144.282 87.4865 149.1 91.7334C150.165 95.4452 154.929 115.238 142.846 136.628L136.653 121.063L136.232 119.845ZM179.152 227.876C190.61 214.885 194.519 202.921 195.738 194.907L202.671 212.292C202.815 212.9 203.58 216.678 201.987 222.574C199.439 232.005 192.688 240.425 186.599 246.472C186.459 246.197 186.33 245.914 186.216 245.628L179.152 227.876ZM212.657 243.949C211.41 248.245 207.374 250.693 207.343 250.713L207.189 250.803L207.048 250.912C204.602 252.817 201.579 253.83 198.48 253.781C195.38 253.733 192.39 252.627 190.005 250.647C200.785 240.088 205.396 230.734 207.236 223.732L212.569 237.079C213.266 239.31 213.298 241.696 212.661 243.945L212.657 243.949Z"
          fill="white"
          style={{ mixBlendMode: 'soft-light' }}
        />
      </g>
      <defs>
        <linearGradient
          id="paint0_linear_10_145"
          x1="38.4"
          y1="-39"
          x2="212.4"
          y2="290.4"
          gradientUnits="userSpaceOnUse"
        >
          <stop stop-color="#3E3E3E" />
          <stop offset="0.5" stop-color="#C1C0C0" />
          <stop offset="1" stop-color="#3E3E3E" />
        </linearGradient>
        <clipPath id="clip0_10_145">
          <rect width="240" height="240" rx="120" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}
