package com.twjitm.thread;

import java.util.concurrent.*;

/**
 * @author twjitm - [Created on 2018-08-21 20:42]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 */
public class Test {
    private final ExecutorService executorService;

    public Test(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void test() {
        CompletionService completionService = new ExecutorCompletionService(executorService);
        try {
            Object obj = completionService.submit(new Callable() {
                @Override
                public Object call() throws Exception {
                    Thread.sleep(4000l);

                    return "hahaha";
                }
            }).get(2000l, TimeUnit.MILLISECONDS);
            System.out.println(obj);

        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        } catch (TimeoutException e) {
            e.printStackTrace();
            System.out.println("超时了--线程任务");
        }

    }

    public static void main(String[] args) {
        ExecutorService executorService = new ThreadPoolExecutor(4, 10, 0, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<>(10));
        Test t = new Test(executorService);
        t.test();
    }
}
