package com.twjitm.rpc;

import com.twjitm.TestSpring;
import com.twjitm.core.common.enums.NettyGameTypeEnum;
import com.twjitm.core.common.service.rpc.client.NettyRpcContextHolder;
import com.twjitm.core.common.service.rpc.client.NettyRpcContextHolderObject;
import com.twjitm.core.common.service.rpc.service.NettyRpcProxyService;
import com.twjitm.core.service.rpc.service.IHelloWorld;
import com.twjitm.core.spring.SpringServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author twjitm - [Created on 2018-08-20 15:16]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 *
 * 同步阻塞调用
 */
public class HelloWorldServiceTest {
    Logger logger=LoggerFactory.getLogger(HelloWorldServiceTest.class);
    private NettyRpcProxyService nettyRpcProxyService;

    public static void main(String[] args) {
        TestSpring.initSpring();
        HelloWorldServiceTest helloServiceTest = new HelloWorldServiceTest();
        helloServiceTest.init();
        helloServiceTest.helloTest1();
        helloServiceTest.setTear();
    }



    private void init() {
        nettyRpcProxyService=SpringServiceManager.getSpringLoadService().getNettyRpcProxyService();

    }

    private void helloTest1() {
        IHelloWorld helloWorld = nettyRpcProxyService.createProxy(IHelloWorld.class);
        int serverId=18001;
        NettyRpcContextHolderObject rpcContextHolderObject =
                new NettyRpcContextHolderObject(NettyGameTypeEnum.WORLD, serverId);
        NettyRpcContextHolder.setContextHolder(rpcContextHolderObject);
        String result = helloWorld.getHelloWorld(5);
        logger.info(result);
    }
    public void setTear(){
        if (nettyRpcProxyService != null) {
            try {
                nettyRpcProxyService.shutdown();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
