package com.twjitm.rpc;

import com.twjitm.TestSpring;
import com.twjitm.core.common.enums.NettyGameTypeEnum;
import com.twjitm.core.common.service.rpc.client.NettyAsyncRPCCallback;
import com.twjitm.core.common.service.rpc.client.NettyRpcFuture;
import com.twjitm.core.common.service.rpc.client.NettyRpcContextHolder;
import com.twjitm.core.common.service.rpc.client.NettyRpcContextHolderObject;
import com.twjitm.core.common.service.rpc.client.proxy.INettyAsyncRpcProxy;
import com.twjitm.core.common.service.rpc.service.NettyRpcProxyService;
import com.twjitm.core.service.rpc.service.IHelloWorld;
import com.twjitm.core.spring.SpringServiceManager;

/**
 * @author twjitm - [Created on 2018-08-20 17:26]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 * 异步回调
 */
public class HelloWorldCallbackTest {
    private static NettyRpcProxyService nettyRpcProxyService;

    public static void main(String[] args) {
        init();
    }

    private static void init() {
        TestSpring.initSpring();
        nettyRpcProxyService = SpringServiceManager.getSpringLoadService().getNettyRpcProxyService();
        INettyAsyncRpcProxy async =  nettyRpcProxyService.createAsync(IHelloWorld.class);
        NettyRpcContextHolderObject rpcContextHolderObject = new NettyRpcContextHolderObject(NettyGameTypeEnum.WORLD, 9001);
        NettyRpcContextHolder.setContextHolder(rpcContextHolderObject);
        NettyRpcFuture rpcFuture = async.call("getHelloWorld", 5);

        rpcFuture.addCallback(new NettyAsyncRPCCallback() {
            @Override
            public void success(Object result) {
                System.out.println(result);
            }

            @Override
            public void fail(Exception e) {
                System.out.println(e);
            }
        });
    }

}
