package com.twjitm.core.utils.xml;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

import java.io.InputStream;
import java.net.URL;

/**
 * @author twjitm - [Created on 2018-08-20 14:17]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 */
public class JdomUtils {

    public static final String ARRAY_SEPARATOR = ";";

    public static Element getRootElement(String xmlPath) {
        SAXBuilder builder = new SAXBuilder();
//		builder.setValidation(false);
        Document doc = null;
        try {
            doc = builder.build(xmlPath);
            return doc.getRootElement();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Element getRootElement(URL xmlPath) {
        SAXBuilder builder = new SAXBuilder();
//		builder.setValidation(false);
        Document doc = null;
        try {
            doc = builder.build(xmlPath);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return doc.getRootElement();
    }

    public static int getIntAttriValue(Element e, String attrName) {
        String attributeValue = e.getAttributeValue(attrName);
        if (attributeValue == null) {
            return -1;
        }
        return Integer.valueOf(attributeValue);
    }

    public static short getShortAttriValue(Element e, String attrName) {
        String attributeValue = e.getAttributeValue(attrName);
        if (attributeValue == null) {
            return -1;
        }
        return Short.valueOf(attributeValue);
    }

    public static byte getByteAttriValue(Element e, String attrName) {
        String attributeValue = e.getAttributeValue(attrName);
        if (attributeValue == null) {
            return -1;
        }
        return Byte.valueOf(attributeValue);
    }

    public static int[] getIntArrayAttriValue(Element e, String attrName) {
        String[] temp = e.getAttributeValue(attrName).split(ARRAY_SEPARATOR);
        int[] result = new int[temp.length];
        for (int i = 0; i < temp.length; i++) {
            result[i] = Integer.valueOf(temp[i]);
        }
        return result;
    }

    public static short[] getShortArrayAttriValue(Element e, String attrName) {
        String[] temp = e.getAttributeValue(attrName).split(ARRAY_SEPARATOR);
        short[] result = new short[temp.length];
        for (int i = 0; i < temp.length; i++) {
            result[i] = Short.valueOf(temp[i]);
        }
        return result;
    }

    public static Element getRootElementByStream(String xmlPath) {
        try {

            InputStream in= Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(in);
            return doc.getRootElement();

        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

}
