package com.twjitm.core.initalizer;

import com.twjitm.core.common.handler.rpc.NettyRpcClientServerHandler;
import com.twjitm.core.common.netstack.coder.decode.rpc.NettyNetMessageRPCDecoder;
import com.twjitm.core.common.netstack.coder.encode.rpc.NettyNetMessageRPCEncoder;
import com.twjitm.core.common.netstack.entity.rpc.NettyRpcRequestMessage;
import com.twjitm.core.common.netstack.entity.rpc.NettyRpcResponseMessage;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;

/**
 * @author twjitm - [Created on 2018-08-20 11:27]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 * rpc 客戶端登陸
 */
public class NettyRpcClientMessageServerInitializer extends ChannelInitializer<SocketChannel> {
    @Override
    protected void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline channelPipeline = socketChannel.pipeline();
        int maxLength = Integer.MAX_VALUE;
        channelPipeline.addLast(new LengthFieldBasedFrameDecoder(maxLength, 0, 4, 0, 0));
        channelPipeline.addLast(new NettyNetMessageRPCEncoder(NettyRpcRequestMessage.class));
        channelPipeline.addLast(new NettyNetMessageRPCDecoder(NettyRpcResponseMessage.class));
        channelPipeline.addLast("logger", new LoggingHandler(LogLevel.DEBUG));
        channelPipeline.addLast(new NettyRpcClientServerHandler());
    }
}
