package com.twjitm.core.common.zookeeper;

import com.twjitm.core.common.enums.NettyGameTypeEnum;

/**
 * @author twjitm - [Created on 2018-08-22 10:42]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 * zookeeper 节点枚举
 */
public enum NettyZookeeperNodeNettyGameTypeEnum {
    WORLD(NettyGameTypeEnum.WORLD, "/registry_world_address"),
    GAME(NettyGameTypeEnum.GAME, "/registry_game_address"),
    DB(NettyGameTypeEnum.DB, "/registry_db_address"),;

    private NettyGameTypeEnum nettyGameTypeEnum;
    private String rootPath;


    NettyZookeeperNodeNettyGameTypeEnum(NettyGameTypeEnum nettyGameTypeEnum, String rootPath) {
        this.nettyGameTypeEnum = nettyGameTypeEnum;
        this.rootPath = rootPath;
    }

    public NettyGameTypeEnum getNettyGameTypeEnum() {
        return nettyGameTypeEnum;
    }

    public void setNettyGameTypeEnum(NettyGameTypeEnum nettyGameTypeEnum) {
        this.nettyGameTypeEnum = nettyGameTypeEnum;
    }

    public String getRootPath() {
        return rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }
}
